/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.reconciliation.entity.SaleRecContractAcceptance;
import com.els.modules.reconciliation.mapper.SaleRecContractAcceptanceMapper;
import com.els.modules.reconciliation.service.SaleRecContractAcceptanceService;
import com.els.modules.reconciliation.vo.SalePerformanceReconciliationVO;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleRecContractAcceptanceServiceImpl
extends BaseServiceImpl<SaleRecContractAcceptanceMapper, SaleRecContractAcceptance>
implements SaleRecContractAcceptanceService {
    @Override
    public void add(SaleRecContractAcceptance saleRecContractAcceptance) {
        ((SaleRecContractAcceptanceMapper)this.baseMapper).insert((Object)saleRecContractAcceptance);
    }

    @Override
    public void edit(SaleRecContractAcceptance saleRecContractAcceptance) {
        int count = ((SaleRecContractAcceptanceMapper)this.baseMapper).updateById((Object)saleRecContractAcceptance);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((SaleRecContractAcceptanceMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleRecContractAcceptanceMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<SaleRecContractAcceptance> selectByMainId(String id) {
        return ((SaleRecContractAcceptanceMapper)this.baseMapper).selectByMainId(id);
    }

    @Override
    public void deleteByMainId(String id) {
        ((SaleRecContractAcceptanceMapper)this.baseMapper).deleteByMainId(id);
    }

    @Override
    public void checkAcceptance(SalePerformanceReconciliationVO saleReconciliationVO) {
        List<SaleRecContractAcceptance> recContractAcceptanceList = saleReconciliationVO.getRecContractAcceptanceList();
        if (CollectionUtil.isEmpty(recContractAcceptanceList)) {
            return;
        }
        Set<String> acceptanceNumbers = recContractAcceptanceList.stream().map(SaleRecContractAcceptance::getAcceptanceNumbers).collect(Collectors.toSet());
        List<SaleRecContractAcceptance> items = ((SaleRecContractAcceptanceMapper)this.baseMapper).checkHasReconcilationed(acceptanceNumbers);
        List<SaleRecContractAcceptance> resultList = this.getIntersection(recContractAcceptanceList, items);
        if (CollectionUtil.isEmpty(resultList)) {
            return;
        }
        String reconciliationNumber = saleReconciliationVO.getReconciliationNumber();
        if (CollectionUtil.isEmpty(resultList = resultList.stream().filter(item -> !item.getReconciliationNumber().contains(reconciliationNumber)).collect(Collectors.toList()))) {
            return;
        }
        List<SaleRecContractAcceptance> sourceList = this.getIntersection(resultList, recContractAcceptanceList);
        Optional optional = sourceList.stream().findFirst();
        if (optional.isPresent()) {
            SaleRecContractAcceptance saleRecContractAcceptance = (SaleRecContractAcceptance)((Object)optional.get());
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_neOltWTyWWWWWIhxIeWVQG_c051c425", (String)"\u5408\u540c\u9a8c\u6536\u5355 \u5e8f\u53f7${0} \u5df2\u53d1\u5e03\u5bf9\u8d26\uff0c\u8bf7\u5220\u9664", (String[])new String[]{saleRecContractAcceptance.getItemNumber()}));
        }
    }

    private List<SaleRecContractAcceptance> getIntersection(List<SaleRecContractAcceptance> targetList, List<SaleRecContractAcceptance> sourceList) {
        return sourceList.stream().filter(item -> targetList.stream().map(SaleRecContractAcceptance::getAcceptanceNumbers).collect(Collectors.toList()).contains(item.getAcceptanceNumbers())).collect(Collectors.toList());
    }
}

