/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.budget.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.budget.entity.BudgetManage;
import com.els.modules.budget.service.BudgetManageService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9884\u7b97\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/budget/budgetManage"})
public class BudgetManageController
extends BaseController<BudgetManage, BudgetManageService> {
    @Autowired
    private BudgetManageService budgetManageService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String LOCK_KEY = "srm_budgetManage_";
    private static final Long LOCK_EXPIRE_TIME = 30000L;

    private String getDictMap(String dictCode, String value) {
        if (StringUtils.isBlank((CharSequence)dictCode)) {
            return null;
        }
        List dictDTOS = this.invokeBaseRpcService.queryDictItemsByCode(dictCode, TenantContext.getTenant());
        if (CollectionUtils.isEmpty((Collection)dictDTOS)) {
            return null;
        }
        Map<String, String> dictMap = dictDTOS.stream().collect(Collectors.toMap(DictDTO::getValue, infoDto -> infoDto.getText()));
        return dictMap.get(value);
    }

    @AutoLog(value="\u9884\u7b97\u7ba1\u7406-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"budgetManage#budgetManage:list"})
    @PermissionDataView(businessType="budgetManage")
    public Result<?> queryPageList(BudgetManage budgetManage, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)budgetManage), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.budgetManageService.page((IPage)page, (Wrapper)queryWrapper);
        pageList.getRecords().forEach(item -> item.setPeriodRange_dictText(this.getDictMap(item.getBudgetPeriod(), item.getPeriodRange())));
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u9884\u7b97\u7ba1\u7406-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"budgetManage#budgetManage:add"})
    @PermissionDataOpt(businessType="budgetManage", beanClass=BudgetManageService.class)
    @FormCommit
    public Result<?> add(@RequestBody BudgetManage budgetManage) {
        String budgetNumber = this.invokeBaseRpcService.getNextCode("srmBudgetNumber", (Object)budgetManage);
        budgetManage.setBudgetNumber(budgetNumber);
        budgetManage.setStatus("0");
        budgetManage.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        budgetManage.setActualBudget(budgetManage.getBudgetAmount());
        budgetManage.setAvailableAmount(budgetManage.getBudgetAmount());
        budgetManage.setActualUsedAmount(BigDecimal.ZERO);
        budgetManage.setOccupiedAmount(BigDecimal.ZERO);
        this.budgetManageService.saveBudgetManage(budgetManage);
        return Result.ok((Object)((Object)budgetManage));
    }

    @SrmValidated
    @AutoLog(value="\u9884\u7b97\u7ba1\u7406-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"budgetManage#budgetManage:edit"})
    @PermissionDataOpt(businessType="budgetManage", beanClass=BudgetManageService.class)
    public Result<?> edit(@RequestBody BudgetManage budgetManage) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, budgetManage.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtFiKRcsSTVBtk_2ef68e36", (String)"\u5f53\u524d\u5355\u636e\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            budgetManage.setActualBudget(budgetManage.getBudgetAmount());
            budgetManage.setAvailableAmount(budgetManage.getBudgetAmount());
            this.budgetManageService.updateBudgetManage(budgetManage);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, budgetManage.getId());
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9884\u7b97\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"budgetManage#budgetManage:delete"})
    @PermissionDataOpt(businessType="budgetManage", beanClass=BudgetManageService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.budgetManageService.delBudgetManage(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u9884\u7b97\u7ba1\u7406-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"budgetManage#budgetManage:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        BudgetManage budgetManage = (BudgetManage)((Object)this.budgetManageService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        budgetManage.setPeriodRange_dictText(this.getDictMap(budgetManage.getBudgetPeriod(), budgetManage.getPeriodRange()));
        return Result.ok((Object)((Object)budgetManage));
    }

    @AutoLog(value="\u9884\u7b97\u7ba1\u7406-\u4f5c\u5e9f")
    @ApiOperation(value="\u4f5c\u5e9f", notes="\u4f5c\u5e9f")
    @GetMapping(value={"/invalidBudgetManage"})
    @RequiresPermissions(value={"budgetManage#budgetManage:invalidBudgetManage"})
    @PermissionDataOpt(businessType="budgetManage", beanClass=BudgetManageService.class)
    public Result<?> invalidBudgetManage(@RequestParam(name="id") String id) {
        this.budgetManageService.invalidBudgetManage(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9884\u7b97\u7ba1\u7406-\u6279\u91cf\u4f5c\u5e9f")
    @ApiOperation(value="\u6279\u91cf\u4f5c\u5e9f", notes="\u6279\u91cf\u4f5c\u5e9f")
    @GetMapping(value={"/invalidBatchBudgetManage"})
    @RequiresPermissions(value={"budgetManage#budgetManage:invalidBatchBudgetManage"})
    @PermissionDataOpt(businessType="budgetManage", beanClass=BudgetManageService.class)
    public Result<?> invalidBatchBudgetManage(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.budgetManageService.invalidBatchBudgetManage(idList);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9884\u7b97\u7ba1\u7406-\u9884\u7b97\u6821\u9a8c")
    @ApiOperation(value="\u9884\u7b97\u6821\u9a8c", notes="\u9884\u7b97\u6821\u9a8c")
    @GetMapping(value={"/budgetCheck"})
    @RequiresPermissions(value={"budgetManage#budgetManage:budgetCheck"})
    public Result<?> budgetCheck(@RequestParam String purchaseRequestHeadId) {
        return this.budgetManageService.budgetCheck(purchaseRequestHeadId);
    }

    @AutoLog(value="\u9884\u7b97\u7ba1\u7406-\u56de\u9000\u9884\u7b97\u7ba1\u7406\u5360\u7528\u91d1\u989d")
    @ApiOperation(value="\u56de\u9000\u9884\u7b97\u7ba1\u7406\u5360\u7528\u91d1\u989d", notes="\u56de\u9000\u9884\u7b97\u7ba1\u7406\u5360\u7528\u91d1\u989d")
    @GetMapping(value={"/refundOfOccupiedAmount"})
    @RequiresPermissions(value={"budgetManage#budgetManage:refundOfOccupiedAmount"})
    public Result<?> refundOfOccupiedAmount(@RequestParam String purchaseRequestHeadId) {
        this.budgetManageService.refundOfOccupiedAmount(purchaseRequestHeadId);
        return Result.ok();
    }

    @AutoLog(value="\u9884\u7b97\u7ba1\u7406-\u91c7\u8d2d\u8f6c\u8ba2\u5355\u6210\u529f\u540e\u4fee\u6539\u9884\u7b97\u91d1\u989d")
    @ApiOperation(value="\u91c7\u8d2d\u8f6c\u8ba2\u5355\u6210\u529f\u540e\u4fee\u6539\u9884\u7b97\u91d1\u989d", notes="\u91c7\u8d2d\u8f6c\u8ba2\u5355\u6210\u529f\u540e\u4fee\u6539\u9884\u7b97\u91d1\u989d")
    @GetMapping(value={"/requestToOrderChangeBudgetAmount"})
    @RequiresPermissions(value={"budgetManage#budgetManage:requestToOrderChangeBudgetAmount"})
    public Result<?> requestToOrderChangeBudgetAmount(@RequestParam String purchaseOrderHeadId) {
        this.budgetManageService.requestToOrderChangeBudgetAmount(purchaseOrderHeadId);
        return Result.ok();
    }

    @ApiOperation(value="\u83b7\u53d6ERP\u6570\u636e", notes="\u83b7\u53d6ERP\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"budgetManage#budgetManage:getDataByErp"})
    public Result<?> getDataByErp() {
        this.budgetManageService.getDataByErp();
        return Result.ok();
    }

    @ApiOperation(value="SRM\u63a8\u9001\u5230ERP", notes="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"budgetManage#budgetManage:pushDataToErp"})
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        this.budgetManageService.pushDataToErp(ids);
        return Result.ok();
    }

    @SrmValidated
    @AutoLog(value="\u9884\u7b97\u7ba1\u7406-\u590d\u5236")
    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236")
    @GetMapping(value={"/copy"})
    @RequiresPermissions(value={"budgetManage#budgetManage:copy"})
    @PermissionDataOpt(businessType="budgetManage", beanClass=BudgetManageService.class)
    public Result<?> copy(@RequestParam String id) {
        this.budgetManageService.copy(id);
        return Result.ok();
    }
}

