/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rebate.service.impl;

import com.alibaba.fastjson.JSON;
import com.els.api.dto.BaseDTO;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheet;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetCalculateDetail;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRegister;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRuleDetail;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRuleSupplement;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRuleThreshold;
import com.els.modules.rebate.enumerate.CalculationRebateCalculateResultEnum;
import com.els.modules.rebate.enumerate.CalculationRebateFormEnum;
import com.els.modules.rebate.enumerate.CalculationRebateMethodEnum;
import com.els.modules.rebate.enumerate.CalculationSheetLadderEnum;
import com.els.modules.rebate.enumerate.RebateConditionEnum;
import com.els.modules.rebate.enumerate.RebateRuleProgressiveApproachEnum;
import com.els.modules.rebate.enumerate.RebateRuleSettlementCycleEnum;
import com.els.modules.rebate.mapper.PurchaseRebateCalculationSheetMapper;
import com.els.modules.rebate.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetCalculateDetailService;
import com.els.modules.rebate.utils.DateUtils;
import com.els.modules.rebate.vo.CalculationResultDTO;
import com.els.modules.rebate.vo.CalculationSheetLadderVO;
import com.els.modules.rebate.vo.GoodLadderVO;
import com.els.modules.rebate.vo.GoodRebateVO;
import com.els.modules.rebate.vo.PurchaseRebateCalculationSheetVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public abstract class PurchaseRebateCalculationService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseRebateCalculationService.class);
    @Autowired
    private PurchaseRebateCalculationSheetCalculateDetailService purchaseRebateCalculationSheetCalculateDetailService;
    @Resource
    private PurchaseRebateCalculationSheetMapper purchaseRebateCalculationSheetMapper;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadLocalRpcService;

    protected abstract CalculationResultDTO beforeCalculate(PurchaseRebateCalculationSheet var1, PurchaseRebateCalculationSheetRuleDetail var2);

    protected abstract void afterCalculate(PurchaseRebateCalculationSheet var1, List<PurchaseRebateCalculationSheetCalculateDetail> var2, PurchaseRebateCalculationSheetRuleDetail var3, CalculationResultDTO var4);

    protected abstract CalculationResultDTO beforeCalculateThreshold(PurchaseRebateCalculationSheet var1, PurchaseRebateCalculationSheetRuleThreshold var2);

    protected abstract void afterCalculateThreshold(PurchaseRebateCalculationSheet var1, List<PurchaseRebateCalculationSheetCalculateDetail> var2, PurchaseRebateCalculationSheetRuleThreshold var3, CalculationResultDTO var4);

    protected abstract CalculationResultDTO beforeCalculateSupplement(PurchaseRebateCalculationSheet var1, PurchaseRebateCalculationSheetRuleSupplement var2);

    protected abstract void afterCalculateSupplement(PurchaseRebateCalculationSheet var1, List<PurchaseRebateCalculationSheetCalculateDetail> var2, PurchaseRebateCalculationSheetRuleSupplement var3, CalculationResultDTO var4);

    @Async
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void calculateAll(PurchaseRebateCalculationSheet sheet, PurchaseRebateCalculationSheetVO vo) {
        TenantContext.setTenant((String)sheet.getElsAccount());
        try {
            TimeUnit.SECONDS.sleep(10L);
        }
        catch (InterruptedException e) {
            log.error("calculateAll error");
        }
        HashMap<String, Boolean> thresholdMap = new HashMap<String, Boolean>();
        HashMap<String, String> ruleMap = new HashMap<String, String>();
        List<PurchaseRebateCalculationSheetRuleDetail> ruleDetails = vo.getRebateCalculationSheetRuleDetails();
        if (!CollectionUtils.isEmpty(ruleDetails)) {
            for (PurchaseRebateCalculationSheetRuleDetail ruleDetail : ruleDetails) {
                ruleMap.put(ruleDetail.getRuleNumber(), ruleDetail.getRebateSettlementCycle());
            }
        }
        this.calculateThresholds(sheet, vo.getRebateCalculationSheetRuleThresholds(), thresholdMap, ruleMap);
        BigDecimal totalRuleDetail = this.calculateDetail(sheet, ruleDetails, thresholdMap);
        BigDecimal totalSupplement = this.calculateSupplement(sheet, vo.getRebateCalculationSheetRuleSupplements(), thresholdMap, ruleMap);
        BigDecimal totalRebate = BigDecimal.ZERO;
        totalRebate = totalRebate.add(totalRuleDetail).add(totalSupplement);
        this.headCalculate(sheet, totalRebate, vo.getRebateCalculationSheetRegisters());
    }

    private BigDecimal calculateThresholds(PurchaseRebateCalculationSheet sheet, List<PurchaseRebateCalculationSheetRuleThreshold> thresholds, Map<String, Boolean> thresholdMap, Map<String, String> ruleMap) {
        log.info("rebate calculateThresholds {}", (Object)JSON.toJSONString(thresholds));
        BigDecimal totalRebate = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty(thresholds)) {
            return totalRebate;
        }
        ArrayList<PurchaseRebateCalculationSheetCalculateDetail> detailList = new ArrayList<PurchaseRebateCalculationSheetCalculateDetail>();
        for (PurchaseRebateCalculationSheetRuleThreshold threshold : thresholds) {
            CalculationResultDTO resultDTO;
            String rebateSettlementCycle = ruleMap.get(threshold.getRuleNumber());
            if (!StringUtils.isEmpty((CharSequence)rebateSettlementCycle)) {
                threshold.setRebateSettlementCycle(rebateSettlementCycle);
            }
            if (BigDecimal.ZERO.compareTo((resultDTO = this.beforeCalculateThreshold(sheet, threshold)).getTotalAmount()) == 0 && BigDecimal.ZERO.compareTo(resultDTO.getTotalNumber()) == 0) {
                this.afterCalculateThreshold(sheet, detailList, threshold, resultDTO);
                continue;
            }
            totalRebate = this.calculateThresholds(totalRebate, threshold, resultDTO);
            this.afterCalculateThreshold(sheet, detailList, threshold, resultDTO);
            if (resultDTO.getCompletionRate().compareTo(BigDecimal.ONE) >= 0) continue;
            thresholdMap.put(threshold.getRuleNumber(), true);
        }
        this.insertPurchaseRebateCalculationSheetCalculateDetail(sheet, detailList);
        return totalRebate;
    }

    private BigDecimal calculateSupplement(PurchaseRebateCalculationSheet sheet, List<PurchaseRebateCalculationSheetRuleSupplement> supplements, Map<String, Boolean> thresholdMap, Map<String, String> ruleMap) {
        log.info("rebate calculateSupplement {}", (Object)JSON.toJSONString(supplements));
        BigDecimal totalRebate = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty(supplements)) {
            return totalRebate;
        }
        log.info("rebate calculateSupplement before inverseProduct {}", (Object)JSON.toJSONString(supplements));
        for (PurchaseRebateCalculationSheetRuleSupplement supplement : supplements) {
            String inverseProducts = this.inverseProduct(supplement.getRebateProductExtends());
            if (StringUtils.isEmpty((CharSequence)inverseProducts)) continue;
            supplement.setRebateProduct(inverseProducts);
        }
        log.info("rebate calculateSupplement after inverseProduct {}", (Object)JSON.toJSONString(supplements));
        ArrayList<PurchaseRebateCalculationSheetCalculateDetail> detailList = new ArrayList<PurchaseRebateCalculationSheetCalculateDetail>();
        for (PurchaseRebateCalculationSheetRuleSupplement supplement : supplements) {
            CalculationResultDTO resultDTO;
            boolean flag;
            Boolean thresholdFlag = thresholdMap.get(supplement.getRuleNumber()) == null ? Boolean.valueOf(false) : thresholdMap.get(supplement.getRuleNumber());
            String rebateSettlementCycle = ruleMap.get(supplement.getRuleNumber());
            if (!StringUtils.isEmpty((CharSequence)rebateSettlementCycle)) {
                supplement.setRebateSettlementCycle(rebateSettlementCycle);
            }
            boolean bl = flag = BigDecimal.ZERO.compareTo((resultDTO = this.beforeCalculateSupplement(sheet, supplement)).getTotalAmount()) == 0 && BigDecimal.ZERO.compareTo(resultDTO.getTotalNumber()) == 0;
            if (flag || thresholdFlag.booleanValue()) {
                this.afterCalculateSupplement(sheet, detailList, supplement, resultDTO);
                continue;
            }
            totalRebate = this.calculateSupplement(totalRebate, sheet, supplement, resultDTO);
            this.afterCalculateSupplement(sheet, detailList, supplement, resultDTO);
        }
        this.insertPurchaseRebateCalculationSheetCalculateDetail(sheet, detailList);
        return totalRebate;
    }

    private BigDecimal calculateDetail(PurchaseRebateCalculationSheet sheet, List<PurchaseRebateCalculationSheetRuleDetail> details, Map<String, Boolean> thresholdMap) {
        log.info("rebate calculateDetail {}", (Object)JSON.toJSONString(details));
        BigDecimal totalRebate = BigDecimal.ZERO;
        if (CollectionUtils.isEmpty(details)) {
            return totalRebate;
        }
        log.info("rebate calculateDetail before inverseProduct {}", (Object)JSON.toJSONString(details));
        for (PurchaseRebateCalculationSheetRuleDetail ruleDetail : details) {
            String inverseProducts = this.inverseProduct(ruleDetail.getRebateProductExtends());
            if (StringUtils.isEmpty((CharSequence)inverseProducts)) continue;
            ruleDetail.setRebateProduct(inverseProducts);
        }
        log.info("rebate calculateDetail after inverseProduct {}", (Object)JSON.toJSONString(details));
        ArrayList<PurchaseRebateCalculationSheetCalculateDetail> detailList = new ArrayList<PurchaseRebateCalculationSheetCalculateDetail>();
        for (PurchaseRebateCalculationSheetRuleDetail rule : details) {
            boolean flag;
            Boolean thresholdFlag = thresholdMap.get(rule.getRuleNumber()) == null ? Boolean.valueOf(false) : thresholdMap.get(rule.getRuleNumber());
            CalculationResultDTO resultDTO = this.beforeCalculate(sheet, rule);
            boolean bl = flag = BigDecimal.ZERO.compareTo(resultDTO.getTotalAmount()) == 0 && BigDecimal.ZERO.compareTo(resultDTO.getTotalNumber()) == 0;
            if (flag || thresholdFlag.booleanValue()) {
                this.afterCalculate(sheet, detailList, rule, resultDTO);
                continue;
            }
            totalRebate = this.calculate(totalRebate, sheet, rule, resultDTO);
            this.afterCalculate(sheet, detailList, rule, resultDTO);
        }
        this.insertPurchaseRebateCalculationSheetCalculateDetail(sheet, detailList);
        return totalRebate;
    }

    private String inverseProduct(String productExtends) {
        String result = "";
        if (StringUtils.isEmpty((CharSequence)productExtends)) {
            return result;
        }
        try {
            List goodLadderVOS = JSON.parseArray((String)productExtends, GoodLadderVO.class);
            if (CollectionUtils.isEmpty((Collection)goodLadderVOS)) {
                return result;
            }
            Set productIds = goodLadderVOS.stream().filter(GoodLadderVO::isInverseSelection).map(GoodLadderVO::getId).collect(Collectors.toSet());
            log.info(" \u53cd\u9009ids {}", productIds);
            if (CollectionUtils.isEmpty(productIds)) {
                return result;
            }
            List<PurchaseMaterialHeadDTO> allList = this.purchaseMaterialHeadLocalRpcService.listAll();
            if (CollectionUtils.isEmpty(allList)) {
                return result;
            }
            Set allIds = allList.stream().map(BaseDTO::getId).collect(Collectors.toSet());
            log.info(" all ids {}", allIds);
            allIds.removeAll(productIds);
            log.info(" \u53cd\u9009\u540e ids {}", allIds);
            StringJoiner inverseProducts = new StringJoiner(",");
            for (String allId : allIds) {
                inverseProducts.add(allId);
            }
            result = inverseProducts.toString();
        }
        catch (Exception e) {
            log.info("goodLadderVOS \u8f6c\u6362\u5f02\u5e38: {} ", (Object)e.getMessage());
            return result;
        }
        return result;
    }

    private void headCalculate(PurchaseRebateCalculationSheet sheet, BigDecimal totalRebate, List<PurchaseRebateCalculationSheetRegister> registers) {
        String rebateForm = sheet.getRebateForm();
        if (CalculationRebateFormEnum.PHYSICAL.getValue().equals(rebateForm)) {
            sheet.setRebateQuantity(totalRebate);
            sheet.setRebateAmount(BigDecimal.ZERO);
        } else if (CalculationRebateFormEnum.OFFSET_PAYMENT.getValue().equals(rebateForm) || CalculationRebateFormEnum.COLLECTION.getValue().equals(rebateForm)) {
            BigDecimal confirmAmount;
            sheet.setRebateAmount(totalRebate);
            BigDecimal bigDecimal = confirmAmount = sheet.getConfirmAmount() == null ? BigDecimal.ZERO : sheet.getConfirmAmount();
            if (!CollectionUtils.isEmpty(registers)) {
                BigDecimal receivedAmount = registers.parallelStream().filter(item -> item.getReceivedAmount() != null).map(PurchaseRebateCalculationSheetRegister::getReceivedAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                sheet.setReceivedAmount(receivedAmount);
                BigDecimal current = confirmAmount.subtract(receivedAmount);
                current = this.handleScientificNotation(current);
                sheet.setOutstandingAmount(current);
            }
            sheet.setRebateQuantity(BigDecimal.ZERO);
        }
        sheet.setCalculateResult(CalculationRebateCalculateResultEnum.CALCULATED_SUCCESS.getValue());
        this.purchaseRebateCalculationSheetMapper.updateById((Object)sheet);
    }

    private BigDecimal calculateSupplement(BigDecimal rebateAmount, PurchaseRebateCalculationSheet sheet, PurchaseRebateCalculationSheetRuleSupplement supplement, CalculationResultDTO resultDTO) {
        BigDecimal totalAmount = resultDTO.getTotalAmount();
        BigDecimal totalNumber = resultDTO.getTotalNumber();
        BigDecimal rebate = BigDecimal.ZERO;
        if (RebateConditionEnum.AMOUNT.getValue().equals(supplement.getRebateCondition())) {
            rebate = totalAmount;
        } else if (RebateConditionEnum.NUMBER.getValue().equals(supplement.getRebateCondition())) {
            rebate = totalNumber;
        }
        BigDecimal thresholdValue = supplement.getThresholdValue();
        this.handleRebateMethod(resultDTO, rebate, thresholdValue, supplement.getRebateMethod());
        if (BigDecimal.ONE.compareTo(resultDTO.getCompletionRate()) != 0) {
            return rebateAmount;
        }
        String rebateLadder = supplement.getRebateLadder();
        List sheetLadderVOList = JSON.parseArray((String)rebateLadder, CalculationSheetLadderVO.class);
        String productExtends = supplement.getRebateProductExtends();
        boolean goodLadderFlag = this.isGoodLadder(productExtends);
        if (goodLadderFlag) {
            GoodRebateVO goodRebateVO = new GoodRebateVO();
            BeanUtils.copyProperties((Object)((Object)supplement), (Object)goodRebateVO);
            rebateAmount = this.handleGoodRebate(rebateAmount, sheet, resultDTO, goodRebateVO, sheetLadderVOList, productExtends);
        } else {
            String progressiveApproach = supplement.getProgressiveApproach();
            BigDecimal current = BigDecimal.ZERO;
            if (RebateRuleProgressiveApproachEnum.FULLY_PROGRESSIVE.getValue().equals(progressiveApproach)) {
                current = this.fullyProgressiveCalculation(sheetLadderVOList, totalAmount, totalNumber, sheet.getRebateForm());
            } else if (RebateRuleProgressiveApproachEnum.OVER_PROGRESSIVE.getValue().equals(progressiveApproach)) {
                current = this.overProgressiveCalculation(sheetLadderVOList, totalAmount, totalNumber, sheet.getRebateForm());
            }
            resultDTO.setRebateAmount(current);
            rebateAmount = rebateAmount.add(current);
        }
        return rebateAmount;
    }

    private BigDecimal calculateThresholds(BigDecimal rebateAmount, PurchaseRebateCalculationSheetRuleThreshold threshold, CalculationResultDTO resultDTO) {
        BigDecimal totalAmount = resultDTO.getTotalAmount();
        BigDecimal totalNumber = resultDTO.getTotalNumber();
        BigDecimal rebate = BigDecimal.ZERO;
        if (RebateConditionEnum.AMOUNT.getValue().equals(threshold.getRebateCondition())) {
            rebate = totalAmount;
        } else if (RebateConditionEnum.NUMBER.getValue().equals(threshold.getRebateCondition())) {
            rebate = totalNumber;
        }
        BigDecimal thresholdValue = threshold.getThresholdValue();
        this.handleRebateMethod(resultDTO, rebate, thresholdValue, threshold.getRebateMethod());
        return rebateAmount;
    }

    private void handleRebateMethod(CalculationResultDTO resultDTO, BigDecimal rebate, BigDecimal thresholdValue, String rebateMethod) {
        if (CalculationRebateMethodEnum.FIX.getValue().equals(rebateMethod)) {
            BigDecimal temp = rebate.subtract(thresholdValue);
            if (BigDecimal.ZERO.compareTo(temp = this.handleScientificNotation(temp)) <= 0) {
                resultDTO.setCompletionRate(BigDecimal.ONE);
            } else {
                BigDecimal completionRate = rebate.divide(thresholdValue, 4, 4);
                resultDTO.setCompletionRate(completionRate);
            }
        } else if (CalculationRebateMethodEnum.RATE.getValue().equals(rebateMethod)) {
            BigDecimal temp = rebate.multiply(thresholdValue).multiply(new BigDecimal("0.01"));
            BigDecimal result = rebate.subtract(temp);
            if (BigDecimal.ZERO.compareTo(result = this.handleScientificNotation(result)) <= 0) {
                resultDTO.setCompletionRate(BigDecimal.ONE);
            } else {
                BigDecimal completionRate = rebate.divide(temp, 4, 4);
                resultDTO.setCompletionRate(completionRate);
            }
        }
    }

    private BigDecimal calculate(BigDecimal rebateAmount, PurchaseRebateCalculationSheet sheet, PurchaseRebateCalculationSheetRuleDetail rule, CalculationResultDTO resultDTO) {
        BigDecimal totalAmount = resultDTO.getTotalAmount();
        BigDecimal totalNumber = resultDTO.getTotalNumber();
        String rebateLadder = rule.getRebateLadder();
        List sheetLadderVOList = JSON.parseArray((String)rebateLadder, CalculationSheetLadderVO.class);
        BigDecimal completionCount = BigDecimal.ZERO;
        if (RebateConditionEnum.AMOUNT.getValue().equals(rule.getRebateCondition())) {
            completionCount = totalAmount;
        } else if (RebateConditionEnum.NUMBER.getValue().equals(rule.getRebateCondition())) {
            completionCount = totalNumber;
        }
        this.calculateCompletionRate(sheetLadderVOList, resultDTO, completionCount);
        String productExtends = rule.getRebateProductExtends();
        boolean goodLadderFlag = this.isGoodLadder(productExtends);
        if (goodLadderFlag) {
            GoodRebateVO goodRebateVO = new GoodRebateVO();
            BeanUtils.copyProperties((Object)((Object)rule), (Object)goodRebateVO);
            rebateAmount = this.handleGoodRebate(rebateAmount, sheet, resultDTO, goodRebateVO, sheetLadderVOList, productExtends);
        } else {
            String progressiveApproach = rule.getProgressiveApproach();
            BigDecimal current = BigDecimal.ZERO;
            if (RebateRuleProgressiveApproachEnum.FULLY_PROGRESSIVE.getValue().equals(progressiveApproach)) {
                current = this.fullyProgressiveCalculation(sheetLadderVOList, totalAmount, totalNumber, sheet.getRebateForm());
            } else if (RebateRuleProgressiveApproachEnum.OVER_PROGRESSIVE.getValue().equals(progressiveApproach)) {
                current = this.overProgressiveCalculation(sheetLadderVOList, totalAmount, totalNumber, sheet.getRebateForm());
            }
            resultDTO.setRebateAmount(current);
            rebateAmount = rebateAmount.add(current);
        }
        return rebateAmount;
    }

    private boolean isGoodLadder(String productExtends) {
        boolean goodLadderFlag = false;
        if (StringUtils.isEmpty((CharSequence)productExtends)) {
            return goodLadderFlag;
        }
        try {
            List goodLadderList = JSON.parseArray((String)productExtends, GoodLadderVO.class);
            if (CollectionUtils.isEmpty((Collection)goodLadderList)) {
                return goodLadderFlag;
            }
            for (GoodLadderVO goodLadderVO : goodLadderList) {
                if (StringUtils.isEmpty((CharSequence)goodLadderVO.getChildRebateLadder())) continue;
                goodLadderFlag = true;
            }
        }
        catch (Exception e) {
            log.error("isGoodLadder error: {}", (Object)e.getMessage());
        }
        return goodLadderFlag;
    }

    private BigDecimal handleGoodRebate(BigDecimal rebateAmount, PurchaseRebateCalculationSheet sheet, CalculationResultDTO resultDTO, GoodRebateVO goodRebateVO, List<CalculationSheetLadderVO> sheetLadderVOList, String productExtends) {
        BigDecimal goodRebateAmount = BigDecimal.ZERO;
        HashMap<BigDecimal, CalculationSheetLadderVO> ladderMap = new HashMap<BigDecimal, CalculationSheetLadderVO>();
        for (CalculationSheetLadderVO ladderVO : sheetLadderVOList) {
            ladderMap.put(ladderVO.getMin(), ladderVO);
        }
        try {
            List goodLadderList = JSON.parseArray((String)productExtends, GoodLadderVO.class);
            if (CollectionUtils.isEmpty((Collection)goodLadderList)) {
                return rebateAmount;
            }
            for (GoodLadderVO ladderVO : goodLadderList) {
                List<CalculationSheetLadderVO> childrenLadder = ladderVO.getRebateLadder();
                if (CollectionUtils.isEmpty(childrenLadder)) continue;
                CalculationResultDTO goodResultDto = new CalculationResultDTO();
                BeanUtils.copyProperties((Object)resultDTO, goodResultDto);
                this.handleGoodRebate(goodResultDto, ladderVO, goodRebateVO);
                BigDecimal goodTotalAmount = goodResultDto.getTotalAmount();
                BigDecimal goodTotalNumber = goodResultDto.getTotalNumber();
                boolean flag = this.needUseLineData(ladderMap, childrenLadder);
                this.copyLineDataToGoodLadder(ladderMap, childrenLadder, flag);
                String progressiveApproach = goodRebateVO.getProgressiveApproach();
                BigDecimal current = BigDecimal.ZERO;
                if (RebateRuleProgressiveApproachEnum.FULLY_PROGRESSIVE.getValue().equals(progressiveApproach)) {
                    current = this.fullyProgressiveCalculation(childrenLadder, goodTotalAmount, goodTotalNumber, sheet.getRebateForm());
                } else if (RebateRuleProgressiveApproachEnum.OVER_PROGRESSIVE.getValue().equals(progressiveApproach)) {
                    current = this.overProgressiveCalculation(childrenLadder, goodTotalAmount, goodTotalNumber, sheet.getRebateForm());
                }
                goodRebateAmount = goodRebateAmount.add(current);
            }
        }
        catch (Exception e) {
            log.error("parse GoodLadderVO error : {} ", (Object)e.getMessage());
        }
        resultDTO.setRebateAmount(goodRebateAmount);
        rebateAmount = rebateAmount.add(goodRebateAmount);
        return rebateAmount;
    }

    private void copyLineDataToGoodLadder(Map<BigDecimal, CalculationSheetLadderVO> ladderMap, List<CalculationSheetLadderVO> childrenLadder, boolean flag) {
        for (CalculationSheetLadderVO childrenLadderVO : childrenLadder) {
            BigDecimal min = childrenLadderVO.getMin();
            if (min == null) {
                return;
            }
            CalculationSheetLadderVO parentLadderVO = ladderMap.get(min);
            if (parentLadderVO == null || childrenLadderVO.getFix() != null || childrenLadderVO.getRate() != null || childrenLadderVO.getUnion() != null || flag) continue;
            childrenLadderVO.setFix(parentLadderVO.getFix());
            childrenLadderVO.setRate(parentLadderVO.getRate());
            childrenLadderVO.setUnion(parentLadderVO.getUnion());
        }
    }

    private boolean needUseLineData(Map<BigDecimal, CalculationSheetLadderVO> ladderMap, List<CalculationSheetLadderVO> childrenLadder) {
        boolean flag = false;
        for (CalculationSheetLadderVO childrenLadderVO : childrenLadder) {
            BigDecimal min = childrenLadderVO.getMin();
            if (min == null) {
                return flag;
            }
            CalculationSheetLadderVO parentLadderVO = ladderMap.get(min);
            if (parentLadderVO == null || childrenLadderVO.getFix() == null && childrenLadderVO.getRate() == null && childrenLadderVO.getUnion() == null) continue;
            flag = true;
        }
        return flag;
    }

    protected abstract void handleGoodRebate(CalculationResultDTO var1, GoodLadderVO var2, GoodRebateVO var3);

    private void calculateCompletionRate(List<CalculationSheetLadderVO> sheetLadderVOList, CalculationResultDTO resultDTO, BigDecimal completionCount) {
        BigDecimal totalCompletionRate = BigDecimal.ZERO;
        for (CalculationSheetLadderVO ladderVO : sheetLadderVOList) {
            BigDecimal min = ladderVO.getMin();
            BigDecimal temp = completionCount.subtract(min);
            if (BigDecimal.ZERO.compareTo(temp = this.handleScientificNotation(temp)) <= 0) {
                totalCompletionRate = totalCompletionRate.add(BigDecimal.ONE);
                resultDTO.setCompletionRate(totalCompletionRate);
                continue;
            }
            BigDecimal currentCompletionRate = completionCount.divide(min, 4, 4);
            totalCompletionRate = totalCompletionRate.add(currentCompletionRate);
            resultDTO.setCompletionRate(currentCompletionRate);
            break;
        }
        resultDTO.setTotalCompletionRate(totalCompletionRate);
    }

    private BigDecimal fullyProgressiveCalculation(List<CalculationSheetLadderVO> sheetLadderVOList, BigDecimal amount, BigDecimal number, String rebateForm) {
        BigDecimal currency;
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal maxValue = BigDecimal.ZERO;
        if (CalculationRebateFormEnum.PHYSICAL.getValue().equals(rebateForm)) {
            maxValue = number;
        } else if (CalculationRebateFormEnum.OFFSET_PAYMENT.getValue().equals(rebateForm) || CalculationRebateFormEnum.COLLECTION.getValue().equals(rebateForm)) {
            maxValue = amount;
        }
        Collections.reverse(sheetLadderVOList);
        CalculationSheetLadderVO fullVo = null;
        for (CalculationSheetLadderVO vo : sheetLadderVOList) {
            BigDecimal max;
            BigDecimal min = vo.getMin() == null ? BigDecimal.ZERO : vo.getMin();
            BigDecimal bigDecimal = max = vo.getMax() == null ? BigDecimal.ZERO : vo.getMax();
            if (maxValue.compareTo(min) < 0) {
                log.info("rebate:  \u8fd4\u5229\u503c: " + maxValue + ",\u4f4e\u4e8e\u8303\u56f4, min: " + min + "max: " + max);
                continue;
            }
            fullVo = vo;
            break;
        }
        if (fullVo == null) {
            return total;
        }
        if (CalculationSheetLadderEnum.FIX.getValue().equals(fullVo.getType())) {
            BigDecimal fix = fullVo.getFix();
            total = total.add(fix);
        } else if (CalculationSheetLadderEnum.RATE.getValue().equals(fullVo.getType())) {
            BigDecimal rate = fullVo.getRate();
            if (rate == null || BigDecimal.ZERO.compareTo(rate) == 0) {
                throw new ELSBootException("\u6bd4\u4f8b\u503c\u4e0d\u80fd\u4e3a0 ");
            }
            currency = maxValue.multiply(rate).multiply(new BigDecimal("0.01"));
            total = total.add(currency);
        } else if (CalculationSheetLadderEnum.UNION.getValue().equals(fullVo.getType())) {
            maxValue = number;
            BigDecimal union = fullVo.getUnion();
            if (BigDecimal.ZERO.compareTo(union) == 0) {
                throw new ELSBootException("\u6bcf\u5355\u4f4d\u4e0d\u80fd\u4e3a0");
            }
            currency = maxValue.multiply(union);
            total = total.add(currency);
        } else {
            BigDecimal fixRebate = fullVo.getFix() == null ? BigDecimal.ZERO : fullVo.getFix();
            BigDecimal rateRebate = BigDecimal.ZERO;
            BigDecimal rate = fullVo.getRate();
            if (rate != null && BigDecimal.ZERO.compareTo(rate) != 0) {
                rateRebate = maxValue.multiply(rate).multiply(new BigDecimal("0.01"));
            }
            BigDecimal unionRebate = BigDecimal.ZERO;
            maxValue = number;
            BigDecimal union = fullVo.getUnion();
            if (union != null && BigDecimal.ZERO.compareTo(union) != 0) {
                unionRebate = maxValue.multiply(union);
            }
            total = total.add(fixRebate);
            total = total.add(rateRebate);
            total = total.add(unionRebate);
        }
        if (CalculationRebateFormEnum.PHYSICAL.getValue().equals(rebateForm)) {
            total = total.setScale(6, 4);
        } else if (CalculationRebateFormEnum.OFFSET_PAYMENT.getValue().equals(rebateForm) || CalculationRebateFormEnum.COLLECTION.getValue().equals(rebateForm)) {
            total = total.setScale(2, 4);
        }
        log.info("rebate:  final total : " + total);
        return total;
    }

    private BigDecimal overProgressiveCalculation(List<CalculationSheetLadderVO> sheetLadderVOList, BigDecimal amount, BigDecimal number, String rebateForm) {
        BigDecimal difference = BigDecimal.ZERO;
        BigDecimal differenceTotal = BigDecimal.ZERO;
        BigDecimal total = BigDecimal.ZERO;
        Collections.reverse(sheetLadderVOList);
        for (CalculationSheetLadderVO vo : sheetLadderVOList) {
            BigDecimal currency;
            BigDecimal union;
            BigDecimal max = vo.getMax() == null ? BigDecimal.ZERO : vo.getMax();
            BigDecimal min = vo.getMin() == null ? BigDecimal.ZERO : vo.getMin();
            BigDecimal rate = vo.getRate() == null ? BigDecimal.ZERO : vo.getRate();
            BigDecimal fix = vo.getFix() == null ? BigDecimal.ZERO : vo.getFix();
            BigDecimal bigDecimal = union = vo.getUnion() == null ? BigDecimal.ZERO : vo.getUnion();
            if (CalculationRebateFormEnum.PHYSICAL.getValue().equals(rebateForm)) {
                if (number.compareTo(min) < 0) {
                    log.info("rebate: \u8fd4\u5229\u503c: " + number + ",\u4f4e\u4e8e\u8303\u56f4, min: " + min + "max: " + max);
                    continue;
                }
                difference = number.subtract(min).subtract(differenceTotal);
                difference = this.handleScientificNotation(difference);
            } else if (CalculationRebateFormEnum.OFFSET_PAYMENT.getValue().equals(rebateForm) || CalculationRebateFormEnum.COLLECTION.getValue().equals(rebateForm)) {
                if (amount.compareTo(min) < 0) {
                    log.info("rebate: \u8fd4\u5229\u503c: " + amount + ",\u4f4e\u4e8e\u8303\u56f4, min: " + min + "max: " + max);
                    continue;
                }
                difference = amount.subtract(min).subtract(differenceTotal);
                difference = this.handleScientificNotation(difference);
            }
            differenceTotal = differenceTotal.add(difference);
            if (BigDecimal.ZERO.compareTo(difference) == 0) continue;
            if (CalculationSheetLadderEnum.FIX.getValue().equals(vo.getType())) {
                total = total.add(fix);
                log.info("rebate: \u6309\u56fa\u5b9a\u503c\u8fdb\u884c\u8fd4\u5229,  fix: " + fix);
                continue;
            }
            if (CalculationSheetLadderEnum.RATE.getValue().equals(vo.getType())) {
                if (BigDecimal.ZERO.compareTo(rate) == 0) continue;
                currency = difference.multiply(rate).multiply(new BigDecimal("0.01"));
                total = total.add(currency);
                log.info("rebate: \u6309\u6bd4\u4f8b\u8fdb\u884c\u8fd4\u5229,  difference: " + difference + "  differenceTotal: " + differenceTotal + "   currency: " + currency + "rate: " + rate);
                continue;
            }
            if (CalculationSheetLadderEnum.UNION.getValue().equals(vo.getType())) {
                if (BigDecimal.ZERO.compareTo(union) == 0) continue;
                currency = difference.multiply(union);
                total = total.add(currency);
                log.info("rebate: \u6309\u6bcf\u5355\u4f4d\u8fdb\u884c\u8fd4\u5229,  difference: " + difference + "  differenceTotal: " + differenceTotal + "   currency: " + currency + "  union: " + union);
                continue;
            }
            BigDecimal fixRebate = vo.getFix() == null ? BigDecimal.ZERO : vo.getFix();
            BigDecimal rateRebate = BigDecimal.ZERO;
            if (rate != null && BigDecimal.ZERO.compareTo(rate) != 0) {
                rateRebate = difference.multiply(rate).multiply(new BigDecimal("0.01"));
            }
            BigDecimal unionRebate = BigDecimal.ZERO;
            if (union != null && BigDecimal.ZERO.compareTo(union) != 0) {
                unionRebate = difference.multiply(union);
            }
            total = total.add(fixRebate);
            total = total.add(rateRebate);
            total = total.add(unionRebate);
        }
        if (CalculationRebateFormEnum.PHYSICAL.getValue().equals(rebateForm)) {
            total = total.setScale(6, 4);
        } else if (CalculationRebateFormEnum.OFFSET_PAYMENT.getValue().equals(rebateForm) || CalculationRebateFormEnum.COLLECTION.getValue().equals(rebateForm)) {
            total = total.setScale(2, 4);
        }
        log.info("rebate: final total : " + total);
        return total;
    }

    protected BigDecimal handleScientificNotation(BigDecimal number) {
        return number.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : number;
    }

    protected Date handleCalculationSheetEndDate(String rebateSettlementCycle, Date endDate) {
        Date calculationSheetEndDate = null;
        if (RebateRuleSettlementCycleEnum.RANDOM.getValue().equals(rebateSettlementCycle)) {
            return null;
        }
        if (RebateRuleSettlementCycleEnum.MONTH.getValue().equals(rebateSettlementCycle)) {
            calculationSheetEndDate = DateUtils.getMonth(endDate);
        } else if (RebateRuleSettlementCycleEnum.QUARTER.getValue().equals(rebateSettlementCycle)) {
            calculationSheetEndDate = DateUtils.getQuarter(endDate);
        } else if (RebateRuleSettlementCycleEnum.HALF_YEAR.getValue().equals(rebateSettlementCycle)) {
            calculationSheetEndDate = DateUtils.getHalfYear(endDate);
        } else if (RebateRuleSettlementCycleEnum.YEAR.getValue().equals(rebateSettlementCycle)) {
            calculationSheetEndDate = DateUtils.getYear(endDate);
        }
        return calculationSheetEndDate;
    }

    private void insertPurchaseRebateCalculationSheetCalculateDetail(PurchaseRebateCalculationSheet sheet, List<PurchaseRebateCalculationSheetCalculateDetail> detailList) {
        if (CollectionUtils.isEmpty(detailList)) {
            return;
        }
        int itemNumber = 1;
        for (PurchaseRebateCalculationSheetCalculateDetail calculateDetail : detailList) {
            calculateDetail.setHeadId(sheet.getId());
            SysUtil.setSysParam((BaseEntity)calculateDetail, (BaseEntity)sheet);
            calculateDetail.setItemNumber(String.valueOf(itemNumber));
            ++itemNumber;
        }
        this.purchaseRebateCalculationSheetCalculateDetailService.saveBatch(detailList);
    }
}

