/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.confirm.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.confirm.entity.PurchaseReconciliationConfirmation;
import com.els.modules.confirm.entity.PurchaseReconciliationConfirmationBookBalance;
import com.els.modules.confirm.entity.PurchaseReconciliationConfirmationDifferenceDescription;
import com.els.modules.confirm.entity.PurchaseReconciliationConfirmationUnpaidAccount;
import com.els.modules.confirm.entity.SaleReconciliationConfirmation;
import com.els.modules.confirm.entity.SaleReconciliationConfirmationBookBalance;
import com.els.modules.confirm.entity.SaleReconciliationConfirmationDifferenceDescription;
import com.els.modules.confirm.entity.SaleReconciliationConfirmationUnpaidAccount;
import com.els.modules.confirm.mapper.PurchaseReconciliationConfirmationBookBalanceMapper;
import com.els.modules.confirm.mapper.PurchaseReconciliationConfirmationDifferenceDescriptionMapper;
import com.els.modules.confirm.mapper.PurchaseReconciliationConfirmationMapper;
import com.els.modules.confirm.mapper.PurchaseReconciliationConfirmationUnpaidAccountMapper;
import com.els.modules.confirm.mapper.SaleReconciliationConfirmationBookBalanceMapper;
import com.els.modules.confirm.mapper.SaleReconciliationConfirmationDifferenceDescriptionMapper;
import com.els.modules.confirm.mapper.SaleReconciliationConfirmationMapper;
import com.els.modules.confirm.mapper.SaleReconciliationConfirmationUnpaidAccountMapper;
import com.els.modules.confirm.service.PurchaseReconciliationConfirmationBookBalanceService;
import com.els.modules.confirm.service.PurchaseReconciliationConfirmationDifferenceDescriptionService;
import com.els.modules.confirm.service.PurchaseReconciliationConfirmationUnpaidAccountService;
import com.els.modules.confirm.service.SaleReconciliationConfirmationService;
import com.els.modules.delivery.api.dto.PurchaseReconciliationConfirmationDTO;
import com.els.modules.delivery.api.dto.PurchaseVoucherItemDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.modules.finance.api.enumerate.ConfirmEsignStatusEnum;
import com.els.modules.reconciliation.entity.PurchasePerformanceReconciliation;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.enumerate.ConfirmElectronicSignStatusEmun;
import com.els.modules.reconciliation.enumerate.ConfirmUnpaidAccountItemStatusEnum;
import com.els.modules.reconciliation.enumerate.ReconciliationConfirmStatusEnum;
import com.els.modules.reconciliation.mapper.PurchasePerformanceReconciliationMapper;
import com.els.modules.reconciliation.mapper.PurchaseReconciliationMapper;
import com.els.modules.reconciliation.rpc.PurchaseVoucherItemLocalRpcService;
import com.els.modules.reconciliation.vo.SaleReconciliationConfirmationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class SaleReconciliationConfirmationServiceImpl
extends BaseServiceImpl<SaleReconciliationConfirmationMapper, SaleReconciliationConfirmation>
implements SaleReconciliationConfirmationService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseReconciliationConfirmationMapper purchaseReconciliationConfirmationMapper;
    @Resource
    private SaleReconciliationConfirmationMapper saleReconciliationConfirmationMapper;
    @Resource
    private SaleReconciliationConfirmationBookBalanceMapper saleReconciliationConfirmationBookBalanceMapper;
    @Resource
    private SaleReconciliationConfirmationUnpaidAccountMapper saleReconciliationConfirmationUnpaidAccountMapper;
    @Resource
    private SaleReconciliationConfirmationDifferenceDescriptionMapper saleReconciliationConfirmationDifferenceDescriptionMapper;
    @Resource
    private PurchaseReconciliationConfirmationBookBalanceMapper purchaseReconciliationConfirmationBookBalanceMapper;
    @Resource
    private PurchaseReconciliationConfirmationUnpaidAccountMapper purchaseReconciliationConfirmationUnpaidAccountMapper;
    @Resource
    private PurchaseReconciliationConfirmationDifferenceDescriptionMapper purchaseReconciliationConfirmationDifferenceDescriptionMapper;
    @Autowired
    private PurchaseReconciliationConfirmationBookBalanceService purchaseReconciliationConfirmationBookBalanceService;
    @Autowired
    private PurchaseReconciliationConfirmationUnpaidAccountService purchaseReconciliationConfirmationUnpaidAccountService;
    @Autowired
    private PurchaseReconciliationConfirmationDifferenceDescriptionService purchaseReconciliationConfirmationDifferenceDescriptionService;
    @Resource
    private PurchaseReconciliationMapper purchaseReconciliationMapper;
    @Resource
    private PurchasePerformanceReconciliationMapper purchasePerformanceReconciliationMapper;
    @Autowired
    private StaticConfig staticConfig;
    @Resource
    private TemplateRpcService templateHeadService;
    @Resource
    private ElsEnterpriseInfoRpcService elsEnterpriseInfoRpcService;
    @Resource
    private PurchaseVoucherItemLocalRpcService purchaseVoucherItemRpcService;

    @Override
    public void add(SaleReconciliationConfirmation saleReconciliationConfirmation) {
        ((SaleReconciliationConfirmationMapper)this.baseMapper).insert((Object)saleReconciliationConfirmation);
    }

    @Override
    public void edit(SaleReconciliationConfirmation saleReconciliationConfirmation) {
        int count = ((SaleReconciliationConfirmationMapper)this.baseMapper).updateById((Object)saleReconciliationConfirmation);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((SaleReconciliationConfirmationMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.purchaseReconciliationConfirmationBookBalanceMapper.deleteByMainId(id);
        this.purchaseReconciliationConfirmationUnpaidAccountMapper.deleteByMainId(id);
        this.purchaseReconciliationConfirmationDifferenceDescriptionMapper.deleteByMainId(id);
        List<SaleReconciliationConfirmationUnpaidAccount> accountList = this.saleReconciliationConfirmationUnpaidAccountMapper.selectByMainId(id);
        if (CollectionUtils.isEmpty(accountList)) {
            return;
        }
        for (SaleReconciliationConfirmationUnpaidAccount unpaidAccount : accountList) {
            String businessNumber = unpaidAccount.getBusinessNumbers();
            if (StringUtils.isEmpty((CharSequence)businessNumber) || !businessNumber.contains(",")) continue;
            List<String> businessNumbers = Arrays.asList(businessNumber.split(","));
            this.releaseConfirmStatus(businessNumbers);
        }
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleReconciliationConfirmationMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirmOrRefused(SaleReconciliationConfirmation confirmation, String operation) {
        String opt = null;
        if ("confirm".equals(operation)) {
            confirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.CONFIRMED.getValue());
            opt = "confirm";
        } else if ("refused".equals(operation)) {
            confirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.UNCONFIRMED.getValue());
            opt = "refund";
        }
        this.updateById((Object)confirmation);
        this.invokeBaseRpcService.addStatusLog(confirmation.getRelationId(), confirmation.getPreparedByStatus(), "saleReconciliationConfirmation", opt);
        PurchaseReconciliationConfirmation purchaseConfirmation = (PurchaseReconciliationConfirmation)((Object)this.purchaseReconciliationConfirmationMapper.selectById((Serializable)((Object)confirmation.getRelationId())));
        if (purchaseConfirmation == null) {
            throw new RuntimeException("\u5bf9\u5e94\u7684\u9500\u552e\u5bf9\u8d26\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u786e\u8ba4\u6216\u62d2\u7edd");
        }
        purchaseConfirmation.setPreparedByStatus(confirmation.getPreparedByStatus());
        purchaseConfirmation.setRemark(confirmation.getRemark());
        purchaseConfirmation.setRelationId(confirmation.getId());
        this.purchaseReconciliationConfirmationMapper.updateById((Object)purchaseConfirmation);
        super.sendMessage(purchaseConfirmation.getElsAccount(), "saleReconciliationConfirmation", opt, purchaseConfirmation.getId(), "reconciliationConfirmationBusDataServiceImpl", Arrays.asList(purchaseConfirmation.getToElsAccount()));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void opponentConfirm(SaleReconciliationConfirmation confirmation) {
        String opt = "confirm";
        List<SaleReconciliationConfirmationDifferenceDescription> saleDescriptionList = this.saleReconciliationConfirmationDifferenceDescriptionMapper.selectByMainId(confirmation.getId());
        List<SaleReconciliationConfirmationBookBalance> saleReconciliationConfirmationBookBalanceList = this.saleReconciliationConfirmationBookBalanceMapper.selectByMainId(confirmation.getId());
        List<SaleReconciliationConfirmationUnpaidAccount> saleReconciliationConfirmationUnpaidAccountList = this.saleReconciliationConfirmationUnpaidAccountMapper.selectByMainId(confirmation.getId());
        if (CollectionUtils.isEmpty(saleDescriptionList)) {
            confirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.CONFIRMED.getValue());
        } else {
            confirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.UNCONFIRMEDS.getValue());
        }
        PurchaseReconciliationConfirmation purchaseReconciliationConfirmation = (PurchaseReconciliationConfirmation)((Object)this.purchaseReconciliationConfirmationMapper.selectById((Serializable)((Object)confirmation.getRelationId())));
        this.asyBalance(saleReconciliationConfirmationBookBalanceList);
        this.asyUnpaidAccount(saleReconciliationConfirmationUnpaidAccountList);
        this.handlePurchaseReconciliationConfirmationDifferenceDescription(purchaseReconciliationConfirmation, saleDescriptionList);
        this.updateById((Object)confirmation);
        this.invokeBaseRpcService.addStatusLog(confirmation.getRelationId(), confirmation.getPreparedByStatus(), "purchaseReconciliationConfirmation", opt);
        if (purchaseReconciliationConfirmation != null) {
            purchaseReconciliationConfirmation.setPreparedByStatus(confirmation.getPreparedByStatus());
            purchaseReconciliationConfirmation.setRemark(confirmation.getRemark());
            purchaseReconciliationConfirmation.setRelationId(confirmation.getId());
            this.purchaseReconciliationConfirmationMapper.updateById((Object)purchaseReconciliationConfirmation);
        }
    }

    @Override
    public List<PurchaseReconciliationConfirmationUnpaidAccount> extractUnPaidAccountItem(SaleReconciliationConfirmationVO vo) {
        ArrayList<PurchaseReconciliationConfirmationUnpaidAccount> result = new ArrayList<PurchaseReconciliationConfirmationUnpaidAccount>();
        if (StringUtils.isEmpty((CharSequence)vo.getLocalCurrency())) {
            vo.setLocalCurrency("CNY");
        }
        if (StringUtils.isEmpty((CharSequence)vo.getToLocalCurrency())) {
            vo.setToLocalCurrency("CNY");
        }
        if (vo.getBeginDate() != null) {
            vo.setBeginDate((Date)DateUtil.beginOfDay((Date)vo.getBeginDate()));
        }
        if (vo.getEndDate() != null) {
            vo.setEndDate((Date)DateUtil.endOfDay((Date)vo.getEndDate()));
        }
        this.extractReconciliationPreparationConfirmAmount(vo, result);
        this.extractUnReconciliationConfirmationAmount(vo, result);
        return result;
    }

    @Override
    public JSONObject getDataById(String id) {
        SaleReconciliationConfirmation saleReconciliationConfirmation = (SaleReconciliationConfirmation)((Object)this.getById((Serializable)((Object)id)));
        SaleReconciliationConfirmationVO headVO = (SaleReconciliationConfirmationVO)((Object)BeanUtil.copyProperties((Object)((Object)saleReconciliationConfirmation), SaleReconciliationConfirmationVO.class, (String[])new String[0]));
        Result result = Result.ok((Object)((Object)headVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }

    private void extractReconciliationPreparationConfirmAmount(SaleReconciliationConfirmationVO vo, List<PurchaseReconciliationConfirmationUnpaidAccount> result) {
        List<PurchasePerformanceReconciliation> purchasePerformanceReconciliationList;
        BigDecimal reconciliationPreparationConfirmAmount = BigDecimal.ZERO;
        ArrayList<String> businessNumbers = new ArrayList<String>();
        List<PurchaseReconciliation> purchaseReconciliationList = this.purchaseReconciliationMapper.saleListReconciliationByConfirm(vo);
        if (!CollectionUtils.isEmpty(purchaseReconciliationList)) {
            for (Object purchaseReconciliation : purchaseReconciliationList) {
                boolean flag;
                BigDecimal closingAmount = purchaseReconciliation.getClosingAmount() == null ? BigDecimal.ZERO : purchaseReconciliation.getClosingAmount();
                if (BigDecimal.ZERO.compareTo(closingAmount) == 0) continue;
                boolean bl = flag = "1".equals(purchaseReconciliation.getConfirmStatus()) && !StringUtils.isEmpty((CharSequence)vo.getPreparedByNumber()) && !vo.getPreparedByNumber().equals(purchaseReconciliation.getConfirmNumber());
                if (flag) continue;
                reconciliationPreparationConfirmAmount = reconciliationPreparationConfirmAmount.add(closingAmount);
                businessNumbers.add(purchaseReconciliation.getReconciliationNumber());
            }
        }
        if (!CollectionUtils.isEmpty(purchasePerformanceReconciliationList = this.purchasePerformanceReconciliationMapper.saleListReconciliationByConfirm(vo))) {
            for (PurchasePerformanceReconciliation purchasePerformanceReconciliation : purchasePerformanceReconciliationList) {
                boolean flag;
                BigDecimal closingAmount = purchasePerformanceReconciliation.getClosingAmount() == null ? BigDecimal.ZERO : purchasePerformanceReconciliation.getClosingAmount();
                if (BigDecimal.ZERO.compareTo(closingAmount) == 0) continue;
                boolean bl = flag = "1".equals(purchasePerformanceReconciliation.getConfirmStatus()) && !StringUtils.isEmpty((CharSequence)vo.getPreparedByNumber()) && !vo.getPreparedByNumber().equals(purchasePerformanceReconciliation.getConfirmNumber());
                if (flag) continue;
                businessNumbers.add(purchasePerformanceReconciliation.getReconciliationNumber());
                reconciliationPreparationConfirmAmount = reconciliationPreparationConfirmAmount.add(closingAmount);
            }
        }
        PurchaseReconciliationConfirmationUnpaidAccount unReconciliationConfirmationUnpaidAccount = new PurchaseReconciliationConfirmationUnpaidAccount();
        unReconciliationConfirmationUnpaidAccount.setUnpaidAccountItem(ConfirmUnpaidAccountItemStatusEnum.RECONCILATIONED.getValue());
        unReconciliationConfirmationUnpaidAccount.setPreparationConfirmAmount(reconciliationPreparationConfirmAmount);
        String businessNumbersStr = String.join((CharSequence)",", businessNumbers);
        unReconciliationConfirmationUnpaidAccount.setBusinessNumbers(businessNumbersStr);
        result.add(unReconciliationConfirmationUnpaidAccount);
    }

    private void extractUnReconciliationConfirmationAmount(SaleReconciliationConfirmationVO vo, List<PurchaseReconciliationConfirmationUnpaidAccount> result) {
        ArrayList<String> businessNumbers = new ArrayList<String>();
        PurchaseReconciliationConfirmationDTO dto = new PurchaseReconciliationConfirmationDTO();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)dto);
        String elsAccount = dto.getElsAccount();
        dto.setElsAccount(dto.getToElsAccount());
        dto.setToElsAccount(elsAccount);
        List<PurchaseVoucherItemDTO> voucherItemList = this.purchaseVoucherItemRpcService.saleSelectConfirmVoucher(dto);
        BigDecimal taxAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(voucherItemList)) {
            for (PurchaseVoucherItemDTO purchaseVoucherItemDTO : voucherItemList) {
                boolean flag;
                BigDecimal dtoTaxAmount = purchaseVoucherItemDTO.getTaxAmount() == null ? BigDecimal.ZERO : purchaseVoucherItemDTO.getTaxAmount();
                if (BigDecimal.ZERO.compareTo(dtoTaxAmount) == 0) continue;
                boolean bl = flag = "1".equals(purchaseVoucherItemDTO.getConfirmStatus()) && !StringUtils.isEmpty((CharSequence)vo.getPreparedByNumber()) && !vo.getPreparedByNumber().equals(purchaseVoucherItemDTO.getConfirmNumber());
                if (flag) continue;
                businessNumbers.add(purchaseVoucherItemDTO.getVoucherNumber());
                if ("-".equals(purchaseVoucherItemDTO.getLoanDirection())) {
                    taxAmount = taxAmount.subtract(dtoTaxAmount);
                    continue;
                }
                if (!"+".equals(purchaseVoucherItemDTO.getLoanDirection())) continue;
                taxAmount = taxAmount.add(dtoTaxAmount);
            }
        }
        PurchaseReconciliationConfirmationUnpaidAccount confirmationUnpaidAccount = new PurchaseReconciliationConfirmationUnpaidAccount();
        confirmationUnpaidAccount.setUnpaidAccountItem(ConfirmUnpaidAccountItemStatusEnum.UN_RECONCILATION.getValue());
        confirmationUnpaidAccount.setPreparationConfirmAmount(taxAmount);
        String businessNumbersStr = String.join((CharSequence)",", businessNumbers);
        confirmationUnpaidAccount.setBusinessNumbers(businessNumbersStr);
        result.add(confirmationUnpaidAccount);
    }

    private void asyBalance(List<SaleReconciliationConfirmationBookBalance> balanceList) {
        HashMap<String, SaleReconciliationConfirmationBookBalance> balanceMap = new HashMap<String, SaleReconciliationConfirmationBookBalance>();
        if (CollectionUtils.isEmpty(balanceList)) {
            return;
        }
        Set balanceIds = balanceList.stream().filter(balance -> !StringUtils.isEmpty((CharSequence)balance.getRelationId())).map(SaleReconciliationConfirmationBookBalance::getRelationId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(balanceIds)) {
            return;
        }
        List purchaseBalanceList = this.purchaseReconciliationConfirmationBookBalanceMapper.selectBatchIds(balanceIds);
        if (CollectionUtils.isEmpty((Collection)purchaseBalanceList)) {
            return;
        }
        for (SaleReconciliationConfirmationBookBalance saleReconciliationConfirmationBookBalance : balanceList) {
            balanceMap.put(saleReconciliationConfirmationBookBalance.getRelationId(), saleReconciliationConfirmationBookBalance);
        }
        for (PurchaseReconciliationConfirmationBookBalance purchaseReconciliationConfirmationBookBalance : purchaseBalanceList) {
            SaleReconciliationConfirmationBookBalance saleBalance = (SaleReconciliationConfirmationBookBalance)((Object)balanceMap.get(purchaseReconciliationConfirmationBookBalance.getId()));
            if (saleBalance == null) continue;
            purchaseReconciliationConfirmationBookBalance.setDifferenceAmount(saleBalance.getDifferenceAmount());
            purchaseReconciliationConfirmationBookBalance.setOpponentConfirmAmount(saleBalance.getOpponentConfirmAmount());
        }
        this.purchaseReconciliationConfirmationBookBalanceService.updateBatchById(purchaseBalanceList);
    }

    private void asyUnpaidAccount(List<SaleReconciliationConfirmationUnpaidAccount> unpaidAccountList) {
        HashMap<String, SaleReconciliationConfirmationUnpaidAccount> unpaidAccountMap = new HashMap<String, SaleReconciliationConfirmationUnpaidAccount>();
        if (CollectionUtils.isEmpty(unpaidAccountList)) {
            return;
        }
        Set unpaidAccountIds = unpaidAccountList.stream().filter(balance -> !StringUtils.isEmpty((CharSequence)balance.getRelationId())).map(SaleReconciliationConfirmationUnpaidAccount::getRelationId).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(unpaidAccountIds)) {
            return;
        }
        List purchaseUnpaidAccountList = this.purchaseReconciliationConfirmationUnpaidAccountMapper.selectBatchIds(unpaidAccountIds);
        if (CollectionUtils.isEmpty((Collection)purchaseUnpaidAccountList)) {
            return;
        }
        for (SaleReconciliationConfirmationUnpaidAccount saleReconciliationConfirmationUnpaidAccount : unpaidAccountList) {
            unpaidAccountMap.put(saleReconciliationConfirmationUnpaidAccount.getRelationId(), saleReconciliationConfirmationUnpaidAccount);
        }
        for (PurchaseReconciliationConfirmationUnpaidAccount purchaseReconciliationConfirmationUnpaidAccount : purchaseUnpaidAccountList) {
            SaleReconciliationConfirmationUnpaidAccount saleUnpaidAccount = (SaleReconciliationConfirmationUnpaidAccount)((Object)unpaidAccountMap.get(purchaseReconciliationConfirmationUnpaidAccount.getId()));
            if (saleUnpaidAccount == null) continue;
            purchaseReconciliationConfirmationUnpaidAccount.setDifferenceAmount(saleUnpaidAccount.getDifferenceAmount());
            purchaseReconciliationConfirmationUnpaidAccount.setOpponentConfirmAmount(saleUnpaidAccount.getOpponentConfirmAmount());
        }
        this.purchaseReconciliationConfirmationUnpaidAccountService.updateBatchById(purchaseUnpaidAccountList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> publish(SaleReconciliationConfirmation confirmation, SaleReconciliationConfirmationVO vo) {
        SaleReconciliationConfirmation dbReconciliation = (SaleReconciliationConfirmation)((Object)this.getById((Serializable)((Object)confirmation.getId())));
        if (dbReconciliation != null && ReconciliationConfirmStatusEnum.UNCONFIRMED.getValue().equals(dbReconciliation.getPreparedByStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APzExqhxVXVtFzE_64c0f41", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u53d1\u5e03\uff0c\u8bf7\u5237\u65b0\u5355\u636e\u72b6\u6001"));
        }
        Boolean flag = false;
        if (ReconciliationConfirmStatusEnum.UNCONFIRMEDS.getValue().equals(confirmation.getPreparedByStatus()) && StringUtils.isNotBlank((CharSequence)confirmation.getRelationId())) {
            flag = true;
        }
        confirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.UNCONFIRMED.getValue());
        this.updateMain(confirmation, vo);
        this.invokeBaseRpcService.addStatusLog(confirmation.getRelationId(), confirmation.getPreparedByStatus(), "saleReconciliationConfirmation", "publish");
        String id = confirmation.getRelationId();
        PurchaseReconciliationConfirmation purchaseConfirmation = new PurchaseReconciliationConfirmation();
        BeanUtils.copyProperties((Object)((Object)confirmation), (Object)((Object)purchaseConfirmation));
        purchaseConfirmation.setElsAccount(confirmation.getToElsAccount());
        purchaseConfirmation.setToElsAccount(confirmation.getElsAccount());
        purchaseConfirmation.setRelationId(confirmation.getId());
        if (flag.booleanValue()) {
            purchaseConfirmation.setId(id);
            purchaseConfirmation.setPreparedByStatus(purchaseConfirmation.getPreparedByStatus());
            this.purchaseReconciliationConfirmationMapper.updateById((Object)purchaseConfirmation);
            this.handleDetail(purchaseConfirmation, vo);
        } else {
            purchaseConfirmation.setId(id);
            this.purchaseReconciliationConfirmationMapper.insert((Object)purchaseConfirmation);
            this.handleDetail(purchaseConfirmation, vo);
            confirmation.setRelationId(purchaseConfirmation.getId());
        }
        this.sendMessage(confirmation, purchaseConfirmation);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_hxLRW_c95760c0", (String)"\u53d1\u5e03\u6210\u529f\uff01"));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SaleReconciliationConfirmation confirmation, SaleReconciliationConfirmationVO vo) {
        this.buildReconciliationConfirmation(confirmation);
        this.saleReconciliationConfirmationMapper.insert((Object)confirmation);
        this.insertReconciliationConfirmationBookBalance(confirmation, vo.getBalance());
        this.insertReconciliationConfirmationDifferenceDescription(confirmation, vo.getDifferenceDescription());
        this.insertReconciliationConfirmationUnpaidAccount(confirmation, vo.getUnpaidAccountItem());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SaleReconciliationConfirmation confirmation, SaleReconciliationConfirmationVO vo) {
        if ("0".equals(confirmation.getSign())) {
            confirmation.setElectronicSignStatus(ConfirmElectronicSignStatusEmun.NO_NEED_INITIATE.getValue());
            confirmation.setSignStatus(ConfirmEsignStatusEnum.NO_NEED_START.getValue());
        } else if ("1".equals(confirmation.getSign())) {
            confirmation.setElectronicSignStatus(ConfirmElectronicSignStatusEmun.NO_START.getValue());
            confirmation.setSignStatus(ConfirmEsignStatusEnum.NO_START.getValue());
        }
        this.saleReconciliationConfirmationMapper.updateById((Object)confirmation);
        this.saleReconciliationConfirmationBookBalanceMapper.deleteByMainId(confirmation.getId());
        this.saleReconciliationConfirmationUnpaidAccountMapper.deleteByMainId(confirmation.getId());
        this.saleReconciliationConfirmationDifferenceDescriptionMapper.deleteByMainId(confirmation.getId());
        List<SaleReconciliationConfirmationUnpaidAccount> unpaidAccountItem = vo.getUnpaidAccountItem();
        if (!CollectionUtils.isEmpty(unpaidAccountItem)) {
            for (SaleReconciliationConfirmationUnpaidAccount account : unpaidAccountItem) {
                String businessNumber = account.getBusinessNumbers();
                if (StringUtils.isEmpty((CharSequence)businessNumber)) continue;
                List<String> businessNumbers = Arrays.asList(businessNumber.split(","));
                String preparedByNumber = vo.getPreparedByNumber();
                if (ConfirmUnpaidAccountItemStatusEnum.UN_RECONCILATION.getValue().equals(account.getUnpaidAccountItem())) {
                    this.purchaseVoucherItemRpcService.updateConfirmStatusByConfirmNumber(businessNumbers, preparedByNumber, "1");
                    continue;
                }
                if (!ConfirmUnpaidAccountItemStatusEnum.RECONCILATIONED.getValue().equals(account.getUnpaidAccountItem())) continue;
                this.purchaseReconciliationMapper.updateConfirmStatusByConfirmNumber(businessNumbers, preparedByNumber, "1");
                this.purchasePerformanceReconciliationMapper.updateConfirmStatusByConfirmNumber(businessNumbers, preparedByNumber, "1");
            }
        }
        this.insertReconciliationConfirmationBookBalance(confirmation, vo.getBalance());
        this.insertReconciliationConfirmationDifferenceDescription(confirmation, vo.getDifferenceDescription());
        this.insertReconciliationConfirmationUnpaidAccount(confirmation, vo.getUnpaidAccountItem());
    }

    private void releaseConfirmStatus(List<String> businessNumbers) {
        this.purchaseReconciliationMapper.updateConfirmStatusByConfirmNumber(businessNumbers, null, "0");
        this.purchasePerformanceReconciliationMapper.updateConfirmStatusByConfirmNumber(businessNumbers, null, "0");
        this.purchaseVoucherItemRpcService.updateConfirmStatusByConfirmNumber(businessNumbers, null, "0");
    }

    @Override
    public void emailConfirmOrRefuesd(String id, String operation) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BaseEntity::getId, (Object)id);
        SaleReconciliationConfirmation saleReconciliationConfirmation = (SaleReconciliationConfirmation)((Object)this.getOne((Wrapper)lambdaQueryWrapper));
        if (saleReconciliationConfirmation != null) {
            this.confirmOrRefused(saleReconciliationConfirmation, operation);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void createDifference(SaleReconciliationConfirmationVO vo) {
        List<SaleReconciliationConfirmationBookBalance> balanceList = vo.getBalance();
        if (CollectionUtils.isEmpty(balanceList)) {
            return;
        }
        this.saleReconciliationConfirmationDifferenceDescriptionMapper.deleteByMainId(vo.getId());
        ArrayList<SaleReconciliationConfirmationDifferenceDescription> descriptionList = new ArrayList<SaleReconciliationConfirmationDifferenceDescription>();
        for (SaleReconciliationConfirmationBookBalance balance : balanceList) {
            SaleReconciliationConfirmationDifferenceDescription description = new SaleReconciliationConfirmationDifferenceDescription();
            if (balance.getDifferenceAmount().compareTo(BigDecimal.ZERO) == 0) continue;
            if (balance.getDifferenceAmount().compareTo(BigDecimal.ZERO) > 0) {
                description.setAccountAdjustmentDirection("0");
            } else if (balance.getDifferenceAmount().compareTo(BigDecimal.ZERO) < 0) {
                description.setAccountAdjustmentDirection("1");
            }
            description.setDifferenceDate(new Date());
            description.setDifferencePayment(balance.getCurrentBalance());
            description.setDifferenceAmount(balance.getDifferenceAmount());
            descriptionList.add(description);
        }
        SaleReconciliationConfirmation confirmation = new SaleReconciliationConfirmation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)confirmation));
        this.insertReconciliationConfirmationDifferenceDescription(confirmation, descriptionList);
    }

    private void handleMessage(SaleReconciliationConfirmation confirmation, String opt, PurchaseReconciliationConfirmation purchaseConfirmation) {
        String serviceAddress = (String)this.staticConfig.getConfig().get("service.address");
        confirmation.setFbk10(serviceAddress + "/srm/reconciliation/sale/saleReconciliationConfirmation?id=" + confirmation.getId() + "&open=true");
        if (!StringUtils.isEmpty((CharSequence)opt) && purchaseConfirmation != null) {
            super.sendMessage(confirmation.getBusAccount(), "saleReconciliationConfirmation", opt, confirmation.getId(), "reconciliationConfirmationBusDataServiceImpl", Arrays.asList(confirmation.getElsAccount()));
            super.sendMessage(confirmation.getBusAccount(), "purchaseReconciliationConfirmation", opt, confirmation.getId(), "reconciliationConfirmationBusDataServiceImpl", Arrays.asList(confirmation.getToElsAccount()));
        }
    }

    private void buildReconciliationConfirmation(SaleReconciliationConfirmation confirmation) {
        ElsEnterpriseInfoDTO enterpriseInfo;
        String nextCode = this.invokeBaseRpcService.getNextCode("salePreparedByNumber", (Object)confirmation);
        confirmation.setPreparedByNumber(nextCode);
        confirmation.setPreparedByStatus(ReconciliationConfirmStatusEnum.NEW.getValue());
        confirmation.setBusAccount(confirmation.getToElsAccount());
        TemplateHeadDTO templateHead = this.templateHeadService.getById(confirmation.getTemplateNumber());
        if (templateHead != null) {
            confirmation.setTemplateName(templateHead.getTemplateName());
            confirmation.setTemplateNumber(templateHead.getTemplateNumber());
            confirmation.setTemplateVersion(templateHead.getTemplateVersion() + "");
            confirmation.setTemplateAccount(templateHead.getElsAccount());
        }
        if ((enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(TenantContext.getTenant())) != null) {
            confirmation.setSupplierName(enterpriseInfo.getName());
            confirmation.setElsAccountName(enterpriseInfo.getName());
        }
        if ((enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(confirmation.getToElsAccount())) != null) {
            confirmation.setSupplierName(enterpriseInfo.getName());
            confirmation.setElsAccountName(enterpriseInfo.getName());
        }
        confirmation.setRelationId(IdWorker.getIdStr());
        confirmation.setCreateAccount(TenantContext.getTenant());
        if ("0".equals(confirmation.getSign())) {
            confirmation.setElectronicSignStatus(ConfirmElectronicSignStatusEmun.NO_NEED_INITIATE.getValue());
            confirmation.setSignStatus(ConfirmEsignStatusEnum.NO_NEED_START.getValue());
        } else if ("1".equals(confirmation.getSign())) {
            confirmation.setElectronicSignStatus(ConfirmElectronicSignStatusEmun.NO_START.getValue());
            confirmation.setSignStatus(ConfirmEsignStatusEnum.NO_START.getValue());
        }
    }

    private void insertReconciliationConfirmationBookBalance(SaleReconciliationConfirmation confirmation, List<SaleReconciliationConfirmationBookBalance> balanceList) {
        if (CollectionUtils.isEmpty(balanceList)) {
            return;
        }
        for (SaleReconciliationConfirmationBookBalance entity : balanceList) {
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)confirmation);
            BigDecimal bookBalance = entity.getBookBalance() == null ? BigDecimal.ZERO : entity.getBookBalance();
            BigDecimal opponentConfirmAmount = entity.getOpponentConfirmAmount() == null ? BigDecimal.ZERO : entity.getOpponentConfirmAmount();
            entity.setHeadId(confirmation.getId());
            entity.setToElsAccount(confirmation.getToElsAccount());
            entity.setBusAccount(confirmation.getBusAccount());
            if (StringUtils.isEmpty((CharSequence)confirmation.getElsAccount()) || confirmation.getElsAccount().equals(confirmation.getCreateAccount())) continue;
            BigDecimal result = bookBalance.subtract(opponentConfirmAmount);
            entity.setDifferenceAmount(result);
        }
        if (!CollectionUtils.isEmpty(balanceList)) {
            this.saleReconciliationConfirmationBookBalanceMapper.insertBatchSomeColumn(balanceList);
        }
    }

    private void insertReconciliationConfirmationUnpaidAccount(SaleReconciliationConfirmation confirmation, List<SaleReconciliationConfirmationUnpaidAccount> unpaidAccountList) {
        if (CollectionUtils.isEmpty(unpaidAccountList)) {
            return;
        }
        for (SaleReconciliationConfirmationUnpaidAccount entity : unpaidAccountList) {
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)confirmation);
            BigDecimal preparationConfirmAmount = entity.getPreparationConfirmAmount() == null ? BigDecimal.ZERO : entity.getPreparationConfirmAmount();
            BigDecimal opponentConfirmAmount = entity.getOpponentConfirmAmount() == null ? BigDecimal.ZERO : entity.getOpponentConfirmAmount();
            entity.setHeadId(confirmation.getId());
            entity.setToElsAccount(confirmation.getToElsAccount());
            entity.setBusAccount(confirmation.getBusAccount());
            if (StringUtils.isEmpty((CharSequence)confirmation.getElsAccount()) || confirmation.getElsAccount().equals(confirmation.getCreateAccount())) continue;
            BigDecimal result = preparationConfirmAmount.subtract(opponentConfirmAmount);
            entity.setDifferenceAmount(result);
        }
        if (!CollectionUtils.isEmpty(unpaidAccountList)) {
            this.saleReconciliationConfirmationUnpaidAccountMapper.insertBatchSomeColumn(unpaidAccountList);
        }
    }

    private void insertReconciliationConfirmationDifferenceDescription(SaleReconciliationConfirmation confirmation, List<SaleReconciliationConfirmationDifferenceDescription> descriptionList) {
        if (CollectionUtils.isEmpty(descriptionList)) {
            return;
        }
        for (SaleReconciliationConfirmationDifferenceDescription entity : descriptionList) {
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)confirmation);
            entity.setHeadId(confirmation.getId());
            entity.setToElsAccount(confirmation.getToElsAccount());
            entity.setBusAccount(confirmation.getBusAccount());
        }
        if (!CollectionUtils.isEmpty(descriptionList)) {
            this.saleReconciliationConfirmationDifferenceDescriptionMapper.insertBatchSomeColumn(descriptionList);
        }
    }

    private void handleDetail(PurchaseReconciliationConfirmation confirmation, SaleReconciliationConfirmationVO vo) {
        List<SaleReconciliationConfirmationBookBalance> saleReconciliationConfirmationBookBalanceList = vo.getBalance();
        List<SaleReconciliationConfirmationUnpaidAccount> saleReconciliationConfirmationUnpaidAccountList = vo.getUnpaidAccountItem();
        List<SaleReconciliationConfirmationDifferenceDescription> saleReconciliationConfirmationDifferenceDescriptionList = vo.getDifferenceDescription();
        List<SaleAttachmentDTO> attachments = vo.getAttachments();
        this.purchaseReconciliationConfirmationBookBalanceMapper.deleteByMainId(confirmation.getId());
        this.purchaseReconciliationConfirmationUnpaidAccountMapper.deleteByMainId(confirmation.getId());
        this.purchaseReconciliationConfirmationDifferenceDescriptionMapper.deleteByMainId(confirmation.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(confirmation.getId());
        this.handlePurchaseReconciliationConfirmationBookBalance(confirmation, saleReconciliationConfirmationBookBalanceList);
        this.handlePurchaseReconciliationConfirmationUnpaidAccount(confirmation, saleReconciliationConfirmationUnpaidAccountList);
        this.handlePurchaseReconciliationConfirmationDifferenceDescription(confirmation, saleReconciliationConfirmationDifferenceDescriptionList);
        this.handlePurchaseAttachmentDetail(confirmation, attachments);
    }

    private void handlePurchaseReconciliationConfirmationBookBalance(PurchaseReconciliationConfirmation confirmation, List<SaleReconciliationConfirmationBookBalance> balanceList) {
        if (CollectionUtils.isEmpty(balanceList)) {
            return;
        }
        ArrayList<PurchaseReconciliationConfirmationBookBalance> purchaseBalanceList = new ArrayList<PurchaseReconciliationConfirmationBookBalance>();
        for (SaleReconciliationConfirmationBookBalance saleBalance : balanceList) {
            PurchaseReconciliationConfirmationBookBalance purchaseBookBalance = new PurchaseReconciliationConfirmationBookBalance();
            BeanUtils.copyProperties((Object)((Object)saleBalance), (Object)((Object)purchaseBookBalance));
            purchaseBookBalance.setId(null);
            purchaseBookBalance.setElsAccount(confirmation.getElsAccount());
            purchaseBookBalance.setToElsAccount(confirmation.getToElsAccount());
            purchaseBookBalance.setHeadId(confirmation.getId());
            purchaseBookBalance.setRelationId(saleBalance.getId());
            purchaseBalanceList.add(purchaseBookBalance);
        }
        this.purchaseReconciliationConfirmationBookBalanceMapper.insertBatchSomeColumn(purchaseBalanceList);
    }

    private void handlePurchaseReconciliationConfirmationUnpaidAccount(PurchaseReconciliationConfirmation confirmation, List<SaleReconciliationConfirmationUnpaidAccount> unpaidAccountList) {
        if (CollectionUtils.isEmpty(unpaidAccountList)) {
            return;
        }
        ArrayList<PurchaseReconciliationConfirmationUnpaidAccount> purchaseUnpaidAccountList = new ArrayList<PurchaseReconciliationConfirmationUnpaidAccount>();
        for (SaleReconciliationConfirmationUnpaidAccount unpaidAccount : unpaidAccountList) {
            PurchaseReconciliationConfirmationUnpaidAccount purchaseUnpaidAccount = new PurchaseReconciliationConfirmationUnpaidAccount();
            BeanUtils.copyProperties((Object)((Object)unpaidAccount), (Object)((Object)purchaseUnpaidAccount));
            purchaseUnpaidAccount.setId(null);
            purchaseUnpaidAccount.setElsAccount(confirmation.getElsAccount());
            purchaseUnpaidAccount.setToElsAccount(confirmation.getToElsAccount());
            purchaseUnpaidAccount.setHeadId(confirmation.getId());
            purchaseUnpaidAccount.setRelationId(unpaidAccount.getId());
            purchaseUnpaidAccountList.add(purchaseUnpaidAccount);
        }
        this.purchaseReconciliationConfirmationUnpaidAccountMapper.insertBatchSomeColumn(purchaseUnpaidAccountList);
    }

    private void handlePurchaseReconciliationConfirmationDifferenceDescription(PurchaseReconciliationConfirmation confirmation, List<SaleReconciliationConfirmationDifferenceDescription> saleDescriptionList) {
        if (CollectionUtils.isEmpty(saleDescriptionList)) {
            return;
        }
        ArrayList<PurchaseReconciliationConfirmationDifferenceDescription> purchaseDescriptionList = new ArrayList<PurchaseReconciliationConfirmationDifferenceDescription>();
        for (SaleReconciliationConfirmationDifferenceDescription description : saleDescriptionList) {
            PurchaseReconciliationConfirmationDifferenceDescription purchaseDescription = new PurchaseReconciliationConfirmationDifferenceDescription();
            BeanUtils.copyProperties((Object)((Object)description), (Object)((Object)purchaseDescription));
            purchaseDescription.setId(null);
            purchaseDescription.setElsAccount(confirmation.getElsAccount());
            purchaseDescription.setToElsAccount(confirmation.getToElsAccount());
            purchaseDescription.setHeadId(confirmation.getId());
            purchaseDescription.setRelationId(description.getId());
            purchaseDescriptionList.add(purchaseDescription);
        }
        this.purchaseReconciliationConfirmationDifferenceDescriptionMapper.insertBatchSomeColumn(purchaseDescriptionList);
    }

    private void handlePurchaseAttachmentDetail(PurchaseReconciliationConfirmation confirmation, List<SaleAttachmentDTO> attachments) {
        if (CollectionUtils.isEmpty(attachments)) {
            return;
        }
        ArrayList<PurchaseAttachmentDTO> purchaseAttachments = new ArrayList<PurchaseAttachmentDTO>();
        for (SaleAttachmentDTO saleAttachment : attachments) {
            saleAttachment.setSendStatus("1");
            PurchaseAttachmentDTO purchaseAttachment = new PurchaseAttachmentDTO();
            BeanUtils.copyProperties((Object)saleAttachment, (Object)purchaseAttachment);
            purchaseAttachment.setId(null);
            purchaseAttachment.setElsAccount(confirmation.getElsAccount());
            purchaseAttachment.setHeadId(confirmation.getId());
            purchaseAttachment.setRelationId(saleAttachment.getId());
            purchaseAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
            purchaseAttachments.add(purchaseAttachment);
        }
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachments);
    }

    private void sendMessage(SaleReconciliationConfirmation confirmation, PurchaseReconciliationConfirmation purchaseReconciliationConfirmation) {
        super.sendMessage(confirmation.getElsAccount(), "saleReconciliationConfirmation", "publish", confirmation.getId(), "reconciliationConfirmationBusDataServiceImpl", Arrays.asList(confirmation.getToElsAccount()));
    }
}

