/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.reconciliation.entity.PurchaseRecCharge;
import com.els.modules.reconciliation.mapper.PurchaseRecChargeMapper;
import com.els.modules.reconciliation.service.PurchaseRecChargeService;
import com.els.modules.reconciliation.vo.PurchasePerformanceReconciliationVO;
import com.els.modules.reconciliation.vo.PurchaseReconciliationVO;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class PurchaseRecChargeServiceImpl
extends ServiceImpl<PurchaseRecChargeMapper, PurchaseRecCharge>
implements PurchaseRecChargeService {
    @Resource
    private PurchaseRecChargeMapper purchaseRecChargeMapper;

    @Override
    public List<PurchaseRecCharge> selectByMainId(String mainId) {
        return this.purchaseRecChargeMapper.selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        this.purchaseRecChargeMapper.deleteByMainId(mainId);
    }

    @Override
    public void checkReconcilationCharge(PurchaseReconciliationVO purchaseReconciliationVO) {
        List<PurchaseRecCharge> recChargeList = purchaseReconciliationVO.getRecChargeList();
        if (CollectionUtil.isEmpty(recChargeList)) {
            return;
        }
        Set<String> voucherNumbers = recChargeList.stream().map(PurchaseRecCharge::getVoucherNumber).collect(Collectors.toSet());
        List<PurchaseRecCharge> items = this.purchaseRecChargeMapper.checkHasReconcilationed(voucherNumbers);
        List<PurchaseRecCharge> resultList = this.getIntersection(recChargeList, items);
        if (CollectionUtil.isEmpty(resultList)) {
            return;
        }
        String reconciliationNumber = purchaseReconciliationVO.getReconciliationNumber();
        if (CollectionUtil.isEmpty(resultList = resultList.stream().filter(item -> !item.getReconciliationNumber().contains(reconciliationNumber)).collect(Collectors.toList()))) {
            return;
        }
        List<PurchaseRecCharge> sourceList = this.getIntersection(resultList, recChargeList);
        Optional optional = sourceList.stream().findFirst();
        if (optional.isPresent()) {
            PurchaseRecCharge purchaseRecCharge = (PurchaseRecCharge)((Object)optional.get());
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VVRHWTyWWWWWIhxIeWVQG_d3c7fd99", (String)"\u6263\u6b3e\u660e\u7ec6 \u5e8f\u53f7${0} \u5df2\u53d1\u5e03\u5bf9\u8d26\uff0c\u8bf7\u5220\u9664", (String[])new String[]{purchaseRecCharge.getItemNumber()}));
        }
    }

    private List<PurchaseRecCharge> getIntersection(List<PurchaseRecCharge> targetList, List<PurchaseRecCharge> sourceList) {
        return sourceList.stream().filter(item -> targetList.stream().map(PurchaseRecCharge::getVoucherNumber).collect(Collectors.toList()).contains(item.getVoucherNumber())).collect(Collectors.toList());
    }

    @Override
    public void checkPerformanceReconcilationCharge(PurchasePerformanceReconciliationVO reconciliationVO) {
        List<PurchaseRecCharge> recChargeList = reconciliationVO.getRecChargeList();
        if (CollectionUtil.isEmpty(recChargeList)) {
            return;
        }
        Set<String> voucherNumbers = recChargeList.stream().map(PurchaseRecCharge::getVoucherNumber).collect(Collectors.toSet());
        List<PurchaseRecCharge> items = this.purchaseRecChargeMapper.checkHasPerformanceReconcilationed(voucherNumbers);
        List<PurchaseRecCharge> resultList = this.getIntersection(recChargeList, items);
        if (CollectionUtil.isEmpty(resultList)) {
            return;
        }
        String reconciliationNumber = reconciliationVO.getReconciliationNumber();
        if (CollectionUtil.isEmpty(resultList = resultList.stream().filter(item -> !item.getReconciliationNumber().contains(reconciliationNumber)).collect(Collectors.toList()))) {
            return;
        }
        List<PurchaseRecCharge> sourceList = this.getIntersection(resultList, recChargeList);
        Optional optional = sourceList.stream().findFirst();
        if (optional.isPresent()) {
            PurchaseRecCharge purchaseRecCharge = (PurchaseRecCharge)((Object)optional.get());
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VVRHWTyWWWWWIhxIeWVQG_d3c7fd99", (String)"\u6263\u6b3e\u660e\u7ec6 \u5e8f\u53f7${0} \u5df2\u53d1\u5e03\u5bf9\u8d26\uff0c\u8bf7\u5220\u9664", (String[])new String[]{purchaseRecCharge.getItemNumber()}));
        }
    }
}

