/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.controller;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.finance.entity.PurchasePaymentApplyHead;
import com.els.modules.finance.entity.PurchasePaymentPlanHead;
import com.els.modules.finance.entity.PurchasePaymentPlanItem;
import com.els.modules.finance.service.PurchasePaymentPlanHeadService;
import com.els.modules.finance.service.PurchasePaymentPlanItemService;
import com.els.modules.finance.vo.PurchasePaymentPlanHeadVO;
import com.els.modules.finance.vo.PurchasePaymentPlanReconciliationVO;
import com.els.modules.rebate.rpc.SupplierLocalRpcService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/finance/purchasePaymentPlanHead"})
@Api(tags={"\u8d44\u91d1\u8ba1\u5212\u8868"})
public class PurchasePaymentPlanHeadController
extends BaseController<PurchasePaymentPlanHead, PurchasePaymentPlanHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchasePaymentPlanHeadController.class);
    @Autowired
    private PurchasePaymentPlanHeadService purchasePaymentPlanHeadService;
    @Autowired
    private PurchasePaymentPlanItemService purchasePaymentPlanItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SupplierLocalRpcService supplierLocalRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"finance#purchasePaymentPlanHead:list"})
    @PermissionDataView(businessType="paymentPlan")
    public Result<?> queryPageList(PurchasePaymentPlanHead purchasePaymentPlanHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchasePaymentPlanHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchasePaymentPlanHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"finance#purchasePaymentPlanHead:list"})
    @PermissionDataView(businessType="paymentPlan")
    public Result<?> queryTabsCount(PurchasePaymentPlanHead purchasePaymentPlanHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchasePaymentPlanHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"payment_plan_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"payment_plan_status");
        List list = ((PurchasePaymentPlanHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchasePaymentPlanHead::getPaymentPlanStatus, PurchasePaymentPlanHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "paymentPlanStatus", null, all));
        List srmDeliveryStatus = this.invokeBaseRpcService.queryDictItemsByCode("paymentPlanStatus", TenantContext.getTenant());
        for (DictDTO status : srmDeliveryStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "paymentPlanStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2-\u884c\u660e\u7ec6", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2-\u884c\u660e\u7ec6")
    @GetMapping(value={"/itemList"})
    @RequiresPermissions(value={"finance#purchasePaymentPlanHead:list"})
    public Result<?> itemList(PurchasePaymentPlanItem purchasePaymentPlanItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchasePaymentPlanItem), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchasePaymentPlanItemService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u67e5\u8be2\u5e93\u5b58\u5bf9\u8d26\u7ba1\u7406\u3001\u5c65\u7ea6\u5bf9\u8d26\u7ba1\u7406\u6570\u636e", notes="\u67e5\u8be2\u5e93\u5b58\u5bf9\u8d26\u7ba1\u7406\u3001\u5c65\u7ea6\u5bf9\u8d26\u7ba1\u7406\u6570\u636e")
    @GetMapping(value={"/selectPerformanceReconciliationList"})
    @RequiresPermissions(value={"finance#purchasePaymentPlanHead:list"})
    public Result<?> selectPerformanceReconciliationList(PurchasePaymentPlanReconciliationVO purchasePaymentPlanReconciliationVO, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchasePaymentPlanReconciliationVO), (Map)req.getParameterMap());
        List<PurchasePaymentPlanReconciliationVO> pageList = this.purchasePaymentPlanItemService.selectPerformanceReconciliationList((QueryWrapper<PurchasePaymentPlanReconciliationVO>)queryWrapper);
        this.setAcceptanceDenominationVal(pageList);
        return Result.ok(pageList);
    }

    @SrmValidated
    @AutoLog(busModule="\u8d44\u91d1\u8ba1\u5212\u8868", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"finance#purchasePaymentPlanHead:add"})
    @PermissionDataOpt(businessType="paymentPlan", beanClass=PurchasePaymentPlanHeadService.class)
    public Result<?> add(@RequestBody PurchasePaymentPlanHeadVO purchasePaymentPlanHeadPage) {
        PurchasePaymentPlanHead purchasePaymentPlanHead = new PurchasePaymentPlanHead();
        BeanUtils.copyProperties((Object)((Object)purchasePaymentPlanHeadPage), (Object)((Object)purchasePaymentPlanHead));
        this.purchasePaymentPlanHeadService.saveMain(purchasePaymentPlanHead, purchasePaymentPlanHeadPage.getPurchasePaymentPlanItemList());
        return Result.ok((Object)((Object)purchasePaymentPlanHead));
    }

    @SrmValidated
    @AutoLog(busModule="\u8d44\u91d1\u8ba1\u5212\u8868", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"finance#purchasePaymentPlanHead:edit"})
    @PermissionDataOpt(businessType="paymentPlan", beanClass=PurchasePaymentPlanHeadService.class)
    public Result<?> edit(@RequestBody PurchasePaymentPlanHeadVO purchasePaymentPlanHeadPage) {
        PurchasePaymentPlanHead purchasePaymentPlanHead = new PurchasePaymentPlanHead();
        BeanUtils.copyProperties((Object)((Object)purchasePaymentPlanHeadPage), (Object)((Object)purchasePaymentPlanHead));
        this.purchasePaymentPlanHeadService.updateMain(purchasePaymentPlanHead, purchasePaymentPlanHeadPage.getPurchasePaymentPlanItemList());
        return this.queryById(purchasePaymentPlanHead.getId());
    }

    @FormCommit
    @SrmValidated
    @AutoLog(busModule="\u8d44\u91d1\u8ba1\u5212\u8868", value="\u53d1\u5e03")
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"finance#purchasePaymentPlanHead:publish"})
    @PermissionDataOpt(businessType="paymentPlan", beanClass=PurchasePaymentPlanHeadService.class)
    public Result<?> publish(@RequestBody PurchasePaymentPlanHeadVO purchasePaymentPlanHeadPage) {
        PurchasePaymentPlanHead purchasePaymentPlanHead = new PurchasePaymentPlanHead();
        BeanUtils.copyProperties((Object)((Object)purchasePaymentPlanHeadPage), (Object)((Object)purchasePaymentPlanHead));
        this.purchasePaymentPlanHeadService.publish(purchasePaymentPlanHead, purchasePaymentPlanHeadPage.getPurchasePaymentPlanItemList());
        return this.commonSuccessResult(3);
    }

    @FormCommit
    @AutoLog(busModule="\u8d44\u91d1\u8ba1\u5212\u8868", value="\u521b\u5efa\u4ed8\u6b3e\u7533\u8bf7")
    @ApiOperation(value="\u521b\u5efa\u4ed8\u6b3e\u7533\u8bf7", notes="\u521b\u5efa\u4ed8\u6b3e\u7533\u8bf7")
    @PostMapping(value={"/addPaymentApply"})
    @RequiresPermissions(value={"finance#purchasePaymentPlanHead:addPaymentApply"})
    @PermissionDataOpt(businessType="paymentPlan", beanClass=PurchasePaymentPlanHeadService.class)
    public Result<?> addPaymentApply(@RequestBody PurchasePaymentPlanHeadVO purchasePaymentPlanHeadPage) {
        List<PurchasePaymentApplyHead> paymentApplyHeads = this.purchasePaymentPlanHeadService.addPaymentApply(purchasePaymentPlanHeadPage.getId(), purchasePaymentPlanHeadPage.getPurchasePaymentPlanItemList());
        return Result.ok(paymentApplyHeads);
    }

    @FormCommit
    @AutoLog(busModule="\u8d44\u91d1\u8ba1\u5212\u8868", value="\u89e3\u9664\u5ef6\u671f\u4ed8\u6b3e")
    @ApiOperation(value="\u89e3\u9664\u5ef6\u671f\u4ed8\u6b3e", notes="\u89e3\u9664\u5ef6\u671f\u4ed8\u6b3e")
    @PostMapping(value={"/releasePayment"})
    @RequiresPermissions(value={"finance#purchasePaymentPlanHead:releasePayment"})
    @PermissionDataOpt(businessType="paymentPlan", beanClass=PurchasePaymentPlanHeadService.class)
    public Result<?> releasePayment(@RequestBody PurchasePaymentPlanHeadVO purchasePaymentPlanHeadPage) {
        this.purchasePaymentPlanHeadService.releasePayment(purchasePaymentPlanHeadPage.getId(), purchasePaymentPlanHeadPage.getPurchasePaymentPlanItemList());
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u8d44\u91d1\u8ba1\u5212\u8868", value="\u901a\u8fc7id\u4f5c\u5e9f")
    @ApiOperation(value="\u901a\u8fc7id\u4f5c\u5e9f", notes="\u901a\u8fc7id\u4f5c\u5e9f")
    @GetMapping(value={"/invalid"})
    @RequiresPermissions(value={"finance#purchasePaymentPlanHead:invalid"})
    public Result<?> invalid(@RequestParam(name="id") String id) {
        this.purchasePaymentPlanHeadService.invalid(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u8d44\u91d1\u8ba1\u5212\u8868", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"finance#purchasePaymentPlanHead:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchasePaymentPlanHeadService.deleteMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u8d44\u91d1\u8ba1\u5212\u8868", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"finance#purchasePaymentPlanHead:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        this.purchasePaymentPlanHeadService.deleteBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"finance#purchasePaymentPlanHead:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        return Result.ok((Object)((Object)this.purchasePaymentPlanHeadService.queryById(id)));
    }

    private void setAcceptanceDenominationVal(List<PurchasePaymentPlanReconciliationVO> pageList) {
        List acceptanceDenominationList;
        List<String> toElsAccountList;
        if (CollUtil.isNotEmpty(pageList) && CollUtil.isNotEmpty(toElsAccountList = pageList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getToElsAccount())).map(PurchasePaymentPlanReconciliationVO::getToElsAccount).distinct().collect(Collectors.toList())) && CollUtil.isNotEmpty((Collection)(acceptanceDenominationList = this.invokeBaseRpcService.queryDictItemsByCode("acceptanceDenomination", TenantContext.getTenant())))) {
            List dictList = acceptanceDenominationList.stream().map(DictDTO::getValue).distinct().collect(Collectors.toList());
            List bigDecimalList = dictList.stream().map(BigDecimal::new).collect(Collectors.toList());
            List<SupplierMasterDataDTO> masterDataDTOList = this.supplierLocalRpcService.getSupplierMasterDataByAccountGroup(TenantContext.getTenant(), toElsAccountList);
            Map dataMap = masterDataDTOList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getToElsAccount, Function.identity(), (v1, v2) -> v2));
            for (PurchasePaymentPlanReconciliationVO vo : pageList) {
                Collections.sort(bigDecimalList);
                vo.setAcceptanceDenomination(String.valueOf(bigDecimalList.get(0)));
                SupplierMasterDataDTO dto = (SupplierMasterDataDTO)dataMap.get(vo.getToElsAccount());
                if (dto == null || dto.getAcceptanceDenomination() == null) continue;
                List bigDecimals = bigDecimalList.stream().filter(x -> x.compareTo(dto.getAcceptanceDenomination()) <= 0).collect(Collectors.toList());
                if (CollUtil.isNotEmpty(bigDecimals)) {
                    Collections.sort(bigDecimals);
                    BigDecimal val = bigDecimals.size() > 1 ? (BigDecimal)bigDecimals.get(bigDecimals.size() - 1) : (BigDecimal)bigDecimals.get(0);
                    vo.setAcceptanceDenomination(String.valueOf(val));
                    continue;
                }
                vo.setAcceptanceDenomination(String.valueOf(bigDecimalList.get(bigDecimalList.size() - 1)));
            }
        }
    }
}

