/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.finance.api.enumerate.AddCostConfirmStatusEnum;
import com.els.modules.finance.entity.PurchaseAddCost;
import com.els.modules.finance.entity.PurchaseAddCostItem;
import com.els.modules.finance.entity.SaleAddCost;
import com.els.modules.finance.entity.SaleAddCostItem;
import com.els.modules.finance.mapper.PurchaseAddCostItemMapper;
import com.els.modules.finance.mapper.PurchaseAddCostMapper;
import com.els.modules.finance.mapper.SaleAddCostItemMapper;
import com.els.modules.finance.service.PurchaseAddCostItemService;
import com.els.modules.finance.service.PurchaseAddCostService;
import com.els.modules.finance.service.PurchaseDeliveryWaterService;
import com.els.modules.finance.service.SaleAddCostItemService;
import com.els.modules.finance.service.SaleAddCostService;
import com.els.modules.finance.service.impl.SaleAddCostServiceImpl;
import com.els.modules.finance.vo.PurchaseAddCostVO;
import com.els.modules.reconciliation.api.dto.PurchaseDeliveryWaterDTO;
import com.els.modules.reconciliation.entity.PurchaseRecAdditionalCharges;
import com.els.modules.reconciliation.enumerate.ReconcilationItemTypeEmun;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseAddCostServiceImpl
extends BaseServiceImpl<PurchaseAddCostMapper, PurchaseAddCost>
implements PurchaseAddCostService {
    @Autowired
    private PurchaseDeliveryWaterService purchaseDeliveryWaterService;
    @Autowired
    private PurchaseAddCostItemService purchaseAddCostItemService;
    @Autowired
    private SaleAddCostItemService saleAddCostItemService;
    @Resource
    private PurchaseAddCostItemMapper purchaseAddCostItemMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SaleAddCostItemMapper saleAddCostItemMapper;

    @Override
    public void savePurchaseAddCost(PurchaseAddCostVO vo) {
        PurchaseAddCost purchaseAddCost = new PurchaseAddCost();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseAddCost));
        purchaseAddCost.setCreateAccount(purchaseAddCost.getElsAccount());
        if (StringUtils.isBlank((CharSequence)purchaseAddCost.getCostNumber())) {
            purchaseAddCost.setCostNumber(this.invokeBaseRpcService.getNextCode("srmAddCostNumber", (Object)purchaseAddCost));
        }
        this.calculatePrice(purchaseAddCost, vo.getAddCostItemList());
        purchaseAddCost.setBusAccount(TenantContext.getTenant());
        ((PurchaseAddCostMapper)this.baseMapper).insert((Object)purchaseAddCost);
        vo.setId(purchaseAddCost.getId());
        this.insertPurchaseAddCostItemList(purchaseAddCost, vo.getAddCostItemList());
    }

    @Override
    public void updatePurchaseAddCost(PurchaseAddCostVO vo) {
        PurchaseAddCost purchaseAddCost = new PurchaseAddCost();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseAddCost));
        purchaseAddCost.setCreateAccount(purchaseAddCost.getElsAccount());
        this.calculatePrice(purchaseAddCost, vo.getAddCostItemList());
        ((PurchaseAddCostMapper)this.baseMapper).updateById((Object)purchaseAddCost);
        this.purchaseAddCostItemService.deleteByMainId(purchaseAddCost.getId());
        if (CollectionUtils.isEmpty(vo.getAddCostItemList())) {
            return;
        }
        this.insertPurchaseAddCostItemList(purchaseAddCost, vo.getAddCostItemList());
    }

    private void calculatePrice(PurchaseAddCost addCost, List<PurchaseAddCostItem> purchaseAddCostItemList) {
        BigDecimal headTaxAmount = BigDecimal.ZERO;
        if (!CollectionUtil.isEmpty(purchaseAddCostItemList)) {
            for (PurchaseAddCostItem purchaseAddCostItem : purchaseAddCostItemList) {
                BigDecimal itemTaxAmount = purchaseAddCostItem.getTaxAmount() == null ? BigDecimal.ZERO : purchaseAddCostItem.getTaxAmount();
                headTaxAmount = headTaxAmount.add(itemTaxAmount);
            }
            addCost.setTaxAmount(headTaxAmount);
        }
        BigDecimal taxRate = addCost.getTaxRate() == null ? BigDecimal.ZERO : addCost.getTaxRate().divide(BigDecimal.valueOf(100L));
        BigDecimal taxAmount = addCost.getTaxAmount() == null ? BigDecimal.ZERO : addCost.getTaxAmount();
        BigDecimal netAmount = taxAmount.divide(BigDecimal.ONE.add(taxRate), 6, 4);
        addCost.setNetAmount(netAmount);
    }

    private void insertPurchaseAddCostItemList(PurchaseAddCost purchaseAddCost, List<PurchaseAddCostItem> purchaseAddCostItemList) {
        if (CollectionUtil.isEmpty(purchaseAddCostItemList)) {
            return;
        }
        for (PurchaseAddCostItem purchaseAddCostItem : purchaseAddCostItemList) {
            purchaseAddCostItem.setId(null);
            purchaseAddCostItem.setHeadId(purchaseAddCost.getId());
            purchaseAddCostItem.setToElsAccount(purchaseAddCost.getToElsAccount());
            SysUtil.setSysParam((BaseEntity)purchaseAddCostItem, (BaseEntity)purchaseAddCost);
        }
        this.purchaseAddCostItemService.saveBatch(purchaseAddCostItemList);
    }

    @Override
    public void publish(PurchaseAddCostVO vo) {
        PurchaseAddCost purchaseAddCost = new PurchaseAddCost();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseAddCost));
        if (purchaseAddCost.getTaxAmount() == null || BigDecimal.ZERO.compareTo(purchaseAddCost.getTaxAmount()) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_BuujRHcxfHflTfUW_cd0e11bb", (String)"\u9644\u52a0\u8d39\u7528\u660e\u7ec6\u884c\u542b\u7a0e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0"));
        }
        purchaseAddCost.setConfirmStatus(AddCostConfirmStatusEnum.ALREADY_CONFIRM.getValue());
        SaleAddCost saleAddCost = new SaleAddCost();
        BeanUtils.copyProperties((Object)((Object)purchaseAddCost), (Object)((Object)saleAddCost));
        String relationId = IdWorker.getIdStr();
        purchaseAddCost.setRelationId(relationId);
        saleAddCost.setId(relationId);
        saleAddCost.setRelationId(purchaseAddCost.getId());
        saleAddCost.setElsAccount(purchaseAddCost.getToElsAccount());
        saleAddCost.setToElsAccount(purchaseAddCost.getElsAccount());
        saleAddCost.setBusAccount(purchaseAddCost.getElsAccount());
        this.updateById((Object)purchaseAddCost);
        SaleAddCostService saleAddCostService = (SaleAddCostService)SpringContextUtils.getBean(SaleAddCostServiceImpl.class);
        saleAddCostService.updateById((Object)saleAddCost);
        saleAddCostService.save((Object)saleAddCost);
        this.handleSaleAttachmentDetail(saleAddCost, vo.getPurchaseAttachmentList());
        this.handleSaleAddItem(saleAddCost, vo.getAddCostItemList());
    }

    private void handleSaleAddItem(SaleAddCost saleAddCost, List<PurchaseAddCostItem> costItems) {
        if (CollectionUtils.isEmpty(costItems)) {
            return;
        }
        ArrayList<SaleAddCostItem> saleAddCostItemList = new ArrayList<SaleAddCostItem>();
        for (PurchaseAddCostItem addCostItem : costItems) {
            SaleAddCostItem saleAddCostItem = new SaleAddCostItem();
            BeanUtils.copyProperties((Object)((Object)addCostItem), (Object)((Object)saleAddCostItem));
            saleAddCostItem.setId(null);
            saleAddCostItem.setElsAccount(saleAddCost.getElsAccount());
            saleAddCostItem.setToElsAccount(saleAddCost.getToElsAccount());
            saleAddCostItem.setBusAccount(saleAddCost.getBusAccount());
            saleAddCostItem.setHeadId(saleAddCost.getId());
            saleAddCostItem.setRelationId(addCostItem.getId());
            saleAddCostItemList.add(saleAddCostItem);
        }
        this.saleAddCostItemMapper.insertBatchSomeColumn(saleAddCostItemList);
    }

    private void handleSaleAttachmentDetail(SaleAddCost saleAddCost, List<PurchaseAttachmentDTO> attachments) {
        if (CollectionUtils.isEmpty(attachments)) {
            return;
        }
        ArrayList<SaleAttachmentDTO> saleAttachments = new ArrayList<SaleAttachmentDTO>();
        for (PurchaseAttachmentDTO purchaseAttachment : attachments) {
            purchaseAttachment.setSendStatus("1");
            SaleAttachmentDTO saleAttachment = new SaleAttachmentDTO();
            BeanUtils.copyProperties((Object)purchaseAttachment, (Object)saleAttachment);
            saleAttachment.setId(null);
            saleAttachment.setElsAccount(saleAddCost.getElsAccount());
            saleAttachment.setHeadId(saleAddCost.getId());
            saleAttachment.setRelationId(purchaseAttachment.getId());
            saleAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
            saleAttachments.add(saleAttachment);
        }
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachments);
    }

    @Override
    public void delPurchaseAddCost(String id) {
        ((PurchaseAddCostMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.purchaseAddCostItemService.deleteByMainId(id);
    }

    @Override
    public void delBatchPurchaseAddCost(List<String> idList) {
        ((PurchaseAddCostMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void replyAddCost(PurchaseAddCost purchaseAddCost, List<PurchaseAddCostItem> addCostItemList) {
        Set ids;
        List saleAddCostItems;
        String relationId = purchaseAddCost.getRelationId();
        SaleAddCost saleAddCost = new SaleAddCost();
        saleAddCost.setId(relationId);
        saleAddCost.setConfirmStatus(purchaseAddCost.getConfirmStatus());
        saleAddCost.setRejectReason(purchaseAddCost.getRejectReason());
        SaleAddCostService saleAddCostService = (SaleAddCostService)SpringContextUtils.getBean(SaleAddCostServiceImpl.class);
        saleAddCostService.updateById((Object)saleAddCost);
        this.updateById((Object)purchaseAddCost);
        PurchaseAddCost byId = (PurchaseAddCost)((Object)this.getById((Serializable)((Object)purchaseAddCost.getId())));
        HashMap<String, PurchaseAddCostItem> map = new HashMap<String, PurchaseAddCostItem>();
        for (PurchaseAddCostItem purchaseAddCostItem : addCostItemList) {
            if (StringUtils.isEmpty((CharSequence)purchaseAddCostItem.getRelationId())) continue;
            map.put(purchaseAddCostItem.getRelationId(), purchaseAddCostItem);
            purchaseAddCostItem.setReplyTime(new Date());
        }
        this.purchaseAddCostItemService.updateBatchById(addCostItemList);
        if (!CollectionUtils.isEmpty(map) && !CollectionUtils.isEmpty((Collection)(saleAddCostItems = this.saleAddCostItemService.listByIds(ids = map.keySet())))) {
            for (SaleAddCostItem saleAddCostItem : saleAddCostItems) {
                PurchaseAddCostItem purchaseAddCostItem = (PurchaseAddCostItem)((Object)map.get(saleAddCostItem.getId()));
                if (purchaseAddCostItem == null) continue;
                saleAddCostItem.setReplyTime(purchaseAddCostItem.getReplyTime());
                saleAddCostItem.setReply(purchaseAddCostItem.getReply());
            }
            this.saleAddCostItemService.updateBatchById(saleAddCostItems);
        }
        if (AddCostConfirmStatusEnum.ALREADY_CONFIRM.getValue().equals(purchaseAddCost.getConfirmStatus())) {
            PurchaseDeliveryWaterDTO purchaseDeliveryWater = new PurchaseDeliveryWaterDTO();
            BeanUtils.copyProperties((Object)((Object)byId), (Object)purchaseDeliveryWater);
            if (!ObjectUtils.isEmpty((Object)purchaseDeliveryWater)) {
                purchaseDeliveryWater.setDocumentNumber(byId.getCostNumber());
                purchaseDeliveryWater.setTotalAmount(byId.getTaxAmount());
                purchaseDeliveryWater.setTotalNonTaxAmount(byId.getNetAmount());
                purchaseDeliveryWater.setCompany(byId.getCompany());
                purchaseDeliveryWater.setToElsAccount(byId.getToElsAccount());
                purchaseDeliveryWater.setDocumentCategory("2");
                purchaseDeliveryWater.setDocumentStatus("\u5df2\u786e\u8ba4");
                purchaseDeliveryWater.setDocumentType("2");
                purchaseDeliveryWater.setReconciliationNumber(byId.getReconciliationNumber());
                purchaseDeliveryWater.setId(null);
                this.purchaseDeliveryWaterService.insert(purchaseDeliveryWater);
            }
        }
        super.sendMessage(byId.getElsAccount(), "addCost", "reply", byId.getId(), "addCostBusDataServiceImpl", Arrays.asList(byId.getToElsAccount()));
    }

    @Override
    public List<PurchaseAddCost> listPurchaseAddCost(ReconciliationVO reconciliationVO, String elsAccount) {
        QueryWrapper addCostWapper = new QueryWrapper();
        addCostWapper.eq((Object)"els_account", (Object)elsAccount);
        addCostWapper.eq((Object)"to_els_account", (Object)reconciliationVO.getToElsAccount());
        addCostWapper.eq((Object)"company", (Object)reconciliationVO.getCompany());
        addCostWapper.ge((Object)"cost_time", (Object)reconciliationVO.getBeginDate());
        addCostWapper.le((Object)"cost_time", (Object)reconciliationVO.getEndDate());
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getTaxCode())) {
            addCostWapper.eq((Object)"tax_code", (Object)reconciliationVO.getTaxCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getCurrency())) {
            addCostWapper.eq((Object)"currency", (Object)reconciliationVO.getCurrency());
        }
        addCostWapper.eq((Object)"confirm_status", (Object)AddCostConfirmStatusEnum.ALREADY_CONFIRM.getValue());
        addCostWapper.and(q -> ((QueryWrapper)((QueryWrapper)q.isNull((Object)"cost_status")).or()).eq((Object)"cost_status", (Object)"0"));
        return this.list((Wrapper)addCostWapper);
    }

    @Override
    public List<PurchaseRecAdditionalCharges> getByPurchaseAddCost(ReconciliationVO reconciliationVO, String elsAccount) {
        List<PurchaseAddCost> purchaseAddCosts = this.listPurchaseAddCost(reconciliationVO, elsAccount);
        ArrayList<PurchaseRecAdditionalCharges> additionalCharges = new ArrayList<PurchaseRecAdditionalCharges>();
        if (CollectionUtils.isEmpty(purchaseAddCosts)) {
            return null;
        }
        for (PurchaseAddCost purchaseAddCost : purchaseAddCosts) {
            PurchaseRecAdditionalCharges charges = new PurchaseRecAdditionalCharges();
            BeanUtils.copyProperties((Object)((Object)purchaseAddCost), (Object)((Object)charges));
            charges.setVoucherNumber(purchaseAddCost.getCostNumber());
            charges.setBusinessType(purchaseAddCost.getCostType());
            charges.setTotalAmount(purchaseAddCost.getTaxAmount());
            charges.setTotalNonTaxAmount(purchaseAddCost.getNetAmount());
            charges.setSource(purchaseAddCost.getSourceType());
            charges.setBusinessId(purchaseAddCost.getId());
            charges.setItemType(ReconcilationItemTypeEmun.ADDITIONAL_CHARGES.getValue());
            charges.setDocumentParentId(purchaseAddCost.getId());
            charges.setId(null);
            additionalCharges.add(charges);
        }
        return additionalCharges;
    }

    @Override
    public JSONObject getRequestDataById(String id) {
        PurchaseAddCostVO purchaseAddCostVO = this.getMessageById(id);
        Result result = Result.ok((Object)((Object)purchaseAddCostVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }

    @Override
    public JSONArray getRequestDataById(List<String> ids) {
        ArrayList headVOArrayList = new ArrayList();
        ids.forEach(id -> headVOArrayList.add(this.getMessageById((String)id)));
        Result result = Result.ok(headVOArrayList);
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONArray)result.getResult();
    }

    @Override
    public List<PurchaseAddCost> checkHasReconciliation(Set<String> voucherNumbers) {
        if (CollectionUtil.isEmpty(voucherNumbers)) {
            return new ArrayList<PurchaseAddCost>();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(PurchaseAddCost::getCostNumber, voucherNumbers);
        return this.list((Wrapper)queryWrapper);
    }

    private PurchaseAddCostVO getMessageById(String id) {
        PurchaseAddCost purchaseAddCost = (PurchaseAddCost)((Object)this.getById((Serializable)((Object)id)));
        PurchaseAddCostVO purchaseAddCostVO = new PurchaseAddCostVO();
        BeanUtils.copyProperties((Object)((Object)purchaseAddCost), (Object)((Object)purchaseAddCostVO));
        List<PurchaseAddCostItem> purchaseAddCostItemList = this.purchaseAddCostItemMapper.selectByMainId(id);
        purchaseAddCostVO.setAddCostItemList(purchaseAddCostItemList);
        return purchaseAddCostVO;
    }
}

