/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.finance.entity.PurchasePaymentApplyHead;
import com.els.modules.finance.entity.PurchasePaymentApplyItem;
import com.els.modules.finance.entity.PurchasePaymentPlanHead;
import com.els.modules.finance.entity.PurchasePaymentPlanItem;
import com.els.modules.finance.enumerate.PaymentPlanStatusEnum;
import com.els.modules.finance.mapper.PurchasePaymentPlanHeadMapper;
import com.els.modules.finance.rpc.PurchasePaymentPlanWorkFlowRpcService;
import com.els.modules.finance.service.PurchasePaymentApplyHeadService;
import com.els.modules.finance.service.PurchasePaymentPlanHeadService;
import com.els.modules.finance.service.PurchasePaymentPlanItemService;
import com.els.modules.finance.vo.PurchasePaymentApplyHeadVO;
import com.els.modules.finance.vo.PurchasePaymentPlanHeadVO;
import com.els.modules.finance.vo.PurchasePaymentPlanItemVO;
import com.els.modules.reconciliation.service.PurchasePerformanceReconciliationService;
import com.els.modules.reconciliation.service.PurchaseReconciliationService;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class PurchasePaymentPlanHeadServiceImpl
extends BaseServiceImpl<PurchasePaymentPlanHeadMapper, PurchasePaymentPlanHead>
implements PurchasePaymentPlanHeadService {
    @Resource
    private PurchasePaymentPlanItemService purchasePaymentPlanItemService;
    @Resource
    private PurchaseReconciliationService purchaseReconciliationService;
    @Resource
    private PurchasePerformanceReconciliationService purchasePerformanceReconciliationService;
    @Resource
    private PurchasePaymentApplyHeadService purchasePaymentApplyHeadService;
    @Resource
    private InvokeBaseRpcService baseRpcService;
    @Resource
    private PurchasePaymentPlanWorkFlowRpcService purchasePaymentPlanWorkFlowRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchasePaymentPlanHead purchasePaymentPlanHead, List<PurchasePaymentPlanItem> purchasePaymentPlanItemList) {
        if (StringUtils.isBlank((CharSequence)purchasePaymentPlanHead.getPaymentPlanIssue())) {
            String currentPaymentPlanIssue = this.getCurrentPaymentPlanIssue();
            purchasePaymentPlanHead.setPaymentPlanIssue(currentPaymentPlanIssue);
        }
        this.checkPaymentPlanIssueCount(purchasePaymentPlanHead, "0");
        if (StringUtils.isBlank((CharSequence)purchasePaymentPlanHead.getPaymentPlanNumber())) {
            purchasePaymentPlanHead.setPaymentPlanNumber(this.baseRpcService.getNextCode("paymentPlanNumber", (Object)purchasePaymentPlanHead));
        }
        if (StringUtils.isBlank((CharSequence)purchasePaymentPlanHead.getPaymentPlanStatus())) {
            purchasePaymentPlanHead.setPaymentPlanStatus(PaymentPlanStatusEnum.CREATE.getValue());
        }
        if ("1".equals(purchasePaymentPlanHead.getAudit())) {
            purchasePaymentPlanHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchasePaymentPlanHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        super.setHeadDefaultValue((BaseEntity)purchasePaymentPlanHead);
        this.calculateAmount(purchasePaymentPlanHead, purchasePaymentPlanItemList);
        this.setDefaultVal(purchasePaymentPlanItemList);
        ((PurchasePaymentPlanHeadMapper)this.baseMapper).insert((Object)purchasePaymentPlanHead);
        this.insertData(purchasePaymentPlanHead, purchasePaymentPlanItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchasePaymentPlanHead purchasePaymentPlanHead, List<PurchasePaymentPlanItem> purchasePaymentPlanItemList) {
        if (StringUtils.isBlank((CharSequence)purchasePaymentPlanHead.getPaymentPlanIssue())) {
            String currentPaymentPlanIssue = this.getCurrentPaymentPlanIssue();
            purchasePaymentPlanHead.setPaymentPlanIssue(currentPaymentPlanIssue);
        }
        this.checkPaymentPlanIssueCount(purchasePaymentPlanHead, "1");
        this.calculateAmount(purchasePaymentPlanHead, purchasePaymentPlanItemList);
        if ("1".equals(purchasePaymentPlanHead.getAudit())) {
            purchasePaymentPlanHead.setAuditStatus(StringUtils.isBlank((CharSequence)purchasePaymentPlanHead.getAuditStatus()) ? AuditStatusEnum.AUDIT_NEW.getValue() : purchasePaymentPlanHead.getAuditStatus());
        } else {
            purchasePaymentPlanHead.setAuditStatus(StringUtils.isBlank((CharSequence)purchasePaymentPlanHead.getAuditStatus()) ? AuditStatusEnum.NO_AUDIT_REQUIRED.getValue() : purchasePaymentPlanHead.getAuditStatus());
        }
        this.setDefaultVal(purchasePaymentPlanItemList);
        int count = ((PurchasePaymentPlanHeadMapper)this.baseMapper).updateById((Object)purchasePaymentPlanHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.insertData(purchasePaymentPlanHead, purchasePaymentPlanItemList);
    }

    private void checkPaymentPlanIssueCount(PurchasePaymentPlanHead purchasePaymentPlanHead, String status) {
        if (StringUtils.isNotBlank((CharSequence)purchasePaymentPlanHead.getPaymentPlanIssue())) {
            PurchasePaymentPlanHead head;
            List list = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).eq((Object)"payment_plan_issue", (Object)purchasePaymentPlanHead.getPaymentPlanIssue()));
            if ("0".equals(status) && CollUtil.isNotEmpty((Collection)list)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IMKdejJHtEAm_15bd03ae", (String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u8d44\u91d1\u8ba1\u5212\u671f\u6b21"));
            }
            if ("1".equals(status) && CollUtil.isNotEmpty((Collection)list) && !(head = (PurchasePaymentPlanHead)((Object)list.get(0))).getId().equals(purchasePaymentPlanHead.getId())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IMKdejJHtEAm_15bd03ae", (String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u8d44\u91d1\u8ba1\u5212\u671f\u6b21"));
            }
        }
    }

    private String getCurrentPaymentPlanIssue() {
        LocalDate currentDate = LocalDate.now();
        LocalDate firstDayOfMonth = currentDate.withDayOfMonth(1);
        LocalDate lastDayOfMonth = currentDate.withDayOfMonth(currentDate.lengthOfMonth());
        LocalDateTime startOfMonth = LocalDateTime.of(firstDayOfMonth, LocalTime.MIN);
        LocalDateTime endOfMonth = LocalDateTime.of(lastDayOfMonth, LocalTime.MAX);
        String startTimeStr = LocalDateTimeUtil.format((LocalDateTime)startOfMonth, (DateTimeFormatter)DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String endTimeStr = LocalDateTimeUtil.format((LocalDateTime)endOfMonth, (DateTimeFormatter)DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        int count = this.count((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).eq((Object)"payment_plan_status", (Object)PaymentPlanStatusEnum.PUBLISHED.getValue())).le((Object)"create_time", (Object)startTimeStr)).ge((Object)"create_time", (Object)endTimeStr));
        String paymentPlanIssue = DateUtil.format((Date)new Date(), (String)"yyyyMM").concat("-").concat(String.format("%02d", count + 1));
        return paymentPlanIssue;
    }

    private void insertData(PurchasePaymentPlanHead purchasePaymentPlanHead, List<PurchasePaymentPlanItem> purchasePaymentPlanItemList) {
        if (CollUtil.isNotEmpty(purchasePaymentPlanItemList)) {
            for (PurchasePaymentPlanItem entity : purchasePaymentPlanItemList) {
                entity.setHeadId(purchasePaymentPlanHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchasePaymentPlanHead);
            }
            this.purchasePaymentPlanItemService.saveOrUpdateBatch(purchasePaymentPlanItemList, 2000);
        }
    }

    private void calculateAmount(PurchasePaymentPlanHead head, List<PurchasePaymentPlanItem> itemList) {
        if (CollUtil.isNotEmpty(itemList)) {
            BigDecimal settlementAmount = itemList.stream().filter(it -> it.getSettlementAmount() != null).map(PurchasePaymentPlanItem::getSettlementAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal cashAmount = itemList.stream().filter(it -> it.getCashAmount() != null).map(PurchasePaymentPlanItem::getCashAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal endorseAmount = itemList.stream().filter(it -> it.getEndorseAmount() != null).map(PurchasePaymentPlanItem::getEndorseAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal acceptanceAmount = itemList.stream().filter(it -> it.getAcceptanceAmount() != null).map(PurchasePaymentPlanItem::getAcceptanceAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal paymentAmount = itemList.stream().filter(it -> it.getPaymentAmount() != null).map(PurchasePaymentPlanItem::getPaymentAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            head.setTotalSettlementAmount(settlementAmount);
            head.setTotalCashAmount(cashAmount);
            head.setTotalAcceptanceAmount(endorseAmount);
            head.setTotalEndorseAmount(acceptanceAmount);
            head.setTotalPaymentAmount(paymentAmount);
        }
    }

    private void setDefaultVal(List<PurchasePaymentPlanItem> purchasePaymentPlanItemList) {
        if (CollUtil.isNotEmpty(purchasePaymentPlanItemList)) {
            purchasePaymentPlanItemList.forEach(x -> {
                if (x.getSettlementAmount() != null && x.getEndorseAmount() != null && x.getAcceptanceAmount() != null) {
                    BigDecimal val = x.getSettlementAmount().subtract(x.getEndorseAmount()).subtract(x.getAcceptanceAmount());
                    x.setSettlementAmount(val);
                }
                if (x.getPaymentBenchmarkDate() != null && x.getPaymentExpiredate() == null) {
                    Date paymentExpiredate = x.getPaymentExpiredate();
                    x.setPaymentExpiredate(paymentExpiredate);
                }
                if (x.getPaymentBenchmarkDate() != null && x.getPayCycle() != null && x.getPaymentExpiredate() == null) {
                    x.setPaymentExpiredate((Date)DateUtil.offsetDay((Date)x.getPaymentExpiredate(), (int)x.getPayCycle().intValue()));
                }
                if ("1".equals(x.getPaymentDelay()) && x.getPaymentExpiredate() != null && x.getPaymentDelayDays() != null) {
                    x.setPaymentDelayDate((Date)DateUtil.offsetDay((Date)x.getPaymentExpiredate(), (int)x.getPaymentDelayDays().intValue()));
                }
            });
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void publish(PurchasePaymentPlanHead purchasePaymentPlanHead, List<PurchasePaymentPlanItem> purchasePaymentPlanItemList) {
        if ("1".equals(purchasePaymentPlanHead.getAudit())) {
            AuditInputParamDTO dto = new AuditInputParamDTO();
            dto.setBusinessId(purchasePaymentPlanHead.getId());
            dto.setBusinessType("paymentPlan");
            dto.setAuditSubject(I18nUtil.translate((String)"i18n_alert_JHtEUzty0_d23f1ac6", (String)"\u8d44\u91d1\u8ba1\u5212\u5ba1\u6279\uff0c\u5355\u53f7\uff1a${0}", (String[])new String[]{purchasePaymentPlanHead.getPaymentPlanNumber()}));
            dto.setParams(JSONObject.toJSONString((Object)((Object)this.queryById(purchasePaymentPlanHead.getId()))));
            this.purchasePaymentPlanWorkFlowRpcService.submit(dto);
            this.setReconciliationPaymentPlan(purchasePaymentPlanItemList, "1");
        } else {
            purchasePaymentPlanHead.setPaymentPlanStatus(PaymentPlanStatusEnum.PUBLISHED.getValue());
            int count = ((PurchasePaymentPlanHeadMapper)this.baseMapper).updateById((Object)purchasePaymentPlanHead);
            Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
            this.setReconciliationPaymentPlan(purchasePaymentPlanItemList, "1");
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public List<PurchasePaymentApplyHead> addPaymentApply(String headId, List<PurchasePaymentPlanItem> purchasePaymentPlanItemList) {
        List<PurchasePaymentApplyHead> applyHeads = new ArrayList<PurchasePaymentApplyHead>();
        ArrayList<String> paymentApplyIds = new ArrayList<String>();
        PurchasePaymentPlanHead planHead = (PurchasePaymentPlanHead)((Object)this.getById((Serializable)((Object)headId)));
        if (CollUtil.isNotEmpty(purchasePaymentPlanItemList) && !ObjectUtils.isEmpty((Object)((Object)planHead))) {
            Map<String, List<PurchasePaymentPlanItem>> listMap = purchasePaymentPlanItemList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getToElsAccount())).collect(Collectors.groupingBy(PurchasePaymentPlanItem::getToElsAccount));
            List headDTOList = this.baseRpcService.getDefaultTemplateByType("paymentApply");
            Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)headDTOList), (String)I18nUtil.translate((String)"", (String)"\u8bf7\u8bbe\u7f6e\u4ed8\u6b3e\u7533\u8bf7\u4e1a\u52a1\u6a21\u677f\uff01"));
            PurchasePaymentApplyHeadVO applyHeadVO = new PurchasePaymentApplyHeadVO();
            for (String toElsAccount : listMap.keySet()) {
                List<PurchasePaymentPlanItem> itemList = listMap.get(toElsAccount);
                PurchasePaymentApplyHead applyHead = new PurchasePaymentApplyHead();
                applyHead.setId(IdWorker.getIdStr());
                applyHead.setTemplateAccount(((TemplateHeadDTO)headDTOList.get(0)).getElsAccount());
                applyHead.setTemplateNumber(((TemplateHeadDTO)headDTOList.get(0)).getTemplateNumber());
                applyHead.setTemplateName(((TemplateHeadDTO)headDTOList.get(0)).getTemplateName());
                applyHead.setTemplateVersion(String.valueOf(((TemplateHeadDTO)headDTOList.get(0)).getTemplateVersion()));
                applyHead.setElsAccount(planHead.getElsAccount());
                applyHead.setToElsAccount(toElsAccount);
                applyHead.setSupplierName(itemList.get(0).getSupplierName());
                applyHead.setCompany(planHead.getCompany());
                applyHead.setPurchaseOrg(planHead.getPurchaseOrg());
                applyHead.setCurrency(planHead.getCurrencyCode());
                applyHead.setStandardCoin(planHead.getStandardMoneyCode());
                applyHead.setExchangeRate(planHead.getExchangeRate());
                applyHead.setPayAmount(planHead.getTotalPaymentAmount());
                applyHead.setClosingAmount(planHead.getTotalSettlementAmount());
                applyHead.setPaymentApplyNumber(this.baseRpcService.getNextCode("srmApplyNumber", (Object)applyHead));
                ArrayList<PurchasePaymentApplyItem> applyItemList = new ArrayList<PurchasePaymentApplyItem>();
                for (PurchasePaymentPlanItem planItem : itemList) {
                    PurchasePaymentApplyItem applyItem = new PurchasePaymentApplyItem();
                    applyItem.setHeadId(applyHead.getId());
                    applyItem.setPaymentApplyNumber(applyHead.getPaymentApplyNumber());
                    applyItem.setElsAccount(planItem.getElsAccount());
                    applyItem.setPaymentStatus("0");
                    applyItem.setSourceSystem("srm");
                    applyItem.setSourceType("paymentPlan");
                    applyItem.setSourceNumber(planHead.getPaymentPlanNumber());
                    applyItem.setSourceId(planItem.getId());
                    applyItem.setPayWay(planItem.getPayWay());
                    applyItem.setPaymentClause(planItem.getPaymentClause());
                    applyItem.setPaymentBenchmarkDate(planItem.getPaymentBenchmarkDate());
                    applyItem.setSourcePaidAmount(planItem.getPaymentAmount());
                    applyItem.setPayAmount(planItem.getPaymentAmount());
                    applyItem.setClosingAmount(planItem.getSettlementAmount());
                    applyItemList.add(applyItem);
                }
                BeanUtils.copyProperties((Object)((Object)applyHead), (Object)((Object)applyHeadVO));
                applyHeadVO.setPaymentApplyItemList(applyItemList);
                this.purchasePaymentApplyHeadService.saveMain(applyHead, applyHeadVO);
                paymentApplyIds.add(applyHead.getId());
            }
        }
        if (CollUtil.isNotEmpty(paymentApplyIds)) {
            applyHeads = this.purchasePaymentApplyHeadService.listByIds(paymentApplyIds);
        }
        return applyHeads;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void releasePayment(String headId, List<PurchasePaymentPlanItem> purchasePaymentPlanItemList) {
        Assert.isTrue((boolean)CollUtil.isNotEmpty(purchasePaymentPlanItemList), (String)I18nUtil.translate((String)"i18n_alert_yGjcWFLVxOyG_5527e876", (String)"\u89e3\u9664\u7684\u884c\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u89e3\u9664"));
        List idList = purchasePaymentPlanItemList.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchasePaymentPlanItemService.lambdaUpdate().in(BaseEntity::getId, idList)).set(PurchasePaymentPlanItem::getPaymentDelay, (Object)"0")).set(PurchasePaymentPlanItem::getPaymentDelayDays, null)).set(PurchasePaymentPlanItem::getPaymentDelayDate, null)).update();
        this.setReconciliationPaymentPlan(purchasePaymentPlanItemList, "0");
    }

    @Override
    public PurchasePaymentPlanHeadVO queryById(String id) {
        PurchasePaymentPlanHeadVO purchaseFundPlanHeadVO = new PurchasePaymentPlanHeadVO();
        PurchasePaymentPlanHead purchasePaymentPlanHead = (PurchasePaymentPlanHead)((Object)this.getById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)purchasePaymentPlanHead), (Object)((Object)purchaseFundPlanHeadVO));
        List<PurchasePaymentPlanItem> purchasePaymentPlanItemList = this.purchasePaymentPlanItemService.selectByMainId(id);
        purchaseFundPlanHeadVO.setPurchasePaymentPlanItemList(purchasePaymentPlanItemList);
        return purchaseFundPlanHeadVO;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void invalid(String id) {
        PurchasePaymentPlanHead head = (PurchasePaymentPlanHead)((Object)this.getById((Serializable)((Object)id)));
        if (ObjectUtils.isEmpty((Object)((Object)head))) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_YxuIdjnRWF_ceeb2a8c", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u91c7\u8d2d\u6570\u636e"));
        }
        head.setPaymentPlanStatus(PaymentPlanStatusEnum.INVALID.getValue());
        this.updateById((Object)head);
        List<PurchasePaymentPlanItem> itemList = this.purchasePaymentPlanItemService.selectByMainId(id);
        this.setReconciliationPaymentPlan(itemList, "0");
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updatePaymentPlanItem(String paymentApplyStatus, List<PurchasePaymentApplyItem> applyItemList) {
        if (CollUtil.isNotEmpty(applyItemList)) {
            applyItemList = applyItemList.stream().filter(x -> "paymentPlan".equals(x.getSourceType())).collect(Collectors.toList());
            List paymentPlanNumberList = applyItemList.stream().map(PurchasePaymentApplyItem::getSourceNumber).distinct().collect(Collectors.toList());
            if (CollUtil.isNotEmpty(applyItemList)) {
                ArrayList<PurchasePaymentPlanItem> itemList = new ArrayList<PurchasePaymentPlanItem>();
                for (PurchasePaymentApplyItem applyItem : applyItemList) {
                    PurchasePaymentPlanItem item = new PurchasePaymentPlanItem();
                    item.setId(applyItem.getSourceId());
                    item.setPaymentStatus("2".equals(applyItem.getPaymentStatus()) ? applyItem.getPaymentStatus() : "1");
                    item.setPaymentApplyStatus(paymentApplyStatus);
                    item.setPaymentApplyNumber(applyItem.getPaymentApplyNumber());
                    itemList.add(item);
                }
                this.purchasePaymentPlanItemService.updateBatchById(itemList);
            }
            if (CollUtil.isNotEmpty(paymentPlanNumberList)) {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.in((Object)"payment_plan_number", paymentPlanNumberList);
                List list = this.list((Wrapper)wrapper);
                if (CollUtil.isNotEmpty((Collection)list)) {
                    List idList = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
                    QueryWrapper wrapperItem = new QueryWrapper();
                    wrapperItem.in((Object)"head_id", idList);
                    List listItem = this.purchasePaymentPlanItemService.list((Wrapper)wrapperItem);
                    Map<String, List<PurchasePaymentPlanItem>> listMap = listItem.stream().collect(Collectors.groupingBy(PurchasePaymentPlanItem::getHeadId));
                    ArrayList<PurchasePaymentPlanHead> updateList = new ArrayList<PurchasePaymentPlanHead>();
                    for (PurchasePaymentPlanHead head : list) {
                        List<PurchasePaymentPlanItem> itemList = listMap.get(head.getId());
                        long paid = itemList.stream().filter(it -> "2".equals(it.getPaymentStatus())).count();
                        head.setPaymentPlanStatus(PaymentPlanStatusEnum.EXECUTING.getValue());
                        if (paid == (long)list.size()) {
                            head.setPaymentPlanStatus(PaymentPlanStatusEnum.FINISHED.getValue());
                        }
                        if (PaymentPlanStatusEnum.isCreateAndInvalid(head.getPaymentPlanStatus())) continue;
                        updateList.add(head);
                    }
                    if (CollUtil.isNotEmpty(updateList)) {
                        this.updateBatchById(updateList);
                    }
                }
            }
        }
    }

    public void setReconciliationPaymentPlan(List<PurchasePaymentPlanItem> itemList, String paymentPlan) {
        List list;
        List promiseReconciliation;
        List list2;
        List stockReconciliationList = itemList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getSourceNumber()) && "stockReconciliation".equals(x.getSourceType())).map(PurchasePaymentPlanItem::getSourceNumber).distinct().collect(Collectors.toList());
        if (CollUtil.isNotEmpty(stockReconciliationList) && CollUtil.isNotEmpty((Collection)(list2 = this.purchaseReconciliationService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).in((Object)"reconciliation_number", stockReconciliationList))))) {
            List idList = list2.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseReconciliationService.lambdaUpdate().in(BaseEntity::getId, idList)).set((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPaymentPlan(), (Lcom/els/modules/reconciliation/entity/PurchaseReconciliation;)Ljava/lang/Object;)(), (Object)paymentPlan)).update();
        }
        if (CollUtil.isNotEmpty(promiseReconciliation = itemList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getSourceNumber()) && "promiseReconciliation".equals(x.getSourceType())).map(PurchasePaymentPlanItem::getSourceNumber).distinct().collect(Collectors.toList())) && CollUtil.isNotEmpty((Collection)(list = this.purchasePerformanceReconciliationService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).in((Object)"reconciliation_number", promiseReconciliation))))) {
            List idList = list.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchasePerformanceReconciliationService.lambdaUpdate().in(BaseEntity::getId, idList)).set((Object)(SFunction & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getPaymentPlan(), (Lcom/els/modules/reconciliation/entity/PurchasePerformanceReconciliation;)Ljava/lang/Object;)(), (Object)paymentPlan)).update();
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.purchasePaymentPlanItemService.deleteByMainId(id);
        ((PurchasePaymentPlanHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchasePaymentPlanItemService.deleteByMainId(serializable.toString());
            ((PurchasePaymentPlanHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public IPage<PurchasePaymentPlanItemVO> selectPlanReconciliationPage(Page<PurchasePaymentPlanItemVO> page, QueryWrapper<PurchasePaymentPlanItemVO> queryWrapper) {
        return this.purchasePaymentPlanItemService.selectPlanReconciliationPage(page, queryWrapper);
    }
}

