/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rebate.adapter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.MqUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheet;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetCalculateDetail;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetCertificate;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRegister;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRuleDetail;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRuleSupplement;
import com.els.modules.rebate.entity.PurchaseRebateCalculationSheetRuleThreshold;
import com.els.modules.rebate.enumerate.CalculationRebateCalculateResultEnum;
import com.els.modules.rebate.mapper.PurchaseRebateCalculationSheetMapper;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetCalculateDetailService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetCertificateService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetRegisterService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetRuleDetailService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetRuleSupplementService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetRuleThresholdService;
import com.els.modules.rebate.service.PurchaseRebateCalculationSheetService;
import com.els.modules.rebate.vo.PurchaseRebateCalculationSheetVO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PurchaseRebateCalculationSheetAuditOptCallBackServiceImpl
implements AuditOptCallBackService {
    @Resource
    private PurchaseRebateCalculationSheetMapper purchaseRebateCalculationSheetMapper;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Autowired
    private PurchaseRebateCalculationSheetService purchaseRebateCalculationSheetService;
    @Autowired
    private PurchaseRebateCalculationSheetCalculateDetailService purchaseRebateCalculationSheetCalculateDetailService;
    @Autowired
    private PurchaseRebateCalculationSheetCertificateService purchaseRebateCalculationSheetCertificateService;
    @Autowired
    private PurchaseRebateCalculationSheetRegisterService purchaseRebateCalculationSheetRegisterService;
    @Autowired
    private PurchaseRebateCalculationSheetRuleDetailService purchaseRebateCalculationSheetRuleDetailService;
    @Autowired
    private PurchaseRebateCalculationSheetRuleThresholdService purchaseRebateCalculationSheetRuleThresholdService;
    @Autowired
    private PurchaseRebateCalculationSheetRuleSupplementService purchaseRebateCalculationSheetRuleSupplementService;

    public void startCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        String params = StringUtils.isNotBlank((CharSequence)inputParamVO.getParams()) ? inputParamVO.getParams() : "{}";
        PurchaseRebateCalculationSheet headVO = (PurchaseRebateCalculationSheet)((Object)JSON.parseObject((String)params, PurchaseRebateCalculationSheet.class));
        this.updateStatus(inputParamVO, outputParamVO);
        PurchaseRebateCalculationSheetVO vo = (PurchaseRebateCalculationSheetVO)((Object)JSONObject.parseObject((String)params, PurchaseRebateCalculationSheetVO.class));
        PurchaseRebateCalculationSheet sheet = new PurchaseRebateCalculationSheet();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)sheet));
        String calculateResult = sheet.getCalculateResult();
        if (!CalculationRebateCalculateResultEnum.CALCULATED_SUCCESS.getValue().equals(calculateResult)) {
            throw new ELSBootException("\u8fd4\u5229\u5355\u8ba1\u7b97\u6210\u529f\u624d\u53ef\u63d0\u5ba1");
        }
        BigDecimal rebateAmount = sheet.getRebateAmount();
        BigDecimal rebateQuantity = sheet.getRebateQuantity();
        if (!(rebateAmount != null && BigDecimal.ZERO.compareTo(rebateAmount) != 0 || rebateQuantity != null && BigDecimal.ZERO.compareTo(rebateQuantity) != 0)) {
            throw new ELSBootException("\u8fd4\u5229\u91d1\u989d/\u8fd4\u5229\u6570\u91cf=0\uff0c\u4e0d\u5141\u8bb8\u63d0\u5ba1\u8fd4\u5229\u8ba1\u7b97\u5355");
        }
        for (String account : outputParamVO.getNextAuditUserList()) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
            String operataion = "submitAudit";
            if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
            }
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
        }
    }

    public void completeCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(outputParamVO.getAuditStatus())) {
            MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
            MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditPass", (MsgParamsVO)msgParamsVO);
            PurchaseRebateCalculationSheetVO vo = new PurchaseRebateCalculationSheetVO();
            String id = inputParamVO.getBusinessId();
            PurchaseRebateCalculationSheet purchaseRebateCalculationSheet = (PurchaseRebateCalculationSheet)((Object)this.purchaseRebateCalculationSheetService.getById((Serializable)((Object)id)));
            List<PurchaseRebateCalculationSheetCalculateDetail> calculateDetails = this.purchaseRebateCalculationSheetCalculateDetailService.selectByMainId(id);
            List<PurchaseRebateCalculationSheetCertificate> certificates = this.purchaseRebateCalculationSheetCertificateService.selectByMainId(id);
            List<PurchaseRebateCalculationSheetRegister> registers = this.purchaseRebateCalculationSheetRegisterService.selectByMainId(id);
            List<PurchaseRebateCalculationSheetRuleDetail> ruleDetails = this.purchaseRebateCalculationSheetRuleDetailService.selectByMainId(id);
            List<PurchaseRebateCalculationSheetRuleThreshold> thresholdList = this.purchaseRebateCalculationSheetRuleThresholdService.selectByMainId(id);
            List<PurchaseRebateCalculationSheetRuleSupplement> supplementList = this.purchaseRebateCalculationSheetRuleSupplementService.selectByMainId(id);
            vo.setRebateCalculationSheetCalculateDetails(calculateDetails);
            vo.setRebateCalculationSheetCertificates(certificates);
            vo.setRebateCalculationSheetRegisters(registers);
            vo.setRebateCalculationSheetRuleDetails(ruleDetails);
            vo.setRebateCalculationSheetRuleThresholds(thresholdList);
            vo.setRebateCalculationSheetRuleSupplements(supplementList);
            BeanUtils.copyProperties((Object)((Object)purchaseRebateCalculationSheet), (Object)((Object)vo));
            this.purchaseRebateCalculationSheetService.publish(purchaseRebateCalculationSheet, vo);
        } else {
            for (String account : outputParamVO.getNextAuditUserList()) {
                MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, account);
                String operataion = "submitAudit";
                if (WorkFlowType.BPMN.getValue().equals(outputParamVO.getBpmnType())) {
                    operataion = outputParamVO.getBpmnType() + "_" + "submitAudit";
                }
                MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)operataion, (MsgParamsVO)msgParamsVO);
            }
        }
    }

    public void rejectCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
        MsgParamsVO msgParamsVO = this.parameterAssemble(inputParamVO, outputParamVO, outputParamVO.getSubmitUser());
        MqUtil.sendBusMsg((String)TenantContext.getTenant(), (String)inputParamVO.getBusinessType(), (String)"auditReject", (MsgParamsVO)msgParamsVO);
    }

    public void cancelCallBack(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        this.updateStatus(inputParamVO, outputParamVO);
    }

    public JSONObject getDataById(String id) {
        PurchaseRebateCalculationSheet head = (PurchaseRebateCalculationSheet)((Object)this.purchaseRebateCalculationSheetMapper.selectById((Serializable)((Object)id)));
        if (head != null) {
            Result result = Result.ok((Object)((Object)head));
            ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
            JSONObject jsonObject = (JSONObject)result.getResult();
            return jsonObject;
        }
        return null;
    }

    private void updateStatus(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO) {
        PurchaseRebateCalculationSheet head = new PurchaseRebateCalculationSheet();
        head.setId(inputParamVO.getBusinessId());
        head.setAuditStatus(outputParamVO.getAuditStatus());
        head.setFlowId(outputParamVO.getProcessRootId());
        this.purchaseRebateCalculationSheetMapper.updateById((Object)head);
    }

    private MsgParamsVO parameterAssemble(AuditInputParamDTO inputParamVO, AuditOutputParamDTO outputParamVO, String account) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(TenantContext.getTenant(), account.split("_")[1]);
        accountList.add(subAccount);
        receiverMap.put(TenantContext.getTenant(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        String outAuditPassUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String outAuditRejectUrl = SysUtil.getOutAuditPassUrl((ElsSubAccountDTO)subAccount, (String)outputParamVO.getProcessRootId(), (String)inputParamVO.getBusinessType(), (String)inputParamVO.getBusinessId());
        String headId = inputParamVO.getBusinessId();
        PurchaseRebateCalculationSheet head = (PurchaseRebateCalculationSheet)((Object)this.purchaseRebateCalculationSheetMapper.selectById((Serializable)((Object)headId)));
        Result result = Result.ok((Object)((Object)head));
        ((DictAspect)SpringContextUtils.getBean(DictAspect.class)).parseDictText((Object)result);
        JSONObject jsonObject = (JSONObject)result.getResult();
        Map paramMap = (Map)JSON.parse((String)jsonObject.toString());
        paramMap.put("outAuditPassUrl", outAuditPassUrl);
        paramMap.put("outAuditRejectUrl", outAuditRejectUrl);
        msgParamsVO.setParams((Object)paramMap);
        HashMap<String, JSONObject> receiveParamMap = new HashMap<String, JSONObject>();
        JSONObject paramObj = new JSONObject();
        paramObj.put("businessId", (Object)inputParamVO.getBusinessId());
        paramObj.put("businessType", (Object)inputParamVO.getBusinessType());
        if (account.split("_").length > 2) {
            paramObj.put("taskId", (Object)account.split("_")[2]);
        }
        if (account.split("_").length > 3) {
            paramObj.put("processInstanceId", (Object)account.split("_")[3]);
        }
        receiveParamMap.put(TenantContext.getTenant(), paramObj);
        msgParamsVO.setReceiveParamMap(receiveParamMap);
        return msgParamsVO;
    }
}

