/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.rebate.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.rebate.entity.PurchaseRebateRule;
import com.els.modules.rebate.entity.PurchaseRebateRuleItem;
import com.els.modules.rebate.entity.PurchaseRebateRuleSupplement;
import com.els.modules.rebate.entity.PurchaseRebateRuleThreshold;
import com.els.modules.rebate.entity.SaleRebateRule;
import com.els.modules.rebate.entity.SaleRebateRuleItem;
import com.els.modules.rebate.entity.SaleRebateRuleSupplement;
import com.els.modules.rebate.entity.SaleRebateRuleThreshold;
import com.els.modules.rebate.enumerate.CalculationRebateFormEnum;
import com.els.modules.rebate.enumerate.CalculationRebateTypeEnum;
import com.els.modules.rebate.enumerate.CalculationSheetLadderEnum;
import com.els.modules.rebate.enumerate.RebateConditionEnum;
import com.els.modules.rebate.enumerate.RebateRuleProgressiveApproachEnum;
import com.els.modules.rebate.enumerate.RuleStatusEnum;
import com.els.modules.rebate.mapper.PurchaseRebateRuleItemMapper;
import com.els.modules.rebate.mapper.PurchaseRebateRuleMapper;
import com.els.modules.rebate.mapper.SaleRebateRuleItemMapper;
import com.els.modules.rebate.mapper.SaleRebateRuleMapper;
import com.els.modules.rebate.mapper.SaleRebateRuleSupplementMapper;
import com.els.modules.rebate.mapper.SaleRebateRuleThresholdMapper;
import com.els.modules.rebate.rpc.PurchaseMaterialHeadLocalRpcService;
import com.els.modules.rebate.service.PurchaseRebateRuleService;
import com.els.modules.rebate.service.PurchaseRebateRuleSupplementService;
import com.els.modules.rebate.service.PurchaseRebateRuleThresholdService;
import com.els.modules.rebate.vo.CalculationSheetLadderVO;
import com.els.modules.rebate.vo.ItemVO;
import com.els.modules.rebate.vo.PurchaseRebateRuleVO;
import com.els.modules.supplier.api.enumerate.SupplierCoordinationWayEnum;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseRebateRuleServiceImpl
extends BaseServiceImpl<PurchaseRebateRuleMapper, PurchaseRebateRule>
implements PurchaseRebateRuleService {
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private PurchaseRebateRuleMapper purchaseRebateRuleMapper;
    @Resource
    private PurchaseRebateRuleItemMapper purchaseRebateRuleItemMapper;
    @Resource
    private SaleRebateRuleMapper saleRebateRuleMapper;
    @Resource
    private InterfaceUtil interfaceUtil;
    @Resource
    private StaticConfig staticConfig;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private SaleRebateRuleItemMapper saleRebateRuleItemMapper;
    @Resource
    private SaleRebateRuleThresholdMapper saleRebateRuleThresholdMapper;
    @Resource
    private SaleRebateRuleSupplementMapper saleRebateRuleSupplementMapper;
    @Resource
    private PurchaseMaterialHeadLocalRpcService purchaseMaterialHeadLocalRpcService;
    @Autowired
    private PurchaseRebateRuleThresholdService purchaseRebateRuleThresholdService;
    @Autowired
    private PurchaseRebateRuleSupplementService purchaseRebateRuleSupplementService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchaseRebateRule purchaseRebateRule, PurchaseRebateRuleVO purchaseRebateRuleVO) {
        this.checkRule(purchaseRebateRule, purchaseRebateRuleVO);
        String nextCode = this.invokeBaseRpcService.getNextCode("purchaseRebateRuleNumber", (Object)purchaseRebateRule);
        purchaseRebateRule.setRuleNumber(nextCode);
        purchaseRebateRule.setRuleStatus(RuleStatusEnum.NEW.getValue());
        this.purchaseRebateRuleMapper.insert((Object)purchaseRebateRule);
        this.insertRebateRuleItems(purchaseRebateRule, purchaseRebateRuleVO.getRebateRuleItems());
        this.insertRebateRuleThreshold(purchaseRebateRule, purchaseRebateRuleVO.getRebateRuleThresholds());
        this.insertRebateRuleSupplement(purchaseRebateRule, purchaseRebateRuleVO.getRebateRuleSupplements());
    }

    private void insertRebateRuleSupplement(PurchaseRebateRule purchaseRebateRule, List<PurchaseRebateRuleSupplement> rebateRuleSupplementList) {
        if (CollectionUtil.isEmpty(rebateRuleSupplementList)) {
            return;
        }
        int itemNumber = 1;
        for (PurchaseRebateRuleSupplement supplement : rebateRuleSupplementList) {
            SysUtil.setSysParam((BaseEntity)supplement, (BaseEntity)purchaseRebateRule);
            supplement.setHeadId(purchaseRebateRule.getId());
            supplement.setItemNumber(String.valueOf(itemNumber));
            ++itemNumber;
        }
        this.purchaseRebateRuleSupplementService.saveBatch(rebateRuleSupplementList);
    }

    private void insertRebateRuleThreshold(PurchaseRebateRule purchaseRebateRule, List<PurchaseRebateRuleThreshold> rebateRuleThresholdList) {
        if (CollectionUtil.isEmpty(rebateRuleThresholdList)) {
            return;
        }
        int itemNumber = 1;
        for (PurchaseRebateRuleThreshold threshold : rebateRuleThresholdList) {
            SysUtil.setSysParam((BaseEntity)threshold, (BaseEntity)purchaseRebateRule);
            threshold.setHeadId(purchaseRebateRule.getId());
            threshold.setItemNumber(String.valueOf(itemNumber));
            ++itemNumber;
        }
        this.purchaseRebateRuleThresholdService.saveBatch(rebateRuleThresholdList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchaseRebateRule purchaseRebateRule, PurchaseRebateRuleVO purchaseRebateRuleVO) {
        this.checkRule(purchaseRebateRule, purchaseRebateRuleVO);
        this.purchaseRebateRuleMapper.updateById((Object)purchaseRebateRule);
        this.purchaseRebateRuleItemMapper.deleteByMainId(purchaseRebateRule.getId());
        this.purchaseRebateRuleThresholdService.deleteByMainId(purchaseRebateRule.getId());
        this.purchaseRebateRuleSupplementService.deleteByMainId(purchaseRebateRule.getId());
        this.insertRebateRuleItems(purchaseRebateRule, purchaseRebateRuleVO.getRebateRuleItems());
        this.insertRebateRuleThreshold(purchaseRebateRule, purchaseRebateRuleVO.getRebateRuleThresholds());
        this.insertRebateRuleSupplement(purchaseRebateRule, purchaseRebateRuleVO.getRebateRuleSupplements());
    }

    private void checkRule(PurchaseRebateRule purchaseRebateRule, PurchaseRebateRuleVO purchaseRebateRuleVO) {
        List<PurchaseRebateRuleItem> rebateRuleItemList = purchaseRebateRuleVO.getRebateRuleItems();
        String rebateForm = purchaseRebateRule.getRebateForm();
        for (PurchaseRebateRuleItem item : rebateRuleItemList) {
            String progressiveApproach = item.getProgressiveApproach();
            String rebateCondition = item.getRebateCondition();
            String rebateLadder = item.getRebateLadder();
            if (StringUtils.isEmpty((CharSequence)rebateLadder)) {
                throw new ELSBootException("\u8fd4\u5229\u9636\u68af \u4e0d\u80fd\u4e3a\u7a7a");
            }
            List sheetLadderVOList = new ArrayList();
            try {
                sheetLadderVOList = JSON.parseArray((String)rebateLadder, CalculationSheetLadderVO.class);
            }
            catch (Exception e) {
                throw new ELSBootException("\u8fd4\u5229\u9636\u68af \u8f93\u5165\u4e0d\u6b63\u786e");
            }
            for (CalculationSheetLadderVO vo : sheetLadderVOList) {
                boolean flag2;
                boolean flag;
                boolean multiStandand = vo.getUnion() != null && StringUtils.isEmpty((CharSequence)vo.getType());
                boolean singleStandand = CalculationSheetLadderEnum.UNION.getValue().equals(vo.getType());
                boolean bl = flag = (singleStandand || multiStandand) && RebateConditionEnum.AMOUNT.getValue().equals(rebateCondition) && RebateRuleProgressiveApproachEnum.OVER_PROGRESSIVE.getValue().equals(progressiveApproach);
                if (flag) {
                    throw new ELSBootException("\u603b\u91d1\u989d\u4e0d\u80fd\u6309\u8d85\u989d\u7d2f\u8fdb\u8ba1\u7b97\u6bcf\u5355\u4f4d");
                }
                multiStandand = vo.getRate() != null && StringUtils.isEmpty((CharSequence)vo.getType());
                singleStandand = CalculationSheetLadderEnum.RATE.getValue().equals(vo.getType());
                boolean bl2 = flag2 = !(!singleStandand && !multiStandand || !RebateConditionEnum.NUMBER.getValue().equals(rebateCondition) || !CalculationRebateFormEnum.OFFSET_PAYMENT.getValue().equals(rebateForm) && !CalculationRebateFormEnum.COLLECTION.getValue().equals(rebateForm));
                if (flag2) {
                    throw new ELSBootException("\u8fd4\u5229\u91d1\u989d\u4e0d\u80fd\u7528\u603b\u6570\u91cf\u7684\u6bd4\u4f8b\u503c\u8ba1\u7b97");
                }
                multiStandand = vo.getRate() != null && StringUtils.isEmpty((CharSequence)vo.getType());
                singleStandand = CalculationSheetLadderEnum.RATE.getValue().equals(vo.getType());
                boolean flag3 = (singleStandand || multiStandand) && RebateConditionEnum.AMOUNT.getValue().equals(rebateCondition) && CalculationRebateFormEnum.PHYSICAL.getValue().equals(rebateForm);
                if (!flag3) continue;
                throw new ELSBootException("\u8fd4\u5229\u5b9e\u7269\u4e0d\u80fd\u7528\u603b\u91d1\u989d\u7684\u6bd4\u4f8b\u503c\u8ba1\u7b97");
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delete(String id) {
        PurchaseRebateRule head = (PurchaseRebateRule)((Object)this.getById((Serializable)((Object)id)));
        if (AuditStatusEnum.AUDIT_DOING.getValue().equals(head.getAuditStatus()) || AuditStatusEnum.AUDIT_FINISH.getValue().equals(head.getAuditStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_UzsSUzeRjtFqQG_908d607c", (String)"\u5ba1\u6279\u4e2d\u6216\u5ba1\u6279\u901a\u8fc7\u7684\u5355\u636e\u4e0d\u53ef\u5220\u9664"));
        }
        ((PurchaseRebateRuleMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        this.purchaseRebateRuleItemMapper.deleteByMainId(id);
        this.purchaseRebateRuleThresholdService.deleteByMainId(id);
        this.purchaseRebateRuleSupplementService.deleteByMainId(id);
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseRebateRuleMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List purchaseRebateRuleList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchaseRebateRule purchaseRebateRule : purchaseRebateRuleList) {
            this.pushDataToErp(purchaseRebateRule);
        }
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getPurchaseRebateRule", (Object)new JSONObject());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> publish(PurchaseRebateRule purchaseRebateRule, PurchaseRebateRuleVO purchaseRebateRuleVO) {
        this.publishCheckRule(purchaseRebateRule, purchaseRebateRuleVO);
        Boolean flag = false;
        if (RuleStatusEnum.RENTURNED.getValue().equals(purchaseRebateRule.getRuleStatus()) && StringUtils.isNotBlank((CharSequence)purchaseRebateRule.getRelationId())) {
            flag = true;
        }
        if (SupplierCoordinationWayEnum.NO_COORDINATIONWAY.getValue().equals(purchaseRebateRule.getTeamwork())) {
            purchaseRebateRule.setRuleStatus(RuleStatusEnum.CONFIRMED.getValue());
        } else {
            purchaseRebateRule.setRuleStatus(RuleStatusEnum.UNCONFIRMED.getValue());
        }
        this.updateMain(purchaseRebateRule, purchaseRebateRuleVO);
        this.invokeBaseRpcService.addStatusLog(purchaseRebateRule.getId(), purchaseRebateRule.getRuleStatus(), "purchaseRebateRule", "publish");
        String relationId = purchaseRebateRule.getRelationId();
        SaleRebateRule saleRebateRule = new SaleRebateRule();
        BeanUtils.copyProperties((Object)((Object)purchaseRebateRule), (Object)((Object)saleRebateRule));
        saleRebateRule.setToElsAccount(purchaseRebateRule.getElsAccount());
        saleRebateRule.setElsAccount(purchaseRebateRule.getToElsAccount());
        saleRebateRule.setBusAccount(purchaseRebateRule.getElsAccount());
        saleRebateRule.setRelationId(purchaseRebateRule.getId());
        if (flag.booleanValue()) {
            saleRebateRule.setId(relationId);
            saleRebateRule.setRuleStatus(purchaseRebateRule.getRuleStatus());
            this.saleRebateRuleMapper.updateById((Object)saleRebateRule);
            this.handleDetail(saleRebateRule, purchaseRebateRuleVO);
        } else {
            saleRebateRule.setId(null);
            this.saleRebateRuleMapper.insert((Object)saleRebateRule);
            purchaseRebateRule.setRelationId(saleRebateRule.getId());
            this.purchaseRebateRuleMapper.updateById((Object)purchaseRebateRule);
            this.handleDetail(saleRebateRule, purchaseRebateRuleVO);
        }
        this.sendMessage(purchaseRebateRule, saleRebateRule);
        return Result.ok((String)"\u53d1\u5e03\u6210\u529f\uff01");
    }

    @Override
    public void publishCheckRule(PurchaseRebateRule purchaseRebateRule, PurchaseRebateRuleVO vo) {
        String rebateLadder;
        boolean rebateMethodFlag;
        boolean rebateConditionFlag;
        String rebateProduct;
        PurchaseRebateRule dbRebateRule = (PurchaseRebateRule)((Object)this.getById((Serializable)((Object)purchaseRebateRule.getId())));
        if (dbRebateRule != null) {
            boolean flag;
            boolean bl = flag = RuleStatusEnum.UNCONFIRMED.getValue().equals(dbRebateRule.getRuleStatus()) || RuleStatusEnum.CONFIRMED.getValue().equals(dbRebateRule.getRuleStatus()) && SupplierCoordinationWayEnum.NO_COORDINATIONWAY.getValue().equals(dbRebateRule.getTeamwork());
            if (flag) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APzExqhxVXVtFzE_64c0f41", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u53d1\u5e03\uff0c\u8bf7\u5237\u65b0\u5355\u636e\u72b6\u6001"));
            }
        }
        Date rebateRedemptionPeriod = purchaseRebateRule.getRebateRedemptionPeriod();
        DateTime lastDay = DateUtil.offsetDay((Date)new Date(), (int)-1);
        DateTime lastDayTime = DateUtil.endOfDay((Date)lastDay);
        if (rebateRedemptionPeriod != null && !rebateRedemptionPeriod.after((Date)lastDayTime)) {
            throw new ELSBootException("\u8fd4\u5229\u5151\u6362\u671f\u9650\u5e94\u8be5\u8981\u5927\u4e8e\u7b49\u4e8e\u5f53\u524d\u65e5\u671f");
        }
        List<PurchaseRebateRuleItem> ruleItemList = vo.getRebateRuleItems();
        HashSet setAll = new HashSet();
        HashSet<String> rebateProductSet = new HashSet<String>();
        Map<String, String> rebateProductMap = this.handleProductInfo(ruleItemList, rebateProductSet);
        List<PurchaseRebateRuleThreshold> thresholdList = vo.getRebateRuleThresholds();
        List<PurchaseRebateRuleItem> detailList = vo.getRebateRuleItems();
        List<PurchaseRebateRuleSupplement> supplementList = vo.getRebateRuleSupplements();
        for (PurchaseRebateRuleThreshold threshold : thresholdList) {
            boolean allTrueFlag;
            rebateProduct = threshold.getRebateProduct();
            String rebateType = threshold.getRebateType();
            String rebateCondition = threshold.getRebateCondition();
            String rebateMethod = threshold.getRebateMethod();
            BigDecimal thresholdValue = threshold.getThresholdValue();
            boolean rebateProductFlag = StringUtils.isEmpty((CharSequence)rebateProduct);
            boolean rebateTypetFlag = StringUtils.isEmpty((CharSequence)rebateType);
            rebateConditionFlag = StringUtils.isEmpty((CharSequence)rebateCondition);
            rebateMethodFlag = StringUtils.isEmpty((CharSequence)rebateMethod);
            boolean thresholdValueFlag = thresholdValue == null;
            boolean allFlag = rebateProductFlag || rebateTypetFlag || rebateConditionFlag || rebateMethodFlag || thresholdValueFlag;
            boolean bl = allTrueFlag = rebateProductFlag && rebateTypetFlag && rebateConditionFlag && rebateMethodFlag && thresholdValueFlag;
            if (allFlag && !allTrueFlag) {
                throw new ELSBootException("\u5df2\u8bbe\u7f6e\u90e8\u5206\u8fd4\u5229\u95e8\u69db\uff0c\u8bf7\u6309\u9700\u5b8c\u5584\u6216\u6e05\u7a7a");
            }
            if (CalculationRebateTypeEnum.MONEY_RETURN.getValue().equals(threshold.getRebateType()) || StringUtils.isEmpty((CharSequence)threshold.getPayType())) continue;
            throw new ELSBootException("\u95e8\u69db\u7c7b\u578b\u4e3a\u56de\u6b3e\u624d\u53ef\u8bbe\u7f6e\u95e8\u69db\u4ed8\u6b3e\u65b9\u5f0f");
        }
        for (PurchaseRebateRuleItem ruleDetail : detailList) {
            String rebateSettlementCycle = ruleDetail.getRebateSettlementCycle();
            if (StringUtils.isEmpty((CharSequence)rebateSettlementCycle)) {
                throw new ELSBootException("\u8fd4\u5229\u7ed3\u7b97\u5468\u671f\u5fc5\u586b");
            }
            String progressiveApproach = ruleDetail.getProgressiveApproach();
            if (StringUtils.isEmpty((CharSequence)progressiveApproach)) {
                throw new ELSBootException("\u7d2f\u8fdb\u65b9\u5f0f \u5fc5\u586b");
            }
            String pricingBasis = ruleDetail.getPricingBasis();
            if (StringUtils.isEmpty((CharSequence)pricingBasis)) {
                throw new ELSBootException("\u8ba1\u4ef7\u57fa\u7840 \u5fc5\u586b");
            }
            String rebateCondition = ruleDetail.getRebateCondition();
            if (StringUtils.isEmpty((CharSequence)rebateCondition)) {
                throw new ELSBootException("\u8fd4\u5229\u6761\u4ef6 \u5fc5\u586b");
            }
            rebateLadder = ruleDetail.getRebateLadder();
            if (StringUtils.isEmpty((CharSequence)rebateLadder)) {
                throw new ELSBootException("\u8fd4\u5229\u9636\u68af \u5fc5\u586b");
            }
            try {
                JSON.parseArray((String)rebateLadder, CalculationSheetLadderVO.class);
            }
            catch (Exception e) {
                throw new ELSBootException("\u8fd4\u5229\u9636\u68af \u8f93\u5165\u4e0d\u6b63\u786e");
            }
        }
        for (PurchaseRebateRuleSupplement supplement : supplementList) {
            boolean allTrueFlag;
            rebateProduct = supplement.getRebateProduct();
            String rebateCondition = supplement.getRebateCondition();
            String rebateMethod = supplement.getRebateMethod();
            BigDecimal thresholdValue = supplement.getThresholdValue();
            rebateLadder = supplement.getRebateLadder();
            String progressiveApproach = supplement.getProgressiveApproach();
            boolean rebateProductFlag = StringUtils.isEmpty((CharSequence)rebateProduct);
            rebateConditionFlag = StringUtils.isEmpty((CharSequence)rebateCondition);
            rebateMethodFlag = StringUtils.isEmpty((CharSequence)rebateMethod);
            boolean rebateLadderFlag = StringUtils.isEmpty((CharSequence)rebateLadder);
            boolean progressiveApproachFlag = StringUtils.isEmpty((CharSequence)progressiveApproach);
            boolean thresholdValueFlag = thresholdValue == null;
            boolean allFlag = rebateProductFlag || rebateConditionFlag || rebateMethodFlag || rebateLadderFlag || progressiveApproachFlag || thresholdValueFlag;
            boolean bl = allTrueFlag = rebateProductFlag || rebateConditionFlag && rebateMethodFlag && rebateLadderFlag && progressiveApproachFlag && thresholdValueFlag;
            if (allFlag && !allTrueFlag) {
                throw new ELSBootException("\u5df2\u8bbe\u7f6e\u90e8\u5206\u8ffd\u52a0\u8fd4\u5229\u89c4\u5219\uff0c\u8bf7\u6309\u9700\u5b8c\u5584\u6216\u6e05\u7a7a");
            }
            try {
                JSON.parseArray((String)rebateLadder, CalculationSheetLadderVO.class);
            }
            catch (Exception e) {
                throw new ELSBootException("\u8ffd\u52a0\u8fd4\u5229\u9636\u68af \u8f93\u5165\u4e0d\u6b63\u786e");
            }
        }
        HashSet<ItemVO> pricingBasiSet = new HashSet<ItemVO>();
        HashSet<ItemVO> pogressiveApproachSet = new HashSet<ItemVO>();
        for (PurchaseRebateRuleItem rebateRuleItem : ruleItemList) {
            String repeatRebateAllowed = rebateRuleItem.getRepeatRebateAllowed();
            if ("1".equals(repeatRebateAllowed)) continue;
            this.checkPricingBasis(rebateProductMap, pricingBasiSet, rebateRuleItem);
            this.checkProgressiveApproach(rebateProductMap, pogressiveApproachSet, rebateRuleItem);
            String rebateProduct2 = rebateRuleItem.getRebateProduct();
            ArrayList rebateProducts = Lists.newArrayList((Object[])rebateProduct2.split(","));
            String sourceRestriction = rebateRuleItem.getSourceRestriction();
            ArrayList sourceRestrictions = Lists.newArrayList((Object[])sourceRestriction.split(","));
            for (String restriction : sourceRestrictions) {
                for (String product : rebateProducts) {
                    HashSet<String> set = new HashSet<String>();
                    set.add(product);
                    set.add(restriction);
                    boolean add = setAll.add(set);
                    if (add) continue;
                    String productName = rebateProductMap.get(product);
                    throw new ELSBootException("\u5546\u54c1 " + productName + " \u5df2\u5728\u7b2c" + rebateRuleItem.getItemNumber() + "\u884c\u8bbe\u7f6e\u8fd4\u5229\u89c4\u5219");
                }
            }
        }
    }

    private void checkPricingBasis(Map<String, String> rebateProductMap, Set<ItemVO> itemVOSet, PurchaseRebateRuleItem rebateRuleItem) {
        String pricingBasis;
        ItemVO itemVO = new ItemVO();
        String rebateCondition = rebateRuleItem.getRebateCondition();
        if (!StringUtils.isEmpty((CharSequence)rebateCondition)) {
            itemVO.setRebateCondition(rebateCondition);
        }
        if (!StringUtils.isEmpty((CharSequence)(pricingBasis = rebateRuleItem.getPricingBasis()))) {
            itemVO.setPricingBasis(pricingBasis);
        }
        String sourceRestriction = rebateRuleItem.getSourceRestriction();
        String storeRestriction = rebateRuleItem.getStoreRestriction();
        String rebateProduct = rebateRuleItem.getRebateProduct();
        HashSet rebateProducts = Sets.newHashSet((Object[])rebateProduct.split(","));
        itemVO.setRebateProducts(rebateProducts);
        if (!StringUtils.isEmpty((CharSequence)sourceRestriction)) {
            HashSet sourceRestrictions = Sets.newHashSet((Object[])sourceRestriction.split(","));
            itemVO.setSourceRestrictions(sourceRestrictions);
        }
        if (!StringUtils.isEmpty((CharSequence)storeRestriction)) {
            HashSet storeRestrictions = Sets.newHashSet((Object[])storeRestriction.split(","));
            itemVO.setStoreRestrictions(storeRestrictions);
        }
        if (!itemVOSet.contains(itemVO)) {
            itemVOSet.add(itemVO);
        } else {
            Iterator iterator = rebateProducts.iterator();
            if (iterator.hasNext()) {
                String product = (String)iterator.next();
                String productName = rebateProductMap.get(product);
                throw new ELSBootException("\u5546\u54c1 " + productName + " \u5df2\u5728\u7b2c" + rebateRuleItem.getItemNumber() + "\u884c\u8bbe\u7f6e\u8ba1\u4ef7\u57fa\u7840");
            }
        }
    }

    private void checkProgressiveApproach(Map<String, String> rebateProductMap, Set<ItemVO> itemVOSet, PurchaseRebateRuleItem rebateRuleItem) {
        String progressiveApproach;
        ItemVO itemVO = new ItemVO();
        String rebateCondition = rebateRuleItem.getRebateCondition();
        if (!StringUtils.isEmpty((CharSequence)rebateCondition)) {
            itemVO.setRebateCondition(rebateCondition);
        }
        if (!StringUtils.isEmpty((CharSequence)(progressiveApproach = rebateRuleItem.getProgressiveApproach()))) {
            itemVO.setProgressiveApproach(progressiveApproach);
        }
        String sourceRestriction = rebateRuleItem.getSourceRestriction();
        String storeRestriction = rebateRuleItem.getStoreRestriction();
        String rebateProduct = rebateRuleItem.getRebateProduct();
        HashSet rebateProducts = Sets.newHashSet((Object[])rebateProduct.split(","));
        itemVO.setRebateProducts(rebateProducts);
        if (!StringUtils.isEmpty((CharSequence)sourceRestriction)) {
            HashSet sourceRestrictions = Sets.newHashSet((Object[])sourceRestriction.split(","));
            itemVO.setSourceRestrictions(sourceRestrictions);
        }
        if (!StringUtils.isEmpty((CharSequence)storeRestriction)) {
            HashSet storeRestrictions = Sets.newHashSet((Object[])storeRestriction.split(","));
            itemVO.setStoreRestrictions(storeRestrictions);
        }
        if (!itemVOSet.contains(itemVO)) {
            itemVOSet.add(itemVO);
        } else {
            Iterator iterator = rebateProducts.iterator();
            if (iterator.hasNext()) {
                String product = (String)iterator.next();
                String productName = rebateProductMap.get(product);
                throw new ELSBootException("\u5546\u54c1 " + productName + " \u5df2\u5728\u7b2c" + rebateRuleItem.getItemNumber() + "\u884c\u8bbe\u7f6e\u7d2f\u8fdb\u65b9\u5f0f");
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void copyData(String id) {
        PurchaseRebateRule rebateRule = (PurchaseRebateRule)((Object)this.purchaseRebateRuleMapper.selectById((Serializable)((Object)id)));
        rebateRule.setId(null);
        rebateRule.setRebateContractNumber(null);
        rebateRule.setInvalidStatus(null);
        rebateRule.setRebateType(null);
        rebateRule.setAudit(null);
        rebateRule.setAuditStatus("");
        rebateRule.setCreateBy(null);
        rebateRule.setCreateTime(null);
        rebateRule.setCreateById(null);
        rebateRule.setUpdateBy(null);
        rebateRule.setUpdateTime(null);
        rebateRule.setUpdateById(null);
        rebateRule.setRejectReason(null);
        PurchaseRebateRuleVO purchaseRebateRuleVO = new PurchaseRebateRuleVO();
        List<PurchaseRebateRuleItem> ruleItems = this.purchaseRebateRuleItemMapper.selectByMainId(id);
        for (PurchaseRebateRuleItem purchaseRebateRuleItem : ruleItems) {
            purchaseRebateRuleItem.setId(null);
        }
        List<PurchaseRebateRuleThreshold> thresholds = this.purchaseRebateRuleThresholdService.selectByMainId(id);
        for (PurchaseRebateRuleThreshold threshold : thresholds) {
            threshold.setId(null);
        }
        List<PurchaseRebateRuleSupplement> list = this.purchaseRebateRuleSupplementService.selectByMainId(id);
        for (PurchaseRebateRuleSupplement supplement : list) {
            supplement.setId(null);
        }
        purchaseRebateRuleVO.setRebateRuleItems(ruleItems);
        purchaseRebateRuleVO.setRebateRuleThresholds(thresholds);
        purchaseRebateRuleVO.setRebateRuleSupplements(list);
        this.saveMain(rebateRule, purchaseRebateRuleVO);
    }

    @Override
    public JSONObject getDataById(String id) {
        PurchaseRebateRule purchaseRebateRule = (PurchaseRebateRule)((Object)this.getById((Serializable)((Object)id)));
        PurchaseRebateRuleVO headVO = (PurchaseRebateRuleVO)((Object)BeanUtil.copyProperties((Object)((Object)purchaseRebateRule), PurchaseRebateRuleVO.class, (String[])new String[0]));
        Result result = Result.ok((Object)((Object)headVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }

    private Map<String, String> handleProductInfo(List<PurchaseRebateRuleItem> ruleItemList, Set<String> rebateProductSet) {
        HashMap<String, String> rebateProductMap = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(ruleItemList)) {
            return rebateProductMap;
        }
        for (PurchaseRebateRuleItem rebateRuleItem : ruleItemList) {
            String rebateProduct = rebateRuleItem.getRebateProduct();
            ArrayList rebateProducts = Lists.newArrayList((Object[])rebateProduct.split(","));
            rebateProductSet.addAll(rebateProducts);
        }
        List<PurchaseMaterialHeadDTO> purchaseMaterialHeadDTOList = this.purchaseMaterialHeadLocalRpcService.listByIds(new ArrayList<String>(rebateProductSet));
        for (PurchaseMaterialHeadDTO purchaseMaterialHeadDTO : purchaseMaterialHeadDTOList) {
            rebateProductMap.put(purchaseMaterialHeadDTO.getId(), purchaseMaterialHeadDTO.getMaterialName());
        }
        return rebateProductMap;
    }

    @Override
    public void cancellation(String id) {
        PurchaseRebateRule purchaseRebateRule = (PurchaseRebateRule)((Object)this.purchaseRebateRuleMapper.selectById((Serializable)((Object)id)));
        purchaseRebateRule.setRuleStatus(RuleStatusEnum.CANCEL.getValue());
        purchaseRebateRule.setInvalidStatus("1");
        this.purchaseRebateRuleMapper.updateById((Object)purchaseRebateRule);
        SaleRebateRule saleRebateRule = (SaleRebateRule)((Object)this.saleRebateRuleMapper.selectById((Serializable)((Object)purchaseRebateRule.getRelationId())));
        saleRebateRule.setRuleStatus(RuleStatusEnum.CANCEL.getValue());
        saleRebateRule.setInvalidStatus("1");
        this.saleRebateRuleMapper.updateById((Object)saleRebateRule);
        super.sendMessage(purchaseRebateRule.getElsAccount(), "purchaseRebateRule", "cancel", purchaseRebateRule.getId(), "rebateRuleBusDataServiceImpl", Arrays.asList(purchaseRebateRule.getToElsAccount()));
    }

    @Override
    public void updateInvalidStatus() {
        List<PurchaseRebateRule> list = ((PurchaseRebateRuleMapper)this.baseMapper).selectRuleList();
        HashSet<String> invalidIds = new HashSet<String>();
        HashSet<String> effectIds = new HashSet<String>();
        for (PurchaseRebateRule purchaseRebateRule : list) {
            Date rebateRedemptionPeriod = purchaseRebateRule.getRebateRedemptionPeriod();
            this.handleStatus(invalidIds, purchaseRebateRule, rebateRedemptionPeriod);
            Date beginDate = purchaseRebateRule.getBeginDate();
            this.handleStatus(effectIds, purchaseRebateRule, beginDate);
        }
        if (!CollectionUtils.isEmpty(invalidIds)) {
            ((PurchaseRebateRuleMapper)this.baseMapper).updateRuleStatus(invalidIds, RuleStatusEnum.EFFECT.getValue(), RuleStatusEnum.EXPIRED.getValue());
            this.saleRebateRuleMapper.updateRuleStatus(invalidIds, RuleStatusEnum.EFFECT.getValue(), RuleStatusEnum.EXPIRED.getValue());
            ((PurchaseRebateRuleMapper)this.baseMapper).updateRuleStatus(invalidIds, RuleStatusEnum.CONFIRMED.getValue(), RuleStatusEnum.EXPIRED.getValue());
            this.saleRebateRuleMapper.updateRuleStatus(invalidIds, RuleStatusEnum.CONFIRMED.getValue(), RuleStatusEnum.EXPIRED.getValue());
            ((PurchaseRebateRuleMapper)this.baseMapper).updateRuleInvalidStatus(invalidIds);
            this.saleRebateRuleMapper.updateRuleInvalidStatus(invalidIds);
        }
        if (!CollectionUtils.isEmpty(effectIds)) {
            ((PurchaseRebateRuleMapper)this.baseMapper).updateRuleStatus(effectIds, RuleStatusEnum.CONFIRMED.getValue(), RuleStatusEnum.EFFECT.getValue());
            this.saleRebateRuleMapper.updateRuleStatus(effectIds, RuleStatusEnum.CONFIRMED.getValue(), RuleStatusEnum.EFFECT.getValue());
        }
    }

    private void handleStatus(Set<String> invalidIds, PurchaseRebateRule purchaseRebateRule, Date date) {
        boolean result;
        if (date != null && (result = new Date().after(date))) {
            String ruleId = purchaseRebateRule.getId();
            invalidIds.add(ruleId);
        }
    }

    private void sendMessage(PurchaseRebateRule purchaseRebateRule, SaleRebateRule saleRebateRule) {
        String url = "id=" + saleRebateRule.getId() + "&toElsAccount" + saleRebateRule.getToElsAccount();
        String serviceAddress = (String)this.staticConfig.getConfig().get("service.address");
        ElsSubAccountDTO elsSubAccount = this.invokeAccountRpcService.getAccount(purchaseRebateRule.getToElsAccount(), "1001");
        String token = JwtUtil.getOutToken((String)(elsSubAccount.getElsAccount() + "_" + elsSubAccount.getSubAccount()), (String)elsSubAccount.getPassword());
        saleRebateRule.setFbk7(serviceAddress + "/els/finance/saleRebateRule/emailConfirmOrRefuesd?token=" + token + "&operation=confirm&id=" + saleRebateRule.getId());
        saleRebateRule.setFbk8(serviceAddress + "/els/finance/saleRebateRule/emailConfirmOrRefuesd?token=" + token + "&operation=refused&id=" + saleRebateRule.getId());
        super.sendMessage(purchaseRebateRule.getElsAccount(), "purchaseRebateRule", "publish", purchaseRebateRule.getId(), "rebateRuleBusDataServiceImpl", Arrays.asList(purchaseRebateRule.getToElsAccount()));
    }

    private void pushDataToErp(PurchaseRebateRule purchaseRebateRule) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushPurchaseRebateRule", (Object)purchaseRebateRule);
    }

    private void insertRebateRuleItems(PurchaseRebateRule purchaseRebateRule, List<PurchaseRebateRuleItem> purchaseRebateRuleItemList) {
        if (CollectionUtil.isEmpty(purchaseRebateRuleItemList)) {
            return;
        }
        int itemNumber = 1;
        for (PurchaseRebateRuleItem entity : purchaseRebateRuleItemList) {
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchaseRebateRule);
            entity.setHeadId(purchaseRebateRule.getId());
            entity.setItemNumber(String.valueOf(itemNumber));
            ++itemNumber;
        }
        if (!purchaseRebateRuleItemList.isEmpty()) {
            this.purchaseRebateRuleItemMapper.insertBatchSomeColumn(purchaseRebateRuleItemList);
        }
    }

    public void handleDetail(SaleRebateRule saleRebateRule, PurchaseRebateRuleVO purchaseRebateRuleVO) {
        String id = saleRebateRule.getId();
        this.saleRebateRuleItemMapper.deleteByMainId(id);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(id);
        this.saleRebateRuleThresholdMapper.deleteByMainId(id);
        this.saleRebateRuleSupplementMapper.deleteByMainId(id);
        this.handleSaleRebateRuleItem(saleRebateRule, purchaseRebateRuleVO.getRebateRuleItems());
        this.handleSaleAttachmentDetail(saleRebateRule, purchaseRebateRuleVO.getAttachments());
        this.handleSaleRebateRuleThreshold(saleRebateRule, purchaseRebateRuleVO.getRebateRuleThresholds());
        this.handleSaleRebateRuleSupplement(saleRebateRule, purchaseRebateRuleVO.getRebateRuleSupplements());
    }

    private void handleSaleRebateRuleSupplement(SaleRebateRule saleRebateRule, List<PurchaseRebateRuleSupplement> purchaseRebateRuleSupplementList) {
        if (CollectionUtils.isEmpty(purchaseRebateRuleSupplementList)) {
            return;
        }
        ArrayList<SaleRebateRuleSupplement> saleRebateSupplementList = new ArrayList<SaleRebateRuleSupplement>();
        for (PurchaseRebateRuleSupplement purchaseRebateRuleSupplement : purchaseRebateRuleSupplementList) {
            SaleRebateRuleSupplement saleRebateRuleSupplement = new SaleRebateRuleSupplement();
            BeanUtils.copyProperties((Object)((Object)purchaseRebateRuleSupplement), (Object)((Object)saleRebateRuleSupplement));
            saleRebateRuleSupplement.setId(null);
            saleRebateRuleSupplement.setElsAccount(saleRebateRule.getElsAccount());
            saleRebateRuleSupplement.setToElsAccount(saleRebateRule.getToElsAccount());
            saleRebateRuleSupplement.setBusAccount(saleRebateRule.getBusAccount());
            saleRebateRuleSupplement.setHeadId(saleRebateRule.getId());
            saleRebateRuleSupplement.setRelationId(purchaseRebateRuleSupplement.getId());
            saleRebateSupplementList.add(saleRebateRuleSupplement);
        }
        this.saleRebateRuleSupplementMapper.insertBatchSomeColumn(saleRebateSupplementList);
    }

    private void handleSaleRebateRuleThreshold(SaleRebateRule saleRebateRule, List<PurchaseRebateRuleThreshold> purchaseRebateRuleThresholdList) {
        if (CollectionUtils.isEmpty(purchaseRebateRuleThresholdList)) {
            return;
        }
        ArrayList<SaleRebateRuleThreshold> saleRebateRuleThresholdList = new ArrayList<SaleRebateRuleThreshold>();
        for (PurchaseRebateRuleThreshold purchaseRebateRuleThreshold : purchaseRebateRuleThresholdList) {
            SaleRebateRuleThreshold saleRebateRuleThreshold = new SaleRebateRuleThreshold();
            BeanUtils.copyProperties((Object)((Object)purchaseRebateRuleThreshold), (Object)((Object)saleRebateRuleThreshold));
            saleRebateRuleThreshold.setId(null);
            saleRebateRuleThreshold.setElsAccount(saleRebateRule.getElsAccount());
            saleRebateRuleThreshold.setToElsAccount(saleRebateRule.getToElsAccount());
            saleRebateRuleThreshold.setBusAccount(saleRebateRule.getBusAccount());
            saleRebateRuleThreshold.setHeadId(saleRebateRule.getId());
            saleRebateRuleThreshold.setRelationId(purchaseRebateRuleThreshold.getId());
            saleRebateRuleThresholdList.add(saleRebateRuleThreshold);
        }
        this.saleRebateRuleThresholdMapper.insertBatchSomeColumn(saleRebateRuleThresholdList);
    }

    private void handleSaleRebateRuleItem(SaleRebateRule saleRebateRule, List<PurchaseRebateRuleItem> purchaseRebateRuleItemList) {
        if (CollectionUtils.isEmpty(purchaseRebateRuleItemList)) {
            return;
        }
        ArrayList<SaleRebateRuleItem> saleRebateRuleItemList = new ArrayList<SaleRebateRuleItem>();
        for (PurchaseRebateRuleItem purchaseRebateRuleItem : purchaseRebateRuleItemList) {
            SaleRebateRuleItem saleRebateRuleItem = new SaleRebateRuleItem();
            BeanUtils.copyProperties((Object)((Object)purchaseRebateRuleItem), (Object)((Object)saleRebateRuleItem));
            saleRebateRuleItem.setId(null);
            saleRebateRuleItem.setElsAccount(saleRebateRule.getElsAccount());
            saleRebateRuleItem.setToElsAccount(saleRebateRule.getToElsAccount());
            saleRebateRuleItem.setBusAccount(saleRebateRule.getBusAccount());
            saleRebateRuleItem.setHeadId(saleRebateRule.getId());
            saleRebateRuleItem.setRelationId(purchaseRebateRuleItem.getId());
            saleRebateRuleItemList.add(saleRebateRuleItem);
        }
        this.saleRebateRuleItemMapper.insertBatchSomeColumn(saleRebateRuleItemList);
    }

    private void handleSaleAttachmentDetail(SaleRebateRule saleRebateRule, List<PurchaseAttachmentDTO> attachments) {
        if (CollectionUtils.isEmpty(attachments)) {
            return;
        }
        ArrayList<SaleAttachmentDTO> saleAttachments = new ArrayList<SaleAttachmentDTO>();
        for (PurchaseAttachmentDTO purchaseAttachment : attachments) {
            purchaseAttachment.setSendStatus("1");
            SaleAttachmentDTO saleAttachment = new SaleAttachmentDTO();
            BeanUtils.copyProperties((Object)purchaseAttachment, (Object)saleAttachment);
            saleAttachment.setId(null);
            saleAttachment.setElsAccount(saleRebateRule.getElsAccount());
            saleAttachment.setHeadId(saleRebateRule.getId());
            saleAttachment.setRelationId(purchaseAttachment.getId());
            saleAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
            saleAttachments.add(saleAttachment);
        }
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachments);
    }
}

