/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.ElsStatusLog;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.ElsStatusLogDTO;
import com.els.modules.finance.api.enumerate.DeductCostTypeEnum;
import com.els.modules.finance.excel.PurchaseRecAcceptReturnExportServiceImpl;
import com.els.modules.reconciliation.entity.PurchasePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.entity.PurchaseRecAcceptReturn;
import com.els.modules.reconciliation.entity.PurchaseRecAdditionalCharges;
import com.els.modules.reconciliation.entity.PurchaseRecCharge;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.enumerate.OperationEnum;
import com.els.modules.reconciliation.excel.PurchaseReconciliationExportServiceImpl;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsSourceCaseService;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffService;
import com.els.modules.reconciliation.service.PurchaseInvoiceHookInformationService;
import com.els.modules.reconciliation.service.PurchaseInvoiceService;
import com.els.modules.reconciliation.service.PurchasePrePaymentWriteOffReconciliationService;
import com.els.modules.reconciliation.service.PurchaseRecAcceptReturnService;
import com.els.modules.reconciliation.service.PurchaseRecAdditionalChargesService;
import com.els.modules.reconciliation.service.PurchaseRecChargeService;
import com.els.modules.reconciliation.service.PurchaseReconciliationService;
import com.els.modules.reconciliation.vo.PurchaseInvoiceHookVO;
import com.els.modules.reconciliation.vo.PurchaseReconciliationVO;
import com.els.modules.supplier.api.enumerate.SupplierCoordinationWayEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/reconciliation/purchaseReconciliation"})
@Api(tags={"\u5e93\u5b58\u5bf9\u8d26\u7ba1\u7406"})
public class PurchaseReconciliationController
extends BaseController<PurchaseReconciliation, PurchaseReconciliationService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseReconciliationController.class);
    @Autowired
    private PurchaseReconciliationService purchaseReconciliationService;
    @Autowired
    private PurchaseRecAcceptReturnService purchaseRecAcceptReturnService;
    @Autowired
    private PurchaseRecAdditionalChargesService purchaseRecAdditionalChargesService;
    @Autowired
    private PurchaseRecChargeService purchaseRecChargeService;
    @Autowired
    private PurchaseInvoiceService purchaseInvoiceService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchasePrePaymentWriteOffReconciliationService purchasePrePaymentWriteOffReconciliationService;
    @Autowired
    private ElsPurchaseStatisticsWriteOffService elsPurchaseStatisticsWriteOffService;
    @Autowired
    private ElsPurchaseStatisticsSourceCaseService elsPurchaseStatisticsSourceCaseService;
    @Autowired
    private PurchaseInvoiceHookInformationService purchaseInvoiceHookInformationService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String LOCK_KEY = "srm_reconciliation_";
    private static final Long LOCK_EXPIRE_TIME = 30000L;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:list"})
    @PermissionDataView(businessType="reconciliation")
    public Result<?> queryPageList(PurchaseReconciliation purchaseReconciliation, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseReconciliation), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseReconciliationService.page((IPage)page, (Wrapper)queryWrapper);
        List records = pageList.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return Result.ok((Object)pageList);
        }
        this.elsPurchaseStatisticsSourceCaseService.handleReconciliationStatisticsInfo(records);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @PermissionDataView(businessType="reconciliation")
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:list"})
    public Result<?> counts(PurchaseReconciliation purchaseReconciliation, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseReconciliation), (Map)req.getParameterMap());
        queryWrapper.select((Object[])new String[]{"status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"status");
        List list = ((PurchaseReconciliationService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseReconciliation::getStatus, PurchaseReconciliation::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "status", null, all));
        List srmReconciliationStatus = this.invokeBaseRpcService.queryDictItemsByCode("reconciliationBillStatus", TenantContext.getTenant());
        for (DictDTO status : srmReconciliationStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "status", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryPageNoChargeList"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:queryPageNoChargeList"})
    public Result<?> queryPageNoChargeList(PurchaseReconciliation purchaseReconciliation, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseReconciliation), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        ((LambdaQueryWrapper)queryWrapper.lambda().gt(PurchaseReconciliation::getChargeAmount, (Object)BigDecimal.ZERO)).nested(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.isNull(PurchaseReconciliation::getAlreadyChargeAmount)).or()).apply("already_charge_amount<charge_amount", new Object[0]);
        });
        IPage pageList = this.purchaseReconciliationService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryReconciliationItemList"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:queryReconciliationItemList"})
    public Result<?> queryReconciliationItemList(PurchaseReconciliation purchaseReconciliation) {
        JSONObject jsonObject = JSONObject.parseObject((String)purchaseReconciliation.getId());
        String id = jsonObject.getString("id");
        PurchaseReconciliationVO purchaseReconciliationVO = this.purchaseReconciliationService.queryReconciliationItemList(purchaseReconciliation, id);
        return Result.ok((Object)((Object)purchaseReconciliationVO));
    }

    @SrmValidated
    @AutoLog(value="\u5bf9\u8d26\u5934-\u6dfb\u52a0", logType=2)
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:add"})
    @PermissionDataOpt(businessType="reconciliation", beanClass=PurchaseReconciliationService.class)
    @FormCommit
    public Result<?> add(@RequestBody PurchaseReconciliationVO vo) {
        PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseReconciliation));
        this.purchaseReconciliationService.saveMain(purchaseReconciliation, vo);
        return Result.ok((Object)((Object)purchaseReconciliation));
    }

    @SrmValidated
    @AutoLog(value="\u5bf9\u8d26\u5934-\u7f16\u8f91", logType=2)
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:edit"})
    @PermissionDataOpt(businessType="reconciliation", beanClass=PurchaseReconciliationService.class)
    public Result<?> edit(@RequestBody PurchaseReconciliationVO vo) {
        PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.purchaseReconciliationService.updateMain(purchaseReconciliation, vo);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:delete"})
    @PermissionDataOpt(businessType="reconciliation", beanClass=PurchaseReconciliationService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchaseReconciliationService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u67e5\u8be2\u8d26\u6263\u660e\u7ec6")
    @ApiOperation(value="\u67e5\u8be2\u8d26\u6263\u660e\u7ec6", notes="\u67e5\u8be2\u8d26\u6263\u660e\u7ec6")
    @GetMapping(value={"/getPurchaseReconciliationByIdList"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:getPurchaseReconciliationByIdList"})
    public Result<?> getPurchaseReconciliationByIdList(@RequestParam(name="ids", required=true) String ids) {
        List purchaseRecChargeList = new ArrayList();
        List<String> idList = Arrays.asList(ids.split(","));
        if (CollectionUtils.isEmpty(idList)) {
            return Result.ok(purchaseRecChargeList);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"head_id", idList);
        queryWrapper.eq((Object)"deduction_type", (Object)DeductCostTypeEnum.ACCOUNT_DEDUCTION.getValue());
        purchaseRecChargeList = this.purchaseRecChargeService.list((Wrapper)queryWrapper);
        return Result.ok(purchaseRecChargeList);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @BusinessModule(module="reconciliation")
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseReconciliation purchaseReconciliation = (PurchaseReconciliation)((Object)this.purchaseReconciliationService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseReconciliationVO purchaseReconciliationVO = new PurchaseReconciliationVO();
        BeanUtils.copyProperties((Object)((Object)purchaseReconciliation), (Object)((Object)purchaseReconciliationVO));
        if (!StringUtils.isEmpty((Object)purchaseReconciliation.getNeedCoordination()) && StringUtils.isEmpty((Object)purchaseReconciliation.getIsTeamwork())) {
            if ("1".equals(purchaseReconciliation.getNeedCoordination())) {
                purchaseReconciliationVO.setIsTeamwork(SupplierCoordinationWayEnum.SRM_COORDINATIONWAY.getValue());
            } else if ("0".equals(purchaseReconciliation.getNeedCoordination())) {
                purchaseReconciliationVO.setIsTeamwork(SupplierCoordinationWayEnum.NO_COORDINATIONWAY.getValue());
            }
        }
        purchaseReconciliationVO.setRecAcceptReturnList(this.purchaseRecAcceptReturnService.selectByMainId(id));
        purchaseReconciliationVO.setRecAdditionalChargesList(this.purchaseRecAdditionalChargesService.selectByMainId(id));
        purchaseReconciliationVO.setRecChargeList(this.purchaseRecChargeService.selectByMainId(id));
        purchaseReconciliationVO.setInvoiceList(this.purchaseInvoiceService.selectByMainId(id));
        List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList = this.purchasePrePaymentWriteOffReconciliationService.selectByMainId(id);
        this.elsPurchaseStatisticsWriteOffService.handlePrePaymentWriteOffList(purchasePrePaymentWriteOffList, purchaseReconciliation.getReconciliationNumber());
        purchaseReconciliationVO.setPrePaymentWriteOffList(purchasePrePaymentWriteOffList);
        purchaseReconciliationVO.setAttachments(this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id));
        purchaseReconciliationVO.setElsStatusLogList(this.listStatusLog(id, "srmReconciliationStatus"));
        return Result.ok((Object)((Object)purchaseReconciliationVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u5bf9\u8d26\u5934id\u67e5\u8be2\u6536\u9000\u8d27\u660e\u7ec6", notes="\u901a\u8fc7\u5bf9\u8d26\u5934id\u67e5\u8be2\u6536\u9000\u8d27\u660e\u7ec6")
    @GetMapping(value={"/queryPurchaseRecAcceptReturnByMainId"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:view"})
    public Result<?> queryPurchaseRecAcceptReturnListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList = this.purchaseRecAcceptReturnService.selectByMainId(id);
        return Result.ok(purchaseRecAcceptReturnList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5bf9\u8d26\u5934id\u67e5\u8be2\u9644\u52a0\u8d39\u7528\u660e\u7ec6", notes="\u901a\u8fc7\u5bf9\u8d26\u5934id\u67e5\u8be2\u9644\u52a0\u8d39\u7528\u660e\u7ec6")
    @GetMapping(value={"/queryPurchaseRecAdditionalChargesByMainId"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:view"})
    public Result<?> queryPurchaseRecAdditionalChargesListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseRecAdditionalCharges> purchaseRecAdditionalChargesList = this.purchaseRecAdditionalChargesService.selectByMainId(id);
        return Result.ok(purchaseRecAdditionalChargesList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5bf9\u8d26\u5934id\u67e5\u8be2\u6263\u6b3e\u660e\u7ec6", notes="\u901a\u8fc7\u5bf9\u8d26\u5934id\u67e5\u8be2\u6263\u6b3e\u660e\u7ec6")
    @GetMapping(value={"/queryPurchaseRecChargeByMainId"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:view"})
    public Result<?> queryPurchaseRecChargeListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseRecCharge> purchaseRecChargeList = this.purchaseRecChargeService.selectByMainId(id);
        return Result.ok(purchaseRecChargeList);
    }

    @ApiOperation(value="\u63d0\u53d6\u5bf9\u8d26\u5355", notes="\u63d0\u53d6\u5bf9\u8d26\u5355")
    @PostMapping(value={"/extractReconciliation"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:extractReconciliation"})
    @PermissionDataOpt(businessType="reconciliation", beanClass=PurchaseReconciliationService.class)
    public Result<?> extractReconciliation(@RequestBody PurchaseReconciliationVO vo) {
        return Result.ok((Object)((Object)this.purchaseReconciliationService.extractReconciliation(vo)));
    }

    @SrmValidated
    @AutoLog(value="\u5bf9\u8d26\u5934-\u53d1\u5e03", logType=2)
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:publish"})
    public Result<?> publish(@RequestBody PurchaseReconciliationVO vo) {
        Result result = new Result();
        PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseReconciliation));
        if (!this.redisUtil.tryGetDistributedLock("supplier_reconciliation_", purchaseReconciliation.getToElsAccount(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_AvjDiKUmRdXIeVRSsK_72c19add", (String)"\u5176\u4ed6\u7528\u6237\u6b63\u5728\u4e0e\u6b64\u4f9b\u5e94\u5546\u5bf9\u8d26\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01"));
        }
        try {
            result = this.purchaseReconciliationService.publish(purchaseReconciliation, vo);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock("supplier_reconciliation_", purchaseReconciliation.getToElsAccount());
        }
        return result;
    }

    @SrmValidated
    @AutoLog(value="\u5bf9\u8d26\u5934-\u53d1\u7968\u62d2\u7edd", logType=2)
    @ApiOperation(value="\u53d1\u7968\u62d2\u7edd", notes="\u53d1\u7968\u62d2\u7edd")
    @PostMapping(value={"/invoiceRefused"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:invoiceRefused"})
    public Result<?> invoicerefused(@RequestBody PurchaseReconciliationVO vo) {
        Result result = new Result();
        PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            result = this.purchaseReconciliationService.invoiceRefusedOrConfirm(purchaseReconciliation, vo.getInvoiceList(), OperationEnum.REFUSED.getValue());
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return result;
    }

    @SrmValidated
    @AutoLog(value="\u5bf9\u8d26\u5934-\u52fe\u7a3d\u786e\u8ba4", logType=2)
    @ApiOperation(value="\u52fe\u7a3d\u786e\u8ba4", notes="\u52fe\u7a3d\u786e\u8ba4")
    @PostMapping(value={"/hookConfirm"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:hookConfirm"})
    public Result<?> hookConfirm(@RequestBody PurchaseReconciliationVO vo) {
        Result result = new Result();
        PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            result = this.purchaseReconciliationService.hookConfirm(purchaseReconciliation, vo.getInvoiceList());
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return result;
    }

    @SrmValidated
    @AutoLog(value="\u5bf9\u8d26\u5934-\u53d1\u7968\u786e\u8ba4", logType=2)
    @ApiOperation(value="\u53d1\u7968\u786e\u8ba4", notes="\u53d1\u7968\u786e\u8ba4")
    @PostMapping(value={"/invoiceConfirmed"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:invoiceConfirmed"})
    @PermissionDataOpt(businessType="reconciliation", beanClass=PurchaseReconciliationService.class)
    public Result<?> invoiceConfirmed(@RequestBody PurchaseReconciliationVO vo) {
        Result result = new Result();
        PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            result = this.purchaseReconciliationService.invoiceRefusedOrConfirm(purchaseReconciliation, vo.getInvoiceList(), OperationEnum.CONFIRM.getValue());
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return result;
    }

    @SrmValidated
    @AutoLog(value="\u5bf9\u8d26\u5934-\u5bf9\u8d26\u5355\u786e\u8ba4", logType=2)
    @ApiOperation(value="\u5bf9\u8d26\u5355\u786e\u8ba4", notes="\u5bf9\u8d26\u5355\u786e\u8ba4")
    @PostMapping(value={"/confirmed"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:confirmed"})
    @PermissionDataOpt(businessType="reconciliation", beanClass=PurchaseReconciliationService.class)
    public Result<?> confirmed(@RequestBody PurchaseReconciliationVO vo) {
        Result result = new Result();
        PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            result = this.purchaseReconciliationService.refusedOrConfirm(purchaseReconciliation, OperationEnum.CONFIRM.getValue());
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return result;
    }

    @SrmValidated
    @AutoLog(value="\u5bf9\u8d26\u5934-\u5bf9\u8d26\u5355\u62d2\u7edd", logType=2)
    @ApiOperation(value="\u5bf9\u8d26\u5355\u62d2\u7edd", notes="\u5bf9\u8d26\u5355\u62d2\u7edd")
    @PostMapping(value={"/refused"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:refused"})
    public Result<?> refused(@RequestBody PurchaseReconciliationVO vo) {
        Result result = new Result();
        PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            result = this.purchaseReconciliationService.refusedOrConfirm(purchaseReconciliation, OperationEnum.REFUSED.getValue());
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return result;
    }

    @AutoLog(value="\u5bf9\u8d26\u5934-\u901a\u8fc7id\u4f5c\u5e9f")
    @ApiOperation(value="\u901a\u8fc7id\u4f5c\u5e9f", notes="\u901a\u8fc7id\u4f5c\u5e9f")
    @GetMapping(value={"/cancellation"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:cancellation"})
    @PermissionDataOpt(businessType="reconciliation", beanClass=PurchaseReconciliationService.class)
    public Result<?> cancellation(@RequestParam(name="id", required=true) String id) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, id, LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.purchaseReconciliationService.cancellation(id);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, id);
        }
        return this.commonSuccessResult(4);
    }

    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:export"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseReconciliationExportServiceImpl.class);
    }

    @PostMapping(value={"/exportPurchaseRecAcceptReturnExportXls"})
    @RequiresPermissions(value={"purchaseReconciliation:purchaseRecAcceptReturnExport"})
    public ModelAndView exportPurchaseRecAcceptReturnXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseRecAcceptReturnExportServiceImpl.class);
    }

    private List<ElsStatusLog> listStatusLog(String id, String dictCode) {
        List list = this.invokeBaseRpcService.listStatusLog(id);
        ArrayList<ElsStatusLog> objects = new ArrayList<ElsStatusLog>();
        List srmReconciliationStatus = this.invokeBaseRpcService.queryDictItemsByCode(dictCode, TenantContext.getTenant());
        if (CollectionUtils.isEmpty((Collection)srmReconciliationStatus)) {
            return objects;
        }
        Map collect = srmReconciliationStatus.parallelStream().collect(Collectors.toMap(DictDTO::getValue, Function.identity()));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return objects;
        }
        for (ElsStatusLogDTO elsStatusLog : list) {
            if (!collect.containsKey(elsStatusLog.getBusinessStatus())) continue;
            DictDTO dictDTO = (DictDTO)collect.get(elsStatusLog.getBusinessStatus());
            elsStatusLog.setBusinessStatus_dictText(I18nUtil.translate((String)dictDTO.getTextI18nKey(), (String)dictDTO.getText()));
        }
        HashMap collect1 = CollectionUtils.isEmpty((Collection)list) ? new HashMap() : list.parallelStream().collect(Collectors.toMap(ElsStatusLogDTO::getBusinessStatus, Function.identity(), (Key1, key2) -> key2));
        for (DictDTO dict : srmReconciliationStatus) {
            if (collect1.containsKey(dict.getValue())) {
                objects.add((ElsStatusLog)SysUtil.copyProperties(collect1.get(dict.getValue()), ElsStatusLog.class));
                continue;
            }
            objects.add(new ElsStatusLog().setBusinessType("reconciliation").setBusinessId(id).setBusinessStatus(dict.getValue()).setBusinessStatus_dictText(I18nUtil.translate((String)dict.getTextI18nKey(), (String)dict.getText())));
        }
        return objects;
    }

    @ApiOperation(value="\u83b7\u53d6ERP\u6570\u636e", notes="\u83b7\u53d6ERP\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:getDataByErp"})
    public Result<?> getDataByErp() {
        this.purchaseReconciliationService.getDataByErp();
        return Result.ok();
    }

    @ApiOperation(value="SRM\u63a8\u9001\u5230ERP", notes="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:pushDataToErp"})
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        this.purchaseReconciliationService.pushDataToErp(ids);
        return Result.ok();
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u5bf9\u8d26\u5934-\u53d1\u7968\u4fdd\u5b58", logType=2)
    @ApiOperation(value="\u53d1\u7968\u4fdd\u5b58", notes="\u53d1\u7968\u4fdd\u5b58")
    @PostMapping(value={"/saveInvoice"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:saveInvoice"})
    public Result<?> saveInvoice(@RequestBody PurchaseReconciliationVO vo) {
        PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.purchaseReconciliationService.saveInvoice(purchaseReconciliation, vo.getInvoiceList(), "save");
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return Result.ok((Object)((Object)purchaseReconciliation));
    }

    @SrmValidated
    @AutoLog(value="\u52fe\u7a3d", logType=2)
    @ApiOperation(value="\u52fe\u7a3d", notes="\u52fe\u7a3d")
    @PostMapping(value={"/hook"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:hook"})
    public Result<?> hook(@RequestBody PurchaseInvoiceHookVO vo) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.purchaseInvoiceHookInformationService.hook(vo);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236")
    @GetMapping(value={"/copyData"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:copy"})
    @PermissionDataOpt(businessType="reconciliation", beanClass=PurchaseReconciliationService.class)
    public Result<?> copyData(@RequestParam(name="id", required=true) String id) {
        this.purchaseReconciliationService.copyData(id);
        return this.commonSuccessResult(3);
    }
}

