/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.api.vo.Result;
import com.els.common.util.DateUtils;
import com.els.modules.finance.entity.FinanceEnterpriseOutinvoice;
import com.els.modules.reconciliation.entity.InvoiceOcrData;
import com.els.modules.reconciliation.entity.InvoiceOcrDataFour;
import com.els.modules.reconciliation.entity.InvoiceOcrDataOne;
import com.els.modules.reconciliation.entity.InvoiceOcrDataThree;
import com.els.modules.reconciliation.entity.InvoiceOcrDataTwo;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.SaleInvoice;
import com.els.modules.reconciliation.enumerate.InvoiceStatusEnum;
import com.els.modules.reconciliation.enumerate.InvoiceTypeToClass;
import com.els.modules.reconciliation.enumerate.OperationEnum;
import com.els.modules.reconciliation.mapper.PurchaseInvoiceMapper;
import com.els.modules.reconciliation.mapper.SaleInvoiceMapper;
import com.els.modules.reconciliation.service.InvoiceOcrDataFourService;
import com.els.modules.reconciliation.service.InvoiceOcrDataOneService;
import com.els.modules.reconciliation.service.InvoiceOcrDataThreeService;
import com.els.modules.reconciliation.service.InvoiceOcrDataTwoService;
import com.els.modules.reconciliation.service.InvoiceService;
import com.els.modules.reconciliation.service.SaleInvoiceService;
import com.els.modules.reconciliation.service.impl.EveryConvergeInvoiceService;
import com.els.modules.reconciliation.service.impl.NuonuoInvoiceService;
import com.els.modules.reconciliation.vo.InvoiceDetailVO;
import com.els.modules.reconciliation.vo.response.InvoiceResultVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleInvoiceServiceImpl
extends ServiceImpl<SaleInvoiceMapper, SaleInvoice>
implements SaleInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(SaleInvoiceServiceImpl.class);
    @Resource
    private SaleInvoiceMapper saleInvoiceMapper;
    @Resource
    private PurchaseInvoiceMapper purchaseInvoiceMapper;
    @Autowired
    private InvoiceOcrDataOneService invoiceOcrDataOneService;
    @Autowired
    private InvoiceOcrDataTwoService invoiceOcrDataTwoService;
    @Autowired
    private InvoiceOcrDataThreeService invoiceOcrDataThreeService;
    @Autowired
    private InvoiceOcrDataFourService invoiceOcrDataFourService;
    @Autowired
    private EveryConvergeInvoiceService everyConvergeInvoiceService;
    @Autowired
    private NuonuoInvoiceService nuonuoInvoiceService;

    @Override
    public List<SaleInvoice> selectByMainId(String mainId) {
        return this.saleInvoiceMapper.selectByMainId(mainId);
    }

    @Override
    public void saveSaleInvoice(SaleInvoice saleInvoice) {
        ((SaleInvoiceMapper)this.baseMapper).insert((Object)saleInvoice);
    }

    @Override
    public void updateSaleInvoice(SaleInvoice saleInvoice) {
        ((SaleInvoiceMapper)this.baseMapper).updateById((Object)saleInvoice);
    }

    @Override
    public void delSaleInvoice(String id) {
        ((SaleInvoiceMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchSaleInvoice(List<String> idList) {
        ((SaleInvoiceMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<SaleInvoice> invoiceOCRToSaleInvoice(List<InvoiceOcrData> invoiceOcrDataList) throws ParseException {
        ArrayList<SaleInvoice> saleInvoiceArrayList = new ArrayList<SaleInvoice>();
        if (CollectionUtil.isNotEmpty(invoiceOcrDataList)) {
            for (InvoiceOcrData invoiceOcrData : invoiceOcrDataList) {
                BigDecimal taxTotal;
                BigDecimal netToatal;
                BigDecimal bigDecimal;
                Date invoiceDate;
                String vatInvoiceIssueDate;
                SaleInvoice saleInvoice = new SaleInvoice();
                String invoiceType = invoiceOcrData.getInvoiceType();
                String id = invoiceOcrData.getId();
                InvoiceTypeToClass invoiceTypeToClass = new InvoiceTypeToClass();
                if (invoiceTypeToClass.getOne().contains(invoiceType) || "netocr".equals(invoiceOcrData.getFbk1())) {
                    List<InvoiceOcrDataOne> invoiceOcrDataOneList = this.invoiceOcrDataOneService.selectByMainId(id);
                    InvoiceOcrDataOne invoiceOcrDataOne = invoiceOcrDataOneList.get(0);
                    vatInvoiceIssueDate = invoiceOcrDataOne.getVatInvoiceIssueDate();
                    invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                    saleInvoice.setInvoiceTime(invoiceDate);
                    saleInvoice.setInvoiceNo(invoiceOcrDataOne.getVatInvoiceHaoma());
                    saleInvoice.setInvoiceCode(invoiceOcrDataOne.getVatInvoiceDaima());
                    saleInvoice.setInvoiceTitle(invoiceOcrDataOne.getVatInvoicePayerName());
                    saleInvoice.setInvoiceImg(invoiceOcrData.getFileId() + "-" + invoiceOcrData.getFileName());
                    bigDecimal = new BigDecimal(invoiceOcrDataOne.getVatInvoiceTotalCoverTaxDigits());
                    saleInvoice.setIncludeTaxAmount(bigDecimal);
                    netToatal = new BigDecimal(invoiceOcrDataOne.getVatInvoiceTotal());
                    saleInvoice.setNotIncludeTaxAmount(netToatal);
                    taxTotal = new BigDecimal(invoiceOcrDataOne.getVatInvoiceTaxTotal());
                    saleInvoice.setTaxAmount(taxTotal);
                    saleInvoiceArrayList.add(saleInvoice);
                    continue;
                }
                if (invoiceTypeToClass.getTwo().contains(invoiceType)) {
                    List<InvoiceOcrDataTwo> invoiceOcrDataTwoList = this.invoiceOcrDataTwoService.selectByMainId(id);
                    InvoiceOcrDataTwo invoiceOcrDataTwo = invoiceOcrDataTwoList.get(0);
                    String vehicleInvoiceIssueDate = invoiceOcrDataTwo.getVehicleInvoiceIssueDate();
                    invoiceDate = DateUtils.parseDate((String)vehicleInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                    saleInvoice.setInvoiceTime(invoiceDate);
                    saleInvoice.setInvoiceNo(invoiceOcrDataTwo.getVehicleInvoiceHaoma());
                    saleInvoice.setInvoiceCode(invoiceOcrDataTwo.getVehicleInvoiceDaima());
                    saleInvoice.setInvoiceTitle(invoiceOcrDataTwo.getVehicleInvoiceBuyer());
                    saleInvoice.setInvoiceImg(invoiceOcrData.getFileId() + "-" + invoiceOcrData.getFileName());
                    bigDecimal = new BigDecimal(invoiceOcrDataTwo.getVehicleInvoiceTotalPriceDigits());
                    saleInvoice.setIncludeTaxAmount(bigDecimal);
                    netToatal = new BigDecimal(invoiceOcrDataTwo.getVehicleInvoicePriceWithoutTax());
                    saleInvoice.setNotIncludeTaxAmount(netToatal);
                    taxTotal = new BigDecimal(invoiceOcrDataTwo.getVehicleInvoiceTaxAmount());
                    saleInvoice.setIncludeTaxAmount(taxTotal);
                    saleInvoiceArrayList.add(saleInvoice);
                    continue;
                }
                if (invoiceTypeToClass.getThree().contains(invoiceType)) {
                    List<InvoiceOcrDataThree> invoiceOcrDataThreeList = this.invoiceOcrDataThreeService.selectByMainId(id);
                    InvoiceOcrDataThree invoiceOcrDataThree = invoiceOcrDataThreeList.get(0);
                    vatInvoiceIssueDate = invoiceOcrDataThree.getVehicleInvoiceIssueDate();
                    invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                    saleInvoice.setInvoiceTime(invoiceDate);
                    saleInvoice.setInvoiceNo(invoiceOcrDataThree.getVehicleInvoiceHaoma());
                    saleInvoice.setInvoiceCode(invoiceOcrDataThree.getVehicleInvoiceDaima());
                    saleInvoice.setInvoiceTitle(invoiceOcrDataThree.getVehicleInvoiceBuyer());
                    saleInvoice.setInvoiceImg(invoiceOcrData.getFileId() + "-" + invoiceOcrData.getFileName());
                    bigDecimal = new BigDecimal(invoiceOcrDataThree.getVehicleInvoiceTotalPriceDigits());
                    saleInvoice.setIncludeTaxAmount(bigDecimal);
                    saleInvoiceArrayList.add(saleInvoice);
                    continue;
                }
                if (!invoiceTypeToClass.getFour().contains(invoiceType)) continue;
                List<InvoiceOcrDataFour> invoiceOcrDataFourList = this.invoiceOcrDataFourService.selectByMainId(id);
                InvoiceOcrDataFour invoiceOcrDataFour = invoiceOcrDataFourList.get(0);
                vatInvoiceIssueDate = invoiceOcrDataFour.getDateOfInvoice();
                invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                saleInvoice.setInvoiceTime(invoiceDate);
                saleInvoice.setInvoiceNo(invoiceOcrDataFour.getInvoiceNumber());
                saleInvoice.setInvoiceCode(invoiceOcrDataFour.getInvoiceCode());
                saleInvoice.setInvoiceTitle(invoiceOcrDataFour.getInvoiceHead());
                saleInvoice.setInvoiceImg(invoiceOcrData.getFileId() + "-" + invoiceOcrData.getFileName());
                bigDecimal = new BigDecimal(invoiceOcrDataFour.getTotalMoney());
                saleInvoice.setIncludeTaxAmount(bigDecimal);
                saleInvoiceArrayList.add(saleInvoice);
            }
        }
        return saleInvoiceArrayList;
    }

    @Override
    public BigDecimal invoiceRefusedOrConfirm(List<PurchaseInvoice> invoices, String operation) {
        BigDecimal invoiceTotalAmount = BigDecimal.ZERO;
        for (PurchaseInvoice purchaseInvoice : invoices) {
            if (OperationEnum.REFUSED.getValue().equals(operation)) {
                purchaseInvoice.setStatus(InvoiceStatusEnum.RENTURNED.getValue());
            } else if (OperationEnum.CONFIRM.getValue().equals(operation)) {
                purchaseInvoice.setStatus(InvoiceStatusEnum.CONFIRMED.getValue());
            }
            this.purchaseInvoiceMapper.updateById((Object)purchaseInvoice);
            SaleInvoice saleInvoice = (SaleInvoice)((Object)this.saleInvoiceMapper.selectById((Serializable)((Object)purchaseInvoice.getRelationId())));
            if (saleInvoice == null) {
                return invoiceTotalAmount;
            }
            if (OperationEnum.CONFIRM.getValue().equals(operation)) {
                SaleInvoice invoice = new SaleInvoice();
                BeanUtils.copyProperties((Object)((Object)purchaseInvoice), (Object)((Object)invoice));
                invoice.setId(saleInvoice.getId());
                invoice.setElsAccount(saleInvoice.getElsAccount());
                invoice.setToElsAccount(saleInvoice.getToElsAccount());
                invoice.setBusAccount(saleInvoice.getBusAccount());
                invoice.setHeadId(saleInvoice.getHeadId());
                invoice.setNotIncludeTaxAmount(invoice.getIncludeTaxAmount().subtract(invoice.getTaxAmount()));
                this.saleInvoiceMapper.updateById((Object)invoice);
                invoiceTotalAmount = invoiceTotalAmount.add(invoice.getIncludeTaxAmount());
                continue;
            }
            saleInvoice.setPurchaseRemark(purchaseInvoice.getPurchaseRemark());
            saleInvoice.setStatus(purchaseInvoice.getStatus());
            this.saleInvoiceMapper.updateById((Object)saleInvoice);
        }
        return invoiceTotalAmount;
    }

    @Override
    public Result<?> billing(List<InvoiceDetailVO> details, FinanceEnterpriseOutinvoice saleOutinvoice, FinanceEnterpriseOutinvoice purchaseOutinvoice, SaleInvoice saleInvoice) {
        InvoiceService invoiceService = this.getInvoiceService("nuonuo");
        return invoiceService.billing(details, saleOutinvoice, purchaseOutinvoice, saleInvoice);
    }

    @Override
    public void createSaleInvoice(InvoiceResultVO resultVO) {
        InvoiceService invoiceService = this.getInvoiceService("nuonuo");
        invoiceService.createInvoice(resultVO);
    }

    @Override
    public void deleteByRelationIds(Set<String> ids) {
        ((SaleInvoiceMapper)this.baseMapper).deleteByRelationIds(ids);
    }

    private InvoiceService getInvoiceService(String storageMedia) {
        switch (storageMedia) {
            case "nuonuo": {
                return this.nuonuoInvoiceService;
            }
            case "everyConverge": {
                return this.everyConvergeInvoiceService;
            }
        }
        return this.nuonuoInvoiceService;
    }
}

