/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.finance.api.enumerate.DeductCostConfirmStatusEnum;
import com.els.modules.finance.api.enumerate.DeductCostSourceEnum;
import com.els.modules.finance.api.enumerate.DeductCostStatusEnum;
import com.els.modules.finance.api.enumerate.DeductCostTypeEnum;
import com.els.modules.finance.entity.PurchaseDeductCost;
import com.els.modules.finance.service.PurchaseDeductCostService;
import com.els.modules.finance.vo.PurchaseDeductCostVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u91c7\u8d2d\u6263\u6b3e\u8d39\u7528\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/finance/purchaseDeductCost"})
public class PurchaseDeductCostController
extends BaseController<PurchaseDeductCost, PurchaseDeductCostService> {
    @Autowired
    private PurchaseDeductCostService purchaseDeductCostService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseDeductCost purchaseDeductCost, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseDeductCost), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseDeductCostService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCount(PurchaseDeductCost purchaseDeductCost, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseDeductCost), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"confirm_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"confirm_status");
        List list = ((PurchaseDeductCostService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseDeductCost::getConfirmStatus, PurchaseDeductCost::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "confirmStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmDeductConfirmStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "confirmStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @AutoLog(value="\u91c7\u8d2d\u6263\u6b3e\u8d39\u7528\u7ba1\u7406-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"deductCost#purchaseDeductCost:add"})
    @PermissionDataOpt(businessType="deductCost", beanClass=PurchaseDeductCostService.class)
    public Result<?> add(@RequestBody PurchaseDeductCost purchaseDeductCost) {
        String elsAccount = this.getTenantId();
        purchaseDeductCost.setElsAccount(elsAccount);
        purchaseDeductCost.setBusAccount(elsAccount);
        purchaseDeductCost.setDeductStatus(DeductCostStatusEnum.NO_RECONCILIATION.getValue());
        if (StringUtils.isEmpty((CharSequence)purchaseDeductCost.getDeductType())) {
            purchaseDeductCost.setDeductType(DeductCostTypeEnum.TICKET_DEDUCTION.getValue());
        }
        purchaseDeductCost.setSourceType(DeductCostSourceEnum.SRM.getValue());
        purchaseDeductCost.setConfirmStatus(DeductCostConfirmStatusEnum.NEW.getValue());
        purchaseDeductCost.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        this.purchaseDeductCostService.savePurchaseDeductCost(purchaseDeductCost);
        return Result.ok((Object)((Object)purchaseDeductCost));
    }

    @AutoLog(value="\u91c7\u8d2d\u6263\u6b3e\u8d39\u7528\u7ba1\u7406-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"deductCost#purchaseDeductCost:edit"})
    @PermissionDataOpt(businessType="deductCost", beanClass=PurchaseDeductCostService.class)
    public Result<?> edit(@RequestBody PurchaseDeductCost purchaseDeductCost) {
        String elsAccount = this.getTenantId();
        purchaseDeductCost.setElsAccount(elsAccount);
        purchaseDeductCost.setBusAccount(elsAccount);
        this.purchaseDeductCostService.updatePurchaseDeductCost(purchaseDeductCost);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u6263\u6b3e\u8d39\u7528-\u53d1\u9001\u6263\u6b3e\u8d39\u7528\u5355")
    @ApiOperation(value="\u53d1\u9001\u6263\u6b3e\u8d39\u7528\u5355", notes="\u53d1\u9001\u6263\u6b3e\u8d39\u7528\u5355")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"deductCost#purchaseDeductCost:publish"})
    @PermissionDataOpt(businessType="deductCost", beanClass=PurchaseDeductCostService.class)
    public Result<?> publish(@RequestBody PurchaseDeductCost purchaseDeductCost) {
        this.purchaseDeductCostService.sendDeductCost(purchaseDeductCost);
        return Result.ok((Object)((Object)purchaseDeductCost));
    }

    @AutoLog(value="\u91c7\u8d2d\u6263\u6b3e\u8d39\u7528\u7ba1\u7406-\u901a\u8fc7id\u4f5c\u5e9f")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u4f5c\u5e9f")
    @PostMapping(value={"/invalid"})
    @RequiresPermissions(value={"deductCost#purchaseDeductCost:invalid"})
    @PermissionDataOpt(businessType="deductCost", beanClass=PurchaseDeductCostService.class)
    public Result<?> invalid(@RequestBody PurchaseDeductCost purchaseDeductCost) {
        this.purchaseDeductCostService.invalidPurchaseDeductCost(purchaseDeductCost);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u6263\u6b3e\u8d39\u7528\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"deductCost#purchaseDeductCost:delete"})
    @PermissionDataOpt(businessType="deductCost", beanClass=PurchaseDeductCostService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        PurchaseDeductCost purchaseDeductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)id)));
        if (purchaseDeductCost != null && !StringUtils.isEmpty((CharSequence)purchaseDeductCost.getDocumentId())) {
            this.invokeBaseRpcService.delIntegratedDocumentMain("deductCostId", purchaseDeductCost.getDocumentId(), null, purchaseDeductCost.getId());
        }
        this.purchaseDeductCostService.delPurchaseDeductCost(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u6263\u6b3e\u8d39\u7528\u7ba1\u7406-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseDeductCostService.delBatchPurchaseDeductCost(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseDeductCost purchaseDeductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)id)));
        PurchaseDeductCostVO purchaseDeductCostVO = new PurchaseDeductCostVO();
        BeanUtils.copyProperties((Object)((Object)purchaseDeductCost), (Object)((Object)purchaseDeductCostVO));
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseDeductCostVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return Result.ok((Object)((Object)purchaseDeductCostVO));
    }
}

