/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.finance.api.enumerate.DeductCostConfirmStatusEnum;
import com.els.modules.finance.entity.PurchaseDeductCost;
import com.els.modules.finance.entity.SaleDeductCost;
import com.els.modules.finance.mapper.PurchaseDeductCostMapper;
import com.els.modules.finance.service.PurchaseDeductCostService;
import com.els.modules.finance.service.SaleDeductCostService;
import com.els.modules.integrated.api.dto.IntegratedDocumentDTO;
import com.els.rpc.service.CoreInvokeSupplierRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseDeductCostServiceImpl
extends BaseServiceImpl<PurchaseDeductCostMapper, PurchaseDeductCost>
implements PurchaseDeductCostService {
    @Autowired
    private SaleDeductCostService saleDeductCostService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private CoreInvokeSupplierRpcService supplierContactsInfoService;
    @Resource
    private InvokeBaseRpcService baseRpcService;

    @Override
    public void savePurchaseDeductCost(PurchaseDeductCost purchaseDeductCost) {
        if (StringUtils.isBlank((CharSequence)purchaseDeductCost.getDeductNumber())) {
            purchaseDeductCost.setDeductNumber(this.invokeBaseRpcService.getNextCode("srmDeductCostNumber", (Object)purchaseDeductCost));
        }
        ((PurchaseDeductCostMapper)this.baseMapper).insert((Object)purchaseDeductCost);
        this.handleDocument(purchaseDeductCost);
    }

    private void handleDocument(PurchaseDeductCost purchaseDeductCost) {
        String idStr = IdWorker.getIdStr();
        purchaseDeductCost.setDocumentId(idStr);
        ((PurchaseDeductCostMapper)this.baseMapper).updateById((Object)purchaseDeductCost);
        IntegratedDocumentDTO integratedDocument = new IntegratedDocumentDTO();
        integratedDocument.setId(idStr);
        integratedDocument.setDeductCostId(purchaseDeductCost.getId());
        this.baseRpcService.saveIntegratedDocument(integratedDocument);
    }

    @Override
    public void updatePurchaseDeductCost(PurchaseDeductCost purchaseDeductCost) {
        this.calculateNetPrice(purchaseDeductCost);
        ((PurchaseDeductCostMapper)this.baseMapper).updateById((Object)purchaseDeductCost);
    }

    private void calculateNetPrice(PurchaseDeductCost deductCost) {
        BigDecimal taxRate = deductCost.getTaxRate() == null ? BigDecimal.ZERO : new BigDecimal(deductCost.getTaxRate()).divide(BigDecimal.valueOf(100L));
        BigDecimal taxAmount = deductCost.getTaxAmount() == null ? BigDecimal.ZERO : deductCost.getTaxAmount();
        BigDecimal netAmount = taxAmount.divide(BigDecimal.ONE.add(taxRate), 6, 4);
        deductCost.setNetAmount(netAmount);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void sendDeductCost(PurchaseDeductCost purchaseDeductCost) {
        boolean firstSend = true;
        String id = purchaseDeductCost.getId();
        String relationId = purchaseDeductCost.getRelationId();
        String elsAccount = purchaseDeductCost.getElsAccount();
        String toElsAccount = purchaseDeductCost.getToElsAccount();
        if (StringUtils.isBlank((CharSequence)relationId)) {
            relationId = IdWorker.getIdStr();
            purchaseDeductCost.setRelationId(relationId);
        } else {
            firstSend = false;
        }
        if ("0".equals(purchaseDeductCost.getRequiredConfirmation())) {
            purchaseDeductCost.setConfirmStatus(DeductCostConfirmStatusEnum.ALREADY_CONFIRM.getValue());
            purchaseDeductCost.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        } else {
            purchaseDeductCost.setConfirmStatus(DeductCostConfirmStatusEnum.WAIT_CONFIRM.getValue());
        }
        this.updatePurchaseDeductCost(purchaseDeductCost);
        SaleDeductCost saleDeductCost = new SaleDeductCost();
        BeanUtils.copyProperties((Object)((Object)purchaseDeductCost), (Object)((Object)saleDeductCost));
        saleDeductCost.setId(relationId);
        saleDeductCost.setRelationId(id);
        saleDeductCost.setElsAccount(toElsAccount);
        saleDeductCost.setToElsAccount(elsAccount);
        if (firstSend) {
            this.saleDeductCostService.saveSaleDeductCost(saleDeductCost);
        } else {
            this.saleDeductCostService.updateSaleDeductCost(saleDeductCost);
        }
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        if (CollectionUtil.isNotEmpty((Collection)purchaseAttachmentList)) {
            AttachmentSendDTO sendVO = new AttachmentSendDTO();
            sendVO.setElsAccount(elsAccount);
            sendVO.setHeadId(id);
            HashMap<String, String> toSend = new HashMap<String, String>();
            toSend.put(relationId, toElsAccount);
            sendVO.setToSend(toSend);
            this.invokeBaseRpcService.sendPurchaseFile(sendVO, false);
        }
        String urlParam = "id=" + purchaseDeductCost.getRelationId();
        super.sendMsg(purchaseDeductCost.getElsAccount(), purchaseDeductCost.getToElsAccount(), (Object)purchaseDeductCost, urlParam, "deductCost", "publish");
    }

    @Override
    public void delPurchaseDeductCost(String id) {
        ((PurchaseDeductCostMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseDeductCost(List<String> idList) {
        ((PurchaseDeductCostMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void invalidPurchaseDeductCost(PurchaseDeductCost purchaseDeductCost) {
        PurchaseDeductCost deductCost = new PurchaseDeductCost();
        deductCost.setId(purchaseDeductCost.getId());
        deductCost.setConfirmStatus(DeductCostConfirmStatusEnum.INVALID.getValue());
        this.updateById((Object)deductCost);
        if (StringUtils.isNotBlank((CharSequence)purchaseDeductCost.getRelationId())) {
            SaleDeductCost saleDeductCost = new SaleDeductCost();
            saleDeductCost.setId(purchaseDeductCost.getRelationId());
            saleDeductCost.setConfirmStatus(DeductCostConfirmStatusEnum.INVALID.getValue());
            this.saleDeductCostService.updateById((Object)saleDeductCost);
            String urlParam = "id=" + purchaseDeductCost.getRelationId();
            super.sendMsg(purchaseDeductCost.getElsAccount(), purchaseDeductCost.getToElsAccount(), (Object)purchaseDeductCost, urlParam, "deductCost", "cancel");
        }
    }
}

