/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.BaseDTO;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.finance.api.enumerate.PaymentApplyOtherEnum;
import com.els.modules.finance.api.enumerate.PaymentApplySourceTypeEnum;
import com.els.modules.finance.api.enumerate.PaymentApplyStatusEnum;
import com.els.modules.finance.entity.PurchasePaymentApplyHead;
import com.els.modules.finance.entity.PurchasePaymentApplyItem;
import com.els.modules.finance.entity.PurchasePaymentApplyOther;
import com.els.modules.finance.entity.SalePaymentApplyHead;
import com.els.modules.finance.entity.SalePaymentApplyItem;
import com.els.modules.finance.entity.SalePaymentApplyOther;
import com.els.modules.finance.mapper.PurchasePaymentApplyHeadMapper;
import com.els.modules.finance.mapper.PurchasePaymentApplyItemMapper;
import com.els.modules.finance.mapper.PurchasePaymentApplyOtherMapper;
import com.els.modules.finance.mapper.SalePaymentApplyItemMapper;
import com.els.modules.finance.mapper.SalePaymentApplyOtherMapper;
import com.els.modules.finance.rpc.ElsEnterpriseInfoLocalRpcService;
import com.els.modules.finance.rpc.FinanceInvokeOrderRpcService;
import com.els.modules.finance.service.PurchasePaymentApplyHeadService;
import com.els.modules.finance.service.PurchasePaymentApplyOtherService;
import com.els.modules.finance.service.SalePaymentApplyHeadService;
import com.els.modules.finance.service.SalePaymentApplyItemService;
import com.els.modules.finance.service.SalePaymentApplyOtherService;
import com.els.modules.finance.vo.PurchasePaymentApplyHeadVO;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.dto.PurchaseOrderItemDTO;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.service.PurchaseInvoiceService;
import com.els.modules.reconciliation.service.PurchaseReconciliationService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchasePaymentApplyHeadServiceImpl
extends BaseServiceImpl<PurchasePaymentApplyHeadMapper, PurchasePaymentApplyHead>
implements PurchasePaymentApplyHeadService {
    @Resource
    private PurchasePaymentApplyHeadMapper purchasePaymentApplyHeadMapper;
    @Resource
    private PurchasePaymentApplyItemMapper purchasePaymentApplyItemMapper;
    @Resource
    private PurchasePaymentApplyOtherMapper purchasePaymentApplyOtherMapper;
    @Autowired
    private SalePaymentApplyHeadService salePaymentApplyHeadService;
    @Autowired
    private SalePaymentApplyItemService salePaymentApplyItemService;
    @Autowired
    private SalePaymentApplyOtherService salePaymentApplyOtherService;
    @Resource
    private SalePaymentApplyItemMapper salePaymentApplyItemMapper;
    @Resource
    private SalePaymentApplyOtherMapper salePaymentApplyOtherMapper;
    @Resource
    private FinanceInvokeOrderRpcService financeInvokeOrderRpcService;
    @Autowired
    private PurchaseReconciliationService purchaseReconciliationService;
    @Autowired
    private PurchaseInvoiceService purchaseInvoiceService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private ElsEnterpriseInfoLocalRpcService elsEnterpriseInfoRpcService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchasePaymentApplyHead purchasePaymentApplyHead, List<PurchasePaymentApplyItem> purchasePaymentApplyItemList, List<PurchasePaymentApplyOther> purchasePaymentApplyOtherList) {
        purchasePaymentApplyHead.setPaymentApplyNumber(this.invokeBaseRpcService.getNextCode("srmApplyNumber", (Object)purchasePaymentApplyHead));
        ElsEnterpriseInfoDTO enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(TenantContext.getTenant());
        if (enterpriseInfo != null) {
            purchasePaymentApplyHead.setPurchaseName(enterpriseInfo.getName());
        }
        purchasePaymentApplyHead.setPaymentApplyStatus(PaymentApplyStatusEnum.OUTSTANDING.getValue());
        purchasePaymentApplyHead.setPush("0");
        purchasePaymentApplyHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        this.calculateAmount(purchasePaymentApplyHead, purchasePaymentApplyItemList, purchasePaymentApplyOtherList);
        this.purchasePaymentApplyHeadMapper.insert((Object)purchasePaymentApplyHead);
        this.insertData(purchasePaymentApplyHead, purchasePaymentApplyItemList, purchasePaymentApplyOtherList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchasePaymentApplyHead purchasePaymentApplyHead, List<PurchasePaymentApplyItem> purchasePaymentApplyItemList, List<PurchasePaymentApplyOther> purchasePaymentApplyOtherList) {
        this.calculateAmount(purchasePaymentApplyHead, purchasePaymentApplyItemList, purchasePaymentApplyOtherList);
        this.purchasePaymentApplyHeadMapper.updateById((Object)purchasePaymentApplyHead);
        List<PurchasePaymentApplyOther> purchasePaymentApplyOtherList1 = this.purchasePaymentApplyOtherMapper.selectByMainId(purchasePaymentApplyHead.getId());
        this.purchasePaymentApplyItemMapper.deleteByMainId(purchasePaymentApplyHead.getId());
        this.purchasePaymentApplyOtherMapper.deleteByMainId(purchasePaymentApplyHead.getId());
        for (PurchasePaymentApplyOther purchasePaymentApplyOther : purchasePaymentApplyOtherList1) {
            this.calculationDelCharge(purchasePaymentApplyOther);
        }
        this.insertData(purchasePaymentApplyHead, purchasePaymentApplyItemList, purchasePaymentApplyOtherList);
    }

    private void handleDocumentInfo(PurchasePaymentApplyHead purchasePaymentApplyHead, List<PurchasePaymentApplyItem> purchasePaymentApplyItemList, List<SalePaymentApplyItem> salePaymentApplyItemList) {
        List<String> strings;
        PurchaseInvoice purchaseInvoice;
        PurchaseOrderItemDTO dto;
        Iterator<BaseEntity> purchaseOrderItemDTOList;
        HashSet<String> reconciliationNumberSet = new HashSet<String>();
        HashSet<String> orderNumberSet = new HashSet<String>();
        HashSet<String> invoiceNumberSet = new HashSet<String>();
        HashSet parentIdSet = new HashSet();
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItemList) {
            if (PaymentApplySourceTypeEnum.ORDER.getValue().equals(purchasePaymentApplyItem.getSourceType())) {
                if (StringUtils.isEmpty((CharSequence)purchasePaymentApplyItem.getSourceNumber())) continue;
                orderNumberSet.add(purchasePaymentApplyItem.getSourceNumber());
                continue;
            }
            if (!PaymentApplySourceTypeEnum.INVOICE.getValue().equals(purchasePaymentApplyItem.getSourceType())) continue;
            if (!StringUtils.isEmpty((CharSequence)purchasePaymentApplyItem.getInvoiceNumber())) {
                invoiceNumberSet.add(purchasePaymentApplyItem.getInvoiceNumber());
            }
            if (StringUtils.isEmpty((CharSequence)purchasePaymentApplyItem.getSourceNumber())) continue;
            reconciliationNumberSet.add(purchasePaymentApplyItem.getSourceNumber());
        }
        List purchaseInvoiceList = new ArrayList();
        HashMap<String, Object> purchaseInvoiceMap = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty(invoiceNumberSet)) {
            LambdaQueryWrapper purchaseInvoiceLambdaQueryWrapper = new LambdaQueryWrapper();
            purchaseInvoiceLambdaQueryWrapper.in(PurchaseInvoice::getInvoiceNumber, invoiceNumberSet);
            purchaseInvoiceList = this.purchaseInvoiceService.list((Wrapper)purchaseInvoiceLambdaQueryWrapper);
            if (!CollectionUtils.isEmpty(purchaseInvoiceList)) {
                for (Object purchaseInvoice2 : purchaseInvoiceList) {
                    purchaseInvoiceMap.put(((PurchaseInvoice)((Object)purchaseInvoice2)).getInvoiceNumber(), purchaseInvoice2);
                }
            }
        }
        HashMap<String, PurchaseOrderItemDTO> purchaseOrderHeadMap = new HashMap<String, PurchaseOrderItemDTO>();
        if (!CollectionUtils.isEmpty(orderNumberSet) && !CollectionUtils.isEmpty(purchaseOrderItemDTOList = this.financeInvokeOrderRpcService.listPurchaseOrderItemByOrderNumber(new ArrayList<String>(orderNumberSet)))) {
            Object purchaseInvoice2;
            purchaseInvoice2 = purchaseOrderItemDTOList.iterator();
            while (purchaseInvoice2.hasNext()) {
                dto = (PurchaseOrderItemDTO)purchaseInvoice2.next();
                purchaseOrderHeadMap.put(dto.getOrderNumber(), dto);
            }
        }
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItemList) {
            if (PaymentApplySourceTypeEnum.ORDER.getValue().equals(purchasePaymentApplyItem.getSourceType())) {
                if (StringUtils.isEmpty((CharSequence)purchasePaymentApplyItem.getSourceNumber()) || (dto = (PurchaseOrderItemDTO)purchaseOrderHeadMap.get(purchasePaymentApplyItem.getSourceNumber())) == null) continue;
                purchasePaymentApplyItem.setDocumentId(dto.getDocumentId());
                purchasePaymentApplyItem.setDocumentParentId(purchasePaymentApplyItem.getId());
                continue;
            }
            if (!PaymentApplySourceTypeEnum.INVOICE.getValue().equals(purchasePaymentApplyItem.getSourceType()) || StringUtils.isEmpty((CharSequence)purchasePaymentApplyItem.getInvoiceNumber()) || (purchaseInvoice = (PurchaseInvoice)((Object)purchaseInvoiceMap.get(purchasePaymentApplyItem.getInvoiceNumber()))) == null) continue;
            purchasePaymentApplyItem.setDocumentId(purchaseInvoice.getDocumentId());
            purchasePaymentApplyItem.setDocumentParentId(purchaseInvoice.getId());
        }
        for (SalePaymentApplyItem salePaymentApplyItem : salePaymentApplyItemList) {
            if (PaymentApplySourceTypeEnum.ORDER.getValue().equals(salePaymentApplyItem.getSourceType())) {
                if (StringUtils.isEmpty((CharSequence)salePaymentApplyItem.getSourceNumber()) || (dto = (PurchaseOrderItemDTO)purchaseOrderHeadMap.get(salePaymentApplyItem.getSourceNumber())) == null) continue;
                salePaymentApplyItem.setDocumentId(dto.getDocumentId());
                salePaymentApplyItem.setDocumentParentId(salePaymentApplyItem.getRelationId());
                continue;
            }
            if (!PaymentApplySourceTypeEnum.INVOICE.getValue().equals(salePaymentApplyItem.getSourceType()) || StringUtils.isEmpty((CharSequence)salePaymentApplyItem.getInvoiceNumber()) || (purchaseInvoice = (PurchaseInvoice)((Object)purchaseInvoiceMap.get(salePaymentApplyItem.getInvoiceNumber()))) == null) continue;
            salePaymentApplyItem.setDocumentId(purchaseInvoice.getDocumentId());
            salePaymentApplyItem.setDocumentParentId(purchaseInvoice.getId());
        }
        if (!CollectionUtils.isEmpty(purchasePaymentApplyItemList)) {
            for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItemList) {
                this.purchasePaymentApplyItemMapper.updateById((Object)purchasePaymentApplyItem);
            }
        }
        HashSet<String> headDocumentIds = new HashSet<String>();
        List<PurchaseOrderHeadDTO> purchaseOrderHeadDTOList = this.financeInvokeOrderRpcService.listPurchaseOrderHeadByOrderNumber(new ArrayList<String>(orderNumberSet));
        if (!CollectionUtils.isEmpty(purchaseOrderHeadDTOList)) {
            List purchaseOrderHeadDocumentIds = purchaseOrderHeadDTOList.stream().map(PurchaseOrderHeadDTO::getDocumentId).collect(Collectors.toList());
            parentIdSet.addAll(purchaseOrderHeadDTOList.stream().map(BaseDTO::getId).collect(Collectors.toSet()));
            for (String purchaseOrderHeadDocumentId : purchaseOrderHeadDocumentIds) {
                if (StringUtils.isEmpty((CharSequence)purchaseOrderHeadDocumentId)) continue;
                if (purchaseOrderHeadDocumentId.contains(",")) {
                    strings = Arrays.asList(purchaseOrderHeadDocumentId.split(","));
                    headDocumentIds.addAll(strings);
                    continue;
                }
                headDocumentIds.add(purchaseOrderHeadDocumentId);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseInvoiceList)) {
            List purchaseInvoiceDocumentIds = purchaseInvoiceList.stream().map(PurchaseInvoice::getDocumentId).collect(Collectors.toList());
            parentIdSet.addAll(purchaseInvoiceList.stream().map(BaseEntity::getId).collect(Collectors.toSet()));
            for (String purchaseInvoiceDocumentId : purchaseInvoiceDocumentIds) {
                if (StringUtils.isEmpty((CharSequence)purchaseInvoiceDocumentId)) continue;
                if (purchaseInvoiceDocumentId.contains(",")) {
                    strings = Arrays.asList(purchaseInvoiceDocumentId.split(","));
                    headDocumentIds.addAll(strings);
                    continue;
                }
                headDocumentIds.add(purchaseInvoiceDocumentId);
            }
        }
        String headDocumentId = StringUtils.join(headDocumentIds, (String)",");
        String parentId = StringUtils.join(parentIdSet, (String)",");
        purchasePaymentApplyHead.setDocumentId(headDocumentId);
        purchasePaymentApplyHead.setDocumentParentId(parentId);
        this.purchasePaymentApplyHeadMapper.updateById((Object)purchasePaymentApplyHead);
        for (String documentId : headDocumentIds) {
            this.invokeBaseRpcService.updateIntegratedDocumentMain("paymentApplyHeadId", documentId, parentId, purchasePaymentApplyHead.getId());
        }
    }

    private void calculateAmount(PurchasePaymentApplyHead purchasePaymentApplyHead, List<PurchasePaymentApplyItem> purchasePaymentApplyItemList, List<PurchasePaymentApplyOther> purchasePaymentApplyOtherList) {
        BigDecimal shouldTaxAmount = BigDecimal.ZERO;
        BigDecimal shouldNoTaxAmount = BigDecimal.ZERO;
        BigDecimal applyAmount = BigDecimal.ZERO;
        BigDecimal applyNoAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(purchasePaymentApplyItemList)) {
            shouldTaxAmount = purchasePaymentApplyItemList.parallelStream().map(PurchasePaymentApplyItem::getShouldTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            shouldNoTaxAmount = purchasePaymentApplyItemList.parallelStream().map(PurchasePaymentApplyItem::getShouldNoTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            applyAmount = purchasePaymentApplyItemList.parallelStream().map(PurchasePaymentApplyItem::getApplyAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            applyNoAmount = purchasePaymentApplyItemList.parallelStream().map(PurchasePaymentApplyItem::getApplyNoTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (!CollectionUtils.isEmpty(purchasePaymentApplyOtherList)) {
            BigDecimal bigDecimalCharge = purchasePaymentApplyOtherList.parallelStream().filter(item -> PaymentApplyOtherEnum.CHARGE.getValue().equals(item.getSourceType())).map(PurchasePaymentApplyOther::getShouldTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal reduceCharge = purchasePaymentApplyItemList.parallelStream().filter(item -> PaymentApplyOtherEnum.CHARGE.getValue().equals(item.getSourceType())).map(PurchasePaymentApplyItem::getApplyAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            shouldTaxAmount = shouldTaxAmount.subtract(bigDecimalCharge);
            shouldNoTaxAmount = shouldNoTaxAmount.subtract(bigDecimalCharge);
            applyAmount = applyAmount.subtract(reduceCharge);
            applyNoAmount = applyNoAmount.subtract(reduceCharge);
        }
        purchasePaymentApplyHead.setTaxTotalAmount(shouldTaxAmount);
        purchasePaymentApplyHead.setNoTaxtPaymentAmount(shouldNoTaxAmount);
        purchasePaymentApplyHead.setPaymentAmount(applyAmount);
        purchasePaymentApplyHead.setNoTaxtPaymentAmount(applyNoAmount);
    }

    private void insertData(PurchasePaymentApplyHead purchasePaymentApplyHead, List<PurchasePaymentApplyItem> purchasePaymentApplyItemList, List<PurchasePaymentApplyOther> purchasePaymentApplyOtherList) {
        int index;
        if (purchasePaymentApplyItemList != null) {
            index = 1;
            for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItemList) {
                purchasePaymentApplyItem.setHeadId(purchasePaymentApplyHead.getId());
                SysUtil.setSysParam((BaseEntity)purchasePaymentApplyItem, (BaseEntity)purchasePaymentApplyHead);
                purchasePaymentApplyItem.setItemNumber(index + "");
                ++index;
            }
            if (!purchasePaymentApplyItemList.isEmpty()) {
                this.purchasePaymentApplyItemMapper.insertBatchSomeColumn(purchasePaymentApplyItemList);
            }
        }
        if (purchasePaymentApplyOtherList != null) {
            index = 1;
            for (PurchasePaymentApplyOther purchasePaymentApplyOther : purchasePaymentApplyOtherList) {
                purchasePaymentApplyOther.setHeadId(purchasePaymentApplyHead.getId());
                SysUtil.setSysParam((BaseEntity)purchasePaymentApplyOther, (BaseEntity)purchasePaymentApplyHead);
                if (PaymentApplyOtherEnum.CHARGE.getValue().equals(purchasePaymentApplyOther.getSourceType())) {
                    this.calculationCharge(purchasePaymentApplyOther);
                }
                purchasePaymentApplyOther.setItemNumber(index + "");
                ++index;
            }
            if (!purchasePaymentApplyOtherList.isEmpty()) {
                this.purchasePaymentApplyOtherMapper.insertBatchSomeColumn(purchasePaymentApplyOtherList);
            }
        }
    }

    private void calculationCharge(PurchasePaymentApplyOther purchasePaymentApplyOther) {
        PurchaseReconciliationService bean = (PurchaseReconciliationService)SpringContextUtils.getBean(PurchaseReconciliationService.class);
        PurchaseReconciliation byId = (PurchaseReconciliation)((Object)bean.getById((Serializable)((Object)purchasePaymentApplyOther.getSourceId())));
        if (byId != null) {
            PurchasePaymentApplyOtherService bean1 = (PurchasePaymentApplyOtherService)SpringContextUtils.getBean(PurchasePaymentApplyOtherService.class);
            if (bean1 != null) {
                List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)bean1.lambdaQuery().eq(PurchasePaymentApplyOther::getSourceId, (Object)purchasePaymentApplyOther.getSourceId())).eq(BaseEntity::getDeleted, (Object)"0")).list();
                BigDecimal reduce = list.parallelStream().map(PurchasePaymentApplyOther::getApplyAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (reduce.add(purchasePaymentApplyOther.getApplyAmount()).compareTo(byId.getChargeAmount()) > 0) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IeteVHfBBWIetyLWWWWWWVXVSVVsM_2a9b43c", (String)("\u5bf9\u8d26\u5355\u8d26\u6263\u91d1\u989d\u8d85\u6807,\u5bf9\u8d26\u5355\u53f7\u4e3a:" + purchasePaymentApplyOther.getSourceNumber() + ",\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u4fdd\u5b58"), (String[])new String[]{purchasePaymentApplyOther.getSourceNumber()}));
                }
                byId.setAlreadyChargeAmount(reduce.add(purchasePaymentApplyOther.getApplyAmount()));
                bean.updateById((Object)byId);
            }
        } else {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_YxuIetWIetyLWWWWWW_8c15af30", (String)("\u627e\u4e0d\u5230\u5bf9\u8d26\u5355,\u5bf9\u8d26\u5355\u53f7\u4e3a:" + purchasePaymentApplyOther.getSourceNumber()), (String[])new String[]{purchasePaymentApplyOther.getSourceNumber()}));
        }
    }

    private void calculationDelCharge(PurchasePaymentApplyOther purchasePaymentApplyOther) {
        PurchaseReconciliationService bean = (PurchaseReconciliationService)SpringContextUtils.getBean(PurchaseReconciliationService.class);
        PurchaseReconciliation byId = (PurchaseReconciliation)((Object)bean.getById((Serializable)((Object)purchasePaymentApplyOther.getSourceId())));
        if (byId != null) {
            PurchasePaymentApplyOtherService bean1 = (PurchasePaymentApplyOtherService)SpringContextUtils.getBean(PurchasePaymentApplyOtherService.class);
            if (bean1 != null) {
                List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)bean1.lambdaQuery().eq(PurchasePaymentApplyOther::getSourceId, (Object)purchasePaymentApplyOther.getSourceId())).eq(BaseEntity::getDeleted, (Object)"0")).list();
                BigDecimal reduce = list.parallelStream().map(PurchasePaymentApplyOther::getApplyAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (reduce.add(purchasePaymentApplyOther.getApplyAmount()).compareTo(byId.getChargeAmount()) > 0) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IeteVHfBBWIetyLWWWWWWVXVSVVsM_2a9b43c", (String)("\u5bf9\u8d26\u5355\u8d26\u6263\u91d1\u989d\u8d85\u6807,\u5bf9\u8d26\u5355\u53f7\u4e3a:" + purchasePaymentApplyOther.getSourceNumber() + ",\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u4fdd\u5b58"), (String[])new String[]{purchasePaymentApplyOther.getSourceNumber()}));
                }
                byId.setAlreadyChargeAmount(reduce);
                bean.updateById((Object)byId);
            }
        } else {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)("\u627e\u4e0d\u5230\u5bf9\u8d26\u5355,\u5bf9\u8d26\u5355\u53f7\u4e3a:" + purchasePaymentApplyOther.getSourceNumber())));
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.purchasePaymentApplyOtherMapper.deleteByMainId(id);
        this.purchasePaymentApplyItemMapper.deleteByMainId(id);
        this.purchasePaymentApplyHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    public void synchr(PurchasePaymentApplyHeadVO id) {
        List list;
        PurchasePaymentApplyHead byId = (PurchasePaymentApplyHead)((Object)this.getById((Serializable)((Object)id.getId())));
        if (!byId.getPaymentApplyStatus().equals(id.getPaymentApplyStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtFzEhbHrWVXVSsK_2a0afd21", (String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u53d1\u751f\u66f4\u6539,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5"));
        }
        List<PurchasePaymentApplyItem> purchasePaymentApplyItems = this.purchasePaymentApplyItemMapper.selectByMainId(id.getId());
        List<PurchasePaymentApplyOther> purchasePaymentApplyOtherList = this.purchasePaymentApplyOtherMapper.selectByMainId(id.getId());
        if ("1".equals(byId.getSendStatus())) {
            this.salePaymentApplyHeadService.delMain(byId.getRelationId());
            this.salePaymentApplyItemService.removeByIds(purchasePaymentApplyItems.parallelStream().map(item -> item.getRelationId()).collect(Collectors.toList()));
            this.salePaymentApplyOtherService.removeByIds(purchasePaymentApplyOtherList.parallelStream().map(item -> item.getRelationId()).collect(Collectors.toList()));
        }
        byId.setSendStatus("1");
        SalePaymentApplyHead saleHead = new SalePaymentApplyHead();
        BeanUtils.copyProperties((Object)((Object)byId), (Object)((Object)saleHead));
        saleHead.setId(IdWorker.getIdStr());
        byId.setRelationId(saleHead.getId());
        saleHead.setRelationId(byId.getId());
        saleHead.setElsAccount(byId.getToElsAccount());
        saleHead.setToElsAccount(byId.getElsAccount());
        saleHead.setBusAccount(byId.getElsAccount());
        this.salePaymentApplyHeadService.save((Object)saleHead);
        ArrayList<SalePaymentApplyItem> saleItemList = new ArrayList<SalePaymentApplyItem>();
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItems) {
            SalePaymentApplyItem saleItem = new SalePaymentApplyItem();
            BeanUtils.copyProperties((Object)((Object)purchasePaymentApplyItem), (Object)((Object)saleItem));
            saleItem.setId(IdWorker.getIdStr());
            purchasePaymentApplyItem.setRelationId(saleItem.getId());
            saleItem.setHeadId(saleHead.getId());
            saleItem.setRelationId(purchasePaymentApplyItem.getId());
            saleItem.setElsAccount(byId.getToElsAccount());
            saleItem.setBusAccount(byId.getElsAccount());
            SysUtil.setSysParam((BaseEntity)saleItem, (BaseEntity)saleHead);
            saleItemList.add(saleItem);
        }
        if (CollectionUtil.isNotEmpty(saleItemList)) {
            saleItemList.forEach(item -> this.salePaymentApplyItemMapper.insert(item));
        }
        ArrayList<SalePaymentApplyOther> salePaymentApplyOthers = new ArrayList<SalePaymentApplyOther>();
        for (PurchasePaymentApplyOther purchasePaymentApplyOther : purchasePaymentApplyOtherList) {
            SalePaymentApplyOther saleItem = new SalePaymentApplyOther();
            BeanUtils.copyProperties((Object)((Object)purchasePaymentApplyOther), (Object)((Object)saleItem));
            saleItem.setId(IdWorker.getIdStr());
            purchasePaymentApplyOther.setRelationId(saleItem.getId());
            saleItem.setHeadId(saleHead.getId());
            saleItem.setRelationId(purchasePaymentApplyOther.getId());
            saleItem.setElsAccount(byId.getToElsAccount());
            SysUtil.setSysParam((BaseEntity)saleItem, (BaseEntity)saleHead);
            salePaymentApplyOthers.add(saleItem);
        }
        if (CollectionUtil.isNotEmpty(salePaymentApplyOthers)) {
            salePaymentApplyOthers.forEach(item -> this.salePaymentApplyOtherMapper.insert(item));
        }
        if (CollectionUtil.isNotEmpty((Collection)(list = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id.getId())))) {
            AttachmentSendDTO sendVO = new AttachmentSendDTO();
            sendVO.setElsAccount(TenantContext.getTenant());
            sendVO.setHeadId(byId.getId());
            HashMap<String, String> toSend = new HashMap<String, String>();
            toSend.put(byId.getId(), byId.getElsAccount());
            sendVO.setToSend(toSend);
            this.invokeBaseRpcService.sendPurchaseFile(sendVO, false);
        }
        this.purchasePaymentApplyHeadMapper.alwaysUpdateSomeColumnById((Object)byId);
        purchasePaymentApplyItems.forEach(item -> this.purchasePaymentApplyItemMapper.alwaysUpdateSomeColumnById(item));
        String urlParam = "id=" + saleHead.getId();
        if (StringUtils.isNotBlank((CharSequence)byId.getSalePrincipal())) {
            super.sendMsg(byId.getElsAccount(), byId.getToElsAccount(), byId.getSalePrincipal(), (Object)byId, urlParam, "paymentApply", "publish");
        } else {
            super.sendMsg(byId.getElsAccount(), byId.getToElsAccount(), (Object)byId, urlParam, "paymentApply", "publish");
        }
        this.handleDocumentInfo(byId, purchasePaymentApplyItems, saleItemList);
        saleHead.setDocumentId(byId.getDocumentId());
        saleHead.setDocumentParentId(byId.getDocumentParentId());
        this.salePaymentApplyHeadService.updateById((Object)saleHead);
    }

    @Override
    public void cancel(PurchasePaymentApplyHeadVO id) {
        PurchasePaymentApplyHead byId = (PurchasePaymentApplyHead)((Object)this.getById((Serializable)((Object)id.getId())));
        if (byId == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_mxuAPtF_d6b9bdfb", (String)"\u67e5\u4e0d\u5230\u5f53\u524d\u5355\u636e"));
        }
        if (byId != null && !byId.getPaymentApplyStatus().equals(id.getPaymentApplyStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtFzEhbHrWVXVSsK_2a0afd21", (String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u53d1\u751f\u66f4\u6539,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5"));
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)id.getId())).set(PurchasePaymentApplyHead::getPaymentApplyStatus, (Object)PaymentApplyStatusEnum.CANCELLATION.getValue())).update((Object)new PurchasePaymentApplyHead());
        if ("1".equals(byId.getSendStatus())) {
            this.synchr(id);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchasePaymentApplyItemMapper.deleteByMainId(serializable.toString());
            this.purchasePaymentApplyOtherMapper.deleteByMainId(serializable.toString());
            this.purchasePaymentApplyHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public Result<?> getBusinessDocuments(Map<String, String[]> parameters, Integer pageNo, Integer pageSize) {
        Set<String> keys = parameters.keySet();
        String elsAccount = TenantContext.getTenant();
        String toElsAccount = null;
        String company = null;
        String purchaseOrg = null;
        String sourceType = null;
        String payWay = null;
        String paymentClause = null;
        String keyWord = null;
        for (String string : keys) {
            if ("toElsAccount".equals(string) && parameters.get(string) != null) {
                toElsAccount = parameters.get(string)[0];
            }
            if ("company".equals(string) && parameters.get(string) != null) {
                company = parameters.get(string)[0];
            }
            if ("purchaseOrg".equals(string) && parameters.get(string) != null) {
                purchaseOrg = parameters.get(string)[0];
            }
            if ("sourceType".equals(string) && parameters.get(string) != null) {
                sourceType = parameters.get(string)[0];
            }
            if ("payWay".equals(string) && parameters.get(string) != null) {
                payWay = parameters.get(string)[0];
            }
            if ("paymentClause".equals(string) && parameters.get(string) != null) {
                paymentClause = parameters.get(string)[0];
            }
            if (!"keyWord".equals(string) || parameters.get(string) == null) continue;
            keyWord = parameters.get(string)[0];
        }
        if (PaymentApplySourceTypeEnum.CONTACT.getValue().equals(sourceType)) {
            return this.getContact(pageNo, pageSize, elsAccount, toElsAccount, company, purchaseOrg);
        }
        if (PaymentApplySourceTypeEnum.ORDER.getValue().equals(sourceType)) {
            return this.getOrder(pageNo, pageSize, elsAccount, toElsAccount, company, purchaseOrg, payWay, paymentClause, keyWord);
        }
        if (PaymentApplySourceTypeEnum.RECONCILIATION.getValue().equals(sourceType)) {
            // empty if block
        }
        if (PaymentApplySourceTypeEnum.INVOICE.getValue().equals(sourceType)) {
            return this.getInvoice(pageNo, pageSize, elsAccount, toElsAccount, company, purchaseOrg, payWay, paymentClause, keyWord);
        }
        return null;
    }

    public Result<?> getContact(Integer pageNo, Integer pageSize, String elsAccount, String toElsAccount, String company, String purchaseOrg) {
        return Result.ok();
    }

    public Result<?> getOrder(Integer pageNo, Integer pageSize, String elsAccount, String toElsAccount, String company, String purchaseOrg, String payWay, String paymentClause, String keyword) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.inSql((Object)"order_number", "SELECT order_number FROM purchase_order_head WHERE els_account = '" + TenantContext.getTenant() + "' AND payment_way = '" + payWay + "' AND payment_clause = '" + paymentClause + "' AND to_els_account = '" + toElsAccount + "' AND company = '" + company + "' AND purchase_org = '" + purchaseOrg + " AND send_status = 0 AND order_status != 5 ' AND (is_deleted IS NULL OR is_deleted = '0')");
        wrapper.and(q -> ((QueryWrapper)((QueryWrapper)q.isNull((Object)"is_freeze")).or()).eq((Object)"is_freeze", (Object)"0"));
        IPage<PurchaseOrderItemDTO> pageList = this.financeInvokeOrderRpcService.listOrderItem(pageNo, pageSize, elsAccount, toElsAccount, company, purchaseOrg, payWay, paymentClause, keyword);
        return Result.ok(pageList);
    }

    public Result<?> getReconciliation(Integer pageNo, Integer pageSize, String elsAccount, String toElsAccount, String company, String purchaseOrg) {
        return null;
    }

    public Result<?> getInvoice(Integer pageNo, Integer pageSize, String elsAccount, String toElsAccount, String company, String purchaseOrg, String payWay, String paymentClause, String keyword) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.inSql((Object)"reconciliation_number", "SELECT reconciliation_number FROM purchase_reconciliation WHERE els_account = '" + TenantContext.getTenant() + "' AND pay_way = '" + payWay + "' AND payment_clause = '" + paymentClause + "' AND to_els_account = '" + toElsAccount + "' AND company = '" + company + "' AND purchase_org = '" + purchaseOrg + "' AND is_cancellation != '1'  AND (is_deleted IS NULL OR is_deleted = '0')");
        if (!StringUtils.isEmpty((CharSequence)keyword)) {
            wrapper.eq((Object)"invoice_number", (Object)keyword);
        }
        IPage pageList = this.purchaseInvoiceService.page((IPage)page, (Wrapper)wrapper);
        return Result.ok((Object)pageList);
    }
}

