/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.ElsStatusLog;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.ElsStatusLogDTO;
import com.els.modules.delivery.api.dto.PurchaseVoucherItemDTO;
import com.els.modules.finance.excel.PurchaseRecAcceptReturnExportServiceImpl;
import com.els.modules.finance.service.PurchasePaymentApplyItemService;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.PurchaseRecAcceptReturn;
import com.els.modules.reconciliation.entity.PurchaseRecAdditionalCharges;
import com.els.modules.reconciliation.entity.PurchaseRecCharge;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.enumerate.OperationEnum;
import com.els.modules.reconciliation.excel.PurchaseReconciliationExportServiceImpl;
import com.els.modules.reconciliation.rpc.PurchaseVoucherItemLocalRpcService;
import com.els.modules.reconciliation.service.PurchaseInvoiceService;
import com.els.modules.reconciliation.service.PurchaseRecAcceptReturnService;
import com.els.modules.reconciliation.service.PurchaseRecAdditionalChargesService;
import com.els.modules.reconciliation.service.PurchaseRecChargeService;
import com.els.modules.reconciliation.service.PurchaseReconciliationService;
import com.els.modules.reconciliation.vo.PurchaseReconciliationVO;
import com.els.modules.supplier.api.enumerate.SupplierCoordinationWayEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/reconciliation/purchaseReconciliation"})
@Api(tags={"\u5bf9\u8d26\u5934"})
public class PurchaseReconciliationController
extends BaseController<PurchaseReconciliation, PurchaseReconciliationService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseReconciliationController.class);
    @Autowired
    private PurchaseReconciliationService purchaseReconciliationService;
    @Autowired
    private PurchaseRecAcceptReturnService purchaseRecAcceptReturnService;
    @Autowired
    private PurchaseRecAdditionalChargesService purchaseRecAdditionalChargesService;
    @Autowired
    private PurchaseRecChargeService purchaseRecChargeService;
    @Autowired
    private PurchaseInvoiceService purchaseInvoiceService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private PurchasePaymentApplyItemService purchasePaymentApplyItemService;
    @Autowired
    private PurchaseVoucherItemLocalRpcService purchaseVoucherItemLocalRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(PurchaseReconciliation purchaseReconciliation, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseReconciliation), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseReconciliationService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> counts(PurchaseReconciliation purchaseReconciliation, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseReconciliation), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"reconciliation_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"reconciliation_status");
        List list = ((PurchaseReconciliationService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseReconciliation::getReconciliationStatus, PurchaseReconciliation::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "reconciliationStatus", null, all));
        List srmReconciliationStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmReconciliationStatus", TenantContext.getTenant());
        for (DictDTO status : srmReconciliationStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "reconciliationStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryPageNoChargeList"})
    public Result<?> queryPageNoChargeList(PurchaseReconciliation purchaseReconciliation, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseReconciliation), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        ((LambdaQueryWrapper)queryWrapper.lambda().gt(PurchaseReconciliation::getChargeAmount, (Object)BigDecimal.ZERO)).nested(i -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.isNull(PurchaseReconciliation::getAlreadyChargeAmount)).or()).apply("already_charge_amount<charge_amount", new Object[0]);
        });
        IPage pageList = this.purchaseReconciliationService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryReconciliationItemList"})
    public Result<?> queryReconciliationItemList(PurchaseReconciliation purchaseReconciliation, HttpServletRequest req) {
        JSONObject jsonObject = JSONObject.parseObject((String)purchaseReconciliation.getId());
        String sourceType = jsonObject.getString("sourceType");
        String id = jsonObject.getString("id");
        PurchaseReconciliationVO purchaseReconciliationVO = new PurchaseReconciliationVO();
        if (sourceType.equals("invoice")) {
            PurchaseInvoice purchaseInvoice = (PurchaseInvoice)((Object)this.purchaseInvoiceService.getById((Serializable)((Object)id)));
            String reconciliationNumber = purchaseInvoice.getReconciliationNumber();
            List purchaseReconciliations = ((LambdaQueryChainWrapper)this.purchaseReconciliationService.lambdaQuery().eq(PurchaseReconciliation::getReconciliationNumber, (Object)reconciliationNumber)).list();
            List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList = this.purchaseRecAcceptReturnService.selectByMainId(((PurchaseReconciliation)((Object)purchaseReconciliations.get(0))).getId());
            List<PurchaseRecAdditionalCharges> purchaseRecAdditionalChargesList = this.purchaseRecAdditionalChargesService.selectByMainId(((PurchaseReconciliation)((Object)purchaseReconciliations.get(0))).getId());
            List<PurchaseRecCharge> purchaseRecChargeList = this.purchaseRecChargeService.selectByMainId(((PurchaseReconciliation)((Object)purchaseReconciliations.get(0))).getId());
            purchaseReconciliationVO.setPurchaseRecAdditionalChargesList(purchaseRecAdditionalChargesList);
            purchaseReconciliationVO.setPurchaseRecChargeList(purchaseRecChargeList);
            purchaseReconciliationVO.setPurchaseRecAcceptReturnList(purchaseRecAcceptReturnList);
        } else {
            List<PurchaseVoucherItemDTO> purchaseVoucherItem = this.purchaseVoucherItemLocalRpcService.selectPurchaseAttachmentByOrderId(id);
            ArrayList<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList = new ArrayList<PurchaseRecAcceptReturn>();
            BeanUtils.copyProperties(purchaseRecAcceptReturnList, purchaseVoucherItem);
            purchaseReconciliationVO.setPurchaseRecAcceptReturnList(purchaseRecAcceptReturnList);
        }
        return Result.ok((Object)((Object)purchaseReconciliationVO));
    }

    @AutoLog(value="\u5bf9\u8d26\u5934-\u6dfb\u52a0", logType=2)
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:add"})
    @PermissionDataOpt(businessType="reconciliation", beanClass=PurchaseReconciliationService.class)
    public Result<?> add(@RequestBody PurchaseReconciliationVO purchaseReconciliationPage) {
        PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
        BeanUtils.copyProperties((Object)((Object)purchaseReconciliationPage), (Object)((Object)purchaseReconciliation));
        this.purchaseReconciliationService.saveMain(purchaseReconciliation, purchaseReconciliationPage.getPurchaseRecAcceptReturnList(), purchaseReconciliationPage.getPurchaseRecAdditionalChargesList(), purchaseReconciliationPage.getPurchaseRecChargeList());
        return Result.ok((Object)((Object)purchaseReconciliation));
    }

    @AutoLog(value="\u5bf9\u8d26\u5934-\u7f16\u8f91", logType=2)
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:edit"})
    @PermissionDataOpt(businessType="reconciliation", beanClass=PurchaseReconciliationService.class)
    public Result<?> edit(@RequestBody PurchaseReconciliationVO purchaseReconciliationPage) {
        PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
        BeanUtils.copyProperties((Object)((Object)purchaseReconciliationPage), (Object)((Object)purchaseReconciliation));
        this.purchaseReconciliationService.updateMain(purchaseReconciliation, purchaseReconciliationPage.getPurchaseRecAcceptReturnList(), purchaseReconciliationPage.getPurchaseRecAdditionalChargesList(), purchaseReconciliationPage.getPurchaseRecChargeList());
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:delete"})
    @PermissionDataOpt(businessType="reconciliation", beanClass=PurchaseReconciliationService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchaseReconciliationService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u5bf9\u8d26\u5934-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.purchaseReconciliationService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseReconciliation purchaseReconciliation = (PurchaseReconciliation)((Object)this.purchaseReconciliationService.getById((Serializable)((Object)id)));
        PurchaseReconciliationVO purchaseReconciliationVO = new PurchaseReconciliationVO();
        BeanUtils.copyProperties((Object)((Object)purchaseReconciliation), (Object)((Object)purchaseReconciliationVO));
        if (!StringUtils.isEmpty((Object)purchaseReconciliation.getNeedCoordination()) && StringUtils.isEmpty((Object)purchaseReconciliation.getIsTeamwork())) {
            if ("1".equals(purchaseReconciliation.getNeedCoordination())) {
                purchaseReconciliationVO.setIsTeamwork(SupplierCoordinationWayEnum.SRM_COORDINATIONWAY.getValue());
            } else if ("0".equals(purchaseReconciliation.getNeedCoordination())) {
                purchaseReconciliationVO.setIsTeamwork(SupplierCoordinationWayEnum.NO_COORDINATIONWAY.getValue());
            }
        }
        List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList = this.purchaseRecAcceptReturnService.selectByMainId(id);
        purchaseReconciliationVO.setPurchaseRecAcceptReturnList(purchaseRecAcceptReturnList);
        List<PurchaseRecAdditionalCharges> purchaseRecAdditionalChargesList = this.purchaseRecAdditionalChargesService.selectByMainId(id);
        purchaseReconciliationVO.setPurchaseRecAdditionalChargesList(purchaseRecAdditionalChargesList);
        List<PurchaseRecCharge> purchaseRecChargeList = this.purchaseRecChargeService.selectByMainId(id);
        purchaseReconciliationVO.setPurchaseRecChargeList(purchaseRecChargeList);
        List<PurchaseInvoice> invoices = this.purchaseInvoiceService.selectByMainId(id);
        purchaseReconciliationVO.setPurchaseInvoices(invoices);
        List attachments = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseReconciliationVO.setAttachments(attachments);
        purchaseReconciliationVO.setElsStatusLogList(this.listStatusLog(id, "srmReconciliationStatus"));
        return Result.ok((Object)((Object)purchaseReconciliationVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u5bf9\u8d26\u5934id\u67e5\u8be2\u6536\u9000\u8d27\u660e\u7ec6", notes="\u901a\u8fc7\u5bf9\u8d26\u5934id\u67e5\u8be2\u6536\u9000\u8d27\u660e\u7ec6")
    @GetMapping(value={"/queryPurchaseRecAcceptReturnByMainId"})
    public Result<?> queryPurchaseRecAcceptReturnListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList = this.purchaseRecAcceptReturnService.selectByMainId(id);
        return Result.ok(purchaseRecAcceptReturnList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5bf9\u8d26\u5934id\u67e5\u8be2\u9644\u52a0\u8d39\u7528\u660e\u7ec6", notes="\u901a\u8fc7\u5bf9\u8d26\u5934id\u67e5\u8be2\u9644\u52a0\u8d39\u7528\u660e\u7ec6")
    @GetMapping(value={"/queryPurchaseRecAdditionalChargesByMainId"})
    public Result<?> queryPurchaseRecAdditionalChargesListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseRecAdditionalCharges> purchaseRecAdditionalChargesList = this.purchaseRecAdditionalChargesService.selectByMainId(id);
        return Result.ok(purchaseRecAdditionalChargesList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5bf9\u8d26\u5934id\u67e5\u8be2\u6263\u6b3e\u660e\u7ec6", notes="\u901a\u8fc7\u5bf9\u8d26\u5934id\u67e5\u8be2\u6263\u6b3e\u660e\u7ec6")
    @GetMapping(value={"/queryPurchaseRecChargeByMainId"})
    public Result<?> queryPurchaseRecChargeListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseRecCharge> purchaseRecChargeList = this.purchaseRecChargeService.selectByMainId(id);
        return Result.ok(purchaseRecChargeList);
    }

    @AutoLog(value="\u5bf9\u8d26-\u63d0\u53d6\u5bf9\u8d26\u5355", logType=2)
    @ApiOperation(value="\u63d0\u53d6\u5bf9\u8d26\u5355", notes="\u63d0\u53d6\u5bf9\u8d26\u5355")
    @PostMapping(value={"/extractReconciliation"})
    @PermissionDataOpt(businessType="reconciliation", beanClass=PurchaseReconciliationService.class)
    public Result<?> extractReconciliation(@RequestBody PurchaseReconciliationVO purchaseReconciliationPage) {
        return Result.ok((Object)((Object)this.purchaseReconciliationService.extractReconciliation(purchaseReconciliationPage)));
    }

    @AutoLog(value="\u5bf9\u8d26\u5934-\u53d1\u5e03", logType=2)
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    public Result<?> publish(@RequestBody PurchaseReconciliationVO purchaseReconciliationPage) {
        PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
        BeanUtils.copyProperties((Object)((Object)purchaseReconciliationPage), (Object)((Object)purchaseReconciliation));
        return this.purchaseReconciliationService.publish(purchaseReconciliation, purchaseReconciliationPage.getPurchaseRecAcceptReturnList(), purchaseReconciliationPage.getPurchaseRecAdditionalChargesList(), purchaseReconciliationPage.getPurchaseRecChargeList(), purchaseReconciliationPage.getAttachments());
    }

    @AutoLog(value="\u5bf9\u8d26\u5934-\u53d1\u7968\u62d2\u7edd", logType=2)
    @ApiOperation(value="\u53d1\u7968\u62d2\u7edd", notes="\u53d1\u7968\u62d2\u7edd")
    @PostMapping(value={"/invoiceRefused"})
    public Result<?> invoicerefused(@RequestBody PurchaseReconciliationVO purchaseReconciliationPage) {
        PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
        BeanUtils.copyProperties((Object)((Object)purchaseReconciliationPage), (Object)((Object)purchaseReconciliation));
        return this.purchaseReconciliationService.invoiceRefusedOrConfirm(purchaseReconciliation, purchaseReconciliationPage.getPurchaseInvoices(), OperationEnum.REFUSED.getValue());
    }

    @AutoLog(value="\u5bf9\u8d26\u5934-\u53d1\u7968\u786e\u8ba4", logType=2)
    @ApiOperation(value="\u53d1\u7968\u786e\u8ba4", notes="\u53d1\u7968\u786e\u8ba4")
    @PostMapping(value={"/invoiceConfirmed"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:invoiceConfirmed"})
    @PermissionDataOpt(businessType="reconciliation", beanClass=PurchaseReconciliationService.class)
    public Result<?> invoiceConfirmed(@RequestBody PurchaseReconciliationVO purchaseReconciliationPage) {
        PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
        BeanUtils.copyProperties((Object)((Object)purchaseReconciliationPage), (Object)((Object)purchaseReconciliation));
        return this.purchaseReconciliationService.invoiceRefusedOrConfirm(purchaseReconciliation, purchaseReconciliationPage.getPurchaseInvoices(), OperationEnum.CONFIRM.getValue());
    }

    @AutoLog(value="\u5bf9\u8d26\u5934-\u5bf9\u8d26\u5355\u786e\u8ba4", logType=2)
    @ApiOperation(value="\u5bf9\u8d26\u5355\u786e\u8ba4", notes="\u5bf9\u8d26\u5355\u786e\u8ba4")
    @PostMapping(value={"/confirmed"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:confirmed"})
    @PermissionDataOpt(businessType="reconciliation", beanClass=PurchaseReconciliationService.class)
    public Result<?> confirmed(@RequestBody PurchaseReconciliationVO purchaseReconciliationPage) {
        PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
        BeanUtils.copyProperties((Object)((Object)purchaseReconciliationPage), (Object)((Object)purchaseReconciliation));
        return this.purchaseReconciliationService.refusedOrConfirm(purchaseReconciliation, OperationEnum.CONFIRM.getValue());
    }

    @AutoLog(value="\u5bf9\u8d26\u5934-\u5bf9\u8d26\u5355\u62d2\u7edd", logType=2)
    @ApiOperation(value="\u5bf9\u8d26\u5355\u62d2\u7edd", notes="\u5bf9\u8d26\u5355\u62d2\u7edd")
    @PostMapping(value={"/refused"})
    public Result<?> refused(@RequestBody PurchaseReconciliationVO purchaseReconciliationPage) {
        PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
        BeanUtils.copyProperties((Object)((Object)purchaseReconciliationPage), (Object)((Object)purchaseReconciliation));
        return this.purchaseReconciliationService.refusedOrConfirm(purchaseReconciliation, OperationEnum.REFUSED.getValue());
    }

    @AutoLog(value="\u5bf9\u8d26\u5934-\u901a\u8fc7id\u4f5c\u5e9f")
    @ApiOperation(value="\u901a\u8fc7id\u4f5c\u5e9f", notes="\u901a\u8fc7id\u4f5c\u5e9f")
    @GetMapping(value={"/cancellation"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:cancellation"})
    @PermissionDataOpt(businessType="reconciliation", beanClass=PurchaseReconciliationService.class)
    public Result<?> cancellation(@RequestParam(name="id", required=true) String id) {
        this.purchaseReconciliationService.cancellation(id);
        return this.commonSuccessResult(4);
    }

    @GetMapping(value={"/exportXls"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:export"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseReconciliationExportServiceImpl.class);
    }

    @GetMapping(value={"/exportPurchaseRecAcceptReturnExportXls"})
    public ModelAndView exportPurchaseRecAcceptReturnXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseRecAcceptReturnExportServiceImpl.class);
    }

    private List<ElsStatusLog> listStatusLog(String id, String dictCode) {
        List list = this.invokeBaseRpcService.listStatusLog(id);
        ArrayList<ElsStatusLog> objects = new ArrayList<ElsStatusLog>();
        List srmReconciliationStatus = this.invokeBaseRpcService.queryDictItemsByCode(dictCode, TenantContext.getTenant());
        if (!CollectionUtils.isEmpty((Collection)srmReconciliationStatus)) {
            Map collect = srmReconciliationStatus.parallelStream().collect(Collectors.toMap(DictDTO::getValue, Function.identity()));
            if (!CollectionUtils.isEmpty((Collection)list)) {
                for (ElsStatusLogDTO elsStatusLog : list) {
                    if (!collect.containsKey(elsStatusLog.getBusinessStatus())) continue;
                    DictDTO dictDTO = (DictDTO)collect.get(elsStatusLog.getBusinessStatus());
                    elsStatusLog.setBusinessStatus_dictText(I18nUtil.translate((String)dictDTO.getTextI18nKey(), (String)dictDTO.getText()));
                }
            }
            HashMap collect1 = CollectionUtils.isEmpty((Collection)list) ? new HashMap() : list.parallelStream().collect(Collectors.toMap(ElsStatusLogDTO::getBusinessStatus, Function.identity(), (Key1, key2) -> key2));
            for (DictDTO dict : srmReconciliationStatus) {
                if (collect1.containsKey(dict.getValue())) {
                    objects.add((ElsStatusLog)SysUtil.copyProperties(collect1.get(dict.getValue()), ElsStatusLog.class));
                    continue;
                }
                objects.add(new ElsStatusLog().setBusinessType("reconciliation").setBusinessId(id).setBusinessStatus(dict.getValue()).setBusinessStatus_dictText(I18nUtil.translate((String)dict.getTextI18nKey(), (String)dict.getText())));
            }
        }
        return objects;
    }

    @ApiOperation(value="\u83b7\u53d6ERP\u6570\u636e", notes="\u83b7\u53d6ERP\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"reconciliation#purchaseReconciliation:getDataByErp"})
    public Result<?> getDataByErp() {
        this.purchaseReconciliationService.getDataByErp();
        return Result.ok();
    }

    @ApiOperation(value="SRM\u63a8\u9001\u5230ERP", notes="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"purchaseReconciliation:pushDataToErp"})
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        this.purchaseReconciliationService.pushDataToErp(ids);
        return Result.ok();
    }

    @AutoLog(value="\u91c7\u8d2d\u5bf9\u8d26\u5934-\u53d1\u7968\u4fdd\u5b58", logType=2)
    @ApiOperation(value="\u53d1\u7968\u4fdd\u5b58", notes="\u53d1\u7968\u4fdd\u5b58")
    @PostMapping(value={"/saveInvoice"})
    public Result<?> saveInvoice(@RequestBody PurchaseReconciliationVO purchaseReconciliationVO) {
        PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
        BeanUtils.copyProperties((Object)((Object)purchaseReconciliationVO), (Object)((Object)purchaseReconciliation));
        this.purchaseReconciliationService.saveInvoice(purchaseReconciliation, purchaseReconciliationVO.getPurchaseInvoices(), "save");
        return Result.ok((Object)((Object)purchaseReconciliation));
    }
}

