/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.config.IpaasConfig;
import com.els.config.StaticConfig;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.reconciliation.entity.InvoiceOcrData;
import com.els.modules.reconciliation.entity.InvoiceOcrDataEight;
import com.els.modules.reconciliation.entity.InvoiceOcrDataEleven;
import com.els.modules.reconciliation.entity.InvoiceOcrDataFive;
import com.els.modules.reconciliation.entity.InvoiceOcrDataFour;
import com.els.modules.reconciliation.entity.InvoiceOcrDataFourteen;
import com.els.modules.reconciliation.entity.InvoiceOcrDataNine;
import com.els.modules.reconciliation.entity.InvoiceOcrDataOne;
import com.els.modules.reconciliation.entity.InvoiceOcrDataSeven;
import com.els.modules.reconciliation.entity.InvoiceOcrDataSix;
import com.els.modules.reconciliation.entity.InvoiceOcrDataTen;
import com.els.modules.reconciliation.entity.InvoiceOcrDataThirteen;
import com.els.modules.reconciliation.entity.InvoiceOcrDataThree;
import com.els.modules.reconciliation.entity.InvoiceOcrDataTwelve;
import com.els.modules.reconciliation.entity.InvoiceOcrDataTwo;
import com.els.modules.reconciliation.entity.InvoiceProductData;
import com.els.modules.reconciliation.entity.SaleInvoice;
import com.els.modules.reconciliation.enumerate.InvoiceTypeToClass;
import com.els.modules.reconciliation.mapper.SaleInvoiceMapper;
import com.els.modules.reconciliation.rpc.ReconciliationInvokeBaseService;
import com.els.modules.reconciliation.service.InvoiceOcrDataFourService;
import com.els.modules.reconciliation.service.InvoiceOcrDataOneService;
import com.els.modules.reconciliation.service.InvoiceOcrDataService;
import com.els.modules.reconciliation.service.InvoiceOcrDataThreeService;
import com.els.modules.reconciliation.service.InvoiceOcrDataTwoService;
import com.els.modules.reconciliation.service.SaleInvoiceService;
import com.els.modules.reconciliation.vo.InvoiceOcrDataVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SaleInvoiceServiceImpl
extends ServiceImpl<SaleInvoiceMapper, SaleInvoice>
implements SaleInvoiceService {
    private static final Logger log = LoggerFactory.getLogger(SaleInvoiceServiceImpl.class);
    @Resource
    private SaleInvoiceMapper saleInvoiceMapper;
    @Resource
    private ReconciliationInvokeBaseService reconciliationInvokeBaseService;
    @Autowired
    private InvoiceOcrDataService invoiceOcrDataService;
    @Autowired
    private InvoiceOcrDataOneService invoiceOcrDataOneService;
    @Autowired
    private InvoiceOcrDataTwoService invoiceOcrDataTwoService;
    @Autowired
    private InvoiceOcrDataThreeService invoiceOcrDataThreeService;
    @Autowired
    private InvoiceOcrDataFourService invoiceOcrDataFourService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    private String address = (String)((StaticConfig)SpringContextUtils.getBean(StaticConfig.class)).getConfig().get("service.address");
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();

    @Override
    public List<SaleInvoice> selectByMainId(String mainId) {
        return this.saleInvoiceMapper.selectByMainId(mainId);
    }

    @Override
    public void saveSaleInvoice(SaleInvoice saleInvoice) {
        ((SaleInvoiceMapper)this.baseMapper).insert((Object)saleInvoice);
    }

    @Override
    public void updateSaleInvoice(SaleInvoice saleInvoice) {
        ((SaleInvoiceMapper)this.baseMapper).updateById((Object)saleInvoice);
    }

    @Override
    public void delSaleInvoice(String id) {
        ((SaleInvoiceMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchSaleInvoice(List<String> idList) {
        ((SaleInvoiceMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void invoiceOCR(List<InvoiceOcrData> invoiceOcrDataList) {
        if (CollectionUtil.isEmpty(invoiceOcrDataList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VNhPQInRLV_3a9dfc1b", (String)"\u4f20\u5165\u53d1\u7968\u6587\u4ef6\u5730\u5740\u4e3a\u7a7a"));
        }
        List list = invoiceOcrDataList.parallelStream().map(BaseEntity::getId).collect(Collectors.toList());
        List attachmentDTOS = this.invokeBaseRpcService.listPurchaseFiles(list);
        log.info(this.invokeBaseRpcService + "\u5df2\u8fdb\u5165\u67e5\u8be2:" + attachmentDTOS);
        ArrayList strings = new ArrayList();
        try {
            if (!CollectionUtil.isEmpty((Collection)attachmentDTOS)) {
                attachmentDTOS.forEach(item -> strings.add(this.getSignature(item.getSaveType(), item.getFilePath())));
                for (PurchaseAttachmentDTO attachmentDTO : attachmentDTOS) {
                    String signature = this.getSignature(attachmentDTO.getSaveType(), attachmentDTO.getFilePath());
                    HashMap<String, String> interfaceMap = new HashMap<String, String>();
                    interfaceMap.put("filePath", signature);
                    interfaceMap.put("interfaceCode", this.invokeBaseRpcService.getIpaasInterfaceCode("invoice-ocr"));
                    String s = this.reconciliationInvokeBaseService.invoiceOCR(interfaceMap);
                    JSONObject jsonObject = JSONObject.parseObject((String)s);
                    if (jsonObject.getBoolean("success").booleanValue()) {
                        InvoiceOcrDataVO invoiceOcrDataVO = SaleInvoiceServiceImpl.resultToOCRData(new InvoiceOcrData(), jsonObject);
                        invoiceOcrDataVO.setUploadSubAccount(attachmentDTO.getUploadSubAccount());
                        invoiceOcrDataVO.setUploadElsAccount(attachmentDTO.getUploadElsAccount());
                        invoiceOcrDataVO.setFileName(attachmentDTO.getFileName());
                        invoiceOcrDataVO.setFileId(attachmentDTO.getId());
                        invoiceOcrDataVO.setFilePath(signature);
                        invoiceOcrDataVO.setFileSize(attachmentDTO.getFileSize());
                        invoiceOcrDataVO.setFileType(attachmentDTO.getFileType());
                        invoiceOcrDataVO.setData(jsonObject.toJSONString());
                        InvoiceOcrData ocrData = new InvoiceOcrData();
                        BeanUtils.copyProperties((Object)((Object)invoiceOcrDataVO), (Object)((Object)ocrData));
                        this.invoiceOcrDataService.saveMain(ocrData, invoiceOcrDataVO.getInvoiceOcrDataOneList(), invoiceOcrDataVO.getInvoiceOcrDataTwoList(), invoiceOcrDataVO.getInvoiceOcrDataThreeList(), invoiceOcrDataVO.getInvoiceOcrDataFourList(), invoiceOcrDataVO.getInvoiceOcrDataFiveList(), invoiceOcrDataVO.getInvoiceOcrDataSixList(), invoiceOcrDataVO.getInvoiceOcrDataEightList(), invoiceOcrDataVO.getInvoiceOcrDataNineList(), invoiceOcrDataVO.getInvoiceOcrDataTenList(), invoiceOcrDataVO.getInvoiceOcrDataElevenList(), invoiceOcrDataVO.getInvoiceOcrDataTwelveList(), invoiceOcrDataVO.getInvoiceOcrDataThirteenList(), invoiceOcrDataVO.getInvoiceOcrDataFourteenList(), invoiceOcrDataVO.getInvoiceProductDataList(), invoiceOcrDataVO.getInvoiceOcrDataSevenList());
                        continue;
                    }
                    throw new ELSBootException("\u63a5\u53e3\u8c03\u7528\u5931\u8d25:" + jsonObject.getString("message"));
                }
            } else {
                List saleAttachmentDTOS = this.invokeBaseRpcService.listSaleFiles(list);
                log.info(this.invokeBaseRpcService + "\u5df2\u8fdb\u51652\u67e5\u8be2:" + saleAttachmentDTOS);
                for (SaleAttachmentDTO attachmentDTO : saleAttachmentDTOS) {
                    String signature = this.getSignature(attachmentDTO.getSaveType(), attachmentDTO.getFilePath());
                    HashMap<String, String> interfaceMap = new HashMap<String, String>();
                    interfaceMap.put("filePath", signature);
                    interfaceMap.put("interfaceCode", this.invokeBaseRpcService.getIpaasInterfaceCode("invoice-ocr"));
                    log.info("\u5916\u90e8\u94fe\u63a5" + signature);
                    String s = this.reconciliationInvokeBaseService.invoiceOCR(interfaceMap);
                    log.info("\u8fd4\u56de\u7ed3\u679c" + s);
                    JSONObject jsonObject = JSONObject.parseObject((String)s);
                    if (jsonObject.getBoolean("success").booleanValue()) {
                        InvoiceOcrDataVO invoiceOcrDataVO = SaleInvoiceServiceImpl.resultToOCRData(new InvoiceOcrData(), jsonObject);
                        invoiceOcrDataVO.setUploadSubAccount(attachmentDTO.getUploadSubAccount());
                        invoiceOcrDataVO.setUploadElsAccount(attachmentDTO.getUploadElsAccount());
                        invoiceOcrDataVO.setFileName(attachmentDTO.getFileName());
                        invoiceOcrDataVO.setFileId(attachmentDTO.getId());
                        invoiceOcrDataVO.setFilePath(signature);
                        invoiceOcrDataVO.setFileSize(attachmentDTO.getFileSize());
                        invoiceOcrDataVO.setFileType(attachmentDTO.getFileType());
                        invoiceOcrDataVO.setData(jsonObject.toJSONString());
                        InvoiceOcrData ocrData = new InvoiceOcrData();
                        BeanUtils.copyProperties((Object)((Object)invoiceOcrDataVO), (Object)((Object)ocrData));
                        this.invoiceOcrDataService.saveMain(ocrData, invoiceOcrDataVO.getInvoiceOcrDataOneList(), invoiceOcrDataVO.getInvoiceOcrDataTwoList(), invoiceOcrDataVO.getInvoiceOcrDataThreeList(), invoiceOcrDataVO.getInvoiceOcrDataFourList(), invoiceOcrDataVO.getInvoiceOcrDataFiveList(), invoiceOcrDataVO.getInvoiceOcrDataSixList(), invoiceOcrDataVO.getInvoiceOcrDataEightList(), invoiceOcrDataVO.getInvoiceOcrDataNineList(), invoiceOcrDataVO.getInvoiceOcrDataTenList(), invoiceOcrDataVO.getInvoiceOcrDataElevenList(), invoiceOcrDataVO.getInvoiceOcrDataTwelveList(), invoiceOcrDataVO.getInvoiceOcrDataThirteenList(), invoiceOcrDataVO.getInvoiceOcrDataFourteenList(), invoiceOcrDataVO.getInvoiceProductDataList(), invoiceOcrDataVO.getInvoiceOcrDataSevenList());
                        continue;
                    }
                    InvoiceOcrData invoiceOcrData = new InvoiceOcrData();
                    invoiceOcrData.setUploadSubAccount(attachmentDTO.getUploadSubAccount());
                    invoiceOcrData.setUploadElsAccount(attachmentDTO.getUploadElsAccount());
                    invoiceOcrData.setFileName(attachmentDTO.getFileName());
                    invoiceOcrData.setFileId(attachmentDTO.getId());
                    invoiceOcrData.setFilePath(attachmentDTO.getFilePath());
                    invoiceOcrData.setFileSize(attachmentDTO.getFileSize());
                    invoiceOcrData.setFileType(attachmentDTO.getFileType());
                    throw new ELSBootException("\u63a5\u53e3\u8c03\u7528\u5931\u8d25:" + jsonObject.getString("message"));
                }
            }
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage());
        }
    }

    @Override
    public List<SaleInvoice> invoiceOCRToSaleInvoice(List<InvoiceOcrData> invoiceOcrDataList) throws ParseException {
        ArrayList<SaleInvoice> saleInvoiceArrayList = new ArrayList<SaleInvoice>();
        if (CollectionUtil.isNotEmpty(invoiceOcrDataList)) {
            for (InvoiceOcrData invoiceOcrData : invoiceOcrDataList) {
                BigDecimal taxTotal;
                BigDecimal netToatal;
                BigDecimal bigDecimal;
                Date invoiceDate;
                String vatInvoiceIssueDate;
                SaleInvoice saleInvoice = new SaleInvoice();
                String invoiceType = invoiceOcrData.getInvoiceType();
                String id = invoiceOcrData.getId();
                InvoiceTypeToClass invoiceTypeToClass = new InvoiceTypeToClass();
                if (invoiceTypeToClass.getOne().contains(invoiceType)) {
                    List<InvoiceOcrDataOne> invoiceOcrDataOneList = this.invoiceOcrDataOneService.selectByMainId(id);
                    InvoiceOcrDataOne invoiceOcrDataOne = invoiceOcrDataOneList.get(0);
                    vatInvoiceIssueDate = invoiceOcrDataOne.getVatInvoiceIssueDate();
                    invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                    saleInvoice.setInvoiceTime(invoiceDate);
                    saleInvoice.setInvoiceNo(invoiceOcrDataOne.getVatInvoiceHaoma());
                    saleInvoice.setInvoiceCode(invoiceOcrDataOne.getVatInvoiceDaima());
                    saleInvoice.setInvoiceTitle(invoiceOcrDataOne.getVatInvoicePayerName());
                    saleInvoice.setInvoiceImg(invoiceOcrData.getFileId() + "-" + invoiceOcrData.getFileName());
                    bigDecimal = new BigDecimal(invoiceOcrDataOne.getVatInvoiceTotalCoverTaxDigits());
                    saleInvoice.setIncludeTaxAmount(bigDecimal);
                    netToatal = new BigDecimal(invoiceOcrDataOne.getVatInvoiceTotal());
                    saleInvoice.setNotIncludeTaxAmount(netToatal);
                    taxTotal = new BigDecimal(invoiceOcrDataOne.getVatInvoiceTaxTotal());
                    saleInvoice.setTaxAmount(taxTotal);
                    saleInvoiceArrayList.add(saleInvoice);
                    continue;
                }
                if (invoiceTypeToClass.getTwo().contains(invoiceType)) {
                    List<InvoiceOcrDataTwo> invoiceOcrDataTwoList = this.invoiceOcrDataTwoService.selectByMainId(id);
                    InvoiceOcrDataTwo invoiceOcrDataTwo = invoiceOcrDataTwoList.get(0);
                    String vehicleInvoiceIssueDate = invoiceOcrDataTwo.getVehicleInvoiceIssueDate();
                    invoiceDate = DateUtils.parseDate((String)vehicleInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                    saleInvoice.setInvoiceTime(invoiceDate);
                    saleInvoice.setInvoiceNo(invoiceOcrDataTwo.getVehicleInvoiceHaoma());
                    saleInvoice.setInvoiceCode(invoiceOcrDataTwo.getVehicleInvoiceDaima());
                    saleInvoice.setInvoiceTitle(invoiceOcrDataTwo.getVehicleInvoiceBuyer());
                    saleInvoice.setInvoiceImg(invoiceOcrData.getFileId() + "-" + invoiceOcrData.getFileName());
                    bigDecimal = new BigDecimal(invoiceOcrDataTwo.getVehicleInvoiceTotalPriceDigits());
                    saleInvoice.setIncludeTaxAmount(bigDecimal);
                    netToatal = new BigDecimal(invoiceOcrDataTwo.getVehicleInvoicePriceWithoutTax());
                    saleInvoice.setNotIncludeTaxAmount(netToatal);
                    taxTotal = new BigDecimal(invoiceOcrDataTwo.getVehicleInvoiceTaxAmount());
                    saleInvoice.setIncludeTaxAmount(taxTotal);
                    saleInvoiceArrayList.add(saleInvoice);
                    continue;
                }
                if (invoiceTypeToClass.getThree().contains(invoiceType)) {
                    List<InvoiceOcrDataThree> invoiceOcrDataThreeList = this.invoiceOcrDataThreeService.selectByMainId(id);
                    InvoiceOcrDataThree invoiceOcrDataThree = invoiceOcrDataThreeList.get(0);
                    vatInvoiceIssueDate = invoiceOcrDataThree.getVehicleInvoiceIssueDate();
                    invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                    saleInvoice.setInvoiceTime(invoiceDate);
                    saleInvoice.setInvoiceNo(invoiceOcrDataThree.getVehicleInvoiceHaoma());
                    saleInvoice.setInvoiceCode(invoiceOcrDataThree.getVehicleInvoiceDaima());
                    saleInvoice.setInvoiceTitle(invoiceOcrDataThree.getVehicleInvoiceBuyer());
                    saleInvoice.setInvoiceImg(invoiceOcrData.getFileId() + "-" + invoiceOcrData.getFileName());
                    bigDecimal = new BigDecimal(invoiceOcrDataThree.getVehicleInvoiceTotalPriceDigits());
                    saleInvoice.setIncludeTaxAmount(bigDecimal);
                    saleInvoiceArrayList.add(saleInvoice);
                    continue;
                }
                if (!invoiceTypeToClass.getFour().contains(invoiceType)) continue;
                List<InvoiceOcrDataFour> invoiceOcrDataFourList = this.invoiceOcrDataFourService.selectByMainId(id);
                InvoiceOcrDataFour invoiceOcrDataFour = invoiceOcrDataFourList.get(0);
                vatInvoiceIssueDate = invoiceOcrDataFour.getDateOfInvoice();
                invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                saleInvoice.setInvoiceTime(invoiceDate);
                saleInvoice.setInvoiceNo(invoiceOcrDataFour.getInvoiceNumber());
                saleInvoice.setInvoiceCode(invoiceOcrDataFour.getInvoiceCode());
                saleInvoice.setInvoiceTitle(invoiceOcrDataFour.getInvoiceHead());
                saleInvoice.setInvoiceImg(invoiceOcrData.getFileId() + "-" + invoiceOcrData.getFileName());
                bigDecimal = new BigDecimal(invoiceOcrDataFour.getTotalMoney());
                saleInvoice.setIncludeTaxAmount(bigDecimal);
                saleInvoiceArrayList.add(saleInvoice);
            }
        }
        return saleInvoiceArrayList;
    }

    private String getSignature(String saveType, String filePath) {
        return this.invokeBaseRpcService.getSignature(saveType, filePath, this.address + "/opt/upFiles");
    }

    private static InvoiceOcrDataVO resultToOCRData(InvoiceOcrData invoiceOcrData, JSONObject jsonObject) throws ParseException {
        SerializeConfig serializeConfig = new SerializeConfig();
        serializeConfig.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
        String json = JSON.toJSONString((Object)jsonObject, (SerializeConfig)serializeConfig, (SerializerFeature[])new SerializerFeature[0]);
        InvoiceOcrDataVO invoiceOcrDataVO = new InvoiceOcrDataVO();
        JSONObject object = jsonObject.getJSONObject("data");
        invoiceOcrDataVO.setOcrResult(object.getString("message"));
        if (!object.containsKey((Object)"result")) {
            return invoiceOcrDataVO;
        }
        JSONObject result = object.getJSONObject("result");
        JSONArray objectList = result.getJSONArray("object_list");
        Iterator iterator = objectList.stream().iterator();
        while (iterator.hasNext()) {
            Date invoiceDate;
            String vatInvoiceIssueDate;
            JSONObject object1 = JSONObject.parseObject((String)iterator.next().toString());
            String invoiceType = object1.getString("type");
            invoiceOcrDataVO.setInvoiceKind(object1.getString("kind"));
            invoiceOcrDataVO.setInvoiceClass(object1.getString("class"));
            invoiceOcrDataVO.setInvoiceType(invoiceType);
            JSONArray item_list = object1.getJSONArray("item_list");
            Iterator objectIterator = item_list.stream().iterator();
            JSONObject jsonItem = new JSONObject();
            while (objectIterator.hasNext()) {
                JSONObject object2 = JSONObject.parseObject((String)objectIterator.next().toString());
                String key = object2.getString("key");
                String value = object2.getString("value");
                jsonItem.put(key, (Object)value);
            }
            String item = JSON.toJSONString((Object)jsonItem, (SerializeConfig)serializeConfig, (SerializerFeature[])new SerializerFeature[0]);
            InvoiceTypeToClass invoiceTypeToClass = new InvoiceTypeToClass();
            if (invoiceTypeToClass.getOne().contains(invoiceType)) {
                InvoiceOcrDataOne invoiceOcrDataOne = (InvoiceOcrDataOne)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataOne.class));
                invoiceOcrDataVO.setInvoiceCode(invoiceOcrDataOne.getVatInvoiceDaima());
                invoiceOcrDataVO.setVerifyCode(invoiceOcrDataOne.getVatInvoiceCorrectCode());
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataOne.getVatInvoiceHaoma());
                vatInvoiceIssueDate = invoiceOcrDataOne.getVatInvoiceIssueDate();
                invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                invoiceOcrDataVO.setInvoiceDate(invoiceDate);
                invoiceOcrDataVO.setInvoiceOcrDataOneList(Arrays.asList(invoiceOcrDataOne));
                if (!object1.containsKey((Object)"product_list")) continue;
                ArrayList<InvoiceProductData> invoiceProductData = new ArrayList<InvoiceProductData>();
                JSONArray productList = object1.getJSONArray("product_list");
                for (int i = 0; i < productList.size(); ++i) {
                    JSONArray array = JSONArray.parseArray((String)productList.get(i).toString());
                    Iterator arrayIterator = array.stream().iterator();
                    JSONObject jsonProduct = new JSONObject();
                    while (arrayIterator.hasNext()) {
                        JSONObject object2 = JSONObject.parseObject((String)arrayIterator.next().toString());
                        String key = object2.getString("key");
                        String value = object2.getString("value");
                        jsonProduct.put(key, (Object)value);
                    }
                    InvoiceProductData o = (InvoiceProductData)((Object)JSONObject.parseObject((String)jsonProduct.toJSONString(), InvoiceProductData.class));
                    invoiceProductData.add(o);
                }
                invoiceOcrDataVO.setInvoiceProductDataList(invoiceProductData);
                continue;
            }
            if (invoiceTypeToClass.getTwo().contains(invoiceType)) {
                InvoiceOcrDataTwo invoiceOcrDataTwo = (InvoiceOcrDataTwo)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataTwo.class));
                invoiceOcrDataVO.setInvoiceCode(invoiceOcrDataTwo.getVehicleInvoiceDaima());
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataTwo.getVehicleInvoiceHaoma());
                vatInvoiceIssueDate = invoiceOcrDataTwo.getVehicleInvoiceIssueDate();
                invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                invoiceOcrDataVO.setInvoiceDate(invoiceDate);
                invoiceOcrDataVO.setInvoiceOcrDataTwoList(Arrays.asList(invoiceOcrDataTwo));
                continue;
            }
            if (invoiceTypeToClass.getThree().contains(invoiceType)) {
                InvoiceOcrDataThree invoiceOcrDataThree = (InvoiceOcrDataThree)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataThree.class));
                invoiceOcrDataVO.setInvoiceCode(invoiceOcrDataThree.getVehicleInvoiceDaima());
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataThree.getVehicleInvoiceHaoma());
                vatInvoiceIssueDate = invoiceOcrDataThree.getVehicleInvoiceIssueDate();
                invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                invoiceOcrDataVO.setInvoiceDate(invoiceDate);
                invoiceOcrDataVO.setInvoiceOcrDataThreeList(Arrays.asList(invoiceOcrDataThree));
                continue;
            }
            if (invoiceTypeToClass.getFour().contains(invoiceType)) {
                InvoiceOcrDataFour invoiceOcrDataFour = (InvoiceOcrDataFour)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataFour.class));
                invoiceOcrDataVO.setInvoiceCode(invoiceOcrDataFour.getInvoiceCode());
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataFour.getInvoiceNumber());
                vatInvoiceIssueDate = invoiceOcrDataFour.getDateOfInvoice();
                invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                invoiceOcrDataVO.setInvoiceDate(invoiceDate);
                invoiceOcrDataVO.setInvoiceOcrDataFourList(Arrays.asList((InvoiceOcrDataFour)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataFour.class))));
                continue;
            }
            if (invoiceTypeToClass.getFive().contains(invoiceType)) {
                InvoiceOcrDataFive invoiceOcrDataFive = (InvoiceOcrDataFive)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataFive.class));
                invoiceOcrDataVO.setInvoiceCode(invoiceOcrDataFive.getTollCode());
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataFive.getTollNumber());
                vatInvoiceIssueDate = invoiceOcrDataFive.getDate();
                invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                invoiceOcrDataVO.setInvoiceDate(invoiceDate);
                invoiceOcrDataVO.setInvoiceOcrDataFiveList(Arrays.asList((InvoiceOcrDataFive)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataFive.class))));
                continue;
            }
            if (invoiceTypeToClass.getSix().contains(invoiceType)) {
                InvoiceOcrDataSix invoiceOcrDataSix = (InvoiceOcrDataSix)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataSix.class));
                invoiceOcrDataVO.setInvoiceCode(invoiceOcrDataSix.getQuotaInvoiceCode());
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataSix.getQuotaInvoiceNumber());
                invoiceOcrDataVO.setInvoiceOcrDataSixList(Arrays.asList((InvoiceOcrDataSix)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataSix.class))));
                continue;
            }
            if (invoiceTypeToClass.getSeven().contains(invoiceType)) {
                InvoiceOcrDataSeven invoiceOcrDataSeven = (InvoiceOcrDataSeven)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataSeven.class));
                invoiceOcrDataVO.setInvoiceCode(invoiceOcrDataSeven.getInvoiceCode());
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataSeven.getInvoiceNo());
                vatInvoiceIssueDate = invoiceOcrDataSeven.getDate();
                invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                invoiceOcrDataVO.setInvoiceDate(invoiceDate);
                invoiceOcrDataVO.setInvoiceOcrDataSevenList(Arrays.asList((InvoiceOcrDataSeven)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataSeven.class))));
                continue;
            }
            if (invoiceTypeToClass.getEight().contains(invoiceType)) {
                InvoiceOcrDataEight invoiceOcrDataEight = (InvoiceOcrDataEight)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataEight.class));
                invoiceOcrDataVO.setInvoiceOcrDataEightList(Arrays.asList((InvoiceOcrDataEight)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataEight.class))));
                continue;
            }
            if (invoiceTypeToClass.getNine().contains(invoiceType)) {
                InvoiceOcrDataNine invoiceOcrDataNine = (InvoiceOcrDataNine)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataNine.class));
                invoiceOcrDataVO.setInvoiceOcrDataNineList(Arrays.asList((InvoiceOcrDataNine)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataNine.class))));
                continue;
            }
            if (invoiceTypeToClass.getTen().contains(invoiceType)) {
                InvoiceOcrDataTen invoiceOcrDataTen = (InvoiceOcrDataTen)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataTen.class));
                invoiceOcrDataVO.setInvoiceCode(invoiceOcrDataTen.getInvoiceCode());
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataTen.getInvoiceNumber());
                vatInvoiceIssueDate = invoiceOcrDataTen.getDate();
                invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                invoiceOcrDataVO.setInvoiceDate(invoiceDate);
                invoiceOcrDataVO.setInvoiceOcrDataTenList(Arrays.asList((InvoiceOcrDataTen)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataTen.class))));
                continue;
            }
            if (invoiceTypeToClass.getEleven().contains(invoiceType)) {
                InvoiceOcrDataEleven invoiceOcrDataEleven = (InvoiceOcrDataEleven)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataEleven.class));
                invoiceOcrDataVO.setInvoiceCode(invoiceOcrDataEleven.getInvoiceCode());
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataEleven.getInvoiceNumber());
                vatInvoiceIssueDate = invoiceOcrDataEleven.getDate();
                invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                invoiceOcrDataVO.setInvoiceDate(invoiceDate);
                invoiceOcrDataVO.setInvoiceOcrDataElevenList(Arrays.asList((InvoiceOcrDataEleven)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataEleven.class))));
                continue;
            }
            if (invoiceTypeToClass.getTwelve().contains(invoiceType)) {
                InvoiceOcrDataTwelve invoiceOcrDataTwelve = (InvoiceOcrDataTwelve)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataTwelve.class));
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataTwelve.getInvoiceNumber());
                invoiceOcrDataVO.setInvoiceOcrDataTwelveList(Arrays.asList((InvoiceOcrDataTwelve)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataTwelve.class))));
                continue;
            }
            if (invoiceTypeToClass.getThirtten().contains(invoiceType)) {
                InvoiceOcrDataThirteen invoiceOcrDataThirteen = (InvoiceOcrDataThirteen)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataThirteen.class));
                invoiceOcrDataVO.setInvoiceCode(invoiceOcrDataThirteen.getInvoiceCode());
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataThirteen.getInvoiceNumber());
                invoiceOcrDataVO.setInvoiceOcrDataThirteenList(Arrays.asList((InvoiceOcrDataThirteen)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataThirteen.class))));
                continue;
            }
            if (!invoiceTypeToClass.getFourteen().contains(invoiceType)) continue;
            InvoiceOcrDataFourteen invoiceOcrDataFourteen = (InvoiceOcrDataFourteen)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataFourteen.class));
            vatInvoiceIssueDate = invoiceOcrDataFourteen.getDate();
            invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
            invoiceOcrDataVO.setInvoiceDate(invoiceDate);
            invoiceOcrDataVO.setInvoiceOcrDataFourteenList(Arrays.asList((InvoiceOcrDataFourteen)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataFourteen.class))));
        }
        return invoiceOcrDataVO;
    }
}

