/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SpringContextUtils;
import com.els.modules.finance.api.enumerate.AddCostConfirmStatusEnum;
import com.els.modules.finance.entity.PurchaseAddCost;
import com.els.modules.finance.entity.SaleAddCost;
import com.els.modules.finance.mapper.PurchaseAddCostMapper;
import com.els.modules.finance.service.PurchaseAddCostService;
import com.els.modules.finance.service.SaleAddCostService;
import com.els.modules.finance.service.impl.SaleAddCostServiceImpl;
import com.els.modules.reconciliation.api.dto.PurchaseDeliveryWaterDTO;
import com.els.modules.reconciliation.entity.PurchaseRecAdditionalCharges;
import com.els.modules.reconciliation.enumerate.ReconcilationItemTypeEmun;
import com.els.modules.reconciliation.service.PurchaseDeliveryWaterService;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import com.els.rpc.service.CoreInvokeSupplierRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseAddCostServiceImpl
extends BaseServiceImpl<PurchaseAddCostMapper, PurchaseAddCost>
implements PurchaseAddCostService {
    @Resource
    private CoreInvokeSupplierRpcService supplierContactsInfoService;
    @Autowired
    private PurchaseDeliveryWaterService purchaseDeliveryWaterService;

    @Override
    public void savePurchaseAddCost(PurchaseAddCost purchaseAddCost) {
        ((PurchaseAddCostMapper)this.baseMapper).insert((Object)purchaseAddCost);
    }

    @Override
    public void updatePurchaseAddCost(PurchaseAddCost purchaseAddCost) {
        ((PurchaseAddCostMapper)this.baseMapper).updateById((Object)purchaseAddCost);
    }

    @Override
    public void delPurchaseAddCost(String id) {
        ((PurchaseAddCostMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseAddCost(List<String> idList) {
        ((PurchaseAddCostMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void replyAddCost(PurchaseAddCost purchaseAddCost) {
        String relationId = purchaseAddCost.getRelationId();
        SaleAddCost saleAddCost = new SaleAddCost();
        saleAddCost.setId(relationId);
        saleAddCost.setConfirmStatus(purchaseAddCost.getConfirmStatus());
        SaleAddCostService saleAddCostService = (SaleAddCostService)SpringContextUtils.getBean(SaleAddCostServiceImpl.class);
        saleAddCostService.updateById((Object)saleAddCost);
        this.updateById((Object)purchaseAddCost);
        PurchaseAddCost byId = (PurchaseAddCost)((Object)this.getById((Serializable)((Object)purchaseAddCost.getId())));
        PurchaseDeliveryWaterDTO purchaseDeliveryWater = new PurchaseDeliveryWaterDTO();
        BeanUtils.copyProperties((Object)((Object)byId), (Object)purchaseDeliveryWater);
        if (!ObjectUtils.isEmpty((Object)purchaseDeliveryWater)) {
            purchaseDeliveryWater.setDocumentNumber(byId.getCostNumber());
            purchaseDeliveryWater.setTotalAmount(byId.getTaxAmount());
            purchaseDeliveryWater.setTotalNonTaxAmount(byId.getNetAmount());
            purchaseDeliveryWater.setCompany(byId.getCompany());
            purchaseDeliveryWater.setToElsAccount(byId.getToElsAccount());
            purchaseDeliveryWater.setDocumentCategory("2");
            purchaseDeliveryWater.setDocumentStatus(byId.getConfirmStatus());
            purchaseDeliveryWater.setDocumentType("2");
            purchaseDeliveryWater.setReconciliationNumber(byId.getReconciliationNumber());
            purchaseDeliveryWater.setId(null);
            this.purchaseDeliveryWaterService.insert(purchaseDeliveryWater);
        }
        String urlParam = "id=" + purchaseAddCost.getRelationId();
        super.sendMsg(byId.getElsAccount(), byId.getToElsAccount(), (Object)byId, urlParam, "addCost", "reply");
    }

    @Override
    public List<PurchaseAddCost> listPurchaseAddCost(ReconciliationVO reconciliationVO, String elsAccount) {
        QueryWrapper addCostWapper = new QueryWrapper();
        addCostWapper.eq((Object)"els_account", (Object)elsAccount);
        addCostWapper.eq((Object)"to_els_account", (Object)reconciliationVO.getToElsAccount());
        addCostWapper.eq((Object)"company", (Object)reconciliationVO.getCompany());
        addCostWapper.ge((Object)"cost_time", (Object)reconciliationVO.getBeginDate());
        addCostWapper.le((Object)"cost_time", (Object)reconciliationVO.getEndDate());
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getTaxCode())) {
            addCostWapper.eq((Object)"tax_code", (Object)reconciliationVO.getTaxCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getCurrency())) {
            addCostWapper.eq((Object)"currency", (Object)reconciliationVO.getCurrency());
        }
        addCostWapper.eq((Object)"confirm_status", (Object)AddCostConfirmStatusEnum.ALREADY_CONFIRM.getValue());
        addCostWapper.and(q -> ((QueryWrapper)((QueryWrapper)q.isNull((Object)"cost_status")).or()).eq((Object)"cost_status", (Object)"0"));
        return this.list((Wrapper)addCostWapper);
    }

    @Override
    public List<PurchaseRecAdditionalCharges> getByPurchaseAddCost(ReconciliationVO reconciliationVO, String elsAccount) {
        List<PurchaseAddCost> purchaseAddCosts = this.listPurchaseAddCost(reconciliationVO, elsAccount);
        ArrayList<PurchaseRecAdditionalCharges> additionalCharges = new ArrayList<PurchaseRecAdditionalCharges>();
        if (CollectionUtils.isEmpty(purchaseAddCosts)) {
            return null;
        }
        for (PurchaseAddCost purchaseAddCost : purchaseAddCosts) {
            PurchaseRecAdditionalCharges charges = new PurchaseRecAdditionalCharges();
            BeanUtils.copyProperties((Object)((Object)purchaseAddCost), (Object)((Object)charges));
            charges.setVoucherNumber(purchaseAddCost.getCostNumber());
            charges.setBusinessType(purchaseAddCost.getCostType());
            charges.setTotalAmount(purchaseAddCost.getTaxAmount());
            charges.setTotalNonTaxAmount(purchaseAddCost.getNetAmount());
            charges.setSource(purchaseAddCost.getSourceType());
            charges.setBusinessId(purchaseAddCost.getId());
            charges.setItemType(ReconcilationItemTypeEmun.ADDITIONAL_CHARGES.getValue());
            charges.setDocumentParentId(purchaseAddCost.getId());
            charges.setId(null);
            additionalCharges.add(charges);
        }
        return additionalCharges;
    }
}

