/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.SpringContextUtils;
import com.els.modules.finance.api.enumerate.DeductCostConfirmStatusEnum;
import com.els.modules.finance.entity.PurchaseDeductCost;
import com.els.modules.finance.entity.SaleDeductCost;
import com.els.modules.finance.mapper.SaleDeductCostMapper;
import com.els.modules.finance.service.PurchaseDeductCostService;
import com.els.modules.finance.service.SaleDeductCostService;
import com.els.modules.finance.service.impl.PurchaseDeductCostServiceImpl;
import com.els.modules.reconciliation.api.dto.PurchaseDeliveryWaterDTO;
import com.els.modules.reconciliation.entity.SaleRecCharge;
import com.els.modules.reconciliation.enumerate.ReconcilationItemTypeEmun;
import com.els.modules.reconciliation.service.PurchaseDeliveryWaterService;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import com.els.rpc.service.CoreInvokeSupplierRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SaleDeductCostServiceImpl
extends BaseServiceImpl<SaleDeductCostMapper, SaleDeductCost>
implements SaleDeductCostService {
    @Autowired
    private CoreInvokeSupplierRpcService supplierContactsInfoService;
    @Resource
    private PurchaseDeliveryWaterService purchaseDeliveryWaterService;

    @Override
    public void saveSaleDeductCost(SaleDeductCost saleDeductCost) {
        ((SaleDeductCostMapper)this.baseMapper).insert((Object)saleDeductCost);
    }

    @Override
    public void updateSaleDeductCost(SaleDeductCost saleDeductCost) {
        ((SaleDeductCostMapper)this.baseMapper).updateById((Object)saleDeductCost);
    }

    @Override
    public void delSaleDeductCost(String id) {
        ((SaleDeductCostMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchSaleDeductCost(List<String> idList) {
        ((SaleDeductCostMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void replyDeductCost(SaleDeductCost saleDeductCost) {
        String relationId = saleDeductCost.getRelationId();
        PurchaseDeductCost purchaseDeductCost = new PurchaseDeductCost();
        purchaseDeductCost.setId(relationId);
        purchaseDeductCost.setConfirmStatus(saleDeductCost.getConfirmStatus());
        PurchaseDeductCostService purchaseDeductCostService = (PurchaseDeductCostService)SpringContextUtils.getBean(PurchaseDeductCostServiceImpl.class);
        purchaseDeductCostService.updateById((Object)purchaseDeductCost);
        this.updateById((Object)saleDeductCost);
        SaleDeductCost byId = (SaleDeductCost)((Object)this.getById((Serializable)((Object)saleDeductCost.getId())));
        PurchaseDeliveryWaterDTO purchaseDeliveryWater = new PurchaseDeliveryWaterDTO();
        BeanUtils.copyProperties((Object)((Object)byId), (Object)purchaseDeliveryWater);
        if (!ObjectUtils.isEmpty((Object)purchaseDeliveryWater)) {
            purchaseDeliveryWater.setDocumentNumber(byId.getDeductNumber());
            purchaseDeliveryWater.setTotalAmount(byId.getTaxAmount());
            purchaseDeliveryWater.setTotalNonTaxAmount(byId.getNetAmount());
            purchaseDeliveryWater.setToElsAccount(byId.getElsAccount());
            purchaseDeliveryWater.setDocumentCategory("1");
            purchaseDeliveryWater.setDocumentStatus(byId.getConfirmStatus());
            purchaseDeliveryWater.setDocumentType("1");
            purchaseDeliveryWater.setReconciliationNumber(byId.getReconciliationNumber());
            purchaseDeliveryWater.setElsAccount(byId.getToElsAccount());
            purchaseDeliveryWater.setToElsAccount(byId.getElsAccount());
            this.purchaseDeliveryWaterService.insert(purchaseDeliveryWater);
        }
        String urlParam = "id=" + byId.getRelationId();
        super.sendMsg(byId.getElsAccount(), byId.getToElsAccount(), (Object)byId, urlParam, "deductCost", "reply");
    }

    @Override
    public List<SaleDeductCost> listSaleDeductCosts(ReconciliationVO reconciliationVO) {
        QueryWrapper deDuctWapper = new QueryWrapper();
        deDuctWapper.eq((Object)"els_account", (Object)reconciliationVO.getElsAccount());
        deDuctWapper.eq((Object)"to_els_account", (Object)reconciliationVO.getToElsAccount());
        deDuctWapper.eq((Object)"company", (Object)reconciliationVO.getCompany());
        deDuctWapper.ge((Object)"deduct_time", (Object)reconciliationVO.getBeginDate());
        deDuctWapper.le((Object)"deduct_time", (Object)reconciliationVO.getEndDate());
        deDuctWapper.eq((Object)"confirm_status", (Object)DeductCostConfirmStatusEnum.ALREADY_CONFIRM.getValue());
        deDuctWapper.and(q -> ((QueryWrapper)((QueryWrapper)q.isNull((Object)"deduct_status")).or()).eq((Object)"deduct_status", (Object)"0"));
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getTaxCode())) {
            deDuctWapper.eq((Object)"tax_code", (Object)reconciliationVO.getTaxCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getCurrency())) {
            deDuctWapper.eq((Object)"currency", (Object)reconciliationVO.getCurrency());
        }
        return this.list((Wrapper)deDuctWapper);
    }

    @Override
    public List<SaleRecCharge> getBySaleDeductCost(ReconciliationVO reconciliationVO) {
        List<SaleDeductCost> saleDeductCosts = this.listSaleDeductCosts(reconciliationVO);
        ArrayList<SaleRecCharge> charges = new ArrayList<SaleRecCharge>();
        if (CollectionUtils.isEmpty(saleDeductCosts)) {
            return null;
        }
        for (SaleDeductCost saleDeductCost : saleDeductCosts) {
            SaleRecCharge charge = new SaleRecCharge();
            BeanUtils.copyProperties((Object)((Object)saleDeductCost), (Object)((Object)charge));
            charge.setItemType(ReconcilationItemTypeEmun.CHARGE.getValue());
            charge.setVoucherNumber(saleDeductCost.getDeductNumber());
            charge.setVoucherTime(saleDeductCost.getDeductTime());
            charge.setDeductionType(saleDeductCost.getDeductType());
            charge.setTotalAmount(saleDeductCost.getTaxAmount());
            charge.setTotalNonTaxAmount(saleDeductCost.getNetAmount());
            charge.setDeductionsReason(saleDeductCost.getDeductReason());
            charge.setDeductionsInstructions(saleDeductCost.getDeductInstruction());
            charge.setSource(saleDeductCost.getSourceType());
            charge.setBusinessType(saleDeductCost.getRelationType());
            charge.setBusinessId(saleDeductCost.getId());
            charge.setTaxCode(saleDeductCost.getTaxCode());
            charge.setTaxRate(saleDeductCost.getTaxRate());
            charge.setDocumentId(saleDeductCost.getDocumentId());
            charge.setDocumentParentId(saleDeductCost.getRelationId());
            charge.setId(null);
            charges.add(charge);
        }
        return charges;
    }
}

