/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.service.impl;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SysUtil;
import com.els.modules.finance.entity.SalePaymentApplyHead;
import com.els.modules.finance.entity.SalePaymentApplyItem;
import com.els.modules.finance.mapper.SalePaymentApplyHeadMapper;
import com.els.modules.finance.mapper.SalePaymentApplyItemMapper;
import com.els.modules.finance.service.SalePaymentApplyHeadService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SalePaymentApplyHeadServiceImpl
extends ServiceImpl<SalePaymentApplyHeadMapper, SalePaymentApplyHead>
implements SalePaymentApplyHeadService {
    @Resource
    private SalePaymentApplyHeadMapper salePaymentApplyHeadMapper;
    @Resource
    private SalePaymentApplyItemMapper salePaymentApplyItemMapper;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SalePaymentApplyHead salePaymentApplyHead, List<SalePaymentApplyItem> salePaymentApplyItemList) {
        this.salePaymentApplyHeadMapper.insert((Object)salePaymentApplyHead);
        this.insertData(salePaymentApplyHead, salePaymentApplyItemList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(SalePaymentApplyHead salePaymentApplyHead, List<SalePaymentApplyItem> salePaymentApplyItemList) {
        this.salePaymentApplyHeadMapper.updateById((Object)salePaymentApplyHead);
        this.salePaymentApplyItemMapper.deleteByMainId(salePaymentApplyHead.getId());
        this.insertData(salePaymentApplyHead, salePaymentApplyItemList);
    }

    private void insertData(SalePaymentApplyHead salePaymentApplyHead, List<SalePaymentApplyItem> salePaymentApplyItemList) {
        for (SalePaymentApplyItem entity : salePaymentApplyItemList) {
            entity.setHeadId(salePaymentApplyHead.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)salePaymentApplyHead);
        }
        if (!salePaymentApplyItemList.isEmpty()) {
            this.salePaymentApplyItemMapper.insertBatchSomeColumn(salePaymentApplyItemList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.salePaymentApplyItemMapper.deleteByMainId(id);
        this.salePaymentApplyHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.salePaymentApplyItemMapper.deleteByMainId(serializable.toString());
            this.salePaymentApplyHeadMapper.deleteById(serializable);
        }
    }
}

