/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.modules.finance.entity.SalePaymentApplyHead;
import com.els.modules.finance.entity.SalePaymentApplyItem;
import com.els.modules.finance.mapper.SalePaymentApplyItemMapper;
import com.els.modules.finance.service.SalePaymentApplyHeadService;
import com.els.modules.finance.service.SalePaymentApplyItemService;
import com.els.modules.reconciliation.entity.ElsPurchaseStatisticsWriteOff;
import com.els.modules.reconciliation.entity.SalePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.enumerate.ReconcilationItemTypeEmun;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffService;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SalePaymentApplyItemServiceImpl
extends ServiceImpl<SalePaymentApplyItemMapper, SalePaymentApplyItem>
implements SalePaymentApplyItemService {
    @Resource
    private SalePaymentApplyItemMapper salePaymentApplyItemMapper;
    @Autowired
    private ElsPurchaseStatisticsWriteOffService elsPurchaseStatisticsWriteOffService;
    @Autowired
    private SalePaymentApplyHeadService salePaymentApplyHeadService;

    @Override
    public List<SalePaymentApplyItem> selectByMainId(String mainId) {
        return this.salePaymentApplyItemMapper.selectByMainId(mainId);
    }

    @Override
    public List<SalePaymentApplyItem> listSalePaymentApplyItem(ReconciliationVO reconciliationVO) {
        return this.salePaymentApplyItemMapper.listPurchasePaymentApplyItem(reconciliationVO);
    }

    @Override
    public List<SalePrePaymentWriteOffReconciliation> getSalePrePaymentWriteOffReconciliations(ReconciliationVO reconciliationVO) {
        List salePaymentApplyHeadList;
        List<SalePaymentApplyItem> salePaymentApplyItems = this.listSalePaymentApplyItem(reconciliationVO);
        ArrayList<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffReconciliationList = new ArrayList<SalePrePaymentWriteOffReconciliation>();
        if (CollectionUtils.isEmpty(salePaymentApplyItems)) {
            return null;
        }
        Set salePayHeadIds = salePaymentApplyItems.stream().filter(item -> !StringUtils.isEmpty((CharSequence)item.getHeadId())).map(SalePaymentApplyItem::getHeadId).collect(Collectors.toSet());
        HashMap<String, String> purchasePreHeadMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(salePayHeadIds) && !CollectionUtils.isEmpty((Collection)(salePaymentApplyHeadList = this.salePaymentApplyHeadService.listByIds(salePayHeadIds)))) {
            for (SalePaymentApplyHead salePaymentApplyHead : salePaymentApplyHeadList) {
                purchasePreHeadMap.put(salePaymentApplyHead.getId(), salePaymentApplyHead.getRelationId());
            }
        }
        HashMap<String, ElsPurchaseStatisticsWriteOff> map = new HashMap<String, ElsPurchaseStatisticsWriteOff>();
        this.getElsStatisticsWriteOffMap(salePaymentApplyItems, map);
        for (SalePaymentApplyItem salePaymentApplyItem : salePaymentApplyItems) {
            ElsPurchaseStatisticsWriteOff writeOff;
            SalePrePaymentWriteOffReconciliation prePaymentWriteOffReconciliation = new SalePrePaymentWriteOffReconciliation();
            BeanUtils.copyProperties((Object)((Object)salePaymentApplyItem), (Object)((Object)prePaymentWriteOffReconciliation));
            prePaymentWriteOffReconciliation.setSourceType(ReconcilationItemTypeEmun.PRE_PAYMENT.getValue());
            prePaymentWriteOffReconciliation.setPayAmount(salePaymentApplyItem.getPayAmount());
            prePaymentWriteOffReconciliation.setSourceTaxAmount(salePaymentApplyItem.getShouldTaxAmount());
            prePaymentWriteOffReconciliation.setSourceNetAmount(salePaymentApplyItem.getShouldNoTaxAmount());
            prePaymentWriteOffReconciliation.setSourceTax(salePaymentApplyItem.getTaxAmount());
            prePaymentWriteOffReconciliation.setSourcePrice(salePaymentApplyItem.getPayAmount());
            prePaymentWriteOffReconciliation.setId(null);
            prePaymentWriteOffReconciliation.setBusinessId(salePaymentApplyItem.getId());
            if (!StringUtils.isEmpty((CharSequence)salePaymentApplyItem.getHeadId()) && purchasePreHeadMap.get(salePaymentApplyItem.getHeadId()) != null) {
                String preHeadId = (String)purchasePreHeadMap.get(salePaymentApplyItem.getHeadId());
                prePaymentWriteOffReconciliation.setPreHeadId(preHeadId);
            }
            if ((writeOff = (ElsPurchaseStatisticsWriteOff)((Object)map.get(salePaymentApplyItem.getRelationId()))) != null) {
                BigDecimal sourceUnWrittenOffAmount;
                BigDecimal bigDecimal = sourceUnWrittenOffAmount = writeOff.getSourceUnWrittenOffAmount() == null ? BigDecimal.ZERO : writeOff.getSourceUnWrittenOffAmount();
                if (BigDecimal.ZERO.compareTo(sourceUnWrittenOffAmount) == 0) continue;
                prePaymentWriteOffReconciliation.setUnWrittenOffAmount(writeOff.getSourceUnWrittenOffAmount());
                prePaymentWriteOffReconciliation.setWrittenOffAmount(writeOff.getSourceWrittenOffAmount());
            }
            salePrePaymentWriteOffReconciliationList.add(prePaymentWriteOffReconciliation);
        }
        return salePrePaymentWriteOffReconciliationList;
    }

    private void getElsStatisticsWriteOffMap(List<SalePaymentApplyItem> salePaymentApplyItems, Map<String, ElsPurchaseStatisticsWriteOff> map) {
        HashSet<String> ids = new HashSet<String>();
        for (SalePaymentApplyItem salePaymentApplyItem : salePaymentApplyItems) {
            ids.add(salePaymentApplyItem.getRelationId());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_id", ids);
        List list = this.elsPurchaseStatisticsWriteOffService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (ElsPurchaseStatisticsWriteOff writeOff : list) {
            map.put(writeOff.getSourceId(), writeOff);
        }
    }
}

