/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.reconciliation.api.dto.PurchaseDeliveryWaterDTO;
import com.els.modules.reconciliation.entity.PurchaseDeliveryWater;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.PurchaseInvoiceHookInformation;
import com.els.modules.reconciliation.entity.SaleDeliveryWater;
import com.els.modules.reconciliation.mapper.PurchaseDeliveryWaterMapper;
import com.els.modules.reconciliation.mapper.SaleDeliveryWaterMapper;
import com.els.modules.reconciliation.service.PurchaseDeliveryWaterService;
import com.els.modules.reconciliation.service.PurchaseInvoiceHookInformationService;
import com.els.modules.reconciliation.service.SaleDeliveryWaterService;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class PurchaseDeliveryWaterServiceImpl
extends BaseServiceImpl<PurchaseDeliveryWaterMapper, PurchaseDeliveryWater>
implements PurchaseDeliveryWaterService {
    @Resource
    private PurchaseDeliveryWaterMapper purchaseDeliveryWaterMapper;
    @Resource
    private SaleDeliveryWaterMapper saleDeliveryWaterMapper;
    @Resource
    private TemplateRpcService templateRpcService;
    @Autowired
    private PurchaseInvoiceHookInformationService purchaseInvoiceHookInformationService;
    @Autowired
    private SaleDeliveryWaterService saleDeliveryWaterService;

    @Override
    public void add(PurchaseDeliveryWater purchaseDeliveryWater) {
        ((PurchaseDeliveryWaterMapper)this.baseMapper).insert((Object)purchaseDeliveryWater);
    }

    @Override
    public void edit(PurchaseDeliveryWater purchaseDeliveryWater) {
        int count = ((PurchaseDeliveryWaterMapper)this.baseMapper).updateById((Object)purchaseDeliveryWater);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((PurchaseDeliveryWaterMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchaseDeliveryWaterMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void insert(PurchaseDeliveryWaterDTO purchaseDeliveryWaterDTO) {
        List template = this.templateRpcService.getDefaultTemplateByType("deliverywater");
        Optional templateHeadDTOOptional = template.stream().findFirst();
        if (templateHeadDTOOptional.isPresent()) {
            TemplateHeadDTO dto = (TemplateHeadDTO)templateHeadDTOOptional.get();
            purchaseDeliveryWaterDTO.setTemplateAccount("100000");
            purchaseDeliveryWaterDTO.setTemplateName(dto.getTemplateName());
            purchaseDeliveryWaterDTO.setTemplateVersion(String.valueOf(dto.getTemplateVersion()));
            purchaseDeliveryWaterDTO.setTemplateNumber(dto.getTemplateNumber());
        }
        PurchaseDeliveryWater purchaseDeliveryWater = (PurchaseDeliveryWater)((Object)SysUtil.copyProperties((Object)purchaseDeliveryWaterDTO, PurchaseDeliveryWater.class));
        purchaseDeliveryWater.setId(null);
        purchaseDeliveryWater.setConfirmTime(new Date());
        purchaseDeliveryWater.setCreateBy(null);
        purchaseDeliveryWater.setCreateTime(null);
        purchaseDeliveryWater.setUpdateTime(null);
        purchaseDeliveryWater.setUpdateBy(null);
        this.purchaseDeliveryWaterMapper.insert((Object)purchaseDeliveryWater);
        SaleDeliveryWater saleDeliveryWater = new SaleDeliveryWater();
        BeanUtils.copyProperties((Object)((Object)purchaseDeliveryWater), (Object)((Object)saleDeliveryWater));
        saleDeliveryWater.setElsAccount(purchaseDeliveryWater.getToElsAccount());
        saleDeliveryWater.setBusAccount(purchaseDeliveryWater.getElsAccount());
        saleDeliveryWater.setToElsAccount(purchaseDeliveryWater.getElsAccount());
        saleDeliveryWater.setRelationId(purchaseDeliveryWater.getId());
        this.saleDeliveryWaterMapper.insert((Object)saleDeliveryWater);
        purchaseDeliveryWater.setRelationId(saleDeliveryWater.getId());
        this.purchaseDeliveryWaterMapper.updateById((Object)purchaseDeliveryWater);
    }

    @Override
    public void handleWaterData(List<PurchaseInvoice> invoices, ReconciliationVO reconciliationVO) {
        Set invoiceIds = invoices.stream().filter(invoice -> !StringUtils.isEmpty((CharSequence)invoice.getId())).map(BaseEntity::getId).collect(Collectors.toSet());
        HashMap<String, PurchaseInvoice> invoiceMap = new HashMap<String, PurchaseInvoice>();
        if (CollectionUtils.isEmpty(invoiceIds)) {
            return;
        }
        for (PurchaseInvoice invoice2 : invoices) {
            invoiceMap.put(invoice2.getId(), invoice2);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"invoice_id", invoiceIds);
        List list = this.purchaseInvoiceHookInformationService.list((Wrapper)queryWrapper);
        HashMap<String, HashSet<String>> map = new HashMap<String, HashSet<String>>();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (PurchaseInvoiceHookInformation hookInformation : list) {
            String invoiceId = hookInformation.getInvoiceId();
            HashSet<String> hookSet = (HashSet<String>)map.get(invoiceId);
            if (CollectionUtils.isEmpty((Collection)hookSet)) {
                hookSet = new HashSet<String>();
                map.put(invoiceId, hookSet);
            }
            hookSet.add(hookInformation.getCheckTheDocumentNumber());
        }
        ArrayList<PurchaseDeliveryWater> waterList = new ArrayList<PurchaseDeliveryWater>();
        for (Map.Entry entry : map.entrySet()) {
            String invoiceId = (String)entry.getKey();
            Set documentNumber = (Set)entry.getValue();
            if (CollectionUtils.isEmpty((Collection)documentNumber) || StringUtils.isEmpty((CharSequence)invoiceId)) continue;
            QueryWrapper waterQueryWrapper = new QueryWrapper();
            waterQueryWrapper.in((Object)"document_number", (Collection)documentNumber);
            List deliveryWaters = this.list((Wrapper)waterQueryWrapper);
            if (CollectionUtils.isEmpty((Collection)deliveryWaters)) continue;
            for (PurchaseDeliveryWater deliveryWater : deliveryWaters) {
                PurchaseInvoice purchaseInvoice = (PurchaseInvoice)((Object)invoiceMap.get(invoiceId));
                if (purchaseInvoice == null) continue;
                deliveryWater.setInvoiceCode(purchaseInvoice.getInvoiceCode());
                deliveryWater.setInvoiceNo(purchaseInvoice.getInvoiceNo());
                deliveryWater.setNotIncludeTaxAmount(purchaseInvoice.getNotIncludeTaxAmount());
                deliveryWater.setIncludeTaxAmount(purchaseInvoice.getIncludeTaxAmount());
                deliveryWater.setTaxAmount(purchaseInvoice.getTaxAmount());
                deliveryWater.setPayWay(reconciliationVO.getPayWay());
                deliveryWater.setPaymentClause(reconciliationVO.getPaymentClause());
                deliveryWater.setReconciliationNumber(reconciliationVO.getReconciliationNumber());
                deliveryWater.setPaymentBenchmarkDate(reconciliationVO.getPaymentBenchmarkDate());
                deliveryWater.setPaymentExpireDate(reconciliationVO.getPaymentExpiredate());
                deliveryWater.setPayCycle(reconciliationVO.getPayCycle());
                waterList.add(deliveryWater);
            }
        }
        if (!CollectionUtils.isEmpty(waterList)) {
            this.updateBatchById(waterList);
            for (PurchaseDeliveryWater purchaseDeliveryWater : waterList) {
                Set relationIds = waterList.stream().map(PurchaseDeliveryWater::getRelationId).collect(Collectors.toSet());
                QueryWrapper saleWaterQueryWrapper = new QueryWrapper();
                saleWaterQueryWrapper.in((Object)"relation_id", relationIds);
                this.saleDeliveryWaterService.remove((Wrapper)saleWaterQueryWrapper);
                SaleDeliveryWater saleDeliveryWater = new SaleDeliveryWater();
                BeanUtils.copyProperties((Object)((Object)purchaseDeliveryWater), (Object)((Object)saleDeliveryWater));
                saleDeliveryWater.setId(null);
                saleDeliveryWater.setElsAccount(purchaseDeliveryWater.getToElsAccount());
                saleDeliveryWater.setBusAccount(purchaseDeliveryWater.getElsAccount());
                saleDeliveryWater.setToElsAccount(purchaseDeliveryWater.getElsAccount());
                saleDeliveryWater.setRelationId(purchaseDeliveryWater.getId());
                this.saleDeliveryWaterMapper.insert((Object)saleDeliveryWater);
                purchaseDeliveryWater.setRelationId(saleDeliveryWater.getId());
            }
            this.updateBatchById(waterList);
        }
    }
}

