/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.ElsTaxDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ElsTaxRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.delivery.api.dto.PurchaseVoucherHeadDTO;
import com.els.modules.delivery.api.dto.PurchaseVoucherItemDTO;
import com.els.modules.delivery.api.service.PurchaseVoucherItemRpcService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.modules.finance.api.enumerate.DeductCostTypeEnum;
import com.els.modules.finance.entity.PurchaseAddCost;
import com.els.modules.finance.entity.PurchaseDeductCost;
import com.els.modules.finance.entity.PurchasePrePaymentWriteOffReconciliation;
import com.els.modules.finance.entity.SaleAddCost;
import com.els.modules.finance.entity.SaleDeductCost;
import com.els.modules.finance.mapper.PurchasePrePaymentWriteOffReconciliationMapper;
import com.els.modules.finance.service.PurchaseAddCostService;
import com.els.modules.finance.service.PurchaseDeductCostService;
import com.els.modules.finance.service.PurchasePaymentApplyItemService;
import com.els.modules.finance.service.SaleAddCostService;
import com.els.modules.finance.service.SaleDeductCostService;
import com.els.modules.finance.service.SalePaymentApplyItemService;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.PurchaseRecAcceptReturn;
import com.els.modules.reconciliation.entity.PurchaseRecAdditionalCharges;
import com.els.modules.reconciliation.entity.PurchaseRecCharge;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.entity.SaleInvoice;
import com.els.modules.reconciliation.entity.SalePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.entity.SaleRecAcceptReturn;
import com.els.modules.reconciliation.entity.SaleRecAdditionalCharges;
import com.els.modules.reconciliation.entity.SaleRecCharge;
import com.els.modules.reconciliation.entity.SaleReconciliation;
import com.els.modules.reconciliation.enumerate.InvoiceConfirmStatusEnum;
import com.els.modules.reconciliation.enumerate.InvoiceStatusEnum;
import com.els.modules.reconciliation.enumerate.OperationEnum;
import com.els.modules.reconciliation.enumerate.ReconcilationItemTypeEmun;
import com.els.modules.reconciliation.enumerate.ReconciliationStatusEmun;
import com.els.modules.reconciliation.enumerate.SaleStatusEmun;
import com.els.modules.reconciliation.mapper.PurchaseInvoiceMapper;
import com.els.modules.reconciliation.mapper.PurchaseRecAcceptReturnMapper;
import com.els.modules.reconciliation.mapper.PurchaseRecAdditionalChargesMapper;
import com.els.modules.reconciliation.mapper.PurchaseRecChargeMapper;
import com.els.modules.reconciliation.mapper.PurchaseReconciliationMapper;
import com.els.modules.reconciliation.mapper.SaleInvoiceMapper;
import com.els.modules.reconciliation.mapper.SaleReconciliationMapper;
import com.els.modules.reconciliation.rpc.PurchaseVoucherHeadLocalRpcService;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffService;
import com.els.modules.reconciliation.service.PurchaseRecAdditionalChargesService;
import com.els.modules.reconciliation.service.PurchaseRecChargeService;
import com.els.modules.reconciliation.service.SalePrePaymentWriteOffReconciliationService;
import com.els.modules.reconciliation.service.SaleRecAcceptReturnService;
import com.els.modules.reconciliation.service.SaleRecAdditionalChargesService;
import com.els.modules.reconciliation.service.SaleRecChargeService;
import com.els.modules.reconciliation.service.SaleReconciliationService;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import com.els.modules.reconciliation.vo.SaleReconciliationVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SaleReconciliationServiceImpl
extends BaseServiceImpl<SaleReconciliationMapper, SaleReconciliation>
implements SaleReconciliationService {
    private static final Logger log = LoggerFactory.getLogger(SaleReconciliationServiceImpl.class);
    @Resource
    private SaleReconciliationMapper saleReconciliationMapper;
    @Resource
    private SaleRecAcceptReturnService saleRecAcceptReturnService;
    @Resource
    private SaleRecAdditionalChargesService saleRecAdditionalChargesService;
    @Resource
    private SaleRecChargeService saleRecChargeService;
    @Resource
    private SaleInvoiceMapper saleInvoiceMapper;
    @Resource
    private PurchaseReconciliationMapper purchaseReconciliationMapper;
    @Resource
    private PurchaseInvoiceMapper purchaseInvoiceMapper;
    @Resource
    private TemplateRpcService templateHeadService;
    @Resource
    private ElsEnterpriseInfoRpcService elsEnterpriseInfoRpcService;
    @Resource
    private PurchaseVoucherItemRpcService purchaseVoucherItemRpcService;
    @Autowired
    private SaleAddCostService saleAddCostService;
    @Autowired
    private PurchaseAddCostService purchaseAddCostService;
    @Autowired
    private SaleDeductCostService saleDeductCostService;
    @Autowired
    private PurchaseDeductCostService purchaseDeductCostService;
    @Resource
    private PurchaseRecAcceptReturnMapper purchaseRecAcceptReturnMapper;
    @Resource
    private PurchaseRecAdditionalChargesMapper purchaseRecAdditionalChargesMapper;
    @Resource
    private PurchaseRecChargeMapper purchaseRecChargeMapper;
    @Resource
    private PurchasePrePaymentWriteOffReconciliationMapper purchasePrePaymentWriteOffReconciliationMapper;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private ElsTaxRpcService elsTaxRpcService;
    @Resource
    private PurchaseVoucherHeadLocalRpcService purchaseVoucherHeadLocalRpcService;
    @Resource
    private PurchaseRecAdditionalChargesService purchaseRecAdditionalChargesService;
    @Resource
    private PurchaseRecChargeService purchaseRecChargeService;
    @Autowired
    private SalePrePaymentWriteOffReconciliationService salePrePaymentWriteOffReconciliationService;
    @Autowired
    private ElsPurchaseStatisticsWriteOffService elsPurchaseStatisticsWriteOffService;
    @Autowired
    private SalePaymentApplyItemService salePaymentApplyItemService;
    @Autowired
    private PurchasePaymentApplyItemService purchasePaymentApplyItemService;
    @Autowired
    private StaticConfig staticConfig;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SaleReconciliation saleReconciliation, SaleReconciliationVO saleReconciliationPage) {
        List<SaleRecAcceptReturn> saleRecAcceptReturnList = saleReconciliationPage.getSaleRecAcceptReturnList();
        List<SaleRecAdditionalCharges> saleRecAdditionalChargesList = saleReconciliationPage.getSaleRecAdditionalChargesList();
        List<SaleRecCharge> saleRecChargeList = saleReconciliationPage.getSaleRecChargeList();
        this.buildReconciliation(saleReconciliation);
        this.saleReconciliationMapper.insert((Object)saleReconciliation);
        this.handleDocumentInfo(saleRecAcceptReturnList, saleReconciliation);
        this.insertData(saleReconciliation, saleReconciliationPage);
        this.invokeBaseRpcService.addStatusLog(saleReconciliation.getRelationId(), ReconciliationStatusEmun.NEW.getValue(), "saleReconciliation", "inster");
        if (CollectionUtils.isEmpty(saleRecAcceptReturnList)) {
            return;
        }
        ArrayList<String> taxCodeList = new ArrayList<String>();
        ArrayList<String> currenyList = new ArrayList<String>();
        this.checkData(saleRecAcceptReturnList, taxCodeList, currenyList);
        Map<Boolean, String> map = this.generateReconciliation(saleReconciliation, saleReconciliationPage, taxCodeList, currenyList);
        this.insertPrePaymentWriteOff(saleReconciliation, saleReconciliationPage.getSalePrePaymentWriteOffReconciliationList());
        if (!StringUtils.isNotBlank((CharSequence)map.get(true))) {
            throw new RuntimeException(I18nUtil.translate((String)"i18n_alert_IetbLKmW_9176556d", (String)"\u5bf9\u8d26\u5355\u751f\u6210\u5931\u8d25\uff1a") + map.get(false));
        }
    }

    private void insertPrePaymentWriteOff(SaleReconciliation saleReconciliation, List<SalePrePaymentWriteOffReconciliation> prePaymentWriteOffList) {
        if (CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            return;
        }
        int itemNumber = 1;
        for (SalePrePaymentWriteOffReconciliation prePaymentWriteOff : prePaymentWriteOffList) {
            prePaymentWriteOff.setHeadId(saleReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)prePaymentWriteOff, (BaseEntity)saleReconciliation);
            prePaymentWriteOff.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            prePaymentWriteOff.setItemNumber(String.valueOf(itemNumber));
            prePaymentWriteOff.setBusAccount(saleReconciliation.getToElsAccount());
            prePaymentWriteOff.setToElsAccount(saleReconciliation.getToElsAccount());
        }
        if (!CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            this.salePrePaymentWriteOffReconciliationService.saveBatch(prePaymentWriteOffList, 2000);
        }
    }

    private void buildReconciliation(SaleReconciliation saleReconciliation) {
        String reconciliationNumber = this.invokeBaseRpcService.getNextCode("saleReconciliation", (Object)saleReconciliation, saleReconciliation.getBusAccount());
        saleReconciliation.setReconciliationNumber(reconciliationNumber);
        saleReconciliation.setBusAccount(saleReconciliation.getToElsAccount());
        TemplateHeadDTO templateHead = this.templateHeadService.getById(saleReconciliation.getTemplateNumber());
        if (templateHead != null) {
            saleReconciliation.setTemplateName(templateHead.getTemplateName());
            saleReconciliation.setTemplateNumber(templateHead.getTemplateNumber());
            saleReconciliation.setTemplateVersion(String.valueOf(templateHead.getTemplateVersion()));
            saleReconciliation.setTemplateAccount(templateHead.getElsAccount());
        }
        saleReconciliation.setCreateAccount(TenantContext.getTenant());
        saleReconciliation.setSaleRecAffirmStatus(SaleStatusEmun.NEW.getValue());
        saleReconciliation.setSaleRecSendStatus("0");
        saleReconciliation.setInvoiced("0");
        saleReconciliation.setCancellation("0");
        ElsEnterpriseInfoDTO enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(TenantContext.getTenant());
        if (enterpriseInfo != null) {
            saleReconciliation.setSupplierName(enterpriseInfo.getName());
        }
        if ((enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(saleReconciliation.getToElsAccount())) != null) {
            saleReconciliation.setPurchaseName(enterpriseInfo.getName());
        }
        saleReconciliation.setRelationId(IdWorker.getIdStr());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> updateMain(SaleReconciliation saleReconciliation, SaleReconciliationVO saleReconciliationPage) {
        List<SaleRecAcceptReturn> saleRecAcceptReturnList = saleReconciliationPage.getSaleRecAcceptReturnList();
        List<SaleRecAdditionalCharges> saleRecAdditionalChargesList = saleReconciliationPage.getSaleRecAdditionalChargesList();
        List<SaleRecCharge> saleRecChargeList = saleReconciliationPage.getSaleRecChargeList();
        if (CollectionUtils.isEmpty(saleRecAcceptReturnList)) {
            this.cancelAcceptReturns(saleReconciliation.getId(), null);
            this.saleReconciliationMapper.updateById((Object)saleReconciliation);
            this.saleRecAcceptReturnService.deleteByMainId(saleReconciliation.getId());
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_savaSuccess", (String)"\u4fdd\u5b58\u6210\u529f"));
        }
        ArrayList<String> acceptReturnIds = new ArrayList<String>();
        BigDecimal amount = new BigDecimal(0);
        for (SaleRecAcceptReturn saleRecAcceptReturn : saleRecAcceptReturnList) {
            acceptReturnIds.add(saleRecAcceptReturn.getBusinessId());
            if (saleRecAcceptReturn.getDirectionBorrowing().equals("+")) {
                amount = amount.add(saleRecAcceptReturn.getTotalAmount());
            }
            if (!saleRecAcceptReturn.getDirectionBorrowing().equals("-")) continue;
            amount = amount.subtract(saleRecAcceptReturn.getTotalAmount());
        }
        if (amount.compareTo(new BigDecimal(0)) < 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IetsMKmWlYSRHkHfXUW_47a1224a", (String)"\u5bf9\u8d26\u5355\u4fdd\u5b58\u5931\u8d25\uff0c\u6536\u9000\u8d27\u660e\u7ec6\u603b\u91d1\u989d\u5c0f\u4e8e0"));
        }
        this.cancelAcceptReturns(saleReconciliation.getId(), acceptReturnIds);
        ArrayList<String> addCostIds = new ArrayList<String>();
        for (SaleRecAdditionalCharges additionalCharges : saleRecAdditionalChargesList) {
            addCostIds.add(additionalCharges.getBusinessId());
        }
        this.cancelAdditionalCharges(saleReconciliation.getId(), addCostIds);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SaleRecCharge charge : saleRecChargeList) {
            arrayList.add(charge.getBusinessId());
        }
        this.cancelCharges(saleReconciliation.getId(), arrayList);
        this.calculateMoney(saleReconciliation, saleReconciliationPage);
        this.checkSettlementAmount(saleReconciliation);
        this.handleDocumentInfo(saleRecAcceptReturnList, saleReconciliation);
        this.saleReconciliationMapper.updateById((Object)saleReconciliation);
        this.insertData(saleReconciliation, saleReconciliationPage);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_savaSuccess", (String)"\u4fdd\u5b58\u6210\u529f"));
    }

    private void checkSettlementAmount(SaleReconciliation saleReconciliation) {
        if ("1".equals(saleReconciliation.getSaveForZero())) {
            if (saleReconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 0) {
                throw new RuntimeException("\u5bf9\u8d26\u660e\u7ec6\u7684\u7ed3\u7b97\u91d1\u989d\u4e3a\uff1a " + saleReconciliation.getClosingAmount() + " \uff0c\u5c0f\u4e8e0\uff0c\u65e0\u6cd5\u751f\u6210\u6709\u6548\u5bf9\u8d26\u5355");
            }
        } else if (saleReconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 1) {
            throw new RuntimeException("\u5bf9\u8d26\u660e\u7ec6\u7684\u7ed3\u7b97\u91d1\u989d\u4e3a\uff1a " + saleReconciliation.getClosingAmount() + " \uff0c\u5c0f\u4e8e\u7b49\u4e8e0\u90fd\u65e0\u6cd5\u751f\u6210\u6709\u6548\u5bf9\u8d26\u5355");
        }
    }

    private void checkData(List<SaleRecAcceptReturn> saleRecAcceptReturnList, List<String> taxCodeList, List<String> currenyList) {
        for (SaleRecAcceptReturn item : saleRecAcceptReturnList) {
            if (!taxCodeList.contains(item.getTaxCode())) {
                taxCodeList.add(item.getTaxCode());
            } else if (StringUtils.isBlank((CharSequence)item.getTaxCode())) {
                throw new RuntimeException("\u5bf9\u8d26\u5355\u751f\u6210\u5931\u8d25,\u6536(\u9000)\u6216\u51ed\u8bc1" + item.getVoucherNumber() + " \u7a0e\u7801\u4e3a\u7a7a");
            }
            if (!currenyList.contains(item.getCurrency())) {
                currenyList.add(item.getCurrency());
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)item.getCurrency())) continue;
            throw new RuntimeException("\u5bf9\u8d26\u5355\u751f\u6210\u5931\u8d25,\u6536(\u9000)\u6216\u51ed\u8bc1" + item.getVoucherNumber() + " \u5e01\u522b\u4e3a\u7a7a");
        }
    }

    private void handleDocumentInfo(List<SaleRecAcceptReturn> saleRecAcceptReturnList, SaleReconciliation saleReconciliation) {
        HashSet<String> voucherItemIds = new HashSet<String>();
        if (CollectionUtils.isEmpty(saleRecAcceptReturnList)) {
            return;
        }
        for (SaleRecAcceptReturn saleRecAcceptReturn : saleRecAcceptReturnList) {
            if (StringUtils.isEmpty((CharSequence)saleRecAcceptReturn.getBusinessId())) continue;
            voucherItemIds.add(saleRecAcceptReturn.getBusinessId());
        }
        List purchaseVoucherItemDTOSList = this.purchaseVoucherItemRpcService.selectVoucherItemListByIds(new ArrayList(voucherItemIds));
        if (CollectionUtils.isEmpty((Collection)purchaseVoucherItemDTOSList)) {
            return;
        }
        Set voucherHeadIds = purchaseVoucherItemDTOSList.stream().map(PurchaseVoucherItemDTO::getHeadId).collect(Collectors.toSet());
        List<PurchaseVoucherHeadDTO> purchaseVoucherHeadDTOList = this.purchaseVoucherHeadLocalRpcService.listByIds(new ArrayList<String>(voucherHeadIds));
        if (CollectionUtils.isEmpty(purchaseVoucherHeadDTOList)) {
            return;
        }
        HashSet<String> documentIds = new HashSet<String>();
        HashSet<String> parentDocumentIds = new HashSet<String>();
        for (PurchaseVoucherHeadDTO dto : purchaseVoucherHeadDTOList) {
            String documentId = dto.getDocumentId();
            this.handleIds(documentIds, documentId);
            parentDocumentIds.add(dto.getId());
        }
        String documentIdsStr = StringUtils.join(documentIds, (String)",");
        String parentDocumentIdsStr = StringUtils.join(parentDocumentIds, (String)",");
        saleReconciliation.setDocumentId(documentIdsStr);
        saleReconciliation.setDocumentParentId(parentDocumentIdsStr);
        HashMap<String, PurchaseVoucherItemDTO> map = new HashMap<String, PurchaseVoucherItemDTO>();
        for (PurchaseVoucherItemDTO purchaseVoucherItemDTO : purchaseVoucherItemDTOSList) {
            map.put(purchaseVoucherItemDTO.getVoucherNumber(), purchaseVoucherItemDTO);
        }
        for (SaleRecAcceptReturn saleRecAcceptReturn : saleRecAcceptReturnList) {
            PurchaseVoucherItemDTO purchaseVoucherItemDTO;
            if (StringUtils.isEmpty((CharSequence)saleRecAcceptReturn.getVoucherNumber()) || (purchaseVoucherItemDTO = (PurchaseVoucherItemDTO)map.get(saleRecAcceptReturn.getVoucherNumber())) == null) continue;
            saleRecAcceptReturn.setDocumentId(purchaseVoucherItemDTO.getDocumentId());
            saleRecAcceptReturn.setDocumentParentId(purchaseVoucherItemDTO.getId());
        }
    }

    private void handleIds(Set<String> documentIds, String documentId) {
        if (StringUtils.isEmpty((CharSequence)documentId)) {
            return;
        }
        if (documentId.contains(",")) {
            List<String> documentLists = Arrays.asList(documentId.split(","));
            documentIds.addAll(documentLists);
        } else {
            documentIds.add(documentId);
        }
    }

    public Map<Boolean, String> generateReconciliation(SaleReconciliation reconciliation, SaleReconciliationVO saleReconciliationPage, List<String> taxCodeList, List<String> currenyList) {
        List<SaleRecAcceptReturn> acceptReturns = saleReconciliationPage.getSaleRecAcceptReturnList();
        List<SaleRecAdditionalCharges> additionalCharges = saleReconciliationPage.getSaleRecAdditionalChargesList();
        List<SaleRecCharge> charges = saleReconciliationPage.getSaleRecChargeList();
        HashMap<Boolean, String> result = new HashMap<Boolean, String>();
        result.put(false, "");
        result.put(true, "");
        boolean flag = false;
        for (String taxCode : taxCodeList) {
            for (String currency : currenyList) {
                List taxs;
                Object acceptReturn2;
                ArrayList<SaleRecAcceptReturn> recAcceptReturns = new ArrayList<SaleRecAcceptReturn>();
                BigDecimal amount = new BigDecimal(0);
                for (Object acceptReturn2 : acceptReturns) {
                    if (!taxCode.equals(acceptReturn2.getTaxCode()) || !currency.equals(acceptReturn2.getCurrency())) continue;
                    recAcceptReturns.add((SaleRecAcceptReturn)((Object)acceptReturn2));
                    if (acceptReturn2.getDirectionBorrowing().equals("+")) {
                        amount = amount.add(acceptReturn2.getTotalAmount());
                    }
                    if (!acceptReturn2.getDirectionBorrowing().equals("-")) continue;
                    amount = amount.subtract(acceptReturn2.getTotalAmount());
                }
                if (recAcceptReturns.isEmpty()) {
                    result.put(false, (String)result.get(false) + taxCode + "/" + currency + " :\u6536\u9000\u8d27\u660e\u7ec6\u4e3a\u7a7a\uff1b ");
                    continue;
                }
                if (amount.compareTo(new BigDecimal(0)) < 0) {
                    result.put(false, (String)result.get(false) + taxCode + "/" + currency + " :\u6536\u9000\u8d27\u660e\u7ec6\u603b\u91d1\u989d\u5c0f\u4e8e0\uff1b ");
                    continue;
                }
                ArrayList<Object> recAdditionalCharges = new ArrayList<Object>();
                acceptReturn2 = additionalCharges.iterator();
                while (acceptReturn2.hasNext()) {
                    Object purchaseRecAdditionalCharges = (SaleRecAdditionalCharges)((Object)acceptReturn2.next());
                    if (!taxCode.equals(purchaseRecAdditionalCharges.getTaxCode()) || !currency.equals(purchaseRecAdditionalCharges.getCurrency())) continue;
                    recAdditionalCharges.add(purchaseRecAdditionalCharges);
                }
                ArrayList<SaleRecCharge> recCharges = new ArrayList<SaleRecCharge>();
                for (SaleRecCharge charge : charges) {
                    if (!taxCode.equals(charge.getTaxCode()) || !currency.equals(charge.getCurrency())) continue;
                    recCharges.add(charge);
                }
                reconciliation.setTaxCode(taxCode);
                if (reconciliation.getTaxRate() == null && (taxs = this.elsTaxRpcService.findList(reconciliation.getToElsAccount(), taxCode)) != null && taxs.size() > 0) {
                    reconciliation.setTaxRate(((ElsTaxDTO)taxs.get(0)).getTaxRate());
                }
                reconciliation.setCurrency(currency);
                if (flag) {
                    SaleReconciliation saleReconciliation = new SaleReconciliation();
                    BeanUtils.copyProperties((Object)((Object)reconciliation), (Object)((Object)saleReconciliation));
                    saleReconciliation.setId(null);
                    saleReconciliation.setReconciliationNumber(this.invokeBaseRpcService.getNextCode("saleReconciliation", (Object)saleReconciliation));
                    this.calculateMoney(saleReconciliation, saleReconciliationPage);
                    if ("1".equals(saleReconciliation.getSaveForZero())) {
                        if (saleReconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 0) {
                            result.put(false, (String)result.get(false) + taxCode + "/" + currency + " :\u5355\u636e\u7ed3\u7b97\u91d1\u989d\u5c0f\u4e8e0\uff1b ");
                            continue;
                        }
                    } else if (saleReconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 1) {
                        result.put(false, (String)result.get(false) + taxCode + "/" + currency + " :\u5355\u636e\u7ed3\u7b97\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\uff1b ");
                        continue;
                    }
                    this.saleReconciliationMapper.insert((Object)saleReconciliation);
                    this.insertData(saleReconciliation, saleReconciliationPage);
                    result.put(true, (String)result.get(true) + taxCode + "/" + currency + ": " + saleReconciliation.getReconciliationNumber());
                    continue;
                }
                this.calculateMoney(reconciliation, saleReconciliationPage);
                if ("1".equals(reconciliation.getSaveForZero())) {
                    if (reconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 0) {
                        result.put(false, (String)result.get(false) + taxCode + "/" + currency + " :\u5355\u636e\u7ed3\u7b97\u91d1\u989d\u5c0f\u4e8e0\uff1b ");
                        continue;
                    }
                } else if (reconciliation.getClosingAmount().compareTo(new BigDecimal(0)) < 1) {
                    result.put(false, (String)result.get(false) + taxCode + "/" + currency + " :\u5355\u636e\u7ed3\u7b97\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\uff1b ");
                    continue;
                }
                this.saleReconciliationMapper.updateById((Object)reconciliation);
                this.insertData(reconciliation, saleReconciliationPage);
                flag = true;
                result.put(true, (String)result.get(true) + taxCode + "/" + currency + ": " + reconciliation.getReconciliationNumber());
            }
        }
        return result;
    }

    public void calculateMoney(SaleReconciliation reconciliation, SaleReconciliationVO saleReconciliationPage) {
        List<SaleRecAcceptReturn> acceptReturns = saleReconciliationPage.getSaleRecAcceptReturnList();
        List<SaleRecAdditionalCharges> additionalCharges = saleReconciliationPage.getSaleRecAdditionalChargesList();
        List<SaleRecCharge> charges = saleReconciliationPage.getSaleRecChargeList();
        List<SalePrePaymentWriteOffReconciliation> prePaymentWriteOffList = saleReconciliationPage.getSalePrePaymentWriteOffReconciliationList();
        BigDecimal deliveryIncludeTaxAmount = new BigDecimal(0);
        if (!CollectionUtil.isEmpty(acceptReturns)) {
            for (Object recAcceptReturn : acceptReturns) {
                if (recAcceptReturn.getDirectionBorrowing().equals("+")) {
                    deliveryIncludeTaxAmount = deliveryIncludeTaxAmount.add(recAcceptReturn.getTotalAmount());
                }
                if (!recAcceptReturn.getDirectionBorrowing().equals("-")) continue;
                deliveryIncludeTaxAmount = deliveryIncludeTaxAmount.subtract(recAcceptReturn.getTotalAmount());
            }
        }
        reconciliation.setDeliveryIncludeTaxAmount(deliveryIncludeTaxAmount);
        BigDecimal additionalChangesAmount = new BigDecimal(0);
        if (!CollectionUtil.isEmpty(additionalCharges)) {
            for (SaleRecAdditionalCharges recAdditionalCharges : additionalCharges) {
                additionalChangesAmount = additionalChangesAmount.add(recAdditionalCharges.getTotalAmount());
            }
        }
        reconciliation.setAdditionalChangesAmount(additionalChangesAmount);
        BigDecimal chargeTotalAmount = new BigDecimal(0);
        BigDecimal chargeAmount = new BigDecimal(0);
        BigDecimal buckleTicketsAmount = new BigDecimal(0);
        if (!CollectionUtil.isEmpty(charges)) {
            for (SaleRecCharge recCharge : charges) {
                chargeTotalAmount = chargeTotalAmount.add(recCharge.getTotalAmount());
                if (DeductCostTypeEnum.ACCOUNT_DEDUCTION.getValue().equals(recCharge.getDeductionType())) {
                    chargeAmount = chargeAmount.add(recCharge.getTotalAmount());
                }
                if (!DeductCostTypeEnum.TICKET_DEDUCTION.getValue().equals(recCharge.getDeductionType())) continue;
                buckleTicketsAmount = buckleTicketsAmount.add(recCharge.getTotalAmount());
            }
        }
        reconciliation.setChargeTotalAmount(chargeTotalAmount);
        reconciliation.setChargeAmount(chargeAmount);
        reconciliation.setBuckleTicketsAmount(buckleTicketsAmount);
        BigDecimal shouldInvoiceAmount = deliveryIncludeTaxAmount.add(additionalChangesAmount).subtract(buckleTicketsAmount);
        reconciliation.setShouldInvoiceAmount(shouldInvoiceAmount);
        BigDecimal closingAmount = shouldInvoiceAmount.subtract(chargeAmount);
        reconciliation.setClosingAmount(closingAmount);
        BigDecimal writtenOffAmount = BigDecimal.ZERO;
        if (!CollectionUtil.isEmpty(prePaymentWriteOffList)) {
            writtenOffAmount = prePaymentWriteOffList.parallelStream().filter(item -> item.getThisWriteOffAmount() != null).map(SalePrePaymentWriteOffReconciliation::getThisWriteOffAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            reconciliation.setWrittenOffAmount(writtenOffAmount);
        }
        BigDecimal settlementAmount = closingAmount.subtract(writtenOffAmount);
        reconciliation.setSettlementAmount(settlementAmount);
        reconciliation.setRemainingUnPaidAmount(settlementAmount);
    }

    private void insertData(SaleReconciliation saleReconciliation, SaleReconciliationVO saleReconciliationPage) {
        this.deleteDetail(saleReconciliation.getId());
        this.insertAcceptReturns(saleReconciliation, saleReconciliationPage.getSaleRecAcceptReturnList());
        this.insertAddCost(saleReconciliation, saleReconciliationPage.getSaleRecAdditionalChargesList());
        this.insertDeductCost(saleReconciliation, saleReconciliationPage.getSaleRecChargeList());
        this.insertPrePaymentWriteOff(saleReconciliation, saleReconciliationPage.getSalePrePaymentWriteOffReconciliationList());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.cancelAcceptReturns(id, null);
        this.cancelAdditionalCharges(id, null);
        this.cancelCharges(id, null);
        this.deleteDetail(id);
        this.saleReconciliationMapper.deleteById((Serializable)((Object)id));
    }

    private void cancelCharges(String id, List<String> existIds) {
        List<SaleRecCharge> charges = this.saleRecChargeService.selectByMainId(id);
        if (CollectionUtils.isEmpty(charges)) {
            return;
        }
        ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
        ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
        for (SaleRecCharge charge : charges) {
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(charge.getBusinessId())) continue;
            SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)charge.getBusinessId())));
            saleDeductCost.setDeductStatus("0");
            saleDeductCost.setReconciliationNumber(null);
            saleDeductCosts.add(saleDeductCost);
            PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)saleDeductCost.getRelationId())));
            deductCost.setDeductStatus("0");
            deductCost.setReconciliationNumber(null);
            deductCosts.add(deductCost);
        }
        if (!deductCosts.isEmpty()) {
            this.purchaseDeductCostService.updateBatchById(deductCosts);
        }
        if (!saleDeductCosts.isEmpty()) {
            this.saleDeductCostService.updateBatchById(saleDeductCosts);
        }
    }

    private void cancelAdditionalCharges(String id, List<String> existIds) {
        List<SaleRecAdditionalCharges> additionalCharges = this.saleRecAdditionalChargesService.selectByMainId(id);
        if (CollectionUtils.isEmpty(additionalCharges)) {
            return;
        }
        ArrayList<PurchaseAddCost> addCosts = new ArrayList<PurchaseAddCost>();
        ArrayList<SaleAddCost> saleAddCosts = new ArrayList<SaleAddCost>();
        for (SaleRecAdditionalCharges recAdditionalCharges : additionalCharges) {
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(recAdditionalCharges.getBusinessId())) continue;
            SaleAddCost saleAddCost = (SaleAddCost)((Object)this.saleAddCostService.getById((Serializable)((Object)recAdditionalCharges.getBusinessId())));
            saleAddCost.setReconciliationNumber(null);
            saleAddCost.setCostStatus("0");
            saleAddCosts.add(saleAddCost);
            PurchaseAddCost addCost = (PurchaseAddCost)((Object)this.purchaseAddCostService.getById((Serializable)((Object)saleAddCost.getRelationId())));
            addCost.setCostStatus("0");
            addCost.setReconciliationNumber(null);
            addCosts.add(addCost);
        }
        if (!addCosts.isEmpty()) {
            this.purchaseAddCostService.updateBatchById(addCosts);
        }
        if (!saleAddCosts.isEmpty()) {
            this.saleAddCostService.updateBatchById(saleAddCosts);
        }
    }

    private void cancelAcceptReturns(String id, List<String> existIds) {
        List<SaleRecAcceptReturn> acceptReturns = this.saleRecAcceptReturnService.selectByMainId(id);
        if (CollectionUtils.isEmpty(acceptReturns)) {
            return;
        }
        ArrayList<PurchaseVoucherItemDTO> voucherItems = new ArrayList<PurchaseVoucherItemDTO>();
        for (SaleRecAcceptReturn acceptReturn : acceptReturns) {
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(acceptReturn.getBusinessId())) continue;
            PurchaseVoucherItemDTO voucherItem = this.purchaseVoucherItemRpcService.getById(acceptReturn.getBusinessId());
            voucherItem.setReconciliation("0");
            voucherItem.setReconciliationNumber(null);
            voucherItems.add(voucherItem);
        }
        if (!voucherItems.isEmpty()) {
            this.purchaseVoucherItemRpcService.updatePurchaseVoucherItemListById(voucherItems);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (String id : idList) {
            this.deleteDetail(id);
            this.saleReconciliationMapper.deleteById((Serializable)((Object)id));
        }
    }

    private void deleteDetail(String id) {
        this.saleRecAcceptReturnService.deleteByMainId(id);
        this.saleRecAdditionalChargesService.deleteByMainId(id);
        this.saleRecChargeService.deleteByMainId(id);
        this.salePrePaymentWriteOffReconciliationService.deleteByMainId(id);
        this.saleInvoiceMapper.deleteByMainId(id);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirmOrRefused(SaleReconciliation saleReconciliation, String operation) {
        String opt = null;
        if ("confirm".equals(operation)) {
            saleReconciliation.setReconciliationStatus(ReconciliationStatusEmun.COMFIRMED.getValue());
            opt = "confirm";
        } else if ("refused".equals(operation)) {
            saleReconciliation.setReconciliationStatus(ReconciliationStatusEmun.REFUSED.getValue());
            opt = "refund";
            this.elsPurchaseStatisticsWriteOffService.cancelReleaseAmountBySale(saleReconciliation.getRelationId(), saleReconciliation.getToElsAccount(), saleReconciliation.getElsAccount());
        }
        this.updateById((Object)saleReconciliation);
        this.invokeBaseRpcService.addStatusLog(saleReconciliation.getRelationId(), saleReconciliation.getReconciliationStatus(), "reconciliation", opt);
        PurchaseReconciliation purchaseReconciliation = (PurchaseReconciliation)((Object)this.purchaseReconciliationMapper.selectById((Serializable)((Object)saleReconciliation.getRelationId())));
        if (purchaseReconciliation != null) {
            purchaseReconciliation.setReconciliationStatus(saleReconciliation.getReconciliationStatus());
            purchaseReconciliation.setSaleRemark(saleReconciliation.getSaleRemark());
            purchaseReconciliation.setRelationId(saleReconciliation.getId());
            this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
        }
        if (OperationEnum.CONFIRM.getValue().equals(operation)) {
            this.handleDocument(purchaseReconciliation);
        }
        this.handleMessage(saleReconciliation, opt, purchaseReconciliation);
    }

    private void handleMessage(SaleReconciliation saleReconciliation, String opt, PurchaseReconciliation purchaseReconciliation) {
        String serviceAddress = (String)this.staticConfig.getConfig().get("service.address");
        saleReconciliation.setFbk18(serviceAddress + "/srm/reconciliation/sale/SaleReconciliation?id=" + saleReconciliation.getId() + "&open=true&toInvoice=true");
        if (!StringUtils.isEmpty((CharSequence)opt) && purchaseReconciliation != null) {
            String url = "id=" + purchaseReconciliation.getId() + "&createAccount=" + purchaseReconciliation.getCreateAccount();
            if (StringUtils.isNotBlank((CharSequence)saleReconciliation.getPurchasePrincipal())) {
                super.sendMsg(saleReconciliation.getBusAccount(), saleReconciliation.getToElsAccount(), saleReconciliation.getPurchasePrincipal(), (Object)saleReconciliation, url, "reconciliation", opt);
                super.sendMsg(saleReconciliation.getBusAccount(), saleReconciliation.getElsAccount(), saleReconciliation.getPurchasePrincipal(), (Object)saleReconciliation, url, "saleReconciliation", opt);
            } else {
                super.sendMsg(saleReconciliation.getBusAccount(), saleReconciliation.getToElsAccount(), (Object)saleReconciliation, url, "reconciliation", opt);
                super.sendMsg(saleReconciliation.getBusAccount(), saleReconciliation.getElsAccount(), (Object)saleReconciliation, url, "saleReconciliation", opt);
            }
        }
    }

    private void handleDocument(PurchaseReconciliation purchaseReconciliation) {
        String headId = purchaseReconciliation.getRelationId();
        Set<String> voucherItemIds = this.listVourcherItemIdsFromSaleRecAcceptReturn(headId);
        List purchaseVoucherItemDTOSList = this.purchaseVoucherItemRpcService.selectVoucherItemListByIds(new ArrayList<String>(voucherItemIds));
        if (!CollectionUtils.isEmpty((Collection)purchaseVoucherItemDTOSList)) {
            Set<String> voucherHeadIds = purchaseVoucherItemDTOSList.stream().map(PurchaseVoucherItemDTO::getHeadId).collect(Collectors.toSet());
            this.handlePurchaseReconciliationDocumentInfo(purchaseReconciliation, voucherHeadIds);
        }
        this.handlePurchaseRecAdditionalChargesListDocumentInfo(purchaseReconciliation);
        this.handlePurchaseRecChargeListDocumentInfo(purchaseReconciliation);
    }

    private void handlePurchaseReconciliationDocumentInfo(PurchaseReconciliation purchaseReconciliation, Set<String> voucherHeadIds) {
        List<PurchaseVoucherHeadDTO> purchaseVoucherHeadDTOList = this.purchaseVoucherHeadLocalRpcService.listByIds(new ArrayList<String>(voucherHeadIds));
        if (CollectionUtils.isEmpty(purchaseVoucherHeadDTOList)) {
            return;
        }
        for (PurchaseVoucherHeadDTO dto : purchaseVoucherHeadDTOList) {
            String documentIdz = dto.getDocumentId();
            if (StringUtils.isEmpty((CharSequence)documentIdz)) continue;
            if (documentIdz.contains(",")) {
                List<String> documentIds = Arrays.asList(documentIdz.split(","));
                for (String documentId : documentIds) {
                    this.invokeBaseRpcService.updateIntegratedDocumentMain("reconciliationId", documentId, dto.getId(), purchaseReconciliation.getId());
                }
                continue;
            }
            this.invokeBaseRpcService.updateIntegratedDocumentMain("reconciliationId", documentIdz, dto.getId(), purchaseReconciliation.getId());
        }
    }

    private Set<String> listVourcherItemIdsFromSaleRecAcceptReturn(String headId) {
        HashSet<String> voucherItemIds = new HashSet<String>();
        List<SaleRecAcceptReturn> saleRecAcceptReturnList = this.saleRecAcceptReturnService.selectByMainId(headId);
        if (CollectionUtils.isEmpty(saleRecAcceptReturnList)) {
            return voucherItemIds;
        }
        for (SaleRecAcceptReturn saleRecAcceptReturn : saleRecAcceptReturnList) {
            if (StringUtils.isEmpty((CharSequence)saleRecAcceptReturn.getBusinessId())) continue;
            voucherItemIds.add(saleRecAcceptReturn.getBusinessId());
        }
        return voucherItemIds;
    }

    private void handlePurchaseRecAdditionalChargesListDocumentInfo(PurchaseReconciliation purchaseReconciliation) {
        List<PurchaseRecAdditionalCharges> purchaseRecAdditionalChargesList = this.purchaseRecAdditionalChargesService.selectByMainId(purchaseReconciliation.getId());
        if (CollectionUtils.isEmpty(purchaseRecAdditionalChargesList)) {
            return;
        }
        for (PurchaseRecAdditionalCharges purchaseRecAdditionalCharges : purchaseRecAdditionalChargesList) {
            if (StringUtils.isEmpty((CharSequence)purchaseRecAdditionalCharges.getDocumentId())) continue;
            this.invokeBaseRpcService.updateIntegratedDocumentMain("reconciliationId", purchaseRecAdditionalCharges.getDocumentId(), purchaseRecAdditionalCharges.getBusinessId(), purchaseReconciliation.getId());
        }
    }

    private void handlePurchaseRecChargeListDocumentInfo(PurchaseReconciliation purchaseReconciliation) {
        List<PurchaseRecCharge> purchaseRecChargeList = this.purchaseRecChargeService.selectByMainId(purchaseReconciliation.getId());
        if (CollectionUtils.isEmpty(purchaseRecChargeList)) {
            return;
        }
        for (PurchaseRecCharge purchaseRecCharge : purchaseRecChargeList) {
            if (StringUtils.isEmpty((CharSequence)purchaseRecCharge.getDocumentId())) continue;
            this.invokeBaseRpcService.updateIntegratedDocumentMain("reconciliationId", purchaseRecCharge.getDocumentId(), purchaseRecCharge.getBusinessId(), purchaseReconciliation.getId());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveInvoice(SaleReconciliation saleReconciliation, List<SaleInvoice> saleInvoiceList, String operation) {
        this.saleInvoiceMapper.deleteByMainId(saleReconciliation.getId());
        BigDecimal invoiceTotalAmount = new BigDecimal(0);
        BigDecimal notIncludeTaxAmount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        for (SaleInvoice saleInvoice : saleInvoiceList) {
            saleInvoice.setId(null);
            if (StringUtils.isBlank((CharSequence)saleInvoice.getInvoiceNumber())) {
                saleInvoice.setInvoiceNumber(this.invokeBaseRpcService.getNextCode("invoiceNumber", (Object)saleInvoice, saleReconciliation.getToElsAccount()));
            }
            if ("save".equals(operation)) {
                if (!InvoiceStatusEnum.RENTURNED.getValue().equals(saleInvoice.getStatus())) {
                    saleInvoice.setStatus(InvoiceStatusEnum.NEW.getValue());
                }
            } else if ("send".equals(operation)) {
                saleInvoice.setStatus(InvoiceStatusEnum.UNCONFIRMED.getValue());
            }
            if (saleInvoice.getNotIncludeTaxAmount() == null) {
                BigDecimal tax = new BigDecimal(saleInvoice.getTaxRate()).divide(new BigDecimal(100)).add(BigDecimal.ONE);
                saleInvoice.setNotIncludeTaxAmount(saleInvoice.getIncludeTaxAmount().divide(tax, 5));
            }
            if (saleInvoice.getTaxAmount() == null) {
                saleInvoice.setTaxAmount(saleInvoice.getIncludeTaxAmount().subtract(saleInvoice.getNotIncludeTaxAmount()));
            }
            saleInvoice.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            saleInvoice.setBusAccount(saleReconciliation.getToElsAccount());
            saleInvoice.setToElsAccount(saleReconciliation.getToElsAccount());
            saleInvoice.setHeadId(saleReconciliation.getId());
            String documentId = saleReconciliation.getDocumentId();
            if (!StringUtils.isEmpty((CharSequence)documentId)) {
                saleInvoice.setDocumentId(documentId);
            }
            saleInvoice.setDocumentParentId(saleReconciliation.getRelationId());
            SysUtil.setSysParam((BaseEntity)saleInvoice, (BaseEntity)saleReconciliation);
            invoiceTotalAmount = invoiceTotalAmount.add(saleInvoice.getIncludeTaxAmount());
            notIncludeTaxAmount = notIncludeTaxAmount.add(saleInvoice.getNotIncludeTaxAmount());
            taxAmount = taxAmount.add(saleInvoice.getTaxAmount());
        }
        saleReconciliation.setTotalInvoiceAmount(invoiceTotalAmount);
        saleReconciliation.setNotIncludeTaxAmount(notIncludeTaxAmount);
        saleReconciliation.setTaxAmount(taxAmount);
        this.saleReconciliationMapper.updateById((Object)saleReconciliation);
        if (!saleInvoiceList.isEmpty()) {
            this.saleInvoiceMapper.insertBatchSomeColumn(saleInvoiceList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void sendInvoice(SaleReconciliation saleReconciliation, List<SaleInvoice> saleInvoiceList) {
        saleReconciliation.setInvoiced("1");
        saleReconciliation.setPurchaseInvoiceAffirmStatus(InvoiceConfirmStatusEnum.UNCONFIRMED.getValue());
        this.saveInvoice(saleReconciliation, saleInvoiceList, "send");
        PurchaseReconciliation purchaseReconciliation = (PurchaseReconciliation)((Object)this.purchaseReconciliationMapper.selectById((Serializable)((Object)saleReconciliation.getRelationId())));
        if (purchaseReconciliation != null) {
            purchaseReconciliation.setInvoiced("1");
            purchaseReconciliation.setRelationId(saleReconciliation.getId());
            purchaseReconciliation.setPurchaseInvoiceAffirmStatus(InvoiceConfirmStatusEnum.UNCONFIRMED.getValue());
            purchaseReconciliation.setTotalInvoiceAmount(saleReconciliation.getTotalInvoiceAmount());
            purchaseReconciliation.setSaleRemark(saleReconciliation.getSaleRemark());
            this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
            this.purchaseInvoiceMapper.deleteByMainId(purchaseReconciliation.getId());
            ArrayList<PurchaseInvoice> purchaseInvoices = new ArrayList<PurchaseInvoice>();
            for (SaleInvoice saleInvoice : saleInvoiceList) {
                PurchaseInvoice purchaseInvoice = new PurchaseInvoice();
                BeanUtils.copyProperties((Object)((Object)saleInvoice), (Object)((Object)purchaseInvoice));
                purchaseInvoice.setRelationId(saleInvoice.getId());
                purchaseInvoice.setElsAccount(purchaseReconciliation.getElsAccount());
                purchaseInvoice.setToElsAccount(purchaseReconciliation.getToElsAccount());
                purchaseInvoice.setHeadId(purchaseReconciliation.getId());
                purchaseInvoice.setId(null);
                purchaseInvoices.add(purchaseInvoice);
            }
            this.sendMessage(saleReconciliation, purchaseReconciliation, "invoice");
            this.purchaseInvoiceMapper.insertBatchSomeColumn(purchaseInvoices);
        }
    }

    private void sendMessage(SaleReconciliation saleReconciliation, PurchaseReconciliation purchaseReconciliation, String invoice) {
        String url = "id=" + purchaseReconciliation.getId() + "&createAccount=" + purchaseReconciliation.getCreateAccount();
        if (StringUtils.isNotBlank((CharSequence)saleReconciliation.getPurchasePrincipal())) {
            super.sendMsg(saleReconciliation.getBusAccount(), saleReconciliation.getToElsAccount(), saleReconciliation.getPurchasePrincipal(), (Object)saleReconciliation, url, invoice, "publish");
        } else {
            super.sendMsg(saleReconciliation.getBusAccount(), saleReconciliation.getToElsAccount(), (Object)saleReconciliation, url, invoice, "publish");
        }
    }

    @Override
    public SaleReconciliationVO extractReconciliation(SaleReconciliationVO reconciliationVO) {
        PurchaseVoucherItemDTO purchaseVoucherItemDTO = this.buildPurchaseVoucherItem(reconciliationVO);
        List voucherItems = this.purchaseVoucherItemRpcService.selectReconciliationVoucher(purchaseVoucherItemDTO);
        if (!CollectionUtils.isEmpty((Collection)voucherItems)) {
            List<SaleRecAcceptReturn> acceptReturns = this.getBySaleVoucherItem(voucherItems);
            reconciliationVO.setSaleRecAcceptReturnList(acceptReturns);
        } else {
            reconciliationVO.setSaleRecAcceptReturnList(null);
        }
        ReconciliationVO vo = new ReconciliationVO();
        BeanUtils.copyProperties((Object)((Object)reconciliationVO), (Object)vo);
        List<SaleRecCharge> charges = this.saleDeductCostService.getBySaleDeductCost(vo);
        reconciliationVO.setSaleRecChargeList(charges);
        List<SaleRecAdditionalCharges> additionalCharges = this.saleAddCostService.getBySaleAddCost(reconciliationVO);
        reconciliationVO.setSaleRecAdditionalChargesList(additionalCharges);
        List<SalePrePaymentWriteOffReconciliation> prePaymentWriteOff = this.salePaymentApplyItemService.getSalePrePaymentWriteOffReconciliations(vo);
        reconciliationVO.setSalePrePaymentWriteOffReconciliationList(prePaymentWriteOff);
        return reconciliationVO;
    }

    private PurchaseVoucherItemDTO buildPurchaseVoucherItem(SaleReconciliationVO reconciliationVO) {
        PurchaseVoucherItemDTO purchaseVoucherItemDTO = new PurchaseVoucherItemDTO();
        purchaseVoucherItemDTO.setElsAccount(reconciliationVO.getToElsAccount());
        purchaseVoucherItemDTO.setToElsAccount(reconciliationVO.getElsAccount());
        purchaseVoucherItemDTO.setCompany(reconciliationVO.getCompany());
        purchaseVoucherItemDTO.setBeginDate(reconciliationVO.getBeginDate());
        purchaseVoucherItemDTO.setEndDate(reconciliationVO.getEndDate());
        purchaseVoucherItemDTO.setVoucherStatus("0");
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getTaxCode())) {
            purchaseVoucherItemDTO.setTaxCode(reconciliationVO.getTaxCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getCurrency())) {
            purchaseVoucherItemDTO.setCurrency(reconciliationVO.getCurrency());
        }
        return purchaseVoucherItemDTO;
    }

    public List<SaleRecAcceptReturn> getBySaleVoucherItem(List<PurchaseVoucherItemDTO> voucherItems) {
        ArrayList<SaleRecAcceptReturn> acceptReturns = new ArrayList<SaleRecAcceptReturn>();
        for (PurchaseVoucherItemDTO purchaseVoucherItem : voucherItems) {
            SaleRecAcceptReturn acceptReturn = new SaleRecAcceptReturn();
            BeanUtils.copyProperties((Object)purchaseVoucherItem, (Object)((Object)acceptReturn));
            acceptReturn.setItemType(ReconcilationItemTypeEmun.RECEIVING_REFUND.getValue());
            acceptReturn.setVoucherItemNumber(purchaseVoucherItem.getItemNumber());
            acceptReturn.setVoucherTime(purchaseVoucherItem.getVoucherDate());
            acceptReturn.setMobileType(purchaseVoucherItem.getMoveType());
            acceptReturn.setDirectionBorrowing(purchaseVoucherItem.getLoanDirection());
            acceptReturn.setPurchaseFactory(purchaseVoucherItem.getFactory());
            acceptReturn.setInventoryAddress(purchaseVoucherItem.getStorageLocation());
            acceptReturn.setInventoryAddressDesc(purchaseVoucherItem.getStorageLocationName());
            acceptReturn.setUnitQuantity(purchaseVoucherItem.getQuantityUnit());
            acceptReturn.setPrice(purchaseVoucherItem.getPrice());
            acceptReturn.setNoTaxUnitPrice(purchaseVoucherItem.getNetPrice());
            acceptReturn.setTaxRate(StringUtils.isNotBlank((CharSequence)purchaseVoucherItem.getTaxRate()) ? Integer.valueOf(Integer.parseInt(purchaseVoucherItem.getTaxRate())) : null);
            if (purchaseVoucherItem.getPrice() != null && purchaseVoucherItem.getVoucherQuantity() != null) {
                acceptReturn.setTotalAmount(purchaseVoucherItem.getPrice().multiply(purchaseVoucherItem.getVoucherQuantity()));
            }
            if (purchaseVoucherItem.getNetPrice() != null && purchaseVoucherItem.getVoucherQuantity() != null) {
                acceptReturn.setTotalNonTaxAmount(purchaseVoucherItem.getNetPrice().multiply(purchaseVoucherItem.getVoucherQuantity()));
            }
            acceptReturn.setBusinessId(purchaseVoucherItem.getId());
            acceptReturn.setId(null);
            acceptReturns.add(acceptReturn);
        }
        return acceptReturns;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> publish(SaleReconciliation saleReconciliation, SaleReconciliationVO saleReconciliationVO) {
        boolean flag = false;
        if (SaleStatusEmun.REFUSED.getValue().equals(saleReconciliation.getSaleRecAffirmStatus()) && StringUtils.isNotBlank((CharSequence)saleReconciliation.getRelationId())) {
            flag = true;
        }
        saleReconciliation.setSaleRecAffirmStatus(SaleStatusEmun.UNCONFIRMED.getValue());
        saleReconciliation.setSaleRecSendStatus("1");
        this.updateMain(saleReconciliation, saleReconciliationVO);
        this.invokeBaseRpcService.addStatusLog(saleReconciliation.getRelationId(), saleReconciliation.getReconciliationStatus(), "saleReconciliation", "publish");
        String id = saleReconciliation.getRelationId();
        PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
        BeanUtils.copyProperties((Object)((Object)saleReconciliation), (Object)((Object)purchaseReconciliation));
        purchaseReconciliation.setElsAccount(saleReconciliation.getToElsAccount());
        purchaseReconciliation.setToElsAccount(saleReconciliation.getElsAccount());
        purchaseReconciliation.setRelationId(saleReconciliation.getId());
        if (flag) {
            purchaseReconciliation.setId(id);
            purchaseReconciliation.setReconciliationStatus(purchaseReconciliation.getReconciliationStatus());
            this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
            this.handleDetail(purchaseReconciliation, saleReconciliationVO);
        } else {
            purchaseReconciliation.setId(id);
            this.purchaseReconciliationMapper.insert((Object)purchaseReconciliation);
            this.handleDetail(purchaseReconciliation, saleReconciliationVO);
            saleReconciliation.setRelationId(purchaseReconciliation.getId());
        }
        this.sendMessage(saleReconciliation, purchaseReconciliation, "saleReconciliation");
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_hxLRW_c95760c0", (String)"\u53d1\u5e03\u6210\u529f\uff01"));
    }

    @Override
    public void emailConfirmOrRefuesd(String id, String operation) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BaseEntity::getId, (Object)id);
        SaleReconciliation saleReconciliation = (SaleReconciliation)((Object)this.getOne((Wrapper)lambdaQueryWrapper));
        if (saleReconciliation != null) {
            this.confirmOrRefused(saleReconciliation, operation);
        }
    }

    private MsgParamsVO parameterAssemble(SaleReconciliation reconciliation) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(reconciliation.getToElsAccount(), reconciliation.getPurchasePrincipal().split("_")[0]);
        accountList.add(subAccount);
        receiverMap.put(reconciliation.getToElsAccount(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        Map paramMap = (Map)JSON.parse((String)JSONObject.toJSON((Object)((Object)reconciliation)).toString());
        paramMap.put("userName", subAccount.getRealname());
        msgParamsVO.setParams((Object)paramMap);
        return msgParamsVO;
    }

    private void handleDetail(PurchaseReconciliation purchaseReconciliation, SaleReconciliationVO saleReconciliationVO) {
        List<SaleRecAcceptReturn> saleRecAcceptReturnList = saleReconciliationVO.getSaleRecAcceptReturnList();
        List<SaleRecAdditionalCharges> saleRecAdditionalChargesList = saleReconciliationVO.getSaleRecAdditionalChargesList();
        List<SaleRecCharge> saleRecChargeList = saleReconciliationVO.getSaleRecChargeList();
        List<SaleAttachmentDTO> attachments = saleReconciliationVO.getAttachments();
        List<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffList = saleReconciliationVO.getSalePrePaymentWriteOffReconciliationList();
        this.purchaseRecAcceptReturnMapper.deleteByMainId(purchaseReconciliation.getId());
        this.purchaseRecChargeMapper.deleteByMainId(purchaseReconciliation.getId());
        this.purchaseRecAdditionalChargesMapper.deleteByMainId(purchaseReconciliation.getId());
        this.purchasePrePaymentWriteOffReconciliationMapper.deleteByMainId(purchaseReconciliation.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseReconciliation.getId());
        this.handlePurchaseRecAcceptReturnDetail(purchaseReconciliation, saleRecAcceptReturnList);
        this.handlePurchaseRecChargeDetail(purchaseReconciliation, saleRecChargeList);
        this.handlePurchaseRecAdditionalChargeDetail(purchaseReconciliation, saleRecAdditionalChargesList);
        this.handlePurchaseRecPrePaymentWriteOffDetail(purchaseReconciliation, salePrePaymentWriteOffList);
        this.handlePurchaseAttachmentDetail(purchaseReconciliation, attachments);
    }

    private void handlePurchaseAttachmentDetail(PurchaseReconciliation purchaseReconciliation, List<SaleAttachmentDTO> attachments) {
        if (CollectionUtils.isEmpty(attachments)) {
            return;
        }
        ArrayList<PurchaseAttachmentDTO> purchaseAttachments = new ArrayList<PurchaseAttachmentDTO>();
        for (SaleAttachmentDTO saleAttachment : attachments) {
            saleAttachment.setSendStatus("1");
            PurchaseAttachmentDTO purchaseAttachment = new PurchaseAttachmentDTO();
            BeanUtils.copyProperties((Object)saleAttachment, (Object)purchaseAttachment);
            purchaseAttachment.setId(null);
            purchaseAttachment.setElsAccount(purchaseReconciliation.getElsAccount());
            purchaseAttachment.setHeadId(purchaseReconciliation.getId());
            purchaseAttachment.setRelationId(saleAttachment.getId());
            purchaseAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
            purchaseAttachments.add(purchaseAttachment);
        }
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachments);
    }

    private void handlePurchaseRecAdditionalChargeDetail(PurchaseReconciliation purchaseReconciliation, List<SaleRecAdditionalCharges> saleRecAdditionalChargesList) {
        if (CollectionUtils.isEmpty(saleRecAdditionalChargesList)) {
            return;
        }
        ArrayList<PurchaseRecAdditionalCharges> purchaseRecAdditionalCharges = new ArrayList<PurchaseRecAdditionalCharges>();
        for (SaleRecAdditionalCharges saleRecAdditionalCharges : saleRecAdditionalChargesList) {
            PurchaseRecAdditionalCharges purchaseRecAdditionalCharge = new PurchaseRecAdditionalCharges();
            BeanUtils.copyProperties((Object)((Object)saleRecAdditionalCharges), (Object)((Object)purchaseRecAdditionalCharge));
            purchaseRecAdditionalCharge.setId(null);
            purchaseRecAdditionalCharge.setElsAccount(purchaseReconciliation.getElsAccount());
            purchaseRecAdditionalCharge.setToElsAccount(purchaseReconciliation.getToElsAccount());
            purchaseRecAdditionalCharge.setHeadId(purchaseReconciliation.getId());
            purchaseRecAdditionalCharge.setRelationId(saleRecAdditionalCharges.getId());
            purchaseRecAdditionalCharges.add(purchaseRecAdditionalCharge);
        }
        this.purchaseRecAdditionalChargesMapper.insertBatchSomeColumn(purchaseRecAdditionalCharges);
    }

    private void handlePurchaseRecChargeDetail(PurchaseReconciliation purchaseReconciliation, List<SaleRecCharge> saleRecChargeList) {
        if (CollectionUtils.isEmpty(saleRecChargeList)) {
            return;
        }
        ArrayList<PurchaseRecCharge> purchaseRecCharges = new ArrayList<PurchaseRecCharge>();
        for (SaleRecCharge saleRecCharge : saleRecChargeList) {
            PurchaseRecCharge purchaseRecCharge = new PurchaseRecCharge();
            BeanUtils.copyProperties((Object)((Object)saleRecCharge), (Object)((Object)purchaseRecCharge));
            purchaseRecCharge.setId(null);
            purchaseRecCharge.setElsAccount(purchaseReconciliation.getElsAccount());
            purchaseRecCharge.setToElsAccount(purchaseReconciliation.getToElsAccount());
            purchaseRecCharge.setHeadId(purchaseReconciliation.getId());
            purchaseRecCharge.setRelationId(saleRecCharge.getId());
            purchaseRecCharges.add(purchaseRecCharge);
        }
        this.purchaseRecChargeMapper.insertBatchSomeColumn(purchaseRecCharges);
    }

    private void handlePurchaseRecPrePaymentWriteOffDetail(PurchaseReconciliation purchaseReconciliation, List<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffList) {
        if (CollectionUtils.isEmpty(salePrePaymentWriteOffList)) {
            return;
        }
        ArrayList<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList = new ArrayList<PurchasePrePaymentWriteOffReconciliation>();
        for (SalePrePaymentWriteOffReconciliation prePaymentWriteOff : salePrePaymentWriteOffList) {
            PurchasePrePaymentWriteOffReconciliation prePaymentWriteOffReconciliation = new PurchasePrePaymentWriteOffReconciliation();
            BeanUtils.copyProperties((Object)((Object)prePaymentWriteOff), (Object)((Object)prePaymentWriteOffReconciliation));
            prePaymentWriteOffReconciliation.setId(null);
            prePaymentWriteOffReconciliation.setElsAccount(purchaseReconciliation.getElsAccount());
            prePaymentWriteOffReconciliation.setToElsAccount(purchaseReconciliation.getToElsAccount());
            prePaymentWriteOffReconciliation.setHeadId(purchaseReconciliation.getId());
            prePaymentWriteOffReconciliation.setRelationId(prePaymentWriteOff.getId());
            purchasePrePaymentWriteOffList.add(prePaymentWriteOffReconciliation);
        }
        this.purchasePrePaymentWriteOffReconciliationMapper.insertBatchSomeColumn(purchasePrePaymentWriteOffList);
    }

    private void handlePurchaseRecAcceptReturnDetail(PurchaseReconciliation purchaseReconciliation, List<SaleRecAcceptReturn> saleRecAcceptReturnList) {
        if (CollectionUtils.isEmpty(saleRecAcceptReturnList)) {
            return;
        }
        ArrayList<PurchaseRecAcceptReturn> purcahseRecAcceptReturns = new ArrayList<PurchaseRecAcceptReturn>();
        for (SaleRecAcceptReturn saleRecAcceptReturn : saleRecAcceptReturnList) {
            PurchaseRecAcceptReturn purchaseRecAcceptReturn = new PurchaseRecAcceptReturn();
            BeanUtils.copyProperties((Object)((Object)saleRecAcceptReturn), (Object)((Object)purchaseRecAcceptReturn));
            purchaseRecAcceptReturn.setId(null);
            purchaseRecAcceptReturn.setElsAccount(purchaseReconciliation.getElsAccount());
            purchaseRecAcceptReturn.setToElsAccount(purchaseReconciliation.getToElsAccount());
            purchaseRecAcceptReturn.setHeadId(purchaseReconciliation.getId());
            purchaseRecAcceptReturn.setRelationId(saleRecAcceptReturn.getId());
            purcahseRecAcceptReturns.add(purchaseRecAcceptReturn);
        }
        this.purchaseRecAcceptReturnMapper.insertBatchSomeColumn(purcahseRecAcceptReturns);
    }

    private void insertDeductCost(SaleReconciliation saleReconciliation, List<SaleRecCharge> saleRecChargeList) {
        if (CollectionUtils.isEmpty(saleRecChargeList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
        ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
        for (SaleRecCharge entity : saleRecChargeList) {
            entity.setHeadId(saleReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleReconciliation);
            entity.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            entity.setItemNumber(String.valueOf(itemNumber));
            entity.setBusAccount(saleReconciliation.getBusAccount());
            SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)entity.getBusinessId())));
            saleDeductCost.setDeductStatus("1");
            saleDeductCost.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            saleDeductCosts.add(saleDeductCost);
            PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)saleDeductCost.getRelationId())));
            deductCost.setDeductStatus("1");
            deductCost.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            deductCosts.add(deductCost);
            ++itemNumber;
        }
        if (!saleRecChargeList.isEmpty()) {
            this.saleRecChargeService.saveBatch(saleRecChargeList, 2000);
        }
        if (!deductCosts.isEmpty()) {
            this.purchaseDeductCostService.updateBatchById(deductCosts);
        }
        if (!saleDeductCosts.isEmpty()) {
            this.saleDeductCostService.updateBatchById(saleDeductCosts);
        }
    }

    private void insertAddCost(SaleReconciliation saleReconciliation, List<SaleRecAdditionalCharges> saleRecAdditionalChargesList) {
        if (CollectionUtils.isEmpty(saleRecAdditionalChargesList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<PurchaseAddCost> addCosts = new ArrayList<PurchaseAddCost>();
        ArrayList<SaleAddCost> saleAddCosts = new ArrayList<SaleAddCost>();
        for (SaleRecAdditionalCharges entity : saleRecAdditionalChargesList) {
            entity.setHeadId(saleReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleReconciliation);
            entity.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            entity.setItemNumber(String.valueOf(itemNumber));
            entity.setBusAccount(saleReconciliation.getBusAccount());
            SaleAddCost saleAddCost = (SaleAddCost)((Object)this.saleAddCostService.getById((Serializable)((Object)entity.getBusinessId())));
            saleAddCost.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            saleAddCost.setCostStatus("1");
            saleAddCosts.add(saleAddCost);
            PurchaseAddCost addCost = (PurchaseAddCost)((Object)this.purchaseAddCostService.getById((Serializable)((Object)saleAddCost.getRelationId())));
            addCost.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            addCost.setCostStatus("1");
            addCosts.add(addCost);
            ++itemNumber;
        }
        if (!saleRecAdditionalChargesList.isEmpty()) {
            this.saleRecAdditionalChargesService.saveBatch(saleRecAdditionalChargesList, 200);
        }
        if (!addCosts.isEmpty()) {
            this.purchaseAddCostService.updateBatchById(addCosts);
        }
        if (!saleAddCosts.isEmpty()) {
            this.saleAddCostService.updateBatchById(saleAddCosts);
        }
    }

    private void insertAcceptReturns(SaleReconciliation saleReconciliation, List<SaleRecAcceptReturn> saleRecAcceptReturnList) {
        if (CollectionUtils.isEmpty(saleRecAcceptReturnList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<PurchaseVoucherItemDTO> voucherItems = new ArrayList<PurchaseVoucherItemDTO>();
        Date date = new Date();
        for (SaleRecAcceptReturn entity : saleRecAcceptReturnList) {
            entity.setHeadId(saleReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleReconciliation);
            entity.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            entity.setItemNumber(String.valueOf(itemNumber));
            entity.setBusAccount(saleReconciliation.getBusAccount());
            PurchaseVoucherItemDTO voucherItem = this.purchaseVoucherItemRpcService.getById(entity.getBusinessId());
            voucherItem.setReconciliation("1");
            voucherItem.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            voucherItem.setPostDate(date);
            voucherItems.add(voucherItem);
            ++itemNumber;
        }
        if (!saleRecAcceptReturnList.isEmpty()) {
            this.saleRecAcceptReturnService.saveBatch(saleRecAcceptReturnList, 2000);
        }
        if (!voucherItems.isEmpty()) {
            this.purchaseVoucherItemRpcService.updatePurchaseVoucherItemListById(voucherItems);
        }
    }
}

