/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.budget.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.budget.entity.BudgetCheckHead;
import com.els.modules.budget.entity.BudgetCheckItem;
import com.els.modules.budget.entity.BudgetDetail;
import com.els.modules.budget.entity.BudgetManage;
import com.els.modules.budget.mapper.BudgetManageMapper;
import com.els.modules.budget.rpc.PurchaseOrderHeadLocalRpcService;
import com.els.modules.budget.rpc.PurchaseRequestHeadLocalRpcService;
import com.els.modules.budget.service.BudgetCheckHeadService;
import com.els.modules.budget.service.BudgetDetailService;
import com.els.modules.budget.service.BudgetManageService;
import com.els.modules.budget.vo.BudgetCheckVo;
import com.els.modules.demand.api.dto.PurchaseRequestHeadDTO;
import com.els.modules.demand.api.dto.PurchaseRequestItemDTO;
import com.els.modules.inquiry.api.enumerate.PurchaseRequestStatusEnum;
import com.els.modules.inquiry.api.enumerate.PurchaseRequestStatusItemEnum;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.dto.PurchaseOrderItemDTO;
import com.els.modules.order.api.enumerate.OrderSourceTypeEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BudgetManageServiceImpl
extends ServiceImpl<BudgetManageMapper, BudgetManage>
implements BudgetManageService {
    @Resource
    private BudgetCheckHeadService budgetCheckHeadService;
    @Resource
    private BudgetDetailService budgetDetailService;
    @Resource
    private InterfaceUtil interfaceUtil;
    @Resource
    private PurchaseRequestHeadLocalRpcService purchaseRequestHeadLocalRpcService;
    @Resource
    private PurchaseOrderHeadLocalRpcService purchaseOrderHeadRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void saveBudgetManage(BudgetManage budgetManage) {
        ((BudgetManageMapper)this.baseMapper).insert((Object)budgetManage);
    }

    @Override
    public void updateBudgetManage(BudgetManage budgetManage) {
        int count = ((BudgetManageMapper)this.baseMapper).updateById((Object)budgetManage);
        if (count == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void delBudgetManage(String id) {
        ((BudgetManageMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchBudgetManage(List<String> idList) {
        ((BudgetManageMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void invalidBudgetManage(String id) {
        BudgetManage budgetManage = (BudgetManage)((Object)((BudgetManageMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        budgetManage.setStatus("1");
        this.updateBudgetManage(budgetManage);
    }

    @Override
    public void invalidBatchBudgetManage(List<String> idList) {
        for (String id : idList) {
            BudgetManage budgetManage = (BudgetManage)((Object)((BudgetManageMapper)this.baseMapper).selectById((Serializable)((Object)id)));
            budgetManage.setStatus("1");
            this.updateBudgetManage(budgetManage);
        }
    }

    @Override
    public List<BudgetManage> findByPurchaseRequestHead(PurchaseRequestHeadDTO purchaseRequestHead) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BudgetCheckHead::getPurchaseRequestType, (Object)purchaseRequestHead.getRequestType());
        BudgetCheckHead budgetCheckHead = (BudgetCheckHead)((Object)this.budgetCheckHeadService.getOne((Wrapper)lambdaQueryWrapper));
        if (null == budgetCheckHead) {
            return null;
        }
        BudgetCheckVo budgetCheckVo = this.budgetCheckHeadService.viewDetail(budgetCheckHead.getId());
        List<BudgetCheckItem> budgetCheckItems = budgetCheckVo.getBudgetCheckItems();
        if (CollectionUtils.isEmpty(budgetCheckItems)) {
            return null;
        }
        BudgetManage budgetManage = new BudgetManage();
        for (BudgetCheckItem budgetCheckItem : budgetCheckItems) {
            try {
                Field declaredField1 = purchaseRequestHead.getClass().getDeclaredField(budgetCheckItem.getPurchaseRequestField());
                declaredField1.setAccessible(true);
                String value = String.valueOf(declaredField1.get(purchaseRequestHead));
                Field declaredField2 = ((Object)((Object)budgetManage)).getClass().getDeclaredField(budgetCheckItem.getBudgetManageField());
                declaredField2.setAccessible(true);
                declaredField2.set((Object)budgetManage, value);
            }
            catch (IllegalAccessException | NoSuchFieldException e) {
                this.log.error("\u9884\u7b97\u6821\u9a8c\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u6620\u5c04\u5b57\u6bb5", (Throwable)e);
            }
        }
        budgetManage.setStatus("0");
        budgetManage.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        return ((BudgetManageMapper)this.baseMapper).findByBudgetManage(budgetManage);
    }

    @Override
    @SrmTransaction
    public Result<?> budgetCheck(String purchaseRequestHeadId) {
        PurchaseRequestHeadDTO purchaseRequestHead = this.purchaseRequestHeadLocalRpcService.selectPurchaseRequestHeadById(purchaseRequestHeadId);
        List<PurchaseRequestItemDTO> purchaseRequestItemList = this.purchaseRequestHeadLocalRpcService.selectPurchaseRequestItemListByMainId(purchaseRequestHead.getId());
        List filterPurchaseRequestItemList = purchaseRequestItemList.stream().filter(a -> "1".equals(a.getCheckBudget()) && (PurchaseRequestStatusItemEnum.SEND_BACK.getValue().equals(a.getItemStatus()) || PurchaseRequestStatusItemEnum.APPROVED.getValue().equals(a.getItemStatus()))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(filterPurchaseRequestItemList)) {
            purchaseRequestHead.setRequestStatus(PurchaseRequestStatusEnum.NOT_CHECK.getValue());
            this.purchaseRequestHeadLocalRpcService.updatePurchaseRequestHeadById(purchaseRequestHead);
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_dinRUVSTJO_2d08eb5e", (String)"\u6240\u9009\u91c7\u8d2d\u7533\u8bf7\u65e0\u9700\u6821\u9a8c"));
        }
        List<BudgetManage> budgetManages = this.findByPurchaseRequestHead(purchaseRequestHead);
        if (CollectionUtils.isEmpty(budgetManages)) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_rnRUVIdjUdxMKWVRsERKQiRW_35939b94", (String)"\u8be5\u91c7\u8d2d\u7533\u8bf7\u5bf9\u5e94\u7684\u9884\u7b97\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u4fdd\u914d\u7f6e\u662f\u5426\u6b63\u786e\uff01"));
        }
        if (budgetManages.size() > 1) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_rnRUVIdjUdMKOTWVRsERKQiRW_c7ef40a0", (String)"\u8be5\u91c7\u8d2d\u7533\u8bf7\u5bf9\u5e94\u7684\u9884\u7b97\u5b58\u5728\u591a\u6761\uff0c\u8bf7\u786e\u4fdd\u914d\u7f6e\u662f\u5426\u6b63\u786e\uff01"));
        }
        BudgetManage budgetManage = budgetManages.get(0);
        if ("0".equals(budgetManage.getBudgetMethod())) {
            BigDecimal lowestUnitPrice;
            BigDecimal highestUnitPrice = budgetManage.getHighestUnitPrice();
            if (null != highestUnitPrice) {
                for (Object purchaseRequestItem : filterPurchaseRequestItemList) {
                    if (purchaseRequestItem.getPrice().compareTo(highestUnitPrice) <= 0) continue;
                    purchaseRequestHead.setRequestStatus(PurchaseRequestStatusEnum.CHECK_FAIL.getValue());
                    this.purchaseRequestHeadLocalRpcService.updatePurchaseRequestHeadById(purchaseRequestHead);
                    return Result.error((String)I18nUtil.translate((String)"i18n_alert_EyLWWWWWWjnRUVctuBRUdRvextuWJOxeR_1ab739a4", (String)"\u884c\u53f7\u4e3a[${0}]\u7684\u91c7\u8d2d\u7533\u8bf7\u884c\u5355\u4ef7\u8d85\u8fc7\u9884\u7b97\u7ba1\u7406\u6700\u9ad8\u5355\u4ef7\uff0c\u6821\u9a8c\u4e0d\u901a\u8fc7", (String[])new String[]{purchaseRequestItem.getItemNumber()}));
                }
            }
            if (null != (lowestUnitPrice = budgetManage.getLowestUnitPrice())) {
                for (PurchaseRequestItemDTO purchaseRequestItem : filterPurchaseRequestItemList) {
                    if (purchaseRequestItem.getPrice().compareTo(lowestUnitPrice) >= 0) continue;
                    purchaseRequestHead.setRequestStatus(PurchaseRequestStatusEnum.CHECK_FAIL.getValue());
                    this.purchaseRequestHeadLocalRpcService.updatePurchaseRequestHeadById(purchaseRequestHead);
                    return Result.error((String)I18nUtil.translate((String)"i18n_alert_EyLWWWWWWjnRUVctunUUdRventuWJOxeR_9f6641b8", (String)"\u884c\u53f7\u4e3a[${0}]\u7684\u91c7\u8d2d\u7533\u8bf7\u884c\u5355\u4ef7\u4f4e\u4e8e\u9884\u7b97\u7ba1\u7406\u6700\u4f4e\u5355\u4ef7\uff0c\u6821\u9a8c\u4e0d\u901a\u8fc7", (String[])new String[]{purchaseRequestItem.getItemNumber()}));
                }
            }
        }
        BigDecimal availableAmount = budgetManage.getAvailableAmount();
        BigDecimal totalAmount = BigDecimal.ZERO;
        if ("0".equals(budgetManage.getBudgetMethod())) {
            if ("0".equals(budgetManage.getIncludeTax())) {
                for (PurchaseRequestItemDTO purchaseRequestItem : filterPurchaseRequestItemList) {
                    BigDecimal netPrices = purchaseRequestItem.getNetPrice().multiply(purchaseRequestItem.getQuantity());
                    totalAmount = totalAmount.add(netPrices);
                }
            } else {
                for (PurchaseRequestItemDTO purchaseRequestItem : filterPurchaseRequestItemList) {
                    BigDecimal prices = purchaseRequestItem.getPrice().multiply(purchaseRequestItem.getQuantity());
                    totalAmount = totalAmount.add(prices);
                }
            }
        } else {
            totalAmount = filterPurchaseRequestItemList.stream().map(PurchaseRequestItemDTO::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (totalAmount.compareTo(availableAmount) > 0) {
            purchaseRequestHead.setRequestStatus(PurchaseRequestStatusEnum.CHECK_FAIL.getValue());
            this.purchaseRequestHeadLocalRpcService.updatePurchaseRequestHeadById(purchaseRequestHead);
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_BRUdRvqjHfWJOxeR_154b9282", (String)"\u8d85\u8fc7\u9884\u7b97\u7ba1\u7406\u53ef\u7528\u91d1\u989d\uff0c\u6821\u9a8c\u4e0d\u901a\u8fc7"));
        }
        purchaseRequestHead.setRequestStatus(PurchaseRequestStatusEnum.CHECK_PASS.getValue());
        this.purchaseRequestHeadLocalRpcService.updatePurchaseRequestHeadById(purchaseRequestHead);
        budgetManage.setOccupiedAmount(budgetManage.getOccupiedAmount().add(totalAmount));
        budgetManage.setAvailableAmount(budgetManage.getAvailableAmount().subtract(totalAmount));
        this.updateBudgetManage(budgetManage);
        ArrayList<BudgetDetail> budgetDetails = new ArrayList<BudgetDetail>();
        for (PurchaseRequestItemDTO purchaseRequestItem : filterPurchaseRequestItemList) {
            BudgetDetail budgetDetail = new BudgetDetail();
            budgetDetail.setElsAccount(TenantContext.getTenant());
            budgetDetail.setTemplateNumber(purchaseRequestHead.getTemplateNumber());
            budgetDetail.setTemplateName(purchaseRequestHead.getTemplateName());
            budgetDetail.setTemplateVersion(purchaseRequestHead.getTemplateVersion());
            budgetDetail.setTemplateAccount(purchaseRequestHead.getTemplateAccount());
            budgetDetail.setBudgetId(budgetManage.getId());
            budgetDetail.setType("0");
            budgetDetail.setTypeId(purchaseRequestHead.getId());
            budgetDetail.setDetailLine(purchaseRequestItem.getRequestNumber() + "_" + purchaseRequestItem.getItemNumber());
            budgetDetail.setBudgetMethod(budgetManage.getBudgetMethod());
            budgetDetail.setIncludeTax(budgetManage.getIncludeTax());
            if ("0".equals(budgetManage.getBudgetMethod())) {
                if ("0".equals(budgetManage.getIncludeTax())) {
                    budgetDetail.setAmount(purchaseRequestItem.getNetPrice().multiply(purchaseRequestItem.getQuantity()));
                } else {
                    budgetDetail.setAmount(purchaseRequestItem.getPrice().multiply(purchaseRequestItem.getQuantity()));
                }
            } else {
                budgetDetail.setAmount(purchaseRequestItem.getQuantity());
            }
            budgetDetails.add(budgetDetail);
        }
        this.budgetDetailService.saveBatch(budgetDetails);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_JOeR_31abc2b8", (String)"\u6821\u9a8c\u901a\u8fc7"));
    }

    @Override
    @SrmTransaction
    public void refundOfOccupiedAmount(String purchaseRequestHeadId) {
        PurchaseRequestHeadDTO purchaseRequestHead = this.purchaseRequestHeadLocalRpcService.selectPurchaseRequestHeadById(purchaseRequestHeadId);
        if (PurchaseRequestStatusEnum.CHECK_PASS.getValue().equals(purchaseRequestHead.getRequestStatus())) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(BudgetDetail::getTypeId, (Object)purchaseRequestHeadId);
            List budgetDetails = this.budgetDetailService.list((Wrapper)lambdaQueryWrapper);
            if (!CollectionUtils.isEmpty((Collection)budgetDetails)) {
                BigDecimal totalAmount = budgetDetails.stream().map(BudgetDetail::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                BudgetManage budgetManage = (BudgetManage)((Object)((BudgetManageMapper)this.baseMapper).selectById((Serializable)((Object)((BudgetDetail)((Object)budgetDetails.get(0))).getBudgetId())));
                budgetManage.setOccupiedAmount(budgetManage.getOccupiedAmount().subtract(totalAmount));
                budgetManage.setAvailableAmount(budgetManage.getAvailableAmount().add(totalAmount));
                this.updateBudgetManage(budgetManage);
                this.budgetDetailService.remove((Wrapper)lambdaQueryWrapper);
            }
            purchaseRequestHead.setRequestStatus(PurchaseRequestStatusEnum.REQUEST_NEW.getValue());
            this.purchaseRequestHeadLocalRpcService.updatePurchaseRequestHeadById(purchaseRequestHead);
        }
    }

    @Override
    @SrmTransaction
    public void demandPoolRefund(String requestNumber, String itemNumber) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BudgetDetail::getDetailLine, (Object)(requestNumber + "_" + itemNumber));
        List budgetDetails = this.budgetDetailService.list((Wrapper)lambdaQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)budgetDetails)) {
            BigDecimal totalAmount = budgetDetails.stream().map(BudgetDetail::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BudgetManage budgetManage = (BudgetManage)((Object)((BudgetManageMapper)this.baseMapper).selectById((Serializable)((Object)((BudgetDetail)((Object)budgetDetails.get(0))).getBudgetId())));
            budgetManage.setOccupiedAmount(budgetManage.getOccupiedAmount().subtract(totalAmount));
            budgetManage.setAvailableAmount(budgetManage.getAvailableAmount().add(totalAmount));
            this.updateBudgetManage(budgetManage);
            this.budgetDetailService.remove((Wrapper)lambdaQueryWrapper);
        }
    }

    @Override
    public void requestToOrderChangeBudgetAmount(String purchaseOrderHeadId) {
        BigDecimal totalActualUsedAmount;
        PurchaseOrderHeadDTO purchaseOrderHead = this.purchaseOrderHeadRpcService.getById(purchaseOrderHeadId);
        List<Object> purchaseOrderItemList = this.purchaseOrderHeadRpcService.listItemByMainId(purchaseOrderHead.getId());
        List<String> sourceIds = (purchaseOrderItemList = purchaseOrderItemList.stream().filter(a -> OrderSourceTypeEnum.PURCHASE_REQUEST.getValue().equals(a.getSourceType())).collect(Collectors.toList())).stream().map(PurchaseOrderItemDTO::getSourceId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sourceIds)) {
            return;
        }
        List<PurchaseRequestItemDTO> purchaseRequestItemList = this.purchaseRequestHeadLocalRpcService.selectPurchaseRequestItemByItemIds(sourceIds);
        if (CollectionUtils.isEmpty(purchaseRequestItemList)) {
            return;
        }
        ArrayList<PurchaseRequestItemDTO> filterPurchaseRequestItemList = new ArrayList<PurchaseRequestItemDTO>();
        for (PurchaseRequestItemDTO purchaseRequestItem : purchaseRequestItemList) {
            if ("1".equals(purchaseRequestItem.getCheckBudget())) {
                filterPurchaseRequestItemList.add(purchaseRequestItem);
                continue;
            }
            purchaseOrderItemList.removeIf(a -> a.getSourceId().equals(purchaseRequestItem.getId()));
        }
        if (CollectionUtils.isEmpty(filterPurchaseRequestItemList) || CollectionUtils.isEmpty(purchaseOrderItemList)) {
            return;
        }
        PurchaseRequestHeadDTO purchaseRequestHead = this.purchaseRequestHeadLocalRpcService.selectPurchaseRequestHeadById(((PurchaseRequestItemDTO)filterPurchaseRequestItemList.get(0)).getHeadId());
        List<BudgetManage> budgetManages = this.findByPurchaseRequestHead(purchaseRequestHead);
        if (CollectionUtils.isEmpty(budgetManages)) {
            return;
        }
        if (budgetManages.size() > 1) {
            return;
        }
        BudgetManage budgetManage = budgetManages.get(0);
        BigDecimal totalOccupiedAmount = BigDecimal.ZERO;
        if ("0".equals(budgetManage.getBudgetMethod())) {
            if ("0".equals(budgetManage.getIncludeTax())) {
                totalActualUsedAmount = purchaseOrderItemList.stream().map(PurchaseOrderItemDTO::getNetAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                for (PurchaseRequestItemDTO purchaseRequestItem : filterPurchaseRequestItemList) {
                    BigDecimal netPrices = purchaseRequestItem.getNetPrice().multiply(purchaseRequestItem.getQuantity());
                    totalOccupiedAmount = totalOccupiedAmount.add(netPrices);
                }
            } else {
                totalActualUsedAmount = purchaseOrderItemList.stream().map(PurchaseOrderItemDTO::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                for (PurchaseRequestItemDTO purchaseRequestItem : filterPurchaseRequestItemList) {
                    BigDecimal prices = purchaseRequestItem.getPrice().multiply(purchaseRequestItem.getQuantity());
                    totalOccupiedAmount = totalOccupiedAmount.add(prices);
                }
            }
        } else {
            totalActualUsedAmount = purchaseOrderItemList.stream().map(PurchaseOrderItemDTO::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
            totalOccupiedAmount = filterPurchaseRequestItemList.stream().map(PurchaseRequestItemDTO::getQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        ArrayList<BudgetDetail> budgetActualDetails = new ArrayList<BudgetDetail>();
        for (PurchaseOrderItemDTO purchaseOrderItemDTO : purchaseOrderItemList) {
            BudgetDetail budgetActualDetail = new BudgetDetail();
            budgetActualDetail.setElsAccount(TenantContext.getTenant());
            budgetActualDetail.setTemplateNumber(purchaseOrderHead.getTemplateNumber());
            budgetActualDetail.setTemplateName(purchaseOrderHead.getTemplateName());
            budgetActualDetail.setTemplateVersion(purchaseOrderHead.getTemplateVersion());
            budgetActualDetail.setTemplateAccount(purchaseOrderHead.getTemplateAccount());
            budgetActualDetail.setBudgetId(budgetManage.getId());
            budgetActualDetail.setType("1");
            budgetActualDetail.setTypeId(purchaseOrderHead.getId());
            budgetActualDetail.setDetailLine(purchaseOrderItemDTO.getOrderNumber() + "_" + purchaseOrderItemDTO.getItemNumber());
            budgetActualDetail.setBudgetMethod(budgetManage.getBudgetMethod());
            budgetActualDetail.setIncludeTax(budgetManage.getIncludeTax());
            if ("0".equals(budgetManage.getBudgetMethod())) {
                if ("0".equals(budgetManage.getIncludeTax())) {
                    budgetActualDetail.setAmount(purchaseOrderItemDTO.getNetAmount());
                } else {
                    budgetActualDetail.setAmount(purchaseOrderItemDTO.getTaxAmount());
                }
            } else {
                budgetActualDetail.setAmount(purchaseOrderItemDTO.getQuantity());
            }
            budgetActualDetails.add(budgetActualDetail);
            PurchaseRequestItemDTO purchaseRequestItem = this.purchaseRequestHeadLocalRpcService.selectPurchaseRequestItemById(purchaseOrderItemDTO.getSourceId());
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(BudgetDetail::getDetailLine, (Object)(purchaseRequestItem.getRequestNumber() + "_" + purchaseRequestItem.getItemNumber()));
            this.budgetDetailService.remove((Wrapper)lambdaQueryWrapper);
        }
        this.budgetDetailService.saveBatch(budgetActualDetails);
        budgetManage.setOccupiedAmount(budgetManage.getOccupiedAmount().subtract(totalOccupiedAmount));
        budgetManage.setActualUsedAmount(budgetManage.getActualUsedAmount().add(totalActualUsedAmount));
        budgetManage.setAvailableAmount(budgetManage.getAvailableAmount().add(totalOccupiedAmount).subtract(totalActualUsedAmount));
        this.updateBudgetManage(budgetManage);
    }

    @Override
    @SrmTransaction
    public void refundOfActualUsedAmount(String purchaseOrderHeadId) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BudgetDetail::getTypeId, (Object)purchaseOrderHeadId);
        List budgetDetails = this.budgetDetailService.list((Wrapper)lambdaQueryWrapper);
        PurchaseOrderHeadDTO purchaseOrderHead = this.purchaseOrderHeadRpcService.getById(purchaseOrderHeadId);
        if (!CollectionUtils.isEmpty((Collection)budgetDetails)) {
            BudgetManage budgetManage = (BudgetManage)((Object)((BudgetManageMapper)this.baseMapper).selectById((Serializable)((Object)((BudgetDetail)((Object)budgetDetails.get(0))).getBudgetId())));
            ArrayList<BudgetDetail> budgetOccupiedDetails = new ArrayList<BudgetDetail>();
            for (BudgetDetail budgetDetail : budgetDetails) {
                LambdaQueryWrapper purchaseOrderItemQueryWrapper = new LambdaQueryWrapper();
                String[] split = budgetDetail.getDetailLine().split("_");
                purchaseOrderItemQueryWrapper.eq(PurchaseOrderItemDTO::getOrderNumber, (Object)split[0]);
                purchaseOrderItemQueryWrapper.eq(PurchaseOrderItemDTO::getItemNumber, (Object)split[1]);
                PurchaseOrderItemDTO purchaseOrderItem = this.purchaseOrderHeadRpcService.getItemByLineNumber(budgetDetail.getElsAccount(), purchaseOrderHead.getToElsAccount(), split[0], split[1]);
                PurchaseRequestItemDTO purchaseRequestItem = this.purchaseRequestHeadLocalRpcService.selectPurchaseRequestItemById(purchaseOrderItem.getSourceId());
                PurchaseRequestHeadDTO purchaseRequestHead = this.purchaseRequestHeadLocalRpcService.selectPurchaseRequestHeadById(purchaseRequestItem.getHeadId());
                BudgetDetail budgetOccupiedDetail = new BudgetDetail();
                budgetOccupiedDetail.setElsAccount(TenantContext.getTenant());
                budgetOccupiedDetail.setTemplateNumber(purchaseRequestHead.getTemplateNumber());
                budgetOccupiedDetail.setTemplateName(purchaseRequestHead.getTemplateName());
                budgetOccupiedDetail.setTemplateVersion(purchaseRequestHead.getTemplateVersion());
                budgetOccupiedDetail.setTemplateAccount(purchaseRequestHead.getTemplateAccount());
                budgetOccupiedDetail.setBudgetId(budgetManage.getId());
                budgetOccupiedDetail.setType("0");
                budgetOccupiedDetail.setTypeId(purchaseRequestHead.getId());
                budgetOccupiedDetail.setDetailLine(purchaseRequestItem.getRequestNumber() + "_" + purchaseRequestItem.getItemNumber());
                budgetOccupiedDetail.setBudgetMethod(budgetManage.getBudgetMethod());
                budgetOccupiedDetail.setIncludeTax(budgetManage.getIncludeTax());
                if ("0".equals(budgetManage.getBudgetMethod())) {
                    if ("0".equals(budgetManage.getIncludeTax())) {
                        budgetOccupiedDetail.setAmount(purchaseRequestItem.getNetPrice().multiply(purchaseRequestItem.getQuantity()));
                    } else {
                        budgetOccupiedDetail.setAmount(purchaseRequestItem.getPrice().multiply(purchaseRequestItem.getQuantity()));
                    }
                } else {
                    budgetOccupiedDetail.setAmount(purchaseRequestItem.getQuantity());
                }
                budgetOccupiedDetails.add(budgetOccupiedDetail);
            }
            this.budgetDetailService.saveBatch(budgetOccupiedDetails);
            BigDecimal totalActualUsedAmount = budgetDetails.stream().map(BudgetDetail::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal totalOccupiedAmount = budgetOccupiedDetails.stream().map(BudgetDetail::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            List<String> budgetDetailIds = budgetDetails.stream().map(BaseEntity::getId).collect(Collectors.toList());
            this.budgetDetailService.delBatchBudgetDetail(budgetDetailIds);
            budgetManage.setOccupiedAmount(budgetManage.getOccupiedAmount().add(totalOccupiedAmount));
            budgetManage.setActualUsedAmount(budgetManage.getActualUsedAmount().subtract(totalActualUsedAmount));
            budgetManage.setAvailableAmount(budgetManage.getAvailableAmount().subtract(totalOccupiedAmount).add(totalActualUsedAmount));
            this.updateBudgetManage(budgetManage);
        }
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getBudgetManage", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List budgetManageList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (BudgetManage budgetManage : budgetManageList) {
            String elsAccount = TenantContext.getTenant();
            this.interfaceUtil.callInterface(elsAccount, "pushBudgetManage", (Object)budgetManage);
        }
    }

    @Override
    public void copy(String id) {
        BudgetManage budgetManage = (BudgetManage)((Object)this.getById((Serializable)((Object)id)));
        budgetManage.setId(null);
        budgetManage.setBudgetNumber(this.invokeBaseRpcService.getNextCode("srmBudgetNumber", (Object)budgetManage));
        budgetManage.setElsAccount(TenantContext.getTenant());
        budgetManage.setStatus("0");
        budgetManage.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        budgetManage.setCreateBy(SysUtil.getLoginUser().getSubAccount());
        budgetManage.setCreateTime(new Date());
        budgetManage.setUpdateBy(null);
        budgetManage.setUpdateTime(null);
        budgetManage.setActualBudget(budgetManage.getBudgetAmount());
        budgetManage.setAvailableAmount(budgetManage.getBudgetAmount());
        budgetManage.setActualUsedAmount(BigDecimal.ZERO);
        budgetManage.setOccupiedAmount(BigDecimal.ZERO);
        this.saveBudgetManage(budgetManage);
    }
}

