/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.finance.api.enumerate.AddCostConfirmStatusEnum;
import com.els.modules.finance.entity.PurchaseAddCost;
import com.els.modules.finance.service.PurchaseAddCostService;
import com.els.modules.finance.vo.PurchaseAddCostVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u91c7\u8d2d\u9644\u52a0\u8d39\u7528\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/finance/purchaseAddCost"})
public class PurchaseAddCostController
extends BaseController<PurchaseAddCost, PurchaseAddCostService> {
    @Autowired
    private PurchaseAddCostService purchaseAddCostService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="addCost")
    public Result<?> queryPageList(PurchaseAddCost purchaseAddCost, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseAddCost), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseAddCostService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCount(PurchaseAddCost purchaseAddCost, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseAddCost), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"confirm_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"confirm_status");
        List list = ((PurchaseAddCostService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseAddCost::getConfirmStatus, PurchaseAddCost::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "confirmStatus", null, all));
        List srmAddCostConfirmStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmAddCostConfirmStatus", TenantContext.getTenant());
        for (DictDTO status : srmAddCostConfirmStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "confirmStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @AutoLog(value="\u91c7\u8d2d\u9644\u52a0\u8d39\u7528\u7ba1\u7406-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"finance#purchaseAddCost:add"})
    public Result<?> add(@RequestBody PurchaseAddCost purchaseAddCost) {
        this.purchaseAddCostService.savePurchaseAddCost(purchaseAddCost);
        return Result.ok((Object)((Object)purchaseAddCost));
    }

    @AutoLog(value="\u91c7\u8d2d\u9644\u52a0\u8d39\u7528\u7ba1\u7406-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"finance#purchaseAddCost:edit"})
    public Result<?> edit(@RequestBody PurchaseAddCost purchaseAddCost) {
        this.purchaseAddCostService.updatePurchaseAddCost(purchaseAddCost);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u9644\u52a0\u8d39\u7528\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"finance#purchaseAddCost:delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchaseAddCostService.delPurchaseAddCost(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u9644\u52a0\u8d39\u7528\u7ba1\u7406-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseAddCostService.delBatchPurchaseAddCost(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"finance#purchaseAddCost:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseAddCost purchaseAddCost = (PurchaseAddCost)((Object)this.purchaseAddCostService.getById((Serializable)((Object)id)));
        PurchaseAddCostVO purchaseAddCostVO = new PurchaseAddCostVO();
        BeanUtils.copyProperties((Object)((Object)purchaseAddCost), (Object)((Object)purchaseAddCostVO));
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchaseAddCostVO.setPurchaseAttachmentList(purchaseAttachmentList);
        return Result.ok((Object)((Object)purchaseAddCostVO));
    }

    @AutoLog(value="\u91c7\u8d2d\u9644\u52a0\u8d39\u7528\u7ba1\u7406-\u901a\u8fc7id\u786e\u8ba4")
    @ApiOperation(value="\u901a\u8fc7id\u786e\u8ba4", notes="\u901a\u8fc7id\u786e\u8ba4")
    @PostMapping(value={"/confirmById"})
    public Result<?> confirmById(@RequestBody PurchaseAddCost purchaseAddCost) {
        purchaseAddCost.setConfirmStatus(AddCostConfirmStatusEnum.ALREADY_CONFIRM.getValue());
        this.purchaseAddCostService.replyAddCost(purchaseAddCost);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u91c7\u8d2d\u9644\u52a0\u8d39\u7528\u7ba1\u7406-\u901a\u8fc7id\u62d2\u7edd")
    @ApiOperation(value="\u901a\u8fc7id\u62d2\u7edd", notes="\u901a\u8fc7id\u62d2\u7edd")
    @PostMapping(value={"/rejectById"})
    public Result<?> rejectById(@RequestBody PurchaseAddCost purchaseAddCost) {
        purchaseAddCost.setConfirmStatus(AddCostConfirmStatusEnum.REJECTED.getValue());
        this.purchaseAddCostService.replyAddCost(purchaseAddCost);
        return this.commonSuccessResult(3);
    }
}

