/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.finance.api.enumerate.AddCostConfirmStatusEnum;
import com.els.modules.finance.api.enumerate.AddCostSourceEnum;
import com.els.modules.finance.api.enumerate.AddCostStatusEnum;
import com.els.modules.finance.entity.SaleAddCost;
import com.els.modules.finance.service.SaleAddCostService;
import com.els.modules.finance.vo.SaleAddCostVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u9500\u552e\u9644\u52a0\u8d39\u7528\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/finance/saleAddCost"})
public class SaleAddCostController
extends BaseController<SaleAddCost, SaleAddCostService> {
    @Autowired
    private SaleAddCostService saleAddCostService;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SaleAddCost saleAddCost, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleAddCost), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleAddCostService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> queryTabsCount(SaleAddCost saleAddCost, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleAddCost), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"confirm_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"confirm_status");
        List list = ((SaleAddCostService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SaleAddCost::getConfirmStatus, SaleAddCost::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "confirmStatus", null, all));
        List srmAddCostConfirmStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmAddCostConfirmStatus", TenantContext.getTenant());
        for (DictDTO status : srmAddCostConfirmStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "confirmStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @AutoLog(value="\u9500\u552e\u9644\u52a0\u8d39\u7528\u7ba1\u7406-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"finance#saleAddCost:add"})
    public Result<?> add(@RequestBody SaleAddCost saleAddCost) {
        LoginUser sysUser = SysUtil.getLoginUser();
        saleAddCost.setElsAccount(sysUser.getElsAccount());
        saleAddCost.setSupplierName(sysUser.getEnterpriseName());
        saleAddCost.setCostStatus(AddCostStatusEnum.NO_RECONCILIATION.getValue());
        saleAddCost.setSourceType(AddCostSourceEnum.SRM.getValue());
        saleAddCost.setConfirmStatus(AddCostConfirmStatusEnum.NEW.getValue());
        this.saleAddCostService.saveSaleAddCost(saleAddCost);
        return Result.ok((Object)((Object)saleAddCost));
    }

    @AutoLog(value="\u9500\u552e\u9644\u52a0\u8d39\u7528\u7ba1\u7406-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"finance#saleAddCost:edit"})
    public Result<?> edit(@RequestBody SaleAddCost saleAddCost) {
        this.saleAddCostService.updateSaleAddCost(saleAddCost);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9500\u552e\u9644\u52a0\u8d39\u7528-\u53d1\u9001\u9644\u52a0\u8d39\u7528\u5355\u636e")
    @ApiOperation(value="\u53d1\u9001\u9644\u52a0\u8d39\u7528\u5355\u636e", notes="\u53d1\u9001\u9644\u52a0\u8d39\u7528\u5355\u636e")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"finance#saleAddCost:publish"})
    public Result<?> publish(@RequestBody SaleAddCost saleAddCost) {
        this.saleAddCostService.sendAddCost(saleAddCost);
        return Result.ok((Object)((Object)saleAddCost));
    }

    @AutoLog(value="\u9500\u552e\u9644\u52a0\u8d39\u7528\u7ba1\u7406-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/invalid"})
    public Result<?> invalid(@RequestBody SaleAddCost saleAddCost) {
        this.saleAddCostService.invalidSaleAddCost(saleAddCost);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9500\u552e\u9644\u52a0\u8d39\u7528\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"finance#saleAddCost:delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.saleAddCostService.delSaleAddCost(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u9500\u552e\u9644\u52a0\u8d39\u7528\u7ba1\u7406-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.saleAddCostService.delBatchSaleAddCost(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"finance#saleAddCost:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        SaleAddCost saleAddCost = (SaleAddCost)((Object)this.saleAddCostService.getById((Serializable)((Object)id)));
        SaleAddCostVO saleAddCostVO = new SaleAddCostVO();
        BeanUtils.copyProperties((Object)((Object)saleAddCost), (Object)((Object)saleAddCostVO));
        List saleAttachmentList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        saleAddCostVO.setSaleAttachmentList(saleAttachmentList);
        return Result.ok((Object)((Object)saleAddCostVO));
    }
}

