/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.finance.api.enumerate.DeductCostConfirmStatusEnum;
import com.els.modules.finance.api.enumerate.DeductCostSourceEnum;
import com.els.modules.finance.entity.PurchaseDeductCost;
import com.els.modules.finance.entity.SaleDeductCost;
import com.els.modules.finance.mapper.PurchaseDeductCostMapper;
import com.els.modules.finance.service.PurchaseDeductCostService;
import com.els.modules.finance.service.SaleDeductCostService;
import com.els.modules.integrated.api.dto.IntegratedDocumentDTO;
import com.els.modules.reconciliation.entity.PurchaseRecCharge;
import com.els.modules.reconciliation.enumerate.ReconcilationItemTypeEmun;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import com.els.rpc.service.CoreInvokeSupplierRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PurchaseDeductCostServiceImpl
extends BaseServiceImpl<PurchaseDeductCostMapper, PurchaseDeductCost>
implements PurchaseDeductCostService {
    @Autowired
    private SaleDeductCostService saleDeductCostService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private CoreInvokeSupplierRpcService supplierContactsInfoService;
    @Resource
    private InvokeBaseRpcService baseRpcService;

    @Override
    public void savePurchaseDeductCost(PurchaseDeductCost purchaseDeductCost) {
        if (StringUtils.isBlank((CharSequence)purchaseDeductCost.getDeductNumber())) {
            purchaseDeductCost.setDeductNumber(this.invokeBaseRpcService.getNextCode("srmDeductCostNumber", (Object)purchaseDeductCost));
        }
        ((PurchaseDeductCostMapper)this.baseMapper).insert((Object)purchaseDeductCost);
        this.handleDocument(purchaseDeductCost);
    }

    private void handleDocument(PurchaseDeductCost purchaseDeductCost) {
        String idStr = IdWorker.getIdStr();
        purchaseDeductCost.setDocumentId(idStr);
        ((PurchaseDeductCostMapper)this.baseMapper).updateById((Object)purchaseDeductCost);
        IntegratedDocumentDTO integratedDocument = new IntegratedDocumentDTO();
        integratedDocument.setId(idStr);
        integratedDocument.setDeductCostId(purchaseDeductCost.getId());
        this.baseRpcService.saveIntegratedDocument(integratedDocument);
    }

    @Override
    public void updatePurchaseDeductCost(PurchaseDeductCost purchaseDeductCost) {
        this.calculateNetPrice(purchaseDeductCost);
        ((PurchaseDeductCostMapper)this.baseMapper).updateById((Object)purchaseDeductCost);
    }

    private void calculateNetPrice(PurchaseDeductCost deductCost) {
        BigDecimal taxRate = deductCost.getTaxRate() == null ? BigDecimal.ZERO : new BigDecimal(deductCost.getTaxRate()).divide(BigDecimal.valueOf(100L));
        BigDecimal taxAmount = deductCost.getTaxAmount() == null ? BigDecimal.ZERO : deductCost.getTaxAmount();
        BigDecimal netAmount = taxAmount.divide(BigDecimal.ONE.add(taxRate), 6, 4);
        deductCost.setNetAmount(netAmount);
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void sendDeductCost(PurchaseDeductCost purchaseDeductCost) {
        boolean firstSend = true;
        String id = purchaseDeductCost.getId();
        String relationId = purchaseDeductCost.getRelationId();
        String elsAccount = purchaseDeductCost.getElsAccount();
        String toElsAccount = purchaseDeductCost.getToElsAccount();
        if (StringUtils.isBlank((CharSequence)relationId)) {
            relationId = IdWorker.getIdStr();
            purchaseDeductCost.setRelationId(relationId);
        } else {
            firstSend = false;
        }
        if ("0".equals(purchaseDeductCost.getRequiredConfirmation())) {
            purchaseDeductCost.setConfirmStatus(DeductCostConfirmStatusEnum.ALREADY_CONFIRM.getValue());
        } else {
            purchaseDeductCost.setConfirmStatus(DeductCostConfirmStatusEnum.WAIT_CONFIRM.getValue());
        }
        if ("0".equals(purchaseDeductCost.getRequiredConfirmation()) && !StringUtils.isEmpty((CharSequence)purchaseDeductCost.getRequiredAudit()) && !"1".equals(purchaseDeductCost.getRequiredAudit())) {
            purchaseDeductCost.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.updatePurchaseDeductCost(purchaseDeductCost);
        SaleDeductCost saleDeductCost = new SaleDeductCost();
        BeanUtils.copyProperties((Object)((Object)purchaseDeductCost), (Object)((Object)saleDeductCost));
        saleDeductCost.setId(relationId);
        saleDeductCost.setRelationId(id);
        saleDeductCost.setElsAccount(toElsAccount);
        saleDeductCost.setToElsAccount(elsAccount);
        if (firstSend) {
            this.saleDeductCostService.saveSaleDeductCost(saleDeductCost);
        } else {
            this.saleDeductCostService.updateSaleDeductCost(saleDeductCost);
        }
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        if (CollectionUtil.isNotEmpty((Collection)purchaseAttachmentList)) {
            AttachmentSendDTO sendVO = new AttachmentSendDTO();
            sendVO.setElsAccount(elsAccount);
            sendVO.setHeadId(id);
            HashMap<String, String> toSend = new HashMap<String, String>();
            toSend.put(relationId, toElsAccount);
            sendVO.setToSend(toSend);
            this.invokeBaseRpcService.sendPurchaseFile(sendVO, false);
        }
        String urlParam = "id=" + purchaseDeductCost.getRelationId();
        super.sendMsg(purchaseDeductCost.getElsAccount(), purchaseDeductCost.getToElsAccount(), (Object)purchaseDeductCost, urlParam, "deductCost", "publish");
    }

    @Override
    public void delPurchaseDeductCost(String id) {
        ((PurchaseDeductCostMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseDeductCost(List<String> idList) {
        ((PurchaseDeductCostMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void invalidPurchaseDeductCost(PurchaseDeductCost purchaseDeductCost) {
        PurchaseDeductCost deductCost = new PurchaseDeductCost();
        deductCost.setId(purchaseDeductCost.getId());
        deductCost.setConfirmStatus(DeductCostConfirmStatusEnum.INVALID.getValue());
        this.updateById((Object)deductCost);
        if (StringUtils.isNotBlank((CharSequence)purchaseDeductCost.getRelationId())) {
            SaleDeductCost saleDeductCost = new SaleDeductCost();
            saleDeductCost.setId(purchaseDeductCost.getRelationId());
            saleDeductCost.setConfirmStatus(DeductCostConfirmStatusEnum.INVALID.getValue());
            this.saleDeductCostService.updateById((Object)saleDeductCost);
            String urlParam = "id=" + purchaseDeductCost.getRelationId();
            super.sendMsg(purchaseDeductCost.getElsAccount(), purchaseDeductCost.getToElsAccount(), (Object)purchaseDeductCost, urlParam, "deductCost", "cancel");
        }
    }

    @Override
    public List<PurchaseDeductCost> listPurchaseDeductCost(ReconciliationVO reconciliationVO, String elsAccount) {
        QueryWrapper deDuctWapper = new QueryWrapper();
        deDuctWapper.eq((Object)"els_account", (Object)elsAccount);
        deDuctWapper.eq((Object)"to_els_account", (Object)reconciliationVO.getToElsAccount());
        deDuctWapper.eq((Object)"company", (Object)reconciliationVO.getCompany());
        deDuctWapper.ge((Object)"deduct_time", (Object)reconciliationVO.getBeginDate());
        deDuctWapper.le((Object)"deduct_time", (Object)reconciliationVO.getEndDate());
        deDuctWapper.eq((Object)"confirm_status", (Object)DeductCostConfirmStatusEnum.ALREADY_CONFIRM.getValue());
        deDuctWapper.and(q -> ((QueryWrapper)((QueryWrapper)q.isNull((Object)"deduct_status")).or()).eq((Object)"deduct_status", (Object)"0"));
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getTaxCode())) {
            deDuctWapper.eq((Object)"tax_code", (Object)reconciliationVO.getTaxCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getCurrency())) {
            deDuctWapper.eq((Object)"currency", (Object)reconciliationVO.getCurrency());
        }
        return this.list((Wrapper)deDuctWapper);
    }

    @Override
    public List<PurchaseRecCharge> getByPurchaseDeductCost(ReconciliationVO reconciliationVO, String elsAccount) {
        List<PurchaseDeductCost> purchaseDeductCosts = this.listPurchaseDeductCost(reconciliationVO, elsAccount);
        ArrayList<PurchaseRecCharge> charges = new ArrayList<PurchaseRecCharge>();
        if (CollectionUtil.isEmpty(purchaseDeductCosts)) {
            return null;
        }
        for (PurchaseDeductCost purchaseDeductCost : purchaseDeductCosts) {
            PurchaseRecCharge charge = new PurchaseRecCharge();
            BeanUtils.copyProperties((Object)((Object)purchaseDeductCost), (Object)((Object)charge));
            charge.setItemType(ReconcilationItemTypeEmun.CHARGE.getValue());
            charge.setVoucherNumber(purchaseDeductCost.getDeductNumber());
            charge.setVoucherTime(purchaseDeductCost.getDeductTime());
            charge.setDeductionType(purchaseDeductCost.getDeductType());
            charge.setTotalAmount(purchaseDeductCost.getTaxAmount());
            charge.setTotalNonTaxAmount(purchaseDeductCost.getNetAmount());
            charge.setDeductionsReason(purchaseDeductCost.getDeductReason());
            charge.setDeductionsInstructions(purchaseDeductCost.getDeductInstruction());
            charge.setSource(purchaseDeductCost.getSourceType());
            charge.setBusinessType(purchaseDeductCost.getRelationType());
            charge.setBusinessId(purchaseDeductCost.getId());
            charge.setDocumentParentId(purchaseDeductCost.getId());
            charge.setId(null);
            charges.add(charge);
        }
        return charges;
    }

    @Override
    public void copyData(String id) {
        PurchaseDeductCost purchaseDeductCost = (PurchaseDeductCost)((Object)((PurchaseDeductCostMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        if (purchaseDeductCost == null) {
            return;
        }
        PurchaseDeductCost newDeductCost = new PurchaseDeductCost();
        newDeductCost.setTemplateNumber(purchaseDeductCost.getTemplateNumber());
        newDeductCost.setTemplateName(purchaseDeductCost.getTemplateName());
        newDeductCost.setTemplateVersion(purchaseDeductCost.getTemplateVersion());
        newDeductCost.setTemplateAccount(purchaseDeductCost.getTemplateAccount());
        newDeductCost.setPurchaseOrg(purchaseDeductCost.getPurchaseOrg());
        newDeductCost.setCompany(purchaseDeductCost.getCompany());
        newDeductCost.setToElsAccount(purchaseDeductCost.getToElsAccount());
        newDeductCost.setSupplierName(purchaseDeductCost.getSupplierName());
        newDeductCost.setDeductTime(purchaseDeductCost.getDeductTime());
        newDeductCost.setDeductType(purchaseDeductCost.getDeductType());
        newDeductCost.setTaxCode(purchaseDeductCost.getTaxCode());
        newDeductCost.setTaxRate(purchaseDeductCost.getTaxRate());
        newDeductCost.setCurrency(purchaseDeductCost.getCurrency());
        newDeductCost.setLocalCurrency(purchaseDeductCost.getLocalCurrency());
        newDeductCost.setExchangeRate(purchaseDeductCost.getExchangeRate());
        newDeductCost.setDeductReason(purchaseDeductCost.getDeductReason());
        newDeductCost.setDeductInstruction(purchaseDeductCost.getDeductInstruction());
        newDeductCost.setRelationType(purchaseDeductCost.getRelationType());
        newDeductCost.setRelationNumber(purchaseDeductCost.getRelationNumber());
        newDeductCost.setRelationItemNumber(purchaseDeductCost.getRelationItemNumber());
        newDeductCost.setRequiredConfirmation(purchaseDeductCost.getRequiredConfirmation());
        newDeductCost.setRequiredAudit(purchaseDeductCost.getRequiredAudit());
        newDeductCost.setAuditStrategy(purchaseDeductCost.getAuditStrategy());
        newDeductCost.setWorkFlowType(purchaseDeductCost.getWorkFlowType());
        newDeductCost.setBusAccount(purchaseDeductCost.getBusAccount());
        newDeductCost.setSourceType(DeductCostSourceEnum.SRM.getValue());
        newDeductCost.setConfirmStatus(DeductCostConfirmStatusEnum.NEW.getValue());
        newDeductCost.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        this.savePurchaseDeductCost(newDeductCost);
    }
}

