/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.BaseDTO;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.contract.dto.PurchaseContractHeadDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.finance.api.enumerate.PaymentApplyEnum;
import com.els.modules.finance.api.enumerate.PaymentApplyOtherEnum;
import com.els.modules.finance.api.enumerate.PaymentApplySourceTypeEnum;
import com.els.modules.finance.api.enumerate.PaymentApplyStatusEnum;
import com.els.modules.finance.api.enumerate.ReconciliationPaymentStatusEnum;
import com.els.modules.finance.entity.PurchasePaymentApplyHead;
import com.els.modules.finance.entity.PurchasePaymentApplyItem;
import com.els.modules.finance.entity.PurchasePaymentApplyOther;
import com.els.modules.finance.entity.PurchasePaymentApplyWriteOff;
import com.els.modules.finance.entity.PurchaseWriteOffRecord;
import com.els.modules.finance.entity.SalePaymentApplyHead;
import com.els.modules.finance.entity.SalePaymentApplyItem;
import com.els.modules.finance.entity.SalePaymentApplyOther;
import com.els.modules.finance.entity.SalePaymentApplyWriteOff;
import com.els.modules.finance.mapper.PurchasePaymentApplyHeadMapper;
import com.els.modules.finance.mapper.PurchasePaymentApplyItemMapper;
import com.els.modules.finance.mapper.PurchasePaymentApplyOtherMapper;
import com.els.modules.finance.mapper.PurchasePaymentApplyWriteOffMapper;
import com.els.modules.finance.mapper.SalePaymentApplyHeadMapper;
import com.els.modules.finance.mapper.SalePaymentApplyItemMapper;
import com.els.modules.finance.mapper.SalePaymentApplyOtherMapper;
import com.els.modules.finance.mapper.SalePaymentApplyWriteOffMapper;
import com.els.modules.finance.rpc.ElsEnterpriseInfoLocalRpcService;
import com.els.modules.finance.rpc.FinanceInvokeContractRpcService;
import com.els.modules.finance.rpc.FinanceInvokeOrderRpcService;
import com.els.modules.finance.service.PurchasePaymentApplyHeadService;
import com.els.modules.finance.service.PurchasePaymentApplyItemService;
import com.els.modules.finance.service.PurchasePaymentApplyOtherService;
import com.els.modules.finance.service.PurchaseWriteOffRecordService;
import com.els.modules.finance.service.SalePaymentApplyHeadService;
import com.els.modules.finance.service.SalePaymentApplyItemService;
import com.els.modules.finance.service.SalePaymentApplyOtherService;
import com.els.modules.finance.vo.PurchasePaymentApplyHeadVO;
import com.els.modules.order.api.dto.PurchaseOrderHeadDTO;
import com.els.modules.order.api.dto.PurchaseOrderItemDTO;
import com.els.modules.reconciliation.api.dto.PurchaseDeliveryWaterDTO;
import com.els.modules.reconciliation.entity.ElsPurchaseStatisticsSourceCase;
import com.els.modules.reconciliation.entity.ElsPurchaseStatisticsSourceCaseRecord;
import com.els.modules.reconciliation.entity.ElsPurchaseStatisticsWriteOff;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.PurchasePaymentCharge;
import com.els.modules.reconciliation.entity.PurchasePerformanceReconciliation;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.entity.SalePaymentCharge;
import com.els.modules.reconciliation.mapper.PurchasePaymentChargeMapper;
import com.els.modules.reconciliation.mapper.SalePaymentChargeMapper;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsSourceCaseRecordService;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsSourceCaseService;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffService;
import com.els.modules.reconciliation.service.PurchaseDeliveryWaterService;
import com.els.modules.reconciliation.service.PurchaseInvoiceService;
import com.els.modules.reconciliation.service.PurchasePerformanceReconciliationService;
import com.els.modules.reconciliation.service.PurchaseReconciliationService;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchasePaymentApplyHeadServiceImpl
extends BaseServiceImpl<PurchasePaymentApplyHeadMapper, PurchasePaymentApplyHead>
implements PurchasePaymentApplyHeadService {
    @Resource
    private PurchasePaymentApplyHeadMapper purchasePaymentApplyHeadMapper;
    @Resource
    private PurchasePaymentApplyItemMapper purchasePaymentApplyItemMapper;
    @Resource
    private PurchasePaymentApplyOtherMapper purchasePaymentApplyOtherMapper;
    @Resource
    private PurchasePaymentApplyWriteOffMapper purchasePaymentApplyWriteOffMapper;
    @Resource
    private SalePaymentApplyWriteOffMapper salePaymentApplyWriteOffMapper;
    @Autowired
    private SalePaymentApplyHeadService salePaymentApplyHeadService;
    @Autowired
    private SalePaymentApplyItemService salePaymentApplyItemService;
    @Autowired
    private SalePaymentApplyOtherService salePaymentApplyOtherService;
    @Resource
    private PurchasePaymentChargeMapper purchasePaymentChargeMapper;
    @Resource
    private SalePaymentChargeMapper salePaymentChargeMapper;
    @Resource
    private SalePaymentApplyItemMapper salePaymentApplyItemMapper;
    @Resource
    private SalePaymentApplyOtherMapper salePaymentApplyOtherMapper;
    @Resource
    private FinanceInvokeOrderRpcService financeInvokeOrderRpcService;
    @Resource
    private FinanceInvokeContractRpcService financeInvokeContractRpcService;
    @Autowired
    private PurchaseReconciliationService purchaseReconciliationService;
    @Autowired
    private PurchaseInvoiceService purchaseInvoiceService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private ElsEnterpriseInfoLocalRpcService elsEnterpriseInfoRpcService;
    @Autowired
    private ElsPurchaseStatisticsSourceCaseService elsPurchaseStatisticsSourceCaseService;
    @Autowired
    private PurchasePaymentApplyItemService purchasePaymentApplyItemService;
    @Resource
    private PurchasePerformanceReconciliationService purchasePerformanceReconciliationService;
    @Autowired
    private ElsPurchaseStatisticsWriteOffService elsPurchaseStatisticsWriteOffService;
    @Autowired
    private PurchaseWriteOffRecordService purchaseWriteOffRecordService;
    @Resource
    private SalePaymentApplyHeadMapper salePaymentApplyHeadMapper;
    @Autowired
    private PurchaseDeliveryWaterService purchaseDeliveryWaterService;
    @Autowired
    private ElsPurchaseStatisticsSourceCaseRecordService elsPurchaseStatisticsSourceCaseRecordService;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchasePaymentApplyHead purchasePaymentApplyHead, PurchasePaymentApplyHeadVO purchasePaymentApplyHeadVO) {
        List<PurchasePaymentApplyItem> purchasePaymentApplyItemList = purchasePaymentApplyHeadVO.getPurchasePaymentApplyItemList();
        List<PurchasePaymentApplyWriteOff> purchasePaymentApplyWriteOffList = purchasePaymentApplyHeadVO.getPurchasePaymentApplyWriteOffList();
        purchasePaymentApplyHead.setPaymentApplyNumber(this.invokeBaseRpcService.getNextCode("srmApplyNumber", (Object)purchasePaymentApplyHead));
        ElsEnterpriseInfoDTO enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(TenantContext.getTenant());
        if (enterpriseInfo != null) {
            purchasePaymentApplyHead.setPurchaseName(enterpriseInfo.getName());
        }
        purchasePaymentApplyHead.setPaymentApplyStatus(PaymentApplyStatusEnum.OUTSTANDING.getValue());
        purchasePaymentApplyHead.setPush("0");
        purchasePaymentApplyHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        this.calculateAmount(purchasePaymentApplyHead, purchasePaymentApplyHeadVO);
        this.purchasePaymentApplyHeadMapper.insert((Object)purchasePaymentApplyHead);
        this.insertPaymentApplyItem(purchasePaymentApplyHead, purchasePaymentApplyItemList);
        this.insertPaymentWriteOffReconciliationList(purchasePaymentApplyHead, purchasePaymentApplyWriteOffList);
        this.insertPurchasePaymentCharge(purchasePaymentApplyHead, purchasePaymentApplyHeadVO.getPurchasePaymentChargeList());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchasePaymentApplyHead purchasePaymentApplyHead, PurchasePaymentApplyHeadVO purchasePaymentApplyHeadVO) {
        this.checkOverAmount(purchasePaymentApplyHeadVO);
        this.calculateAmount(purchasePaymentApplyHead, purchasePaymentApplyHeadVO);
        this.purchasePaymentApplyHeadMapper.updateById((Object)purchasePaymentApplyHead);
        List<PurchasePaymentApplyOther> purchasePaymentApplyOtherList = this.purchasePaymentApplyOtherMapper.selectByMainId(purchasePaymentApplyHead.getId());
        this.purchasePaymentApplyItemMapper.deleteByMainId(purchasePaymentApplyHead.getId());
        this.purchasePaymentApplyOtherMapper.deleteByMainId(purchasePaymentApplyHead.getId());
        this.purchasePaymentApplyWriteOffMapper.deleteByMainId(purchasePaymentApplyHead.getId());
        this.purchasePaymentChargeMapper.deleteByMainId(purchasePaymentApplyHead.getId());
        for (PurchasePaymentApplyOther purchasePaymentApplyOther : purchasePaymentApplyOtherList) {
            this.calculationDelCharge(purchasePaymentApplyOther);
        }
        this.insertPaymentApplyItem(purchasePaymentApplyHead, purchasePaymentApplyHeadVO.getPurchasePaymentApplyItemList());
        this.insertPaymentApplyOtherList(purchasePaymentApplyHead, purchasePaymentApplyHeadVO.getPurchasePaymentApplyOtherList());
        this.insertPaymentWriteOffReconciliationList(purchasePaymentApplyHead, purchasePaymentApplyHeadVO.getPurchasePaymentApplyWriteOffList());
        this.insertPurchasePaymentCharge(purchasePaymentApplyHead, purchasePaymentApplyHeadVO.getPurchasePaymentChargeList());
    }

    private void checkOverAmount(PurchasePaymentApplyHeadVO purchasePaymentApplyHeadVO) {
        List<PurchasePaymentApplyItem> purchasePaymentApplyItemList = purchasePaymentApplyHeadVO.getPurchasePaymentApplyItemList();
        if (CollectionUtils.isEmpty(purchasePaymentApplyItemList)) {
            return;
        }
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItemList) {
            BigDecimal applyAmount = purchasePaymentApplyItem.getApplyAmount();
            BigDecimal shouldTaxAmount = purchasePaymentApplyItem.getShouldTaxAmount();
            if (applyAmount == null || shouldTaxAmount == null || shouldTaxAmount.compareTo(applyAmount) >= 0) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_field_UVBVHfxjfUxfHf_a16c3dd6", (String)"\u7533\u8bf7\u4ed8\u6b3e\u91d1\u989d\u4e0d\u5f97\u5927\u4e8e\u542b\u7a0e\u91d1\u989d"));
        }
    }

    private void insertPaymentApplyOtherList(PurchasePaymentApplyHead purchasePaymentApplyHead, List<PurchasePaymentApplyOther> purchasePaymentApplyOtherList) {
        if (CollectionUtils.isEmpty(purchasePaymentApplyOtherList)) {
            return;
        }
        int index = 1;
        for (PurchasePaymentApplyOther entity : purchasePaymentApplyOtherList) {
            entity.setHeadId(purchasePaymentApplyHead.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchasePaymentApplyHead);
            if (PaymentApplyOtherEnum.CHARGE.getValue().equals(entity.getSourceType())) {
                this.calculationCharge(entity);
            }
            entity.setPaymentApplyNumber(purchasePaymentApplyHead.getPaymentApplyNumber());
            entity.setItemNumber(index + "");
            ++index;
        }
        if (!purchasePaymentApplyOtherList.isEmpty()) {
            this.purchasePaymentApplyOtherMapper.insertBatchSomeColumn(purchasePaymentApplyOtherList);
        }
    }

    private void calculationCharge(PurchasePaymentApplyOther purchasePaymentApplyOther) {
        PurchaseReconciliationService bean = (PurchaseReconciliationService)SpringContextUtils.getBean(PurchaseReconciliationService.class);
        PurchaseReconciliation byId = (PurchaseReconciliation)((Object)bean.getById((Serializable)((Object)purchasePaymentApplyOther.getSourceId())));
        if (byId != null) {
            PurchasePaymentApplyOtherService bean1 = (PurchasePaymentApplyOtherService)SpringContextUtils.getBean(PurchasePaymentApplyOtherService.class);
            if (bean1 != null) {
                List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)bean1.lambdaQuery().eq(PurchasePaymentApplyOther::getSourceId, (Object)purchasePaymentApplyOther.getSourceId())).eq(BaseEntity::getDeleted, (Object)"0")).list();
                BigDecimal reduce = list.parallelStream().map(PurchasePaymentApplyOther::getApplyAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                if (reduce.add(purchasePaymentApplyOther.getApplyAmount()).compareTo(byId.getChargeAmount()) > 0) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IeteVHfBBWIetyLWWWWWWVXVSVVsM_2a9b43c", (String)("\u5bf9\u8d26\u5355\u8d26\u6263\u91d1\u989d\u8d85\u6807,\u5bf9\u8d26\u5355\u53f7\u4e3a:" + purchasePaymentApplyOther.getSourceNumber() + ",\u8bf7\u5237\u65b0\u540e\u91cd\u65b0\u4fdd\u5b58"), (String[])new String[]{purchasePaymentApplyOther.getSourceNumber()}));
                }
                byId.setAlreadyChargeAmount(reduce.add(purchasePaymentApplyOther.getApplyAmount()));
                bean.updateById((Object)byId);
            }
        } else {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_YxuIetWIetyLWWWWWW_8c15af30", (String)("\u627e\u4e0d\u5230\u5bf9\u8d26\u5355,\u5bf9\u8d26\u5355\u53f7\u4e3a:" + purchasePaymentApplyOther.getSourceNumber()), (String[])new String[]{purchasePaymentApplyOther.getSourceNumber()}));
        }
    }

    private void handleDocumentInfo(PurchasePaymentApplyHead purchasePaymentApplyHead, List<PurchasePaymentApplyItem> purchasePaymentApplyItemList, List<SalePaymentApplyItem> salePaymentApplyItemList) {
        List<String> strings;
        PurchaseInvoice purchaseInvoice;
        PurchaseOrderItemDTO dto;
        Iterator<BaseEntity> purchaseOrderItemDTOList;
        HashSet<String> reconciliationNumberSet = new HashSet<String>();
        HashSet<String> orderNumberSet = new HashSet<String>();
        HashSet<String> invoiceNumberSet = new HashSet<String>();
        HashSet parentIdSet = new HashSet();
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItemList) {
            if (PaymentApplySourceTypeEnum.ORDER.getValue().equals(purchasePaymentApplyItem.getSourceType())) {
                if (StringUtils.isEmpty((CharSequence)purchasePaymentApplyItem.getSourceNumber())) continue;
                orderNumberSet.add(purchasePaymentApplyItem.getSourceNumber());
                continue;
            }
            if (!PaymentApplySourceTypeEnum.INVOICE.getValue().equals(purchasePaymentApplyItem.getSourceType())) continue;
            if (!StringUtils.isEmpty((CharSequence)purchasePaymentApplyItem.getInvoiceNumber())) {
                invoiceNumberSet.add(purchasePaymentApplyItem.getInvoiceNumber());
            }
            if (StringUtils.isEmpty((CharSequence)purchasePaymentApplyItem.getSourceNumber())) continue;
            reconciliationNumberSet.add(purchasePaymentApplyItem.getSourceNumber());
        }
        List purchaseInvoiceList = new ArrayList();
        HashMap<String, Object> purchaseInvoiceMap = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty(invoiceNumberSet)) {
            LambdaQueryWrapper purchaseInvoiceLambdaQueryWrapper = new LambdaQueryWrapper();
            purchaseInvoiceLambdaQueryWrapper.in(PurchaseInvoice::getInvoiceNumber, invoiceNumberSet);
            purchaseInvoiceList = this.purchaseInvoiceService.list((Wrapper)purchaseInvoiceLambdaQueryWrapper);
            if (!CollectionUtils.isEmpty(purchaseInvoiceList)) {
                for (Object purchaseInvoice2 : purchaseInvoiceList) {
                    purchaseInvoiceMap.put(((PurchaseInvoice)((Object)purchaseInvoice2)).getInvoiceNumber(), purchaseInvoice2);
                }
            }
        }
        HashMap<String, PurchaseOrderItemDTO> purchaseOrderHeadMap = new HashMap<String, PurchaseOrderItemDTO>();
        if (!CollectionUtils.isEmpty(orderNumberSet) && !CollectionUtils.isEmpty(purchaseOrderItemDTOList = this.financeInvokeOrderRpcService.listPurchaseOrderItemByOrderNumber(new ArrayList<String>(orderNumberSet)))) {
            Object purchaseInvoice2;
            purchaseInvoice2 = purchaseOrderItemDTOList.iterator();
            while (purchaseInvoice2.hasNext()) {
                dto = (PurchaseOrderItemDTO)purchaseInvoice2.next();
                purchaseOrderHeadMap.put(dto.getOrderNumber(), dto);
            }
        }
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItemList) {
            if (PaymentApplySourceTypeEnum.ORDER.getValue().equals(purchasePaymentApplyItem.getSourceType())) {
                if (StringUtils.isEmpty((CharSequence)purchasePaymentApplyItem.getSourceNumber()) || (dto = (PurchaseOrderItemDTO)purchaseOrderHeadMap.get(purchasePaymentApplyItem.getSourceNumber())) == null) continue;
                purchasePaymentApplyItem.setDocumentId(dto.getDocumentId());
                purchasePaymentApplyItem.setDocumentParentId(purchasePaymentApplyItem.getId());
                continue;
            }
            if (!PaymentApplySourceTypeEnum.INVOICE.getValue().equals(purchasePaymentApplyItem.getSourceType()) || StringUtils.isEmpty((CharSequence)purchasePaymentApplyItem.getInvoiceNumber()) || (purchaseInvoice = (PurchaseInvoice)((Object)purchaseInvoiceMap.get(purchasePaymentApplyItem.getInvoiceNumber()))) == null) continue;
            purchasePaymentApplyItem.setDocumentId(purchaseInvoice.getDocumentId());
            purchasePaymentApplyItem.setDocumentParentId(purchaseInvoice.getId());
        }
        for (SalePaymentApplyItem salePaymentApplyItem : salePaymentApplyItemList) {
            if (PaymentApplySourceTypeEnum.ORDER.getValue().equals(salePaymentApplyItem.getSourceType())) {
                if (StringUtils.isEmpty((CharSequence)salePaymentApplyItem.getSourceNumber()) || (dto = (PurchaseOrderItemDTO)purchaseOrderHeadMap.get(salePaymentApplyItem.getSourceNumber())) == null) continue;
                salePaymentApplyItem.setDocumentId(dto.getDocumentId());
                salePaymentApplyItem.setDocumentParentId(salePaymentApplyItem.getRelationId());
                continue;
            }
            if (!PaymentApplySourceTypeEnum.INVOICE.getValue().equals(salePaymentApplyItem.getSourceType()) || StringUtils.isEmpty((CharSequence)salePaymentApplyItem.getInvoiceNumber()) || (purchaseInvoice = (PurchaseInvoice)((Object)purchaseInvoiceMap.get(salePaymentApplyItem.getInvoiceNumber()))) == null) continue;
            salePaymentApplyItem.setDocumentId(purchaseInvoice.getDocumentId());
            salePaymentApplyItem.setDocumentParentId(purchaseInvoice.getId());
        }
        if (!CollectionUtils.isEmpty(purchasePaymentApplyItemList)) {
            for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItemList) {
                this.purchasePaymentApplyItemMapper.updateById((Object)purchasePaymentApplyItem);
            }
        }
        HashSet<String> headDocumentIds = new HashSet<String>();
        List<PurchaseOrderHeadDTO> purchaseOrderHeadDTOList = this.financeInvokeOrderRpcService.listPurchaseOrderHeadByOrderNumber(new ArrayList<String>(orderNumberSet));
        if (!CollectionUtils.isEmpty(purchaseOrderHeadDTOList)) {
            List purchaseOrderHeadDocumentIds = purchaseOrderHeadDTOList.stream().map(PurchaseOrderHeadDTO::getDocumentId).collect(Collectors.toList());
            parentIdSet.addAll(purchaseOrderHeadDTOList.stream().map(BaseDTO::getId).collect(Collectors.toSet()));
            for (String purchaseOrderHeadDocumentId : purchaseOrderHeadDocumentIds) {
                if (StringUtils.isEmpty((CharSequence)purchaseOrderHeadDocumentId)) continue;
                if (purchaseOrderHeadDocumentId.contains(",")) {
                    strings = Arrays.asList(purchaseOrderHeadDocumentId.split(","));
                    headDocumentIds.addAll(strings);
                    continue;
                }
                headDocumentIds.add(purchaseOrderHeadDocumentId);
            }
        }
        if (!CollectionUtils.isEmpty(purchaseInvoiceList)) {
            List purchaseInvoiceDocumentIds = purchaseInvoiceList.stream().map(PurchaseInvoice::getDocumentId).collect(Collectors.toList());
            parentIdSet.addAll(purchaseInvoiceList.stream().map(BaseEntity::getId).collect(Collectors.toSet()));
            for (String purchaseInvoiceDocumentId : purchaseInvoiceDocumentIds) {
                if (StringUtils.isEmpty((CharSequence)purchaseInvoiceDocumentId)) continue;
                if (purchaseInvoiceDocumentId.contains(",")) {
                    strings = Arrays.asList(purchaseInvoiceDocumentId.split(","));
                    headDocumentIds.addAll(strings);
                    continue;
                }
                headDocumentIds.add(purchaseInvoiceDocumentId);
            }
        }
        String headDocumentId = StringUtils.join(headDocumentIds, (String)",");
        String parentId = StringUtils.join(parentIdSet, (String)",");
        purchasePaymentApplyHead.setDocumentId(headDocumentId);
        purchasePaymentApplyHead.setDocumentParentId(parentId);
        this.purchasePaymentApplyHeadMapper.updateById((Object)purchasePaymentApplyHead);
        for (String documentId : headDocumentIds) {
            this.invokeBaseRpcService.updateIntegratedDocumentMain("paymentApplyHeadId", documentId, parentId, purchasePaymentApplyHead.getId());
        }
    }

    private void calculateAmount(PurchasePaymentApplyHead purchasePaymentApplyHead, PurchasePaymentApplyHeadVO purchasePaymentApplyHeadVO) {
        List<PurchasePaymentApplyItem> purchasePaymentApplyItemList = purchasePaymentApplyHeadVO.getPurchasePaymentApplyItemList();
        List<PurchasePaymentApplyOther> purchasePaymentApplyOtherList = purchasePaymentApplyHeadVO.getPurchasePaymentApplyOtherList();
        BigDecimal shouldTaxAmount = BigDecimal.ZERO;
        BigDecimal shouldNoTaxAmount = BigDecimal.ZERO;
        BigDecimal applyAmount = BigDecimal.ZERO;
        BigDecimal applyNoAmount = BigDecimal.ZERO;
        BigDecimal closingAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(purchasePaymentApplyItemList)) {
            shouldTaxAmount = purchasePaymentApplyItemList.parallelStream().filter(item -> item.getShouldTaxAmount() != null).map(PurchasePaymentApplyItem::getShouldTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            shouldNoTaxAmount = purchasePaymentApplyItemList.parallelStream().filter(item -> item.getShouldNoTaxAmount() != null).map(PurchasePaymentApplyItem::getShouldNoTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            applyAmount = purchasePaymentApplyItemList.parallelStream().filter(item -> item.getApplyAmount() != null).map(PurchasePaymentApplyItem::getApplyAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            applyNoAmount = purchasePaymentApplyItemList.parallelStream().filter(item -> item.getApplyNoTaxAmount() != null).map(PurchasePaymentApplyItem::getApplyNoTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            closingAmount = purchasePaymentApplyItemList.parallelStream().filter(a -> a.getClosingAmount() != null).map(PurchasePaymentApplyItem::getClosingAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        if (!CollectionUtils.isEmpty(purchasePaymentApplyOtherList)) {
            BigDecimal bigDecimalCharge = purchasePaymentApplyOtherList.parallelStream().filter(item -> PaymentApplyOtherEnum.CHARGE.getValue().equals(item.getSourceType())).map(PurchasePaymentApplyOther::getShouldTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal reduceCharge = purchasePaymentApplyItemList.parallelStream().filter(item -> PaymentApplyOtherEnum.CHARGE.getValue().equals(item.getSourceType())).map(PurchasePaymentApplyItem::getApplyAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            shouldTaxAmount = shouldTaxAmount.subtract(bigDecimalCharge);
            shouldNoTaxAmount = shouldNoTaxAmount.subtract(bigDecimalCharge);
            applyAmount = applyAmount.subtract(reduceCharge);
            applyNoAmount = applyNoAmount.subtract(reduceCharge);
        }
        purchasePaymentApplyHead.setTaxTotalAmount(shouldTaxAmount);
        purchasePaymentApplyHead.setNoTaxtPaymentAmount(shouldNoTaxAmount);
        purchasePaymentApplyHead.setPaymentAmount(applyAmount);
        purchasePaymentApplyHead.setNoTaxtPaymentAmount(applyNoAmount);
        purchasePaymentApplyHead.setClosingAmount(closingAmount);
    }

    private void calculateClosingAmount(List<PurchasePaymentApplyItem> purchasePaymentApplyItemList) {
        Map<String, ElsPurchaseStatisticsSourceCase> map = this.getStatisticsSourceMap(purchasePaymentApplyItemList);
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItemList) {
            ElsPurchaseStatisticsSourceCase statisticsSourceCase;
            String sourceId = purchasePaymentApplyItem.getSourceId();
            if (StringUtils.isEmpty((CharSequence)sourceId) || (statisticsSourceCase = map.get(sourceId)) == null) continue;
            BigDecimal sourceShouldTaxAmount = purchasePaymentApplyItem.getShouldTaxAmount() == null ? BigDecimal.ZERO : purchasePaymentApplyItem.getShouldTaxAmount();
            BigDecimal sourcePaidAmount = statisticsSourceCase.getSourcePaidAmount() == null ? BigDecimal.ZERO : statisticsSourceCase.getSourcePaidAmount();
            BigDecimal sourcePaymentAmount = statisticsSourceCase.getSourcePaymentAmount() == null ? BigDecimal.ZERO : statisticsSourceCase.getSourcePaymentAmount();
            BigDecimal sourceClosingAmount = sourceShouldTaxAmount.subtract(sourcePaidAmount).subtract(sourcePaymentAmount);
            purchasePaymentApplyItem.setClosingAmount(sourceClosingAmount);
        }
    }

    @Override
    public Map<String, ElsPurchaseStatisticsSourceCase> getStatisticsSourceMap(List<PurchasePaymentApplyItem> purchasePaymentApplyItemList) {
        HashMap<String, ElsPurchaseStatisticsSourceCase> map = new HashMap<String, ElsPurchaseStatisticsSourceCase>();
        Set sourceIds = purchasePaymentApplyItemList.stream().map(PurchasePaymentApplyItem::getSourceId).collect(Collectors.toSet());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_id", sourceIds);
        List list = this.elsPurchaseStatisticsSourceCaseService.list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (ElsPurchaseStatisticsSourceCase elsPurchaseStatisticsSourceCase : list) {
                map.put(elsPurchaseStatisticsSourceCase.getSourceId(), elsPurchaseStatisticsSourceCase);
            }
        }
        return map;
    }

    private void insertPaymentApplyItem(PurchasePaymentApplyHead purchasePaymentApplyHead, List<PurchasePaymentApplyItem> purchasePaymentApplyItemList) {
        if (CollectionUtils.isEmpty(purchasePaymentApplyItemList)) {
            return;
        }
        int index = 1;
        for (PurchasePaymentApplyItem entity : purchasePaymentApplyItemList) {
            entity.setHeadId(purchasePaymentApplyHead.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchasePaymentApplyHead);
            entity.setPaymentApplyNumber(purchasePaymentApplyHead.getPaymentApplyNumber());
            entity.setItemNumber(index + "");
            ++index;
        }
        if (!purchasePaymentApplyItemList.isEmpty()) {
            this.purchasePaymentApplyItemMapper.insertBatchSomeColumn(purchasePaymentApplyItemList);
        }
    }

    private void insertPurchasePaymentCharge(PurchasePaymentApplyHead purchasePaymentApplyHead, List<PurchasePaymentCharge> purchasePaymentChargeList) {
        if (CollectionUtils.isEmpty(purchasePaymentChargeList)) {
            return;
        }
        int index = 1;
        for (PurchasePaymentCharge entity : purchasePaymentChargeList) {
            entity.setId(null);
            entity.setHeadId(purchasePaymentApplyHead.getId());
            entity.setPaymentApplyNumber(purchasePaymentApplyHead.getPaymentApplyNumber());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchasePaymentApplyHead);
            entity.setItemNumber(index + "");
            ++index;
        }
        if (!purchasePaymentChargeList.isEmpty()) {
            this.purchasePaymentChargeMapper.insertBatchSomeColumn(purchasePaymentChargeList);
        }
    }

    private void insertPaymentWriteOffReconciliationList(PurchasePaymentApplyHead purchasePaymentApplyHead, List<PurchasePaymentApplyWriteOff> purchasePaymentApplyWriteOffList) {
        if (CollectionUtils.isEmpty(purchasePaymentApplyWriteOffList)) {
            return;
        }
        int index = 1;
        for (PurchasePaymentApplyWriteOff entity : purchasePaymentApplyWriteOffList) {
            entity.setId(null);
            entity.setHeadId(purchasePaymentApplyHead.getId());
            entity.setPaymentApplyNumber(purchasePaymentApplyHead.getPaymentApplyNumber());
            entity.setToElsAccount(purchasePaymentApplyHead.getToElsAccount());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchasePaymentApplyHead);
            entity.setItemNumber(index + "");
            ++index;
        }
        if (!purchasePaymentApplyWriteOffList.isEmpty()) {
            this.purchasePaymentApplyWriteOffMapper.insertBatchSomeColumn(purchasePaymentApplyWriteOffList);
        }
    }

    private void calculationDelCharge(PurchasePaymentApplyOther purchasePaymentApplyOther) {
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.cancelReleaseAmount(id);
        this.purchasePaymentApplyOtherMapper.deleteByMainId(id);
        this.purchasePaymentApplyItemMapper.deleteByMainId(id);
        this.purchasePaymentApplyWriteOffMapper.deleteByMainId(id);
        this.purchasePaymentChargeMapper.deleteByMainId(id);
        this.purchasePaymentApplyHeadMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void synchr(PurchasePaymentApplyHeadVO purchasePaymentApplyHeadVO) {
        PurchasePaymentApplyHead purchasePaymentApplyHead = (PurchasePaymentApplyHead)((Object)this.getById((Serializable)((Object)purchasePaymentApplyHeadVO.getId())));
        if (!purchasePaymentApplyHead.getPaymentApplyStatus().equals(purchasePaymentApplyHeadVO.getPaymentApplyStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtFzEhbHrWVXVSsK_2a0afd21", (String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u53d1\u751f\u66f4\u6539,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5"));
        }
        List<PurchasePaymentApplyItem> purchasePaymentApplyItems = this.purchasePaymentApplyItemMapper.selectByMainId(purchasePaymentApplyHeadVO.getId());
        List<PurchasePaymentApplyOther> purchasePaymentApplyOtherList = this.purchasePaymentApplyOtherMapper.selectByMainId(purchasePaymentApplyHeadVO.getId());
        List<PurchasePaymentCharge> purchasePaymentChargeList = this.purchasePaymentChargeMapper.selectByMainId(purchasePaymentApplyHeadVO.getId());
        List<PurchasePaymentApplyWriteOff> purchasePaymentApplyWriteOffList = this.purchasePaymentApplyWriteOffMapper.selectByMainId(purchasePaymentApplyHeadVO.getId());
        if ("1".equals(purchasePaymentApplyHead.getSendStatus())) {
            this.salePaymentApplyHeadService.delMain(purchasePaymentApplyHead.getRelationId());
            this.salePaymentApplyItemService.removeByIds(purchasePaymentApplyItems.parallelStream().map(item -> item.getRelationId()).collect(Collectors.toList()));
            this.salePaymentApplyOtherService.removeByIds(purchasePaymentApplyOtherList.parallelStream().map(item -> item.getRelationId()).collect(Collectors.toList()));
        }
        purchasePaymentApplyHead.setSendStatus("1");
        SalePaymentApplyHead saleHead = new SalePaymentApplyHead();
        BeanUtils.copyProperties((Object)((Object)purchasePaymentApplyHead), (Object)((Object)saleHead));
        saleHead.setId(IdWorker.getIdStr());
        purchasePaymentApplyHead.setRelationId(saleHead.getId());
        saleHead.setRelationId(purchasePaymentApplyHead.getId());
        saleHead.setElsAccount(purchasePaymentApplyHead.getToElsAccount());
        saleHead.setToElsAccount(purchasePaymentApplyHead.getElsAccount());
        saleHead.setBusAccount(purchasePaymentApplyHead.getElsAccount());
        this.salePaymentApplyHeadService.save((Object)saleHead);
        List<SalePaymentApplyItem> saleItemList = this.insertSalePaymentApplyItem(purchasePaymentApplyHead, purchasePaymentApplyItems, saleHead);
        this.insertSalePaymentApplyOther(purchasePaymentApplyHead, purchasePaymentApplyOtherList, saleHead);
        this.insertSalePaymentCharge(purchasePaymentApplyHead, purchasePaymentChargeList, saleHead);
        this.insertSalePaymentApplyWriteOff(purchasePaymentApplyHead, purchasePaymentApplyWriteOffList, saleHead);
        this.insertSaleAttachment(purchasePaymentApplyHeadVO, purchasePaymentApplyHead);
        this.purchasePaymentApplyHeadMapper.alwaysUpdateSomeColumnById((Object)purchasePaymentApplyHead);
        purchasePaymentApplyItems.forEach(item -> this.purchasePaymentApplyItemMapper.alwaysUpdateSomeColumnById(item));
        purchasePaymentChargeList.forEach(item -> this.purchasePaymentChargeMapper.alwaysUpdateSomeColumnById(item));
        purchasePaymentApplyWriteOffList.forEach(item -> this.purchasePaymentApplyWriteOffMapper.alwaysUpdateSomeColumnById(item));
        this.sendMessage(purchasePaymentApplyHead, saleHead);
        this.handleDocumentInfo(purchasePaymentApplyHead, purchasePaymentApplyItems, saleItemList);
        saleHead.setDocumentId(purchasePaymentApplyHead.getDocumentId());
        saleHead.setDocumentParentId(purchasePaymentApplyHead.getDocumentParentId());
        this.salePaymentApplyHeadService.updateById((Object)saleHead);
        this.purchasePaymentApplyHeadMapper.updateById((Object)purchasePaymentApplyHead);
    }

    @Override
    public void checkAmount(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return;
        }
        PurchasePaymentApplyHead purchasePaymentApplyHead = (PurchasePaymentApplyHead)((Object)this.purchasePaymentApplyHeadMapper.selectById((Serializable)((Object)id)));
        List<PurchasePaymentApplyItem> purchasePaymentApplyItems = this.purchasePaymentApplyItemMapper.selectByMainId(id);
        if (purchasePaymentApplyHead == null || CollectionUtils.isEmpty(purchasePaymentApplyItems)) {
            return;
        }
        ArrayList<ElsPurchaseStatisticsSourceCase> list = new ArrayList<ElsPurchaseStatisticsSourceCase>();
        Map<String, ElsPurchaseStatisticsSourceCase> map = this.getStatisticsSourceMap(purchasePaymentApplyItems);
        this.saveStatisticsSourceCase(purchasePaymentApplyItems, list, map);
        this.calculatePaymentApplyHead(purchasePaymentApplyHead, purchasePaymentApplyItems);
        String tips = this.checkOverAmount(purchasePaymentApplyItems, map);
        if (!StringUtils.isEmpty((CharSequence)tips)) {
            throw new ELSBootException("\u7b2c " + tips + " \u884c\u7684\u4ed8\u6b3e\u7533\u8bf7\u542b\u7a0e\u91d1\u989d\u5927\u4e8e\u7ed3\u7b97\u91d1\u989d");
        }
        this.purchasePaymentApplyHeadMapper.updateById((Object)purchasePaymentApplyHead);
    }

    private void saveStatisticsSourceCase(List<PurchasePaymentApplyItem> purchasePaymentApplyItems, List<ElsPurchaseStatisticsSourceCase> list, Map<String, ElsPurchaseStatisticsSourceCase> map) {
        ArrayList<ElsPurchaseStatisticsSourceCaseRecord> recordList = new ArrayList<ElsPurchaseStatisticsSourceCaseRecord>();
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItems) {
            if (purchasePaymentApplyItem.getApplyAmount() == null || StringUtils.isEmpty((CharSequence)purchasePaymentApplyItem.getSourceId())) continue;
            ElsPurchaseStatisticsSourceCase statisticsSourceCase = map.get(purchasePaymentApplyItem.getSourceId());
            if (statisticsSourceCase == null) {
                statisticsSourceCase = new ElsPurchaseStatisticsSourceCase();
                statisticsSourceCase.setId(IdWorker.getIdStr());
                statisticsSourceCase.setSourceId(purchasePaymentApplyItem.getSourceId());
            }
            BigDecimal sourcePaymentAmount = statisticsSourceCase.getSourcePaymentAmount() == null ? BigDecimal.ZERO : statisticsSourceCase.getSourcePaymentAmount();
            sourcePaymentAmount = sourcePaymentAmount.add(purchasePaymentApplyItem.getApplyAmount());
            statisticsSourceCase.setSourcePaymentAmount(sourcePaymentAmount);
            statisticsSourceCase.setSourceClosingAmount(purchasePaymentApplyItem.getClosingAmount());
            ElsPurchaseStatisticsSourceCaseRecord record = new ElsPurchaseStatisticsSourceCaseRecord();
            record.setHeadId(statisticsSourceCase.getId());
            record.setAmount(purchasePaymentApplyItem.getApplyAmount());
            record.setSourceId(purchasePaymentApplyItem.getSourceId());
            recordList.add(record);
            list.add(statisticsSourceCase);
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.elsPurchaseStatisticsSourceCaseService.saveOrUpdateBatch(list);
        }
        if (!CollectionUtils.isEmpty(recordList)) {
            this.elsPurchaseStatisticsSourceCaseRecordService.saveBatch(recordList);
        }
    }

    private String checkOverAmount(List<PurchasePaymentApplyItem> purchasePaymentApplyItems, Map<String, ElsPurchaseStatisticsSourceCase> map) {
        StringJoiner tips = new StringJoiner(",");
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItems) {
            BigDecimal closingAmount = purchasePaymentApplyItem.getClosingAmount();
            BigDecimal applyAmount = purchasePaymentApplyItem.getApplyAmount();
            if (closingAmount == null || applyAmount == null || closingAmount.compareTo(applyAmount) >= 0 || StringUtils.isEmpty((CharSequence)purchasePaymentApplyItem.getItemNumber())) continue;
            tips.add(purchasePaymentApplyItem.getItemNumber());
        }
        return tips.toString();
    }

    private void calculatePaymentApplyHead(PurchasePaymentApplyHead purchasePaymentApplyHead, List<PurchasePaymentApplyItem> purchasePaymentApplyItems) {
        BigDecimal applyAmount = BigDecimal.ZERO;
        BigDecimal preWrittenOffAmount = BigDecimal.ZERO;
        BigDecimal closingAmount = BigDecimal.ZERO;
        BigDecimal payAmount = BigDecimal.ZERO;
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItems) {
            if (purchasePaymentApplyItem.getApplyAmount() != null) {
                applyAmount = applyAmount.add(purchasePaymentApplyItem.getApplyAmount());
            }
            if (purchasePaymentApplyItem.getPreWrittenOffAmount() != null) {
                preWrittenOffAmount = preWrittenOffAmount.add(purchasePaymentApplyItem.getPreWrittenOffAmount());
            }
            if (purchasePaymentApplyItem.getClosingAmount() != null) {
                closingAmount = closingAmount.add(purchasePaymentApplyItem.getClosingAmount());
            }
            if (purchasePaymentApplyItem.getPayAmount() == null) continue;
            payAmount = payAmount.add(purchasePaymentApplyItem.getPayAmount());
        }
        purchasePaymentApplyHead.setPaymentAmount(applyAmount);
        purchasePaymentApplyHead.setPrePayWriteOffAmount(preWrittenOffAmount);
        purchasePaymentApplyHead.setClosingAmount(closingAmount);
        purchasePaymentApplyHead.setPayAmount(payAmount);
    }

    private void insertSaleAttachment(PurchasePaymentApplyHeadVO id, PurchasePaymentApplyHead byId) {
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id.getId());
        if (CollectionUtil.isNotEmpty((Collection)purchaseAttachmentList)) {
            AttachmentSendDTO sendVO = new AttachmentSendDTO();
            sendVO.setElsAccount(TenantContext.getTenant());
            sendVO.setHeadId(byId.getId());
            HashMap<String, String> toSend = new HashMap<String, String>();
            toSend.put(byId.getId(), byId.getElsAccount());
            sendVO.setToSend(toSend);
            this.invokeBaseRpcService.sendPurchaseFile(sendVO, false);
        }
    }

    private void insertSalePaymentApplyOther(PurchasePaymentApplyHead byId, List<PurchasePaymentApplyOther> purchasePaymentApplyOtherList, SalePaymentApplyHead saleHead) {
        ArrayList<SalePaymentApplyOther> salePaymentApplyOthers = new ArrayList<SalePaymentApplyOther>();
        for (PurchasePaymentApplyOther purchasePaymentApplyOther : purchasePaymentApplyOtherList) {
            SalePaymentApplyOther saleItem = new SalePaymentApplyOther();
            BeanUtils.copyProperties((Object)((Object)purchasePaymentApplyOther), (Object)((Object)saleItem));
            saleItem.setId(IdWorker.getIdStr());
            purchasePaymentApplyOther.setRelationId(saleItem.getId());
            saleItem.setHeadId(saleHead.getId());
            saleItem.setRelationId(purchasePaymentApplyOther.getId());
            saleItem.setElsAccount(byId.getToElsAccount());
            SysUtil.setSysParam((BaseEntity)saleItem, (BaseEntity)saleHead);
            salePaymentApplyOthers.add(saleItem);
        }
        if (CollectionUtil.isNotEmpty(salePaymentApplyOthers)) {
            salePaymentApplyOthers.forEach(item -> this.salePaymentApplyOtherMapper.insert(item));
        }
    }

    private void insertSalePaymentCharge(PurchasePaymentApplyHead byId, List<PurchasePaymentCharge> purchasePaymentChargeList, SalePaymentApplyHead saleHead) {
        ArrayList<SalePaymentCharge> salePaymentChargeList = new ArrayList<SalePaymentCharge>();
        for (PurchasePaymentCharge purchasePaymentCharge : purchasePaymentChargeList) {
            SalePaymentCharge salePaymentCharge = new SalePaymentCharge();
            BeanUtils.copyProperties((Object)((Object)purchasePaymentCharge), (Object)((Object)salePaymentCharge));
            salePaymentCharge.setId(IdWorker.getIdStr());
            purchasePaymentCharge.setRelationId(salePaymentCharge.getId());
            salePaymentCharge.setHeadId(saleHead.getId());
            salePaymentCharge.setRelationId(salePaymentCharge.getId());
            salePaymentCharge.setElsAccount(byId.getToElsAccount());
            salePaymentCharge.setBusAccount(byId.getToElsAccount());
            SysUtil.setSysParam((BaseEntity)salePaymentCharge, (BaseEntity)saleHead);
            salePaymentChargeList.add(salePaymentCharge);
        }
        if (CollectionUtil.isNotEmpty(salePaymentChargeList)) {
            salePaymentChargeList.forEach(item -> this.salePaymentChargeMapper.insert(item));
        }
    }

    private void insertSalePaymentApplyWriteOff(PurchasePaymentApplyHead byId, List<PurchasePaymentApplyWriteOff> purchasePaymentApplyWriteOffList, SalePaymentApplyHead saleHead) {
        ArrayList<SalePaymentApplyWriteOff> salePaymentApplyWriteOffList = new ArrayList<SalePaymentApplyWriteOff>();
        for (PurchasePaymentApplyWriteOff purchasePaymentApplyWriteOff : purchasePaymentApplyWriteOffList) {
            SalePaymentApplyWriteOff salePaymentApplyWriteOff = new SalePaymentApplyWriteOff();
            BeanUtils.copyProperties((Object)((Object)purchasePaymentApplyWriteOff), (Object)((Object)salePaymentApplyWriteOff));
            salePaymentApplyWriteOff.setId(IdWorker.getIdStr());
            purchasePaymentApplyWriteOff.setRelationId(salePaymentApplyWriteOff.getId());
            salePaymentApplyWriteOff.setHeadId(saleHead.getId());
            salePaymentApplyWriteOff.setRelationId(salePaymentApplyWriteOff.getId());
            salePaymentApplyWriteOff.setElsAccount(byId.getToElsAccount());
            salePaymentApplyWriteOff.setBusAccount(byId.getToElsAccount());
            SysUtil.setSysParam((BaseEntity)salePaymentApplyWriteOff, (BaseEntity)saleHead);
            salePaymentApplyWriteOffList.add(salePaymentApplyWriteOff);
        }
        if (CollectionUtil.isNotEmpty(salePaymentApplyWriteOffList)) {
            salePaymentApplyWriteOffList.forEach(item -> this.salePaymentApplyWriteOffMapper.insert(item));
        }
    }

    private List<SalePaymentApplyItem> insertSalePaymentApplyItem(PurchasePaymentApplyHead byId, List<PurchasePaymentApplyItem> purchasePaymentApplyItems, SalePaymentApplyHead saleHead) {
        ArrayList<SalePaymentApplyItem> saleItemList = new ArrayList<SalePaymentApplyItem>();
        for (PurchasePaymentApplyItem purchaseOrderItem : purchasePaymentApplyItems) {
            SalePaymentApplyItem saleItem = new SalePaymentApplyItem();
            BeanUtils.copyProperties((Object)((Object)purchaseOrderItem), (Object)((Object)saleItem));
            saleItem.setId(IdWorker.getIdStr());
            purchaseOrderItem.setRelationId(saleItem.getId());
            saleItem.setHeadId(saleHead.getId());
            saleItem.setRelationId(purchaseOrderItem.getId());
            saleItem.setElsAccount(byId.getToElsAccount());
            saleItem.setBusAccount(byId.getElsAccount());
            SysUtil.setSysParam((BaseEntity)saleItem, (BaseEntity)saleHead);
            saleItemList.add(saleItem);
        }
        if (CollectionUtil.isNotEmpty(saleItemList)) {
            saleItemList.forEach(item -> this.salePaymentApplyItemMapper.insert(item));
        }
        return saleItemList;
    }

    private void sendMessage(PurchasePaymentApplyHead byId, SalePaymentApplyHead saleHead) {
        String urlParam = "id=" + saleHead.getId();
        if (StringUtils.isNotBlank((CharSequence)byId.getSalePrincipal())) {
            super.sendMsg(byId.getElsAccount(), byId.getToElsAccount(), byId.getSalePrincipal(), (Object)byId, urlParam, "paymentApply", "publish");
        } else {
            super.sendMsg(byId.getElsAccount(), byId.getToElsAccount(), (Object)byId, urlParam, "paymentApply", "publish");
        }
    }

    @Override
    public void cancel(PurchasePaymentApplyHeadVO id) {
        PurchasePaymentApplyHead paymentApplyHead = (PurchasePaymentApplyHead)((Object)this.getById((Serializable)((Object)id.getId())));
        if (paymentApplyHead == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_mxuAPtF_d6b9bdfb", (String)"\u67e5\u4e0d\u5230\u5f53\u524d\u5355\u636e"));
        }
        if (!paymentApplyHead.getPaymentApplyStatus().equals(id.getPaymentApplyStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APtFzEhbHrWVXVSsK_2a0afd21", (String)"\u5f53\u524d\u5355\u636e\u72b6\u6001\u53d1\u751f\u66f4\u6539,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5"));
        }
        this.cancelReleaseAmount(id.getId());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseEntity::getId, (Object)id.getId())).set(PurchasePaymentApplyHead::getPaymentApplyStatus, (Object)PaymentApplyStatusEnum.CANCELLATION.getValue())).update((Object)new PurchasePaymentApplyHead());
        if ("1".equals(paymentApplyHead.getSendStatus())) {
            this.synchr(id);
        }
    }

    @Override
    public void cancelReleaseAmount(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return;
        }
        List<PurchasePaymentApplyItem> purchasePaymentApplyItems = this.purchasePaymentApplyItemService.selectByMainId(id);
        if (CollectionUtils.isEmpty(purchasePaymentApplyItems)) {
            return;
        }
        Map<String, ElsPurchaseStatisticsSourceCase> map = this.getStatisticsSourceMap(purchasePaymentApplyItems);
        ArrayList<ElsPurchaseStatisticsSourceCase> statisticsSourceCaseList = new ArrayList<ElsPurchaseStatisticsSourceCase>();
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItems) {
            Set recordAmount;
            BigDecimal applyAmount = purchasePaymentApplyItem.getApplyAmount() == null ? BigDecimal.ZERO : purchasePaymentApplyItem.getApplyAmount();
            String sourceId = purchasePaymentApplyItem.getSourceId();
            ElsPurchaseStatisticsSourceCase sourceCase = map.get(sourceId);
            if (sourceCase == null) continue;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"used", (Object)0);
            queryWrapper.eq((Object)"source_id", (Object)sourceId);
            queryWrapper.eq((Object)"head_id", (Object)sourceCase.getId());
            List recordList = this.elsPurchaseStatisticsSourceCaseRecordService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isEmpty((Collection)recordList) || CollectionUtils.isEmpty(recordAmount = recordList.stream().filter(record -> record.getAmount() != null).map(ElsPurchaseStatisticsSourceCaseRecord::getAmount).collect(Collectors.toSet())) || !recordAmount.contains(applyAmount)) continue;
            ElsPurchaseStatisticsSourceCaseRecord target = new ElsPurchaseStatisticsSourceCaseRecord();
            for (ElsPurchaseStatisticsSourceCaseRecord record2 : recordList) {
                if (!applyAmount.equals(record2.getAmount())) continue;
                target = record2;
            }
            target.setUsed("1");
            this.elsPurchaseStatisticsSourceCaseRecordService.updateById((Object)target);
            BigDecimal sourcePaymentAmount = sourceCase.getSourcePaymentAmount() == null ? BigDecimal.ZERO : sourceCase.getSourcePaymentAmount();
            sourcePaymentAmount = sourcePaymentAmount.subtract(applyAmount);
            sourceCase.setSourcePaymentAmount(sourcePaymentAmount);
            statisticsSourceCaseList.add(sourceCase);
        }
        if (!CollectionUtils.isEmpty(statisticsSourceCaseList)) {
            this.elsPurchaseStatisticsSourceCaseService.updateBatchById(statisticsSourceCaseList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchasePaymentApplyItemMapper.deleteByMainId(serializable.toString());
            this.purchasePaymentApplyOtherMapper.deleteByMainId(serializable.toString());
            this.purchasePaymentApplyWriteOffMapper.deleteByMainId(serializable.toString());
            this.purchasePaymentChargeMapper.deleteByMainId(serializable.toString());
            this.purchasePaymentApplyHeadMapper.deleteById(serializable);
        }
    }

    @Override
    public Result<?> getBusinessDocuments(PurchasePaymentApplyHead head, Integer pageNo, Integer pageSize) {
        String elsAccount = TenantContext.getTenant();
        head.setElsAccount(elsAccount);
        if (PaymentApplySourceTypeEnum.CONTACT.getValue().equals(head.getSourceType())) {
            IPage<PurchaseContractHeadDTO> contractPage = this.getContact(pageNo, pageSize, head);
            return Result.ok(contractPage);
        }
        if (PaymentApplySourceTypeEnum.ORDER.getValue().equals(head.getSourceType())) {
            IPage<PurchaseOrderItemDTO> orderPage = this.getOrder(pageNo, pageSize, head);
            return Result.ok(orderPage);
        }
        if (PaymentApplySourceTypeEnum.RECONCILIATION.getValue().equals(head.getSourceType())) {
            return this.getReconciliation(pageNo, pageSize, head);
        }
        if (PaymentApplySourceTypeEnum.PERFORMANCE_RECONCILIATION.getValue().equals(head.getSourceType())) {
            return this.getPerformanceReconciliation(pageNo, pageSize, head);
        }
        return null;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void paymentConfirmation(String id) {
        PurchasePaymentApplyHead purchasePaymentApplyHead = (PurchasePaymentApplyHead)((Object)this.purchasePaymentApplyHeadMapper.selectById((Serializable)((Object)id)));
        if (purchasePaymentApplyHead == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_mxuAPtF_d6b9bdfb", (String)"\u67e5\u4e0d\u5230\u5f53\u524d\u5355\u636e"));
        }
        String paymentApplyStatus = purchasePaymentApplyHead.getPaymentApplyStatus();
        if (!PaymentApplyStatusEnum.OUTSTANDING.getValue().equals(paymentApplyStatus) && !PaymentApplyStatusEnum.PARTIAL_PAYMENT.getValue().equals(paymentApplyStatus)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u786e\u8ba4\u652f\u4ed8"));
        }
        purchasePaymentApplyHead.setPaymentApplyStatus(PaymentApplyStatusEnum.HAS_BEEN_PAID.getValue());
        this.purchasePaymentApplyHeadMapper.updateById((Object)purchasePaymentApplyHead);
        List<PurchasePaymentApplyItem> purchasePaymentApplyItems = this.purchasePaymentApplyItemMapper.selectByMainId(id);
        if (CollectionUtils.isEmpty(purchasePaymentApplyItems)) {
            return;
        }
        this.handlePrepayments(purchasePaymentApplyItems, purchasePaymentApplyHead);
        if (!PaymentApplyEnum.PREPAYMENTS.getValue().equals(purchasePaymentApplyHead.getPaymentApplyType())) {
            List<PurchasePaymentApplyWriteOff> writeOffList = this.purchasePaymentApplyWriteOffMapper.selectByMainId(id);
            this.handleWriteOff(writeOffList);
            this.createPurchaseWriteOffRecord(writeOffList);
        } else {
            this.initWriteOff(purchasePaymentApplyItems);
            this.createWaterRecord(id);
        }
    }

    private void createWaterRecord(String id) {
        PurchaseDeliveryWaterDTO purchaseDeliveryWater = new PurchaseDeliveryWaterDTO();
        PurchasePaymentApplyHead newPurchasePaymentApplyHead = (PurchasePaymentApplyHead)((Object)this.purchasePaymentApplyHeadMapper.selectById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)newPurchasePaymentApplyHead), (Object)purchaseDeliveryWater);
        if (!ObjectUtils.isEmpty((Object)purchaseDeliveryWater)) {
            purchaseDeliveryWater.setDocumentNumber(newPurchasePaymentApplyHead.getPaymentApplyNumber());
            purchaseDeliveryWater.setTotalAmount(newPurchasePaymentApplyHead.getPayAmount());
            purchaseDeliveryWater.setCompany(newPurchasePaymentApplyHead.getCompany());
            purchaseDeliveryWater.setToElsAccount(newPurchasePaymentApplyHead.getToElsAccount());
            purchaseDeliveryWater.setDocumentCategory("3");
            purchaseDeliveryWater.setDocumentStatus(newPurchasePaymentApplyHead.getPaymentApplyType());
            purchaseDeliveryWater.setDocumentType("2");
            this.purchaseDeliveryWaterService.insert(purchaseDeliveryWater);
        }
    }

    private void createPurchaseWriteOffRecord(List<PurchasePaymentApplyWriteOff> writeOffList) {
        List purchasePaymentApplyHeadList;
        if (CollectionUtils.isEmpty(writeOffList)) {
            return;
        }
        Set preHeadIds = writeOffList.stream().filter(writeOff -> !StringUtils.isEmpty((CharSequence)writeOff.getPreHeadId())).map(PurchasePaymentApplyWriteOff::getPreHeadId).collect(Collectors.toSet());
        HashMap<String, PurchasePaymentApplyHead> preHeadMap = new HashMap<String, PurchasePaymentApplyHead>();
        if (!CollectionUtils.isEmpty(preHeadIds) && !CollectionUtils.isEmpty((Collection)(purchasePaymentApplyHeadList = this.listByIds(preHeadIds)))) {
            for (PurchasePaymentApplyHead prePaymentApplyHead : purchasePaymentApplyHeadList) {
                preHeadMap.put(prePaymentApplyHead.getId(), prePaymentApplyHead);
            }
        }
        HashMap<String, ReconciliationVO> map = new HashMap<String, ReconciliationVO>();
        this.listPurchaseReconciliation(writeOffList, map);
        this.listPurchasePerformanceReconciliation(writeOffList, map);
        ArrayList<PurchaseWriteOffRecord> recordList = new ArrayList<PurchaseWriteOffRecord>();
        for (PurchasePaymentApplyWriteOff writeOff2 : writeOffList) {
            ReconciliationVO vo;
            PurchaseWriteOffRecord record = new PurchaseWriteOffRecord();
            if (StringUtils.isEmpty((CharSequence)writeOff2.getReconciliationNumber()) || (vo = (ReconciliationVO)map.get(writeOff2.getReconciliationNumber())) == null) continue;
            record.setReconciliationNumber(writeOff2.getReconciliationNumber());
            record.setBeginDate(vo.getBeginDate());
            record.setEndDate(vo.getEndDate());
            record.setHeadId(writeOff2.getHeadId());
            record.setPaymentApplyNumber(writeOff2.getPaymentApplyNumber());
            String preHeadId = writeOff2.getPreHeadId();
            if (!StringUtils.isEmpty((CharSequence)preHeadId) && preHeadMap.get(preHeadId) != null) {
                PurchasePaymentApplyHead paymentApplyHead = (PurchasePaymentApplyHead)((Object)preHeadMap.get(preHeadId));
                record.setHeadId(paymentApplyHead.getId());
                record.setPaymentApplyNumber(paymentApplyHead.getPaymentApplyNumber());
            }
            record.setElsAccount(writeOff2.getElsAccount());
            record.setToElsAccount(writeOff2.getToElsAccount());
            record.setThisWriteOffAmount(writeOff2.getThisWriteOffAmount());
            record.setWriteOffTime(new Date());
            recordList.add(record);
        }
        this.purchaseWriteOffRecordService.saveBatch(recordList);
    }

    private void listPurchaseReconciliation(List<PurchasePaymentApplyWriteOff> writeOffList, Map<String, ReconciliationVO> map) {
        Set reconciliationSourceNumberSet = writeOffList.stream().filter(writeOff -> !StringUtils.isEmpty((CharSequence)writeOff.getReconciliationNumber())).map(PurchasePaymentApplyWriteOff::getReconciliationNumber).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(reconciliationSourceNumberSet)) {
            return;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"reconciliation_number", reconciliationSourceNumberSet);
        wrapper.eq((Object)"is_deleted", (Object)"0");
        List list = this.purchaseReconciliationService.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (PurchaseReconciliation purchaseReconciliation : list) {
            ReconciliationVO vo = new ReconciliationVO();
            BeanUtils.copyProperties((Object)((Object)purchaseReconciliation), (Object)vo);
            map.put(purchaseReconciliation.getReconciliationNumber(), vo);
        }
    }

    private void listPurchasePerformanceReconciliation(List<PurchasePaymentApplyWriteOff> writeOffList, Map<String, ReconciliationVO> map) {
        Set performanceReconciliationSourceNumberSet = writeOffList.stream().filter(writeOff -> !StringUtils.isEmpty((CharSequence)writeOff.getReconciliationNumber())).map(PurchasePaymentApplyWriteOff::getReconciliationNumber).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(performanceReconciliationSourceNumberSet)) {
            return;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.in((Object)"reconciliation_number", performanceReconciliationSourceNumberSet);
        wrapper.eq((Object)"is_deleted", (Object)"0");
        List list = this.purchasePerformanceReconciliationService.list((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (PurchasePerformanceReconciliation purchasePerformanceReconciliation : list) {
            ReconciliationVO vo = new ReconciliationVO();
            BeanUtils.copyProperties((Object)((Object)purchasePerformanceReconciliation), (Object)vo);
            map.put(purchasePerformanceReconciliation.getReconciliationNumber(), vo);
        }
    }

    private void initWriteOff(List<PurchasePaymentApplyItem> purchasePaymentApplyItems) {
        ArrayList<ElsPurchaseStatisticsWriteOff> writeOffList = new ArrayList<ElsPurchaseStatisticsWriteOff>();
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItems) {
            ElsPurchaseStatisticsWriteOff writeOff = new ElsPurchaseStatisticsWriteOff();
            writeOff.setSourceId(purchasePaymentApplyItem.getId());
            BigDecimal applyAmount = purchasePaymentApplyItem.getApplyAmount() == null ? BigDecimal.ZERO : purchasePaymentApplyItem.getApplyAmount();
            writeOff.setSourceUnWrittenOffAmount(applyAmount);
            writeOff.setSourcePayAmount(applyAmount);
            writeOff.setSourceWrittenOffAmount(BigDecimal.ZERO);
            writeOffList.add(writeOff);
        }
        if (!CollectionUtils.isEmpty(writeOffList)) {
            this.elsPurchaseStatisticsWriteOffService.saveBatch(writeOffList);
        }
    }

    private void handleWriteOff(List<PurchasePaymentApplyWriteOff> writeOffList) {
        if (CollectionUtils.isEmpty(writeOffList)) {
            return;
        }
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        for (PurchasePaymentApplyWriteOff writeOff : writeOffList) {
            BigDecimal thisWriteOffAmount;
            BigDecimal bigDecimal = thisWriteOffAmount = writeOff.getThisWriteOffAmount() == null ? BigDecimal.ZERO : writeOff.getThisWriteOffAmount();
            if (StringUtils.isEmpty((CharSequence)writeOff.getBusinessId())) continue;
            BigDecimal amount = map.computeIfAbsent(writeOff.getBusinessId(), applyWriteOff -> BigDecimal.ZERO);
            amount = amount.add(thisWriteOffAmount);
            map.put(writeOff.getBusinessId(), amount);
        }
        this.updateApplyWriteOffInfo(writeOffList, map);
    }

    private void updateApplyWriteOffInfo(List<PurchasePaymentApplyWriteOff> writeOffList, Map<String, BigDecimal> map) {
        HashSet<String> businessId = new HashSet<String>();
        for (PurchasePaymentApplyWriteOff writeOff : writeOffList) {
            businessId.add(writeOff.getBusinessId());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_id", businessId);
        List list = this.elsPurchaseStatisticsWriteOffService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (ElsPurchaseStatisticsWriteOff writeOff : list) {
            BigDecimal thisWriteOffAmount = map.get(writeOff.getSourceId()) == null ? BigDecimal.ZERO : map.get(writeOff.getSourceId());
            BigDecimal applyAmount = writeOff.getSourceApplyAmount() == null ? BigDecimal.ZERO : writeOff.getSourceApplyAmount();
            applyAmount = applyAmount.subtract(thisWriteOffAmount);
            writeOff.setSourceApplyAmount(applyAmount);
            BigDecimal writtenOffAmount = writeOff.getSourceWrittenOffAmount() == null ? BigDecimal.ZERO : writeOff.getSourceWrittenOffAmount();
            writtenOffAmount = writtenOffAmount.add(thisWriteOffAmount);
            writeOff.setSourceWrittenOffAmount(writtenOffAmount);
            BigDecimal sourcePayAmount = writeOff.getSourcePayAmount() == null ? BigDecimal.ZERO : writeOff.getSourcePayAmount();
            BigDecimal unWrittenOffAmount = sourcePayAmount.subtract(writtenOffAmount).subtract(applyAmount);
            writeOff.setSourceUnWrittenOffAmount(unWrittenOffAmount);
        }
        this.elsPurchaseStatisticsWriteOffService.updateBatchById(list);
    }

    private void handlePrepayments(List<PurchasePaymentApplyItem> purchasePaymentApplyItems, PurchasePaymentApplyHead purchasePaymentApplyHead) {
        Map<String, ElsPurchaseStatisticsSourceCase> map = this.getStatisticsSourceMap(purchasePaymentApplyItems);
        ArrayList<ElsPurchaseStatisticsSourceCase> statisticsSourceCaseList = new ArrayList<ElsPurchaseStatisticsSourceCase>();
        HashSet<String> reconciliationSet = new HashSet<String>();
        HashSet<String> performanceReconciliationSet = new HashSet<String>();
        SalePaymentApplyHead salePaymentApplyHead = null;
        ArrayList<SalePaymentApplyItem> salePaymentApplyItemList = new ArrayList();
        if (!StringUtils.isEmpty((CharSequence)purchasePaymentApplyHead.getRelationId())) {
            salePaymentApplyHead = (SalePaymentApplyHead)((Object)this.salePaymentApplyHeadMapper.selectById((Serializable)((Object)purchasePaymentApplyHead.getRelationId())));
            salePaymentApplyItemList = this.salePaymentApplyItemService.selectByMainId(purchasePaymentApplyHead.getRelationId());
        }
        BigDecimal payAmount = BigDecimal.ZERO;
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItems) {
            String sourceId;
            ElsPurchaseStatisticsSourceCase sourceCase;
            BigDecimal applyAmount = purchasePaymentApplyItem.getApplyAmount() == null ? BigDecimal.ZERO : purchasePaymentApplyItem.getApplyAmount();
            purchasePaymentApplyItem.setPayAmount(applyAmount);
            if (applyAmount != null && purchasePaymentApplyItem.getPayAmount() != null) {
                BigDecimal unPayIncludeTaxAmount = applyAmount.subtract(purchasePaymentApplyItem.getPayAmount());
                purchasePaymentApplyItem.setUnPayIncludeTaxAmount(unPayIncludeTaxAmount);
            }
            if ((sourceCase = map.get(sourceId = purchasePaymentApplyItem.getSourceId())) == null) continue;
            BigDecimal sourcePaymentAmount = sourceCase.getSourcePaymentAmount() == null ? BigDecimal.ZERO : sourceCase.getSourcePaymentAmount();
            sourcePaymentAmount = sourcePaymentAmount.subtract(applyAmount);
            sourceCase.setSourcePaymentAmount(sourcePaymentAmount);
            BigDecimal sourcePaidAmount = sourceCase.getSourcePaidAmount() == null ? BigDecimal.ZERO : sourceCase.getSourcePaidAmount();
            sourcePaidAmount = sourcePaidAmount.add(applyAmount);
            sourceCase.setSourcePaidAmount(sourcePaidAmount);
            purchasePaymentApplyItem.setPayAmount(applyAmount);
            purchasePaymentApplyItem.setUnPayIncludeTaxAmount(applyAmount.subtract(purchasePaymentApplyItem.getPayAmount()));
            payAmount = payAmount.add(applyAmount);
            if (PaymentApplySourceTypeEnum.RECONCILIATION.getValue().equals(purchasePaymentApplyItem.getSourceType())) {
                reconciliationSet.add(sourceId);
            } else if (PaymentApplySourceTypeEnum.PERFORMANCE_RECONCILIATION.getValue().equals(purchasePaymentApplyItem.getSourceType())) {
                performanceReconciliationSet.add(sourceId);
            }
            statisticsSourceCaseList.add(sourceCase);
        }
        this.updateReconciliationInfo(map, reconciliationSet);
        this.updatePerformanceReconciliationInfo(map, performanceReconciliationSet);
        HashMap<String, PurchasePaymentApplyItem> itemMap = new HashMap<String, PurchasePaymentApplyItem>();
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItems) {
            itemMap.put(purchasePaymentApplyItem.getId(), purchasePaymentApplyItem);
        }
        if (!CollectionUtils.isEmpty(purchasePaymentApplyItems)) {
            this.purchasePaymentApplyItemService.updateBatchById(purchasePaymentApplyItems);
        }
        if (!CollectionUtils.isEmpty(statisticsSourceCaseList)) {
            this.elsPurchaseStatisticsSourceCaseService.updateBatchById(statisticsSourceCaseList);
        }
        purchasePaymentApplyHead.setPayAmount(payAmount);
        this.updateById((Object)purchasePaymentApplyHead);
        if (salePaymentApplyHead != null) {
            salePaymentApplyHead.setPayAmount(payAmount);
            this.salePaymentApplyHeadService.updateById((Object)salePaymentApplyHead);
        }
        this.handleSalePaymentApplyItemList(salePaymentApplyItemList, itemMap);
    }

    private void handleSalePaymentApplyItemList(List<SalePaymentApplyItem> salePaymentApplyItemList, Map<String, PurchasePaymentApplyItem> itemMap) {
        if (CollectionUtils.isEmpty(salePaymentApplyItemList)) {
            return;
        }
        for (SalePaymentApplyItem salePaymentApplyItem : salePaymentApplyItemList) {
            PurchasePaymentApplyItem purchasePaymentApplyItem;
            String relationId = salePaymentApplyItem.getRelationId();
            if (StringUtils.isEmpty((CharSequence)relationId) || (purchasePaymentApplyItem = itemMap.get(relationId)) == null) continue;
            salePaymentApplyItem.setPayAmount(purchasePaymentApplyItem.getPayAmount());
            salePaymentApplyItem.setUnPayIncludeTaxAmount(purchasePaymentApplyItem.getUnPayIncludeTaxAmount());
            salePaymentApplyItem.setPayAmount(purchasePaymentApplyItem.getPayAmount());
            salePaymentApplyItem.setUnPayIncludeTaxAmount(purchasePaymentApplyItem.getUnPayIncludeTaxAmount());
        }
        this.salePaymentApplyItemService.updateBatchById(salePaymentApplyItemList);
    }

    private void updatePerformanceReconciliationInfo(Map<String, ElsPurchaseStatisticsSourceCase> map, Set<String> reconciliationSet) {
        if (CollectionUtils.isEmpty(reconciliationSet)) {
            return;
        }
        List purchasePerformanceReconciliationList = this.purchasePerformanceReconciliationService.listByIds(reconciliationSet);
        if (CollectionUtils.isEmpty((Collection)purchasePerformanceReconciliationList)) {
            return;
        }
        for (PurchasePerformanceReconciliation purchaseReconciliation : purchasePerformanceReconciliationList) {
            ElsPurchaseStatisticsSourceCase statisticsSourceCase = map.get(purchaseReconciliation.getId());
            if (statisticsSourceCase == null) continue;
            purchaseReconciliation.setPaidAmount(statisticsSourceCase.getSourcePaidAmount());
            BigDecimal settlementAmount = purchaseReconciliation.getSettlementAmount() == null ? BigDecimal.ZERO : purchaseReconciliation.getSettlementAmount();
            purchaseReconciliation.setRemainingUnPaidAmount(settlementAmount.subtract(purchaseReconciliation.getPaidAmount()));
            if (BigDecimal.ZERO.equals(purchaseReconciliation.getPaymentRequestedAmount())) {
                purchaseReconciliation.setPaymentStatus(ReconciliationPaymentStatusEnum.PAID.getValue());
            }
            if (!BigDecimal.ZERO.equals(purchaseReconciliation.getSettlementAmount())) continue;
            purchaseReconciliation.setPaymentStatus(ReconciliationPaymentStatusEnum.NO_PAY.getValue());
        }
        this.purchasePerformanceReconciliationService.updateBatchById(purchasePerformanceReconciliationList);
    }

    private void updateReconciliationInfo(Map<String, ElsPurchaseStatisticsSourceCase> map, Set<String> reconciliationSet) {
        if (CollectionUtils.isEmpty(reconciliationSet)) {
            return;
        }
        List purchaseReconciliations = this.purchaseReconciliationService.listByIds(reconciliationSet);
        if (CollectionUtils.isEmpty((Collection)purchaseReconciliations)) {
            return;
        }
        for (PurchaseReconciliation purchaseReconciliation : purchaseReconciliations) {
            ElsPurchaseStatisticsSourceCase statisticsSourceCase = map.get(purchaseReconciliation.getId());
            if (statisticsSourceCase == null) continue;
            purchaseReconciliation.setPaidAmount(statisticsSourceCase.getSourcePaidAmount());
            BigDecimal settlementAmount = purchaseReconciliation.getSettlementAmount() == null ? BigDecimal.ZERO : purchaseReconciliation.getSettlementAmount();
            purchaseReconciliation.setRemainingUnPaidAmount(settlementAmount.subtract(purchaseReconciliation.getPaidAmount()));
            if (BigDecimal.ZERO.equals(purchaseReconciliation.getRemainingUnPaidAmount())) {
                purchaseReconciliation.setPaymentStatus(ReconciliationPaymentStatusEnum.PAID.getValue());
            }
            if (!BigDecimal.ZERO.equals(purchaseReconciliation.getSettlementAmount())) continue;
            purchaseReconciliation.setPaymentStatus(ReconciliationPaymentStatusEnum.NO_PAY.getValue());
        }
        this.purchaseReconciliationService.updateBatchById(purchaseReconciliations);
    }

    private Result<?> getReconciliation(Integer pageNo, Integer pageSize, PurchasePaymentApplyHead head) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        wrapper.eq((Object)"to_els_account", (Object)head.getToElsAccount());
        if (!StringUtils.isEmpty((CharSequence)head.getPayWay())) {
            wrapper.eq((Object)"pay_way", (Object)head.getPayWay());
        }
        if (!StringUtils.isEmpty((CharSequence)head.getPaymentClause())) {
            wrapper.eq((Object)"payment_clause", (Object)head.getPaymentClause());
        }
        if (!StringUtils.isEmpty((CharSequence)head.getCompany())) {
            wrapper.eq((Object)"company", (Object)head.getCompany());
        }
        if (!StringUtils.isEmpty((CharSequence)head.getPurchaseOrg())) {
            wrapper.eq((Object)"purchase_org", (Object)head.getPurchaseOrg());
        }
        if (!StringUtils.isEmpty((CharSequence)head.getKeyWord())) {
            wrapper.eq((Object)"reconciliation_number", (Object)head.getKeyWord());
        }
        wrapper.eq((Object)"is_deleted", (Object)"0");
        wrapper.gt((Object)"settlement_amount", (Object)0);
        wrapper.gt((Object)"remaining_un_paid_amount", (Object)0);
        wrapper.and(q -> ((QueryWrapper)((QueryWrapper)q.eq((Object)"sale_rec_affirm_status", (Object)"2")).or()).eq((Object)"reconciliation_status", (Object)"2"));
        Page page1 = (Page)this.purchaseReconciliationService.page((IPage)page, (Wrapper)wrapper);
        List records = page1.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            Result.ok((Object)page1);
        }
        this.elsPurchaseStatisticsSourceCaseService.handleReconciliationStatisticsInfo(records);
        return Result.ok((Object)page1);
    }

    private Result<?> getPerformanceReconciliation(Integer pageNo, Integer pageSize, PurchasePaymentApplyHead head) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        wrapper.eq((Object)"to_els_account", (Object)head.getToElsAccount());
        if (!StringUtils.isEmpty((CharSequence)head.getPayWay())) {
            wrapper.eq((Object)"pay_way", (Object)head.getPayWay());
        }
        if (!StringUtils.isEmpty((CharSequence)head.getPaymentClause())) {
            wrapper.eq((Object)"payment_clause", (Object)head.getPaymentClause());
        }
        if (!StringUtils.isEmpty((CharSequence)head.getCompany())) {
            wrapper.eq((Object)"company", (Object)head.getCompany());
        }
        if (!StringUtils.isEmpty((CharSequence)head.getPurchaseOrg())) {
            wrapper.eq((Object)"purchase_org", (Object)head.getPurchaseOrg());
        }
        if (!StringUtils.isEmpty((CharSequence)head.getKeyWord())) {
            wrapper.eq((Object)"reconciliation_number", (Object)head.getKeyWord());
        }
        wrapper.eq((Object)"is_deleted", (Object)"0");
        wrapper.gt((Object)"settlement_amount", (Object)0);
        wrapper.gt((Object)"remaining_un_paid_amount", (Object)0);
        wrapper.and(q -> ((QueryWrapper)((QueryWrapper)q.eq((Object)"sale_rec_affirm_status", (Object)"2")).or()).eq((Object)"reconciliation_status", (Object)"2"));
        page = (Page)this.purchasePerformanceReconciliationService.page((IPage)page, (Wrapper)wrapper);
        List records = page.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            Result.ok((Object)page);
        }
        this.elsPurchaseStatisticsSourceCaseService.handlePurchasePerformanceReconciliationStatisticsInfo(records);
        return Result.ok((Object)page);
    }

    public IPage<PurchaseContractHeadDTO> getContact(Integer pageNo, Integer pageSize, PurchasePaymentApplyHead head) {
        IPage<PurchaseContractHeadDTO> purchaseContractHeadDTOIPage = this.financeInvokeContractRpcService.listContractItem(pageNo, pageSize, head.getElsAccount(), head.getToElsAccount(), head.getCompany(), head.getPurchaseOrg(), head.getPayWay(), head.getPaymentClause(), head.getKeyWord());
        List records = purchaseContractHeadDTOIPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return purchaseContractHeadDTOIPage;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (PurchaseContractHeadDTO record : records) {
            idSet.add(record.getId());
        }
        Map<String, ElsPurchaseStatisticsSourceCase> map = this.getElsPurchaseStatisticsSourceCaseMap(idSet);
        for (PurchaseContractHeadDTO record : records) {
            ElsPurchaseStatisticsSourceCase sourceCase = map.get(record.getId());
            if (sourceCase == null) continue;
            record.setSourcePaidAmount(sourceCase.getSourcePaidAmount());
            record.setSourcePaymentAmount(sourceCase.getSourcePaymentAmount());
        }
        return purchaseContractHeadDTOIPage;
    }

    public IPage<PurchaseOrderItemDTO> getOrder(Integer pageNo, Integer pageSize, PurchasePaymentApplyHead head) {
        IPage<PurchaseOrderItemDTO> purchaseOrderItemDTOIPage = this.financeInvokeOrderRpcService.listOrderItem(pageNo, pageSize, head.getElsAccount(), head.getToElsAccount(), head.getCompany(), head.getPurchaseOrg(), head.getPayWay(), head.getPaymentClause(), head.getKeyWord());
        List records = purchaseOrderItemDTOIPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return purchaseOrderItemDTOIPage;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (PurchaseOrderItemDTO record : records) {
            idSet.add(record.getId());
        }
        Map<String, ElsPurchaseStatisticsSourceCase> map = this.getElsPurchaseStatisticsSourceCaseMap(idSet);
        for (PurchaseOrderItemDTO record : records) {
            ElsPurchaseStatisticsSourceCase sourceCase = map.get(record.getId());
            if (sourceCase == null) continue;
            record.setSourcePaidAmount(sourceCase.getSourcePaidAmount());
            record.setSourcePaymentAmount(sourceCase.getSourcePaymentAmount());
        }
        return purchaseOrderItemDTOIPage;
    }

    private Map<String, ElsPurchaseStatisticsSourceCase> getElsPurchaseStatisticsSourceCaseMap(Set<String> idSet) {
        HashMap<String, ElsPurchaseStatisticsSourceCase> map = new HashMap<String, ElsPurchaseStatisticsSourceCase>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_id", idSet);
        List list = this.elsPurchaseStatisticsSourceCaseService.list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (ElsPurchaseStatisticsSourceCase sourceCase : list) {
                map.put(sourceCase.getSourceId(), sourceCase);
            }
        }
        return map;
    }

    @Override
    public void copyData(String id) {
        PurchasePaymentApplyHead purchasePaymentApplyHead = (PurchasePaymentApplyHead)((Object)this.purchasePaymentApplyHeadMapper.selectById((Serializable)((Object)id)));
        if (purchasePaymentApplyHead == null) {
            return;
        }
        PurchasePaymentApplyHead newPaymentApplyHead = new PurchasePaymentApplyHead();
        newPaymentApplyHead.setToElsAccount(purchasePaymentApplyHead.getToElsAccount());
        newPaymentApplyHead.setSupplierName(purchasePaymentApplyHead.getSupplierName());
        newPaymentApplyHead.setPurchaseName(purchasePaymentApplyHead.getPurchaseName());
        newPaymentApplyHead.setPaymentApplyType(purchasePaymentApplyHead.getPaymentApplyType());
        newPaymentApplyHead.setPaymentApplyDate(purchasePaymentApplyHead.getPaymentApplyDate());
        newPaymentApplyHead.setCompany(purchasePaymentApplyHead.getCompany());
        newPaymentApplyHead.setPurchaseOrg(purchasePaymentApplyHead.getPurchaseOrg());
        newPaymentApplyHead.setReceiverBankAccount(purchasePaymentApplyHead.getReceiverBankAccount());
        newPaymentApplyHead.setReceiverBank(purchasePaymentApplyHead.getReceiverBank());
        newPaymentApplyHead.setReceiverBankBccountName(purchasePaymentApplyHead.getReceiverBankBccountName());
        newPaymentApplyHead.setCurrency(purchasePaymentApplyHead.getCurrency());
        newPaymentApplyHead.setStandardCoin(purchasePaymentApplyHead.getStandardCoin());
        newPaymentApplyHead.setExchangeRate(purchasePaymentApplyHead.getExchangeRate());
        newPaymentApplyHead.setPayWay(purchasePaymentApplyHead.getPayWay());
        newPaymentApplyHead.setPaymentClause(purchasePaymentApplyHead.getPaymentClause());
        newPaymentApplyHead.setPaymentBenchmarkDate(purchasePaymentApplyHead.getPaymentBenchmarkDate());
        newPaymentApplyHead.setStretegyCode(purchasePaymentApplyHead.getStretegyCode());
        newPaymentApplyHead.setPurchasePrincipal(purchasePaymentApplyHead.getPurchasePrincipal());
        newPaymentApplyHead.setSalePrincipal(purchasePaymentApplyHead.getSalePrincipal());
        newPaymentApplyHead.setApplyExplain(purchasePaymentApplyHead.getApplyExplain());
        newPaymentApplyHead.setTemplateNumber(purchasePaymentApplyHead.getTemplateNumber());
        newPaymentApplyHead.setTemplateVersion(purchasePaymentApplyHead.getTemplateVersion());
        newPaymentApplyHead.setTemplateAccount(purchasePaymentApplyHead.getTemplateAccount());
        newPaymentApplyHead.setTemplateName(purchasePaymentApplyHead.getTemplateName());
        this.saveMain(newPaymentApplyHead, new PurchasePaymentApplyHeadVO());
    }
}

