/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.reconciliation.entity.SaleInvoice;
import com.els.modules.reconciliation.entity.SalePerformanceReconciliation;
import com.els.modules.reconciliation.entity.SalePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.entity.SaleRecCharge;
import com.els.modules.reconciliation.entity.SaleRecContractAcceptance;
import com.els.modules.reconciliation.entity.SaleRecContractPromise;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffService;
import com.els.modules.reconciliation.service.SaleInvoiceService;
import com.els.modules.reconciliation.service.SalePerformanceReconciliationService;
import com.els.modules.reconciliation.service.SalePrePaymentWriteOffReconciliationService;
import com.els.modules.reconciliation.service.SaleRecChargeService;
import com.els.modules.reconciliation.service.SaleRecContractAcceptanceService;
import com.els.modules.reconciliation.service.SaleRecContractPromiseService;
import com.els.modules.reconciliation.vo.SalePerformanceReconciliationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5c65\u7ea6\u5bf9\u8d26\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/reconciliation/salePerformanceReconciliation"})
public class SalePerformanceReconciliationController
extends BaseController<SalePerformanceReconciliation, SalePerformanceReconciliationService> {
    private static final Logger log = LoggerFactory.getLogger(SalePerformanceReconciliationController.class);
    @Autowired
    private SalePerformanceReconciliationService salePerformanceReconciliationService;
    @Autowired
    private SaleRecChargeService saleRecChargeService;
    @Autowired
    private SaleInvoiceService saleInvoiceService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private SaleRecContractPromiseService saleRecContractPromiseService;
    @Autowired
    private SaleRecContractAcceptanceService saleRecContractAcceptanceService;
    @Autowired
    private SalePrePaymentWriteOffReconciliationService salePrePaymentWriteOffReconciliationService;
    @Autowired
    private ElsPurchaseStatisticsWriteOffService elsPurchaseStatisticsWriteOffService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SalePerformanceReconciliation salePerformanceReconciliation, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)salePerformanceReconciliation), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.salePerformanceReconciliationService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u5c65\u7ea6\u5bf9\u8d26\u7ba1\u7406-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"reconciliation#salePerformanceReconciliation:add"})
    public Result<?> add(@RequestBody SalePerformanceReconciliationVO salePerformanceReconciliationVO) {
        SalePerformanceReconciliation saleReconciliation = new SalePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)salePerformanceReconciliationVO), (Object)((Object)saleReconciliation));
        this.salePerformanceReconciliationService.saveMain(saleReconciliation, salePerformanceReconciliationVO);
        return Result.ok((Object)((Object)saleReconciliation));
    }

    @AutoLog(value="\u5c65\u7ea6\u5bf9\u8d26\u7ba1\u7406-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"reconciliation#salePerformanceReconciliation:edit"})
    public Result<?> edit(@RequestBody SalePerformanceReconciliationVO salePerformanceReconciliationVO) {
        SalePerformanceReconciliation saleReconciliation = new SalePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)salePerformanceReconciliationVO), (Object)((Object)saleReconciliation));
        this.salePerformanceReconciliationService.updateMain(saleReconciliation, salePerformanceReconciliationVO);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5c65\u7ea6\u5bf9\u8d26\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"reconciliation#salePerformanceReconciliation:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.salePerformanceReconciliationService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u5c65\u7ea6\u5bf9\u8d26\u7ba1\u7406-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.salePerformanceReconciliationService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"reconciliation#salePerformanceReconciliation:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        SalePerformanceReconciliationVO vo = new SalePerformanceReconciliationVO();
        SalePerformanceReconciliation salePerformanceReconciliation = (SalePerformanceReconciliation)((Object)this.salePerformanceReconciliationService.getById((Serializable)((Object)id)));
        if (salePerformanceReconciliation == null) {
            return Result.ok((Object)((Object)vo));
        }
        BeanUtils.copyProperties((Object)((Object)salePerformanceReconciliation), (Object)((Object)vo));
        List<SaleRecContractPromise> saleRecContractPromiseListList = this.saleRecContractPromiseService.selectByMainId(id);
        vo.setSaleRecContractPromiseList(saleRecContractPromiseListList);
        List<SaleRecContractAcceptance> saleRecContractAcceptanceList = this.saleRecContractAcceptanceService.selectByMainId(id);
        vo.setSaleRecContractAcceptanceList(saleRecContractAcceptanceList);
        List<SaleRecCharge> saleRecChargeList = this.saleRecChargeService.selectByMainId(id);
        vo.setSaleRecChargeList(saleRecChargeList);
        List<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffList = this.salePrePaymentWriteOffReconciliationService.selectByMainId(id);
        this.elsPurchaseStatisticsWriteOffService.handleSalePrePaymentWriteOffList(salePrePaymentWriteOffList);
        vo.setSalePrePaymentWriteOffReconciliationList(salePrePaymentWriteOffList);
        List<SaleInvoice> saleInvoiceList = this.saleInvoiceService.selectByMainId(id);
        vo.setSaleInvoiceList(saleInvoiceList);
        List attachments = this.invokeBaseRpcService.selectSaleAttachmentByMainId(id);
        vo.setAttachments(attachments);
        return Result.ok((Object)((Object)vo));
    }

    @AutoLog(value="\u9500\u552e\u5bf9\u8d26\u5934-\u9500\u552e\u786e\u8ba4")
    @ApiOperation(value="\u9500\u552e\u786e\u8ba4", notes="\u9500\u552e\u786e\u8ba4")
    @PostMapping(value={"/confirm"})
    public Result<?> confirm(@RequestBody SalePerformanceReconciliationVO saleReconciliationPage) {
        SalePerformanceReconciliation salePerformanceReconciliation = new SalePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)saleReconciliationPage), (Object)((Object)salePerformanceReconciliation));
        this.salePerformanceReconciliationService.confirmOrRefused(salePerformanceReconciliation, "confirm");
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u9500\u552e\u5bf9\u8d26\u5934-\u53d1\u7968\u4fdd\u5b58", logType=2)
    @ApiOperation(value="\u53d1\u7968\u4fdd\u5b58", notes="\u53d1\u7968\u4fdd\u5b58")
    @PostMapping(value={"/saveInvoice"})
    public Result<?> saveInvoice(@RequestBody SalePerformanceReconciliationVO saleReconciliationPage) {
        SalePerformanceReconciliation salePerformanceReconciliation = new SalePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)saleReconciliationPage), (Object)((Object)salePerformanceReconciliation));
        this.salePerformanceReconciliationService.saveInvoice(salePerformanceReconciliation, saleReconciliationPage.getSaleInvoiceList(), "save");
        return Result.ok((Object)((Object)salePerformanceReconciliation));
    }

    @AutoLog(value="\u9500\u552e\u5bf9\u8d26\u5934-\u53d1\u7968\u53d1\u9001", logType=2)
    @ApiOperation(value="\u53d1\u7968\u53d1\u9001", notes="\u53d1\u7968\u53d1\u9001")
    @PostMapping(value={"/sendInvoice"})
    public Result<?> sendInvoice(@RequestBody SalePerformanceReconciliationVO saleReconciliationPage) {
        SalePerformanceReconciliation salePerformanceReconciliation = new SalePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)saleReconciliationPage), (Object)((Object)salePerformanceReconciliation));
        this.salePerformanceReconciliationService.sendInvoice(salePerformanceReconciliation, saleReconciliationPage.getSaleInvoiceList());
        return Result.ok((Object)((Object)salePerformanceReconciliation));
    }

    @AutoLog(value="\u9500\u552e\u5bf9\u8d26\u5934-\u9500\u552e\u62d2\u7edd")
    @ApiOperation(value="\u9500\u552e\u62d2\u7edd", notes="\u9500\u552e\u62d2\u7edd")
    @PostMapping(value={"/refuesd"})
    public Result<?> refuesd(@RequestBody SalePerformanceReconciliationVO saleReconciliationPage) {
        SalePerformanceReconciliation salePerformanceReconciliation = new SalePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)saleReconciliationPage), (Object)((Object)salePerformanceReconciliation));
        this.salePerformanceReconciliationService.confirmOrRefused(salePerformanceReconciliation, "refused");
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u9500\u552e\u5bf9\u8d26\u5934-\u90ae\u4ef6\u786e\u8ba4/\u62d2\u7edd")
    @ApiOperation(value="\u9500\u552e\u786e\u8ba4/\u62d2\u7edd", notes="\u9500\u552e\u786e\u8ba4/\u62d2\u7edd")
    @GetMapping(value={"/emailConfirmOrRefuesd"})
    public Result<?> emailConfirmOrRefuesd(@RequestParam(name="operation") String operation, @RequestParam(name="id") String id) {
        this.salePerformanceReconciliationService.emailConfirmOrRefuesd(id, operation);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9500\u552e\u5bf9\u8d26-\u63d0\u53d6\u5bf9\u8d26\u5355", logType=2)
    @ApiOperation(value="\u63d0\u53d6\u5bf9\u8d26\u5355", notes="\u63d0\u53d6\u5bf9\u8d26\u5355")
    @PostMapping(value={"/extractReconciliation"})
    public Result<?> extractReconciliation(@RequestBody SalePerformanceReconciliationVO saleReconciliationVO) {
        return Result.ok((Object)((Object)this.salePerformanceReconciliationService.extractReconciliation(saleReconciliationVO)));
    }

    @AutoLog(value="\u5bf9\u8d26\u5934-\u53d1\u5e03", logType=2)
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"reconciliation#salePerformanceReconciliation:publish"})
    public Result<?> publish(@RequestBody SalePerformanceReconciliationVO saleReconciliationVO) {
        SalePerformanceReconciliation salePerformanceReconciliation = new SalePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)saleReconciliationVO), (Object)((Object)salePerformanceReconciliation));
        return this.salePerformanceReconciliationService.publish(salePerformanceReconciliation, saleReconciliationVO);
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    public Result<?> counts(SalePerformanceReconciliation salePerformanceReconciliation, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)salePerformanceReconciliation), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"reconciliation_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"reconciliation_status");
        List list = ((SalePerformanceReconciliationService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SalePerformanceReconciliation::getReconciliationStatus, SalePerformanceReconciliation::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "reconciliationStatus", null, all));
        List srmReconciliationStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmReconciliationStatus", TenantContext.getTenant());
        for (DictDTO status : srmReconciliationStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "reconciliationStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

