/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.modules.finance.entity.PurchasePrePaymentWriteOffReconciliation;
import com.els.modules.finance.service.PurchasePrePaymentWriteOffReconciliationService;
import com.els.modules.reconciliation.entity.ElsPurchaseStatisticsWriteOff;
import com.els.modules.reconciliation.entity.ElsPurchaseStatisticsWriteOffRecord;
import com.els.modules.reconciliation.entity.SalePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.mapper.ElsPurchaseStatisticsWriteOffMapper;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffRecordService;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffService;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ElsPurchaseStatisticsWriteOffServiceImpl
extends BaseServiceImpl<ElsPurchaseStatisticsWriteOffMapper, ElsPurchaseStatisticsWriteOff>
implements ElsPurchaseStatisticsWriteOffService {
    private static final Logger log = LoggerFactory.getLogger(ElsPurchaseStatisticsWriteOffServiceImpl.class);
    @Autowired
    private PurchasePrePaymentWriteOffReconciliationService purchasePrePaymentWriteOffReconciliationService;
    @Autowired
    private ElsPurchaseStatisticsWriteOffRecordService elsPurchaseStatisticsWriteOffRecordService;

    @Override
    public void saveelsPurchaseStatisticsWriteOff(ElsPurchaseStatisticsWriteOff elsPurchaseStatisticsWriteOff) {
        ((ElsPurchaseStatisticsWriteOffMapper)this.baseMapper).insert((Object)elsPurchaseStatisticsWriteOff);
    }

    @Override
    public void updateelsPurchaseStatisticsWriteOff(ElsPurchaseStatisticsWriteOff elsPurchaseStatisticsWriteOff) {
        ((ElsPurchaseStatisticsWriteOffMapper)this.baseMapper).updateById((Object)elsPurchaseStatisticsWriteOff);
    }

    @Override
    public void delelsPurchaseStatisticsWriteOff(String id) {
        ((ElsPurchaseStatisticsWriteOffMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchelsPurchaseStatisticsWriteOff(List<String> idList) {
        ((ElsPurchaseStatisticsWriteOffMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void cancelReleaseAmountByPurchase(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return;
        }
        List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList = this.purchasePrePaymentWriteOffReconciliationService.selectByMainId(id);
        if (CollectionUtils.isEmpty(purchasePrePaymentWriteOffList)) {
            return;
        }
        this.cancelReleaseAmount(purchasePrePaymentWriteOffList);
    }

    @Override
    public void cancelReleaseAmountBySale(String purchaseHeadId, String elsAccount, String toElsAccount) {
        List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList = this.purchasePrePaymentWriteOffReconciliationService.selectFromSale(purchaseHeadId, elsAccount, toElsAccount);
        this.cancelReleaseAmount(purchasePrePaymentWriteOffList);
    }

    private void cancelReleaseAmount(List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList) {
        Map<String, ElsPurchaseStatisticsWriteOff> map = this.getStatisticsWriteOffMap(purchasePrePaymentWriteOffList);
        ArrayList<ElsPurchaseStatisticsWriteOff> elsPurchaseStatisticsWriteOffList = new ArrayList<ElsPurchaseStatisticsWriteOff>();
        for (PurchasePrePaymentWriteOffReconciliation prePaymentWriteOff : purchasePrePaymentWriteOffList) {
            Set recordAmount;
            BigDecimal thisWriteOffAmount = prePaymentWriteOff.getThisWriteOffAmount() == null ? BigDecimal.ZERO : prePaymentWriteOff.getThisWriteOffAmount();
            String businessId = prePaymentWriteOff.getBusinessId();
            ElsPurchaseStatisticsWriteOff writeOff = map.get(businessId);
            if (writeOff == null) continue;
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"used", (Object)0);
            queryWrapper.eq((Object)"source_id", (Object)businessId);
            queryWrapper.eq((Object)"head_id", (Object)writeOff.getId());
            List recordList = this.elsPurchaseStatisticsWriteOffRecordService.list((Wrapper)queryWrapper);
            if (CollectionUtils.isEmpty((Collection)recordList) || CollectionUtils.isEmpty(recordAmount = recordList.stream().filter(record -> record.getAmount() != null).map(ElsPurchaseStatisticsWriteOffRecord::getAmount).collect(Collectors.toSet())) || !recordAmount.contains(thisWriteOffAmount)) continue;
            ElsPurchaseStatisticsWriteOffRecord target = new ElsPurchaseStatisticsWriteOffRecord();
            for (ElsPurchaseStatisticsWriteOffRecord record2 : recordList) {
                if (!thisWriteOffAmount.equals(record2.getAmount())) continue;
                target = record2;
            }
            target.setUsed("1");
            this.elsPurchaseStatisticsWriteOffRecordService.updateById((Object)target);
            BigDecimal applyAmount = writeOff.getSourceApplyAmount() == null ? BigDecimal.ZERO : writeOff.getSourceApplyAmount();
            applyAmount = applyAmount.subtract(thisWriteOffAmount);
            writeOff.setSourceApplyAmount(applyAmount);
            BigDecimal sourceWrittenOffAmount = writeOff.getSourceWrittenOffAmount() == null ? BigDecimal.ZERO : writeOff.getSourceWrittenOffAmount();
            BigDecimal sourcePayAmount = writeOff.getSourcePayAmount() == null ? BigDecimal.ZERO : writeOff.getSourcePayAmount();
            BigDecimal sourceUnWrittenOffAmount = sourcePayAmount.subtract(sourceWrittenOffAmount).subtract(applyAmount);
            writeOff.setSourceUnWrittenOffAmount(sourceUnWrittenOffAmount);
            elsPurchaseStatisticsWriteOffList.add(writeOff);
        }
        if (!CollectionUtils.isEmpty(elsPurchaseStatisticsWriteOffList)) {
            this.updateBatchById(elsPurchaseStatisticsWriteOffList);
        }
    }

    @Override
    public void writeOffAmountOccupy(ReconciliationVO reconciliationVO, List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffReconciliationList) {
        BigDecimal writtenOffAmount;
        ArrayList<ElsPurchaseStatisticsWriteOff> list = new ArrayList<ElsPurchaseStatisticsWriteOff>();
        Map<String, ElsPurchaseStatisticsWriteOff> map = this.getStatisticsWriteOffMap(purchasePrePaymentWriteOffReconciliationList);
        this.saveStatisticsWriteOff(purchasePrePaymentWriteOffReconciliationList, list, map);
        BigDecimal closingAmount = reconciliationVO.getClosingAmount() == null ? BigDecimal.ZERO : reconciliationVO.getClosingAmount();
        String tips = this.checkOverAmount(purchasePrePaymentWriteOffReconciliationList, closingAmount, map);
        if (!StringUtils.isEmpty((CharSequence)tips)) {
            throw new ELSBootException("\u7b2c " + tips + " \u884c\u672c\u6b21\u6838\u9500\u91d1\u989d\u5927\u4e8e\u672a\u6838\u9500\u91d1\u989d");
        }
        BigDecimal bigDecimal = writtenOffAmount = reconciliationVO.getWrittenOffAmount() == null ? BigDecimal.ZERO : reconciliationVO.getWrittenOffAmount();
        if (closingAmount.compareTo(writtenOffAmount) < 0) {
            throw new ELSBootException("\u9884\u4ed8\u6838\u9500\u603b\u989d\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\uff0c\u8bf7\u4fee\u6539\u6838\u9500\u91d1\u989d");
        }
        this.updateWriteOff(list);
    }

    @Override
    public void handlePrePaymentWriteOffList(List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList) {
        if (CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (PurchasePrePaymentWriteOffReconciliation prePaymentWriteOff : prePaymentWriteOffList) {
            idSet.add(prePaymentWriteOff.getBusinessId());
        }
        HashMap<String, ElsPurchaseStatisticsWriteOff> map = new HashMap<String, ElsPurchaseStatisticsWriteOff>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_id", idSet);
        List list = this.list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (ElsPurchaseStatisticsWriteOff elsPurchaseStatisticsWriteOff : list) {
                map.put(elsPurchaseStatisticsWriteOff.getSourceId(), elsPurchaseStatisticsWriteOff);
            }
        }
        for (PurchasePrePaymentWriteOffReconciliation prePaymentWriteOff : prePaymentWriteOffList) {
            ElsPurchaseStatisticsWriteOff writeOff;
            String businessId = prePaymentWriteOff.getBusinessId();
            if (StringUtils.isEmpty((CharSequence)businessId) || (writeOff = (ElsPurchaseStatisticsWriteOff)((Object)map.get(businessId))) == null) continue;
            prePaymentWriteOff.setUnWrittenOffAmount(writeOff.getSourceUnWrittenOffAmount());
            prePaymentWriteOff.setWrittenOffAmount(writeOff.getSourceWrittenOffAmount());
        }
    }

    @Override
    public void handleSalePrePaymentWriteOffList(List<SalePrePaymentWriteOffReconciliation> prePaymentWriteOffList) {
        if (CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        for (SalePrePaymentWriteOffReconciliation prePaymentWriteOff : prePaymentWriteOffList) {
            idSet.add(prePaymentWriteOff.getBusinessId());
        }
        HashMap<String, ElsPurchaseStatisticsWriteOff> map = new HashMap<String, ElsPurchaseStatisticsWriteOff>();
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_id", idSet);
        List list = this.list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (ElsPurchaseStatisticsWriteOff elsPurchaseStatisticsWriteOff : list) {
                map.put(elsPurchaseStatisticsWriteOff.getSourceId(), elsPurchaseStatisticsWriteOff);
            }
        }
        for (SalePrePaymentWriteOffReconciliation prePaymentWriteOff : prePaymentWriteOffList) {
            ElsPurchaseStatisticsWriteOff writeOff;
            String businessId = prePaymentWriteOff.getBusinessId();
            if (StringUtils.isEmpty((CharSequence)businessId) || (writeOff = (ElsPurchaseStatisticsWriteOff)((Object)map.get(businessId))) == null) continue;
            prePaymentWriteOff.setUnWrittenOffAmount(writeOff.getSourceUnWrittenOffAmount());
            prePaymentWriteOff.setWrittenOffAmount(writeOff.getSourceWrittenOffAmount());
        }
    }

    @Override
    public Map<String, ElsPurchaseStatisticsWriteOff> getStatisticsSourceMap(Set<String> businessIds) {
        HashMap<String, ElsPurchaseStatisticsWriteOff> writeOffMap = new HashMap<String, ElsPurchaseStatisticsWriteOff>();
        if (CollectionUtils.isEmpty(businessIds)) {
            return writeOffMap;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(ElsPurchaseStatisticsWriteOff::getSourceId, businessIds);
        List list = this.list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (ElsPurchaseStatisticsWriteOff writeOff : list) {
                writeOffMap.put(writeOff.getSourceId(), writeOff);
            }
        }
        return writeOffMap;
    }

    private Map<String, ElsPurchaseStatisticsWriteOff> getStatisticsWriteOffMap(List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffReconciliationList) {
        HashMap<String, ElsPurchaseStatisticsWriteOff> map = new HashMap<String, ElsPurchaseStatisticsWriteOff>();
        Set businessIds = purchasePrePaymentWriteOffReconciliationList.stream().map(PurchasePrePaymentWriteOffReconciliation::getBusinessId).collect(Collectors.toSet());
        if (CollectionUtil.isEmpty(businessIds)) {
            return map;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_id", businessIds);
        List list = this.list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (ElsPurchaseStatisticsWriteOff elsPurchaseStatisticsWriteOff : list) {
                map.put(elsPurchaseStatisticsWriteOff.getSourceId(), elsPurchaseStatisticsWriteOff);
            }
        }
        return map;
    }

    private void saveStatisticsWriteOff(List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffReconciliationList, List<ElsPurchaseStatisticsWriteOff> list, Map<String, ElsPurchaseStatisticsWriteOff> map) {
        ArrayList<ElsPurchaseStatisticsWriteOffRecord> recordList = new ArrayList<ElsPurchaseStatisticsWriteOffRecord>();
        for (PurchasePrePaymentWriteOffReconciliation prePaymentWriteOffReconciliation : purchasePrePaymentWriteOffReconciliationList) {
            if (prePaymentWriteOffReconciliation.getThisWriteOffAmount() == null || StringUtils.isEmpty((CharSequence)prePaymentWriteOffReconciliation.getBusinessId())) continue;
            ElsPurchaseStatisticsWriteOff writeOff = map.get(prePaymentWriteOffReconciliation.getBusinessId());
            if (writeOff == null) {
                writeOff = new ElsPurchaseStatisticsWriteOff();
                writeOff.setId(IdWorker.getIdStr());
                writeOff.setSourceId(prePaymentWriteOffReconciliation.getBusinessId());
                writeOff.setSourcePayAmount(prePaymentWriteOffReconciliation.getPayAmount());
            }
            BigDecimal applyAmount = writeOff.getSourceApplyAmount() == null ? BigDecimal.ZERO : writeOff.getSourceApplyAmount();
            applyAmount = applyAmount.add(prePaymentWriteOffReconciliation.getThisWriteOffAmount());
            writeOff.setSourceApplyAmount(applyAmount);
            ElsPurchaseStatisticsWriteOffRecord record = new ElsPurchaseStatisticsWriteOffRecord();
            record.setHeadId(writeOff.getId());
            record.setAmount(prePaymentWriteOffReconciliation.getThisWriteOffAmount());
            record.setSourceId(prePaymentWriteOffReconciliation.getBusinessId());
            recordList.add(record);
            list.add(writeOff);
        }
        if (!CollectionUtils.isEmpty(list)) {
            this.saveOrUpdateBatch(list);
            for (ElsPurchaseStatisticsWriteOff elsPurchaseStatisticsWriteOff : list) {
                map.put(elsPurchaseStatisticsWriteOff.getSourceId(), elsPurchaseStatisticsWriteOff);
            }
        }
        if (!CollectionUtils.isEmpty(recordList)) {
            this.elsPurchaseStatisticsWriteOffRecordService.saveBatch(recordList);
        }
    }

    private String checkOverAmount(List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffReconciliationList, BigDecimal closingAmount, Map<String, ElsPurchaseStatisticsWriteOff> map) {
        closingAmount = closingAmount == null ? BigDecimal.ZERO : closingAmount;
        StringJoiner tips = new StringJoiner(",");
        for (PurchasePrePaymentWriteOffReconciliation prePaymentWriteOffReconciliation : purchasePrePaymentWriteOffReconciliationList) {
            ElsPurchaseStatisticsWriteOff writeOff;
            BigDecimal thisWriteOffAmount = prePaymentWriteOffReconciliation.getThisWriteOffAmount();
            if (thisWriteOffAmount == null || (writeOff = map.get(prePaymentWriteOffReconciliation.getBusinessId())) == null) continue;
            BigDecimal sourceUnWrittenOffAmount = writeOff.getSourceUnWrittenOffAmount() == null ? BigDecimal.ZERO : writeOff.getSourceUnWrittenOffAmount();
            BigDecimal min = sourceUnWrittenOffAmount.min(closingAmount);
            if (BigDecimal.ZERO.compareTo(sourceUnWrittenOffAmount) == 0) {
                min = closingAmount;
            }
            if (BigDecimal.ZERO.compareTo(closingAmount) == 0) {
                min = sourceUnWrittenOffAmount;
            }
            log.error("thisWriteOffAmount: {} , closingAmount: {}, sourceUnWrittenOffAmount: {}", new Object[]{thisWriteOffAmount, closingAmount, sourceUnWrittenOffAmount});
            if (min.compareTo(thisWriteOffAmount) >= 0 || StringUtils.isEmpty((CharSequence)prePaymentWriteOffReconciliation.getItemNumber())) continue;
            log.error("checkOverAmount : thisWriteOffAmount, {}", (Object)thisWriteOffAmount);
            tips.add(prePaymentWriteOffReconciliation.getItemNumber());
        }
        return tips.toString();
    }

    private void updateWriteOff(List<ElsPurchaseStatisticsWriteOff> list) {
        ArrayList<ElsPurchaseStatisticsWriteOff> writeOffList = new ArrayList<ElsPurchaseStatisticsWriteOff>();
        for (ElsPurchaseStatisticsWriteOff writeOff : list) {
            BigDecimal applyAmount = writeOff.getSourceApplyAmount() == null ? BigDecimal.ZERO : writeOff.getSourceApplyAmount();
            BigDecimal sourceWrittenOffAmount = writeOff.getSourceWrittenOffAmount() == null ? BigDecimal.ZERO : writeOff.getSourceWrittenOffAmount();
            BigDecimal sourcePayAmount = writeOff.getSourcePayAmount() == null ? BigDecimal.ZERO : writeOff.getSourcePayAmount();
            BigDecimal sourceUnWrittenOffAmount = sourcePayAmount.subtract(sourceWrittenOffAmount).subtract(applyAmount);
            writeOff.setSourceUnWrittenOffAmount(sourceUnWrittenOffAmount);
            writeOffList.add(writeOff);
        }
        this.saveOrUpdateBatch(list);
    }
}

