/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.PropertyNamingStrategy;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.config.mybatis.TenantContext;
import com.els.enumerate.ElsInterfaceParams;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.reconciliation.entity.InvoiceOcrData;
import com.els.modules.reconciliation.entity.InvoiceOcrDataEight;
import com.els.modules.reconciliation.entity.InvoiceOcrDataEleven;
import com.els.modules.reconciliation.entity.InvoiceOcrDataFive;
import com.els.modules.reconciliation.entity.InvoiceOcrDataFour;
import com.els.modules.reconciliation.entity.InvoiceOcrDataFourteen;
import com.els.modules.reconciliation.entity.InvoiceOcrDataNine;
import com.els.modules.reconciliation.entity.InvoiceOcrDataOne;
import com.els.modules.reconciliation.entity.InvoiceOcrDataSeven;
import com.els.modules.reconciliation.entity.InvoiceOcrDataSix;
import com.els.modules.reconciliation.entity.InvoiceOcrDataTen;
import com.els.modules.reconciliation.entity.InvoiceOcrDataThirteen;
import com.els.modules.reconciliation.entity.InvoiceOcrDataThree;
import com.els.modules.reconciliation.entity.InvoiceOcrDataTwelve;
import com.els.modules.reconciliation.entity.InvoiceOcrDataTwo;
import com.els.modules.reconciliation.entity.InvoiceProductData;
import com.els.modules.reconciliation.enumerate.InvoiceTypeToClass;
import com.els.modules.reconciliation.mapper.InvoiceOcrDataEightMapper;
import com.els.modules.reconciliation.mapper.InvoiceOcrDataElevenMapper;
import com.els.modules.reconciliation.mapper.InvoiceOcrDataFiveMapper;
import com.els.modules.reconciliation.mapper.InvoiceOcrDataFourMapper;
import com.els.modules.reconciliation.mapper.InvoiceOcrDataFourteenMapper;
import com.els.modules.reconciliation.mapper.InvoiceOcrDataMapper;
import com.els.modules.reconciliation.mapper.InvoiceOcrDataNineMapper;
import com.els.modules.reconciliation.mapper.InvoiceOcrDataOneMapper;
import com.els.modules.reconciliation.mapper.InvoiceOcrDataSevenMapper;
import com.els.modules.reconciliation.mapper.InvoiceOcrDataSixMapper;
import com.els.modules.reconciliation.mapper.InvoiceOcrDataTenMapper;
import com.els.modules.reconciliation.mapper.InvoiceOcrDataThirteenMapper;
import com.els.modules.reconciliation.mapper.InvoiceOcrDataThreeMapper;
import com.els.modules.reconciliation.mapper.InvoiceOcrDataTwelveMapper;
import com.els.modules.reconciliation.mapper.InvoiceOcrDataTwoMapper;
import com.els.modules.reconciliation.mapper.InvoiceProductDataMapper;
import com.els.modules.reconciliation.rpc.ReconciliationInvokeBaseService;
import com.els.modules.reconciliation.service.InvoiceOcrDataService;
import com.els.modules.reconciliation.vo.InvoiceOcrDataVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class InvoiceOcrDataServiceImpl
extends BaseServiceImpl<InvoiceOcrDataMapper, InvoiceOcrData>
implements InvoiceOcrDataService {
    private static final Logger log = LoggerFactory.getLogger(InvoiceOcrDataServiceImpl.class);
    @Resource
    private ReconciliationInvokeBaseService reconciliationInvokeBaseService;
    @Resource
    private InvoiceOcrDataMapper invoiceOcrDataMapper;
    @Resource
    private InvoiceOcrDataOneMapper invoiceOcrDataOneMapper;
    @Resource
    private InvoiceOcrDataTwoMapper invoiceOcrDataTwoMapper;
    @Resource
    private InvoiceOcrDataThreeMapper invoiceOcrDataThreeMapper;
    @Resource
    private InvoiceOcrDataFourMapper invoiceOcrDataFourMapper;
    @Resource
    private InvoiceOcrDataFiveMapper invoiceOcrDataFiveMapper;
    @Resource
    private InvoiceOcrDataSixMapper invoiceOcrDataSixMapper;
    @Resource
    private InvoiceOcrDataEightMapper invoiceOcrDataEightMapper;
    @Resource
    private InvoiceOcrDataNineMapper invoiceOcrDataNineMapper;
    @Resource
    private InvoiceOcrDataTenMapper invoiceOcrDataTenMapper;
    @Resource
    private InvoiceOcrDataElevenMapper invoiceOcrDataElevenMapper;
    @Resource
    private InvoiceOcrDataTwelveMapper invoiceOcrDataTwelveMapper;
    @Resource
    private InvoiceOcrDataThirteenMapper invoiceOcrDataThirteenMapper;
    @Resource
    private InvoiceOcrDataFourteenMapper invoiceOcrDataFourteenMapper;
    @Resource
    private InvoiceProductDataMapper invoiceProductDataMapper;
    @Resource
    private InvoiceOcrDataSevenMapper invoiceOcrDataSevenMapper;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Value(value="${els.config.service.address}")
    private String address;
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(InvoiceOcrData invoiceOcrData, List<InvoiceOcrDataOne> invoiceOcrDataOneList, List<InvoiceOcrDataTwo> invoiceOcrDataTwoList, List<InvoiceOcrDataThree> invoiceOcrDataThreeList, List<InvoiceOcrDataFour> invoiceOcrDataFourList, List<InvoiceOcrDataFive> invoiceOcrDataFiveList, List<InvoiceOcrDataSix> invoiceOcrDataSixList, List<InvoiceOcrDataEight> invoiceOcrDataEightList, List<InvoiceOcrDataNine> invoiceOcrDataNineList, List<InvoiceOcrDataTen> invoiceOcrDataTenList, List<InvoiceOcrDataEleven> invoiceOcrDataElevenList, List<InvoiceOcrDataTwelve> invoiceOcrDataTwelveList, List<InvoiceOcrDataThirteen> invoiceOcrDataThirteenList, List<InvoiceOcrDataFourteen> invoiceOcrDataFourteenList, List<InvoiceProductData> invoiceProductDataList, List<InvoiceOcrDataSeven> invoiceOcrDataSevenList) {
        if (StringUtils.isEmpty((CharSequence)invoiceOcrData.getElsAccount())) {
            invoiceOcrData.setElsAccount(TenantContext.getTenant());
        }
        this.invoiceOcrDataMapper.insert((Object)invoiceOcrData);
        this.insertData(invoiceOcrData, invoiceOcrDataOneList, invoiceOcrDataTwoList, invoiceOcrDataThreeList, invoiceOcrDataFourList, invoiceOcrDataFiveList, invoiceOcrDataSixList, invoiceOcrDataEightList, invoiceOcrDataNineList, invoiceOcrDataTenList, invoiceOcrDataElevenList, invoiceOcrDataTwelveList, invoiceOcrDataThirteenList, invoiceOcrDataFourteenList, invoiceProductDataList, invoiceOcrDataSevenList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(InvoiceOcrData invoiceOcrData, List<InvoiceOcrDataOne> invoiceOcrDataOneList, List<InvoiceOcrDataTwo> invoiceOcrDataTwoList, List<InvoiceOcrDataThree> invoiceOcrDataThreeList, List<InvoiceOcrDataFour> invoiceOcrDataFourList, List<InvoiceOcrDataFive> invoiceOcrDataFiveList, List<InvoiceOcrDataSix> invoiceOcrDataSixList, List<InvoiceOcrDataEight> invoiceOcrDataEightList, List<InvoiceOcrDataNine> invoiceOcrDataNineList, List<InvoiceOcrDataTen> invoiceOcrDataTenList, List<InvoiceOcrDataEleven> invoiceOcrDataElevenList, List<InvoiceOcrDataTwelve> invoiceOcrDataTwelveList, List<InvoiceOcrDataThirteen> invoiceOcrDataThirteenList, List<InvoiceOcrDataFourteen> invoiceOcrDataFourteenList, List<InvoiceProductData> invoiceProductDataList, List<InvoiceOcrDataSeven> invoiceOcrDataSevenList) {
        this.invoiceOcrDataMapper.updateById((Object)invoiceOcrData);
        this.invoiceOcrDataOneMapper.deleteByMainId(invoiceOcrData.getId());
        this.invoiceOcrDataTwoMapper.deleteByMainId(invoiceOcrData.getId());
        this.invoiceOcrDataThreeMapper.deleteByMainId(invoiceOcrData.getId());
        this.invoiceOcrDataFourMapper.deleteByMainId(invoiceOcrData.getId());
        this.invoiceOcrDataFiveMapper.deleteByMainId(invoiceOcrData.getId());
        this.invoiceOcrDataSixMapper.deleteByMainId(invoiceOcrData.getId());
        this.invoiceOcrDataEightMapper.deleteByMainId(invoiceOcrData.getId());
        this.invoiceOcrDataNineMapper.deleteByMainId(invoiceOcrData.getId());
        this.invoiceOcrDataTenMapper.deleteByMainId(invoiceOcrData.getId());
        this.invoiceOcrDataElevenMapper.deleteByMainId(invoiceOcrData.getId());
        this.invoiceOcrDataTwelveMapper.deleteByMainId(invoiceOcrData.getId());
        this.invoiceOcrDataThirteenMapper.deleteByMainId(invoiceOcrData.getId());
        this.invoiceOcrDataFourteenMapper.deleteByMainId(invoiceOcrData.getId());
        this.invoiceProductDataMapper.deleteByMainId(invoiceOcrData.getId());
        this.invoiceOcrDataSevenMapper.deleteByMainId(invoiceOcrData.getId());
        this.insertData(invoiceOcrData, invoiceOcrDataOneList, invoiceOcrDataTwoList, invoiceOcrDataThreeList, invoiceOcrDataFourList, invoiceOcrDataFiveList, invoiceOcrDataSixList, invoiceOcrDataEightList, invoiceOcrDataNineList, invoiceOcrDataTenList, invoiceOcrDataElevenList, invoiceOcrDataTwelveList, invoiceOcrDataThirteenList, invoiceOcrDataFourteenList, invoiceProductDataList, invoiceOcrDataSevenList);
    }

    private void insertData(InvoiceOcrData invoiceOcrData, List<InvoiceOcrDataOne> invoiceOcrDataOneList, List<InvoiceOcrDataTwo> invoiceOcrDataTwoList, List<InvoiceOcrDataThree> invoiceOcrDataThreeList, List<InvoiceOcrDataFour> invoiceOcrDataFourList, List<InvoiceOcrDataFive> invoiceOcrDataFiveList, List<InvoiceOcrDataSix> invoiceOcrDataSixList, List<InvoiceOcrDataEight> invoiceOcrDataEightList, List<InvoiceOcrDataNine> invoiceOcrDataNineList, List<InvoiceOcrDataTen> invoiceOcrDataTenList, List<InvoiceOcrDataEleven> invoiceOcrDataElevenList, List<InvoiceOcrDataTwelve> invoiceOcrDataTwelveList, List<InvoiceOcrDataThirteen> invoiceOcrDataThirteenList, List<InvoiceOcrDataFourteen> invoiceOcrDataFourteenList, List<InvoiceProductData> invoiceProductDataList, List<InvoiceOcrDataSeven> invoiceOcrDataSevenList) {
        if (!CollectionUtils.isEmpty(invoiceOcrDataOneList)) {
            for (InvoiceOcrDataOne invoiceOcrDataOne : invoiceOcrDataOneList) {
                invoiceOcrDataOne.setHeadId(invoiceOcrData.getId());
                SysUtil.setSysParam((BaseEntity)invoiceOcrDataOne, (BaseEntity)invoiceOcrData);
            }
            if (!invoiceOcrDataOneList.isEmpty()) {
                this.invoiceOcrDataOneMapper.insertBatchSomeColumn(invoiceOcrDataOneList);
            }
        }
        if (!CollectionUtils.isEmpty(invoiceOcrDataTwoList)) {
            for (InvoiceOcrDataTwo invoiceOcrDataTwo : invoiceOcrDataTwoList) {
                invoiceOcrDataTwo.setHeadId(invoiceOcrData.getId());
                SysUtil.setSysParam((BaseEntity)invoiceOcrDataTwo, (BaseEntity)invoiceOcrData);
            }
            if (!invoiceOcrDataTwoList.isEmpty()) {
                this.invoiceOcrDataTwoMapper.insertBatchSomeColumn(invoiceOcrDataTwoList);
            }
        }
        if (!CollectionUtils.isEmpty(invoiceOcrDataThreeList)) {
            for (InvoiceOcrDataThree invoiceOcrDataThree : invoiceOcrDataThreeList) {
                invoiceOcrDataThree.setHeadId(invoiceOcrData.getId());
                SysUtil.setSysParam((BaseEntity)invoiceOcrDataThree, (BaseEntity)invoiceOcrData);
            }
            if (!invoiceOcrDataThreeList.isEmpty()) {
                this.invoiceOcrDataThreeMapper.insertBatchSomeColumn(invoiceOcrDataThreeList);
            }
        }
        if (!CollectionUtils.isEmpty(invoiceOcrDataFourList)) {
            for (InvoiceOcrDataFour invoiceOcrDataFour : invoiceOcrDataFourList) {
                invoiceOcrDataFour.setHeadId(invoiceOcrData.getId());
                SysUtil.setSysParam((BaseEntity)invoiceOcrDataFour, (BaseEntity)invoiceOcrData);
            }
            if (!invoiceOcrDataFourList.isEmpty()) {
                this.invoiceOcrDataFourMapper.insertBatchSomeColumn(invoiceOcrDataFourList);
            }
        }
        if (!CollectionUtils.isEmpty(invoiceOcrDataFiveList)) {
            for (InvoiceOcrDataFive invoiceOcrDataFive : invoiceOcrDataFiveList) {
                invoiceOcrDataFive.setHeadId(invoiceOcrData.getId());
                SysUtil.setSysParam((BaseEntity)invoiceOcrDataFive, (BaseEntity)invoiceOcrData);
            }
            if (!invoiceOcrDataFiveList.isEmpty()) {
                this.invoiceOcrDataFiveMapper.insertBatchSomeColumn(invoiceOcrDataFiveList);
            }
        }
        if (!CollectionUtils.isEmpty(invoiceOcrDataSixList)) {
            for (InvoiceOcrDataSix invoiceOcrDataSix : invoiceOcrDataSixList) {
                invoiceOcrDataSix.setHeadId(invoiceOcrData.getId());
                SysUtil.setSysParam((BaseEntity)invoiceOcrDataSix, (BaseEntity)invoiceOcrData);
            }
            if (!invoiceOcrDataSixList.isEmpty()) {
                this.invoiceOcrDataSixMapper.insertBatchSomeColumn(invoiceOcrDataSixList);
            }
        }
        if (!CollectionUtils.isEmpty(invoiceOcrDataEightList)) {
            for (InvoiceOcrDataEight invoiceOcrDataEight : invoiceOcrDataEightList) {
                invoiceOcrDataEight.setHeadId(invoiceOcrData.getId());
                SysUtil.setSysParam((BaseEntity)invoiceOcrDataEight, (BaseEntity)invoiceOcrData);
            }
            if (!invoiceOcrDataEightList.isEmpty()) {
                this.invoiceOcrDataEightMapper.insertBatchSomeColumn(invoiceOcrDataEightList);
            }
        }
        if (!CollectionUtils.isEmpty(invoiceOcrDataNineList)) {
            for (InvoiceOcrDataNine invoiceOcrDataNine : invoiceOcrDataNineList) {
                invoiceOcrDataNine.setHeadId(invoiceOcrData.getId());
                SysUtil.setSysParam((BaseEntity)invoiceOcrDataNine, (BaseEntity)invoiceOcrData);
            }
            if (!invoiceOcrDataNineList.isEmpty()) {
                this.invoiceOcrDataNineMapper.insertBatchSomeColumn(invoiceOcrDataNineList);
            }
        }
        if (!CollectionUtils.isEmpty(invoiceOcrDataTenList)) {
            for (InvoiceOcrDataTen invoiceOcrDataTen : invoiceOcrDataTenList) {
                invoiceOcrDataTen.setHeadId(invoiceOcrData.getId());
                SysUtil.setSysParam((BaseEntity)invoiceOcrDataTen, (BaseEntity)invoiceOcrData);
            }
            if (!invoiceOcrDataTenList.isEmpty()) {
                this.invoiceOcrDataTenMapper.insertBatchSomeColumn(invoiceOcrDataTenList);
            }
        }
        if (!CollectionUtils.isEmpty(invoiceOcrDataElevenList)) {
            for (InvoiceOcrDataEleven invoiceOcrDataEleven : invoiceOcrDataElevenList) {
                invoiceOcrDataEleven.setHeadId(invoiceOcrData.getId());
                SysUtil.setSysParam((BaseEntity)invoiceOcrDataEleven, (BaseEntity)invoiceOcrData);
            }
            if (!invoiceOcrDataElevenList.isEmpty()) {
                this.invoiceOcrDataElevenMapper.insertBatchSomeColumn(invoiceOcrDataElevenList);
            }
        }
        if (!CollectionUtils.isEmpty(invoiceOcrDataTwelveList)) {
            for (InvoiceOcrDataTwelve invoiceOcrDataTwelve : invoiceOcrDataTwelveList) {
                invoiceOcrDataTwelve.setHeadId(invoiceOcrData.getId());
                SysUtil.setSysParam((BaseEntity)invoiceOcrDataTwelve, (BaseEntity)invoiceOcrData);
            }
            if (!invoiceOcrDataTwelveList.isEmpty()) {
                this.invoiceOcrDataTwelveMapper.insertBatchSomeColumn(invoiceOcrDataTwelveList);
            }
        }
        if (!CollectionUtils.isEmpty(invoiceOcrDataThirteenList)) {
            for (InvoiceOcrDataThirteen invoiceOcrDataThirteen : invoiceOcrDataThirteenList) {
                invoiceOcrDataThirteen.setHeadId(invoiceOcrData.getId());
                SysUtil.setSysParam((BaseEntity)invoiceOcrDataThirteen, (BaseEntity)invoiceOcrData);
            }
            if (!invoiceOcrDataThirteenList.isEmpty()) {
                this.invoiceOcrDataThirteenMapper.insertBatchSomeColumn(invoiceOcrDataThirteenList);
            }
        }
        if (!CollectionUtils.isEmpty(invoiceOcrDataFourteenList)) {
            for (InvoiceOcrDataFourteen invoiceOcrDataFourteen : invoiceOcrDataFourteenList) {
                invoiceOcrDataFourteen.setHeadId(invoiceOcrData.getId());
                SysUtil.setSysParam((BaseEntity)invoiceOcrDataFourteen, (BaseEntity)invoiceOcrData);
            }
            if (!invoiceOcrDataFourteenList.isEmpty()) {
                this.invoiceOcrDataFourteenMapper.insertBatchSomeColumn(invoiceOcrDataFourteenList);
            }
        }
        if (!CollectionUtils.isEmpty(invoiceProductDataList)) {
            for (InvoiceProductData invoiceProductData : invoiceProductDataList) {
                invoiceProductData.setHeadId(invoiceOcrData.getId());
                SysUtil.setSysParam((BaseEntity)invoiceProductData, (BaseEntity)invoiceOcrData);
            }
            if (!invoiceProductDataList.isEmpty()) {
                this.invoiceProductDataMapper.insertBatchSomeColumn(invoiceProductDataList);
            }
        }
        if (!CollectionUtils.isEmpty(invoiceOcrDataSevenList)) {
            for (InvoiceOcrDataSeven invoiceOcrDataSeven : invoiceOcrDataSevenList) {
                invoiceOcrDataSeven.setHeadId(invoiceOcrData.getId());
                SysUtil.setSysParam((BaseEntity)invoiceOcrDataSeven, (BaseEntity)invoiceOcrData);
            }
            if (!invoiceOcrDataSevenList.isEmpty()) {
                this.invoiceOcrDataSevenMapper.insertBatchSomeColumn(invoiceOcrDataSevenList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.invoiceOcrDataOneMapper.deleteByMainId(id);
        this.invoiceOcrDataTwoMapper.deleteByMainId(id);
        this.invoiceOcrDataThreeMapper.deleteByMainId(id);
        this.invoiceOcrDataFourMapper.deleteByMainId(id);
        this.invoiceOcrDataFiveMapper.deleteByMainId(id);
        this.invoiceOcrDataSixMapper.deleteByMainId(id);
        this.invoiceOcrDataEightMapper.deleteByMainId(id);
        this.invoiceOcrDataNineMapper.deleteByMainId(id);
        this.invoiceOcrDataTenMapper.deleteByMainId(id);
        this.invoiceOcrDataElevenMapper.deleteByMainId(id);
        this.invoiceOcrDataTwelveMapper.deleteByMainId(id);
        this.invoiceOcrDataThirteenMapper.deleteByMainId(id);
        this.invoiceOcrDataFourteenMapper.deleteByMainId(id);
        this.invoiceProductDataMapper.deleteByMainId(id);
        this.invoiceOcrDataSevenMapper.deleteByMainId(id);
        this.invoiceOcrDataMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.invoiceOcrDataOneMapper.deleteByMainId(serializable.toString());
            this.invoiceOcrDataTwoMapper.deleteByMainId(serializable.toString());
            this.invoiceOcrDataThreeMapper.deleteByMainId(serializable.toString());
            this.invoiceOcrDataFourMapper.deleteByMainId(serializable.toString());
            this.invoiceOcrDataFiveMapper.deleteByMainId(serializable.toString());
            this.invoiceOcrDataSixMapper.deleteByMainId(serializable.toString());
            this.invoiceOcrDataEightMapper.deleteByMainId(serializable.toString());
            this.invoiceOcrDataNineMapper.deleteByMainId(serializable.toString());
            this.invoiceOcrDataTenMapper.deleteByMainId(serializable.toString());
            this.invoiceOcrDataElevenMapper.deleteByMainId(serializable.toString());
            this.invoiceOcrDataTwelveMapper.deleteByMainId(serializable.toString());
            this.invoiceOcrDataThirteenMapper.deleteByMainId(serializable.toString());
            this.invoiceOcrDataFourteenMapper.deleteByMainId(serializable.toString());
            this.invoiceProductDataMapper.deleteByMainId(serializable.toString());
            this.invoiceOcrDataSevenMapper.deleteByMainId(serializable.toString());
            this.invoiceOcrDataMapper.deleteById(serializable);
        }
    }

    @Override
    public void invoiceVerification(List<InvoiceOcrData> invoiceOcrDataList) {
        if (CollectionUtil.isEmpty(invoiceOcrDataList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VNhPLV_a85ebd3c", (String)"\u4f20\u5165\u53d1\u7968\u4e3a\u7a7a"));
        }
        ArrayList strings = new ArrayList();
        try {
            if (!CollectionUtil.isEmpty(invoiceOcrDataList)) {
                for (InvoiceOcrData invoiceOcrData : invoiceOcrDataList) {
                    HashMap<String, String> paramInterface = new HashMap<String, String>();
                    JSONObject data = this.checkAndParameterAssemble(invoiceOcrData.getId());
                    paramInterface.put("data", data.toJSONString());
                    paramInterface.put("interfaceCode", this.invokeBaseRpcService.getIpaasInterfaceCode("invoice-verification"));
                    String s = this.reconciliationInvokeBaseService.invoiceVerification(paramInterface);
                    JSONObject jsonObject = JSONObject.parseObject((String)s);
                    if (jsonObject.getBoolean("success").booleanValue()) {
                        JSONObject result = jsonObject.getJSONObject("data");
                        Integer resultInteger = result.getInteger("code");
                        if (Objects.equals(resultInteger, ElsInterfaceParams.SUCCESS_CODE)) {
                            JSONObject object = result.getJSONObject("result");
                            invoiceOcrData.setCheckData(object.toJSONString());
                            invoiceOcrData.setCheckStatu(object.getString("code"));
                            invoiceOcrData.setCheckMsg(object.getString("msg"));
                            invoiceOcrData.setInvalidMark(object.getString("invalid_mark"));
                            continue;
                        }
                        throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_hPOiKmW_c3c7487a", (String)"\u53d1\u7968\u9a8c\u8bc1\u5931\u8d25:") + result.getString("message"));
                    }
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_yVDjKmW_328c4ae3", (String)"\u63a5\u53e3\u8c03\u7528\u5931\u8d25:") + jsonObject.getString("message"));
                }
                this.updateBatchById(invoiceOcrDataList);
            }
        }
        catch (Exception e) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_hPObKmW_ba66385c", (String)"\u53d1\u7968\u9a8c\u771f\u5931\u8d25:") + e.getMessage());
        }
    }

    private JSONObject checkAndParameterAssemble(String id) throws ParseException {
        JSONObject data = new JSONObject();
        InvoiceOcrData byId = (InvoiceOcrData)((Object)this.getById((Serializable)((Object)id)));
        InvoiceTypeToClass invoiceTypeToClass = new InvoiceTypeToClass();
        if (invoiceTypeToClass.getInvoiceVerification().contains(byId.getInvoiceType())) {
            String invoiceType = byId.getInvoiceType();
            if (invoiceTypeToClass.getOne().contains(invoiceType)) {
                List<InvoiceOcrDataOne> invoiceOcrDataOneList = this.invoiceOcrDataOneMapper.selectByMainId(id);
                InvoiceOcrDataOne invoiceOcrDataOne = invoiceOcrDataOneList.get(0);
                data.put("invoice_code", (Object)invoiceOcrDataOne.getVatInvoiceDaima());
                data.put("invoice_no", (Object)invoiceOcrDataOne.getVatInvoiceHaoma());
                String vatInvoiceIssueDate = invoiceOcrDataOne.getVatInvoiceIssueDate();
                Date invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                String dateformat = DateUtils.formatDate((Date)invoiceDate, (String)"yyyyMMdd");
                data.put("invoice_date", (Object)dateformat);
                if (invoiceTypeToClass.getInvoiceVerifyCode().contains(invoiceType)) {
                    String vatInvoiceCorrectCode = invoiceOcrDataOne.getVatInvoiceCorrectCode();
                    data.put("verify_code", (Object)vatInvoiceCorrectCode.substring(vatInvoiceCorrectCode.length() - 6));
                }
                if (invoiceTypeToClass.getInvoiceNetSum().contains(invoiceType)) {
                    String vatInvoiceTotal = invoiceOcrDataOne.getVatInvoiceTotal();
                    data.put("invoice_sum", (Object)vatInvoiceTotal);
                }
            } else if (invoiceTypeToClass.getTwo().contains(invoiceType)) {
                List<InvoiceOcrDataTwo> invoiceOcrDataTwoList = this.invoiceOcrDataTwoMapper.selectByMainId(id);
                InvoiceOcrDataTwo invoiceOcrDataTwo = invoiceOcrDataTwoList.get(0);
                data.put("invoice_code", (Object)invoiceOcrDataTwo.getVehicleInvoiceDaima());
                data.put("invoice_no", (Object)invoiceOcrDataTwo.getVehicleInvoiceHaoma());
                String vatInvoiceIssueDate = invoiceOcrDataTwo.getVehicleInvoiceIssueDate();
                Date invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                String dateformat = DateUtils.formatDate((Date)invoiceDate, (String)"yyyyMMdd");
                data.put("invoice_date", (Object)dateformat);
                String withoutTax = invoiceOcrDataTwo.getVehicleInvoicePriceWithoutTax();
                data.put("invoice_sum", (Object)withoutTax);
            } else if (invoiceTypeToClass.getThree().contains(invoiceType)) {
                List<InvoiceOcrDataThree> invoiceOcrDataThreeList = this.invoiceOcrDataThreeMapper.selectByMainId(id);
                InvoiceOcrDataThree invoiceOcrDataThree = invoiceOcrDataThreeList.get(0);
                data.put("invoice_code", (Object)invoiceOcrDataThree.getVehicleInvoiceDaima());
                data.put("invoice_no", (Object)invoiceOcrDataThree.getVehicleInvoiceHaoma());
                String vatInvoiceIssueDate = invoiceOcrDataThree.getVehicleInvoiceIssueDate();
                Date invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                String dateformat = DateUtils.formatDate((Date)invoiceDate, (String)"yyyyMMdd");
                data.put("invoice_date", (Object)dateformat);
                String totalPrice = invoiceOcrDataThree.getVehicleInvoicePriceTotalPrice();
                data.put("invoice_sum", (Object)totalPrice);
            } else if (invoiceTypeToClass.getFour().contains(invoiceType)) {
                List<InvoiceOcrDataFour> invoiceOcrDataFourList = this.invoiceOcrDataFourMapper.selectByMainId(id);
                InvoiceOcrDataFour invoiceOcrDataFour = invoiceOcrDataFourList.get(0);
                data.put("invoice_code", (Object)invoiceOcrDataFour.getInvoiceCode());
                data.put("invoice_no", (Object)invoiceOcrDataFour.getInvoiceNumber());
                String vatInvoiceIssueDate = invoiceOcrDataFour.getDateOfInvoice();
                Date invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                String dateformat = DateUtils.formatDate((Date)invoiceDate, (String)"yyyyMMdd");
                data.put("invoice_date", (Object)dateformat);
                String checkNumber = invoiceOcrDataFour.getCheckNumber();
                data.put("verify_code", (Object)checkNumber.substring(checkNumber.length() - 6));
            } else if ("vat_transport_invoice".equals(invoiceType)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_rhPIPHRuzAWPSyREKq_4c0f9f91", (String)"\u8be5\u53d1\u7968\u76ee\u524d\u4ec5\u652f\u6301\u5206\u7c7b,\u6682\u65e0\u7ed3\u6784\u5316\u8bc6\u522b"));
            }
        } else {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_mshPxKObvLC_3c735e26", (String)"\u6b64\u79cd\u53d1\u7968\u4e0d\u5728\u9a8c\u771f\u8303\u56f4\u5185"));
        }
        return data;
    }

    @Override
    public void invoiceOCR(List<InvoiceOcrData> invoiceOcrDataList) {
        if (CollectionUtil.isEmpty(invoiceOcrDataList)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VNhPQInRLV_3a9dfc1b", (String)"\u4f20\u5165\u53d1\u7968\u6587\u4ef6\u5730\u5740\u4e3a\u7a7a"));
        }
        List list = invoiceOcrDataList.parallelStream().map(BaseEntity::getId).collect(Collectors.toList());
        List attachmentDTOS = this.invokeBaseRpcService.listPurchaseFiles(list);
        log.info(this.invokeBaseRpcService + "\u5df2\u8fdb\u5165\u67e5\u8be2:" + attachmentDTOS);
        ArrayList strings = new ArrayList();
        try {
            if (!CollectionUtil.isEmpty((Collection)attachmentDTOS)) {
                attachmentDTOS.forEach(item -> strings.add(this.getSignature(item.getSaveType(), item.getFilePath())));
                for (PurchaseAttachmentDTO attachmentDTO : attachmentDTOS) {
                    String signature = this.getSignature(attachmentDTO.getSaveType(), attachmentDTO.getFilePath());
                    HashMap<String, String> interfaceMap = new HashMap<String, String>();
                    interfaceMap.put("filePath", signature);
                    interfaceMap.put("interfaceCode", this.invokeBaseRpcService.getIpaasInterfaceCode("invoice-ocr"));
                    String s = this.reconciliationInvokeBaseService.invoiceOCR(interfaceMap);
                    JSONObject jsonObject = JSONObject.parseObject((String)s);
                    if (jsonObject.getBoolean("success").booleanValue()) {
                        InvoiceOcrDataVO invoiceOcrDataVO = this.resultToOCRData(new InvoiceOcrData(), jsonObject);
                        invoiceOcrDataVO.setUploadSubAccount(attachmentDTO.getUploadSubAccount());
                        invoiceOcrDataVO.setUploadElsAccount(attachmentDTO.getUploadElsAccount());
                        invoiceOcrDataVO.setFileName(attachmentDTO.getFileName());
                        invoiceOcrDataVO.setFileId(attachmentDTO.getId());
                        invoiceOcrDataVO.setFilePath(signature);
                        invoiceOcrDataVO.setFileSize(attachmentDTO.getFileSize());
                        invoiceOcrDataVO.setFileType(attachmentDTO.getFileType());
                        invoiceOcrDataVO.setData(jsonObject.toJSONString());
                        InvoiceOcrData ocrData = new InvoiceOcrData();
                        BeanUtils.copyProperties((Object)((Object)invoiceOcrDataVO), (Object)((Object)ocrData));
                        this.saveMain(ocrData, invoiceOcrDataVO.getInvoiceOcrDataOneList(), invoiceOcrDataVO.getInvoiceOcrDataTwoList(), invoiceOcrDataVO.getInvoiceOcrDataThreeList(), invoiceOcrDataVO.getInvoiceOcrDataFourList(), invoiceOcrDataVO.getInvoiceOcrDataFiveList(), invoiceOcrDataVO.getInvoiceOcrDataSixList(), invoiceOcrDataVO.getInvoiceOcrDataEightList(), invoiceOcrDataVO.getInvoiceOcrDataNineList(), invoiceOcrDataVO.getInvoiceOcrDataTenList(), invoiceOcrDataVO.getInvoiceOcrDataElevenList(), invoiceOcrDataVO.getInvoiceOcrDataTwelveList(), invoiceOcrDataVO.getInvoiceOcrDataThirteenList(), invoiceOcrDataVO.getInvoiceOcrDataFourteenList(), invoiceOcrDataVO.getInvoiceProductDataList(), invoiceOcrDataVO.getInvoiceOcrDataSevenList());
                        continue;
                    }
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_yVDjKmW_328c4ae3", (String)"\u63a5\u53e3\u8c03\u7528\u5931\u8d25:") + jsonObject.getString("message"));
                }
            } else {
                List saleAttachmentDTOS = this.invokeBaseRpcService.listSaleFiles(list);
                log.info(this.invokeBaseRpcService + "\u5df2\u8fdb\u51652\u67e5\u8be2:" + saleAttachmentDTOS);
                for (SaleAttachmentDTO attachmentDTO : saleAttachmentDTOS) {
                    String signature = this.getSignature(attachmentDTO.getSaveType(), attachmentDTO.getFilePath());
                    HashMap<String, String> interfaceMap = new HashMap<String, String>();
                    interfaceMap.put("filePath", signature);
                    interfaceMap.put("interfaceCode", this.invokeBaseRpcService.getIpaasInterfaceCode("invoice-ocr"));
                    log.info("\u5916\u90e8\u94fe\u63a5" + signature);
                    String s = this.reconciliationInvokeBaseService.invoiceOCR(interfaceMap);
                    log.info("\u8fd4\u56de\u7ed3\u679c" + s);
                    JSONObject jsonObject = JSONObject.parseObject((String)s);
                    if (jsonObject.getBoolean("success").booleanValue()) {
                        InvoiceOcrDataVO invoiceOcrDataVO = this.resultToOCRData(new InvoiceOcrData(), jsonObject);
                        invoiceOcrDataVO.setUploadSubAccount(attachmentDTO.getUploadSubAccount());
                        invoiceOcrDataVO.setUploadElsAccount(attachmentDTO.getUploadElsAccount());
                        invoiceOcrDataVO.setFileName(attachmentDTO.getFileName());
                        invoiceOcrDataVO.setFileId(attachmentDTO.getId());
                        invoiceOcrDataVO.setFilePath(signature);
                        invoiceOcrDataVO.setFileSize(attachmentDTO.getFileSize());
                        invoiceOcrDataVO.setFileType(attachmentDTO.getFileType());
                        invoiceOcrDataVO.setData(jsonObject.toJSONString());
                        InvoiceOcrData ocrData = new InvoiceOcrData();
                        BeanUtils.copyProperties((Object)((Object)invoiceOcrDataVO), (Object)((Object)ocrData));
                        this.saveMain(ocrData, invoiceOcrDataVO.getInvoiceOcrDataOneList(), invoiceOcrDataVO.getInvoiceOcrDataTwoList(), invoiceOcrDataVO.getInvoiceOcrDataThreeList(), invoiceOcrDataVO.getInvoiceOcrDataFourList(), invoiceOcrDataVO.getInvoiceOcrDataFiveList(), invoiceOcrDataVO.getInvoiceOcrDataSixList(), invoiceOcrDataVO.getInvoiceOcrDataEightList(), invoiceOcrDataVO.getInvoiceOcrDataNineList(), invoiceOcrDataVO.getInvoiceOcrDataTenList(), invoiceOcrDataVO.getInvoiceOcrDataElevenList(), invoiceOcrDataVO.getInvoiceOcrDataTwelveList(), invoiceOcrDataVO.getInvoiceOcrDataThirteenList(), invoiceOcrDataVO.getInvoiceOcrDataFourteenList(), invoiceOcrDataVO.getInvoiceProductDataList(), invoiceOcrDataVO.getInvoiceOcrDataSevenList());
                        continue;
                    }
                    InvoiceOcrData invoiceOcrData = new InvoiceOcrData();
                    invoiceOcrData.setUploadSubAccount(attachmentDTO.getUploadSubAccount());
                    invoiceOcrData.setUploadElsAccount(attachmentDTO.getUploadElsAccount());
                    invoiceOcrData.setFileName(attachmentDTO.getFileName());
                    invoiceOcrData.setFileId(attachmentDTO.getId());
                    invoiceOcrData.setFilePath(attachmentDTO.getFilePath());
                    invoiceOcrData.setFileSize(attachmentDTO.getFileSize());
                    invoiceOcrData.setFileType(attachmentDTO.getFileType());
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_yVDjKmW_328c4ae3", (String)"\u63a5\u53e3\u8c03\u7528\u5931\u8d25:") + jsonObject.getString("message"));
                }
            }
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage());
        }
    }

    private String getSignature(String saveType, String filePath) {
        return this.invokeBaseRpcService.getSignature(saveType, filePath, this.address + "/opt/upFiles");
    }

    private InvoiceOcrDataVO resultToOCRData(InvoiceOcrData invoiceOcrData, JSONObject jsonObject) throws ParseException {
        SerializeConfig serializeConfig = new SerializeConfig();
        serializeConfig.propertyNamingStrategy = PropertyNamingStrategy.SnakeCase;
        String json = JSON.toJSONString((Object)jsonObject, (SerializeConfig)serializeConfig, (SerializerFeature[])new SerializerFeature[0]);
        InvoiceOcrDataVO invoiceOcrDataVO = new InvoiceOcrDataVO();
        JSONObject object = jsonObject.getJSONObject("data");
        invoiceOcrDataVO.setOcrResult(object.getString("message"));
        if (!object.containsKey((Object)"result")) {
            return invoiceOcrDataVO;
        }
        JSONObject result = object.getJSONObject("result");
        JSONArray objectList = result.getJSONArray("object_list");
        Iterator iterator = objectList.stream().iterator();
        while (iterator.hasNext()) {
            Date invoiceDate;
            String vatInvoiceIssueDate;
            JSONObject object1 = JSONObject.parseObject((String)iterator.next().toString());
            String invoiceType = object1.getString("type");
            invoiceOcrDataVO.setInvoiceKind(object1.getString("kind"));
            invoiceOcrDataVO.setInvoiceClass(object1.getString("class"));
            invoiceOcrDataVO.setInvoiceType(invoiceType);
            JSONArray item_list = object1.getJSONArray("item_list");
            Iterator objectIterator = item_list.stream().iterator();
            JSONObject jsonItem = new JSONObject();
            while (objectIterator.hasNext()) {
                JSONObject object2 = JSONObject.parseObject((String)objectIterator.next().toString());
                String key = object2.getString("key");
                String value = object2.getString("value");
                jsonItem.put(key, (Object)value);
            }
            String item = JSON.toJSONString((Object)jsonItem, (SerializeConfig)serializeConfig, (SerializerFeature[])new SerializerFeature[0]);
            InvoiceTypeToClass invoiceTypeToClass = new InvoiceTypeToClass();
            if (invoiceTypeToClass.getOne().contains(invoiceType)) {
                InvoiceOcrDataOne invoiceOcrDataOne = (InvoiceOcrDataOne)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataOne.class));
                invoiceOcrDataVO.setInvoiceCode(invoiceOcrDataOne.getVatInvoiceDaima());
                invoiceOcrDataVO.setVerifyCode(invoiceOcrDataOne.getVatInvoiceCorrectCode());
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataOne.getVatInvoiceHaoma());
                vatInvoiceIssueDate = invoiceOcrDataOne.getVatInvoiceIssueDate();
                invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                invoiceOcrDataVO.setInvoiceDate(invoiceDate);
                invoiceOcrDataVO.setInvoiceOcrDataOneList(Arrays.asList(invoiceOcrDataOne));
                if (!object1.containsKey((Object)"product_list")) continue;
                ArrayList<InvoiceProductData> invoiceProductData = new ArrayList<InvoiceProductData>();
                JSONArray productList = object1.getJSONArray("product_list");
                for (int i = 0; i < productList.size(); ++i) {
                    JSONArray array = JSONArray.parseArray((String)productList.get(i).toString());
                    Iterator arrayIterator = array.stream().iterator();
                    JSONObject jsonProduct = new JSONObject();
                    while (arrayIterator.hasNext()) {
                        JSONObject object2 = JSONObject.parseObject((String)arrayIterator.next().toString());
                        String key = object2.getString("key");
                        String value = object2.getString("value");
                        jsonProduct.put(key, (Object)value);
                    }
                    InvoiceProductData o = (InvoiceProductData)((Object)JSONObject.parseObject((String)jsonProduct.toJSONString(), InvoiceProductData.class));
                    invoiceProductData.add(o);
                }
                invoiceOcrDataVO.setInvoiceProductDataList(invoiceProductData);
                continue;
            }
            if (invoiceTypeToClass.getTwo().contains(invoiceType)) {
                InvoiceOcrDataTwo invoiceOcrDataTwo = (InvoiceOcrDataTwo)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataTwo.class));
                invoiceOcrDataVO.setInvoiceCode(invoiceOcrDataTwo.getVehicleInvoiceDaima());
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataTwo.getVehicleInvoiceHaoma());
                vatInvoiceIssueDate = invoiceOcrDataTwo.getVehicleInvoiceIssueDate();
                invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                invoiceOcrDataVO.setInvoiceDate(invoiceDate);
                invoiceOcrDataVO.setInvoiceOcrDataTwoList(Arrays.asList(invoiceOcrDataTwo));
                continue;
            }
            if (invoiceTypeToClass.getThree().contains(invoiceType)) {
                InvoiceOcrDataThree invoiceOcrDataThree = (InvoiceOcrDataThree)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataThree.class));
                invoiceOcrDataVO.setInvoiceCode(invoiceOcrDataThree.getVehicleInvoiceDaima());
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataThree.getVehicleInvoiceHaoma());
                vatInvoiceIssueDate = invoiceOcrDataThree.getVehicleInvoiceIssueDate();
                invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                invoiceOcrDataVO.setInvoiceDate(invoiceDate);
                invoiceOcrDataVO.setInvoiceOcrDataThreeList(Arrays.asList(invoiceOcrDataThree));
                continue;
            }
            if (invoiceTypeToClass.getFour().contains(invoiceType)) {
                InvoiceOcrDataFour invoiceOcrDataFour = (InvoiceOcrDataFour)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataFour.class));
                invoiceOcrDataVO.setInvoiceCode(invoiceOcrDataFour.getInvoiceCode());
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataFour.getInvoiceNumber());
                vatInvoiceIssueDate = invoiceOcrDataFour.getDateOfInvoice();
                invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                invoiceOcrDataVO.setInvoiceDate(invoiceDate);
                invoiceOcrDataVO.setInvoiceOcrDataFourList(Arrays.asList((InvoiceOcrDataFour)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataFour.class))));
                continue;
            }
            if (invoiceTypeToClass.getFive().contains(invoiceType)) {
                InvoiceOcrDataFive invoiceOcrDataFive = (InvoiceOcrDataFive)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataFive.class));
                invoiceOcrDataVO.setInvoiceCode(invoiceOcrDataFive.getTollCode());
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataFive.getTollNumber());
                vatInvoiceIssueDate = invoiceOcrDataFive.getDate();
                invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                invoiceOcrDataVO.setInvoiceDate(invoiceDate);
                invoiceOcrDataVO.setInvoiceOcrDataFiveList(Arrays.asList((InvoiceOcrDataFive)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataFive.class))));
                continue;
            }
            if (invoiceTypeToClass.getSix().contains(invoiceType)) {
                InvoiceOcrDataSix invoiceOcrDataSix = (InvoiceOcrDataSix)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataSix.class));
                invoiceOcrDataVO.setInvoiceCode(invoiceOcrDataSix.getQuotaInvoiceCode());
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataSix.getQuotaInvoiceNumber());
                invoiceOcrDataVO.setInvoiceOcrDataSixList(Arrays.asList((InvoiceOcrDataSix)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataSix.class))));
                continue;
            }
            if (invoiceTypeToClass.getSeven().contains(invoiceType)) {
                InvoiceOcrDataSeven invoiceOcrDataSeven = (InvoiceOcrDataSeven)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataSeven.class));
                invoiceOcrDataVO.setInvoiceCode(invoiceOcrDataSeven.getInvoiceCode());
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataSeven.getInvoiceNo());
                vatInvoiceIssueDate = invoiceOcrDataSeven.getDate();
                invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                invoiceOcrDataVO.setInvoiceDate(invoiceDate);
                invoiceOcrDataVO.setInvoiceOcrDataSevenList(Arrays.asList((InvoiceOcrDataSeven)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataSeven.class))));
                continue;
            }
            if (invoiceTypeToClass.getEight().contains(invoiceType)) {
                InvoiceOcrDataEight invoiceOcrDataEight = (InvoiceOcrDataEight)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataEight.class));
                invoiceOcrDataVO.setInvoiceOcrDataEightList(Arrays.asList((InvoiceOcrDataEight)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataEight.class))));
                continue;
            }
            if (invoiceTypeToClass.getNine().contains(invoiceType)) {
                InvoiceOcrDataNine invoiceOcrDataNine = (InvoiceOcrDataNine)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataNine.class));
                invoiceOcrDataVO.setInvoiceOcrDataNineList(Arrays.asList((InvoiceOcrDataNine)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataNine.class))));
                continue;
            }
            if (invoiceTypeToClass.getTen().contains(invoiceType)) {
                InvoiceOcrDataTen invoiceOcrDataTen = (InvoiceOcrDataTen)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataTen.class));
                invoiceOcrDataVO.setInvoiceCode(invoiceOcrDataTen.getInvoiceCode());
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataTen.getInvoiceNumber());
                vatInvoiceIssueDate = invoiceOcrDataTen.getDate();
                invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                invoiceOcrDataVO.setInvoiceDate(invoiceDate);
                invoiceOcrDataVO.setInvoiceOcrDataTenList(Arrays.asList((InvoiceOcrDataTen)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataTen.class))));
                continue;
            }
            if (invoiceTypeToClass.getEleven().contains(invoiceType)) {
                InvoiceOcrDataEleven invoiceOcrDataEleven = (InvoiceOcrDataEleven)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataEleven.class));
                invoiceOcrDataVO.setInvoiceCode(invoiceOcrDataEleven.getInvoiceCode());
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataEleven.getInvoiceNumber());
                vatInvoiceIssueDate = invoiceOcrDataEleven.getDate();
                invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
                invoiceOcrDataVO.setInvoiceDate(invoiceDate);
                invoiceOcrDataVO.setInvoiceOcrDataElevenList(Arrays.asList((InvoiceOcrDataEleven)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataEleven.class))));
                continue;
            }
            if (invoiceTypeToClass.getTwelve().contains(invoiceType)) {
                InvoiceOcrDataTwelve invoiceOcrDataTwelve = (InvoiceOcrDataTwelve)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataTwelve.class));
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataTwelve.getInvoiceNumber());
                invoiceOcrDataVO.setInvoiceOcrDataTwelveList(Arrays.asList((InvoiceOcrDataTwelve)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataTwelve.class))));
                continue;
            }
            if (invoiceTypeToClass.getThirtten().contains(invoiceType)) {
                InvoiceOcrDataThirteen invoiceOcrDataThirteen = (InvoiceOcrDataThirteen)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataThirteen.class));
                invoiceOcrDataVO.setInvoiceCode(invoiceOcrDataThirteen.getInvoiceCode());
                invoiceOcrDataVO.setInvoiceNumber(invoiceOcrDataThirteen.getInvoiceNumber());
                invoiceOcrDataVO.setInvoiceOcrDataThirteenList(Arrays.asList((InvoiceOcrDataThirteen)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataThirteen.class))));
                continue;
            }
            if (!invoiceTypeToClass.getFourteen().contains(invoiceType)) continue;
            InvoiceOcrDataFourteen invoiceOcrDataFourteen = (InvoiceOcrDataFourteen)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataFourteen.class));
            vatInvoiceIssueDate = invoiceOcrDataFourteen.getDate();
            invoiceDate = DateUtils.parseDate((String)vatInvoiceIssueDate, (String)"yyyy\u5e74MM\u6708dd\u65e5");
            invoiceOcrDataVO.setInvoiceDate(invoiceDate);
            invoiceOcrDataVO.setInvoiceOcrDataFourteenList(Arrays.asList((InvoiceOcrDataFourteen)((Object)JSONObject.parseObject((String)item, InvoiceOcrDataFourteen.class))));
        }
        return invoiceOcrDataVO;
    }
}

