/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.contract.dto.PurchaseContractAcceptanceDTO;
import com.els.modules.contract.dto.PurchaseContractPromiseDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.finance.api.enumerate.DeductCostTypeEnum;
import com.els.modules.finance.entity.PurchaseDeductCost;
import com.els.modules.finance.entity.PurchasePrePaymentWriteOffReconciliation;
import com.els.modules.finance.entity.SaleDeductCost;
import com.els.modules.finance.rpc.ElsEnterpriseInfoLocalRpcService;
import com.els.modules.finance.service.PurchaseDeductCostService;
import com.els.modules.finance.service.PurchasePaymentApplyItemService;
import com.els.modules.finance.service.PurchasePrePaymentWriteOffReconciliationService;
import com.els.modules.finance.service.SaleDeductCostService;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.PurchaseInvoiceHookInformation;
import com.els.modules.reconciliation.entity.PurchasePerformanceReconciliation;
import com.els.modules.reconciliation.entity.PurchaseRecCharge;
import com.els.modules.reconciliation.entity.PurchaseRecContractAcceptance;
import com.els.modules.reconciliation.entity.PurchaseRecContractPromise;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.entity.SaleInvoice;
import com.els.modules.reconciliation.entity.SalePerformanceReconciliation;
import com.els.modules.reconciliation.entity.SalePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.entity.SaleRecCharge;
import com.els.modules.reconciliation.entity.SaleRecContractAcceptance;
import com.els.modules.reconciliation.entity.SaleRecContractPromise;
import com.els.modules.reconciliation.enumerate.InvoiceConfirmStatusEnum;
import com.els.modules.reconciliation.enumerate.InvoiceStatusEnum;
import com.els.modules.reconciliation.enumerate.OperationEnum;
import com.els.modules.reconciliation.enumerate.ReconcilationItemTypeEmun;
import com.els.modules.reconciliation.enumerate.ReconciliationStatusEmun;
import com.els.modules.reconciliation.enumerate.SaleStatusEmun;
import com.els.modules.reconciliation.mapper.PurchaseInvoiceMapper;
import com.els.modules.reconciliation.mapper.PurchasePerformanceReconciliationMapper;
import com.els.modules.reconciliation.mapper.SaleInvoiceMapper;
import com.els.modules.reconciliation.mapper.SalePerformanceReconciliationMapper;
import com.els.modules.reconciliation.mapper.SalePrePaymentWriteOffReconciliationMapper;
import com.els.modules.reconciliation.mapper.SaleRecAdditionalChargesMapper;
import com.els.modules.reconciliation.mapper.SaleRecChargeMapper;
import com.els.modules.reconciliation.mapper.SaleRecContractAcceptanceMapper;
import com.els.modules.reconciliation.mapper.SaleRecContractPromiseMapper;
import com.els.modules.reconciliation.rpc.PurchaseContractAcceptanceLocalRpcService;
import com.els.modules.reconciliation.rpc.PurchaseContractPromiseLocalRpcService;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffService;
import com.els.modules.reconciliation.service.PurchaseDeliveryWaterService;
import com.els.modules.reconciliation.service.PurchaseInvoiceHookInformationService;
import com.els.modules.reconciliation.service.PurchaseInvoiceService;
import com.els.modules.reconciliation.service.PurchasePerformanceReconciliationService;
import com.els.modules.reconciliation.service.PurchaseRecChargeService;
import com.els.modules.reconciliation.service.PurchaseRecContractAcceptanceService;
import com.els.modules.reconciliation.service.PurchaseRecContractPromiseService;
import com.els.modules.reconciliation.vo.PurchaseInvoiceHookVO;
import com.els.modules.reconciliation.vo.PurchasePerformanceReconciliationVO;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import com.els.modules.supplier.api.enumerate.SupplierCoordinationWayEnum;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchasePerformanceReconciliationServiceImpl
extends BaseServiceImpl<PurchasePerformanceReconciliationMapper, PurchasePerformanceReconciliation>
implements PurchasePerformanceReconciliationService {
    private static final Logger log = LoggerFactory.getLogger(PurchasePerformanceReconciliationServiceImpl.class);
    @Autowired
    private PurchaseDeductCostService purchaseDeductCostService;
    @Autowired
    private PurchasePaymentApplyItemService purchasePaymentApplyItemService;
    @Resource
    private PurchaseContractPromiseLocalRpcService purchaseContractPromiseLocalRpcService;
    @Resource
    private PurchaseContractAcceptanceLocalRpcService purchaseContractAcceptanceLocalRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private ElsEnterpriseInfoLocalRpcService elsEnterpriseInfoRpcService;
    @Autowired
    private PurchaseRecChargeService purchaseRecChargeService;
    @Autowired
    private PurchasePrePaymentWriteOffReconciliationService purchasePrePaymentWriteOffReconciliationService;
    @Autowired
    private PurchaseRecContractAcceptanceService purchaseRecContractAcceptanceService;
    @Autowired
    private PurchaseRecContractPromiseService purchaseRecContractPromiseService;
    @Resource
    private PurchasePerformanceReconciliationMapper purchasePerformanceReconciliationMapper;
    @Resource
    private SalePerformanceReconciliationMapper salePerformanceReconciliationMapper;
    @Autowired
    private SaleDeductCostService saleDeductCostService;
    @Autowired
    private ElsPurchaseStatisticsWriteOffService elsPurchaseStatisticsWriteOffService;
    @Autowired
    private PurchaseInvoiceHookInformationService purchaseInvoiceHookInformationService;
    @Autowired
    private PurchaseInvoiceService purchaseInvoiceService;
    @Resource
    private SaleInvoiceMapper saleInvoiceMapper;
    @Resource
    private PurchaseInvoiceMapper purchaseInvoiceMapper;
    @Resource
    private SaleRecChargeMapper saleRecChargeMapper;
    @Resource
    private SaleRecAdditionalChargesMapper saleRecAdditionalChargesMapper;
    @Resource
    private SalePrePaymentWriteOffReconciliationMapper salePrePaymentWriteOffReconciliationMapper;
    @Resource
    private SaleRecContractAcceptanceMapper saleRecContractAcceptanceMapper;
    @Resource
    private SaleRecContractPromiseMapper saleRecContractPromiseMapper;
    @Autowired
    private InterfaceUtil interfaceUtil;
    @Autowired
    private PurchaseDeliveryWaterService purchaseDeliveryWaterService;

    @Override
    public void delete(String id) {
        ((PurchasePerformanceReconciliationMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchasePerformanceReconciliationMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchasePerformanceReconciliation purchasePerformanceReconciliation, PurchasePerformanceReconciliationVO reconciliationVO) {
        this.buildPurchasePerformanceReconciliation(purchasePerformanceReconciliation);
        this.purchasePerformanceReconciliationMapper.insert((Object)purchasePerformanceReconciliation);
        this.invokeBaseRpcService.addStatusLog(purchasePerformanceReconciliation.getId(), ReconciliationStatusEmun.NEW.getValue(), "reconciliation", "inster");
        this.insertData(purchasePerformanceReconciliation, reconciliationVO);
        this.calculateMoney(purchasePerformanceReconciliation, reconciliationVO);
    }

    private void checkSettlementAmount(PurchasePerformanceReconciliation purchasePerformanceReconciliation) {
        if ("1".equals(purchasePerformanceReconciliation.getSaveForZero())) {
            if (purchasePerformanceReconciliation.getSettlementAmount().compareTo(new BigDecimal(0)) < 0) {
                log.error("checkSettlementAmount, error  " + JSON.toJSONString((Object)((Object)purchasePerformanceReconciliation)));
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IeRHjydHfLWWWWWWWWXUWWShbLjXIet_a0732d09", (String)"\u5bf9\u8d26\u660e\u7ec6\u7684\u7ed3\u7b97\u91d1\u989d\u4e3a\uff1a[${0}]\uff0c\u5c0f\u4e8e0\uff0c\u65e0\u6cd5\u751f\u6210\u6709\u6548\u5bf9\u8d26\u5355", (String[])new String[]{purchasePerformanceReconciliation.getSettlementAmount().toString()}));
            }
        } else if (purchasePerformanceReconciliation.getSettlementAmount().compareTo(new BigDecimal(0)) < 1) {
            log.error("checkSettlementAmount, error  " + JSON.toJSONString((Object)((Object)purchasePerformanceReconciliation)));
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IeRHjydHfLWWWWWWWWXUEUWOShbLjXIet_f75bb433", (String)"\u5bf9\u8d26\u660e\u7ec6\u7684\u7ed3\u7b97\u91d1\u989d\u4e3a\uff1a[${0}]\uff0c\u5c0f\u4e8e\u7b49\u4e8e0\u90fd\u65e0\u6cd5\u751f\u6210\u6709\u6548\u5bf9\u8d26\u5355", (String[])new String[]{purchasePerformanceReconciliation.getSettlementAmount().toString()}));
        }
    }

    private void buildPurchasePerformanceReconciliation(PurchasePerformanceReconciliation purchasePerformanceReconciliation) {
        String reconciliationNumber = this.invokeBaseRpcService.getNextCode("performanceReconciliation", (Object)purchasePerformanceReconciliation);
        purchasePerformanceReconciliation.setReconciliationNumber(reconciliationNumber);
        purchasePerformanceReconciliation.setInvoiced("0");
        purchasePerformanceReconciliation.setSendStatus("0");
        purchasePerformanceReconciliation.setReconciliationStatus(ReconciliationStatusEmun.NEW.getValue());
        purchasePerformanceReconciliation.setCancellation("0");
        purchasePerformanceReconciliation.setCreateAccount(TenantContext.getTenant());
        ElsEnterpriseInfoDTO enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(TenantContext.getTenant());
        if (enterpriseInfo != null) {
            purchasePerformanceReconciliation.setPurchaseName(enterpriseInfo.getName());
        }
    }

    private void insertData(PurchasePerformanceReconciliation purchasePerformanceReconciliation, PurchasePerformanceReconciliationVO reconciliationVO) {
        this.deleteDetail(reconciliationVO.getId());
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = reconciliationVO.getPurchaseRecContractPromiseList();
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = reconciliationVO.getPurchaseRecContractAcceptanceList();
        List<PurchaseRecCharge> purchaseRecChargeList = reconciliationVO.getPurchaseRecChargeList();
        List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList = reconciliationVO.getPurchasePrePaymentWriteOffReconciliationList();
        this.insertContractPromise(purchasePerformanceReconciliation, purchaseRecContractPromiseList);
        this.insertContractAcceptance(purchasePerformanceReconciliation, purchaseRecContractAcceptanceList);
        this.insertDeductCost(purchasePerformanceReconciliation, purchaseRecChargeList);
        this.insertPrePaymentWriteOff(purchasePerformanceReconciliation, prePaymentWriteOffList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteDetail(String id) {
        this.purchaseRecContractPromiseService.deleteByMainId(id);
        this.purchaseRecContractAcceptanceService.deleteByMainId(id);
        this.purchaseRecChargeService.deleteByMainId(id);
        this.purchasePrePaymentWriteOffReconciliationService.deleteByMainId(id);
        this.purchaseInvoiceMapper.deleteByMainId(id);
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(id);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchasePerformanceReconciliation purchasePerformanceReconciliation, PurchasePerformanceReconciliationVO reconciliationVO) {
        this.purchasePerformanceReconciliationMapper.updateById((Object)purchasePerformanceReconciliation);
        this.cancelContractPromise(purchasePerformanceReconciliation.getId(), null);
        this.cancelContractAcceptance(purchasePerformanceReconciliation.getId(), null);
        this.cancelCharges(purchasePerformanceReconciliation.getId(), null);
        this.calculateMoney(purchasePerformanceReconciliation, reconciliationVO);
        this.insertData(purchasePerformanceReconciliation, reconciliationVO);
    }

    public void calculateMoney(PurchasePerformanceReconciliation reconciliation, PurchasePerformanceReconciliationVO purchaseReconciliationVO) {
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = purchaseReconciliationVO.getPurchaseRecContractPromiseList();
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = purchaseReconciliationVO.getPurchaseRecContractAcceptanceList();
        List<PurchaseRecCharge> charges = purchaseReconciliationVO.getPurchaseRecChargeList();
        List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList = purchaseReconciliationVO.getPurchasePrePaymentWriteOffReconciliationList();
        BigDecimal performanceIncludeTaxAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(purchaseRecContractPromiseList)) {
            performanceIncludeTaxAmount = purchaseRecContractPromiseList.parallelStream().filter(item -> item.getTotalTaxAmount() != null).map(PurchaseRecContractPromise::getTotalTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        reconciliation.setPerformanceIncludeTaxAmount(performanceIncludeTaxAmount);
        BigDecimal acceptanceIncludeTaxAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(purchaseRecContractAcceptanceList)) {
            acceptanceIncludeTaxAmount = purchaseRecContractAcceptanceList.parallelStream().filter(item -> item.getTaxAmount() != null).map(PurchaseRecContractAcceptance::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        reconciliation.setAcceptanceIncludeTaxAmount(acceptanceIncludeTaxAmount);
        BigDecimal chargeTotalAmount = BigDecimal.ZERO;
        BigDecimal chargeAmount = BigDecimal.ZERO;
        BigDecimal buckleTicketsAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(charges)) {
            for (PurchaseRecCharge purchaseRecCharge : charges) {
                chargeTotalAmount = chargeTotalAmount.add(purchaseRecCharge.getTotalAmount());
                if (DeductCostTypeEnum.ACCOUNT_DEDUCTION.getValue().equals(purchaseRecCharge.getDeductionType())) {
                    chargeAmount = chargeAmount.add(purchaseRecCharge.getTotalAmount());
                }
                if (!DeductCostTypeEnum.TICKET_DEDUCTION.getValue().equals(purchaseRecCharge.getDeductionType())) continue;
                buckleTicketsAmount = buckleTicketsAmount.add(purchaseRecCharge.getTotalAmount());
            }
        }
        reconciliation.setChargeTotalAmount(chargeTotalAmount);
        reconciliation.setChargeAmount(chargeAmount);
        reconciliation.setBuckleTicketsAmount(buckleTicketsAmount);
        BigDecimal shouldInvoiceAmount = performanceIncludeTaxAmount.add(acceptanceIncludeTaxAmount).subtract(buckleTicketsAmount);
        reconciliation.setShouldInvoiceAmount(shouldInvoiceAmount);
        BigDecimal closingAmount = shouldInvoiceAmount.subtract(chargeAmount);
        reconciliation.setClosingAmount(closingAmount);
        BigDecimal writtenOffAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            writtenOffAmount = prePaymentWriteOffList.parallelStream().filter(item -> item.getThisWriteOffAmount() != null).map(PurchasePrePaymentWriteOffReconciliation::getThisWriteOffAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        reconciliation.setWrittenOffAmount(writtenOffAmount);
        BigDecimal settlementAmount = closingAmount.subtract(writtenOffAmount);
        reconciliation.setSettlementAmount(settlementAmount);
        reconciliation.setRemainingUnPaidAmount(settlementAmount);
        this.purchasePerformanceReconciliationMapper.updateById((Object)reconciliation);
    }

    @Override
    public PurchasePerformanceReconciliationVO extractReconciliation(PurchasePerformanceReconciliationVO reconciliationVO) {
        String elsAccount = !StringUtils.isBlank((CharSequence)reconciliationVO.getElsAccount()) ? reconciliationVO.getElsAccount() : TenantContext.getTenant();
        ReconciliationVO targetReconciliationVO = new ReconciliationVO();
        BeanUtils.copyProperties((Object)((Object)reconciliationVO), (Object)targetReconciliationVO);
        PurchaseContractPromiseDTO purchaseContractPromiseDTO = new PurchaseContractPromiseDTO();
        BeanUtils.copyProperties((Object)((Object)reconciliationVO), (Object)purchaseContractPromiseDTO);
        List<PurchaseContractPromiseDTO> purchaseContractPromiseList = this.purchaseContractPromiseLocalRpcService.listPurchaseContractPromiseDTO(purchaseContractPromiseDTO);
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = this.getPurchaseRecContractPromiseList(purchaseContractPromiseList);
        reconciliationVO.setPurchaseRecContractPromiseList(purchaseRecContractPromiseList);
        PurchaseContractAcceptanceDTO purchaseContractAcceptanceDTO = new PurchaseContractAcceptanceDTO();
        BeanUtils.copyProperties((Object)((Object)reconciliationVO), (Object)purchaseContractAcceptanceDTO);
        List<PurchaseContractAcceptanceDTO> purchaseContractAcceptanceList = this.purchaseContractAcceptanceLocalRpcService.listPurchaseContractAcceptanceDTO(purchaseContractAcceptanceDTO);
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = this.getPurchaseRecContractAcceptanceList(purchaseContractAcceptanceList);
        reconciliationVO.setPurchaseRecContractAcceptanceList(purchaseRecContractAcceptanceList);
        List<PurchaseRecCharge> charges = this.purchaseDeductCostService.getByPurchaseDeductCost(targetReconciliationVO, elsAccount);
        reconciliationVO.setPurchaseRecChargeList(charges);
        List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOff = this.purchasePaymentApplyItemService.getPurchasePrePaymentWriteOffReconciliations(targetReconciliationVO, elsAccount);
        reconciliationVO.setPurchasePrePaymentWriteOffReconciliationList(prePaymentWriteOff);
        return reconciliationVO;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> publish(PurchasePerformanceReconciliation purchasePerformanceReconciliation, PurchasePerformanceReconciliationVO reconciliationVO) {
        this.calculateMoney(purchasePerformanceReconciliation, reconciliationVO);
        this.checkSettlementAmount(purchasePerformanceReconciliation);
        ReconciliationVO vo = new ReconciliationVO();
        BeanUtils.copyProperties((Object)((Object)reconciliationVO), (Object)vo);
        this.elsPurchaseStatisticsWriteOffService.writeOffAmountOccupy(vo, reconciliationVO.getPurchasePrePaymentWriteOffReconciliationList());
        boolean flag = false;
        if (ReconciliationStatusEmun.REFUSED.getValue().equals(purchasePerformanceReconciliation.getReconciliationStatus()) && StringUtils.isNotBlank((CharSequence)purchasePerformanceReconciliation.getRelationId())) {
            flag = true;
        }
        if (SupplierCoordinationWayEnum.NO_COORDINATIONWAY.getValue().equals(purchasePerformanceReconciliation.getIsTeamwork())) {
            purchasePerformanceReconciliation.setReconciliationStatus(ReconciliationStatusEmun.COMFIRMED.getValue());
        } else {
            purchasePerformanceReconciliation.setReconciliationStatus(ReconciliationStatusEmun.UNCONFIRMED.getValue());
        }
        purchasePerformanceReconciliation.setSendStatus("1");
        this.updateMain(purchasePerformanceReconciliation, reconciliationVO);
        this.invokeBaseRpcService.addStatusLog(purchasePerformanceReconciliation.getId(), purchasePerformanceReconciliation.getReconciliationStatus(), "reconciliation", "publish");
        String id = purchasePerformanceReconciliation.getRelationId();
        SalePerformanceReconciliation salePerformanceReconciliation = new SalePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReconciliation), (Object)((Object)salePerformanceReconciliation));
        salePerformanceReconciliation.setToElsAccount(purchasePerformanceReconciliation.getElsAccount());
        salePerformanceReconciliation.setBusAccount(purchasePerformanceReconciliation.getElsAccount());
        salePerformanceReconciliation.setRelationId(purchasePerformanceReconciliation.getId());
        salePerformanceReconciliation.setElsAccount(purchasePerformanceReconciliation.getToElsAccount());
        if (flag) {
            salePerformanceReconciliation.setDataVersion(null);
            salePerformanceReconciliation.setId(id);
            salePerformanceReconciliation.setReconciliationStatus(purchasePerformanceReconciliation.getReconciliationStatus());
            this.salePerformanceReconciliationMapper.updateById((Object)salePerformanceReconciliation);
            this.handleDetail(salePerformanceReconciliation, reconciliationVO);
        } else {
            salePerformanceReconciliation.setId(null);
            this.salePerformanceReconciliationMapper.insert((Object)salePerformanceReconciliation);
            this.handleDetail(salePerformanceReconciliation, reconciliationVO);
            purchasePerformanceReconciliation.setRelationId(salePerformanceReconciliation.getId());
            this.purchasePerformanceReconciliationMapper.updateById((Object)purchasePerformanceReconciliation);
        }
        if (SupplierCoordinationWayEnum.NO_COORDINATIONWAY.getValue().equals(purchasePerformanceReconciliation.getIsTeamwork())) {
            // empty if block
        }
        return Result.ok((String)"\u53d1\u5e03\u6210\u529f\uff01");
    }

    public void handleDetail(SalePerformanceReconciliation saleReconciliation, PurchasePerformanceReconciliationVO reconciliationVO) {
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = reconciliationVO.getPurchaseRecContractPromiseList();
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = reconciliationVO.getPurchaseRecContractAcceptanceList();
        List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList = reconciliationVO.getPurchasePrePaymentWriteOffReconciliationList();
        List<PurchaseRecCharge> purchaseRecChargeList = reconciliationVO.getPurchaseRecChargeList();
        List<PurchaseAttachmentDTO> attachments = reconciliationVO.getAttachments();
        String id = saleReconciliation.getId();
        this.saleRecContractPromiseMapper.deleteByMainId(id);
        this.saleRecContractAcceptanceMapper.deleteByMainId(id);
        this.salePrePaymentWriteOffReconciliationMapper.deleteByMainId(id);
        this.saleRecChargeMapper.deleteByMainId(id);
        this.saleRecAdditionalChargesMapper.deleteByMainId(id);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(id);
        this.handleSaleRecContractPromiseDetail(saleReconciliation, purchaseRecContractPromiseList);
        this.handleSaleRecContractAcceptanceDetail(saleReconciliation, purchaseRecContractAcceptanceList);
        this.handleSaleRecChargeDetail(saleReconciliation, purchaseRecChargeList);
        this.handleSaleRecPrePaymentWriteOffDetail(saleReconciliation, prePaymentWriteOffList);
        this.handleSaleAttachmentDetail(saleReconciliation, attachments);
    }

    private void handleSaleRecPrePaymentWriteOffDetail(SalePerformanceReconciliation saleReconciliation, List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList) {
        if (CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            return;
        }
        ArrayList<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffList = new ArrayList<SalePrePaymentWriteOffReconciliation>();
        for (PurchasePrePaymentWriteOffReconciliation purchasePrePaymentWriteOff : prePaymentWriteOffList) {
            SalePrePaymentWriteOffReconciliation salePrePaymentWriteOff = new SalePrePaymentWriteOffReconciliation();
            BeanUtils.copyProperties((Object)((Object)purchasePrePaymentWriteOff), (Object)((Object)salePrePaymentWriteOff));
            salePrePaymentWriteOff.setId(null);
            salePrePaymentWriteOff.setElsAccount(saleReconciliation.getElsAccount());
            salePrePaymentWriteOff.setToElsAccount(saleReconciliation.getToElsAccount());
            salePrePaymentWriteOff.setBusAccount(saleReconciliation.getBusAccount());
            salePrePaymentWriteOff.setHeadId(saleReconciliation.getId());
            salePrePaymentWriteOff.setRelationId(purchasePrePaymentWriteOff.getId());
            salePrePaymentWriteOffList.add(salePrePaymentWriteOff);
        }
        this.salePrePaymentWriteOffReconciliationMapper.insertBatchSomeColumn(salePrePaymentWriteOffList);
    }

    private void handleSaleRecContractAcceptanceDetail(SalePerformanceReconciliation saleReconciliation, List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList) {
        if (CollectionUtils.isEmpty(purchaseRecContractAcceptanceList)) {
            return;
        }
        ArrayList<SaleRecContractAcceptance> saleRecContractAcceptanceList = new ArrayList<SaleRecContractAcceptance>();
        for (PurchaseRecContractAcceptance purchaseRecContractAcceptance : purchaseRecContractAcceptanceList) {
            SaleRecContractAcceptance saleRecContractAcceptance = new SaleRecContractAcceptance();
            BeanUtils.copyProperties((Object)((Object)purchaseRecContractAcceptance), (Object)((Object)saleRecContractAcceptance));
            saleRecContractAcceptance.setId(null);
            saleRecContractAcceptance.setElsAccount(saleReconciliation.getElsAccount());
            saleRecContractAcceptance.setToElsAccount(saleReconciliation.getToElsAccount());
            saleRecContractAcceptance.setBusAccount(saleReconciliation.getBusAccount());
            saleRecContractAcceptance.setHeadId(saleReconciliation.getId());
            saleRecContractAcceptance.setRelationId(purchaseRecContractAcceptance.getId());
            saleRecContractAcceptanceList.add(saleRecContractAcceptance);
        }
        this.saleRecContractAcceptanceMapper.insertBatchSomeColumn(saleRecContractAcceptanceList);
    }

    private void handleSaleRecContractPromiseDetail(SalePerformanceReconciliation saleReconciliation, List<PurchaseRecContractPromise> purchaseRecContractPromiseList) {
        if (CollectionUtils.isEmpty(purchaseRecContractPromiseList)) {
            return;
        }
        ArrayList<SaleRecContractPromise> saleRecContractPromiseList = new ArrayList<SaleRecContractPromise>();
        for (PurchaseRecContractPromise purchaseRecContractPromise : purchaseRecContractPromiseList) {
            SaleRecContractPromise saleRecContractPromise = new SaleRecContractPromise();
            BeanUtils.copyProperties((Object)((Object)purchaseRecContractPromise), (Object)((Object)saleRecContractPromise));
            saleRecContractPromise.setId(null);
            saleRecContractPromise.setElsAccount(saleReconciliation.getElsAccount());
            saleRecContractPromise.setToElsAccount(saleReconciliation.getToElsAccount());
            saleRecContractPromise.setBusAccount(saleReconciliation.getBusAccount());
            saleRecContractPromise.setHeadId(saleReconciliation.getId());
            saleRecContractPromise.setRelationId(purchaseRecContractPromise.getId());
            saleRecContractPromiseList.add(saleRecContractPromise);
        }
        this.saleRecContractPromiseMapper.insertBatchSomeColumn(saleRecContractPromiseList);
    }

    private void handleSaleAttachmentDetail(SalePerformanceReconciliation saleReconciliation, List<PurchaseAttachmentDTO> attachments) {
        if (CollectionUtils.isEmpty(attachments)) {
            return;
        }
        ArrayList<SaleAttachmentDTO> saleAttachments = new ArrayList<SaleAttachmentDTO>();
        for (PurchaseAttachmentDTO purchaseAttachment : attachments) {
            purchaseAttachment.setSendStatus("1");
            SaleAttachmentDTO saleAttachment = new SaleAttachmentDTO();
            BeanUtils.copyProperties((Object)purchaseAttachment, (Object)saleAttachment);
            saleAttachment.setId(null);
            saleAttachment.setElsAccount(saleReconciliation.getElsAccount());
            saleAttachment.setHeadId(saleReconciliation.getId());
            saleAttachment.setRelationId(purchaseAttachment.getId());
            saleAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
            saleAttachments.add(saleAttachment);
        }
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachments);
    }

    private void handleSaleRecChargeDetail(SalePerformanceReconciliation saleReconciliation, List<PurchaseRecCharge> purchaseRecChargeList) {
        if (CollectionUtils.isEmpty(purchaseRecChargeList)) {
            return;
        }
        ArrayList<SaleRecCharge> saleRecCharges = new ArrayList<SaleRecCharge>();
        for (PurchaseRecCharge purchaseRecCharge : purchaseRecChargeList) {
            SaleRecCharge saleRecCharge = new SaleRecCharge();
            BeanUtils.copyProperties((Object)((Object)purchaseRecCharge), (Object)((Object)saleRecCharge));
            saleRecCharge.setId(null);
            saleRecCharge.setElsAccount(saleReconciliation.getElsAccount());
            saleRecCharge.setToElsAccount(saleReconciliation.getToElsAccount());
            saleRecCharge.setBusAccount(saleReconciliation.getBusAccount());
            saleRecCharge.setHeadId(saleReconciliation.getId());
            saleRecCharge.setRelationId(purchaseRecCharge.getId());
            saleRecCharges.add(saleRecCharge);
        }
        this.saleRecChargeMapper.insertBatchSomeColumn(saleRecCharges);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> invoiceRefusedOrConfirm(PurchasePerformanceReconciliation purchasePerformanceReconciliation, List<PurchaseInvoice> invoices, String operation) {
        String opt = "confirm";
        if ("refused".equals(operation)) {
            opt = "refund";
            purchasePerformanceReconciliation.setPurchaseInvoiceAffirmStatus(InvoiceConfirmStatusEnum.RENTURNED.getValue());
        } else if ("confirm".equals(operation)) {
            purchasePerformanceReconciliation.setPurchaseInvoiceAffirmStatus(InvoiceConfirmStatusEnum.CONFIRMED.getValue());
            if (!CollectionUtils.isEmpty(invoices) && invoices.size() == 1) {
                PurchaseInvoiceHookVO hookVO = new PurchaseInvoiceHookVO();
                BeanUtils.copyProperties((Object)((Object)invoices.get(0)), (Object)((Object)hookVO));
                String id = purchasePerformanceReconciliation.getId();
                hookVO.setPurchaseRecContractPromiseList(this.purchaseRecContractPromiseService.selectByMainId(id));
                hookVO.setPurchaseRecContractAcceptanceList(this.purchaseRecContractAcceptanceService.selectByMainId(id));
                hookVO.setPurchaseRecChargeList(this.purchaseRecChargeService.selectByMainId(id));
                hookVO.setPurchasePrePaymentWriteOffReconciliationList(this.purchasePrePaymentWriteOffReconciliationService.selectByMainId(id));
                this.hook(hookVO);
                ReconciliationVO reconciliationVO = new ReconciliationVO();
                BeanUtils.copyProperties((Object)((Object)purchasePerformanceReconciliation), (Object)reconciliationVO);
                this.purchaseDeliveryWaterService.handleWaterData(invoices, reconciliationVO);
            }
        }
        this.purchasePerformanceReconciliationMapper.updateById((Object)purchasePerformanceReconciliation);
        SalePerformanceReconciliation salePerformanceReconciliation = (SalePerformanceReconciliation)((Object)this.salePerformanceReconciliationMapper.selectById((Serializable)((Object)purchasePerformanceReconciliation.getRelationId())));
        if (salePerformanceReconciliation != null) {
            BigDecimal invoiceTotalAmount = new BigDecimal(0);
            salePerformanceReconciliation.setPurchaseInvoiceAffirmStatus(purchasePerformanceReconciliation.getPurchaseInvoiceAffirmStatus());
            salePerformanceReconciliation.setPurchaseRemark(purchasePerformanceReconciliation.getPurchaseRemark());
            for (PurchaseInvoice purchaseInvoice : invoices) {
                if (OperationEnum.REFUSED.getValue().equals(operation)) {
                    purchaseInvoice.setStatus(InvoiceStatusEnum.RENTURNED.getValue());
                } else if (OperationEnum.CONFIRM.getValue().equals(operation)) {
                    purchaseInvoice.setStatus(InvoiceStatusEnum.CONFIRMED.getValue());
                }
                this.purchaseInvoiceMapper.updateById((Object)purchaseInvoice);
                SaleInvoice saleInvoice = (SaleInvoice)((Object)this.saleInvoiceMapper.selectById((Serializable)((Object)purchaseInvoice.getRelationId())));
                if (saleInvoice == null) continue;
                if (OperationEnum.CONFIRM.getValue().equals(operation)) {
                    SaleInvoice invoice = new SaleInvoice();
                    BeanUtils.copyProperties((Object)((Object)purchaseInvoice), (Object)((Object)invoice));
                    invoice.setId(saleInvoice.getId());
                    invoice.setElsAccount(saleInvoice.getElsAccount());
                    invoice.setToElsAccount(saleInvoice.getToElsAccount());
                    invoice.setBusAccount(saleInvoice.getBusAccount());
                    invoice.setHeadId(saleInvoice.getHeadId());
                    invoice.setNotIncludeTaxAmount(invoice.getIncludeTaxAmount().subtract(invoice.getTaxAmount()));
                    this.saleInvoiceMapper.updateById((Object)invoice);
                    invoiceTotalAmount = invoiceTotalAmount.add(invoice.getIncludeTaxAmount());
                    String url = "id=" + salePerformanceReconciliation.getId() + "&createAccount=" + salePerformanceReconciliation.getCreateAccount();
                    super.sendMsg(purchasePerformanceReconciliation.getElsAccount(), purchasePerformanceReconciliation.getToElsAccount(), (Object)purchasePerformanceReconciliation, url, "invoice", opt);
                    continue;
                }
                saleInvoice.setPurchaseRemark(purchaseInvoice.getPurchaseRemark());
                saleInvoice.setStatus(purchaseInvoice.getStatus());
                this.saleInvoiceMapper.updateById((Object)saleInvoice);
            }
            if (OperationEnum.CONFIRM.getValue().equals(operation)) {
                salePerformanceReconciliation.setTotalInvoiceAmount(invoiceTotalAmount);
            }
            this.salePerformanceReconciliationMapper.updateById((Object)salePerformanceReconciliation);
        }
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_tkLR_2f0866fe", (String)"\u64cd\u4f5c\u6210\u529f"));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> refusedOrConfirm(PurchasePerformanceReconciliation purchasePerformanceReconciliation, String operation) {
        String opt = "confirm";
        if (OperationEnum.REFUSED.getValue().equals(operation)) {
            purchasePerformanceReconciliation.setSaleRecAffirmStatus(SaleStatusEmun.REFUSED.getValue());
            opt = "refund";
        } else if (OperationEnum.CONFIRM.getValue().equals(operation)) {
            purchasePerformanceReconciliation.setSaleRecAffirmStatus(SaleStatusEmun.COMFIRMED.getValue());
        }
        SalePerformanceReconciliation reconciliation = (SalePerformanceReconciliation)((Object)this.salePerformanceReconciliationMapper.selectById((Serializable)((Object)purchasePerformanceReconciliation.getRelationId())));
        if (reconciliation != null) {
            this.purchasePerformanceReconciliationMapper.updateById((Object)purchasePerformanceReconciliation);
            SalePerformanceReconciliation salePerformanceReconciliation = new SalePerformanceReconciliation();
            BeanUtils.copyProperties((Object)((Object)purchasePerformanceReconciliation), (Object)((Object)salePerformanceReconciliation));
            salePerformanceReconciliation.setId(reconciliation.getId());
            salePerformanceReconciliation.setElsAccount(reconciliation.getElsAccount());
            salePerformanceReconciliation.setToElsAccount(reconciliation.getToElsAccount());
            salePerformanceReconciliation.setBusAccount(reconciliation.getBusAccount());
            salePerformanceReconciliation.setRelationId(purchasePerformanceReconciliation.getId());
            salePerformanceReconciliation.setDataVersion(reconciliation.getDataVersion());
            this.salePerformanceReconciliationMapper.updateById((Object)salePerformanceReconciliation);
            String url = "id=" + salePerformanceReconciliation.getId() + "&createAccount=" + salePerformanceReconciliation.getCreateAccount();
            if (StringUtils.isNotBlank((CharSequence)purchasePerformanceReconciliation.getSalePrincipal())) {
                super.sendMsg(purchasePerformanceReconciliation.getElsAccount(), purchasePerformanceReconciliation.getToElsAccount(), purchasePerformanceReconciliation.getSalePrincipal(), (Object)purchasePerformanceReconciliation, url, "saleReconciliation", opt);
            } else {
                super.sendMsg(purchasePerformanceReconciliation.getElsAccount(), purchasePerformanceReconciliation.getToElsAccount(), (Object)purchasePerformanceReconciliation, url, "saleReconciliation", opt);
            }
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_tkLR_2f0866fe", (String)"\u64cd\u4f5c\u6210\u529f"));
        }
        throw new RuntimeException("\u5bf9\u5e94\u7684\u9500\u552e\u5bf9\u8d26\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u786e\u8ba4\u6216\u62d2\u7edd");
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void cancellation(String id) {
        this.elsPurchaseStatisticsWriteOffService.cancelReleaseAmountByPurchase(id);
        this.cancelReconciliation(id);
        this.cancelContractPromise(id, null);
        this.cancelContractAcceptance(id, null);
        this.cancelCharges(id, null);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveInvoice(PurchasePerformanceReconciliation purchasePerformanceReconciliation, List<PurchaseInvoice> purchaseInvoiceList, String operation) {
        this.purchaseInvoiceMapper.deleteByMainId(purchasePerformanceReconciliation.getId());
        this.saleInvoiceMapper.deleteByMainId(purchasePerformanceReconciliation.getRelationId());
        BigDecimal invoiceTotalAmount = new BigDecimal(0);
        for (PurchaseInvoice purchaseInvoice : purchaseInvoiceList) {
            purchaseInvoice.setId(null);
            if (StringUtils.isBlank((CharSequence)purchaseInvoice.getInvoiceNumber())) {
                purchaseInvoice.setInvoiceNumber(this.invokeBaseRpcService.getNextCode("invoiceNumber", (Object)purchaseInvoice));
            }
            purchaseInvoice.setStatus(InvoiceStatusEnum.UNCONFIRMED.getValue());
            if (purchaseInvoice.getNotIncludeTaxAmount() == null) {
                BigDecimal tax = new BigDecimal(purchaseInvoice.getTaxRate()).divide(new BigDecimal(100)).add(BigDecimal.ONE);
                purchaseInvoice.setNotIncludeTaxAmount(purchaseInvoice.getIncludeTaxAmount().divide(tax, 5));
            }
            if (purchaseInvoice.getTaxAmount() == null) {
                purchaseInvoice.setTaxAmount(purchaseInvoice.getIncludeTaxAmount().subtract(purchaseInvoice.getNotIncludeTaxAmount()));
            }
            purchaseInvoice.setReconciliationNumber(purchasePerformanceReconciliation.getReconciliationNumber());
            purchaseInvoice.setToElsAccount(purchasePerformanceReconciliation.getToElsAccount());
            purchaseInvoice.setHeadId(purchasePerformanceReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)purchaseInvoice, (BaseEntity)purchasePerformanceReconciliation);
            invoiceTotalAmount = invoiceTotalAmount.add(purchaseInvoice.getIncludeTaxAmount());
        }
        purchasePerformanceReconciliation.setTotalInvoiceAmount(invoiceTotalAmount);
        purchasePerformanceReconciliation.setInvoiced("1");
        this.purchasePerformanceReconciliationMapper.updateById((Object)purchasePerformanceReconciliation);
        SalePerformanceReconciliation salePerformanceReconciliation = (SalePerformanceReconciliation)((Object)this.salePerformanceReconciliationMapper.selectById((Serializable)((Object)purchasePerformanceReconciliation.getRelationId())));
        salePerformanceReconciliation.setTotalInvoiceAmount(invoiceTotalAmount);
        salePerformanceReconciliation.setInvoiced("1");
        this.salePerformanceReconciliationMapper.updateById((Object)salePerformanceReconciliation);
        if (!purchaseInvoiceList.isEmpty()) {
            this.purchaseInvoiceMapper.insertBatchSomeColumn(purchaseInvoiceList);
        }
        HashMap<String, String> relationMap = new HashMap<String, String>();
        ArrayList<SaleInvoice> saleInvoiceList = new ArrayList<SaleInvoice>();
        if (!CollectionUtils.isEmpty(purchaseInvoiceList)) {
            for (PurchaseInvoice purchaseInvoice : purchaseInvoiceList) {
                SaleInvoice saleInvoice = new SaleInvoice();
                BeanUtils.copyProperties((Object)((Object)purchaseInvoice), (Object)((Object)saleInvoice));
                saleInvoice.setRelationId(purchaseInvoice.getId());
                saleInvoice.setElsAccount(salePerformanceReconciliation.getElsAccount());
                saleInvoice.setToElsAccount(salePerformanceReconciliation.getToElsAccount());
                saleInvoice.setBusAccount(salePerformanceReconciliation.getToElsAccount());
                saleInvoice.setHeadId(salePerformanceReconciliation.getId());
                saleInvoice.setId(null);
                saleInvoiceList.add(saleInvoice);
            }
            this.saleInvoiceMapper.insertBatchSomeColumn(saleInvoiceList);
        }
        for (SaleInvoice saleInvoice : saleInvoiceList) {
            relationMap.put(saleInvoice.getRelationId(), saleInvoice.getId());
        }
        for (PurchaseInvoice purchaseInvoice : purchaseInvoiceList) {
            String relationId = (String)relationMap.get(purchaseInvoice.getId());
            if (StringUtils.isEmpty((CharSequence)relationId)) continue;
            purchaseInvoice.setRelationId(relationId);
            this.purchaseInvoiceMapper.updateById((Object)purchaseInvoice);
        }
    }

    @Override
    public void delMain(String id) {
        this.elsPurchaseStatisticsWriteOffService.cancelReleaseAmountByPurchase(id);
        this.cancelContractPromise(id, null);
        this.cancelContractAcceptance(id, null);
        this.cancelCharges(id, null);
        this.deleteDetail(id);
        this.purchasePerformanceReconciliationMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    public void hook(PurchaseInvoiceHookVO invoiceHockVO) {
        List<PurchasePrePaymentWriteOffReconciliation> list;
        List<PurchaseRecCharge> list2;
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList;
        BigDecimal netAmount;
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList;
        ArrayList<PurchaseInvoiceHookInformation> list3 = new ArrayList<PurchaseInvoiceHookInformation>();
        if (!StringUtils.isEmpty((CharSequence)invoiceHockVO.getId())) {
            this.purchaseInvoiceHookInformationService.deleteByInvoiceId(invoiceHockVO.getId());
        }
        if (!CollectionUtil.isEmpty(purchaseRecContractPromiseList = invoiceHockVO.getPurchaseRecContractPromiseList())) {
            for (PurchaseRecContractPromise purchaseRecContractPromise : purchaseRecContractPromiseList) {
                PurchaseInvoiceHookInformation purchaseInvoiceHookInformation = new PurchaseInvoiceHookInformation();
                BeanUtils.copyProperties((Object)((Object)invoiceHockVO), (Object)((Object)purchaseInvoiceHookInformation));
                purchaseInvoiceHookInformation.setId(null);
                purchaseInvoiceHookInformation.setSourceId(purchaseRecContractPromise.getId());
                purchaseInvoiceHookInformation.setInvoiceId(invoiceHockVO.getId());
                purchaseInvoiceHookInformation.setCheckTheDocumentCategory(ReconcilationItemTypeEmun.CONTRACT_PROMISE.getValue());
                purchaseInvoiceHookInformation.setCheckTheDocumentNumber(purchaseRecContractPromise.getPromiseNumber());
                purchaseInvoiceHookInformation.setItemNumber(purchaseRecContractPromise.getItemNumber());
                BigDecimal totalTaxAmount = purchaseRecContractPromise.getTotalTaxAmount() == null ? BigDecimal.ZERO : purchaseRecContractPromise.getTotalTaxAmount();
                purchaseInvoiceHookInformation.setDocumentTaxAmount(totalTaxAmount);
                if (!StringUtils.isEmpty((CharSequence)purchaseRecContractPromise.getTaxRate())) {
                    BigDecimal tax = new BigDecimal(String.valueOf(purchaseRecContractPromise.getTaxRate())).divide(new BigDecimal(100)).add(BigDecimal.ONE);
                    netAmount = totalTaxAmount.divide(tax, 5);
                    purchaseInvoiceHookInformation.setDocumentNetAmount(netAmount);
                    purchaseInvoiceHookInformation.setDocumentTax(totalTaxAmount.subtract(netAmount));
                }
                list3.add(purchaseInvoiceHookInformation);
            }
        }
        if (!CollectionUtil.isEmpty(purchaseRecContractAcceptanceList = invoiceHockVO.getPurchaseRecContractAcceptanceList())) {
            for (PurchaseRecContractAcceptance purchaseRecContractAcceptance : purchaseRecContractAcceptanceList) {
                PurchaseInvoiceHookInformation hook = new PurchaseInvoiceHookInformation();
                BeanUtils.copyProperties((Object)((Object)invoiceHockVO), (Object)((Object)hook));
                hook.setId(null);
                hook.setSourceId(purchaseRecContractAcceptance.getId());
                hook.setInvoiceId(invoiceHockVO.getId());
                hook.setCheckTheDocumentCategory(ReconcilationItemTypeEmun.CONTRACT_ACCEPTANCE.getValue());
                hook.setCheckTheDocumentNumber(purchaseRecContractAcceptance.getAcceptanceNumbers());
                hook.setItemNumber(purchaseRecContractAcceptance.getItemNumber());
                BigDecimal taxAmount = purchaseRecContractAcceptance.getTaxAmount() == null ? BigDecimal.ZERO : purchaseRecContractAcceptance.getTaxAmount();
                netAmount = purchaseRecContractAcceptance.getNetAmount() == null ? BigDecimal.ZERO : purchaseRecContractAcceptance.getNetAmount();
                hook.setDocumentTaxAmount(taxAmount);
                hook.setDocumentNetAmount(netAmount);
                hook.setDocumentTax(taxAmount.subtract(netAmount));
                list3.add(hook);
            }
        }
        if (!CollectionUtil.isEmpty(list2 = invoiceHockVO.getPurchaseRecChargeList())) {
            for (PurchaseRecCharge purchaseRecCharge : list2) {
                PurchaseInvoiceHookInformation hook = new PurchaseInvoiceHookInformation();
                BeanUtils.copyProperties((Object)((Object)invoiceHockVO), (Object)((Object)hook));
                hook.setId(null);
                hook.setSourceId(purchaseRecCharge.getId());
                hook.setInvoiceId(invoiceHockVO.getId());
                hook.setCheckTheDocumentCategory(ReconcilationItemTypeEmun.CHARGE.getValue());
                hook.setCheckTheDocumentNumber(purchaseRecCharge.getDeductNumber());
                hook.setItemNumber(purchaseRecCharge.getItemNumber());
                BigDecimal totalAmount = purchaseRecCharge.getTotalAmount() == null ? BigDecimal.ZERO : purchaseRecCharge.getTotalAmount();
                BigDecimal totalNonTaxAmount = purchaseRecCharge.getTotalNonTaxAmount() == null ? BigDecimal.ZERO : purchaseRecCharge.getTotalNonTaxAmount();
                hook.setDocumentTaxAmount(totalAmount);
                hook.setDocumentNetAmount(totalNonTaxAmount);
                hook.setDocumentTax(totalAmount.subtract(totalNonTaxAmount));
                list3.add(hook);
            }
        }
        if (!CollectionUtil.isEmpty(list = invoiceHockVO.getPurchasePrePaymentWriteOffReconciliationList())) {
            for (PurchasePrePaymentWriteOffReconciliation prePaymentWriteOff : list) {
                PurchaseInvoiceHookInformation hook = new PurchaseInvoiceHookInformation();
                BeanUtils.copyProperties((Object)((Object)invoiceHockVO), (Object)((Object)hook));
                hook.setId(null);
                hook.setSourceId(prePaymentWriteOff.getId());
                hook.setInvoiceId(invoiceHockVO.getId());
                hook.setCheckTheDocumentCategory(ReconcilationItemTypeEmun.PRE_PAYMENT.getValue());
                hook.setCheckTheDocumentNumber(prePaymentWriteOff.getPaymentApplyNumber());
                hook.setItemNumber(prePaymentWriteOff.getItemNumber());
                hook.setDocumentTaxAmount(prePaymentWriteOff.getSourceTaxAmount());
                hook.setDocumentNetAmount(prePaymentWriteOff.getSourceNetAmount());
                hook.setDocumentTax(prePaymentWriteOff.getSourceTax());
                list3.add(hook);
            }
        }
        this.purchaseInvoiceHookInformationService.saveBatch(list3);
    }

    @Override
    public PurchasePerformanceReconciliationVO queryReconciliationItemList(PurchaseReconciliation purchaseReconciliation, String id) {
        PurchasePerformanceReconciliationVO purchaseReconciliationVO = new PurchasePerformanceReconciliationVO();
        PurchaseInvoice purchaseInvoice = (PurchaseInvoice)((Object)this.purchaseInvoiceService.getById((Serializable)((Object)id)));
        String reconciliationNumber = purchaseInvoice.getReconciliationNumber();
        LambdaQueryWrapper reconciliationLambdaQueryWrapper = new LambdaQueryWrapper();
        reconciliationLambdaQueryWrapper.eq(PurchasePerformanceReconciliation::getReconciliationNumber, (Object)reconciliationNumber);
        PurchasePerformanceReconciliation reconciliation = (PurchasePerformanceReconciliation)((Object)this.getOne((Wrapper)reconciliationLambdaQueryWrapper));
        if (reconciliation == null) {
            return purchaseReconciliationVO;
        }
        List<PurchaseRecCharge> purchaseRecChargeList = this.purchaseRecChargeService.selectByMainId(reconciliation.getId());
        List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList = this.purchasePrePaymentWriteOffReconciliationService.selectByMainId(reconciliation.getId());
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = this.purchaseRecContractAcceptanceService.selectByMainId(reconciliation.getId());
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = this.purchaseRecContractPromiseService.selectByMainId(reconciliation.getId());
        if (!StringUtils.isEmpty((CharSequence)reconciliation.getReconciliationNumber())) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.eq(PurchaseInvoiceHookInformation::getReconciliationNumber, (Object)reconciliation.getReconciliationNumber());
            List list = this.purchaseInvoiceHookInformationService.list((Wrapper)lambdaQueryWrapper);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                PurchaseInvoiceHookInformation purchaseInvoiceHookInformation;
                Map<String, PurchaseInvoiceHookInformation> map = list.stream().filter(hook -> !StringUtils.isEmpty((CharSequence)hook.getSourceId())).collect(Collectors.toMap(PurchaseInvoiceHookInformation::getSourceId, hook -> hook));
                for (PurchasePrePaymentWriteOffReconciliation prePaymentWriteOff : purchasePrePaymentWriteOffList) {
                    if (StringUtils.isEmpty((CharSequence)prePaymentWriteOff.getId()) || (purchaseInvoiceHookInformation = map.get(prePaymentWriteOff.getId())) == null) continue;
                    prePaymentWriteOff.setIsCheck(true);
                }
                for (PurchaseRecCharge purchaseRecCharge : purchaseRecChargeList) {
                    if (StringUtils.isEmpty((CharSequence)purchaseRecCharge.getId()) || (purchaseInvoiceHookInformation = map.get(purchaseRecCharge.getId())) == null) continue;
                    purchaseRecCharge.setIsCheck(true);
                }
                for (PurchaseRecContractAcceptance purchaseRecContractAcceptance : purchaseRecContractAcceptanceList) {
                    if (StringUtils.isEmpty((CharSequence)purchaseRecContractAcceptance.getId()) || (purchaseInvoiceHookInformation = map.get(purchaseRecContractAcceptance.getId())) == null) continue;
                    purchaseRecContractAcceptance.setIsCheck(true);
                }
                for (PurchaseRecContractPromise purchaseRecContractPromise : purchaseRecContractPromiseList) {
                    if (StringUtils.isEmpty((CharSequence)purchaseRecContractPromise.getId()) || (purchaseInvoiceHookInformation = map.get(purchaseRecContractPromise.getId())) == null) continue;
                    purchaseRecContractPromise.setIsCheck(true);
                }
            }
        }
        purchaseReconciliationVO.setPurchaseRecContractPromiseList(purchaseRecContractPromiseList);
        purchaseReconciliationVO.setPurchaseRecContractAcceptanceList(purchaseRecContractAcceptanceList);
        purchaseReconciliationVO.setPurchasePrePaymentWriteOffReconciliationList(purchasePrePaymentWriteOffList);
        purchaseReconciliationVO.setPurchaseRecChargeList(purchaseRecChargeList);
        return purchaseReconciliationVO;
    }

    private void cancelReconciliation(String id) {
        PurchasePerformanceReconciliation purchasePerformanceReconciliation = (PurchasePerformanceReconciliation)((Object)this.purchasePerformanceReconciliationMapper.selectById((Serializable)((Object)id)));
        purchasePerformanceReconciliation.setCancellation("1");
        LoginUser loginUser = SysUtil.getLoginUser();
        purchasePerformanceReconciliation.setCancellationSubAccount(loginUser.getSubAccount());
        purchasePerformanceReconciliation.setCancellationName(loginUser.getRealname());
        purchasePerformanceReconciliation.setCancellationTime(new Date());
        this.purchasePerformanceReconciliationMapper.updateById((Object)purchasePerformanceReconciliation);
        SalePerformanceReconciliation salePerformanceReconciliation = (SalePerformanceReconciliation)((Object)this.salePerformanceReconciliationMapper.selectById((Serializable)((Object)purchasePerformanceReconciliation.getRelationId())));
        salePerformanceReconciliation.setCancellationName(purchasePerformanceReconciliation.getCancellationName());
        salePerformanceReconciliation.setCancellationSubAccount(purchasePerformanceReconciliation.getCancellationSubAccount());
        salePerformanceReconciliation.setCancellationTime(purchasePerformanceReconciliation.getCancellationTime());
        salePerformanceReconciliation.setCancellation("1");
        this.salePerformanceReconciliationMapper.updateById((Object)salePerformanceReconciliation);
    }

    private void insertDeductCost(PurchasePerformanceReconciliation purchasePerformanceReconciliation, List<PurchaseRecCharge> purchaseRecChargeList) {
        if (CollectionUtils.isEmpty(purchaseRecChargeList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
        ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
        for (PurchaseRecCharge entity : purchaseRecChargeList) {
            entity.setHeadId(purchasePerformanceReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchasePerformanceReconciliation);
            entity.setReconciliationNumber(purchasePerformanceReconciliation.getReconciliationNumber());
            entity.setItemNumber(String.valueOf(itemNumber));
            PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)entity.getBusinessId())));
            deductCost.setDeductStatus("1");
            deductCost.setReconciliationNumber(purchasePerformanceReconciliation.getReconciliationNumber());
            deductCosts.add(deductCost);
            SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)deductCost.getRelationId())));
            saleDeductCost.setDeductStatus("1");
            saleDeductCost.setReconciliationNumber(purchasePerformanceReconciliation.getReconciliationNumber());
            saleDeductCosts.add(saleDeductCost);
            ++itemNumber;
        }
        this.purchaseRecChargeService.saveBatch(purchaseRecChargeList, 2000);
        if (!deductCosts.isEmpty()) {
            this.purchaseDeductCostService.updateBatchById(deductCosts);
        }
        if (!saleDeductCosts.isEmpty()) {
            this.saleDeductCostService.updateBatchById(saleDeductCosts);
        }
    }

    private void insertPrePaymentWriteOff(PurchasePerformanceReconciliation purchasePerformanceReconciliation, List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList) {
        if (CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList = new ArrayList<PurchasePrePaymentWriteOffReconciliation>();
        for (PurchasePrePaymentWriteOffReconciliation prePaymentWriteOff : prePaymentWriteOffList) {
            prePaymentWriteOff.setHeadId(purchasePerformanceReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)prePaymentWriteOff, (BaseEntity)purchasePerformanceReconciliation);
            prePaymentWriteOff.setReconciliationNumber(purchasePerformanceReconciliation.getReconciliationNumber());
            prePaymentWriteOff.setItemNumber(String.valueOf(itemNumber));
            prePaymentWriteOff.setToElsAccount(purchasePerformanceReconciliation.getToElsAccount());
            purchasePrePaymentWriteOffList.add(prePaymentWriteOff);
            ++itemNumber;
        }
        if (!CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            this.purchasePrePaymentWriteOffReconciliationService.saveBatch(prePaymentWriteOffList, 2000);
        }
    }

    private void insertContractAcceptance(PurchasePerformanceReconciliation purchasePerformanceReconciliation, List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList) {
        if (CollectionUtils.isEmpty(purchaseRecContractAcceptanceList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<PurchaseContractAcceptanceDTO> purchaseContractAcceptanceList = new ArrayList<PurchaseContractAcceptanceDTO>();
        for (PurchaseRecContractAcceptance purchaseRecContractAcceptance : purchaseRecContractAcceptanceList) {
            purchaseRecContractAcceptance.setHeadId(purchasePerformanceReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)purchaseRecContractAcceptance, (BaseEntity)purchasePerformanceReconciliation);
            purchaseRecContractAcceptance.setReconciliationNumber(purchasePerformanceReconciliation.getReconciliationNumber());
            purchaseRecContractAcceptance.setItemNumber(String.valueOf(itemNumber));
            PurchaseContractAcceptanceDTO dto = this.purchaseContractAcceptanceLocalRpcService.getById(purchaseRecContractAcceptance.getBusinessId());
            dto.setCostStatus("1");
            dto.setReconciliationNumber(purchasePerformanceReconciliation.getReconciliationNumber());
            purchaseContractAcceptanceList.add(dto);
            ++itemNumber;
        }
        if (!CollectionUtils.isEmpty(purchaseRecContractAcceptanceList)) {
            this.purchaseRecContractAcceptanceService.saveBatch(purchaseRecContractAcceptanceList);
        }
        if (!CollectionUtils.isEmpty(purchaseContractAcceptanceList)) {
            this.purchaseContractAcceptanceLocalRpcService.updatePurchaseContractAcceptanceItemListById(purchaseContractAcceptanceList);
        }
    }

    private void insertContractPromise(PurchasePerformanceReconciliation purchasePerformanceReconciliation, List<PurchaseRecContractPromise> purchaseRecContractPromiseList) {
        if (CollectionUtils.isEmpty(purchaseRecContractPromiseList)) {
            return;
        }
        ArrayList<PurchaseContractPromiseDTO> purchaseContractPromiseList = new ArrayList<PurchaseContractPromiseDTO>();
        int itemNumber = 1;
        for (PurchaseRecContractPromise purchaseRecContractPromise : purchaseRecContractPromiseList) {
            purchaseRecContractPromise.setHeadId(purchasePerformanceReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)purchaseRecContractPromise, (BaseEntity)purchasePerformanceReconciliation);
            purchaseRecContractPromise.setReconciliationNumber(purchasePerformanceReconciliation.getReconciliationNumber());
            purchaseRecContractPromise.setItemNumber(String.valueOf(itemNumber));
            PurchaseContractPromiseDTO dto = this.purchaseContractPromiseLocalRpcService.getById(purchaseRecContractPromise.getBusinessId());
            dto.setReconciliationStatus("1");
            dto.setReconciliationNumber(purchasePerformanceReconciliation.getReconciliationNumber());
            purchaseContractPromiseList.add(dto);
            ++itemNumber;
        }
        if (!CollectionUtils.isEmpty(purchaseRecContractPromiseList)) {
            this.purchaseRecContractPromiseService.saveBatch(purchaseRecContractPromiseList);
        }
        if (!CollectionUtils.isEmpty(purchaseContractPromiseList)) {
            this.purchaseContractPromiseLocalRpcService.updatePurchaseContractPromiseItemListById(purchaseContractPromiseList);
        }
    }

    private void cancelContractAcceptance(String id, List<String> existIds) {
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = this.purchaseRecContractAcceptanceService.selectByMainId(id);
        if (CollectionUtils.isEmpty(purchaseRecContractAcceptanceList)) {
            return;
        }
        ArrayList<PurchaseContractAcceptanceDTO> purchaseContractAcceptanceList = new ArrayList<PurchaseContractAcceptanceDTO>();
        for (PurchaseRecContractAcceptance purchaseRecContractAcceptance : purchaseRecContractAcceptanceList) {
            PurchaseContractAcceptanceDTO purchaseContractAcceptanceDTO;
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(purchaseRecContractAcceptance.getBusinessId()) || (purchaseContractAcceptanceDTO = this.purchaseContractAcceptanceLocalRpcService.getById(purchaseRecContractAcceptance.getBusinessId())) == null) continue;
            purchaseContractAcceptanceDTO.setCostStatus("0");
            purchaseContractAcceptanceDTO.setReconciliationNumber(null);
            purchaseContractAcceptanceList.add(purchaseContractAcceptanceDTO);
        }
        if (!CollectionUtils.isEmpty(purchaseContractAcceptanceList)) {
            this.purchaseContractAcceptanceLocalRpcService.updatePurchaseContractAcceptanceItemListById(purchaseContractAcceptanceList);
        }
    }

    private void cancelContractPromise(String id, List<String> existIds) {
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = this.purchaseRecContractPromiseService.selectByMainId(id);
        if (CollectionUtils.isEmpty(purchaseRecContractPromiseList)) {
            return;
        }
        ArrayList<PurchaseContractPromiseDTO> contractPromiseList = new ArrayList<PurchaseContractPromiseDTO>();
        for (PurchaseRecContractPromise purchaseRecContractPromise : purchaseRecContractPromiseList) {
            PurchaseContractPromiseDTO contractPromise;
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(purchaseRecContractPromise.getBusinessId()) || (contractPromise = this.purchaseContractPromiseLocalRpcService.getById(purchaseRecContractPromise.getBusinessId())) == null) continue;
            contractPromise.setReconciliationStatus("0");
            contractPromise.setReconciliationNumber(null);
            contractPromiseList.add(contractPromise);
        }
        if (!CollectionUtils.isEmpty(contractPromiseList)) {
            this.purchaseContractPromiseLocalRpcService.updatePurchaseContractPromiseItemListById(contractPromiseList);
        }
    }

    private void cancelCharges(String purchaseReconciliationId, List<String> existIds) {
        List<PurchaseRecCharge> charges = this.purchaseRecChargeService.selectByMainId(purchaseReconciliationId);
        if (CollectionUtils.isEmpty(charges)) {
            return;
        }
        ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
        ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
        for (PurchaseRecCharge charge : charges) {
            PurchaseDeductCost deductCost;
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(charge.getBusinessId()) || (deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)charge.getBusinessId())))) == null) continue;
            deductCost.setDeductStatus("0");
            deductCost.setReconciliationNumber(null);
            deductCosts.add(deductCost);
            SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)deductCost.getRelationId())));
            saleDeductCost.setDeductStatus("0");
            saleDeductCost.setReconciliationNumber(null);
            saleDeductCosts.add(saleDeductCost);
        }
        if (!deductCosts.isEmpty()) {
            this.purchaseDeductCostService.updateBatchById(deductCosts);
        }
        if (!saleDeductCosts.isEmpty()) {
            this.saleDeductCostService.updateBatchById(saleDeductCosts);
        }
    }

    private List<PurchaseRecContractPromise> getPurchaseRecContractPromiseList(List<PurchaseContractPromiseDTO> purchaseContractPromiseList) {
        ArrayList<PurchaseRecContractPromise> list = new ArrayList<PurchaseRecContractPromise>();
        if (CollectionUtils.isEmpty(purchaseContractPromiseList)) {
            return list;
        }
        for (PurchaseContractPromiseDTO purchaseContractPromiseDTO : purchaseContractPromiseList) {
            PurchaseRecContractPromise dto = new PurchaseRecContractPromise();
            BeanUtils.copyProperties((Object)purchaseContractPromiseDTO, (Object)((Object)dto));
            dto.setMasterContractNumber(purchaseContractPromiseDTO.getContractNumber());
            dto.setContractParties("\u7b7e\u7ea6\u65b9");
            dto.setContractPromise(purchaseContractPromiseDTO.getPerformingPartyName());
            dto.setContractDrawer(purchaseContractPromiseDTO.getInvoicedName());
            dto.setContractReceiver(purchaseContractPromiseDTO.getPayeeName());
            dto.setId(null);
            dto.setAmount(purchaseContractPromiseDTO.getAmount());
            dto.setBusinessId(purchaseContractPromiseDTO.getId());
            list.add(dto);
        }
        return list;
    }

    private List<PurchaseRecContractAcceptance> getPurchaseRecContractAcceptanceList(List<PurchaseContractAcceptanceDTO> purchaseContractAcceptanceList) {
        ArrayList<PurchaseRecContractAcceptance> list = new ArrayList<PurchaseRecContractAcceptance>();
        for (PurchaseContractAcceptanceDTO purchaseContractAcceptanceDTO : purchaseContractAcceptanceList) {
            PurchaseRecContractAcceptance dto = new PurchaseRecContractAcceptance();
            BeanUtils.copyProperties((Object)purchaseContractAcceptanceDTO, (Object)((Object)dto));
            dto.setId(null);
            dto.setBusinessId(purchaseContractAcceptanceDTO.getId());
            list.add(dto);
        }
        return list;
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getPurchasePerformanceReconciliation", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List purchaseReconciliationList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchasePerformanceReconciliation reconciliation : purchaseReconciliationList) {
            this.pushDataToErp(reconciliation);
        }
    }

    private void pushDataToErp(PurchasePerformanceReconciliation reconciliation) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushPurchasePerformanceReconciliation", (Object)reconciliation);
    }

    @Override
    public void copyData(String id) {
        PurchasePerformanceReconciliation purchaseReconciliation = (PurchasePerformanceReconciliation)((Object)this.purchasePerformanceReconciliationMapper.selectById((Serializable)((Object)id)));
        if (purchaseReconciliation == null) {
            return;
        }
        PurchasePerformanceReconciliation newReconciliation = new PurchasePerformanceReconciliation();
        newReconciliation.setToElsAccount(purchaseReconciliation.getToElsAccount());
        newReconciliation.setCreateAccount(purchaseReconciliation.getCreateAccount());
        newReconciliation.setPurchaseName(purchaseReconciliation.getPurchaseName());
        newReconciliation.setSupplierName(purchaseReconciliation.getSupplierName());
        newReconciliation.setBeginDate(purchaseReconciliation.getBeginDate());
        newReconciliation.setEndDate(purchaseReconciliation.getEndDate());
        newReconciliation.setCompany(purchaseReconciliation.getCompany());
        newReconciliation.setPurchaseOrg(purchaseReconciliation.getPurchaseOrg());
        newReconciliation.setSupplierCode(purchaseReconciliation.getSupplierCode());
        newReconciliation.setSalePrincipalPhone(purchaseReconciliation.getSalePrincipalPhone());
        newReconciliation.setPaymentClause(purchaseReconciliation.getPaymentClause());
        newReconciliation.setPaymentClauseDesc(purchaseReconciliation.getPaymentClauseDesc());
        newReconciliation.setTaxCode(purchaseReconciliation.getTaxCode());
        newReconciliation.setTaxRate(purchaseReconciliation.getTaxRate());
        newReconciliation.setCurrency(purchaseReconciliation.getCurrency());
        newReconciliation.setExchangeRate(purchaseReconciliation.getExchangeRate());
        newReconciliation.setPayWay(purchaseReconciliation.getPayWay());
        newReconciliation.setPayCycle(purchaseReconciliation.getPayCycle());
        newReconciliation.setPurchasePrincipal(purchaseReconciliation.getPurchasePrincipal());
        newReconciliation.setSalePrincipal(purchaseReconciliation.getSalePrincipal());
        newReconciliation.setPaymentBenchmarkDate(purchaseReconciliation.getPaymentBenchmarkDate());
        newReconciliation.setPaymentExpiredate(purchaseReconciliation.getPaymentExpiredate());
        newReconciliation.setTemplateNumber(purchaseReconciliation.getTemplateNumber());
        newReconciliation.setTemplateVersion(purchaseReconciliation.getTemplateVersion());
        newReconciliation.setTemplateName(purchaseReconciliation.getTemplateName());
        newReconciliation.setTemplateAccount(purchaseReconciliation.getTemplateAccount());
        newReconciliation.setSaveForZero(purchaseReconciliation.getSaveForZero());
        newReconciliation.setChargeCurrency(purchaseReconciliation.getChargeCurrency());
        newReconciliation.setIsTeamwork(purchaseReconciliation.getIsTeamwork());
        this.saveMain(newReconciliation, new PurchasePerformanceReconciliationVO());
    }
}

