/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.contract.dto.SaleContractAcceptanceDTO;
import com.els.modules.contract.dto.SaleContractPromiseDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.modules.finance.api.enumerate.DeductCostTypeEnum;
import com.els.modules.finance.entity.PurchaseDeductCost;
import com.els.modules.finance.entity.PurchasePrePaymentWriteOffReconciliation;
import com.els.modules.finance.entity.SaleDeductCost;
import com.els.modules.finance.mapper.PurchasePrePaymentWriteOffReconciliationMapper;
import com.els.modules.finance.service.PurchaseDeductCostService;
import com.els.modules.finance.service.PurchasePaymentApplyItemService;
import com.els.modules.finance.service.PurchasePrePaymentWriteOffReconciliationService;
import com.els.modules.finance.service.SaleDeductCostService;
import com.els.modules.finance.service.SalePaymentApplyItemService;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.PurchasePerformanceReconciliation;
import com.els.modules.reconciliation.entity.PurchaseRecCharge;
import com.els.modules.reconciliation.entity.PurchaseRecContractAcceptance;
import com.els.modules.reconciliation.entity.PurchaseRecContractPromise;
import com.els.modules.reconciliation.entity.SaleInvoice;
import com.els.modules.reconciliation.entity.SalePerformanceReconciliation;
import com.els.modules.reconciliation.entity.SalePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.entity.SaleRecCharge;
import com.els.modules.reconciliation.entity.SaleRecContractAcceptance;
import com.els.modules.reconciliation.entity.SaleRecContractPromise;
import com.els.modules.reconciliation.enumerate.InvoiceConfirmStatusEnum;
import com.els.modules.reconciliation.enumerate.InvoiceStatusEnum;
import com.els.modules.reconciliation.enumerate.ReconciliationStatusEmun;
import com.els.modules.reconciliation.enumerate.SaleStatusEmun;
import com.els.modules.reconciliation.mapper.PurchaseInvoiceMapper;
import com.els.modules.reconciliation.mapper.PurchasePerformanceReconciliationMapper;
import com.els.modules.reconciliation.mapper.PurchaseRecChargeMapper;
import com.els.modules.reconciliation.mapper.PurchaseRecContractAcceptanceMapper;
import com.els.modules.reconciliation.mapper.PurchaseRecContractPromiseMapper;
import com.els.modules.reconciliation.mapper.SaleInvoiceMapper;
import com.els.modules.reconciliation.mapper.SalePerformanceReconciliationMapper;
import com.els.modules.reconciliation.rpc.PurchaseContractAcceptanceLocalRpcService;
import com.els.modules.reconciliation.rpc.PurchaseContractPromiseLocalRpcService;
import com.els.modules.reconciliation.rpc.SaleContractAcceptanceLocalRpcService;
import com.els.modules.reconciliation.rpc.SaleContractPromiseLocalRpcService;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffService;
import com.els.modules.reconciliation.service.PurchasePerformanceReconciliationService;
import com.els.modules.reconciliation.service.PurchaseRecContractAcceptanceService;
import com.els.modules.reconciliation.service.PurchaseRecContractPromiseService;
import com.els.modules.reconciliation.service.SalePerformanceReconciliationService;
import com.els.modules.reconciliation.service.SalePrePaymentWriteOffReconciliationService;
import com.els.modules.reconciliation.service.SaleRecChargeService;
import com.els.modules.reconciliation.service.SaleRecContractAcceptanceService;
import com.els.modules.reconciliation.service.SaleRecContractPromiseService;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import com.els.modules.reconciliation.vo.SalePerformanceReconciliationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SalePerformanceReconciliationServiceImpl
extends BaseServiceImpl<SalePerformanceReconciliationMapper, SalePerformanceReconciliation>
implements SalePerformanceReconciliationService {
    private static final Logger log = LoggerFactory.getLogger(SalePerformanceReconciliationServiceImpl.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private TemplateRpcService templateHeadService;
    @Resource
    private ElsEnterpriseInfoRpcService elsEnterpriseInfoRpcService;
    @Resource
    private SalePerformanceReconciliationMapper salePerformanceReconciliationMapper;
    @Resource
    private SaleRecChargeService saleRecChargeService;
    @Resource
    private SaleInvoiceMapper saleInvoiceMapper;
    @Resource
    private PurchaseInvoiceMapper purchaseInvoiceMapper;
    @Resource
    private PurchasePerformanceReconciliationMapper purchasePerformanceReconciliationMapper;
    @Resource
    private PurchaseRecChargeMapper purchaseRecChargeMapper;
    @Autowired
    private SaleDeductCostService saleDeductCostService;
    @Resource
    private PurchaseContractPromiseLocalRpcService purchaseContractPromiseLocalRpcService;
    @Resource
    private PurchaseContractAcceptanceLocalRpcService purchaseContractAcceptanceLocalRpcService;
    @Resource
    private SaleContractPromiseLocalRpcService saleContractPromiseLocalRpcService;
    @Resource
    private SaleContractAcceptanceLocalRpcService saleContractAcceptanceLocalRpcService;
    @Autowired
    private SalePaymentApplyItemService salePaymentApplyItemService;
    @Autowired
    private PurchaseDeductCostService purchaseDeductCostService;
    @Autowired
    private PurchaseRecContractPromiseService purchaseRecContractPromiseService;
    @Autowired
    private PurchaseRecContractAcceptanceService purchaseRecContractAcceptanceService;
    @Autowired
    private PurchasePrePaymentWriteOffReconciliationService purchasePrePaymentWriteOffReconciliationService;
    @Autowired
    private PurchasePaymentApplyItemService purchasePaymentApplyItemService;
    @Autowired
    private SaleRecContractPromiseService saleRecContractPromiseService;
    @Autowired
    private SaleRecContractAcceptanceService saleRecContractAcceptanceService;
    @Autowired
    private SalePrePaymentWriteOffReconciliationService salePrePaymentWriteOffReconciliationService;
    @Autowired
    private PurchasePerformanceReconciliationService purchasePerformanceReconciliationService;
    @Autowired
    private ElsPurchaseStatisticsWriteOffService elsPurchaseStatisticsWriteOffService;
    @Resource
    private PurchaseRecContractPromiseMapper purchaseRecContractPromiseMapper;
    @Resource
    private PurchaseRecContractAcceptanceMapper purchaseRecContractAcceptanceMapper;
    @Resource
    private PurchasePrePaymentWriteOffReconciliationMapper purchasePrePaymentWriteOffReconciliationMapper;
    @Autowired
    private StaticConfig staticConfig;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SalePerformanceReconciliation salePerformanceReconciliation, SalePerformanceReconciliationVO saleReconciliationPage) {
        this.buildReconciliation(salePerformanceReconciliation);
        this.salePerformanceReconciliationMapper.insert((Object)salePerformanceReconciliation);
        this.insertData(salePerformanceReconciliation, saleReconciliationPage);
        this.calculateMoney(salePerformanceReconciliation, saleReconciliationPage);
        this.invokeBaseRpcService.addStatusLog(salePerformanceReconciliation.getRelationId(), ReconciliationStatusEmun.NEW.getValue(), "salePerformanceReconciliation", "inster");
    }

    private void insertData(SalePerformanceReconciliation salePerformanceReconciliation, SalePerformanceReconciliationVO salePerformanceReconciliationVO) {
        this.deleteDetail(salePerformanceReconciliationVO.getId());
        List<SaleRecCharge> saleRecChargeList = salePerformanceReconciliationVO.getSaleRecChargeList();
        List<SaleRecContractPromise> saleRecContractPromiseList = salePerformanceReconciliationVO.getSaleRecContractPromiseList();
        List<SaleRecContractAcceptance> saleRecContractAcceptanceList = salePerformanceReconciliationVO.getSaleRecContractAcceptanceList();
        List<SalePrePaymentWriteOffReconciliation> prePaymentWriteOffList = salePerformanceReconciliationVO.getSalePrePaymentWriteOffReconciliationList();
        this.insertContractPromise(salePerformanceReconciliation, saleRecContractPromiseList);
        this.insertContractAcceptance(salePerformanceReconciliation, saleRecContractAcceptanceList);
        this.insertDeductCost(salePerformanceReconciliation, saleRecChargeList);
        this.insertPrePaymentWriteOff(salePerformanceReconciliation, prePaymentWriteOffList);
    }

    private void insertPrePaymentWriteOff(SalePerformanceReconciliation salePerformanceReconciliation, List<SalePrePaymentWriteOffReconciliation> prePaymentWriteOffList) {
        if (CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            return;
        }
        int itemNumber = 1;
        for (SalePrePaymentWriteOffReconciliation prePaymentWriteOff : prePaymentWriteOffList) {
            prePaymentWriteOff.setHeadId(salePerformanceReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)prePaymentWriteOff, (BaseEntity)salePerformanceReconciliation);
            prePaymentWriteOff.setReconciliationNumber(salePerformanceReconciliation.getReconciliationNumber());
            prePaymentWriteOff.setItemNumber(String.valueOf(itemNumber));
            prePaymentWriteOff.setBusAccount(salePerformanceReconciliation.getToElsAccount());
            prePaymentWriteOff.setToElsAccount(salePerformanceReconciliation.getToElsAccount());
        }
        if (!CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            this.salePrePaymentWriteOffReconciliationService.saveBatch(prePaymentWriteOffList, 2000);
        }
    }

    public void calculateMoney(SalePerformanceReconciliation reconciliation, SalePerformanceReconciliationVO saleReconciliationVO) {
        List<SaleRecContractPromise> saleRecContractPromiseList = saleReconciliationVO.getSaleRecContractPromiseList();
        List<SaleRecContractAcceptance> saleRecContractAcceptanceList = saleReconciliationVO.getSaleRecContractAcceptanceList();
        List<SaleRecCharge> charges = saleReconciliationVO.getSaleRecChargeList();
        List<SalePrePaymentWriteOffReconciliation> prePaymentWriteOffList = saleReconciliationVO.getSalePrePaymentWriteOffReconciliationList();
        BigDecimal performanceIncludeTaxAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(saleRecContractPromiseList)) {
            performanceIncludeTaxAmount = saleRecContractPromiseList.parallelStream().filter(item -> item.getTotalTaxAmount() != null).map(SaleRecContractPromise::getTotalTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            reconciliation.setPerformanceIncludeTaxAmount(performanceIncludeTaxAmount);
        }
        BigDecimal acceptanceIncludeTaxAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(saleRecContractAcceptanceList)) {
            acceptanceIncludeTaxAmount = saleRecContractAcceptanceList.parallelStream().filter(item -> item.getTaxAmount() != null).map(SaleRecContractAcceptance::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            reconciliation.setAcceptanceIncludeTaxAmount(acceptanceIncludeTaxAmount);
        }
        BigDecimal chargeTotalAmount = BigDecimal.ZERO;
        BigDecimal chargeAmount = BigDecimal.ZERO;
        BigDecimal buckleTicketsAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(charges)) {
            for (SaleRecCharge saleRecCharge : charges) {
                chargeTotalAmount = chargeTotalAmount.add(saleRecCharge.getTotalAmount());
                if (DeductCostTypeEnum.ACCOUNT_DEDUCTION.getValue().equals(saleRecCharge.getDeductionType())) {
                    chargeAmount = chargeAmount.add(saleRecCharge.getTotalAmount());
                }
                if (!DeductCostTypeEnum.TICKET_DEDUCTION.getValue().equals(saleRecCharge.getDeductionType())) continue;
                buckleTicketsAmount = buckleTicketsAmount.add(saleRecCharge.getTotalAmount());
            }
        }
        reconciliation.setChargeTotalAmount(chargeTotalAmount);
        reconciliation.setChargeAmount(chargeAmount);
        reconciliation.setBuckleTicketsAmount(buckleTicketsAmount);
        BigDecimal shouldInvoiceAmount = performanceIncludeTaxAmount.add(acceptanceIncludeTaxAmount).subtract(buckleTicketsAmount);
        reconciliation.setShouldInvoiceAmount(shouldInvoiceAmount);
        BigDecimal closingAmount = shouldInvoiceAmount.subtract(chargeAmount);
        reconciliation.setClosingAmount(closingAmount);
        BigDecimal writtenOffAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            writtenOffAmount = prePaymentWriteOffList.parallelStream().filter(item -> item.getThisWriteOffAmount() != null).map(SalePrePaymentWriteOffReconciliation::getThisWriteOffAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            reconciliation.setWrittenOffAmount(writtenOffAmount);
        }
        BigDecimal settlementAmount = closingAmount.subtract(writtenOffAmount);
        reconciliation.setSettlementAmount(settlementAmount);
        reconciliation.setRemainingUnPaidAmount(settlementAmount);
        this.salePerformanceReconciliationMapper.updateById((Object)reconciliation);
    }

    private void insertDeductCost(SalePerformanceReconciliation saleReconciliation, List<SaleRecCharge> saleRecChargeList) {
        if (CollectionUtils.isEmpty(saleRecChargeList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
        ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
        for (SaleRecCharge entity : saleRecChargeList) {
            entity.setHeadId(saleReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleReconciliation);
            entity.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            entity.setItemNumber(String.valueOf(itemNumber));
            entity.setBusAccount(saleReconciliation.getBusAccount());
            SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)entity.getBusinessId())));
            saleDeductCost.setDeductStatus("1");
            saleDeductCost.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            saleDeductCosts.add(saleDeductCost);
            PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)saleDeductCost.getRelationId())));
            deductCost.setDeductStatus("1");
            deductCost.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            deductCosts.add(deductCost);
            ++itemNumber;
        }
        if (!saleRecChargeList.isEmpty()) {
            this.saleRecChargeService.saveBatch(saleRecChargeList, 2000);
        }
        if (!deductCosts.isEmpty()) {
            this.purchaseDeductCostService.updateBatchById(deductCosts);
        }
        if (!saleDeductCosts.isEmpty()) {
            this.saleDeductCostService.updateBatchById(saleDeductCosts);
        }
    }

    private void insertContractAcceptance(SalePerformanceReconciliation salePerformanceReconciliation, List<SaleRecContractAcceptance> saleRecContractAcceptanceList) {
        if (CollectionUtils.isEmpty(saleRecContractAcceptanceList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<SaleContractAcceptanceDTO> saleContractAcceptanceList = new ArrayList<SaleContractAcceptanceDTO>();
        for (SaleRecContractAcceptance saleRecContractAcceptance : saleRecContractAcceptanceList) {
            saleRecContractAcceptance.setHeadId(salePerformanceReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)saleRecContractAcceptance, (BaseEntity)salePerformanceReconciliation);
            saleRecContractAcceptance.setReconciliationNumber(salePerformanceReconciliation.getReconciliationNumber());
            saleRecContractAcceptance.setItemNumber(String.valueOf(itemNumber));
            saleRecContractAcceptance.setBusAccount(salePerformanceReconciliation.getToElsAccount());
            saleRecContractAcceptance.setToElsAccount(salePerformanceReconciliation.getToElsAccount());
            SaleContractAcceptanceDTO dto = this.saleContractAcceptanceLocalRpcService.getById(saleRecContractAcceptance.getBusinessId());
            dto.setCostStatus("1");
            dto.setReconciliationNumber(salePerformanceReconciliation.getReconciliationNumber());
            saleContractAcceptanceList.add(dto);
            ++itemNumber;
        }
        if (!CollectionUtils.isEmpty(saleRecContractAcceptanceList)) {
            this.saleRecContractAcceptanceService.saveBatch(saleRecContractAcceptanceList);
        }
        if (!CollectionUtils.isEmpty(saleContractAcceptanceList)) {
            this.saleContractAcceptanceLocalRpcService.updateSaleContractAcceptanceItemListById(saleContractAcceptanceList);
        }
    }

    private void insertContractPromise(SalePerformanceReconciliation salePerformanceReconciliation, List<SaleRecContractPromise> saleRecContractPromiseList) {
        if (CollectionUtils.isEmpty(saleRecContractPromiseList)) {
            return;
        }
        ArrayList<SaleContractPromiseDTO> saleContractPromiseList = new ArrayList<SaleContractPromiseDTO>();
        int itemNumber = 1;
        for (SaleRecContractPromise saleRecContractPromise : saleRecContractPromiseList) {
            saleRecContractPromise.setHeadId(salePerformanceReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)saleRecContractPromise, (BaseEntity)salePerformanceReconciliation);
            saleRecContractPromise.setReconciliationNumber(salePerformanceReconciliation.getReconciliationNumber());
            saleRecContractPromise.setItemNumber(String.valueOf(itemNumber));
            saleRecContractPromise.setBusAccount(salePerformanceReconciliation.getToElsAccount());
            saleRecContractPromise.setToElsAccount(salePerformanceReconciliation.getToElsAccount());
            SaleContractPromiseDTO dto = this.saleContractPromiseLocalRpcService.getById(saleRecContractPromise.getBusinessId());
            dto.setReconciliationStatus("1");
            dto.setReconciliationNumber(salePerformanceReconciliation.getReconciliationNumber());
            saleContractPromiseList.add(dto);
            ++itemNumber;
        }
        if (!CollectionUtils.isEmpty(saleRecContractPromiseList)) {
            this.saleRecContractPromiseService.saveBatch(saleRecContractPromiseList);
        }
        if (!CollectionUtils.isEmpty(saleContractPromiseList)) {
            this.saleContractPromiseLocalRpcService.updateSaleContractPromiseItemListById(saleContractPromiseList);
        }
    }

    private void deleteDetail(String id) {
        this.saleRecContractPromiseService.deleteByMainId(id);
        this.saleRecContractAcceptanceService.deleteByMainId(id);
        this.saleRecChargeService.deleteByMainId(id);
        this.salePrePaymentWriteOffReconciliationService.deleteByMainId(id);
        this.saleInvoiceMapper.deleteByMainId(id);
    }

    private void buildReconciliation(SalePerformanceReconciliation salePerformanceReconciliation) {
        String reconciliationNumber = this.invokeBaseRpcService.getNextCode("salePerformanceReconciliation", (Object)salePerformanceReconciliation, salePerformanceReconciliation.getBusAccount());
        salePerformanceReconciliation.setReconciliationNumber(reconciliationNumber);
        salePerformanceReconciliation.setBusAccount(salePerformanceReconciliation.getToElsAccount());
        TemplateHeadDTO templateHead = this.templateHeadService.getById(salePerformanceReconciliation.getTemplateNumber());
        if (templateHead != null) {
            salePerformanceReconciliation.setTemplateName(templateHead.getTemplateName());
            salePerformanceReconciliation.setTemplateNumber(templateHead.getTemplateNumber());
            salePerformanceReconciliation.setTemplateVersion(String.valueOf(templateHead.getTemplateVersion()));
            salePerformanceReconciliation.setTemplateAccount(templateHead.getElsAccount());
        }
        salePerformanceReconciliation.setCreateAccount(TenantContext.getTenant());
        salePerformanceReconciliation.setSaleRecAffirmStatus(SaleStatusEmun.NEW.getValue());
        salePerformanceReconciliation.setSaleRecSendStatus("0");
        salePerformanceReconciliation.setInvoiced("0");
        salePerformanceReconciliation.setCancellation("0");
        ElsEnterpriseInfoDTO enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(TenantContext.getTenant());
        if (enterpriseInfo != null) {
            salePerformanceReconciliation.setSupplierName(enterpriseInfo.getName());
        }
        if ((enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(salePerformanceReconciliation.getToElsAccount())) != null) {
            salePerformanceReconciliation.setPurchaseName(enterpriseInfo.getName());
        }
        salePerformanceReconciliation.setRelationId(IdWorker.getIdStr());
        salePerformanceReconciliation.setToElsAccount(salePerformanceReconciliation.getToElsAccount());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> updateMain(SalePerformanceReconciliation salePerformanceReconciliation, SalePerformanceReconciliationVO saleReconciliationPage) {
        this.cancelContractPromise(salePerformanceReconciliation.getId(), null);
        this.cancelContractAcceptance(salePerformanceReconciliation.getId(), null);
        this.cancelCharges(salePerformanceReconciliation.getId(), null);
        this.salePerformanceReconciliationMapper.updateById((Object)salePerformanceReconciliation);
        this.calculateMoney(salePerformanceReconciliation, saleReconciliationPage);
        this.insertData(salePerformanceReconciliation, saleReconciliationPage);
        return Result.ok();
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.cancelContractPromise(id, null);
        this.cancelContractAcceptance(id, null);
        this.cancelCharges(id, null);
        this.deleteDetail(id);
        this.salePerformanceReconciliationMapper.deleteById((Serializable)((Object)id));
    }

    private void cancelContractPromise(String id, List<String> existIds) {
        List<SaleRecContractPromise> saleRecContractPromiseList = this.saleRecContractPromiseService.selectByMainId(id);
        if (CollectionUtils.isEmpty(saleRecContractPromiseList)) {
            return;
        }
        ArrayList<SaleContractPromiseDTO> contractPromiseList = new ArrayList<SaleContractPromiseDTO>();
        for (SaleRecContractPromise saleRecContractPromise : saleRecContractPromiseList) {
            SaleContractPromiseDTO contractPromise;
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(saleRecContractPromise.getBusinessId()) || (contractPromise = this.saleContractPromiseLocalRpcService.getById(saleRecContractPromise.getBusinessId())) == null) continue;
            contractPromise.setReconciliationStatus("0");
            contractPromise.setReconciliationNumber(null);
            contractPromiseList.add(contractPromise);
        }
        if (!CollectionUtils.isEmpty(contractPromiseList)) {
            this.saleContractPromiseLocalRpcService.updateSaleContractPromiseItemListById(contractPromiseList);
        }
    }

    private void cancelContractAcceptance(String id, List<String> existIds) {
        List<SaleRecContractAcceptance> saleRecContractAcceptanceList = this.saleRecContractAcceptanceService.selectByMainId(id);
        if (CollectionUtils.isEmpty(saleRecContractAcceptanceList)) {
            return;
        }
        ArrayList<SaleContractAcceptanceDTO> saleContractAcceptanceList = new ArrayList<SaleContractAcceptanceDTO>();
        for (SaleRecContractAcceptance saleRecContractAcceptance : saleRecContractAcceptanceList) {
            SaleContractAcceptanceDTO saleContractAcceptanceDTO;
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(saleRecContractAcceptance.getBusinessId()) || (saleContractAcceptanceDTO = this.saleContractAcceptanceLocalRpcService.getById(saleRecContractAcceptance.getBusinessId())) == null) continue;
            saleContractAcceptanceDTO.setCostStatus("0");
            saleContractAcceptanceDTO.setReconciliationNumber(null);
            saleContractAcceptanceList.add(saleContractAcceptanceDTO);
        }
        if (!CollectionUtils.isEmpty(saleContractAcceptanceList)) {
            this.saleContractAcceptanceLocalRpcService.updateSaleContractAcceptanceItemListById(saleContractAcceptanceList);
        }
    }

    private void cancelCharges(String id, List<String> existIds) {
        List<SaleRecCharge> charges = this.saleRecChargeService.selectByMainId(id);
        if (CollectionUtils.isEmpty(charges)) {
            return;
        }
        ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
        ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
        for (SaleRecCharge charge : charges) {
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(charge.getBusinessId())) continue;
            SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)charge.getBusinessId())));
            saleDeductCost.setDeductStatus("0");
            saleDeductCost.setReconciliationNumber(null);
            saleDeductCosts.add(saleDeductCost);
            PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)saleDeductCost.getRelationId())));
            deductCost.setDeductStatus("0");
            deductCost.setReconciliationNumber(null);
            deductCosts.add(deductCost);
        }
        if (!deductCosts.isEmpty()) {
            this.purchaseDeductCostService.updateBatchById(deductCosts);
        }
        if (!saleDeductCosts.isEmpty()) {
            this.saleDeductCostService.updateBatchById(saleDeductCosts);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirmOrRefused(SalePerformanceReconciliation saleReconciliation, String operation) {
        String opt = null;
        if ("confirm".equals(operation)) {
            saleReconciliation.setReconciliationStatus(ReconciliationStatusEmun.COMFIRMED.getValue());
            opt = "confirm";
        } else if ("refused".equals(operation)) {
            saleReconciliation.setReconciliationStatus(ReconciliationStatusEmun.REFUSED.getValue());
            opt = "refund";
            this.elsPurchaseStatisticsWriteOffService.cancelReleaseAmountBySale(saleReconciliation.getRelationId(), saleReconciliation.getToElsAccount(), saleReconciliation.getElsAccount());
        }
        this.updateById((Object)saleReconciliation);
        this.invokeBaseRpcService.addStatusLog(saleReconciliation.getRelationId(), saleReconciliation.getReconciliationStatus(), "reconciliation", opt);
        PurchasePerformanceReconciliation purchaseReconciliation = (PurchasePerformanceReconciliation)((Object)this.purchasePerformanceReconciliationMapper.selectById((Serializable)((Object)saleReconciliation.getRelationId())));
        if (purchaseReconciliation != null) {
            purchaseReconciliation.setReconciliationStatus(saleReconciliation.getReconciliationStatus());
            purchaseReconciliation.setSaleRemark(saleReconciliation.getSaleRemark());
            purchaseReconciliation.setRelationId(saleReconciliation.getId());
            this.purchasePerformanceReconciliationMapper.updateById((Object)purchaseReconciliation);
        }
        this.handleMessage(saleReconciliation, opt, purchaseReconciliation);
    }

    private void handleMessage(SalePerformanceReconciliation saleReconciliation, String opt, PurchasePerformanceReconciliation purchaseReconciliation) {
        String serviceAddress = (String)this.staticConfig.getConfig().get("service.address");
        saleReconciliation.setFbk18(serviceAddress + "/srm/reconciliation/sale/SaleReconciliation?id=" + saleReconciliation.getId() + "&open=true&toInvoice=true");
        if (!StringUtils.isEmpty((CharSequence)opt) && purchaseReconciliation != null) {
            String url = "id=" + purchaseReconciliation.getId() + "&createAccount=" + purchaseReconciliation.getCreateAccount();
            if (StringUtils.isNotBlank((CharSequence)saleReconciliation.getPurchasePrincipal())) {
                super.sendMsg(saleReconciliation.getBusAccount(), saleReconciliation.getToElsAccount(), saleReconciliation.getPurchasePrincipal(), (Object)saleReconciliation, url, "reconciliation", opt);
                super.sendMsg(saleReconciliation.getBusAccount(), saleReconciliation.getElsAccount(), saleReconciliation.getPurchasePrincipal(), (Object)saleReconciliation, url, "saleReconciliation", opt);
            } else {
                super.sendMsg(saleReconciliation.getBusAccount(), saleReconciliation.getToElsAccount(), (Object)saleReconciliation, url, "reconciliation", opt);
                super.sendMsg(saleReconciliation.getBusAccount(), saleReconciliation.getElsAccount(), (Object)saleReconciliation, url, "saleReconciliation", opt);
            }
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveInvoice(SalePerformanceReconciliation salePerformanceReconciliation, List<SaleInvoice> saleInvoiceList, String operation) {
        this.saleInvoiceMapper.deleteByMainId(salePerformanceReconciliation.getId());
        BigDecimal invoiceTotalAmount = new BigDecimal(0);
        for (SaleInvoice saleInvoice : saleInvoiceList) {
            saleInvoice.setId(null);
            if (StringUtils.isBlank((CharSequence)saleInvoice.getInvoiceNumber())) {
                saleInvoice.setInvoiceNumber(this.invokeBaseRpcService.getNextCode("invoiceNumber", (Object)saleInvoice, salePerformanceReconciliation.getToElsAccount()));
            }
            if ("save".equals(operation)) {
                if (!InvoiceStatusEnum.RENTURNED.getValue().equals(saleInvoice.getStatus())) {
                    saleInvoice.setStatus(InvoiceStatusEnum.NEW.getValue());
                }
            } else if ("send".equals(operation)) {
                saleInvoice.setStatus(InvoiceStatusEnum.UNCONFIRMED.getValue());
            }
            if (saleInvoice.getNotIncludeTaxAmount() == null) {
                BigDecimal tax = new BigDecimal(saleInvoice.getTaxRate()).divide(new BigDecimal(100)).add(BigDecimal.ONE);
                saleInvoice.setNotIncludeTaxAmount(saleInvoice.getIncludeTaxAmount().divide(tax, 5));
            }
            if (saleInvoice.getTaxAmount() == null) {
                saleInvoice.setTaxAmount(saleInvoice.getIncludeTaxAmount().subtract(saleInvoice.getNotIncludeTaxAmount()));
            }
            saleInvoice.setReconciliationNumber(salePerformanceReconciliation.getReconciliationNumber());
            saleInvoice.setBusAccount(salePerformanceReconciliation.getToElsAccount());
            saleInvoice.setToElsAccount(salePerformanceReconciliation.getToElsAccount());
            saleInvoice.setHeadId(salePerformanceReconciliation.getId());
            String documentId = salePerformanceReconciliation.getDocumentId();
            if (!StringUtils.isEmpty((CharSequence)documentId)) {
                saleInvoice.setDocumentId(documentId);
            }
            saleInvoice.setDocumentParentId(salePerformanceReconciliation.getRelationId());
            SysUtil.setSysParam((BaseEntity)saleInvoice, (BaseEntity)salePerformanceReconciliation);
            invoiceTotalAmount = invoiceTotalAmount.add(saleInvoice.getIncludeTaxAmount());
        }
        salePerformanceReconciliation.setTotalInvoiceAmount(invoiceTotalAmount);
        this.salePerformanceReconciliationMapper.updateById((Object)salePerformanceReconciliation);
        if (!saleInvoiceList.isEmpty()) {
            this.saleInvoiceMapper.insertBatchSomeColumn(saleInvoiceList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void sendInvoice(SalePerformanceReconciliation salePerformanceReconciliation, List<SaleInvoice> saleInvoiceList) {
        salePerformanceReconciliation.setInvoiced("1");
        salePerformanceReconciliation.setPurchaseInvoiceAffirmStatus(InvoiceConfirmStatusEnum.UNCONFIRMED.getValue());
        this.saveInvoice(salePerformanceReconciliation, saleInvoiceList, "send");
        PurchasePerformanceReconciliation purchasePerformanceReconciliation = (PurchasePerformanceReconciliation)((Object)this.purchasePerformanceReconciliationMapper.selectById((Serializable)((Object)salePerformanceReconciliation.getRelationId())));
        if (purchasePerformanceReconciliation != null) {
            purchasePerformanceReconciliation.setInvoiced("1");
            purchasePerformanceReconciliation.setRelationId(salePerformanceReconciliation.getId());
            purchasePerformanceReconciliation.setPurchaseInvoiceAffirmStatus(InvoiceConfirmStatusEnum.UNCONFIRMED.getValue());
            purchasePerformanceReconciliation.setTotalInvoiceAmount(salePerformanceReconciliation.getTotalInvoiceAmount());
            purchasePerformanceReconciliation.setSaleRemark(salePerformanceReconciliation.getSaleRemark());
            this.purchasePerformanceReconciliationMapper.updateById((Object)purchasePerformanceReconciliation);
            this.purchaseInvoiceMapper.deleteByMainId(purchasePerformanceReconciliation.getId());
            ArrayList<PurchaseInvoice> purchaseInvoices = new ArrayList<PurchaseInvoice>();
            for (SaleInvoice saleInvoice : saleInvoiceList) {
                PurchaseInvoice purchaseInvoice = new PurchaseInvoice();
                BeanUtils.copyProperties((Object)((Object)saleInvoice), (Object)((Object)purchaseInvoice));
                purchaseInvoice.setRelationId(saleInvoice.getId());
                purchaseInvoice.setElsAccount(purchasePerformanceReconciliation.getElsAccount());
                purchaseInvoice.setToElsAccount(purchasePerformanceReconciliation.getToElsAccount());
                purchaseInvoice.setHeadId(purchasePerformanceReconciliation.getId());
                purchaseInvoice.setId(null);
                purchaseInvoices.add(purchaseInvoice);
            }
            this.sendMessage(salePerformanceReconciliation, purchasePerformanceReconciliation, "invoice");
            this.purchaseInvoiceMapper.insertBatchSomeColumn(purchaseInvoices);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public SalePerformanceReconciliationVO extractReconciliation(SalePerformanceReconciliationVO reconciliationVO) {
        ReconciliationVO vo = new ReconciliationVO();
        BeanUtils.copyProperties((Object)((Object)reconciliationVO), (Object)vo);
        SaleContractPromiseDTO saleContractPromiseDTO = new SaleContractPromiseDTO();
        BeanUtils.copyProperties((Object)((Object)reconciliationVO), (Object)saleContractPromiseDTO);
        List<SaleContractPromiseDTO> saleContractPromiseList = this.saleContractPromiseLocalRpcService.listSaleContractPromiseDTO(saleContractPromiseDTO);
        List<SaleRecContractPromise> saleRecContractPromiseList = this.getSaleRecContractPromiseList(saleContractPromiseList);
        reconciliationVO.setSaleRecContractPromiseList(saleRecContractPromiseList);
        SaleContractAcceptanceDTO saleContractAcceptanceDTO = new SaleContractAcceptanceDTO();
        BeanUtils.copyProperties((Object)((Object)reconciliationVO), (Object)saleContractAcceptanceDTO);
        List<SaleContractAcceptanceDTO> saleContractAcceptanceList = this.saleContractAcceptanceLocalRpcService.listSaleContractAcceptanceDTO(saleContractAcceptanceDTO);
        List<SaleRecContractAcceptance> saleRecContractAcceptanceList = this.getSaleRecContractAcceptanceList(saleContractAcceptanceList);
        reconciliationVO.setSaleRecContractAcceptanceList(saleRecContractAcceptanceList);
        List<SaleRecCharge> charges = this.saleDeductCostService.getBySaleDeductCost(vo);
        reconciliationVO.setSaleRecChargeList(charges);
        List<SalePrePaymentWriteOffReconciliation> prePaymentWriteOff = this.salePaymentApplyItemService.getSalePrePaymentWriteOffReconciliations(vo);
        reconciliationVO.setSalePrePaymentWriteOffReconciliationList(prePaymentWriteOff);
        return reconciliationVO;
    }

    private List<SaleRecContractAcceptance> getSaleRecContractAcceptanceList(List<SaleContractAcceptanceDTO> saleContractAcceptanceList) {
        ArrayList<SaleRecContractAcceptance> list = new ArrayList<SaleRecContractAcceptance>();
        for (SaleContractAcceptanceDTO saleContractAcceptanceDTO : saleContractAcceptanceList) {
            SaleRecContractAcceptance dto = new SaleRecContractAcceptance();
            BeanUtils.copyProperties((Object)saleContractAcceptanceDTO, (Object)((Object)dto));
            dto.setId(null);
            dto.setBusinessId(saleContractAcceptanceDTO.getId());
            list.add(dto);
        }
        return list;
    }

    private List<SaleRecContractPromise> getSaleRecContractPromiseList(List<SaleContractPromiseDTO> saleContractPromiseList) {
        ArrayList<SaleRecContractPromise> list = new ArrayList<SaleRecContractPromise>();
        if (CollectionUtils.isEmpty(saleContractPromiseList)) {
            return list;
        }
        for (SaleContractPromiseDTO saleContractPromiseDTO : saleContractPromiseList) {
            SaleRecContractPromise dto = new SaleRecContractPromise();
            BeanUtils.copyProperties((Object)saleContractPromiseDTO, (Object)((Object)dto));
            dto.setMasterContractNumber(saleContractPromiseDTO.getContractNumber());
            dto.setContractParties("\u7b7e\u7ea6\u65b9");
            dto.setContractPromise(saleContractPromiseDTO.getPerformingPartyName());
            dto.setContractDrawer(saleContractPromiseDTO.getInvoicedName());
            dto.setContractReceiver(saleContractPromiseDTO.getPayeeName());
            dto.setBusinessId(saleContractPromiseDTO.getId());
            dto.setId(null);
            list.add(dto);
        }
        return list;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> publish(SalePerformanceReconciliation salePerformanceReconciliation, SalePerformanceReconciliationVO saleReconciliationVO) {
        boolean flag = false;
        if (SaleStatusEmun.REFUSED.getValue().equals(salePerformanceReconciliation.getSaleRecAffirmStatus()) && StringUtils.isNotBlank((CharSequence)salePerformanceReconciliation.getRelationId())) {
            flag = true;
        }
        salePerformanceReconciliation.setSaleRecAffirmStatus(SaleStatusEmun.UNCONFIRMED.getValue());
        salePerformanceReconciliation.setSaleRecSendStatus("1");
        this.updateMain(salePerformanceReconciliation, saleReconciliationVO);
        this.invokeBaseRpcService.addStatusLog(salePerformanceReconciliation.getRelationId(), salePerformanceReconciliation.getReconciliationStatus(), "saleReconciliation", "publish");
        String id = salePerformanceReconciliation.getRelationId();
        PurchasePerformanceReconciliation purchaseReconciliation = new PurchasePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)salePerformanceReconciliation), (Object)((Object)purchaseReconciliation));
        purchaseReconciliation.setElsAccount(salePerformanceReconciliation.getToElsAccount());
        purchaseReconciliation.setToElsAccount(salePerformanceReconciliation.getElsAccount());
        purchaseReconciliation.setRelationId(salePerformanceReconciliation.getId());
        if (flag) {
            purchaseReconciliation.setId(id);
            purchaseReconciliation.setReconciliationStatus(purchaseReconciliation.getReconciliationStatus());
            this.purchasePerformanceReconciliationMapper.updateById((Object)purchaseReconciliation);
            this.handleDetail(purchaseReconciliation, saleReconciliationVO);
        } else {
            purchaseReconciliation.setId(id);
            this.purchasePerformanceReconciliationMapper.insert((Object)purchaseReconciliation);
            this.handleDetail(purchaseReconciliation, saleReconciliationVO);
            salePerformanceReconciliation.setRelationId(purchaseReconciliation.getId());
        }
        this.sendMessage(salePerformanceReconciliation, purchaseReconciliation, "saleReconciliation");
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_hxLRW_c95760c0", (String)"\u53d1\u5e03\u6210\u529f\uff01"));
    }

    private void handleDetail(PurchasePerformanceReconciliation purchasePerformanceReconciliation, SalePerformanceReconciliationVO reconciliationVO) {
        List<SaleRecContractPromise> saleRecContractPromiseList = reconciliationVO.getSaleRecContractPromiseList();
        List<SaleRecContractAcceptance> saleRecContractAcceptanceList = reconciliationVO.getSaleRecContractAcceptanceList();
        List<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffList = reconciliationVO.getSalePrePaymentWriteOffReconciliationList();
        List<SaleRecCharge> saleRecChargeList = reconciliationVO.getSaleRecChargeList();
        List<SaleAttachmentDTO> attachments = reconciliationVO.getAttachments();
        this.purchasePerformanceReconciliationService.deleteDetail(purchasePerformanceReconciliation.getId());
        this.handlePurchaseRecContractPromiseDetail(purchasePerformanceReconciliation, saleRecContractPromiseList);
        this.handlePurchaseRecContractAcceptanceDetail(purchasePerformanceReconciliation, saleRecContractAcceptanceList);
        this.handlePurchaseRecChargeDetail(purchasePerformanceReconciliation, saleRecChargeList);
        this.handlePurchaseRecPrePaymentWriteOffDetail(purchasePerformanceReconciliation, salePrePaymentWriteOffList);
        this.handlePurchaseAttachmentDetail(purchasePerformanceReconciliation, attachments);
    }

    private void handlePurchaseRecPrePaymentWriteOffDetail(PurchasePerformanceReconciliation purchasePerformanceReconciliation, List<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffList) {
        if (CollectionUtils.isEmpty(salePrePaymentWriteOffList)) {
            return;
        }
        ArrayList<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList = new ArrayList<PurchasePrePaymentWriteOffReconciliation>();
        for (SalePrePaymentWriteOffReconciliation prePaymentWriteOff : salePrePaymentWriteOffList) {
            PurchasePrePaymentWriteOffReconciliation prePaymentWriteOffReconciliation = new PurchasePrePaymentWriteOffReconciliation();
            BeanUtils.copyProperties((Object)((Object)prePaymentWriteOff), (Object)((Object)prePaymentWriteOffReconciliation));
            prePaymentWriteOffReconciliation.setId(null);
            prePaymentWriteOffReconciliation.setElsAccount(purchasePerformanceReconciliation.getElsAccount());
            prePaymentWriteOffReconciliation.setToElsAccount(purchasePerformanceReconciliation.getToElsAccount());
            prePaymentWriteOffReconciliation.setHeadId(purchasePerformanceReconciliation.getId());
            prePaymentWriteOffReconciliation.setRelationId(prePaymentWriteOff.getId());
            purchasePrePaymentWriteOffList.add(prePaymentWriteOffReconciliation);
        }
        this.purchasePrePaymentWriteOffReconciliationMapper.insertBatchSomeColumn(purchasePrePaymentWriteOffList);
    }

    private void handlePurchaseRecContractAcceptanceDetail(PurchasePerformanceReconciliation purchasePerformanceReconciliation, List<SaleRecContractAcceptance> saleRecContractAcceptanceList) {
        if (CollectionUtils.isEmpty(saleRecContractAcceptanceList)) {
            return;
        }
        ArrayList<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = new ArrayList<PurchaseRecContractAcceptance>();
        for (SaleRecContractAcceptance saleRecContractAcceptance : saleRecContractAcceptanceList) {
            PurchaseRecContractAcceptance purchaseRecContractAcceptance = new PurchaseRecContractAcceptance();
            BeanUtils.copyProperties((Object)((Object)saleRecContractAcceptance), (Object)((Object)purchaseRecContractAcceptance));
            purchaseRecContractAcceptance.setId(null);
            purchaseRecContractAcceptance.setElsAccount(purchasePerformanceReconciliation.getElsAccount());
            purchaseRecContractAcceptance.setToElsAccount(purchasePerformanceReconciliation.getToElsAccount());
            purchaseRecContractAcceptance.setHeadId(purchasePerformanceReconciliation.getId());
            purchaseRecContractAcceptance.setRelationId(saleRecContractAcceptance.getId());
            purchaseRecContractAcceptanceList.add(purchaseRecContractAcceptance);
        }
        this.purchaseRecContractAcceptanceMapper.insertBatchSomeColumn(purchaseRecContractAcceptanceList);
    }

    private void handlePurchaseRecContractPromiseDetail(PurchasePerformanceReconciliation purchasePerformanceReconciliation, List<SaleRecContractPromise> saleRecContractPromiseList) {
        if (CollectionUtils.isEmpty(saleRecContractPromiseList)) {
            return;
        }
        ArrayList<PurchaseRecContractPromise> purchaseRecContractPromiseList = new ArrayList<PurchaseRecContractPromise>();
        for (SaleRecContractPromise saleRecContractPromise : saleRecContractPromiseList) {
            PurchaseRecContractPromise purchaseRecContractPromise = new PurchaseRecContractPromise();
            BeanUtils.copyProperties((Object)((Object)saleRecContractPromise), (Object)((Object)purchaseRecContractPromise));
            purchaseRecContractPromise.setId(null);
            purchaseRecContractPromise.setElsAccount(purchasePerformanceReconciliation.getElsAccount());
            purchaseRecContractPromise.setToElsAccount(purchasePerformanceReconciliation.getToElsAccount());
            purchaseRecContractPromise.setHeadId(purchasePerformanceReconciliation.getId());
            purchaseRecContractPromise.setRelationId(saleRecContractPromise.getId());
            purchaseRecContractPromiseList.add(purchaseRecContractPromise);
        }
        this.purchaseRecContractPromiseMapper.insertBatchSomeColumn(purchaseRecContractPromiseList);
    }

    private void handlePurchaseRecChargeDetail(PurchasePerformanceReconciliation purchaseReconciliation, List<SaleRecCharge> saleRecChargeList) {
        if (CollectionUtils.isEmpty(saleRecChargeList)) {
            return;
        }
        ArrayList<PurchaseRecCharge> purchaseRecCharges = new ArrayList<PurchaseRecCharge>();
        for (SaleRecCharge saleRecCharge : saleRecChargeList) {
            PurchaseRecCharge purchaseRecCharge = new PurchaseRecCharge();
            BeanUtils.copyProperties((Object)((Object)saleRecCharge), (Object)((Object)purchaseRecCharge));
            purchaseRecCharge.setId(null);
            purchaseRecCharge.setElsAccount(purchaseReconciliation.getElsAccount());
            purchaseRecCharge.setToElsAccount(purchaseReconciliation.getToElsAccount());
            purchaseRecCharge.setHeadId(purchaseReconciliation.getId());
            purchaseRecCharge.setRelationId(saleRecCharge.getId());
            purchaseRecCharges.add(purchaseRecCharge);
        }
        this.purchaseRecChargeMapper.insertBatchSomeColumn(purchaseRecCharges);
    }

    private void handlePurchaseAttachmentDetail(PurchasePerformanceReconciliation purchaseReconciliation, List<SaleAttachmentDTO> attachments) {
        if (CollectionUtils.isEmpty(attachments)) {
            return;
        }
        ArrayList<PurchaseAttachmentDTO> purchaseAttachments = new ArrayList<PurchaseAttachmentDTO>();
        for (SaleAttachmentDTO saleAttachment : attachments) {
            saleAttachment.setSendStatus("1");
            PurchaseAttachmentDTO purchaseAttachment = new PurchaseAttachmentDTO();
            BeanUtils.copyProperties((Object)saleAttachment, (Object)purchaseAttachment);
            purchaseAttachment.setId(null);
            purchaseAttachment.setElsAccount(purchaseReconciliation.getElsAccount());
            purchaseAttachment.setHeadId(purchaseReconciliation.getId());
            purchaseAttachment.setRelationId(saleAttachment.getId());
            purchaseAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
            purchaseAttachments.add(purchaseAttachment);
        }
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachments);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void emailConfirmOrRefuesd(String id, String operation) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BaseEntity::getId, (Object)id);
        SalePerformanceReconciliation salePerformanceReconciliation = (SalePerformanceReconciliation)((Object)this.getOne((Wrapper)lambdaQueryWrapper));
        if (salePerformanceReconciliation != null) {
            this.confirmOrRefused(salePerformanceReconciliation, operation);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delete(String id) {
        ((SalePerformanceReconciliationMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteBatch(List<String> idList) {
        ((SalePerformanceReconciliationMapper)this.baseMapper).deleteBatchIds(idList);
    }

    private void sendMessage(SalePerformanceReconciliation salePerformanceReconciliation, PurchasePerformanceReconciliation purchasePerformanceReconciliation, String invoice) {
        String url = "id=" + purchasePerformanceReconciliation.getId() + "&createAccount=" + purchasePerformanceReconciliation.getCreateAccount();
        if (StringUtils.isNotBlank((CharSequence)salePerformanceReconciliation.getPurchasePrincipal())) {
            super.sendMsg(salePerformanceReconciliation.getBusAccount(), salePerformanceReconciliation.getToElsAccount(), salePerformanceReconciliation.getPurchasePrincipal(), (Object)salePerformanceReconciliation, url, invoice, "publish");
        } else {
            super.sendMsg(salePerformanceReconciliation.getBusAccount(), salePerformanceReconciliation.getToElsAccount(), (Object)salePerformanceReconciliation, url, invoice, "publish");
        }
    }
}

