/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.confirm.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.confirm.entity.PurchaseReconciliationConfirmation;
import com.els.modules.confirm.entity.PurchaseReconciliationConfirmationUnpaidAccount;
import com.els.modules.confirm.excel.PurchaseReconciliationConfirmationExportServiceImpl;
import com.els.modules.confirm.service.PurchaseReconciliationConfirmationBookBalanceService;
import com.els.modules.confirm.service.PurchaseReconciliationConfirmationDifferenceDescriptionService;
import com.els.modules.confirm.service.PurchaseReconciliationConfirmationService;
import com.els.modules.confirm.service.PurchaseReconciliationConfirmationUnpaidAccountService;
import com.els.modules.reconciliation.enumerate.OperationEnum;
import com.els.modules.reconciliation.vo.PurchaseReconciliationConfirmationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u5f80\u6765\u5bf9\u8d26\u786e\u8ba4\u51fd"})
@RestController
@RequestMapping(value={"/reconciliation/purchaseReconciliationConfirmation"})
public class PurchaseReconciliationConfirmationController
extends BaseController<PurchaseReconciliationConfirmation, PurchaseReconciliationConfirmationService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseReconciliationConfirmationController.class);
    @Autowired
    private PurchaseReconciliationConfirmationService purchaseReconciliationConfirmationService;
    @Autowired
    private PurchaseReconciliationConfirmationBookBalanceService purchaseReconciliationConfirmationBookBalanceService;
    @Autowired
    private PurchaseReconciliationConfirmationDifferenceDescriptionService purchaseReconciliationConfirmationDifferenceDescriptionService;
    @Autowired
    private PurchaseReconciliationConfirmationUnpaidAccountService purchaseReconciliationConfirmationUnpaidAccountService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String LOCK_KEY = "srm_purchaseReconciliationConfirmation_";
    private static final Long LOCK_EXPIRE_TIME = 30000L;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"finance#purchaseReconciliationConfirmation:list"})
    @PermissionDataView(businessType="purchaseReconciliationConfirmation")
    public Result<?> queryPageList(PurchaseReconciliationConfirmation purchaseReconciliationConfirmation, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseReconciliationConfirmation), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseReconciliationConfirmationService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u5f80\u6765\u5bf9\u8d26\u786e\u8ba4\u51fd-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"finance#purchaseReconciliationConfirmation:add"})
    @FormCommit
    public Result<?> add(@RequestBody PurchaseReconciliationConfirmationVO vo) {
        PurchaseReconciliationConfirmation purchaseReconciliationConfirmation = new PurchaseReconciliationConfirmation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseReconciliationConfirmation));
        this.purchaseReconciliationConfirmationService.saveMain(purchaseReconciliationConfirmation, vo);
        return Result.ok((Object)((Object)purchaseReconciliationConfirmation));
    }

    @SrmValidated
    @AutoLog(value="\u5f80\u6765\u5bf9\u8d26\u786e\u8ba4\u51fd-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"finance#purchaseReconciliationConfirmation:edit"})
    public Result<?> edit(@RequestBody PurchaseReconciliationConfirmationVO vo) {
        PurchaseReconciliationConfirmation purchaseReconciliationConfirmation = new PurchaseReconciliationConfirmation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseReconciliationConfirmation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIexiKRcsSTVBtk_139b0f3", (String)"\u5f53\u524d\u5bf9\u8d26\u51fd\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.purchaseReconciliationConfirmationService.updateMain(purchaseReconciliationConfirmation, vo);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        String id = purchaseReconciliationConfirmation.getId();
        return this.queryById(id);
    }

    @AutoLog(value="\u5f80\u6765\u5bf9\u8d26\u786e\u8ba4\u51fd-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"finance#purchaseReconciliationConfirmation:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseReconciliationConfirmationService.delete(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"finance#purchaseReconciliationConfirmation:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseReconciliationConfirmationVO vo = new PurchaseReconciliationConfirmationVO();
        PurchaseReconciliationConfirmation purchaseReconciliationConfirmation = (PurchaseReconciliationConfirmation)((Object)this.purchaseReconciliationConfirmationService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        BeanUtils.copyProperties((Object)((Object)purchaseReconciliationConfirmation), (Object)((Object)vo));
        vo.setBalance(this.purchaseReconciliationConfirmationBookBalanceService.selectByMainId(id));
        vo.setUnpaidAccountItem(this.purchaseReconciliationConfirmationUnpaidAccountService.selectByMainId(id));
        vo.setDifferenceDescription(this.purchaseReconciliationConfirmationDifferenceDescriptionService.selectByMainId(id));
        vo.setAttachments(this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id));
        return Result.ok((Object)((Object)vo));
    }

    @SrmValidated
    @AutoLog(value="\u91c7\u8d2d\u5f80\u6765\u5bf9\u8d26-\u53d1\u5e03", logType=2)
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"finance#purchaseReconciliationConfirmation:publish"})
    public Result<?> publish(@RequestBody PurchaseReconciliationConfirmationVO vo) {
        Result result = new Result();
        PurchaseReconciliationConfirmation confirmation = new PurchaseReconciliationConfirmation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)confirmation));
        if (!this.redisUtil.tryGetDistributedLock("supplier_confirmation_", confirmation.getToElsAccount(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_AvjDiKUmRdXIeVRSsK_72c19add", (String)"\u5176\u4ed6\u7528\u6237\u6b63\u5728\u4e0e\u6b64\u4f9b\u5e94\u5546\u5bf9\u8d26\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01"));
        }
        try {
            result = this.purchaseReconciliationConfirmationService.publish(confirmation, vo);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock("supplier_confirmation_", confirmation.getToElsAccount());
        }
        return result;
    }

    @AutoLog(value="\u91c7\u8d2d\u5bf9\u8d26\u51fd-\u9500\u552e\u786e\u8ba4")
    @ApiOperation(value="\u9500\u552e\u786e\u8ba4", notes="\u9500\u552e\u786e\u8ba4")
    @PostMapping(value={"/confirm"})
    @RequiresPermissions(value={"finance#purchaseReconciliationConfirmation:confirm"})
    public Result<?> confirm(@RequestBody PurchaseReconciliationConfirmationVO vo) {
        Result result = new Result();
        PurchaseReconciliationConfirmation purchaseReconciliationConfirmation = new PurchaseReconciliationConfirmation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseReconciliationConfirmation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIexiKRcsSTVBtk_139b0f3", (String)"\u5f53\u524d\u5bf9\u8d26\u51fd\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            result = this.purchaseReconciliationConfirmationService.confirmOrRefused(purchaseReconciliationConfirmation, OperationEnum.CONFIRM.getValue());
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return result;
    }

    @AutoLog(value="\u91c7\u8d2d\u5bf9\u8d26\u51fd-\u9500\u552e\u62d2\u7edd")
    @ApiOperation(value="\u9500\u552e\u62d2\u7edd", notes="\u9500\u552e\u62d2\u7edd")
    @PostMapping(value={"/refuesd"})
    @RequiresPermissions(value={"finance#purchaseReconciliationConfirmation:refuesd"})
    public Result<?> refuesd(@RequestBody PurchaseReconciliationConfirmationVO vo) {
        Result result = new Result();
        PurchaseReconciliationConfirmation purchaseReconciliationConfirmation = new PurchaseReconciliationConfirmation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseReconciliationConfirmation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIexiKRcsSTVBtk_139b0f3", (String)"\u5f53\u524d\u5bf9\u8d26\u51fd\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            result = this.purchaseReconciliationConfirmationService.confirmOrRefused(purchaseReconciliationConfirmation, OperationEnum.REFUSED.getValue());
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return result;
    }

    @ApiOperation(value="\u83b7\u53d6ERP\u6570\u636e", notes="\u83b7\u53d6ERP\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"finance#purchaseReconciliationConfirmation:getDataByErp"})
    public Result<?> getDataByErp() {
        this.purchaseReconciliationConfirmationService.getDataByErp();
        return Result.ok();
    }

    @ApiOperation(value="SRM\u63a8\u9001\u5230ERP", notes="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"finance#purchaseReconciliationConfirmation:pushDataToErp"})
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        this.purchaseReconciliationConfirmationService.pushDataToErp(ids);
        return Result.ok();
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"finance#purchaseReconciliationConfirmation:list"})
    @PermissionDataView(businessType="purchaseReconciliationConfirmation")
    public Result<?> counts(PurchaseReconciliationConfirmation purchaseReconciliationConfirmation, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseReconciliationConfirmation), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"prepared_by_status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"prepared_by_status");
        List list = ((PurchaseReconciliationConfirmationService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseReconciliationConfirmation::getPreparedByStatus, PurchaseReconciliationConfirmation::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "preparedByStatus", null, all));
        List srmReconciliationStatus = this.invokeBaseRpcService.queryDictItemsByCode("preparedByStatus", TenantContext.getTenant());
        for (DictDTO status : srmReconciliationStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "preparedByStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"finance#purchaseReconciliationConfirmation:exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, PurchaseReconciliationConfirmationExportServiceImpl.class);
    }

    @AutoLog(value="\u91c7\u8d2d\u5bf9\u8d26\u51fd-\u901a\u8fc7id\u4f5c\u5e9f")
    @ApiOperation(value="\u901a\u8fc7id\u4f5c\u5e9f", notes="\u901a\u8fc7id\u4f5c\u5e9f")
    @GetMapping(value={"/cancellation"})
    @RequiresPermissions(value={"finance#purchaseReconciliationConfirmation:cancellation"})
    public Result<?> cancellation(@RequestParam(name="id", required=true) String id) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, id, LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIexiKRcsSTVBtk_139b0f3", (String)"\u5f53\u524d\u5bf9\u8d26\u51fd\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.purchaseReconciliationConfirmationService.cancellation(id);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, id);
        }
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u91c7\u8d2d\u5bf9\u8d26\u51fd-\u63d0\u53d6\u672a\u8fbe\u8d26\u9879", logType=2)
    @ApiOperation(value="\u63d0\u53d6\u672a\u8fbe\u8d26\u9879", notes="\u63d0\u53d6\u672a\u8fbe\u8d26\u9879")
    @PostMapping(value={"/extractUnPaidAccountItem"})
    @RequiresPermissions(value={"finance#purchaseReconciliationConfirmation:extractUnPaidAccountItem"})
    public Result<?> extractUnPaidAccountItem(@RequestBody PurchaseReconciliationConfirmationVO vo) {
        List<PurchaseReconciliationConfirmationUnpaidAccount> unPaidAccountList = this.purchaseReconciliationConfirmationService.extractUnPaidAccountItem(vo);
        return Result.ok(unPaidAccountList);
    }

    @AutoLog(value="\u91c7\u8d2d\u5bf9\u8d26\u51fd-\u751f\u6210\u5dee\u5f02", logType=2)
    @ApiOperation(value="\u751f\u6210\u5dee\u5f02", notes="\u751f\u6210\u5dee\u5f02")
    @PostMapping(value={"/createDifference"})
    @RequiresPermissions(value={"finance#purchaseReconciliationConfirmation:createDifference"})
    public Result<?> createDifference(@RequestBody PurchaseReconciliationConfirmationVO vo) {
        this.purchaseReconciliationConfirmationService.createDifference(vo);
        return Result.ok();
    }

    @AutoLog(value="\u91c7\u8d2d\u5bf9\u8d26\u51fd-\u5bf9\u65b9\u786e\u8ba4")
    @ApiOperation(value="\u5bf9\u65b9\u786e\u8ba4", notes="\u5bf9\u65b9\u786e\u8ba4")
    @PostMapping(value={"/opponentConfirm"})
    @RequiresPermissions(value={"finance#purchaseReconciliationConfirmation:opponentConfirm"})
    public Result<?> opponentConfirm(@RequestBody PurchaseReconciliationConfirmationVO vo) {
        PurchaseReconciliationConfirmation purchaseReconciliationConfirmation = new PurchaseReconciliationConfirmation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)purchaseReconciliationConfirmation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIexiKRcsSTVBtk_139b0f3", (String)"\u5f53\u524d\u5bf9\u8d26\u51fd\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.purchaseReconciliationConfirmationService.opponentConfirm(purchaseReconciliationConfirmation);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u6279\u91cf\u7b7e\u7f72", notes="\u6279\u91cf\u7b7e\u7f72")
    @AutoLog(value="\u91c7\u8d2d\u5bf9\u8d26\u51fd-\u6279\u91cf\u7b7e\u7f72")
    @GetMapping(value={"/batchSign"})
    @RequiresPermissions(value={"finance#purchaseReconciliationConfirmation:batchSign"})
    public Result<?> batchSign(@RequestParam(value="ids") String ids) {
        return this.purchaseReconciliationConfirmationService.batchSign(ids);
    }
}

