/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.confirm.job;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.confirm.entity.PurchaseReconciliationConfirmation;
import com.els.modules.confirm.entity.PurchaseReconciliationConfirmationUnpaidAccount;
import com.els.modules.confirm.enumerate.ConfirmNatureCycleEnum;
import com.els.modules.confirm.rpc.InvokeDictInfoRpcService;
import com.els.modules.confirm.service.PurchaseReconciliationConfirmationService;
import com.els.modules.finance.api.dto.ElsFinanceConfirmationConfigDTO;
import com.els.modules.finance.api.service.ElsConfirmationConfigRpcService;
import com.els.modules.rebate.rpc.SupplierLocalRpcService;
import com.els.modules.reconciliation.vo.PurchaseReconciliationConfirmationVO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ReconciliationConfirmationJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationConfirmationJob.class);
    private final String LOCK_PREFIX = "schedule_reconciliationConfirmationJob";
    private final long EXPIRE_TIME = 50000L;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private PurchaseReconciliationConfirmationService confirmationService;
    @Resource
    private ElsConfirmationConfigRpcService elsConfirmationConfigRpcService;
    @Resource
    private TemplateRpcService templateRpcService;
    @Resource
    private SupplierLocalRpcService supplierLocalRpcService;
    @Resource
    private InvokeDictInfoRpcService invokeDictInfoRpcService;

    public void execute(String parameter) {
        String elsAccount;
        JSONObject object = JSONObject.parseObject((String)parameter);
        String string = elsAccount = StringUtils.isBlank((CharSequence)object.getString("elsAccount")) ? "100000" : object.getString("elsAccount");
        if (!this.redisUtil.tryGetDistributedLock("schedule_reconciliationConfirmationJob", elsAccount, 50000L)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IexbLLFLSiKRcVxPVBRc_e5d104ca", (String)"\u5bf9\u8d26\u51fd\u751f\u6210\u89c4\u5219\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c"));
        }
        try {
            TenantContext.setTenant((String)elsAccount);
            log.info(":::ReconciliationConfirmationJob start");
            ArrayList<PurchaseReconciliationConfirmationVO> confirmationVOList = new ArrayList<PurchaseReconciliationConfirmationVO>();
            ElsFinanceConfirmationConfigDTO config = this.elsConfirmationConfigRpcService.getDefaultConfirmationConfig(elsAccount);
            log.info("BatchCreateConfirmationJob getReconciliationConfig: {} ", (Object)JSON.toJSONString((Object)config));
            Assert.isNotNull((Object)config, (String)"\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u914d\u7f6e\u751f\u6210\u7b56\u7565\uff01");
            this.fillConfigData(confirmationVOList, config, elsAccount);
            this.fillTemplateData(confirmationVOList, config);
            log.info("BatchCreateConfirmationJob data: {} ", (Object)JSON.toJSONString(confirmationVOList));
            for (PurchaseReconciliationConfirmationVO vo : confirmationVOList) {
                this.createReconciliationConfirmation(vo);
            }
            log.info(":::ReconciliationConfirmationJob end");
        }
        catch (Exception e) {
            log.error(Thread.currentThread().getName() + "\u5bf9\u8d26\u51fd\u751f\u6210\u89c4\u5219\u4efb\u52a1\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
        finally {
            this.redisUtil.releaseDistributedLock("schedule_reconciliationConfirmationJob", elsAccount);
        }
    }

    private void createReconciliationConfirmation(PurchaseReconciliationConfirmationVO vo) {
        log.info("BatchCreateConfirmationJob \u63d0\u53d6\u5355\u636e: {} ", (Object)JSON.toJSONString((Object)((Object)vo)));
        List<PurchaseReconciliationConfirmationUnpaidAccount> unpaidAccounts = this.confirmationService.extractUnPaidAccountItem(vo);
        if (CollectionUtils.isEmpty(unpaidAccounts)) {
            return;
        }
        BigDecimal preparationConfirmAmount = unpaidAccounts.parallelStream().filter(item -> item.getPreparationConfirmAmount() != null).map(PurchaseReconciliationConfirmationUnpaidAccount::getPreparationConfirmAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (preparationConfirmAmount == null || BigDecimal.ZERO.compareTo(preparationConfirmAmount) == 0) {
            return;
        }
        PurchaseReconciliationConfirmation confirmation = new PurchaseReconciliationConfirmation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)confirmation));
        vo.setUnpaidAccountItem(unpaidAccounts);
        try {
            log.info("BatchCreateConfirmationJob \u521b\u5efa\u5bf9\u8d26\u51fd: {} ", (Object)JSON.toJSONString((Object)((Object)vo)));
            this.confirmationService.saveMain(confirmation, vo);
            this.confirmationService.updateMain(confirmation, vo);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u5bf9\u8d26\u51fd\u5931\u8d25: {} ", (Object)e.getMessage());
        }
    }

    private void fillConfigData(List<PurchaseReconciliationConfirmationVO> confirmationVO, ElsFinanceConfirmationConfigDTO config, String elsAccount) {
        Map<String, Date> beginDateWithEndDate = this.getBeginDateWithEndDate(config);
        List<String> accountGroupList = Arrays.asList(config.getAccountGroup().split(","));
        List<SupplierMasterDataDTO> supplierMasterDataDTOS = this.supplierLocalRpcService.getSupplierMasterDataByAccountGroup(elsAccount, accountGroupList);
        Assert.isNotEmpty(supplierMasterDataDTOS, (String)"\u4e0d\u5b58\u5728\u7b26\u5408\u4f9b\u5e94\u5546\u8d26\u6237\u7ec4\u7684\u4f9b\u5e94\u5546\uff01");
        List<DictDTO> companyCodeList = this.invokeDictInfoRpcService.queryDictItemsByCode("purchase_organization_info#org_name#org_code#org_category_code=\"companyCode\" && status=\"1\"", elsAccount);
        for (SupplierMasterDataDTO dto : supplierMasterDataDTOS) {
            for (DictDTO companyDTO : companyCodeList) {
                PurchaseReconciliationConfirmationVO vo = new PurchaseReconciliationConfirmationVO();
                vo.setElsAccount(elsAccount);
                vo.setToElsAccount(dto.getToElsAccount());
                vo.setSupplierCode(dto.getToElsAccount());
                vo.setSupplierName(dto.getSupplierName());
                vo.setEndDate(beginDateWithEndDate.get("endDate"));
                vo.setCompany(companyDTO.getValue());
                confirmationVO.add(vo);
            }
        }
    }

    private Map<String, Date> getBeginDateWithEndDate(ElsFinanceConfirmationConfigDTO config) {
        HashMap<String, Date> map = new HashMap<String, Date>();
        Calendar calendar = Calendar.getInstance();
        if (config.getNatureCycle().equals(ConfirmNatureCycleEnum.WEEKLY.getValue())) {
            int currWeek = calendar.get(7);
            if (currWeek != 7) {
                int differenceOfWeek = 7 - currWeek;
                calendar.add(5, differenceOfWeek);
            }
            calendar.add(5, -7);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            map.put("endDate", calendar.getTime());
        } else if (config.getNatureCycle().equals(ConfirmNatureCycleEnum.MIDMONTHLY.getValue())) {
            int currDay = calendar.get(5);
            if (currDay <= 15) {
                calendar.add(2, -1);
            } else {
                calendar.set(5, 15);
            }
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            map.put("endDate", calendar.getTime());
        } else if (config.getNatureCycle().equals(ConfirmNatureCycleEnum.ENDMONTHLY.getValue())) {
            calendar.add(2, -1);
            calendar.set(2, 15);
            calendar.set(11, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            map.put("endDate", calendar.getTime());
        } else if (config.getNatureCycle().equals(ConfirmNatureCycleEnum.ENDQUARTERLY.getValue())) {
            Date lastQuarterEndTime = this.getLastQuarterEndTime(calendar);
            map.put("endDate", lastQuarterEndTime);
        } else if (config.getNatureCycle().equals(ConfirmNatureCycleEnum.MIDYEAR.getValue())) {
            int currMonth = calendar.get(2);
            if (currMonth <= 6) {
                calendar.add(1, -1);
            }
            calendar.set(2, 6);
            int actualMaximum = calendar.getActualMaximum(5);
            calendar.set(5, actualMaximum);
            int hour = calendar.getActualMaximum(11);
            int minute = calendar.getActualMaximum(12);
            int second = calendar.getActualMaximum(13);
            int milliSecond = calendar.getActualMaximum(14);
            calendar.set(11, hour);
            calendar.set(12, minute);
            calendar.set(13, second);
            calendar.set(14, milliSecond);
            map.put("endDate", calendar.getTime());
        } else if (config.getNatureCycle().equals(ConfirmNatureCycleEnum.ENDYEAR.getValue())) {
            Date currentLastOfYear = this.getLastOfYear(calendar);
            map.put("endDate", currentLastOfYear);
        }
        return map;
    }

    private void fillTemplateData(List<PurchaseReconciliationConfirmationVO> confirmationVOList, ElsFinanceConfirmationConfigDTO config) {
        TemplateHeadDTO templateHeadDTO = this.templateRpcService.getById(config.getRelatedTemplateId());
        if (templateHeadDTO == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_ESIrxMKVImESIr_d0741654", (String)"\u4e1a\u52a1\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u6a21\u677f\uff01"));
        }
        for (PurchaseReconciliationConfirmationVO confirmationVO : confirmationVOList) {
            confirmationVO.setTemplateAccount(templateHeadDTO.getElsAccount());
            confirmationVO.setTemplateName(templateHeadDTO.getTemplateName());
            confirmationVO.setTemplateNumber(templateHeadDTO.getTemplateNumber());
            confirmationVO.setTemplateVersion(String.valueOf(templateHeadDTO.getTemplateVersion()));
        }
    }

    private Date getLastOfYear(Calendar calendar) {
        calendar.add(1, -1);
        int lastYear = calendar.get(1);
        calendar.clear();
        calendar.set(1, lastYear);
        calendar.roll(6, -1);
        return calendar.getTime();
    }

    private Date getLastQuarterEndTime(Calendar calendar) {
        calendar.setTime(this.getLastQuarterStartTime(calendar));
        calendar.add(2, 2);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        return calendar.getTime();
    }

    private Date getLastQuarterStartTime(Calendar calendar) {
        int currentMonth = calendar.get(2) + 1;
        Date lastSeason = null;
        try {
            if (currentMonth <= 3) {
                calendar.set(2, 0);
            } else if (currentMonth <= 6) {
                calendar.set(2, 3);
            } else if (currentMonth <= 9) {
                calendar.set(2, 6);
            } else if (currentMonth <= 12) {
                calendar.set(2, 9);
            }
            calendar.set(5, 1);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            calendar.add(2, -3);
            lastSeason = calendar.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lastSeason;
    }
}

