/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.modules.finance.entity.PurchasePaymentApplyHead;
import com.els.modules.finance.entity.PurchasePaymentApplyItem;
import com.els.modules.finance.entity.PurchasePaymentApplyWriteOff;
import com.els.modules.finance.enumerate.WriteOffStatusEnum;
import com.els.modules.finance.enumerate.WriteOffTypeEnum;
import com.els.modules.finance.mapper.PurchasePaymentApplyItemMapper;
import com.els.modules.finance.service.PurchasePaymentApplyItemService;
import com.els.modules.reconciliation.entity.ElsPurchaseStatisticsWriteOff;
import com.els.modules.reconciliation.entity.PurchasePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.enumerate.ReconcilationItemTypeEmun;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffService;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchasePaymentApplyItemServiceImpl
extends ServiceImpl<PurchasePaymentApplyItemMapper, PurchasePaymentApplyItem>
implements PurchasePaymentApplyItemService {
    @Resource
    private PurchasePaymentApplyItemMapper purchasePaymentApplyItemMapper;
    @Autowired
    private ElsPurchaseStatisticsWriteOffService elsPurchaseStatisticsWriteOffService;

    @Override
    public List<PurchasePaymentApplyItem> selectByMainId(String mainId) {
        return this.purchasePaymentApplyItemMapper.selectByMainId(mainId);
    }

    @Override
    public List<PurchasePaymentApplyItem> listPurchasePaymentApplyItem(ReconciliationVO reconciliationVO, String elsAccount) {
        return this.purchasePaymentApplyItemMapper.listPurchasePaymentApplyItem(reconciliationVO);
    }

    @Override
    public List<PurchasePrePaymentWriteOffReconciliation> getPurchasePrePaymentWriteOffReconciliations(ReconciliationVO reconciliationVO, String elsAccount) {
        List<PurchasePaymentApplyItem> purchasePaymentApplyItems = this.listPurchasePaymentApplyItem(reconciliationVO, elsAccount);
        ArrayList<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffReconciliationList = new ArrayList<PurchasePrePaymentWriteOffReconciliation>();
        if (CollectionUtils.isEmpty(purchasePaymentApplyItems)) {
            return null;
        }
        HashMap<String, ElsPurchaseStatisticsWriteOff> map = new HashMap<String, ElsPurchaseStatisticsWriteOff>();
        this.getElsPurchaseStatisticsWriteOffMap(purchasePaymentApplyItems, map);
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItems) {
            PurchasePrePaymentWriteOffReconciliation prePaymentWriteOffReconciliation = new PurchasePrePaymentWriteOffReconciliation();
            BeanUtils.copyProperties((Object)((Object)purchasePaymentApplyItem), (Object)((Object)prePaymentWriteOffReconciliation));
            prePaymentWriteOffReconciliation.setSourceType(ReconcilationItemTypeEmun.PRE_PAYMENT.getValue());
            prePaymentWriteOffReconciliation.setPayAmount(purchasePaymentApplyItem.getPayAmount());
            prePaymentWriteOffReconciliation.setSourceTaxAmount(purchasePaymentApplyItem.getShouldTaxAmount());
            prePaymentWriteOffReconciliation.setSourceNetAmount(purchasePaymentApplyItem.getShouldNoTaxAmount());
            prePaymentWriteOffReconciliation.setSourceTax(purchasePaymentApplyItem.getTaxAmount());
            prePaymentWriteOffReconciliation.setSourcePrice(purchasePaymentApplyItem.getPayAmount());
            prePaymentWriteOffReconciliation.setPreHeadId(purchasePaymentApplyItem.getHeadId());
            prePaymentWriteOffReconciliation.setId(null);
            prePaymentWriteOffReconciliation.setBusinessId(purchasePaymentApplyItem.getId());
            prePaymentWriteOffReconciliation.setWriteOffStatus(WriteOffStatusEnum.UN_WRITE_OFF.getValue());
            ElsPurchaseStatisticsWriteOff writeOff = (ElsPurchaseStatisticsWriteOff)((Object)map.get(purchasePaymentApplyItem.getId()));
            if (writeOff != null) {
                BigDecimal sourceUnWrittenOffAmount;
                BigDecimal bigDecimal = sourceUnWrittenOffAmount = writeOff.getSourceUnWrittenOffAmount() == null ? BigDecimal.ZERO : writeOff.getSourceUnWrittenOffAmount();
                if (BigDecimal.ZERO.compareTo(sourceUnWrittenOffAmount) == 0) continue;
                prePaymentWriteOffReconciliation.setUnWrittenOffAmount(writeOff.getSourceUnWrittenOffAmount());
                prePaymentWriteOffReconciliation.setWrittenOffAmount(writeOff.getSourceWrittenOffAmount());
            }
            purchasePrePaymentWriteOffReconciliationList.add(prePaymentWriteOffReconciliation);
        }
        return purchasePrePaymentWriteOffReconciliationList;
    }

    @Override
    public List<PurchasePaymentApplyWriteOff> getPurchasePrePaymentWriteOffReconciliations(PurchasePaymentApplyHead purchasePaymentApplyHead, String elsAccount) {
        List<PurchasePaymentApplyItem> purchasePaymentApplyItems = this.listPurchasePaymentApplyItem(purchasePaymentApplyHead, elsAccount);
        ArrayList<PurchasePaymentApplyWriteOff> purchasePrePaymentWriteOffReconciliationList = new ArrayList<PurchasePaymentApplyWriteOff>();
        if (CollectionUtils.isEmpty(purchasePaymentApplyItems)) {
            return null;
        }
        HashMap<String, ElsPurchaseStatisticsWriteOff> map = new HashMap<String, ElsPurchaseStatisticsWriteOff>();
        this.getElsPurchaseStatisticsWriteOffMap(purchasePaymentApplyItems, map);
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItems) {
            PurchasePaymentApplyWriteOff paymentWriteOff = new PurchasePaymentApplyWriteOff();
            BeanUtils.copyProperties((Object)((Object)purchasePaymentApplyItem), (Object)((Object)paymentWriteOff));
            paymentWriteOff.setSourceType(ReconcilationItemTypeEmun.PRE_PAYMENT.getValue());
            paymentWriteOff.setPayAmount(purchasePaymentApplyItem.getPayAmount());
            paymentWriteOff.setTaxAmount(purchasePaymentApplyItem.getShouldTaxAmount());
            paymentWriteOff.setNetAmount(purchasePaymentApplyItem.getShouldNoTaxAmount());
            paymentWriteOff.setTax(purchasePaymentApplyItem.getTaxAmount());
            paymentWriteOff.setPrice(purchasePaymentApplyItem.getPayAmount());
            paymentWriteOff.setPreHeadId(purchasePaymentApplyItem.getHeadId());
            paymentWriteOff.setId(null);
            paymentWriteOff.setBusinessId(purchasePaymentApplyItem.getId());
            paymentWriteOff.setWriteOffType(WriteOffTypeEnum.PAYMENT.getValue());
            ElsPurchaseStatisticsWriteOff writeOff = (ElsPurchaseStatisticsWriteOff)((Object)map.get(purchasePaymentApplyItem.getId()));
            if (writeOff != null) {
                BigDecimal sourceUnWrittenOffAmount;
                BigDecimal bigDecimal = sourceUnWrittenOffAmount = writeOff.getSourceUnWrittenOffAmount() == null ? BigDecimal.ZERO : writeOff.getSourceUnWrittenOffAmount();
                if (BigDecimal.ZERO.compareTo(sourceUnWrittenOffAmount) == 0) continue;
                paymentWriteOff.setUnWrittenOffAmount(writeOff.getSourceUnWrittenOffAmount());
                paymentWriteOff.setWrittenOffAmount(writeOff.getSourceWrittenOffAmount());
            }
            purchasePrePaymentWriteOffReconciliationList.add(paymentWriteOff);
        }
        return purchasePrePaymentWriteOffReconciliationList;
    }

    @Override
    public List<PurchasePaymentApplyItem> listPurchasePaymentApplyItem(PurchasePaymentApplyHead purchasePaymentApplyHead, String elsAccount) {
        return this.purchasePaymentApplyItemMapper.listPurchasePaymentApplyItem(purchasePaymentApplyHead);
    }

    private void getElsPurchaseStatisticsWriteOffMap(List<PurchasePaymentApplyItem> purchasePaymentApplyItems, Map<String, ElsPurchaseStatisticsWriteOff> map) {
        HashSet<String> ids = new HashSet<String>();
        for (PurchasePaymentApplyItem purchasePaymentApplyItem : purchasePaymentApplyItems) {
            ids.add(purchasePaymentApplyItem.getId());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"source_id", ids);
        List list = this.elsPurchaseStatisticsWriteOffService.list((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        for (ElsPurchaseStatisticsWriteOff writeOff : list) {
            map.put(writeOff.getSourceId(), writeOff);
        }
    }
}

