/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.constant.CommonConstant;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.exchange.rpc.dto.BpExchangeRateDTO;
import com.els.modules.finance.api.enumerate.PaymentApplySourceTypeEnum;
import com.els.modules.finance.api.enumerate.PaymentApplyStatusEnum;
import com.els.modules.finance.entity.PurchasePaymentApplyHead;
import com.els.modules.finance.entity.PurchasePaymentApplyItem;
import com.els.modules.finance.entity.PurchasePaymentPlanHead;
import com.els.modules.finance.entity.PurchasePaymentPlanItem;
import com.els.modules.finance.enumerate.PaymentPlanItemSourceTypeEnum;
import com.els.modules.finance.enumerate.PaymentPlanItemStatusEnum;
import com.els.modules.finance.enumerate.PaymentPlanStatusEnum;
import com.els.modules.finance.mapper.PurchasePaymentPlanHeadMapper;
import com.els.modules.finance.rpc.PurchasePaymentPlanWorkFlowRpcService;
import com.els.modules.finance.service.PurchasePaymentApplyHeadService;
import com.els.modules.finance.service.PurchasePaymentPlanHeadService;
import com.els.modules.finance.service.PurchasePaymentPlanItemService;
import com.els.modules.finance.vo.PurchasePaymentApplyHeadVO;
import com.els.modules.finance.vo.PurchasePaymentPlanHeadVO;
import com.els.modules.finance.vo.PurchasePaymentPlanItemVO;
import com.els.modules.finance.vo.PurchasePaymentPlanReconciliationVO;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.rebate.rpc.BpExchangeRateLocalRpcService;
import com.els.modules.rebate.rpc.PurchaseOrganizationInfoLocalRpcService;
import com.els.modules.reconciliation.entity.PurchasePerformanceReconciliation;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.service.PurchasePerformanceReconciliationService;
import com.els.modules.reconciliation.service.PurchaseReconciliationService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.rpc.service.CoreInvokeSupplierRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class PurchasePaymentPlanHeadServiceImpl
extends BaseServiceImpl<PurchasePaymentPlanHeadMapper, PurchasePaymentPlanHead>
implements PurchasePaymentPlanHeadService {
    @Resource
    private PurchasePaymentPlanItemService purchasePaymentPlanItemService;
    @Resource
    private PurchaseReconciliationService purchaseReconciliationService;
    @Resource
    private PurchasePerformanceReconciliationService purchasePerformanceReconciliationService;
    @Resource
    private PurchasePaymentApplyHeadService purchasePaymentApplyHeadService;
    @Resource
    private InvokeBaseRpcService baseRpcService;
    @Resource
    private PurchasePaymentPlanWorkFlowRpcService purchasePaymentPlanWorkFlowRpcService;
    @Resource
    private CoreInvokeSupplierRpcService coreInvokeSupplierRpcService;
    @Resource
    private PurchaseOrganizationInfoLocalRpcService purchaseOrganizationInfoLocalRpcService;
    @Resource
    private BpExchangeRateLocalRpcService bpExchangeRateLocalRpcService;

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void saveMain(PurchasePaymentPlanHead purchasePaymentPlanHead, List<PurchasePaymentPlanItem> purchasePaymentPlanItemList) {
        if (StringUtils.isBlank((CharSequence)purchasePaymentPlanHead.getPaymentPlanIssue())) {
            String currentPaymentPlanIssue = this.getCurrentPaymentPlanIssue();
            purchasePaymentPlanHead.setPaymentPlanIssue(currentPaymentPlanIssue);
        }
        this.checkPaymentPlanIssueCount(purchasePaymentPlanHead, "0");
        if (StringUtils.isBlank((CharSequence)purchasePaymentPlanHead.getPaymentPlanNumber())) {
            purchasePaymentPlanHead.setPaymentPlanNumber(this.baseRpcService.getNextCode("paymentPlanNumber", (Object)purchasePaymentPlanHead));
        }
        if (StringUtils.isBlank((CharSequence)purchasePaymentPlanHead.getPaymentPlanStatus())) {
            purchasePaymentPlanHead.setPaymentPlanStatus(PaymentPlanStatusEnum.CREATE.getValue());
        }
        if ("1".equals(purchasePaymentPlanHead.getAudit())) {
            purchasePaymentPlanHead.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
        } else {
            purchasePaymentPlanHead.setAuditStatus(AuditStatusEnum.NO_AUDIT_REQUIRED.getValue());
        }
        this.setItemDefaultVal(purchasePaymentPlanItemList);
        super.setHeadDefaultValue((BaseEntity)purchasePaymentPlanHead);
        this.setHeadVal(purchasePaymentPlanHead, purchasePaymentPlanItemList);
        ((PurchasePaymentPlanHeadMapper)this.baseMapper).insert((Object)purchasePaymentPlanHead);
        this.insertData(purchasePaymentPlanHead, purchasePaymentPlanItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updateMain(PurchasePaymentPlanHead purchasePaymentPlanHead, List<PurchasePaymentPlanItem> purchasePaymentPlanItemList) {
        if (StringUtils.isBlank((CharSequence)purchasePaymentPlanHead.getPaymentPlanIssue())) {
            String currentPaymentPlanIssue = this.getCurrentPaymentPlanIssue();
            purchasePaymentPlanHead.setPaymentPlanIssue(currentPaymentPlanIssue);
        }
        this.setItemDefaultVal(purchasePaymentPlanItemList);
        this.checkPaymentPlanIssueCount(purchasePaymentPlanHead, "1");
        this.setHeadVal(purchasePaymentPlanHead, purchasePaymentPlanItemList);
        if ("1".equals(purchasePaymentPlanHead.getAudit())) {
            purchasePaymentPlanHead.setAuditStatus(StringUtils.isBlank((CharSequence)purchasePaymentPlanHead.getAuditStatus()) ? AuditStatusEnum.AUDIT_NEW.getValue() : purchasePaymentPlanHead.getAuditStatus());
        } else {
            purchasePaymentPlanHead.setAuditStatus(StringUtils.isBlank((CharSequence)purchasePaymentPlanHead.getAuditStatus()) ? AuditStatusEnum.NO_AUDIT_REQUIRED.getValue() : purchasePaymentPlanHead.getAuditStatus());
        }
        int count = ((PurchasePaymentPlanHeadMapper)this.baseMapper).updateById((Object)purchasePaymentPlanHead);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        this.purchasePaymentPlanItemService.deleteByMainId(purchasePaymentPlanHead.getId());
        this.insertData(purchasePaymentPlanHead, purchasePaymentPlanItemList);
    }

    private void checkPaymentPlanIssueCount(PurchasePaymentPlanHead purchasePaymentPlanHead, String status) {
        if (StringUtils.isNotBlank((CharSequence)purchasePaymentPlanHead.getPaymentPlanIssue())) {
            PurchasePaymentPlanHead head;
            List list = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).eq((Object)"payment_plan_issue", (Object)purchasePaymentPlanHead.getPaymentPlanIssue()));
            if ("0".equals(status) && CollUtil.isNotEmpty((Collection)list)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IMKdejJHtEAm_15bd03ae", (String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u8d44\u91d1\u8ba1\u5212\u671f\u6b21"));
            }
            if ("1".equals(status) && CollUtil.isNotEmpty((Collection)list) && !(head = (PurchasePaymentPlanHead)((Object)list.get(0))).getId().equals(purchasePaymentPlanHead.getId())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IMKdejJHtEAm_15bd03ae", (String)"\u5df2\u5b58\u5728\u76f8\u540c\u7684\u8d44\u91d1\u8ba1\u5212\u671f\u6b21"));
            }
        }
    }

    private void insertData(PurchasePaymentPlanHead purchasePaymentPlanHead, List<PurchasePaymentPlanItem> purchasePaymentPlanItemList) {
        if (CollUtil.isNotEmpty(purchasePaymentPlanItemList)) {
            for (PurchasePaymentPlanItem entity : purchasePaymentPlanItemList) {
                entity.setHeadId(purchasePaymentPlanHead.getId());
                SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)purchasePaymentPlanHead);
            }
            this.purchasePaymentPlanItemService.saveOrUpdateBatch(purchasePaymentPlanItemList, 2000);
        }
    }

    private void setHeadVal(PurchasePaymentPlanHead head, List<PurchasePaymentPlanItem> itemList) {
        if (CollUtil.isNotEmpty(itemList)) {
            PurchaseOrganizationInfoDTO infoDTO;
            BigDecimal settlementAmount = itemList.stream().filter(it -> it.getSettlementAmount() != null).map(PurchasePaymentPlanItem::getSettlementAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal cashAmount = itemList.stream().filter(it -> it.getCashAmount() != null).map(PurchasePaymentPlanItem::getCashAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal endorseAmount = itemList.stream().filter(it -> it.getEndorseAmount() != null).map(PurchasePaymentPlanItem::getEndorseAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal acceptanceAmount = itemList.stream().filter(it -> it.getAcceptanceAmount() != null).map(PurchasePaymentPlanItem::getAcceptanceAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal paymentAmount = itemList.stream().filter(it -> it.getPaymentAmount() != null).map(PurchasePaymentPlanItem::getPaymentAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            head.setTotalSettlementAmount(settlementAmount);
            head.setTotalCashAmount(cashAmount);
            head.setTotalAcceptanceAmount(endorseAmount);
            head.setTotalEndorseAmount(acceptanceAmount);
            head.setTotalPaymentAmount(paymentAmount);
            if (StringUtils.isNotBlank((CharSequence)head.getCompany()) && (infoDTO = this.purchaseOrganizationInfoLocalRpcService.selectByElsAccountAndCode(TenantContext.getTenant(), "companyCode", head.getCompany())) != null) {
                head.setStandardMoneyCode(infoDTO.getChargeCurrency());
            }
            if (StringUtils.isNotBlank((CharSequence)head.getCurrencyCode())) {
                Optional<BpExchangeRateDTO> first;
                List<BpExchangeRateDTO> rateDTOList;
                if (head.getCurrencyCode().equals(head.getStandardMoneyCode())) {
                    head.setExchangeRate(BigDecimal.ONE);
                } else if (StringUtils.isNotBlank((CharSequence)head.getStandardMoneyCode()) && CollUtil.isNotEmpty(rateDTOList = this.bpExchangeRateLocalRpcService.getRateByCurrencys(Lists.newArrayList((Object[])new String[]{head.getCurrencyCode()}), head.getStandardMoneyCode())) && (first = rateDTOList.stream().filter(x -> "0".equals(x.getExchangeUse())).findFirst()).isPresent()) {
                    head.setExchangeRate(first.get().getExchange());
                }
            }
        }
    }

    private void setItemDefaultVal(List<PurchasePaymentPlanItem> purchasePaymentPlanItemList) {
        if (CollUtil.isNotEmpty(purchasePaymentPlanItemList)) {
            purchasePaymentPlanItemList.forEach(x -> {
                if (x.getSettlementAmount() != null && x.getEndorseAmount() != null && x.getAcceptanceAmount() != null) {
                    BigDecimal endorseAmount = x.getEndorseAmount().multiply(new BigDecimal(10000));
                    BigDecimal acceptanceAmount = x.getAcceptanceAmount().multiply(new BigDecimal(10000));
                    BigDecimal val = x.getSettlementAmount().subtract(endorseAmount).subtract(acceptanceAmount);
                    x.setCashAmount(val);
                }
                if (x.getPaymentBenchmarkDate() != null && x.getPaymentExpiredate() == null) {
                    Date paymentExpiredate = x.getPaymentExpiredate();
                    x.setPaymentExpiredate(paymentExpiredate);
                }
                if (x.getPaymentBenchmarkDate() != null && x.getPayCycle() != null) {
                    x.setPaymentExpiredate((Date)DateUtil.offsetDay((Date)x.getPaymentBenchmarkDate(), (int)x.getPayCycle().intValue()));
                }
                if ("1".equals(x.getPaymentDelay()) && x.getPaymentExpiredate() != null && x.getPaymentDelayDays() != null) {
                    x.setPaymentDelayDate((Date)DateUtil.offsetDay((Date)x.getPaymentExpiredate(), (int)x.getPaymentDelayDays().intValue()));
                }
                if ("0".equals(x.getPaymentDelay())) {
                    x.setPaymentDelayDate(null);
                }
            });
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void publish(PurchasePaymentPlanHead purchasePaymentPlanHead, List<PurchasePaymentPlanItem> purchasePaymentPlanItemList) {
        if ("1".equals(purchasePaymentPlanHead.getAudit())) {
            AuditInputParamDTO dto = new AuditInputParamDTO();
            dto.setBusinessId(purchasePaymentPlanHead.getId());
            dto.setBusinessType("paymentPlan");
            dto.setAuditSubject(I18nUtil.translate((String)"i18n_alert_JHtEUzty0_d23f1ac6", (String)"\u8d44\u91d1\u8ba1\u5212\u5ba1\u6279\uff0c\u5355\u53f7\uff1a${0}", (String[])new String[]{purchasePaymentPlanHead.getPaymentPlanNumber()}));
            dto.setParams(JSONObject.toJSONString((Object)((Object)this.queryById(purchasePaymentPlanHead.getId()))));
            this.purchasePaymentPlanWorkFlowRpcService.submit(dto);
            this.setReconciliationPaymentPlan(purchasePaymentPlanItemList, "1");
        } else {
            purchasePaymentPlanHead.setPaymentPlanStatus(PaymentPlanStatusEnum.PUBLISHED.getValue());
            int count = ((PurchasePaymentPlanHeadMapper)this.baseMapper).updateById((Object)purchasePaymentPlanHead);
            Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
            this.setReconciliationPaymentPlan(purchasePaymentPlanItemList, "1");
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public List<PurchasePaymentApplyHead> addPaymentApply(String headId, List<PurchasePaymentPlanItem> purchasePaymentPlanItemList) {
        List<PurchasePaymentApplyHead> applyHeads = new ArrayList<PurchasePaymentApplyHead>();
        ArrayList<String> paymentApplyIds = new ArrayList<String>();
        PurchasePaymentPlanHead planHead = (PurchasePaymentPlanHead)((Object)this.getById((Serializable)((Object)headId)));
        if (CollUtil.isNotEmpty(purchasePaymentPlanItemList) && !ObjectUtils.isEmpty((Object)((Object)planHead))) {
            this.checkPaymentPlanItemInfo(purchasePaymentPlanItemList);
            Map<String, List<PurchasePaymentPlanItem>> listMap = purchasePaymentPlanItemList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getToElsAccount())).collect(Collectors.groupingBy(PurchasePaymentPlanItem::getToElsAccount));
            List headDTOList = this.baseRpcService.getDefaultTemplateByType("paymentApply");
            Assert.isTrue((boolean)CollUtil.isNotEmpty((Collection)headDTOList), (String)I18nUtil.translate((String)"i18n_alert_VGRBVUVESIr_3e54b58b", (String)"\u8bf7\u8bbe\u7f6e\u4ed8\u6b3e\u7533\u8bf7\u4e1a\u52a1\u6a21\u677f\uff01"));
            PurchasePaymentApplyHeadVO applyHeadVO = new PurchasePaymentApplyHeadVO();
            for (String toElsAccount : listMap.keySet()) {
                List<PurchasePaymentPlanItem> itemList = listMap.get(toElsAccount);
                PurchasePaymentApplyHead applyHead = new PurchasePaymentApplyHead();
                applyHead.setId(IdWorker.getIdStr());
                applyHead.setTemplateAccount(((TemplateHeadDTO)headDTOList.get(0)).getElsAccount());
                applyHead.setTemplateNumber(((TemplateHeadDTO)headDTOList.get(0)).getTemplateNumber());
                applyHead.setTemplateName(((TemplateHeadDTO)headDTOList.get(0)).getTemplateName());
                applyHead.setTemplateVersion(String.valueOf(((TemplateHeadDTO)headDTOList.get(0)).getTemplateVersion()));
                applyHead.setElsAccount(planHead.getElsAccount());
                applyHead.setToElsAccount(toElsAccount);
                applyHead.setSupplierName(itemList.get(0).getSupplierName());
                applyHead.setCompany(planHead.getCompany());
                applyHead.setPurchaseOrg(planHead.getPurchaseOrg());
                applyHead.setCurrency(planHead.getCurrencyCode());
                applyHead.setStandardCoin(planHead.getStandardMoneyCode());
                applyHead.setExchangeRate(planHead.getExchangeRate());
                applyHead.setPayAmount(planHead.getTotalPaymentAmount());
                applyHead.setClosingAmount(planHead.getTotalSettlementAmount());
                applyHead.setPayWay(itemList.get(0).getPayWay());
                applyHead.setPaymentClause(itemList.get(0).getPaymentClause());
                applyHead.setPaymentApplyNumber(this.baseRpcService.getNextCode("srmApplyNumber", (Object)applyHead));
                applyHead.setPaymentApplyType("1");
                ArrayList<PurchasePaymentApplyItem> applyItemList = new ArrayList<PurchasePaymentApplyItem>();
                for (PurchasePaymentPlanItem planItem : itemList) {
                    PurchasePaymentApplyItem applyItem = new PurchasePaymentApplyItem();
                    applyItem.setHeadId(applyHead.getId());
                    applyItem.setPaymentApplyNumber(applyHead.getPaymentApplyNumber());
                    applyItem.setElsAccount(planItem.getElsAccount());
                    applyItem.setPaymentStatus(PaymentPlanItemStatusEnum.NOT_APPLY.getValue());
                    applyItem.setSourceSystem("srm");
                    applyItem.setSourceType("paymentPlan");
                    applyItem.setSourceNumber(planHead.getPaymentPlanNumber());
                    applyItem.setSourceId(planItem.getId());
                    applyItem.setPayWay(planItem.getPayWay());
                    applyItem.setPaymentClause(planItem.getPaymentClause());
                    applyItem.setPaymentBenchmarkDate(planItem.getPaymentBenchmarkDate());
                    applyItem.setSourcePaidAmount(planItem.getPaymentAmount());
                    applyItem.setPayAmount(planItem.getPaymentAmount());
                    applyItem.setClosingAmount(planItem.getSettlementAmount());
                    applyItem.setShouldTaxAmount(planItem.getSettlementAmount());
                    applyItem.setApplyAmount(planItem.getSettlementAmount());
                    applyItemList.add(applyItem);
                }
                BeanUtils.copyProperties((Object)((Object)applyHead), (Object)((Object)applyHeadVO));
                applyHeadVO.setPaymentApplyItemList(applyItemList);
                this.purchasePaymentApplyHeadService.saveMain(applyHead, applyHeadVO);
                paymentApplyIds.add(applyHead.getId());
            }
        }
        if (CollUtil.isNotEmpty(paymentApplyIds)) {
            applyHeads = this.purchasePaymentApplyHeadService.listByIds(paymentApplyIds);
        }
        return applyHeads;
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void releasePayment(String headId, List<PurchasePaymentPlanItem> purchasePaymentPlanItemList) {
        Assert.isTrue((boolean)CollUtil.isNotEmpty(purchasePaymentPlanItemList), (String)I18nUtil.translate((String)"i18n_alert_yGjcWFLVxOyG_5527e876", (String)"\u89e3\u9664\u7684\u884c\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u89e3\u9664"));
        List idList = purchasePaymentPlanItemList.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchasePaymentPlanItemService.lambdaUpdate().in(BaseEntity::getId, idList)).set(PurchasePaymentPlanItem::getPaymentDelay, (Object)"0")).set(PurchasePaymentPlanItem::getPaymentDelayDays, null)).set(PurchasePaymentPlanItem::getPaymentDelayDate, null)).update();
        this.setReconciliationPaymentPlan(purchasePaymentPlanItemList, "0");
    }

    @Override
    public PurchasePaymentPlanHeadVO queryById(String id) {
        PurchasePaymentPlanHeadVO purchaseFundPlanHeadVO = new PurchasePaymentPlanHeadVO();
        PurchasePaymentPlanHead purchasePaymentPlanHead = (PurchasePaymentPlanHead)((Object)this.getById((Serializable)((Object)id)));
        BeanUtils.copyProperties((Object)((Object)purchasePaymentPlanHead), (Object)((Object)purchaseFundPlanHeadVO));
        List<PurchasePaymentPlanItem> purchasePaymentPlanItemList = this.purchasePaymentPlanItemService.selectByMainId(id);
        this.handleAcceptanceDenominationOptionsList(purchasePaymentPlanItemList);
        purchaseFundPlanHeadVO.setPurchasePaymentPlanItemList(purchasePaymentPlanItemList);
        return purchaseFundPlanHeadVO;
    }

    @Override
    public String getCurrentPaymentPlanIssue() {
        LocalDate currentDate = LocalDate.now();
        LocalDate firstDayOfMonth = currentDate.withDayOfMonth(1);
        LocalDate lastDayOfMonth = currentDate.withDayOfMonth(currentDate.lengthOfMonth());
        LocalDateTime startOfMonth = LocalDateTime.of(firstDayOfMonth, LocalTime.MIN);
        LocalDateTime endOfMonth = LocalDateTime.of(lastDayOfMonth, LocalTime.MAX);
        String startTimeStr = LocalDateTimeUtil.format((LocalDateTime)startOfMonth, (DateTimeFormatter)DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String endTimeStr = LocalDateTimeUtil.format((LocalDateTime)endOfMonth, (DateTimeFormatter)DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        int count = this.count((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).ge((Object)"create_time", (Object)startTimeStr)).le((Object)"create_time", (Object)endTimeStr));
        String paymentPlanIssue = DateUtil.format((Date)new Date(), (String)"yyyyMM").concat("-").concat(String.format("%02d", count + 1));
        return paymentPlanIssue;
    }

    @Override
    public List<PurchasePaymentPlanReconciliationVO> setSettlementAmountOnToElsAccount(List<PurchasePaymentPlanReconciliationVO> pageList) {
        ArrayList<PurchasePaymentPlanReconciliationVO> list = new ArrayList<PurchasePaymentPlanReconciliationVO>();
        if (CollUtil.isNotEmpty(pageList)) {
            Map<String, List<PurchasePaymentPlanReconciliationVO>> listMap = pageList.stream().collect(Collectors.groupingBy(PurchasePaymentPlanReconciliationVO::getToElsAccount));
            for (String toElsAccount : listMap.keySet()) {
                List<PurchasePaymentPlanReconciliationVO> voList = listMap.get(toElsAccount);
                BigDecimal settlementAmount = voList.stream().filter(it -> it.getSettlementAmount() != null).map(PurchasePaymentPlanReconciliationVO::getSettlementAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
                String sourceNumber = voList.stream().filter(it -> it.getSettlementAmount() != null).map(PurchasePaymentPlanReconciliationVO::getSourceNumber).collect(Collectors.joining(","));
                int size = voList.stream().collect(Collectors.groupingBy(PurchasePaymentPlanReconciliationVO::getSourceType)).size();
                PurchasePaymentPlanReconciliationVO vo = voList.get(0);
                vo.setSourceNumber(sourceNumber);
                vo.setSettlementAmount(settlementAmount);
                vo.setPaymentStatus(PaymentPlanItemStatusEnum.NOT_APPLY.getValue());
                if (size == 2) {
                    vo.setSourceType(PaymentPlanItemSourceTypeEnum.STOCKANDPROMISERECONCILIATION.getValue());
                }
                list.add(vo);
            }
        }
        return list;
    }

    @Override
    public List<PurchasePaymentPlanReconciliationVO> setAcceptanceDenominationVal(List<PurchasePaymentPlanReconciliationVO> pageList) {
        return this.validAcceptanceDenomination(pageList, null);
    }

    @Override
    public List<PurchasePaymentPlanItem> handleAcceptanceDenomination(List<PurchasePaymentPlanItem> purchasePaymentPlanItemList) {
        return this.validAcceptanceDenomination(null, purchasePaymentPlanItemList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void invalid(String id) {
        PurchasePaymentPlanHead head = (PurchasePaymentPlanHead)((Object)this.getById((Serializable)((Object)id)));
        if (ObjectUtils.isEmpty((Object)((Object)head))) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_YxuIdjnRWF_ceeb2a8c", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u91c7\u8d2d\u6570\u636e"));
        }
        head.setPaymentPlanStatus(PaymentPlanStatusEnum.INVALID.getValue());
        this.updateById((Object)head);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void updatePaymentPlanItem(PurchasePaymentApplyHead applyHead, List<PurchasePaymentApplyItem> applyItemList) {
        List<String> paymentPlanNumberList = new ArrayList<String>();
        if (CollUtil.isNotEmpty(applyItemList)) {
            applyItemList = applyItemList.stream().filter(x -> "paymentPlan".equals(x.getSourceType())).collect(Collectors.toList());
            paymentPlanNumberList = applyItemList.stream().map(PurchasePaymentApplyItem::getSourceNumber).distinct().collect(Collectors.toList());
            if (CollUtil.isNotEmpty(applyItemList)) {
                ArrayList<PurchasePaymentPlanItem> itemList = new ArrayList<PurchasePaymentPlanItem>();
                for (PurchasePaymentApplyItem applyItem : applyItemList) {
                    PurchasePaymentPlanItem item = new PurchasePaymentPlanItem();
                    item.setId(applyItem.getSourceId());
                    item.setPaymentApplyStatus(applyHead.getPaymentApplyStatus());
                    item.setPaymentApplyNumber(applyItem.getPaymentApplyNumber());
                    item.setPaymentAmount(applyItem.getPayAmount());
                    item.setPaymentActualDate(applyHead.getPaymentActualDate());
                    if (CommonConstant.DEL_FLAG_1.equals(applyItem.getDeleted())) {
                        item.setPaymentStatus(PaymentPlanItemStatusEnum.NOT_APPLY.getValue());
                    } else {
                        if (PaymentApplyStatusEnum.CANCELLATION.getValue().equals(applyHead.getPaymentApplyStatus())) {
                            item.setPaymentStatus(PaymentPlanItemStatusEnum.NOT_APPLY.getValue());
                        }
                        if (PaymentApplyStatusEnum.OUTSTANDING.getValue().equals(applyHead.getPaymentApplyStatus())) {
                            item.setPaymentStatus(PaymentPlanItemStatusEnum.DO_APPLY.getValue());
                        }
                        if (PaymentApplyStatusEnum.HAS_BEEN_PAID.getValue().equals(applyHead.getPaymentApplyStatus())) {
                            item.setPaymentStatus(PaymentPlanItemStatusEnum.PAY_END.getValue());
                        }
                    }
                    itemList.add(item);
                }
                this.purchasePaymentPlanItemService.updateBatchById(itemList);
            }
        }
        this.updatePaymentPlanStatusByItemList(paymentPlanNumberList);
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void checkReconciliationNumberAndUpdatePaymentApply(List<PurchasePaymentApplyItem> applyItemList) {
        if (CollUtil.isNotEmpty(applyItemList)) {
            List promiseReconciliationList;
            List idList;
            List list;
            List stockReconciliationList;
            Map<String, String> paymentPlanApplyItemList = this.getPaymentPlanItemReconcilationNumberList(applyItemList);
            List<PurchasePaymentApplyItem> reconciliationApplyItemList = applyItemList.stream().filter(x -> PaymentApplySourceTypeEnum.RECONCILIATION.getValue().equals(x.getSourceType())).collect(Collectors.toList());
            List<PurchasePaymentApplyItem> performanceReconciliationApplyItemList = applyItemList.stream().filter(x -> PaymentApplySourceTypeEnum.PERFORMANCE_RECONCILIATION.getValue().equals(x.getSourceType())).collect(Collectors.toList());
            this.checkReconciliationNumberRepeat(paymentPlanApplyItemList, reconciliationApplyItemList);
            this.checkReconciliationNumberRepeat(paymentPlanApplyItemList, performanceReconciliationApplyItemList);
            List<Object> sourceNumberList = new ArrayList();
            if (CollUtil.isNotEmpty(paymentPlanApplyItemList)) {
                sourceNumberList = paymentPlanApplyItemList.keySet().stream().collect(Collectors.toList());
            }
            if (CollUtil.isNotEmpty(sourceNumberList) && CollUtil.isNotEmpty((Collection)(stockReconciliationList = this.purchaseReconciliationService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).in((Object)"reconciliation_number", sourceNumberList))))) {
                list = stockReconciliationList.stream().filter(x -> "1".equals(x.getPaymentApply())).map(PurchaseReconciliation::getReconciliationNumber).distinct().collect(Collectors.toList());
                Assert.isTrue((CollUtil.isEmpty(list) || list.size() == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_BVUVcIdjJHtEcRKjIet0IcIBVUVxiTVBUV_42df145b", (String)"\u4ed8\u6b3e\u7533\u8bf7\u884c\u5bf9\u5e94\u7684\u8d44\u91d1\u8ba1\u5212\u884c\u5173\u8054\u7684\u5bf9\u8d26\u5355\u3010${0}\u3011,\u5df2\u521b\u5efa\u4ed8\u6b3e\u7533\u8bf7\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u7533\u8bf7", (String[])new String[]{list.stream().collect(Collectors.joining(","))}));
                idList = stockReconciliationList.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseReconciliationService.lambdaUpdate().in(BaseEntity::getId, idList)).set(PurchaseReconciliation::getPaymentApply, (Object)"1")).update();
            }
            if (CollUtil.isNotEmpty(sourceNumberList) && CollUtil.isNotEmpty((Collection)(promiseReconciliationList = this.purchasePerformanceReconciliationService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).in((Object)"reconciliation_number", sourceNumberList))))) {
                list = promiseReconciliationList.stream().filter(x -> "1".equals(x.getPaymentApply())).map(PurchasePerformanceReconciliation::getReconciliationNumber).distinct().collect(Collectors.toList());
                Assert.isTrue((CollUtil.isEmpty(list) || list.size() == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_BVUVcIdjJHtEcRKjIet0IcIBVUVxiTVBUV_42df145b", (String)"\u4ed8\u6b3e\u7533\u8bf7\u884c\u5bf9\u5e94\u7684\u8d44\u91d1\u8ba1\u5212\u884c\u5173\u8054\u7684\u5bf9\u8d26\u5355\u3010${0}\u3011,\u5df2\u521b\u5efa\u4ed8\u6b3e\u7533\u8bf7\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u7533\u8bf7", (String[])new String[]{list.stream().collect(Collectors.joining(","))}));
                idList = promiseReconciliationList.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchasePerformanceReconciliationService.lambdaUpdate().in(BaseEntity::getId, idList)).set(PurchasePerformanceReconciliation::getPaymentApply, (Object)"1")).update();
            }
        }
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteMain(String id) {
        this.purchasePaymentPlanItemService.deleteByMainId(id);
        ((PurchasePaymentPlanHeadMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public void deleteBatchMain(List<String> idList) {
        for (Serializable serializable : idList) {
            this.purchasePaymentPlanItemService.deleteByMainId(serializable.toString());
            ((PurchasePaymentPlanHeadMapper)this.baseMapper).deleteById(serializable);
        }
    }

    @Override
    public IPage<PurchasePaymentPlanItemVO> selectPlanReconciliationPage(Page<PurchasePaymentPlanItemVO> page, QueryWrapper<PurchasePaymentPlanItemVO> queryWrapper) {
        return this.purchasePaymentPlanItemService.selectPlanReconciliationPage(page, queryWrapper);
    }

    public void updatePaymentPlanStatusByItemList(List<String> paymentPlanNumberList) {
        if (CollUtil.isNotEmpty(paymentPlanNumberList)) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.in((Object)"payment_plan_number", paymentPlanNumberList);
            List list = this.list((Wrapper)wrapper);
            if (CollUtil.isNotEmpty((Collection)list)) {
                List idList = list.stream().map(BaseEntity::getId).collect(Collectors.toList());
                QueryWrapper wrapperItem = new QueryWrapper();
                wrapperItem.in((Object)"head_id", idList);
                List listItem = this.purchasePaymentPlanItemService.list((Wrapper)wrapperItem);
                Map<String, List<PurchasePaymentPlanItem>> listMap = listItem.stream().collect(Collectors.groupingBy(PurchasePaymentPlanItem::getHeadId));
                ArrayList<PurchasePaymentPlanHead> updateList = new ArrayList<PurchasePaymentPlanHead>();
                for (PurchasePaymentPlanHead head : list) {
                    List<PurchasePaymentPlanItem> itemList = listMap.get(head.getId());
                    long paid = itemList.stream().filter(it -> "2".equals(it.getPaymentStatus())).count();
                    long notApply = itemList.stream().filter(it -> "0".equals(it.getPaymentStatus())).count();
                    if (notApply == (long)list.size()) {
                        head.setPaymentPlanStatus(PaymentPlanStatusEnum.PUBLISHED.getValue());
                    } else {
                        head.setPaymentPlanStatus(PaymentPlanStatusEnum.EXECUTING.getValue());
                    }
                    if (paid == (long)list.size()) {
                        head.setPaymentPlanStatus(PaymentPlanStatusEnum.FINISHED.getValue());
                    }
                    if (PaymentPlanStatusEnum.isCreateAndInvalid(head.getPaymentPlanStatus())) continue;
                    updateList.add(head);
                }
                if (CollUtil.isNotEmpty(updateList)) {
                    this.updateBatchById(updateList);
                }
            }
        }
    }

    public void setReconciliationPaymentPlan(List<PurchasePaymentPlanItem> itemList, String paymentPlan) {
        if (CollUtil.isNotEmpty(itemList)) {
            List promiseReconciliationList;
            List<String> list = itemList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getSourceNumber())).map(PurchasePaymentPlanItem::getSourceNumber).distinct().collect(Collectors.toList());
            if (CollUtil.isEmpty(list) || list.size() == 0) {
                return;
            }
            ArrayList sourceNumberList = new ArrayList();
            list.forEach(x -> {
                String[] arr;
                for (String s : arr = x.split(",")) {
                    sourceNumberList.add(s);
                }
            });
            List stockReconciliationList = this.purchaseReconciliationService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).in((Object)"reconciliation_number", sourceNumberList));
            if (CollUtil.isNotEmpty((Collection)stockReconciliationList)) {
                List idList = stockReconciliationList.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseReconciliationService.lambdaUpdate().in(BaseEntity::getId, idList)).set(PurchaseReconciliation::getPaymentPlan, (Object)paymentPlan)).update();
            }
            if (CollUtil.isNotEmpty((Collection)(promiseReconciliationList = this.purchasePerformanceReconciliationService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).in((Object)"reconciliation_number", sourceNumberList))))) {
                List idList = promiseReconciliationList.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchasePerformanceReconciliationService.lambdaUpdate().in(BaseEntity::getId, idList)).set(PurchasePerformanceReconciliation::getPaymentPlan, (Object)paymentPlan)).update();
            }
        }
    }

    private void checkPaymentPlanItemInfo(List<PurchasePaymentPlanItem> purchasePaymentPlanItemList) {
        String now = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate nowDate = LocalDate.parse(now, formatter);
        purchasePaymentPlanItemList.forEach(x -> {
            String delayDate;
            LocalDate delaydateDate;
            String expiredate;
            LocalDate expiredateDate;
            Date paymentExpiredate = x.getPaymentExpiredate();
            if (paymentExpiredate != null && (expiredateDate = LocalDate.parse(expiredate = DateUtil.format((Date)paymentExpiredate, (String)"yyyy-MM-dd"), formatter)).isAfter(nowDate)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APBAfUEUBVuABAnqIcI_e2b3e7b3", (String)"\u5f53\u524d\u65e5\u671f\u5927\u4e8e\u7b49\u4e8e\u4ed8\u6b3e\u5230\u671f\u65e5\u671f\u624d\u53ef\u4ee5\u521b\u5efa"));
            }
            Date paymentDelayDate = x.getPaymentDelayDate();
            if (paymentDelayDate != null && "1".equals(x.getPaymentDelay()) && (delaydateDate = LocalDate.parse(delayDate = DateUtil.format((Date)paymentDelayDate, (String)"yyyy-MM-dd"), formatter)).isAfter(nowDate)) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APBAfUEUOABVBAnqIcI_3a287b39", (String)"\u5f53\u524d\u65e5\u671f\u5927\u4e8e\u7b49\u4e8e\u5ef6\u671f\u4ed8\u6b3e\u65e5\u671f\u624d\u53ef\u4ee5\u521b\u5efa"));
            }
            String sourceNumber = x.getSourceNumber();
            if (StringUtils.isNotBlank((CharSequence)sourceNumber)) {
                List promiseReconciliationList;
                String[] arr;
                ArrayList<String> sourceNumberList = new ArrayList<String>();
                for (String s : arr = sourceNumber.split(",")) {
                    sourceNumberList.add(s);
                }
                List stockReconciliationList = this.purchaseReconciliationService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).in((Object)"reconciliation_number", sourceNumberList)).eq((Object)"is_payment_apply", (Object)"1"));
                if (CollUtil.isNotEmpty((Collection)stockReconciliationList)) {
                    List list = stockReconciliationList.stream().map(PurchaseReconciliation::getReconciliationNumber).distinct().collect(Collectors.toList());
                    Assert.isTrue((CollUtil.isEmpty(list) || list.size() == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_JHtEcRKjIet0IcIBVUVxiTVBUV_368b79e2", (String)"\u8d44\u91d1\u8ba1\u5212\u884c\u5173\u8054\u7684\u5bf9\u8d26\u5355\u3010${0}\u3011,\u5df2\u521b\u5efa\u4ed8\u6b3e\u7533\u8bf7\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u7533\u8bf7", (String[])new String[]{list.stream().collect(Collectors.joining(","))}));
                }
                if (CollUtil.isNotEmpty((Collection)(promiseReconciliationList = this.purchasePerformanceReconciliationService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"els_account", (Object)TenantContext.getTenant())).in((Object)"reconciliation_number", sourceNumberList)).eq((Object)"is_payment_apply", (Object)"1"))))) {
                    List list = promiseReconciliationList.stream().map(PurchasePerformanceReconciliation::getReconciliationNumber).distinct().collect(Collectors.toList());
                    Assert.isTrue((CollUtil.isEmpty(list) || list.size() == 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_JHtEcRKjIet0IcIBVUVxiTVBUV_368b79e2", (String)"\u8d44\u91d1\u8ba1\u5212\u884c\u5173\u8054\u7684\u5bf9\u8d26\u5355\u3010${0}\u3011,\u5df2\u521b\u5efa\u4ed8\u6b3e\u7533\u8bf7\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u7533\u8bf7", (String[])new String[]{list.stream().collect(Collectors.joining(","))}));
                }
            }
        });
    }

    private void handleAcceptanceDenominationOptionsList(List<PurchasePaymentPlanItem> purchasePaymentPlanItemList) {
        List acceptanceDenominationList = this.baseRpcService.queryDictItemsByCode("acceptanceDenomination", TenantContext.getTenant());
        if (CollUtil.isNotEmpty((Collection)acceptanceDenominationList) && CollUtil.isNotEmpty(purchasePaymentPlanItemList)) {
            ArrayList<Map> acceptanceDenominationOptionsList = new ArrayList<Map>();
            for (DictDTO dictDTO : acceptanceDenominationList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("value", dictDTO.getValue());
                map.put("label", I18nUtil.translate((String)dictDTO.getTextI18nKey(), (String)dictDTO.getText()));
                acceptanceDenominationOptionsList.add(map);
            }
            List toElsAccountList = purchasePaymentPlanItemList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getToElsAccount())).map(PurchasePaymentPlanItem::getToElsAccount).distinct().collect(Collectors.toList());
            List masterDataDTOList = this.coreInvokeSupplierRpcService.selectSupplerList(TenantContext.getTenant(), toElsAccountList);
            Map dataMap = masterDataDTOList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getToElsAccount, Function.identity(), (v1, v2) -> v2));
            for (PurchasePaymentPlanItem item : purchasePaymentPlanItemList) {
                item.setAcceptanceDenominationOptionsList(acceptanceDenominationOptionsList);
                SupplierMasterDataDTO dto = (SupplierMasterDataDTO)dataMap.get(item.getToElsAccount());
                if (dto == null || dto.getAcceptanceDenomination() == null) continue;
                ArrayList<Map> newAcceptanceDenominationOptionsList = new ArrayList<Map>();
                for (Map map : acceptanceDenominationOptionsList) {
                    HashMap newMap = new HashMap();
                    newMap.put("value", map.get("value"));
                    newMap.put("label", map.get("label"));
                    BigDecimal value = new BigDecimal(Long.valueOf(map.get("value").toString()));
                    if (value.compareTo(dto.getAcceptanceDenomination()) == 1) {
                        newMap.put("disabled", true);
                    }
                    newAcceptanceDenominationOptionsList.add(newMap);
                }
                item.setAcceptanceDenominationOptionsList(newAcceptanceDenominationOptionsList);
            }
        }
    }

    private <T extends PurchasePaymentPlanReconciliationVO, R extends PurchasePaymentPlanItem> List validAcceptanceDenomination(List<T> voList, List<R> itemList) {
        List acceptanceDenominationList;
        List<Object> toElsAccountList = new ArrayList();
        if (CollUtil.isNotEmpty(itemList)) {
            toElsAccountList = itemList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getToElsAccount())).map(PurchasePaymentPlanItem::getToElsAccount).distinct().collect(Collectors.toList());
        }
        if (CollUtil.isNotEmpty(voList)) {
            toElsAccountList = voList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getToElsAccount())).map(PurchasePaymentPlanReconciliationVO::getToElsAccount).distinct().collect(Collectors.toList());
        }
        if (CollUtil.isNotEmpty(toElsAccountList) && CollUtil.isNotEmpty((Collection)(acceptanceDenominationList = this.baseRpcService.queryDictItemsByCode("acceptanceDenomination", TenantContext.getTenant())))) {
            BigDecimal value;
            HashMap newMap;
            ArrayList<Map> newAcceptanceDenominationOptionsList;
            BigDecimal val;
            List bigDecimals;
            SupplierMasterDataDTO dto;
            ArrayList<Map> acceptanceDenominationOptionsList = new ArrayList<Map>();
            for (DictDTO dictDTO : acceptanceDenominationList) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("value", dictDTO.getValue());
                map.put("label", I18nUtil.translate((String)dictDTO.getTextI18nKey(), (String)dictDTO.getText()));
                acceptanceDenominationOptionsList.add(map);
            }
            List dictList = acceptanceDenominationList.stream().map(DictDTO::getValue).distinct().collect(Collectors.toList());
            List bigDecimalList = dictList.stream().map(BigDecimal::new).collect(Collectors.toList());
            List masterDataDTOList = this.coreInvokeSupplierRpcService.selectSupplerList(TenantContext.getTenant(), toElsAccountList);
            Map dataMap = masterDataDTOList.stream().collect(Collectors.toMap(SupplierMasterDataDTO::getToElsAccount, Function.identity(), (v1, v2) -> v2));
            Collections.sort(bigDecimalList);
            if (CollUtil.isNotEmpty(itemList)) {
                for (Object vo : itemList) {
                    ((PurchasePaymentPlanItem)((Object)vo)).setAcceptanceDenominationOptionsList(acceptanceDenominationOptionsList);
                    ((PurchasePaymentPlanItem)((Object)vo)).setAcceptanceDenomination(String.valueOf(bigDecimalList.get(0)));
                    dto = (SupplierMasterDataDTO)dataMap.get(((PurchasePaymentPlanItem)((Object)vo)).getToElsAccount());
                    if (dto == null) continue;
                    ((PurchasePaymentPlanItem)((Object)vo)).setSupplierCode(dto.getSupplierCode());
                    ((PurchasePaymentPlanItem)((Object)vo)).setSupplierName(dto.getSupplierName());
                    if (dto.getAcceptanceDenomination() == null) continue;
                    bigDecimals = bigDecimalList.stream().filter(x -> x.compareTo(dto.getAcceptanceDenomination()) <= 0).collect(Collectors.toList());
                    if (CollUtil.isNotEmpty(bigDecimals)) {
                        Collections.sort(bigDecimals);
                        val = bigDecimals.size() > 1 ? (BigDecimal)bigDecimals.get(bigDecimals.size() - 1) : (BigDecimal)bigDecimals.get(0);
                        ((PurchasePaymentPlanItem)((Object)vo)).setAcceptanceDenomination(String.valueOf(val));
                    } else {
                        ((PurchasePaymentPlanItem)((Object)vo)).setAcceptanceDenomination(String.valueOf(bigDecimalList.get(bigDecimalList.size() - 1)));
                    }
                    newAcceptanceDenominationOptionsList = new ArrayList();
                    for (Map map : acceptanceDenominationOptionsList) {
                        newMap = new HashMap();
                        newMap.put("value", map.get("value"));
                        newMap.put("label", map.get("label"));
                        value = new BigDecimal(Long.valueOf(map.get("value").toString()));
                        if (value.compareTo(dto.getAcceptanceDenomination()) == 1) {
                            newMap.put("disabled", true);
                        }
                        newAcceptanceDenominationOptionsList.add(newMap);
                    }
                    ((PurchasePaymentPlanItem)((Object)vo)).setAcceptanceDenominationOptionsList(newAcceptanceDenominationOptionsList);
                }
            }
            if (CollUtil.isNotEmpty(voList)) {
                for (Object vo : voList) {
                    ((PurchasePaymentPlanReconciliationVO)((Object)vo)).setAcceptanceDenominationOptionsList(acceptanceDenominationOptionsList);
                    ((PurchasePaymentPlanReconciliationVO)((Object)vo)).setAcceptanceDenomination(String.valueOf(bigDecimalList.get(0)));
                    dto = (SupplierMasterDataDTO)dataMap.get(((PurchasePaymentPlanReconciliationVO)((Object)vo)).getToElsAccount());
                    if (dto == null) continue;
                    ((PurchasePaymentPlanReconciliationVO)((Object)vo)).setSupplierCode(dto.getSupplierCode());
                    ((PurchasePaymentPlanReconciliationVO)((Object)vo)).setSupplierName(dto.getSupplierName());
                    if (dto.getAcceptanceDenomination() == null) continue;
                    bigDecimals = bigDecimalList.stream().filter(x -> x.compareTo(dto.getAcceptanceDenomination()) <= 0).collect(Collectors.toList());
                    if (CollUtil.isNotEmpty(bigDecimals)) {
                        Collections.sort(bigDecimals);
                        val = bigDecimals.size() > 1 ? (BigDecimal)bigDecimals.get(bigDecimals.size() - 1) : (BigDecimal)bigDecimals.get(0);
                        ((PurchasePaymentPlanReconciliationVO)((Object)vo)).setAcceptanceDenomination(String.valueOf(val));
                    } else {
                        ((PurchasePaymentPlanReconciliationVO)((Object)vo)).setAcceptanceDenomination(String.valueOf(bigDecimalList.get(bigDecimalList.size() - 1)));
                    }
                    newAcceptanceDenominationOptionsList = new ArrayList<Map>();
                    for (Map map : acceptanceDenominationOptionsList) {
                        newMap = new HashMap();
                        newMap.put("value", map.get("value"));
                        newMap.put("label", map.get("label"));
                        value = new BigDecimal(Long.valueOf(map.get("value").toString()));
                        if (value.compareTo(dto.getAcceptanceDenomination()) == 1) {
                            newMap.put("disabled", true);
                        }
                        newAcceptanceDenominationOptionsList.add(newMap);
                    }
                    ((PurchasePaymentPlanReconciliationVO)((Object)vo)).setAcceptanceDenominationOptionsList(newAcceptanceDenominationOptionsList);
                }
            }
        }
        if (CollUtil.isNotEmpty(itemList)) {
            return itemList;
        }
        if (CollUtil.isNotEmpty(voList)) {
            return voList;
        }
        return CollUtil.newArrayList((Object[])new Object[0]);
    }

    private Map<String, String> getPaymentPlanItemReconcilationNumberList(List<PurchasePaymentApplyItem> applyItemList) {
        HashMap<String, String> reconciliationNumberList = new HashMap<String, String>();
        List paymentPlanApplyItemList = applyItemList.stream().filter(x -> PaymentApplySourceTypeEnum.PAYMENTPLAN.getValue().equals(x.getSourceType())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(paymentPlanApplyItemList)) {
            List paymentPlanItemIdList = paymentPlanApplyItemList.stream().filter(x -> StringUtils.isNotBlank((CharSequence)x.getSourceId())).map(PurchasePaymentApplyItem::getSourceId).collect(Collectors.toList());
            Map itemMap = paymentPlanApplyItemList.stream().collect(Collectors.toMap(PurchasePaymentApplyItem::getSourceId, Function.identity(), (v1, v2) -> v2));
            if (CollUtil.isNotEmpty(paymentPlanItemIdList)) {
                QueryWrapper wrapper = new QueryWrapper();
                wrapper.in((Object)"id", paymentPlanItemIdList);
                List list = this.purchasePaymentPlanItemService.list((Wrapper)wrapper);
                if (CollUtil.isNotEmpty((Collection)list)) {
                    list.forEach(item -> {
                        String sourceNumber = item.getSourceNumber();
                        if (StringUtils.isNotBlank((CharSequence)sourceNumber)) {
                            String[] arr;
                            for (String s : arr = sourceNumber.split(",")) {
                                HashMap map = new HashMap();
                                PurchasePaymentApplyItem applyItem = (PurchasePaymentApplyItem)((Object)((Object)itemMap.get(item.getId())));
                                if (applyItem != null) {
                                    reconciliationNumberList.put(s, applyItem.getSourceNumber() + "_" + item.getId());
                                    continue;
                                }
                                reconciliationNumberList.put(s, item.getId());
                            }
                        }
                    });
                }
            }
        }
        return reconciliationNumberList;
    }

    private void checkReconciliationNumberRepeat(Map<String, String> paymentPlanApplyItemList, List<PurchasePaymentApplyItem> applyItemList) {
        if (CollUtil.isNotEmpty(paymentPlanApplyItemList) && CollUtil.isNotEmpty(applyItemList)) {
            List sourceNumberList = paymentPlanApplyItemList.keySet().stream().collect(Collectors.toList());
            ArrayList errList_0 = new ArrayList();
            ArrayList errList_1 = new ArrayList();
            applyItemList.forEach(x -> {
                if (sourceNumberList.contains(x.getSourceNumber())) {
                    String val;
                    if (!errList_1.contains(x.getSourceNumber())) {
                        errList_1.add(x.getSourceNumber());
                    }
                    if (StringUtils.isNotBlank((CharSequence)(val = (String)paymentPlanApplyItemList.get(x.getSourceNumber()))) && !errList_0.contains(val)) {
                        errList_0.add(val);
                    }
                }
            });
            Assert.isTrue((CollUtil.isNotEmpty(errList_1) && CollUtil.isNotEmpty(errList_0) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_BVUVcjJHtEc0IOsxrIet1VQGVBjIetAcSNJHtEAcRH_a71594d1", (String)"\u4ed8\u6b3e\u7533\u8bf7\u884c\u7684\u8d44\u91d1\u8ba1\u5212\u884c\u3010${0)\u3011\uff0c\u5df2\u7ecf\u5305\u542b\u4e86\u5bf9\u8d26\u5355\u3010$(1)\u3011\uff0c\u8bf7\u5220\u9664\u91cd\u590d\u7684\u5bf9\u8d26\u5355\u7c7b\u578b\u6216\u8005\u8d44\u91d1\u8ba1\u5212\u7c7b\u578b\u660e\u7ec6", (String[])new String[]{errList_1.stream().collect(Collectors.joining(",")), errList_1.stream().collect(Collectors.joining(","))}));
        }
    }
}

