/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.finance.api.enumerate.DeductCostConfirmStatusEnum;
import com.els.modules.finance.entity.PurchaseDeductCost;
import com.els.modules.finance.entity.PurchaseDeductCostItem;
import com.els.modules.finance.entity.SaleDeductCost;
import com.els.modules.finance.entity.SaleDeductCostItem;
import com.els.modules.finance.mapper.SaleDeductCostMapper;
import com.els.modules.finance.service.PurchaseDeductCostItemService;
import com.els.modules.finance.service.PurchaseDeductCostService;
import com.els.modules.finance.service.PurchaseDeliveryWaterService;
import com.els.modules.finance.service.SaleDeductCostItemService;
import com.els.modules.finance.service.SaleDeductCostService;
import com.els.modules.finance.service.impl.PurchaseDeductCostServiceImpl;
import com.els.modules.finance.vo.SaleDeductCostVO;
import com.els.modules.reconciliation.api.dto.PurchaseDeliveryWaterDTO;
import com.els.modules.reconciliation.entity.SaleRecCharge;
import com.els.modules.reconciliation.enumerate.ReconcilationItemTypeEmun;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SaleDeductCostServiceImpl
extends BaseServiceImpl<SaleDeductCostMapper, SaleDeductCost>
implements SaleDeductCostService {
    @Resource
    private PurchaseDeliveryWaterService purchaseDeliveryWaterService;
    @Autowired
    private SaleDeductCostItemService saleDeductCostItemService;
    @Autowired
    private PurchaseDeductCostItemService purchaseDeductCostItemService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void saveSaleDeductCost(SaleDeductCost saleDeductCost) {
        ((SaleDeductCostMapper)this.baseMapper).insert((Object)saleDeductCost);
    }

    @Override
    public void updateSaleDeductCost(SaleDeductCost saleDeductCost) {
        ((SaleDeductCostMapper)this.baseMapper).updateById((Object)saleDeductCost);
    }

    @Override
    public void asyPurchaseAttachment(SaleDeductCost saleDeductCost, List<SaleAttachmentDTO> attachments) {
        if (CollectionUtils.isEmpty(attachments)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VWXVBI_7536c9b9", (String)"\u8bf7\u5148\u4e0a\u4f20\u9644\u4ef6!"));
        }
        ArrayList<PurchaseAttachmentDTO> purchaseAttachments = new ArrayList<PurchaseAttachmentDTO>();
        for (SaleAttachmentDTO saleAttachment : attachments) {
            saleAttachment.setSendStatus("1");
            PurchaseAttachmentDTO purchaseAttachment = new PurchaseAttachmentDTO();
            BeanUtils.copyProperties((Object)saleAttachment, (Object)purchaseAttachment);
            purchaseAttachment.setId(null);
            purchaseAttachment.setElsAccount(saleDeductCost.getElsAccount());
            purchaseAttachment.setHeadId(saleDeductCost.getRelationId());
            purchaseAttachment.setRelationId(saleAttachment.getId());
            purchaseAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
            purchaseAttachments.add(purchaseAttachment);
        }
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(saleDeductCost.getRelationId());
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachments);
    }

    @Override
    public void replyDeductCost(SaleDeductCost saleDeductCost, List<SaleDeductCostItem> deductCostItemList) {
        Set ids;
        List purchaseDeductCostItems;
        String relationId = saleDeductCost.getRelationId();
        PurchaseDeductCost purchaseDeductCost = new PurchaseDeductCost();
        purchaseDeductCost.setId(relationId);
        purchaseDeductCost.setConfirmStatus(saleDeductCost.getConfirmStatus());
        purchaseDeductCost.setRejectReason(saleDeductCost.getRejectReason());
        PurchaseDeductCostService purchaseDeductCostService = (PurchaseDeductCostService)SpringContextUtils.getBean(PurchaseDeductCostServiceImpl.class);
        purchaseDeductCostService.updateById((Object)purchaseDeductCost);
        this.updateById((Object)saleDeductCost);
        SaleDeductCost byId = (SaleDeductCost)((Object)this.getById((Serializable)((Object)saleDeductCost.getId())));
        HashMap<String, SaleDeductCostItem> map = new HashMap<String, SaleDeductCostItem>();
        if (!CollectionUtils.isEmpty(deductCostItemList)) {
            for (SaleDeductCostItem saleDeductCostItem : deductCostItemList) {
                if (StringUtils.isEmpty((CharSequence)saleDeductCostItem.getRelationId())) continue;
                map.put(saleDeductCostItem.getRelationId(), saleDeductCostItem);
                saleDeductCostItem.setReplyTime(new Date());
            }
            this.saleDeductCostItemService.updateBatchById(deductCostItemList);
        }
        if (!CollectionUtils.isEmpty(map) && !CollectionUtils.isEmpty((Collection)(purchaseDeductCostItems = this.purchaseDeductCostItemService.listByIds(ids = map.keySet())))) {
            for (PurchaseDeductCostItem purchaseDeductCostItem : purchaseDeductCostItems) {
                SaleDeductCostItem saleDeductCostItem = (SaleDeductCostItem)((Object)map.get(purchaseDeductCostItem.getId()));
                if (saleDeductCostItem == null) continue;
                purchaseDeductCostItem.setReply(saleDeductCostItem.getReply());
                purchaseDeductCostItem.setReplyTime(saleDeductCostItem.getReplyTime());
            }
            this.purchaseDeductCostItemService.updateBatchById(purchaseDeductCostItems);
        }
        if (DeductCostConfirmStatusEnum.ALREADY_CONFIRM.getValue().equals(saleDeductCost.getConfirmStatus())) {
            PurchaseDeliveryWaterDTO purchaseDeliveryWater = new PurchaseDeliveryWaterDTO();
            BeanUtils.copyProperties((Object)((Object)byId), (Object)purchaseDeliveryWater);
            if (!ObjectUtils.isEmpty((Object)purchaseDeliveryWater)) {
                purchaseDeliveryWater.setDocumentNumber(byId.getDeductNumber());
                purchaseDeliveryWater.setTotalAmount(byId.getTaxAmount());
                purchaseDeliveryWater.setTotalNonTaxAmount(byId.getNetAmount());
                purchaseDeliveryWater.setToElsAccount(byId.getElsAccount());
                purchaseDeliveryWater.setDocumentCategory("1");
                purchaseDeliveryWater.setDocumentStatus("\u5df2\u786e\u8ba4");
                purchaseDeliveryWater.setDocumentType("1");
                purchaseDeliveryWater.setReconciliationNumber(byId.getReconciliationNumber());
                purchaseDeliveryWater.setElsAccount(byId.getToElsAccount());
                purchaseDeliveryWater.setToElsAccount(byId.getElsAccount());
                this.purchaseDeliveryWaterService.insert(purchaseDeliveryWater);
            }
        }
        super.sendMessage(byId.getBusAccount(), "deductCost", "reply", byId.getId(), "deductCostBusDataServiceImpl", Arrays.asList(byId.getToElsAccount()));
    }

    @Override
    public List<SaleDeductCost> listSaleDeductCosts(ReconciliationVO reconciliationVO) {
        QueryWrapper deDuctWapper = new QueryWrapper();
        deDuctWapper.eq((Object)"els_account", (Object)reconciliationVO.getElsAccount());
        deDuctWapper.eq((Object)"to_els_account", (Object)reconciliationVO.getToElsAccount());
        deDuctWapper.eq((Object)"company", (Object)reconciliationVO.getCompany());
        deDuctWapper.ge((Object)"deduct_time", (Object)reconciliationVO.getBeginDate());
        deDuctWapper.le((Object)"deduct_time", (Object)reconciliationVO.getEndDate());
        deDuctWapper.eq((Object)"confirm_status", (Object)DeductCostConfirmStatusEnum.ALREADY_CONFIRM.getValue());
        deDuctWapper.and(q -> ((QueryWrapper)((QueryWrapper)q.isNull((Object)"deduct_status")).or()).eq((Object)"deduct_status", (Object)"0"));
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getTaxCode())) {
            deDuctWapper.eq((Object)"tax_code", (Object)reconciliationVO.getTaxCode());
        }
        if (StringUtils.isNotBlank((CharSequence)reconciliationVO.getCurrency())) {
            deDuctWapper.eq((Object)"currency", (Object)reconciliationVO.getCurrency());
        }
        return this.list((Wrapper)deDuctWapper);
    }

    @Override
    public List<SaleRecCharge> getBySaleDeductCost(ReconciliationVO reconciliationVO) {
        List<SaleDeductCost> saleDeductCosts = this.listSaleDeductCosts(reconciliationVO);
        ArrayList<SaleRecCharge> charges = new ArrayList<SaleRecCharge>();
        if (CollectionUtils.isEmpty(saleDeductCosts)) {
            return null;
        }
        for (SaleDeductCost saleDeductCost : saleDeductCosts) {
            SaleRecCharge charge = new SaleRecCharge();
            BeanUtils.copyProperties((Object)((Object)saleDeductCost), (Object)((Object)charge));
            charge.setItemType(ReconcilationItemTypeEmun.CHARGE.getValue());
            charge.setVoucherNumber(saleDeductCost.getDeductNumber());
            charge.setVoucherTime(saleDeductCost.getDeductTime());
            charge.setDeductionType(saleDeductCost.getDeductType());
            charge.setTotalAmount(saleDeductCost.getTaxAmount());
            charge.setTotalNonTaxAmount(saleDeductCost.getNetAmount());
            charge.setDeductionsReason(saleDeductCost.getDeductReason());
            charge.setDeductionsInstructions(saleDeductCost.getDeductInstruction());
            charge.setSource(saleDeductCost.getSourceType());
            charge.setBusinessType(saleDeductCost.getRelationType());
            charge.setBusinessId(saleDeductCost.getId());
            charge.setTaxCode(saleDeductCost.getTaxCode());
            charge.setTaxRate(saleDeductCost.getTaxRate());
            charge.setDocumentId(saleDeductCost.getDocumentId());
            charge.setDocumentParentId(saleDeductCost.getRelationId());
            charge.setId(null);
            charges.add(charge);
        }
        return charges;
    }

    @Override
    public JSONObject getDataById(String id) {
        SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.getById((Serializable)((Object)id)));
        if (Objects.isNull((Object)saleDeductCost)) {
            return null;
        }
        SaleDeductCostVO headVO = (SaleDeductCostVO)((Object)BeanUtil.copyProperties((Object)((Object)saleDeductCost), SaleDeductCostVO.class, (String[])new String[0]));
        Result result = Result.ok((Object)((Object)headVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }

    @Override
    public List<SaleDeductCost> checkHasReconciliation(Set<String> voucherNumbers) {
        if (CollectionUtil.isEmpty(voucherNumbers)) {
            return new ArrayList<SaleDeductCost>();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SaleDeductCost::getDeductNumber, voucherNumbers);
        return this.list((Wrapper)queryWrapper);
    }
}

