/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.integrate.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.SpringContextUtils;
import com.els.modules.finance.entity.PurchaseAddCost;
import com.els.modules.finance.entity.PurchaseAddCostItem;
import com.els.modules.finance.entity.PurchaseDeductCost;
import com.els.modules.finance.entity.PurchaseDeductCostItem;
import com.els.modules.finance.entity.PurchasePaymentApplyHead;
import com.els.modules.finance.entity.PurchasePaymentApplyItem;
import com.els.modules.finance.service.PurchaseAddCostItemService;
import com.els.modules.finance.service.PurchaseAddCostService;
import com.els.modules.finance.service.PurchaseDeductCostItemService;
import com.els.modules.finance.service.PurchaseDeductCostService;
import com.els.modules.finance.service.PurchasePaymentApplyHeadService;
import com.els.modules.finance.service.PurchasePaymentApplyItemService;
import com.els.modules.finance.vo.PurchaseAddCostVO;
import com.els.modules.finance.vo.PurchaseDeductCostVO;
import com.els.modules.finance.vo.PurchasePaymentApplyHeadVO;
import com.els.modules.integrate.service.IntegrateInvokeFinaceDataService;
import com.els.modules.integrated.api.dto.IntegratedSerachConditionDTO;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.PurchasePerformanceReconciliation;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.service.PurchaseInvoiceService;
import com.els.modules.reconciliation.service.PurchasePerformanceReconciliationService;
import com.els.modules.reconciliation.service.PurchaseReconciliationService;
import com.els.modules.reconciliation.vo.PurchaseInvoiceVO;
import com.els.modules.reconciliation.vo.PurchasePerformanceReconciliationVO;
import com.els.modules.reconciliation.vo.PurchaseReconciliationVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class IntegrateInvokeFinaceDataServiceImpl
implements IntegrateInvokeFinaceDataService {
    private static final Logger log = LoggerFactory.getLogger(IntegrateInvokeFinaceDataServiceImpl.class);
    @Autowired
    private PurchasePaymentApplyHeadService purchasePaymentApplyHeadService;
    @Autowired
    private PurchasePaymentApplyItemService purchasePaymentApplyItemService;
    @Autowired
    private PurchaseReconciliationService purchaseReconciliationService;
    @Autowired
    private PurchasePerformanceReconciliationService purchasePerformanceReconciliationService;
    @Autowired
    private PurchaseInvoiceService purchaseInvoiceService;
    @Autowired
    private PurchaseDeductCostService purchaseDeductCostService;
    @Autowired
    private PurchaseDeductCostItemService purchaseDeductCostItemService;
    @Autowired
    private PurchaseAddCostService purchaseAddCostService;
    @Autowired
    private PurchaseAddCostItemService purchaseAddCostItemService;

    @Override
    public JSONArray listFinaceData(IntegratedSerachConditionDTO integratedSerachConditionDTO) {
        String businessTypeCore;
        if (StringUtils.isNotBlank((CharSequence)integratedSerachConditionDTO.getBusinessDataType()) && "head".equals(integratedSerachConditionDTO.getBusinessDataType()) && StringUtils.isNotBlank((CharSequence)(businessTypeCore = integratedSerachConditionDTO.getBusinessTypeCore()))) {
            switch (businessTypeCore) {
                case "reconciliation": {
                    ArrayList<PurchaseReconciliationVO> headVOList = new ArrayList<PurchaseReconciliationVO>();
                    List<PurchaseReconciliation> reconciliationDataByIntegraSerach = this.getReconciliationDataByIntegraSerach(integratedSerachConditionDTO);
                    if (CollectionUtils.isEmpty(reconciliationDataByIntegraSerach)) break;
                    for (PurchaseReconciliation head : reconciliationDataByIntegraSerach) {
                        PurchaseReconciliationVO headVO = new PurchaseReconciliationVO();
                        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
                        headVOList.add(headVO);
                    }
                    return this.dictAspectVO(Result.ok(reconciliationDataByIntegraSerach));
                }
                case "performanceReconciliation": {
                    ArrayList<PurchasePerformanceReconciliationVO> headVOS = new ArrayList<PurchasePerformanceReconciliationVO>();
                    List<PurchasePerformanceReconciliation> performanceReconciliationDataByIntegraSerach = this.getPerformanceReconciliationDataByIntegraSerach(integratedSerachConditionDTO);
                    if (CollectionUtils.isEmpty(performanceReconciliationDataByIntegraSerach)) break;
                    for (PurchasePerformanceReconciliation head : performanceReconciliationDataByIntegraSerach) {
                        PurchasePerformanceReconciliationVO headVO = new PurchasePerformanceReconciliationVO();
                        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
                        headVOS.add(headVO);
                    }
                    return this.dictAspectVO(Result.ok(headVOS));
                }
                case "invoice": {
                    ArrayList<PurchaseInvoiceVO> invoiceVOS = new ArrayList<PurchaseInvoiceVO>();
                    List<PurchaseInvoice> invoiceDataByIntegraSerach = this.getInvoiceDataByIntegraSerach(integratedSerachConditionDTO);
                    if (CollectionUtils.isEmpty(invoiceDataByIntegraSerach)) break;
                    for (PurchaseInvoice head : invoiceDataByIntegraSerach) {
                        PurchaseInvoiceVO headVO = new PurchaseInvoiceVO();
                        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
                        invoiceVOS.add(headVO);
                    }
                    return this.dictAspectVO(Result.ok(invoiceVOS));
                }
                case "deductCost": {
                    ArrayList<PurchaseDeductCostVO> orderHeadVOS = new ArrayList<PurchaseDeductCostVO>();
                    List<PurchaseDeductCost> deductCostDataByIntegraSerach = this.getDeductCostDataByIntegraSerach(integratedSerachConditionDTO);
                    if (CollectionUtils.isEmpty(deductCostDataByIntegraSerach)) break;
                    List collect = deductCostDataByIntegraSerach.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
                    List list = ((LambdaQueryChainWrapper)this.purchaseDeductCostItemService.lambdaQuery().in(PurchaseDeductCostItem::getHeadId, collect)).list();
                    Map<String, List> collectItem = list.stream().collect(Collectors.toMap(PurchaseDeductCostItem::getHeadId, p -> {
                        ArrayList<PurchaseDeductCostItem> getNameList = new ArrayList<PurchaseDeductCostItem>();
                        getNameList.add((PurchaseDeductCostItem)((Object)p));
                        return getNameList;
                    }, (value1, value2) -> {
                        value1.addAll(value2);
                        return value1;
                    }));
                    for (PurchaseDeductCost head : deductCostDataByIntegraSerach) {
                        PurchaseDeductCostVO headVO = new PurchaseDeductCostVO();
                        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
                        if (collectItem.containsKey(head.getId())) {
                            headVO.setDeductCostItemList(collectItem.get(head.getId()));
                        }
                        orderHeadVOS.add(headVO);
                    }
                    return this.dictAspectVO(Result.ok(orderHeadVOS));
                }
                case "addCost": {
                    ArrayList<PurchaseAddCostVO> deliveryHeadVOS = new ArrayList<PurchaseAddCostVO>();
                    List<PurchaseAddCost> addCostDataByIntegraSerach = this.getAddCostDataByIntegraSerach(integratedSerachConditionDTO);
                    if (CollectionUtils.isEmpty(addCostDataByIntegraSerach)) break;
                    List collect = addCostDataByIntegraSerach.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
                    List list = ((LambdaQueryChainWrapper)this.purchaseAddCostItemService.lambdaQuery().in(PurchaseAddCostItem::getHeadId, collect)).list();
                    Map<String, List> collectItem = list.stream().collect(Collectors.toMap(PurchaseAddCostItem::getHeadId, p -> {
                        ArrayList<PurchaseAddCostItem> getNameList = new ArrayList<PurchaseAddCostItem>();
                        getNameList.add((PurchaseAddCostItem)((Object)p));
                        return getNameList;
                    }, (value1, value2) -> {
                        value1.addAll(value2);
                        return value1;
                    }));
                    for (PurchaseAddCost head : addCostDataByIntegraSerach) {
                        PurchaseAddCostVO headVO = new PurchaseAddCostVO();
                        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
                        if (collectItem.containsKey(head.getId())) {
                            headVO.setAddCostItemList(collectItem.get(head.getId()));
                        }
                        deliveryHeadVOS.add(headVO);
                    }
                    return this.dictAspectVO(Result.ok(deliveryHeadVOS));
                }
                case "paymentApply": {
                    ArrayList<PurchasePaymentApplyHeadVO> enquiryHeadVOS = new ArrayList<PurchasePaymentApplyHeadVO>();
                    List<PurchasePaymentApplyHead> paymentApplyDataByIntegraSerach = this.getPaymentApplyDataByIntegraSerach(integratedSerachConditionDTO);
                    if (CollectionUtils.isEmpty(paymentApplyDataByIntegraSerach)) break;
                    List collect = paymentApplyDataByIntegraSerach.stream().map(BaseEntity::getId).distinct().collect(Collectors.toList());
                    List list = ((LambdaQueryChainWrapper)this.purchasePaymentApplyItemService.lambdaQuery().in(PurchasePaymentApplyItem::getHeadId, collect)).list();
                    Map<String, List> collectItem = list.stream().collect(Collectors.toMap(PurchasePaymentApplyItem::getHeadId, p -> {
                        ArrayList<PurchasePaymentApplyItem> getNameList = new ArrayList<PurchasePaymentApplyItem>();
                        getNameList.add((PurchasePaymentApplyItem)((Object)p));
                        return getNameList;
                    }, (value1, value2) -> {
                        value1.addAll(value2);
                        return value1;
                    }));
                    for (PurchasePaymentApplyHead head : paymentApplyDataByIntegraSerach) {
                        PurchasePaymentApplyHeadVO headVO = new PurchasePaymentApplyHeadVO();
                        BeanUtils.copyProperties((Object)((Object)head), (Object)((Object)headVO));
                        if (collectItem.containsKey(head.getId())) {
                            headVO.setPaymentApplyItemList(collectItem.get(head.getId()));
                        }
                        enquiryHeadVOS.add(headVO);
                    }
                    return this.dictAspectVO(Result.ok(enquiryHeadVOS));
                }
            }
        }
        return new JSONArray();
    }

    private JSONArray dictAspectVO(Result<?> result) {
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText(result);
        JSONArray jsonArray = JSONArray.parseArray((String)JSON.toJSONString((Object)result.getResult()));
        return jsonArray;
    }

    private List<PurchasePaymentApplyHead> getPaymentApplyDataByIntegraSerach(IntegratedSerachConditionDTO integratedSerachConditionDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)integratedSerachConditionDTO.getBusinessTypeNumber())) {
            queryWrapper.lambda().like(PurchasePaymentApplyHead::getPaymentApplyNumber, (Object)integratedSerachConditionDTO.getBusinessTypeNumber());
        }
        if (StringUtils.isNotBlank((CharSequence)integratedSerachConditionDTO.getIntegratedId())) {
            queryWrapper.lambda().like(PurchasePaymentApplyHead::getDocumentId, (Object)integratedSerachConditionDTO.getIntegratedId());
        }
        if (!CollectionUtils.isEmpty((Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds())) {
            queryWrapper.and(p -> IntegrateInvokeFinaceDataServiceImpl.createQW(p, integratedSerachConditionDTO.getBusinessTypeIntegrateIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds())) {
            queryWrapper.lambda().in(BaseEntity::getId, (Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds());
        }
        if (integratedSerachConditionDTO.getBeginDate() != null) {
            queryWrapper.lambda().ge(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getBeginDate());
        }
        if (integratedSerachConditionDTO.getEndDate() != null) {
            queryWrapper.lambda().le(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getEndDate());
        }
        return this.purchasePaymentApplyHeadService.list((Wrapper)queryWrapper);
    }

    public static <T> void createQW(QueryWrapper<T> qw, List<String> collect) {
        int index = 0;
        for (String s : collect) {
            if (index == 0) {
                qw.nested(qw1 -> qw1.like((Object)"document_id", (Object)s));
                ++index;
                continue;
            }
            qw.or(qw1 -> qw1.eq((Object)"document_id", (Object)s));
        }
    }

    private List<PurchaseReconciliation> getReconciliationDataByIntegraSerach(IntegratedSerachConditionDTO integratedSerachConditionDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)integratedSerachConditionDTO.getBusinessTypeNumber())) {
            queryWrapper.lambda().like(PurchaseReconciliation::getReconciliationNumber, (Object)integratedSerachConditionDTO.getBusinessTypeNumber());
        }
        if (StringUtils.isNotBlank((CharSequence)integratedSerachConditionDTO.getIntegratedId())) {
            queryWrapper.lambda().like(PurchaseReconciliation::getDocumentId, (Object)integratedSerachConditionDTO.getIntegratedId());
        }
        if (!CollectionUtils.isEmpty((Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds())) {
            queryWrapper.and(p -> IntegrateInvokeFinaceDataServiceImpl.createQW(p, integratedSerachConditionDTO.getBusinessTypeIntegrateIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds())) {
            queryWrapper.lambda().in(BaseEntity::getId, (Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds());
        }
        if (integratedSerachConditionDTO.getBeginDate() != null) {
            queryWrapper.lambda().ge(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getBeginDate());
        }
        if (integratedSerachConditionDTO.getEndDate() != null) {
            queryWrapper.lambda().le(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getEndDate());
        }
        return this.purchaseReconciliationService.list((Wrapper)queryWrapper);
    }

    private List<PurchasePerformanceReconciliation> getPerformanceReconciliationDataByIntegraSerach(IntegratedSerachConditionDTO integratedSerachConditionDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)integratedSerachConditionDTO.getBusinessTypeNumber())) {
            queryWrapper.lambda().like(PurchasePerformanceReconciliation::getReconciliationNumber, (Object)integratedSerachConditionDTO.getBusinessTypeNumber());
        }
        if (StringUtils.isNotBlank((CharSequence)integratedSerachConditionDTO.getIntegratedId())) {
            queryWrapper.lambda().like(PurchasePerformanceReconciliation::getDocumentId, (Object)integratedSerachConditionDTO.getIntegratedId());
        }
        if (!CollectionUtils.isEmpty((Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds())) {
            queryWrapper.and(p -> IntegrateInvokeFinaceDataServiceImpl.createQW(p, integratedSerachConditionDTO.getBusinessTypeIntegrateIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds())) {
            queryWrapper.lambda().in(BaseEntity::getId, (Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds());
        }
        if (integratedSerachConditionDTO.getBeginDate() != null) {
            queryWrapper.lambda().ge(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getBeginDate());
        }
        if (integratedSerachConditionDTO.getEndDate() != null) {
            queryWrapper.lambda().le(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getEndDate());
        }
        return this.purchasePerformanceReconciliationService.list((Wrapper)queryWrapper);
    }

    private List<PurchaseInvoice> getInvoiceDataByIntegraSerach(IntegratedSerachConditionDTO integratedSerachConditionDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)integratedSerachConditionDTO.getBusinessTypeNumber())) {
            queryWrapper.lambda().like(PurchaseInvoice::getInvoiceNumber, (Object)integratedSerachConditionDTO.getBusinessTypeNumber());
        }
        if (StringUtils.isNotBlank((CharSequence)integratedSerachConditionDTO.getIntegratedId())) {
            queryWrapper.lambda().like(PurchaseInvoice::getDocumentId, (Object)integratedSerachConditionDTO.getIntegratedId());
        }
        if (!CollectionUtils.isEmpty((Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds())) {
            queryWrapper.and(p -> IntegrateInvokeFinaceDataServiceImpl.createQW(p, integratedSerachConditionDTO.getBusinessTypeIntegrateIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds())) {
            queryWrapper.lambda().in(BaseEntity::getId, (Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds());
        }
        if (integratedSerachConditionDTO.getBeginDate() != null) {
            queryWrapper.lambda().ge(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getBeginDate());
        }
        if (integratedSerachConditionDTO.getEndDate() != null) {
            queryWrapper.lambda().le(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getEndDate());
        }
        return this.purchaseInvoiceService.list((Wrapper)queryWrapper);
    }

    private List<PurchaseDeductCost> getDeductCostDataByIntegraSerach(IntegratedSerachConditionDTO integratedSerachConditionDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)integratedSerachConditionDTO.getBusinessTypeNumber())) {
            queryWrapper.lambda().like(PurchaseDeductCost::getDeductNumber, (Object)integratedSerachConditionDTO.getBusinessTypeNumber());
        }
        if (StringUtils.isNotBlank((CharSequence)integratedSerachConditionDTO.getIntegratedId())) {
            queryWrapper.lambda().like(PurchaseDeductCost::getDocumentId, (Object)integratedSerachConditionDTO.getIntegratedId());
        }
        if (!CollectionUtils.isEmpty((Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds())) {
            queryWrapper.and(p -> IntegrateInvokeFinaceDataServiceImpl.createQW(p, integratedSerachConditionDTO.getBusinessTypeIntegrateIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds())) {
            queryWrapper.lambda().in(BaseEntity::getId, (Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds());
        }
        if (integratedSerachConditionDTO.getBeginDate() != null) {
            queryWrapper.lambda().ge(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getBeginDate());
        }
        if (integratedSerachConditionDTO.getEndDate() != null) {
            queryWrapper.lambda().le(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getEndDate());
        }
        return this.purchaseDeductCostService.list((Wrapper)queryWrapper);
    }

    private List<PurchaseAddCost> getAddCostDataByIntegraSerach(IntegratedSerachConditionDTO integratedSerachConditionDTO) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)integratedSerachConditionDTO.getBusinessTypeNumber())) {
            queryWrapper.lambda().like(PurchaseAddCost::getCostNumber, (Object)integratedSerachConditionDTO.getBusinessTypeNumber());
        }
        if (StringUtils.isNotBlank((CharSequence)integratedSerachConditionDTO.getIntegratedId())) {
            queryWrapper.lambda().like(PurchaseAddCost::getDocumentId, (Object)integratedSerachConditionDTO.getIntegratedId());
        }
        if (!CollectionUtils.isEmpty((Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds())) {
            queryWrapper.and(p -> IntegrateInvokeFinaceDataServiceImpl.createQW(p, integratedSerachConditionDTO.getBusinessTypeIntegrateIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds())) {
            queryWrapper.lambda().in(BaseEntity::getId, (Collection)integratedSerachConditionDTO.getBusinessTypeIntegrateIds());
        }
        if (integratedSerachConditionDTO.getBeginDate() != null) {
            queryWrapper.lambda().ge(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getBeginDate());
        }
        if (integratedSerachConditionDTO.getEndDate() != null) {
            queryWrapper.lambda().le(BaseEntity::getCreateTime, (Object)integratedSerachConditionDTO.getEndDate());
        }
        return this.purchaseAddCostService.list((Wrapper)queryWrapper);
    }
}

