/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.service.PurchaseInvoiceService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u53d1\u7968\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/reconciliation/purchaseInvoice"})
public class PurchaseInvoiceController
extends BaseController<PurchaseInvoice, PurchaseInvoiceService> {
    @Autowired
    private PurchaseInvoiceService purchaseInvoiceService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @AutoLog(value="\u53d1\u7968\u7ba1\u7406-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"finance#purchaseInvoice:list"})
    @PermissionDataView(businessType="invoice")
    public Result<?> queryPageList(PurchaseInvoice purchaseInvoice, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseInvoice), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseInvoiceService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"finance#purchaseInvoice:list"})
    @PermissionDataView(businessType="invoice")
    public Result<?> queryTabsCount(PurchaseInvoice purchaseInvoice, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseInvoice), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"status");
        List list = ((PurchaseInvoiceService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchaseInvoice::getStatus, PurchaseInvoice::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "confirmStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmInvoiceStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "status", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @SrmValidated
    @AutoLog(value="\u53d1\u7968\u7ba1\u7406-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"finance#purchaseInvoice:add"})
    public Result<?> add(@RequestBody PurchaseInvoice purchaseInvoice) {
        this.purchaseInvoiceService.savePurchaseInvoice(purchaseInvoice);
        return Result.ok((Object)((Object)purchaseInvoice));
    }

    @SrmValidated
    @AutoLog(value="\u53d1\u7968\u7ba1\u7406-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"finance#purchaseInvoice:edit"})
    public Result<?> edit(@RequestBody PurchaseInvoice purchaseInvoice) {
        this.purchaseInvoiceService.updatePurchaseInvoice(purchaseInvoice);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u53d1\u7968\u7ba1\u7406-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"finance#purchaseInvoice:view"})
    @BusinessModule(module="invoice")
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchaseInvoice purchaseInvoice = (PurchaseInvoice)((Object)this.purchaseInvoiceService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)purchaseInvoice));
    }

    @ApiOperation(value="SRM\u63a8\u9001\u53d1\u7968\u5230ERP", notes="SRM\u63a8\u9001\u53d1\u7968\u5230ERP")
    @GetMapping(value={"/pushInvoiceData"})
    @RequiresPermissions(value={"finance#purchaseInvoice:pushInvoiceData"})
    public Result<?> pushInvoiceData(@RequestParam(value="ids") String ids) {
        this.purchaseInvoiceService.pushInvoiceData(ids);
        return Result.ok();
    }
}

