/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.reconciliation.entity.SaleInvoice;
import com.els.modules.reconciliation.entity.SalePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.entity.SaleRecAcceptReturn;
import com.els.modules.reconciliation.entity.SaleRecAdditionalCharges;
import com.els.modules.reconciliation.entity.SaleRecCharge;
import com.els.modules.reconciliation.entity.SaleReconciliation;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffService;
import com.els.modules.reconciliation.service.SaleInvoiceService;
import com.els.modules.reconciliation.service.SalePrePaymentWriteOffReconciliationService;
import com.els.modules.reconciliation.service.SaleRecAcceptReturnService;
import com.els.modules.reconciliation.service.SaleRecAdditionalChargesService;
import com.els.modules.reconciliation.service.SaleRecChargeService;
import com.els.modules.reconciliation.service.SaleReconciliationService;
import com.els.modules.reconciliation.vo.SaleReconciliationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/reconciliation/saleReconciliation"})
@Api(tags={"\u9500\u552e\u5e93\u5b58\u5bf9\u8d26\u7ba1\u7406"})
public class SaleReconciliationController
extends BaseController<SaleReconciliation, SaleReconciliationService> {
    @Autowired
    private SaleReconciliationService saleReconciliationService;
    @Autowired
    private SaleRecAcceptReturnService saleRecAcceptReturnService;
    @Autowired
    private SaleRecAdditionalChargesService saleRecAdditionalChargesService;
    @Autowired
    private SaleRecChargeService saleRecChargeService;
    @Autowired
    private SaleInvoiceService saleInvoiceService;
    @Autowired
    private SalePrePaymentWriteOffReconciliationService salePrePaymentWriteOffReconciliationService;
    @Autowired
    private ElsPurchaseStatisticsWriteOffService elsPurchaseStatisticsWriteOffService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String LOCK_KEY = "srm_saleReconciliation_";
    private static final Long LOCK_EXPIRE_TIME = 30000L;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"reconciliation#saleReconciliation:list"})
    public Result<?> queryPageList(SaleReconciliation saleReconciliation, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleReconciliation), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.saleReconciliationService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(value="\u9500\u552e\u5bf9\u8d26\u5934-\u6dfb\u52a0", logType=2)
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"reconciliation#saleReconciliation:add"})
    @FormCommit
    public Result<?> add(@RequestBody SaleReconciliationVO vo) {
        SaleReconciliation saleReconciliation = new SaleReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)saleReconciliation));
        this.saleReconciliationService.saveMain(saleReconciliation, vo);
        return Result.ok((Object)((Object)saleReconciliation));
    }

    @SrmValidated
    @AutoLog(value="\u9500\u552e\u5bf9\u8d26\u5934-\u7f16\u8f91", logType=2)
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"reconciliation#saleReconciliation:edit"})
    public Result<?> edit(@RequestBody SaleReconciliationVO vo) {
        SaleReconciliation saleReconciliation = new SaleReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)saleReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.saleReconciliationService.updateMain(saleReconciliation, vo);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        String id = saleReconciliation.getId();
        return this.queryById(id);
    }

    @AutoLog(value="\u9500\u552e\u5bf9\u8d26\u5934-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"reconciliation#saleReconciliation:delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.saleReconciliationService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"reconciliation#saleReconciliation:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        SaleReconciliation saleReconciliation = (SaleReconciliation)((Object)this.saleReconciliationService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        SaleReconciliationVO saleReconciliationVO = new SaleReconciliationVO();
        BeanUtils.copyProperties((Object)((Object)saleReconciliation), (Object)((Object)saleReconciliationVO));
        saleReconciliationVO.setRecAcceptReturnList(this.saleRecAcceptReturnService.selectByMainId(id));
        saleReconciliationVO.setRecAdditionalChargesList(this.saleRecAdditionalChargesService.selectByMainId(id));
        saleReconciliationVO.setRecChargeList(this.saleRecChargeService.selectByMainId(id));
        saleReconciliationVO.setInvoiceList(this.saleInvoiceService.selectByMainId(id));
        saleReconciliationVO.setAttachments(this.invokeBaseRpcService.selectSaleAttachmentByMainId(id));
        List<SalePrePaymentWriteOffReconciliation> prePaymentWriteOffList = this.salePrePaymentWriteOffReconciliationService.selectByMainId(id);
        this.elsPurchaseStatisticsWriteOffService.handleSalePrePaymentWriteOffList(prePaymentWriteOffList);
        saleReconciliationVO.setPrePaymentWriteOffList(prePaymentWriteOffList);
        return Result.ok((Object)((Object)saleReconciliationVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u9500\u552e\u5bf9\u8d26\u5934id\u67e5\u8be2\u9500\u552e\u6536\u9000\u8d27\u660e\u7ec6", notes="\u901a\u8fc7\u9500\u552e\u5bf9\u8d26\u5934id\u67e5\u8be2\u9500\u552e\u6536\u9000\u8d27\u660e\u7ec6")
    @RequiresPermissions(value={"reconciliation#saleReconciliation:view"})
    public Result<?> querySaleRecAcceptReturnListByMainId(@RequestParam(name="id", required=true) String id) {
        List<SaleRecAcceptReturn> saleRecAcceptReturnList = this.saleRecAcceptReturnService.selectByMainId(id);
        return Result.ok(saleRecAcceptReturnList);
    }

    @ApiOperation(value="\u901a\u8fc7\u9500\u552e\u5bf9\u8d26\u5934id\u67e5\u8be2\u9500\u552e\u9644\u52a0\u8d39\u7528\u660e\u7ec6", notes="\u901a\u8fc7\u9500\u552e\u5bf9\u8d26\u5934id\u67e5\u8be2\u9500\u552e\u9644\u52a0\u8d39\u7528\u660e\u7ec6")
    @GetMapping(value={"/querySaleRecAdditionalChargesByMainId"})
    @RequiresPermissions(value={"reconciliation#saleReconciliation:view"})
    public Result<?> querySaleRecAdditionalChargesListByMainId(@RequestParam(name="id", required=true) String id) {
        List<SaleRecAdditionalCharges> saleRecAdditionalChargesList = this.saleRecAdditionalChargesService.selectByMainId(id);
        return Result.ok(saleRecAdditionalChargesList);
    }

    @ApiOperation(value="\u901a\u8fc7\u9500\u552e\u5bf9\u8d26\u5934id\u67e5\u8be2\u9500\u552e\u6263\u6b3e\u660e\u7ec6", notes="\u901a\u8fc7\u9500\u552e\u5bf9\u8d26\u5934id\u67e5\u8be2\u9500\u552e\u6263\u6b3e\u660e\u7ec6")
    @GetMapping(value={"/querySaleRecChargeByMainId"})
    @RequiresPermissions(value={"reconciliation#saleReconciliation:view"})
    public Result<?> querySaleRecChargeListByMainId(@RequestParam(name="id", required=true) String id) {
        List<SaleRecCharge> saleRecChargeList = this.saleRecChargeService.selectByMainId(id);
        return Result.ok(saleRecChargeList);
    }

    @ApiOperation(value="\u901a\u8fc7\u9500\u552e\u5bf9\u8d26\u5934id\u67e5\u8be2\u9500\u552e\u53d1\u7968", notes="\u901a\u8fc7\u9500\u552e\u5bf9\u8d26\u5934id\u67e5\u8be2\u9500\u552e\u53d1\u7968")
    @GetMapping(value={"/querySaleInvoiceByMainId"})
    @RequiresPermissions(value={"reconciliation#saleReconciliation:view"})
    public Result<?> querySaleInvoiceListByMainId(@RequestParam(name="id", required=true) String id) {
        List<SaleInvoice> saleInvoiceList = this.saleInvoiceService.selectByMainId(id);
        return Result.ok(saleInvoiceList);
    }

    @SrmValidated
    @AutoLog(value="\u9500\u552e\u5bf9\u8d26\u5934-\u9500\u552e\u786e\u8ba4")
    @ApiOperation(value="\u9500\u552e\u786e\u8ba4", notes="\u9500\u552e\u786e\u8ba4")
    @PostMapping(value={"/confirm"})
    @RequiresPermissions(value={"reconciliation#saleReconciliation:confirm"})
    public Result<?> confirm(@RequestBody SaleReconciliationVO vo) {
        SaleReconciliation saleReconciliation = new SaleReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)saleReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.saleReconciliationService.confirmOrRefused(saleReconciliation, "confirm");
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return this.commonSuccessResult(4);
    }

    @SrmValidated
    @AutoLog(value="\u9500\u552e\u5bf9\u8d26\u5934-\u53d1\u7968\u4fdd\u5b58", logType=2)
    @ApiOperation(value="\u53d1\u7968\u4fdd\u5b58", notes="\u53d1\u7968\u4fdd\u5b58")
    @PostMapping(value={"/saveInvoice"})
    @RequiresPermissions(value={"reconciliation#saleReconciliation:saveInvoice"})
    public Result<?> saveInvoice(@RequestBody SaleReconciliationVO vo) {
        SaleReconciliation saleReconciliation = new SaleReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)saleReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.saleReconciliationService.saveInvoice(saleReconciliation, vo.getInvoiceList(), "save");
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return Result.ok((Object)((Object)saleReconciliation));
    }

    @SrmValidated
    @AutoLog(value="\u9500\u552e\u5bf9\u8d26\u5934-\u53d1\u7968\u53d1\u9001", logType=2)
    @ApiOperation(value="\u53d1\u7968\u53d1\u9001", notes="\u53d1\u7968\u53d1\u9001")
    @PostMapping(value={"/sendInvoice"})
    @RequiresPermissions(value={"reconciliation#saleReconciliation:sendInvoice"})
    public Result<?> sendInvoice(@RequestBody SaleReconciliationVO vo) {
        SaleReconciliation saleReconciliation = new SaleReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)saleReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.saleReconciliationService.sendInvoice(saleReconciliation, vo.getInvoiceList());
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return Result.ok((Object)((Object)saleReconciliation));
    }

    @SrmValidated
    @AutoLog(value="\u9500\u552e\u5bf9\u8d26\u5934-\u9500\u552e\u62d2\u7edd")
    @ApiOperation(value="\u9500\u552e\u62d2\u7edd", notes="\u9500\u552e\u62d2\u7edd")
    @PostMapping(value={"/refuesd"})
    @RequiresPermissions(value={"reconciliation#saleReconciliation:refuesd"})
    public Result<?> refuesd(@RequestBody SaleReconciliationVO vo) {
        SaleReconciliation saleReconciliation = new SaleReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)saleReconciliation));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.saleReconciliationService.confirmOrRefused(saleReconciliation, "refused");
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u9500\u552e\u5bf9\u8d26\u5934-\u90ae\u4ef6\u786e\u8ba4/\u62d2\u7edd")
    @ApiOperation(value="\u9500\u552e\u786e\u8ba4/\u62d2\u7edd", notes="\u9500\u552e\u786e\u8ba4/\u62d2\u7edd")
    @GetMapping(value={"/emailConfirmOrRefuesd"})
    @RequiresPermissions(value={"reconciliation#saleReconciliation:emailConfirmOrRefuesd"})
    public Result<?> emailConfirmOrRefuesd(@RequestParam(name="operation") String operation, @RequestParam(name="id") String id) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, id, LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.saleReconciliationService.emailConfirmOrRefuesd(id, operation);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, id);
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u9500\u552e\u5bf9\u8d26-\u63d0\u53d6\u5bf9\u8d26\u5355", logType=2)
    @ApiOperation(value="\u63d0\u53d6\u5bf9\u8d26\u5355", notes="\u63d0\u53d6\u5bf9\u8d26\u5355")
    @PostMapping(value={"/extractReconciliation"})
    @RequiresPermissions(value={"reconciliation#saleReconciliation:extractReconciliation"})
    public Result<?> extractReconciliation(@RequestBody SaleReconciliationVO vo) {
        return Result.ok((Object)((Object)this.saleReconciliationService.extractReconciliation(vo)));
    }

    @SrmValidated
    @AutoLog(value="\u5bf9\u8d26\u5934-\u53d1\u5e03", logType=2)
    @ApiOperation(value="\u53d1\u5e03", notes="\u53d1\u5e03")
    @PostMapping(value={"/publish"})
    @RequiresPermissions(value={"reconciliation#saleReconciliation:publish"})
    public Result<?> publish(@RequestBody SaleReconciliationVO vo) {
        Result result = new Result();
        SaleReconciliation saleReconciliation = new SaleReconciliation();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)((Object)saleReconciliation));
        if (!this.redisUtil.tryGetDistributedLock("supplier_reconciliation_", vo.getElsAccount(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_AvjDiKUmRdXIeVRSsK_72c19add", (String)"\u5176\u4ed6\u7528\u6237\u6b63\u5728\u4e0e\u6b64\u4f9b\u5e94\u5546\u5bf9\u8d26\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01"));
        }
        try {
            result = this.saleReconciliationService.publish(saleReconciliation, vo);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock("supplier_reconciliation_", vo.getElsAccount());
        }
        return result;
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"reconciliation#saleReconciliation:list"})
    public Result<?> counts(SaleReconciliation saleReconciliation, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)saleReconciliation), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"status", "count(0) as participate_quantity"});
        queryWrapper.groupBy((Object)"status");
        List list = ((SaleReconciliationService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(SaleReconciliation::getStatus, SaleReconciliation::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "status", null, all));
        List srmReconciliationStatus = this.invokeBaseRpcService.queryDictItemsByCode("reconciliationBillStatus", TenantContext.getTenant());
        for (DictDTO status : srmReconciliationStatus) {
            Integer total = countMap.get(status.getValue()) == null ? 0 : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "status", status.getValue(), total));
        }
        return Result.ok(result);
    }

    @ApiOperation(value="\u76f4\u8fde\u5f00\u7968", notes="\u76f4\u8fde\u5f00\u7968")
    @PostMapping(value={"/billing"})
    public Result<?> billing(@RequestBody SaleReconciliationVO vo) {
        Result result = new Result();
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, vo.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APIetiKRcsSTVBtk_83409e9b", (String)"\u5f53\u524d\u5bf9\u8d26\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            result = this.saleReconciliationService.billing(vo);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, vo.getId());
        }
        return result;
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryReconciliationItemList"})
    public Result<?> queryReconciliationItemList(SaleReconciliation saleReconciliation) {
        SaleReconciliationVO vo = this.saleReconciliationService.queryReconciliationItemList(saleReconciliation, saleReconciliation.getId());
        return Result.ok((Object)((Object)vo));
    }
}

