/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.job;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.service.JobRpcService;
import com.els.common.exception.ELSBootException;
import com.els.common.util.Assert;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.confirm.rpc.InvokeDictInfoRpcService;
import com.els.modules.finance.api.dto.ElsFinanceReconciliationConfigDTO;
import com.els.modules.rebate.rpc.SupplierLocalRpcService;
import com.els.modules.reconciliation.entity.PurchaseRecAcceptReturn;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.rpc.ElsReconciliationConfigRpcService;
import com.els.modules.reconciliation.service.PurchaseReconciliationService;
import com.els.modules.reconciliation.utils.NatureCycleDateUtils;
import com.els.modules.reconciliation.vo.PurchaseReconciliationVO;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BatchCreateReconciliationJob
implements JobRpcService {
    private static final Logger log = LoggerFactory.getLogger(BatchCreateReconciliationJob.class);
    private final String LOCK_PREFIX = "schedule_BatchCreateReconciliationJob";
    private final long EXPIRE_TIME = 50000L;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private PurchaseReconciliationService purchaseReconciliationService;
    @Resource
    private ElsReconciliationConfigRpcService reconciliationConfigRpcService;
    @Resource
    private TemplateRpcService templateRpcService;
    @Resource
    private SupplierLocalRpcService supplierLocalRpcService;
    @Resource
    private InvokeDictInfoRpcService invokeDictInfoRpcService;

    public void execute(String parameter) {
        String elsAccount;
        JSONObject object = JSONObject.parseObject((String)parameter);
        String string = elsAccount = StringUtils.isBlank((CharSequence)object.getString("elsAccount")) ? "100000" : object.getString("elsAccount");
        if (!this.redisUtil.tryGetDistributedLock("schedule_BatchCreateReconciliationJob", elsAccount, 50000L)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_zRcIIetLSiKRcVxPVBRc_2080a4a7", (String)"\u6279\u91cf\u521b\u5efa\u5bf9\u8d26\u5355\u4efb\u52a1\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u4e0d\u8981\u91cd\u590d\u6267\u884c"));
        }
        try {
            TenantContext.setTenant((String)elsAccount);
            log.info(":::BatchCreateReconciliationJob start");
            ArrayList<PurchaseReconciliationVO> reconciliationVOList = new ArrayList<PurchaseReconciliationVO>();
            ElsFinanceReconciliationConfigDTO reconciliationConfig = this.reconciliationConfigRpcService.getDefaultReconciliationConfig(elsAccount, "reconciliation");
            Assert.isNotNull((Object)reconciliationConfig, (String)I18nUtil.translate((String)"i18n_field_ERLVVWERbLiN_89125164", (String)"\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u5148\u914d\u7f6e\u751f\u6210\u7b56\u7565\uff01"));
            log.info("BatchCreateReconciliationJob getReconciliationConfig: {} ", (Object)JSON.toJSONString((Object)reconciliationConfig));
            this.fillConfigData(reconciliationVOList, reconciliationConfig, elsAccount);
            this.fillTemplateData(reconciliationVOList, reconciliationConfig);
            log.info("BatchCreateReconciliationJob data: {} ", (Object)JSON.toJSONString(reconciliationVOList));
            for (PurchaseReconciliationVO reconciliationVO : reconciliationVOList) {
                this.createPurchaseReconciliation(reconciliationVO);
            }
            log.info(":::BatchCreateReconciliationJob end");
        }
        catch (Exception e) {
            log.error(Thread.currentThread().getName() + "\u6279\u91cf\u521b\u5efa\u5bf9\u8d26\u5355\u51fa\u73b0\u5f02\u5e38:", (Throwable)e);
            throw e;
        }
        finally {
            this.redisUtil.releaseDistributedLock("schedule_BatchCreateReconciliationJob", elsAccount);
        }
    }

    private void fillConfigData(List<PurchaseReconciliationVO> reconciliationVOList, ElsFinanceReconciliationConfigDTO reconciliationConfig, String elsAccount) {
        String natureCycle = reconciliationConfig.getNatureCycle();
        int beginCycle = Integer.parseInt(reconciliationConfig.getBeginCycle());
        int endCycle = Integer.parseInt(reconciliationConfig.getEndCycle());
        Map<String, Date> beginDateWithEndDate = NatureCycleDateUtils.getBeginDateWithEndDate(natureCycle, beginCycle, endCycle);
        List<Map<String, Date>> eachWeekDateOfCurrYear = NatureCycleDateUtils.getEachWeekDateOfCurrYear(natureCycle, beginCycle, endCycle);
        List<String> accountGroupList = Arrays.asList(reconciliationConfig.getAccountGroup().split(","));
        List<SupplierMasterDataDTO> supplierMasterDataDTOList = this.supplierLocalRpcService.getSupplierMasterDataByAccountGroup(elsAccount, accountGroupList);
        Assert.isNotEmpty(supplierMasterDataDTOList, (String)I18nUtil.translate((String)"i18n_field_xMKBnRdXeDVjRdX_730ad793", (String)"\u4e0d\u5b58\u5728\u7b26\u5408\u4f9b\u5e94\u5546\u8d26\u6237\u7ec4\u7684\u4f9b\u5e94\u5546\uff01"));
        List<DictDTO> companyCodeList = this.invokeDictInfoRpcService.queryDictItemsByCode("purchase_organization_info#org_name#org_code#org_category_code=\"companyCode\" && status=\"1\"", elsAccount);
        if (CollectionUtils.isEmpty(eachWeekDateOfCurrYear)) {
            for (SupplierMasterDataDTO dto : supplierMasterDataDTOList) {
                for (DictDTO companyDTO : companyCodeList) {
                    this.setObjSameProperty(reconciliationVOList, beginDateWithEndDate, elsAccount, dto, companyDTO);
                }
            }
        } else {
            for (SupplierMasterDataDTO dto : supplierMasterDataDTOList) {
                for (DictDTO companyDTO : companyCodeList) {
                    for (Map<String, Date> map : eachWeekDateOfCurrYear) {
                        this.setObjSameProperty(reconciliationVOList, map, elsAccount, dto, companyDTO);
                    }
                }
            }
        }
        log.info("BatchCreateReconciliationJob fillConfigData end {} ", (Object)JSON.toJSONString(reconciliationVOList));
    }

    private void setObjSameProperty(List<PurchaseReconciliationVO> reconciliationVOList, Map<String, Date> beginDateWithEndDate, String elsAccount, SupplierMasterDataDTO dto, DictDTO companyDTO) {
        PurchaseReconciliationVO inventoryVO = new PurchaseReconciliationVO();
        inventoryVO.setElsAccount(elsAccount);
        inventoryVO.setToElsAccount(dto.getToElsAccount());
        inventoryVO.setSupplierCode(dto.getToElsAccount());
        inventoryVO.setSupplierName(dto.getSupplierName());
        inventoryVO.setBeginDate(beginDateWithEndDate.get("beginDate"));
        inventoryVO.setEndDate(beginDateWithEndDate.get("endDate"));
        inventoryVO.setCompany(companyDTO.getValue());
        inventoryVO.setCurrency(dto.getLocalCurrency());
        reconciliationVOList.add(inventoryVO);
    }

    private void fillTemplateData(List<PurchaseReconciliationVO> reconciliationVOList, ElsFinanceReconciliationConfigDTO reconciliationConfig) {
        TemplateHeadDTO templateHeadDTO = this.templateRpcService.getById(reconciliationConfig.getRelatedTemplateId());
        if (templateHeadDTO == null) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_ESIrxMKVImESIr_d0741654", (String)"\u4e1a\u52a1\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\u4e1a\u52a1\u6a21\u677f\uff01"));
        }
        for (PurchaseReconciliationVO vo : reconciliationVOList) {
            vo.setTemplateAccount(templateHeadDTO.getElsAccount());
            vo.setTemplateNumber(templateHeadDTO.getTemplateNumber());
            vo.setTemplateName(templateHeadDTO.getTemplateName());
            vo.setTemplateVersion(String.valueOf(templateHeadDTO.getTemplateVersion()));
        }
    }

    private void createPurchaseReconciliation(PurchaseReconciliationVO vo) {
        log.info("BatchCreateReconciliationJob \u63d0\u53d6\u5355\u636e: {} ", (Object)JSON.toJSONString((Object)((Object)vo)));
        PurchaseReconciliationVO extractReconciliation = this.purchaseReconciliationService.extractReconciliation(vo);
        List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList = extractReconciliation.getRecAcceptReturnList();
        if (CollectionUtils.isEmpty(purchaseRecAcceptReturnList)) {
            return;
        }
        PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
        BeanUtils.copyProperties((Object)((Object)extractReconciliation), (Object)((Object)purchaseReconciliation));
        try {
            log.info("BatchCreateReconciliationJob \u521b\u5efa\u5e93\u5b58\u5bf9\u8d26: {} ", (Object)JSON.toJSONString((Object)((Object)vo)));
            this.purchaseReconciliationService.saveMain(purchaseReconciliation, extractReconciliation);
        }
        catch (Exception e) {
            log.error("\u521b\u5efa\u5e93\u5b58\u5bf9\u8d26\u5931\u8d25: {} ", (Object)e.getMessage());
        }
    }
}

