/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.open.api.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.ExcelExportClassColumnDTO;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.util.ConvertUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.OpenApiRpcService;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.PurchaseRecAcceptReturn;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.entity.SaleInvoice;
import com.els.modules.reconciliation.entity.SaleRecAcceptReturn;
import com.els.modules.reconciliation.entity.SaleReconciliation;
import com.els.modules.reconciliation.enumerate.ReconciliationBillStatusEnum;
import com.els.modules.reconciliation.service.PurchaseInvoiceService;
import com.els.modules.reconciliation.service.PurchaseRecAcceptReturnService;
import com.els.modules.reconciliation.service.PurchaseReconciliationService;
import com.els.modules.reconciliation.service.SaleInvoiceService;
import com.els.modules.reconciliation.service.SaleRecAcceptReturnService;
import com.els.modules.reconciliation.service.SaleReconciliationService;
import com.els.modules.reconciliation.vo.PurchaseReconciliationVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PurchaseReconciliationCreateFinanceCloudServiceImpl
implements OpenApiRpcService {
    private static final Logger log = LoggerFactory.getLogger(PurchaseReconciliationCreateFinanceCloudServiceImpl.class);
    @Resource
    private PurchaseReconciliationService purchaseReconciliationService;
    @Resource
    private PurchaseInvoiceService purchaseInvoiceService;
    @Resource
    private SaleReconciliationService saleReconciliationService;
    @Resource
    private SaleInvoiceService saleInvoiceService;
    @Resource
    private PurchaseRecAcceptReturnService purchaseRecAcceptReturnService;
    @Resource
    private SaleRecAcceptReturnService saleRecAcceptReturnService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @SrmTransaction(rollbackFor={RuntimeException.class})
    public JSONObject doCreateInvoke(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap) {
        log.info("receive data: {} ", (Object)JSON.toJSONString((Object)array));
        ArrayList<PurchaseReconciliation> headList = new ArrayList<PurchaseReconciliation>();
        String account = TenantContext.getTenant();
        ArrayList<PurchaseInvoice> invoices = new ArrayList<PurchaseInvoice>();
        ArrayList<PurchaseRecAcceptReturn> accepts = new ArrayList<PurchaseRecAcceptReturn>();
        for (Object obj : array) {
            JSONObject object = (JSONObject)Convert.convert(JSONObject.class, obj);
            if (object.size() == 0) continue;
            PurchaseReconciliation head = (PurchaseReconciliation)((Object)ConvertUtils.convertDefault(PurchaseReconciliation.class, (JSONObject)object, defaultHeadMap));
            head.setElsAccount(account);
            head.setCreateTime(new Date());
            head.setUpdateTime(new Date());
            head.setCreateBy(head.getCreateBy());
            head.setUpdateBy(head.getCreateBy());
            head.setDeleted(CommonConstant.DEL_FLAG_0);
            head.setTemplateName(templateHead.getTemplateName());
            head.setTemplateNumber(templateHead.getTemplateNumber());
            head.setTemplateVersion("" + templateHead.getTemplateVersion());
            head.setTemplateAccount(templateHead.getElsAccount());
            BeanUtil.copyProperties(defaultHeadMap, (Object)((Object)head), (String[])new String[0]);
            head.setId(SysUtil.getAssignId((Object)((Object)head)));
            head.setCreateAccount(account);
            head.setStatus(ReconciliationBillStatusEnum.INVOICE_CONFIRMED.getValue());
            head.setSendStatus("1");
            headList.add(head);
            this.buildAcceptReturn(defaultItemMap, accepts, object, head);
            this.buildInvoice(defaultItemMap, invoices, object, head);
        }
        ArrayList<PurchaseInvoice> allInvoiceList = new ArrayList<PurchaseInvoice>();
        ArrayList<PurchaseRecAcceptReturn> allAcceptReturnList = new ArrayList<PurchaseRecAcceptReturn>();
        Map<String, PurchaseReconciliation> existMap = this.getPurchaseReconciliationMap(headList);
        ArrayList<PurchaseReconciliation> addList = new ArrayList<PurchaseReconciliation>();
        ArrayList<PurchaseReconciliation> updateList = new ArrayList<PurchaseReconciliation>();
        ArrayList<String> deleteIds = new ArrayList<String>();
        for (PurchaseReconciliation purchaseReconciliation : headList) {
            if (StringUtils.isEmpty((Object)purchaseReconciliation.getElsAccount()) || StringUtils.isEmpty((Object)purchaseReconciliation.getSourceNumber())) continue;
            PurchaseReconciliation exist = existMap.get(purchaseReconciliation.getElsAccount() + "-" + purchaseReconciliation.getSourceNumber());
            if (exist == null) {
                addList.add(purchaseReconciliation);
                continue;
            }
            deleteIds.add(purchaseReconciliation.getId());
            purchaseReconciliation.setId(exist.getId());
            purchaseReconciliation.setReconciliationNumber(exist.getReconciliationNumber());
            updateList.add(purchaseReconciliation);
        }
        headList = addList;
        HashMap<String, String> relationMap = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(updateList)) {
            Set<String> mainIds = updateList.stream().map(BaseEntity::getId).collect(Collectors.toSet());
            this.saleReconciliationService.deleteByRelationIds(mainIds);
            ArrayList saleReconciliations = new ArrayList();
            for (PurchaseReconciliation reconciliation : updateList) {
                SaleReconciliation saleReconciliation = new SaleReconciliation();
                BeanUtil.copyProperties((Object)((Object)reconciliation), (Object)((Object)saleReconciliation), (String[])new String[0]);
                saleReconciliation.setElsAccount(reconciliation.getToElsAccount());
                saleReconciliation.setToElsAccount(reconciliation.getElsAccount());
                saleReconciliation.setBusAccount(reconciliation.getElsAccount());
                saleReconciliation.setId(IdWorker.getIdStr());
                saleReconciliation.setRelationId(reconciliation.getId());
                reconciliation.setRelationId(saleReconciliation.getId());
                relationMap.put(reconciliation.getId(), reconciliation.getRelationId());
                saleReconciliations.add(saleReconciliation);
            }
            this.purchaseReconciliationService.updateBatchById(updateList);
            this.saleReconciliationService.saveBatch(saleReconciliations);
            Map<String, PurchaseRecAcceptReturn> acceptReturnMap = this.getAcceptReturnMap(mainIds);
            List<PurchaseRecAcceptReturn> purchaseRecAcceptReturnList = this.updateAcceptReturnList(accepts, acceptReturnMap, relationMap);
            allAcceptReturnList.addAll(purchaseRecAcceptReturnList);
            Map<String, PurchaseInvoice> invoiceMap = this.getInvoiceMap(mainIds);
            List<PurchaseInvoice> updatePurchaseInvoiceList = this.updatePurchaseInvoiceList(invoices, invoiceMap, relationMap);
            allInvoiceList.addAll(updatePurchaseInvoiceList);
            ArrayList<PurchaseRecAcceptReturn> addAcceptReturnList = new ArrayList<PurchaseRecAcceptReturn>();
            for (PurchaseRecAcceptReturn accept : accepts) {
                if (deleteIds.contains(accept.getHeadId())) continue;
                addAcceptReturnList.add(accept);
            }
            accepts = addAcceptReturnList;
            ArrayList<PurchaseInvoice> addInvoiceList = new ArrayList<PurchaseInvoice>();
            for (PurchaseInvoice invoice : invoices) {
                if (deleteIds.contains(invoice.getHeadId())) continue;
                addInvoiceList.add(invoice);
            }
            invoices = addInvoiceList;
        }
        this.saveReconciliation(headList);
        HashMap<String, String> map = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(headList)) {
            for (PurchaseReconciliation reconciliation : headList) {
                map.put(reconciliation.getId(), reconciliation.getReconciliationNumber());
                relationMap.put(reconciliation.getId(), reconciliation.getRelationId());
            }
        }
        this.saveAcceptReturn(accepts, map, relationMap);
        this.saveInvoice(invoices, map, relationMap);
        ArrayList<PurchaseReconciliation> allHeadList = new ArrayList<PurchaseReconciliation>();
        allHeadList.addAll(headList);
        allHeadList.addAll(updateList);
        allInvoiceList.addAll(invoices);
        allAcceptReturnList.addAll(accepts);
        List collect = allHeadList.stream().map(x -> (PurchaseReconciliationVO)((Object)((Object)Convert.convert(PurchaseReconciliationVO.class, (Object)x)))).collect(Collectors.toList());
        Map<String, List<PurchaseInvoice>> invoiceMap = allInvoiceList.stream().collect(Collectors.groupingBy(PurchaseInvoice::getHeadId));
        Map<String, List<PurchaseRecAcceptReturn>> acceptMap = allAcceptReturnList.stream().collect(Collectors.groupingBy(PurchaseRecAcceptReturn::getHeadId));
        for (PurchaseReconciliationVO vo : collect) {
            vo.setInvoiceList(invoiceMap.get(vo.getId()));
            vo.setRecAcceptReturnList(acceptMap.get(vo.getId()));
        }
        JSONObject resultObj = new JSONObject();
        resultObj.put("headList", collect);
        log.info("response data: {} ", (Object)JSON.toJSONString(collect));
        return resultObj;
    }

    private List<PurchaseRecAcceptReturn> updateAcceptReturnList(List<PurchaseRecAcceptReturn> accepts, Map<String, PurchaseRecAcceptReturn> acceptReturnMap, Map<String, String> relationMap) {
        ArrayList<PurchaseRecAcceptReturn> updateAcceptReturnList = new ArrayList<PurchaseRecAcceptReturn>();
        if (CollectionUtils.isEmpty(accepts)) {
            return updateAcceptReturnList;
        }
        for (PurchaseRecAcceptReturn accept : accepts) {
            PurchaseRecAcceptReturn existAcceptReturn = acceptReturnMap.get(accept.getElsAccount() + "-" + accept.getOtherVoucherNumber());
            if (existAcceptReturn == null) continue;
            PurchaseRecAcceptReturn finalAccept = new PurchaseRecAcceptReturn();
            BeanUtils.copyProperties((Object)((Object)accept), (Object)((Object)finalAccept));
            finalAccept.setId(existAcceptReturn.getId());
            finalAccept.setHeadId(existAcceptReturn.getHeadId());
            updateAcceptReturnList.add(finalAccept);
        }
        if (!CollectionUtils.isEmpty(updateAcceptReturnList)) {
            Set<String> ids = updateAcceptReturnList.stream().map(BaseEntity::getId).collect(Collectors.toSet());
            this.saleRecAcceptReturnService.deleteByRelationIds(ids);
            ArrayList<SaleRecAcceptReturn> saleAccepts = new ArrayList<SaleRecAcceptReturn>();
            for (PurchaseRecAcceptReturn accept : updateAcceptReturnList) {
                SaleRecAcceptReturn saleRecAcceptReturn = new SaleRecAcceptReturn();
                BeanUtil.copyProperties((Object)((Object)accept), (Object)((Object)saleRecAcceptReturn), (String[])new String[0]);
                saleRecAcceptReturn.setId(IdWorker.getIdStr());
                saleRecAcceptReturn.setRelationId(accept.getId());
                accept.setRelationId(saleRecAcceptReturn.getId());
                saleRecAcceptReturn.setToElsAccount(accept.getElsAccount());
                saleRecAcceptReturn.setElsAccount(accept.getToElsAccount());
                saleRecAcceptReturn.setBusAccount(accept.getElsAccount());
                saleRecAcceptReturn.setHeadId(relationMap.get(accept.getHeadId()));
                saleAccepts.add(saleRecAcceptReturn);
            }
            this.purchaseRecAcceptReturnService.updateBatchById(updateAcceptReturnList);
            this.saleRecAcceptReturnService.saveBatch(saleAccepts);
        }
        return updateAcceptReturnList;
    }

    @NotNull
    private Map<String, PurchaseRecAcceptReturn> getAcceptReturnMap(Set<String> mainIds) {
        HashMap<String, PurchaseRecAcceptReturn> acceptReturnMap = new HashMap<String, PurchaseRecAcceptReturn>();
        LambdaQueryWrapper purchaseRecAcceptReturnQueryWrapper = new LambdaQueryWrapper();
        purchaseRecAcceptReturnQueryWrapper.in(PurchaseRecAcceptReturn::getHeadId, mainIds);
        List acceptReturnList = this.purchaseRecAcceptReturnService.list((Wrapper)purchaseRecAcceptReturnQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)acceptReturnList)) {
            for (PurchaseRecAcceptReturn acceptReturn : acceptReturnList) {
                acceptReturnMap.put(acceptReturn.getElsAccount() + "-" + acceptReturn.getOtherVoucherNumber(), acceptReturn);
            }
        }
        return acceptReturnMap;
    }

    private List<PurchaseInvoice> updatePurchaseInvoiceList(List<PurchaseInvoice> invoices, Map<String, PurchaseInvoice> invoiceMap, Map<String, String> relationMap) {
        ArrayList<PurchaseInvoice> updateInvoiceList = new ArrayList<PurchaseInvoice>();
        if (CollectionUtils.isEmpty(invoices)) {
            return updateInvoiceList;
        }
        for (PurchaseInvoice invoice : invoices) {
            PurchaseInvoice existInvoice;
            if (StringUtils.isEmpty((Object)invoice.getInvoiceCode()) || StringUtils.isEmpty((Object)invoice.getInvoiceNo()) || (existInvoice = invoiceMap.get(invoice.getInvoiceCode() + "-" + invoice.getInvoiceNo())) == null) continue;
            PurchaseInvoice finalInvoice = new PurchaseInvoice();
            BeanUtils.copyProperties((Object)((Object)invoice), (Object)((Object)finalInvoice));
            finalInvoice.setInvoiceNumber(existInvoice.getInvoiceNumber());
            finalInvoice.setReconciliationNumber(existInvoice.getReconciliationNumber());
            finalInvoice.setId(existInvoice.getId());
            finalInvoice.setHeadId(existInvoice.getHeadId());
            updateInvoiceList.add(finalInvoice);
        }
        if (!CollectionUtils.isEmpty(updateInvoiceList)) {
            Set<String> ids = updateInvoiceList.stream().map(BaseEntity::getId).collect(Collectors.toSet());
            this.saleInvoiceService.deleteByRelationIds(ids);
            ArrayList<SaleInvoice> saleInvoices = new ArrayList<SaleInvoice>();
            for (PurchaseInvoice invoice : updateInvoiceList) {
                SaleInvoice saleInvoice = new SaleInvoice();
                BeanUtil.copyProperties((Object)((Object)invoice), (Object)((Object)saleInvoice), (String[])new String[0]);
                saleInvoice.setId(IdWorker.getIdStr());
                saleInvoice.setRelationId(invoice.getId());
                invoice.setRelationId(saleInvoice.getId());
                saleInvoice.setToElsAccount(invoice.getElsAccount());
                saleInvoice.setElsAccount(invoice.getToElsAccount());
                saleInvoice.setBusAccount(invoice.getElsAccount());
                saleInvoice.setHeadId(relationMap.get(invoice.getHeadId()));
                saleInvoices.add(saleInvoice);
            }
            this.purchaseInvoiceService.updateBatchById(updateInvoiceList);
            this.saleInvoiceService.saveBatch(saleInvoices);
        }
        return updateInvoiceList;
    }

    @NotNull
    private Map<String, PurchaseInvoice> getInvoiceMap(Set<String> mainIds) {
        HashMap<String, PurchaseInvoice> invoiceMap = new HashMap<String, PurchaseInvoice>();
        LambdaQueryWrapper purchaseInvoiceQueryWrapper = new LambdaQueryWrapper();
        purchaseInvoiceQueryWrapper.in(PurchaseInvoice::getHeadId, mainIds);
        List invoiceList = this.purchaseInvoiceService.list((Wrapper)purchaseInvoiceQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)invoiceList)) {
            for (PurchaseInvoice invoice : invoiceList) {
                invoiceMap.put(invoice.getInvoiceCode() + "-" + invoice.getInvoiceNo(), invoice);
            }
        }
        return invoiceMap;
    }

    private void saveReconciliation(List<PurchaseReconciliation> headList) {
        ArrayList<SaleReconciliation> saleReconciliations = new ArrayList<SaleReconciliation>();
        if (!CollectionUtils.isEmpty(headList)) {
            PurchaseReconciliation entity = headList.get(0);
            long size = headList.stream().filter(x -> CharSequenceUtil.isEmpty((CharSequence)x.getReconciliationNumber())).count();
            if (size > 0L) {
                List nextCodes = this.invokeBaseRpcService.getNextCodes("reconciliation", (Object)entity, (int)size);
                int codeIndex = 0;
                for (PurchaseReconciliation reconciliation : headList) {
                    if (CharSequenceUtil.isEmpty((CharSequence)reconciliation.getReconciliationNumber())) {
                        reconciliation.setReconciliationNumber((String)nextCodes.get(codeIndex++));
                    }
                    SaleReconciliation saleReconciliation = new SaleReconciliation();
                    BeanUtil.copyProperties((Object)((Object)reconciliation), (Object)((Object)saleReconciliation), (String[])new String[0]);
                    saleReconciliation.setElsAccount(reconciliation.getToElsAccount());
                    saleReconciliation.setToElsAccount(reconciliation.getElsAccount());
                    saleReconciliation.setBusAccount(reconciliation.getElsAccount());
                    saleReconciliation.setId(IdWorker.getIdStr());
                    saleReconciliation.setRelationId(reconciliation.getId());
                    reconciliation.setRelationId(saleReconciliation.getId());
                    saleReconciliations.add(saleReconciliation);
                }
            }
            this.purchaseReconciliationService.saveBatch(headList, 2000);
            this.saleReconciliationService.saveBatch(saleReconciliations, 2000);
        }
    }

    @NotNull
    private Map<String, PurchaseReconciliation> getPurchaseReconciliationMap(List<PurchaseReconciliation> headList) {
        HashMap<String, PurchaseReconciliation> existMap = new HashMap<String, PurchaseReconciliation>();
        Set sourceNumber = headList.stream().map(PurchaseReconciliation::getSourceNumber).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(sourceNumber)) {
            LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
            lambdaQueryWrapper.in(PurchaseReconciliation::getSourceNumber, sourceNumber);
            List list = this.purchaseReconciliationService.list((Wrapper)lambdaQueryWrapper);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                for (PurchaseReconciliation existReconciliation : list) {
                    existMap.put(existReconciliation.getElsAccount() + "-" + existReconciliation.getSourceNumber(), existReconciliation);
                }
            }
        }
        return existMap;
    }

    private void saveInvoice(List<PurchaseInvoice> invoices, Map<String, String> map, Map<String, String> relationMap) {
        ArrayList<SaleInvoice> saleInvoices = new ArrayList<SaleInvoice>();
        if (!CollectionUtils.isEmpty(invoices)) {
            for (PurchaseInvoice invoice : invoices) {
                String reconciliationNumber = map.get(invoice.getHeadId()) == null ? "" : map.get(invoice.getHeadId());
                invoice.setReconciliationNumber(reconciliationNumber);
                String invoiceNumber = this.invokeBaseRpcService.getNextCode("invoiceNumber", (Object)invoice);
                invoice.setInvoiceNumber(invoiceNumber);
                invoice.setId(IdWorker.getIdStr());
                SaleInvoice saleInvoice = new SaleInvoice();
                BeanUtil.copyProperties((Object)((Object)invoice), (Object)((Object)saleInvoice), (String[])new String[0]);
                saleInvoice.setId(IdWorker.getIdStr());
                saleInvoice.setRelationId(invoice.getId());
                invoice.setRelationId(saleInvoice.getId());
                saleInvoice.setToElsAccount(invoice.getElsAccount());
                saleInvoice.setElsAccount(invoice.getToElsAccount());
                saleInvoice.setBusAccount(invoice.getElsAccount());
                saleInvoice.setHeadId(relationMap.get(invoice.getHeadId()));
                saleInvoices.add(saleInvoice);
            }
            this.purchaseInvoiceService.saveBatch(invoices, 2000);
            this.saleInvoiceService.saveBatch(saleInvoices, 2000);
        }
    }

    private void saveAcceptReturn(List<PurchaseRecAcceptReturn> accepts, Map<String, String> map, Map<String, String> relationMap) {
        ArrayList<SaleRecAcceptReturn> saleAccepts = new ArrayList<SaleRecAcceptReturn>();
        if (!CollectionUtils.isEmpty(accepts)) {
            for (PurchaseRecAcceptReturn accept : accepts) {
                String reconciliationNumber = map.get(accept.getHeadId()) == null ? "" : map.get(accept.getHeadId());
                accept.setReconciliationNumber(reconciliationNumber);
                accept.setId(IdWorker.getIdStr());
                SaleRecAcceptReturn saleRecAcceptReturn = new SaleRecAcceptReturn();
                BeanUtil.copyProperties((Object)((Object)accept), (Object)((Object)saleRecAcceptReturn), (String[])new String[0]);
                saleRecAcceptReturn.setId(IdWorker.getIdStr());
                saleRecAcceptReturn.setRelationId(accept.getId());
                accept.setRelationId(saleRecAcceptReturn.getId());
                saleRecAcceptReturn.setToElsAccount(accept.getElsAccount());
                saleRecAcceptReturn.setElsAccount(accept.getToElsAccount());
                saleRecAcceptReturn.setBusAccount(accept.getElsAccount());
                saleRecAcceptReturn.setHeadId(relationMap.get(accept.getHeadId()));
                saleAccepts.add(saleRecAcceptReturn);
            }
            this.purchaseRecAcceptReturnService.saveBatch(accepts, 2000);
            this.saleRecAcceptReturnService.saveBatch(saleAccepts, 2000);
        }
    }

    private void buildAcceptReturn(Map<String, String> defaultItemMap, List<PurchaseRecAcceptReturn> accepts, JSONObject object, PurchaseReconciliation head) {
        try {
            JSONArray recAcceptReturnJsonArray = this.getItemList(head, object, defaultItemMap, "recAcceptReturnList");
            List acceptList = JSON.parseArray((String)recAcceptReturnJsonArray.toJSONString(), PurchaseRecAcceptReturn.class);
            for (PurchaseRecAcceptReturn purchaseRecAcceptReturn : acceptList) {
                purchaseRecAcceptReturn.setOtherVoucherNumber(head.getSourceNumber());
            }
            accepts.addAll(acceptList);
        }
        catch (Exception e) {
            log.error("{}==>acceptList\u6570\u636e\u683c\u5f0f\u5f02\u5e38:{}", (Object)this.getBusinessType(), (Object)e.getMessage());
        }
    }

    private void buildInvoice(Map<String, String> defaultItemMap, List<PurchaseInvoice> invoices, JSONObject object, PurchaseReconciliation head) {
        try {
            JSONArray invoiceJsonArray = this.getItemList(head, object, defaultItemMap, "invoiceList");
            List invoiceList = JSON.parseArray((String)invoiceJsonArray.toJSONString(), PurchaseInvoice.class);
            invoices.addAll(invoiceList);
        }
        catch (Exception e) {
            log.error("{}==>invoiceList\u6570\u636e\u683c\u5f0f\u5f02\u5e38:{}", (Object)this.getBusinessType(), (Object)e.getMessage());
        }
    }

    public void doParamCheck(JSONArray array, TemplateHeadDTO templateHead, Map<String, String> defaultHeadMap, Map<String, String> defaultItemMap, List<TemplateConfigHeadDTO> configHeadList, List<TemplateConfigItemDTO> configItemList) {
    }

    public String getBusinessType() {
        return "reconciliation";
    }

    public List<ExcelExportClassColumnDTO> getBusinessClass() {
        return null;
    }

    public List<String> supportItemList() {
        return null;
    }

    private JSONArray getItemList(PurchaseReconciliation head, JSONObject object, Map<String, String> defaultItemMap, String name) {
        if (!object.containsKey((Object)name)) {
            return new JSONArray();
        }
        JSONArray jsonArray = object.getJSONArray(name);
        if (CollectionUtils.isEmpty((Collection)jsonArray)) {
            return new JSONArray();
        }
        JSONArray newJsonArray = new JSONArray();
        for (Object item : jsonArray) {
            JSONObject jsonObject = JSONObject.parseObject((String)JSON.toJSONString(item));
            jsonObject.put("headId", (Object)head.getId());
            jsonObject.put("elsAccount", (Object)head.getElsAccount());
            jsonObject.put("toElsAccount", (Object)head.getToElsAccount());
            jsonObject.put("createTime", (Object)head.getCreateTime());
            jsonObject.put("updateTime", (Object)head.getUpdateTime());
            jsonObject.put("createBy", (Object)head.getCreateBy());
            jsonObject.put("updateBy", (Object)head.getUpdateBy());
            jsonObject.put("deleted", (Object)CommonConstant.DEL_FLAG_0);
            jsonObject.put("id", null);
            BeanUtil.copyProperties(defaultItemMap, (Object)jsonObject, (String[])new String[0]);
            newJsonArray.add((Object)jsonObject);
        }
        return newJsonArray;
    }
}

