/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.constant.CommonConstant;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.UUIDGenerator;
import com.els.modules.config.MuonuoProperties;
import com.els.modules.finance.entity.FinanceEnterpriseOutinvoice;
import com.els.modules.reconciliation.entity.SaleInvoice;
import com.els.modules.reconciliation.enumerate.InvoiceTypeEnum;
import com.els.modules.reconciliation.enumerate.third.NuonuoCallBackStatusEnum;
import com.els.modules.reconciliation.mapper.SaleInvoiceMapper;
import com.els.modules.reconciliation.service.InvoiceService;
import com.els.modules.reconciliation.vo.InvoiceDetailVO;
import com.els.modules.reconciliation.vo.OrderVO;
import com.els.modules.reconciliation.vo.response.DataVO;
import com.els.modules.reconciliation.vo.response.InvoiceResultVO;
import com.els.modules.reconciliation.vo.response.ResultVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NuonuoInvoiceService
implements InvoiceService {
    private static final Logger log = LoggerFactory.getLogger(NuonuoInvoiceService.class);
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private MuonuoProperties muonuoProperties;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private SaleInvoiceMapper saleInvoiceMapper;

    @Override
    public Result<?> billing(List<InvoiceDetailVO> details, FinanceEnterpriseOutinvoice saleOutinvoice, FinanceEnterpriseOutinvoice purchaseOutinvoice, SaleInvoice saleInvoice) {
        HashMap data = new HashMap();
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("taxnum", saleOutinvoice.getTaxpayerRegNumber());
        data.put("header", headerMap);
        HashMap<String, OrderVO> bodyMap = new HashMap<String, OrderVO>();
        OrderVO orderVO = new OrderVO();
        data.put("body", bodyMap);
        orderVO.setBuyerName(purchaseOutinvoice.getEnterpriseName());
        if (!StringUtils.isEmpty((CharSequence)purchaseOutinvoice.getTaxpayerRegNumber())) {
            orderVO.setBuyerTaxNum(purchaseOutinvoice.getTaxpayerRegNumber());
        }
        if (!StringUtils.isEmpty((CharSequence)purchaseOutinvoice.getRegisterTelephone())) {
            orderVO.setBuyerTel(purchaseOutinvoice.getRegisterTelephone());
        }
        orderVO.setBuyerPhone(purchaseOutinvoice.getPhone());
        orderVO.setBuyerAddress(purchaseOutinvoice.getRegisterAddress());
        orderVO.setBuyerAccount(purchaseOutinvoice.getDepositBank() + purchaseOutinvoice.getBankAccount());
        orderVO.setEmail(purchaseOutinvoice.getEmail());
        orderVO.setSalerTaxNum(saleOutinvoice.getTaxpayerRegNumber());
        orderVO.setSalerAddress(purchaseOutinvoice.getRegisterAddress());
        orderVO.setSalerTel(saleOutinvoice.getRegisterTelephone());
        orderVO.setClerk(saleOutinvoice.getDrawer());
        orderVO.setPayee(saleOutinvoice.getPayee());
        orderVO.setChecker(saleOutinvoice.getReviewer());
        String depositBank = !StringUtils.isEmpty((CharSequence)saleOutinvoice.getDepositBank()) ? saleOutinvoice.getDepositBank() : "";
        String bankAccount = !StringUtils.isEmpty((CharSequence)saleOutinvoice.getBankAccount()) ? saleOutinvoice.getBankAccount() : "";
        orderVO.setSalerAccount(depositBank + bankAccount);
        String orderNo = UUIDGenerator.generate();
        this.redisUtil.set(orderNo, (Object)JSON.toJSONString((Object)((Object)saleInvoice)));
        orderVO.setOrderNo(orderNo);
        Date date = new Date();
        String invoiceDate = DateUtils.date2Str((Date)date, (SimpleDateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
        saleInvoice.setInvoiceTime(date);
        orderVO.setInvoiceDate(invoiceDate);
        orderVO.setPushMode("0");
        orderVO.setInvoiceType("1");
        orderVO.setInvoiceLine(InvoiceTypeEnum.FREE_TEXT_INVOICE_ELECTRIC_TICKET.getValue());
        log.info("callback url : {} ", (Object)this.muonuoProperties.getNuonuo());
        orderVO.setCallBackUrl(this.muonuoProperties.getNuonuo() + "/finance/nuonuo/noToken/invoice/callback/");
        orderVO.setInvoiceDetail(details);
        bodyMap.put("order", orderVO);
        log.info("billing: request {}", (Object)JSON.toJSONString(data));
        JSONObject result = this.invokeBaseRpcService.callIPaasInterface(JSON.parseObject((String)JSON.toJSONString(data)), "valueAddedApplication", this.invokeBaseRpcService.getIpaasInterfaceCode("invoice_nuonuo_billing"));
        log.info("billing: response {}", (Object)JSON.toJSONString((Object)result));
        ResultVO resultVO = (ResultVO)JSON.parseObject((String)JSON.toJSONString((Object)result), ResultVO.class);
        if (CommonConstant.SC_INTERNAL_SERVER_ERROR_500.intValue() == resultVO.getCode()) {
            return Result.error((String)resultVO.getMessage());
        }
        DataVO dataVO = resultVO.getData();
        if ("E0000".equals(dataVO.getCode())) {
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_vPDJLR_3f9cdf96", (String)"\u5f00\u7968\u63d0\u4ea4\u6210\u529f\uff01"));
        }
        return Result.error((String)dataVO.getDescribe());
    }

    @Override
    public void createInvoice(InvoiceResultVO resultVO) {
        String status = resultVO.getC_status();
        String orderno = resultVO.getC_orderno();
        if (NuonuoCallBackStatusEnum.BILLING_COMPLETE.getValue().equals(status)) {
            if (StringUtils.isEmpty((CharSequence)orderno)) {
                return;
            }
            Object obj = this.redisUtil.get(orderno);
            SaleInvoice saleInvoice = (SaleInvoice)((Object)JSON.parseObject((String)("" + obj), SaleInvoice.class));
            if (saleInvoice == null) {
                return;
            }
            String bhsje = resultVO.getC_bhsje();
            String hjse = resultVO.getC_hjse();
            if (!StringUtils.isEmpty((CharSequence)hjse) && !StringUtils.isEmpty((CharSequence)bhsje)) {
                saleInvoice.setNotIncludeTaxAmount(new BigDecimal(bhsje));
                saleInvoice.setTaxAmount(new BigDecimal(hjse));
                BigDecimal includeTaxAmount = new BigDecimal(bhsje).add(new BigDecimal(hjse));
                saleInvoice.setIncludeTaxAmount(includeTaxAmount);
            }
            String fpdm = resultVO.getC_fpdm();
            saleInvoice.setInvoiceCode(fpdm);
            String fphm = resultVO.getC_fphm();
            saleInvoice.setInvoiceNo(fphm);
            this.saleInvoiceMapper.insert((Object)saleInvoice);
            this.redisUtil.del(new String[]{orderno});
        }
    }
}

