/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.util.JwtUtil;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.ElsTaxDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.contract.dto.PurchaseContractAcceptanceDTO;
import com.els.modules.contract.dto.PurchaseContractPromiseDTO;
import com.els.modules.contract.dto.SaleContractAcceptanceDTO;
import com.els.modules.contract.dto.SaleContractPromiseDTO;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.finance.api.enumerate.DeductCostTypeEnum;
import com.els.modules.finance.api.enumerate.ReconciliationHookStatusEnum;
import com.els.modules.finance.entity.PurchaseDeductCost;
import com.els.modules.finance.entity.SaleDeductCost;
import com.els.modules.finance.rpc.ElsEnterpriseInfoLocalRpcService;
import com.els.modules.finance.service.PurchaseDeductCostService;
import com.els.modules.finance.service.PurchaseDeliveryWaterService;
import com.els.modules.finance.service.PurchasePaymentApplyItemService;
import com.els.modules.finance.service.SaleDeductCostService;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.PurchasePerformanceReconciliation;
import com.els.modules.reconciliation.entity.PurchasePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.entity.PurchaseRecCharge;
import com.els.modules.reconciliation.entity.PurchaseRecContractAcceptance;
import com.els.modules.reconciliation.entity.PurchaseRecContractPromise;
import com.els.modules.reconciliation.entity.SalePerformanceReconciliation;
import com.els.modules.reconciliation.entity.SalePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.entity.SaleRecCharge;
import com.els.modules.reconciliation.entity.SaleRecContractAcceptance;
import com.els.modules.reconciliation.entity.SaleRecContractPromise;
import com.els.modules.reconciliation.enumerate.InvoiceConfirmStatusEnum;
import com.els.modules.reconciliation.enumerate.OperationEnum;
import com.els.modules.reconciliation.enumerate.ReconciliationBillStatusEnum;
import com.els.modules.reconciliation.enumerate.ReconciliationStatusEmun;
import com.els.modules.reconciliation.enumerate.SaleStatusEmun;
import com.els.modules.reconciliation.mapper.PurchaseInvoiceMapper;
import com.els.modules.reconciliation.mapper.PurchasePerformanceReconciliationMapper;
import com.els.modules.reconciliation.mapper.PurchaseRecContractAcceptanceMapper;
import com.els.modules.reconciliation.mapper.PurchaseRecContractPromiseMapper;
import com.els.modules.reconciliation.mapper.SaleInvoiceMapper;
import com.els.modules.reconciliation.mapper.SalePerformanceReconciliationMapper;
import com.els.modules.reconciliation.mapper.SalePrePaymentWriteOffReconciliationMapper;
import com.els.modules.reconciliation.mapper.SaleRecAdditionalChargesMapper;
import com.els.modules.reconciliation.mapper.SaleRecChargeMapper;
import com.els.modules.reconciliation.mapper.SaleRecContractAcceptanceMapper;
import com.els.modules.reconciliation.mapper.SaleRecContractPromiseMapper;
import com.els.modules.reconciliation.rpc.ElsTaxLocalRpcService;
import com.els.modules.reconciliation.rpc.PurchaseContractAcceptanceLocalRpcService;
import com.els.modules.reconciliation.rpc.PurchaseContractPromiseLocalRpcService;
import com.els.modules.reconciliation.rpc.SaleContractAcceptanceLocalRpcService;
import com.els.modules.reconciliation.rpc.SaleContractPromiseLocalRpcService;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffService;
import com.els.modules.reconciliation.service.PurchaseInvoiceHookInformationService;
import com.els.modules.reconciliation.service.PurchaseInvoiceService;
import com.els.modules.reconciliation.service.PurchasePerformanceReconciliationService;
import com.els.modules.reconciliation.service.PurchasePrePaymentWriteOffReconciliationService;
import com.els.modules.reconciliation.service.PurchaseRecChargeService;
import com.els.modules.reconciliation.service.PurchaseRecContractAcceptanceService;
import com.els.modules.reconciliation.service.PurchaseRecContractPromiseService;
import com.els.modules.reconciliation.service.SaleInvoiceService;
import com.els.modules.reconciliation.vo.PurchaseInvoiceHookVO;
import com.els.modules.reconciliation.vo.PurchasePerformanceReconciliationVO;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import com.els.modules.supplier.api.enumerate.SupplierCoordinationWayEnum;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class PurchasePerformanceReconciliationServiceImpl
extends BaseServiceImpl<PurchasePerformanceReconciliationMapper, PurchasePerformanceReconciliation>
implements PurchasePerformanceReconciliationService {
    private static final Logger log = LoggerFactory.getLogger(PurchasePerformanceReconciliationServiceImpl.class);
    @Autowired
    private PurchaseDeductCostService purchaseDeductCostService;
    @Autowired
    private PurchasePaymentApplyItemService purchasePaymentApplyItemService;
    @Resource
    private PurchaseContractPromiseLocalRpcService purchaseContractPromiseLocalRpcService;
    @Resource
    private SaleContractPromiseLocalRpcService saleContractPromiseLocalRpcService;
    @Resource
    private PurchaseContractAcceptanceLocalRpcService purchaseContractAcceptanceLocalRpcService;
    @Resource
    private SaleContractAcceptanceLocalRpcService saleContractAcceptanceLocalRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private ElsEnterpriseInfoLocalRpcService elsEnterpriseInfoRpcService;
    @Autowired
    private PurchaseRecChargeService purchaseRecChargeService;
    @Autowired
    private PurchasePrePaymentWriteOffReconciliationService purchasePrePaymentWriteOffReconciliationService;
    @Autowired
    private PurchaseRecContractAcceptanceService purchaseRecContractAcceptanceService;
    @Autowired
    private PurchaseRecContractPromiseService purchaseRecContractPromiseService;
    @Resource
    private PurchasePerformanceReconciliationMapper purchasePerformanceReconciliationMapper;
    @Resource
    private SalePerformanceReconciliationMapper salePerformanceReconciliationMapper;
    @Autowired
    private SaleDeductCostService saleDeductCostService;
    @Autowired
    private ElsPurchaseStatisticsWriteOffService elsPurchaseStatisticsWriteOffService;
    @Autowired
    private PurchaseInvoiceHookInformationService purchaseInvoiceHookInformationService;
    @Autowired
    private PurchaseInvoiceService purchaseInvoiceService;
    @Resource
    private SaleInvoiceMapper saleInvoiceMapper;
    @Resource
    private PurchaseInvoiceMapper purchaseInvoiceMapper;
    @Resource
    private SaleRecChargeMapper saleRecChargeMapper;
    @Resource
    private SaleRecAdditionalChargesMapper saleRecAdditionalChargesMapper;
    @Resource
    private SalePrePaymentWriteOffReconciliationMapper salePrePaymentWriteOffReconciliationMapper;
    @Resource
    private SaleRecContractAcceptanceMapper saleRecContractAcceptanceMapper;
    @Resource
    private SaleRecContractPromiseMapper saleRecContractPromiseMapper;
    @Autowired
    private InterfaceUtil interfaceUtil;
    @Autowired
    private PurchaseDeliveryWaterService purchaseDeliveryWaterService;
    @Resource
    private PurchaseRecContractPromiseMapper purchaseRecContractPromiseMapper;
    @Resource
    private PurchaseRecContractAcceptanceMapper purchaseRecContractAcceptanceMapper;
    @Autowired
    private SaleInvoiceService saleInvoiceService;
    @Autowired
    private StaticConfig staticConfig;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private ElsTaxLocalRpcService elsTaxService;

    @Override
    public void delete(String id) {
        ((PurchasePerformanceReconciliationMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((PurchasePerformanceReconciliationMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(PurchasePerformanceReconciliation reconciliation, PurchasePerformanceReconciliationVO vo) {
        this.buildPurchasePerformanceReconciliation(reconciliation);
        this.purchasePerformanceReconciliationMapper.insert((Object)reconciliation);
        this.checkPromise(reconciliation, vo.getRecContractPromiseList());
        this.checkAcceptance(reconciliation, vo.getRecContractAcceptanceList());
        this.checkRecCharge(reconciliation, vo.getRecChargeList());
        this.invokeBaseRpcService.addStatusLog(reconciliation.getId(), ReconciliationStatusEmun.NEW.getValue(), "reconciliation", "inster");
        this.generateReconciliation(reconciliation, vo);
    }

    private void generateReconciliation(PurchasePerformanceReconciliation reconciliation, PurchasePerformanceReconciliationVO vo) {
        boolean flag = false;
        List<PurchaseRecContractPromise> contractPromiseList = vo.getRecContractPromiseList();
        List<PurchaseRecContractAcceptance> contractAcceptanceList = vo.getRecContractAcceptanceList();
        List<PurchaseRecCharge> chargeList = vo.getRecChargeList();
        List<PurchasePrePaymentWriteOffReconciliation> writeOffList = vo.getPrePaymentWriteOffList();
        HashSet currencySet = new HashSet();
        Set promiseCurrencySet = contractPromiseList.stream().filter(items -> !StringUtils.isEmpty((CharSequence)items.getCurrency())).map(PurchaseRecContractPromise::getCurrency).collect(Collectors.toSet());
        Set acceptanceCurrencySet = contractAcceptanceList.stream().map(PurchaseRecContractAcceptance::getCurrency).collect(Collectors.toSet());
        currencySet.addAll(promiseCurrencySet);
        currencySet.addAll(acceptanceCurrencySet);
        if (CollectionUtils.isEmpty(currencySet)) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IetbLKmneIZtSneOltlqLV_76c274e8", (String)"\u5bf9\u8d26\u5355\u751f\u6210\u5931\u8d25,\u5408\u540c\u5c65\u7ea6\u5355\u6216\u5408\u540c\u9a8c\u6536\u5355 \u5e01\u522b\u4e3a\u7a7a"));
        }
        for (String currency : currencySet) {
            Set taxCodes;
            boolean taxCodeFlag = true;
            String taxCode = "";
            ArrayList<PurchaseRecContractPromise> promises = new ArrayList();
            if (!CollectionUtils.isEmpty(contractPromiseList)) {
                promises = contractPromiseList.stream().filter(item -> currency.equals(item.getCurrency())).collect(Collectors.toList());
                Set taxCodes2 = contractPromiseList.stream().filter(item -> !StringUtils.isEmpty((CharSequence)item.getTaxCode())).map(PurchaseRecContractPromise::getTaxCode).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty(taxCodes2) && taxCodes2.size() == 1) {
                    Optional taxCodeOption = taxCodes2.stream().findFirst();
                    taxCode = (String)taxCodeOption.get();
                } else {
                    taxCodeFlag = false;
                }
            }
            ArrayList<PurchaseRecContractAcceptance> acceptances = new ArrayList();
            if (!CollectionUtils.isEmpty(contractAcceptanceList)) {
                acceptances = contractAcceptanceList.stream().filter(item -> currency.equals(item.getCurrency())).collect(Collectors.toList());
                Set taxCodes3 = contractAcceptanceList.stream().map(PurchaseRecContractAcceptance::getTaxCode).collect(Collectors.toSet());
                if (CollectionUtils.isEmpty(taxCodes3) || taxCodes3.size() != 1 || !taxCodes3.contains(taxCode)) {
                    taxCodeFlag = false;
                }
            }
            if (CollectionUtils.isEmpty(promises) && CollectionUtils.isEmpty(acceptances)) continue;
            List<Object> charges = new ArrayList();
            if (!(CollectionUtils.isEmpty(chargeList) || !CollectionUtils.isEmpty(taxCodes = (charges = chargeList.stream().filter(item -> currency.equals(item.getCurrency())).collect(Collectors.toList())).stream().map(PurchaseRecCharge::getTaxCode).collect(Collectors.toSet())) && taxCodes.size() == 1 && taxCodes.contains(taxCode))) {
                taxCodeFlag = false;
            }
            ArrayList<PurchasePrePaymentWriteOffReconciliation> writeOffs = new ArrayList();
            if (!CollectionUtils.isEmpty(writeOffList)) {
                writeOffs = writeOffList.stream().filter(item -> currency.equals(item.getCurrency())).collect(Collectors.toList());
            }
            if (taxCodeFlag) {
                reconciliation.setTaxCode(taxCode);
                this.setTaxRate(reconciliation, taxCode);
            }
            reconciliation.setCurrency(currency);
            if (flag) {
                PurchasePerformanceReconciliation purchaseReconciliation = new PurchasePerformanceReconciliation();
                BeanUtils.copyProperties((Object)((Object)reconciliation), (Object)((Object)purchaseReconciliation));
                purchaseReconciliation.setId(null);
                String reconciliationNumber = this.invokeBaseRpcService.getNextCode("performanceReconciliation", (Object)purchaseReconciliation);
                purchaseReconciliation.setReconciliationNumber(reconciliationNumber);
                PurchasePerformanceReconciliationVO reconciliationVO = new PurchasePerformanceReconciliationVO(promises, acceptances, charges, writeOffs);
                this.calculateMoney(purchaseReconciliation, reconciliationVO);
                this.checkSettlementAmount(purchaseReconciliation);
                this.purchasePerformanceReconciliationMapper.insert((Object)purchaseReconciliation);
                this.insertData(purchaseReconciliation, reconciliationVO);
                this.purchasePerformanceReconciliationMapper.updateById((Object)purchaseReconciliation);
                continue;
            }
            PurchasePerformanceReconciliationVO reconciliationVO = new PurchasePerformanceReconciliationVO(promises, acceptances, charges, writeOffs);
            this.calculateMoney(reconciliation, reconciliationVO);
            this.checkSettlementAmount(reconciliation);
            this.purchasePerformanceReconciliationMapper.updateById((Object)reconciliation);
            this.insertData(reconciliation, reconciliationVO);
            flag = true;
        }
    }

    private void setTaxRate(PurchasePerformanceReconciliation reconciliation, String taxCode) {
        if (reconciliation.getTaxRate() != null) {
            return;
        }
        List<ElsTaxDTO> taxs = this.elsTaxService.findList(reconciliation.getElsAccount(), taxCode);
        if (CollectionUtils.isEmpty(taxs)) {
            return;
        }
        Optional taxOptional = taxs.stream().findFirst();
        if (taxOptional.isPresent()) {
            ElsTaxDTO elsTaxDTO = (ElsTaxDTO)taxOptional.get();
            reconciliation.setTaxRate(elsTaxDTO.getTaxRate());
        }
    }

    private void checkSettlementAmount(PurchasePerformanceReconciliation reconciliation) {
        if ("1".equals(reconciliation.getSaveForZero())) {
            if (reconciliation.getSettlementAmount().compareTo(new BigDecimal(0)) < 0) {
                log.error("checkSettlementAmount, error  " + JSON.toJSONString((Object)((Object)reconciliation)));
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_dBHfEU0xiTcIIet_be49e2d6", (String)"\u5e94\u4ed8\u91d1\u989d\u7b49\u4e8e0\uff0c\u4e0d\u5141\u8bb8\u521b\u5efa\u5bf9\u8d26\u5355"));
            }
        } else if (reconciliation.getSettlementAmount().compareTo(new BigDecimal(0)) < 1) {
            log.error("checkSettlementAmount, error  " + JSON.toJSONString((Object)((Object)reconciliation)));
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_dBHfXUEU0xiTcIIet_5c5ad4b5", (String)"\u5e94\u4ed8\u91d1\u989d\u5c0f\u4e8e\u7b49\u4e8e0\uff0c\u4e0d\u5141\u8bb8\u521b\u5efa\u5bf9\u8d26\u5355"));
        }
    }

    private void buildPurchasePerformanceReconciliation(PurchasePerformanceReconciliation reconciliation) {
        String reconciliationNumber = this.invokeBaseRpcService.getNextCode("performanceReconciliation", (Object)reconciliation);
        reconciliation.setReconciliationNumber(reconciliationNumber);
        reconciliation.setInvoiced("0");
        reconciliation.setSendStatus("0");
        reconciliation.setReconciliationStatus(ReconciliationStatusEmun.NEW.getValue());
        reconciliation.setStatus(ReconciliationBillStatusEnum.NEW.getValue());
        reconciliation.setCancellation("0");
        reconciliation.setCreateAccount(TenantContext.getTenant());
        ElsEnterpriseInfoDTO enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(TenantContext.getTenant());
        if (enterpriseInfo != null) {
            reconciliation.setPurchaseName(enterpriseInfo.getName());
        }
        this.handlePaymentExpireDate(reconciliation);
    }

    private void handlePaymentExpireDate(PurchasePerformanceReconciliation reconciliation) {
        if (StringUtils.isEmpty((CharSequence)reconciliation.getPayCycle()) || reconciliation.getPaymentBenchmarkDate() == null) {
            return;
        }
        Integer payCycle = Integer.valueOf(reconciliation.getPayCycle());
        if (payCycle > 0) {
            DateTime paymentExpireDate = DateUtil.offsetDay((Date)reconciliation.getPaymentBenchmarkDate(), (int)payCycle);
            reconciliation.setPaymentExpiredate((Date)paymentExpireDate);
        }
    }

    private void insertData(PurchasePerformanceReconciliation reconciliation, PurchasePerformanceReconciliationVO vo) {
        this.deleteDetail(reconciliation.getId());
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = vo.getRecContractPromiseList();
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = vo.getRecContractAcceptanceList();
        List<PurchaseRecCharge> purchaseRecChargeList = vo.getRecChargeList();
        List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList = vo.getPrePaymentWriteOffList();
        this.insertContractPromise(reconciliation, purchaseRecContractPromiseList);
        this.insertContractAcceptance(reconciliation, purchaseRecContractAcceptanceList);
        this.insertDeductCost(reconciliation, purchaseRecChargeList);
        this.insertPrePaymentWriteOff(reconciliation, prePaymentWriteOffList);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void deleteDetail(String id) {
        this.purchaseRecContractPromiseService.deleteByMainId(id);
        this.purchaseRecContractAcceptanceService.deleteByMainId(id);
        this.purchaseRecChargeService.deleteByMainId(id);
        this.purchasePrePaymentWriteOffReconciliationService.deleteByMainId(id);
        this.purchaseInvoiceMapper.deleteByMainId(id);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void updateMain(PurchasePerformanceReconciliation reconciliation, PurchasePerformanceReconciliationVO vo) {
        PurchasePerformanceReconciliation dbReconciliation = (PurchasePerformanceReconciliation)((Object)this.getById((Serializable)((Object)reconciliation.getId())));
        if (dbReconciliation != null && !ReconciliationBillStatusEnum.SALE_REFUSED.getValue().equals(dbReconciliation.getStatus()) && !ReconciliationBillStatusEnum.NEW.getValue().equals(dbReconciliation.getStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = vo.getRecContractPromiseList();
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = vo.getRecContractAcceptanceList();
        List<PurchaseRecCharge> purchaseRecChargeList = vo.getRecChargeList();
        List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList = vo.getPrePaymentWriteOffList();
        this.purchaseRecContractPromiseService.checkPromise(vo);
        this.purchaseRecContractAcceptanceService.checkAcceptance(vo);
        this.purchaseRecChargeService.checkPerformanceReconcilationCharge(vo);
        this.checkPromise(reconciliation, purchaseRecContractPromiseList);
        this.checkAcceptance(reconciliation, purchaseRecContractAcceptanceList);
        this.checkRecCharge(reconciliation, purchaseRecChargeList);
        if (CollectionUtils.isEmpty(purchaseRecChargeList)) {
            this.cancelCharges(reconciliation.getId(), null);
            this.purchaseRecChargeService.deleteByMainId(reconciliation.getId());
        }
        if (CollectionUtils.isEmpty(purchasePrePaymentWriteOffList)) {
            this.purchasePrePaymentWriteOffReconciliationService.deleteByMainId(reconciliation.getId());
        }
        if (CollectionUtils.isEmpty(purchaseRecContractPromiseList)) {
            this.cancelContractPromise(reconciliation.getId(), null);
            this.purchaseRecContractPromiseService.deleteByMainId(reconciliation.getId());
        }
        if (CollectionUtils.isEmpty(purchaseRecContractAcceptanceList)) {
            this.cancelContractAcceptance(reconciliation.getId(), null);
            this.purchaseRecContractAcceptanceService.deleteByMainId(reconciliation.getId());
        }
        if (CollectionUtils.isEmpty(purchaseRecContractPromiseList) && CollectionUtils.isEmpty(purchaseRecContractAcceptanceList)) {
            this.calculateMoney(reconciliation, vo);
            this.checkSettlementAmount(reconciliation);
            this.purchasePerformanceReconciliationMapper.updateById((Object)reconciliation);
            return;
        }
        this.handlePaymentExpireDate(reconciliation);
        this.purchasePerformanceReconciliationMapper.updateById((Object)reconciliation);
        this.cancelContractPromise(reconciliation.getId(), null);
        this.cancelContractAcceptance(reconciliation.getId(), null);
        this.cancelCharges(reconciliation.getId(), null);
        this.generateReconciliation(reconciliation, vo);
    }

    private void checkAcceptance(PurchasePerformanceReconciliation purchaseReconciliation, List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList) {
        if (CollectionUtil.isEmpty(purchaseRecContractAcceptanceList)) {
            return;
        }
        Set<String> reconciliationNumbers = purchaseRecContractAcceptanceList.stream().map(PurchaseRecContractAcceptance::getAcceptanceNumbers).collect(Collectors.toSet());
        List<PurchaseContractAcceptanceDTO> purchaseContractAcceptanceList = this.purchaseContractAcceptanceLocalRpcService.checkHasReconciliation(reconciliationNumbers);
        if (CollectionUtil.isEmpty(purchaseContractAcceptanceList)) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (PurchaseContractAcceptanceDTO dto : purchaseContractAcceptanceList) {
            map.put(dto.getAcceptanceNumbers(), dto.getReconciliationNumber());
        }
        Set reconciliationNumber = purchaseContractAcceptanceList.stream().filter(item -> !StringUtils.isEmpty((CharSequence)item.getReconciliationNumber())).map(PurchaseContractAcceptanceDTO::getReconciliationNumber).collect(Collectors.toSet());
        reconciliationNumber.remove(purchaseReconciliation.getReconciliationNumber());
        if (CollectionUtil.isEmpty(reconciliationNumber)) {
            return;
        }
        for (int i = 0; i < purchaseRecContractAcceptanceList.size(); ++i) {
            boolean flag;
            PurchaseRecContractAcceptance contractAcceptance = purchaseRecContractAcceptanceList.get(i);
            String number = (String)map.get(contractAcceptance.getAcceptanceNumbers());
            boolean bl = flag = !StringUtils.isEmpty((CharSequence)number) && !StringUtils.isEmpty((CharSequence)purchaseReconciliation.getReconciliationNumber()) && !purchaseReconciliation.getReconciliationNumber().equals(number);
            if (!flag) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_neOltTy0IqAvIet1IeVQG_67a3107f", (String)"\u5408\u540c\u9a8c\u6536\u5355 \u5e8f\u53f7${0} \u5df2\u88ab\u5176\u4ed6\u5bf9\u8d26\u5355: ${1} \u5bf9\u8d26\uff0c\u8bf7\u5220\u9664", (String[])new String[]{"" + (i + 1), number}));
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkPromise(PurchasePerformanceReconciliation purchaseReconciliation, List<PurchaseRecContractPromise> purchaseRecContractPromiseList) {
        void var7_10;
        if (CollectionUtil.isEmpty(purchaseRecContractPromiseList)) {
            return;
        }
        HashSet<String> reconciliationNumbers = new HashSet<String>();
        for (PurchaseRecContractPromise promise : purchaseRecContractPromiseList) {
            reconciliationNumbers.add(promise.getPromiseNumber() + "-" + promise.getPromiseNumberItem());
        }
        List<PurchaseContractPromiseDTO> contractPromiseDTOList = this.purchaseContractPromiseLocalRpcService.checkHasReconciliation(reconciliationNumbers);
        if (CollectionUtil.isEmpty(contractPromiseDTOList)) {
            return;
        }
        HashMap<CallSite, String> map = new HashMap<CallSite, String>();
        for (PurchaseContractPromiseDTO purchaseContractPromiseDTO : contractPromiseDTOList) {
            map.put((CallSite)((Object)(purchaseContractPromiseDTO.getPromiseNumber() + "-" + purchaseContractPromiseDTO.getPromiseNumberItem())), purchaseContractPromiseDTO.getReconciliationNumber());
        }
        Set reconciliationNumber = contractPromiseDTOList.stream().filter(item -> !StringUtils.isEmpty((CharSequence)item.getReconciliationNumber())).map(PurchaseContractPromiseDTO::getReconciliationNumber).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(reconciliationNumber)) {
            return;
        }
        for (String number : reconciliationNumber) {
            if (!number.contains(purchaseReconciliation.getReconciliationNumber())) continue;
            reconciliationNumber.remove(number);
        }
        if (CollectionUtil.isEmpty(reconciliationNumber)) {
            return;
        }
        boolean bl = false;
        while (var7_10 < purchaseRecContractPromiseList.size()) {
            boolean flag;
            PurchaseRecContractPromise purchaseRecContractPromise = purchaseRecContractPromiseList.get((int)var7_10);
            String number = (String)map.get(purchaseRecContractPromise.getPromiseNumber() + "-" + purchaseRecContractPromise.getPromiseNumberItem());
            boolean bl2 = flag = !StringUtils.isEmpty((CharSequence)number) && !StringUtils.isEmpty((CharSequence)purchaseReconciliation.getReconciliationNumber()) && !purchaseReconciliation.getReconciliationNumber().equals(number);
            if (flag) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_neIZtTy0IqAvIet1IeVQG_fffa6d28", (String)"\u5408\u540c\u5c65\u7ea6\u5355 \u5e8f\u53f7${0} \u5df2\u88ab\u5176\u4ed6\u5bf9\u8d26\u5355: ${1} \u5bf9\u8d26\uff0c\u8bf7\u5220\u9664", (String[])new String[]{"" + (int)(var7_10 + true), number}));
            }
            ++var7_10;
        }
    }

    private void checkRecCharge(PurchasePerformanceReconciliation purchaseReconciliation, List<PurchaseRecCharge> recChargeList) {
        if (CollectionUtil.isEmpty(recChargeList)) {
            return;
        }
        Set<String> voucherNumbers = recChargeList.stream().map(PurchaseRecCharge::getVoucherNumber).collect(Collectors.toSet());
        List<PurchaseDeductCost> purchaseDeductCosts = this.purchaseDeductCostService.checkHasReconciliation(voucherNumbers);
        if (CollectionUtil.isEmpty(purchaseDeductCosts)) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (PurchaseDeductCost purchaseDeductCost : purchaseDeductCosts) {
            map.put(purchaseDeductCost.getDeductNumber(), purchaseDeductCost.getReconciliationNumber());
        }
        Set reconciliationNumber = purchaseDeductCosts.stream().filter(item -> !StringUtils.isEmpty((CharSequence)item.getReconciliationNumber())).map(PurchaseDeductCost::getReconciliationNumber).collect(Collectors.toSet());
        reconciliationNumber.remove(purchaseReconciliation.getReconciliationNumber());
        if (CollectionUtil.isEmpty(reconciliationNumber)) {
            return;
        }
        for (int i = 0; i < recChargeList.size(); ++i) {
            boolean flag;
            PurchaseRecCharge purchaseRecCharge = recChargeList.get(i);
            String number = (String)map.get(purchaseRecCharge.getVoucherNumber());
            boolean bl = flag = !StringUtils.isEmpty((CharSequence)number) && !StringUtils.isEmpty((CharSequence)purchaseReconciliation.getReconciliationNumber()) && !purchaseReconciliation.getReconciliationNumber().equals(number);
            if (!flag) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VVRHTy0IqAvIet1IeVQG_b8be268b", (String)"\u6263\u6b3e\u660e\u7ec6 \u5e8f\u53f7${0} \u5df2\u88ab\u5176\u4ed6\u5bf9\u8d26\u5355: ${1} \u5bf9\u8d26\uff0c\u8bf7\u5220\u9664", (String[])new String[]{"" + (i + 1), number}));
        }
    }

    private void calculateMoney(PurchasePerformanceReconciliation reconciliation, PurchasePerformanceReconciliationVO vo) {
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = vo.getRecContractPromiseList();
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = vo.getRecContractAcceptanceList();
        List<PurchaseRecCharge> charges = vo.getRecChargeList();
        List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList = vo.getPrePaymentWriteOffList();
        BigDecimal performanceIncludeTaxAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(purchaseRecContractPromiseList)) {
            performanceIncludeTaxAmount = purchaseRecContractPromiseList.parallelStream().filter(item -> item.getAmount() != null).map(PurchaseRecContractPromise::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        reconciliation.setPerformanceIncludeTaxAmount(performanceIncludeTaxAmount);
        BigDecimal acceptanceIncludeTaxAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(purchaseRecContractAcceptanceList)) {
            acceptanceIncludeTaxAmount = purchaseRecContractAcceptanceList.parallelStream().filter(item -> item.getTaxAmount() != null).map(PurchaseRecContractAcceptance::getTaxAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        reconciliation.setAcceptanceIncludeTaxAmount(acceptanceIncludeTaxAmount);
        BigDecimal chargeTotalAmount = BigDecimal.ZERO;
        BigDecimal chargeAmount = BigDecimal.ZERO;
        BigDecimal buckleTicketsAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(charges)) {
            for (PurchaseRecCharge purchaseRecCharge : charges) {
                chargeTotalAmount = chargeTotalAmount.add(purchaseRecCharge.getTotalAmount());
                if (DeductCostTypeEnum.ACCOUNT_DEDUCTION.getValue().equals(purchaseRecCharge.getDeductionType())) {
                    chargeAmount = chargeAmount.add(purchaseRecCharge.getTotalAmount());
                }
                if (!DeductCostTypeEnum.TICKET_DEDUCTION.getValue().equals(purchaseRecCharge.getDeductionType())) continue;
                buckleTicketsAmount = buckleTicketsAmount.add(purchaseRecCharge.getTotalAmount());
            }
        }
        reconciliation.setChargeTotalAmount(chargeTotalAmount);
        reconciliation.setChargeAmount(chargeAmount);
        reconciliation.setBuckleTicketsAmount(buckleTicketsAmount);
        BigDecimal shouldInvoiceAmount = performanceIncludeTaxAmount.add(acceptanceIncludeTaxAmount).subtract(buckleTicketsAmount);
        reconciliation.setShouldInvoiceAmount(shouldInvoiceAmount);
        BigDecimal closingAmount = shouldInvoiceAmount.subtract(chargeAmount);
        reconciliation.setClosingAmount(closingAmount);
        BigDecimal writtenOffAmount = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            writtenOffAmount = prePaymentWriteOffList.parallelStream().filter(item -> item.getThisWriteOffAmount() != null).map(PurchasePrePaymentWriteOffReconciliation::getThisWriteOffAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        reconciliation.setWrittenOffAmount(writtenOffAmount);
        BigDecimal settlementAmount = closingAmount.subtract(writtenOffAmount);
        reconciliation.setSettlementAmount(settlementAmount);
        reconciliation.setRemainingUnPaidAmount(settlementAmount);
        this.purchasePerformanceReconciliationMapper.updateById((Object)reconciliation);
    }

    @Override
    public PurchasePerformanceReconciliationVO extractReconciliation(PurchasePerformanceReconciliationVO vo) {
        String elsAccount = !StringUtils.isBlank((CharSequence)vo.getElsAccount()) ? vo.getElsAccount() : TenantContext.getTenant();
        ReconciliationVO targetReconciliationVO = new ReconciliationVO();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)targetReconciliationVO);
        PurchaseContractPromiseDTO purchaseContractPromiseDTO = new PurchaseContractPromiseDTO();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)purchaseContractPromiseDTO);
        List<PurchaseContractPromiseDTO> purchaseContractPromiseList = this.purchaseContractPromiseLocalRpcService.listPurchaseContractPromiseDTO(purchaseContractPromiseDTO);
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = this.getPurchaseRecContractPromiseList(purchaseContractPromiseList);
        vo.setRecContractPromiseList(purchaseRecContractPromiseList);
        PurchaseContractAcceptanceDTO purchaseContractAcceptanceDTO = new PurchaseContractAcceptanceDTO();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)purchaseContractAcceptanceDTO);
        List<PurchaseContractAcceptanceDTO> purchaseContractAcceptanceList = this.purchaseContractAcceptanceLocalRpcService.listPurchaseContractAcceptanceDTO(purchaseContractAcceptanceDTO);
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = this.getPurchaseRecContractAcceptanceList(purchaseContractAcceptanceList);
        vo.setRecContractAcceptanceList(purchaseRecContractAcceptanceList);
        List<PurchaseRecCharge> charges = this.purchaseDeductCostService.getByPurchaseDeductCost(targetReconciliationVO, elsAccount);
        vo.setRecChargeList(charges);
        List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOff = this.purchasePaymentApplyItemService.getPurchasePrePaymentWriteOffReconciliations(targetReconciliationVO, elsAccount);
        vo.setPrePaymentWriteOffList(prePaymentWriteOff);
        return vo;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> publish(PurchasePerformanceReconciliation reconciliation, PurchasePerformanceReconciliationVO vo) {
        PurchasePerformanceReconciliation dbReconciliation = (PurchasePerformanceReconciliation)((Object)this.getById((Serializable)((Object)reconciliation.getId())));
        if (dbReconciliation != null) {
            if (ReconciliationBillStatusEnum.SALE_UNCONFIRMED.getValue().equals(dbReconciliation.getStatus())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APzExqhxVXVtFzE_64c0f41", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u53d1\u5e03\uff0c\u8bf7\u5237\u65b0\u5355\u636e\u72b6\u6001"));
            }
            BigDecimal closingAmount = dbReconciliation.getClosingAmount();
            if (closingAmount != null) {
                if (closingAmount.compareTo(BigDecimal.ZERO) > 0 && ReconciliationBillStatusEnum.UNINVOICE.getValue().equals(dbReconciliation.getStatus())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APzExqhxVXVtFzE_64c0f41", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u53d1\u5e03\uff0c\u8bf7\u5237\u65b0\u5355\u636e\u72b6\u6001"));
                }
                if (closingAmount.compareTo(BigDecimal.ZERO) <= 0 && ReconciliationBillStatusEnum.NOINVOICE.getValue().equals(dbReconciliation.getStatus())) {
                    throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APzExqhxVXVtFzE_64c0f41", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u53d1\u5e03\uff0c\u8bf7\u5237\u65b0\u5355\u636e\u72b6\u6001"));
                }
            }
        }
        this.purchaseRecContractPromiseService.checkPromise(vo);
        this.purchaseRecContractAcceptanceService.checkAcceptance(vo);
        this.purchaseRecChargeService.checkPerformanceReconcilationCharge(vo);
        this.calculateMoney(reconciliation, vo);
        this.checkSettlementAmount(reconciliation);
        ReconciliationVO targetVo = new ReconciliationVO();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)targetVo);
        this.elsPurchaseStatisticsWriteOffService.writeOffAmountOccupy(targetVo, vo.getPrePaymentWriteOffList());
        boolean flag = false;
        if (ReconciliationStatusEmun.REFUSED.getValue().equals(reconciliation.getReconciliationStatus()) && StringUtils.isNotBlank((CharSequence)reconciliation.getRelationId())) {
            flag = true;
        }
        if (SupplierCoordinationWayEnum.NO_COORDINATIONWAY.getValue().equals(reconciliation.getIsTeamwork())) {
            reconciliation.setReconciliationStatus(ReconciliationStatusEmun.COMFIRMED.getValue());
            BigDecimal closingAmount = reconciliation.getClosingAmount();
            if (closingAmount != null && closingAmount.compareTo(BigDecimal.ZERO) > 0) {
                reconciliation.setStatus(ReconciliationBillStatusEnum.UNINVOICE.getValue());
            }
            if (closingAmount != null && closingAmount.compareTo(BigDecimal.ZERO) <= 0) {
                reconciliation.setStatus(ReconciliationBillStatusEnum.NOINVOICE.getValue());
            }
        } else {
            reconciliation.setReconciliationStatus(ReconciliationStatusEmun.UNCONFIRMED.getValue());
            reconciliation.setStatus(ReconciliationBillStatusEnum.SALE_UNCONFIRMED.getValue());
        }
        reconciliation.setSendStatus("1");
        this.updateMain(reconciliation, vo);
        this.invokeBaseRpcService.addStatusLog(reconciliation.getId(), reconciliation.getReconciliationStatus(), "reconciliation", "publish");
        String id = reconciliation.getRelationId();
        SalePerformanceReconciliation salePerformanceReconciliation = new SalePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)reconciliation), (Object)((Object)salePerformanceReconciliation));
        salePerformanceReconciliation.setToElsAccount(reconciliation.getElsAccount());
        salePerformanceReconciliation.setBusAccount(reconciliation.getElsAccount());
        salePerformanceReconciliation.setRelationId(reconciliation.getId());
        salePerformanceReconciliation.setElsAccount(reconciliation.getToElsAccount());
        if (flag) {
            salePerformanceReconciliation.setDataVersion(null);
            salePerformanceReconciliation.setId(id);
            salePerformanceReconciliation.setReconciliationStatus(reconciliation.getReconciliationStatus());
            salePerformanceReconciliation.setStatus(reconciliation.getStatus());
            this.salePerformanceReconciliationMapper.updateById((Object)salePerformanceReconciliation);
            this.handleDetail(salePerformanceReconciliation, vo);
        } else {
            salePerformanceReconciliation.setId(null);
            this.salePerformanceReconciliationMapper.insert((Object)salePerformanceReconciliation);
            this.handleDetail(salePerformanceReconciliation, vo);
            reconciliation.setRelationId(salePerformanceReconciliation.getId());
            PurchasePerformanceReconciliation byId = (PurchasePerformanceReconciliation)((Object)this.getById((Serializable)((Object)reconciliation.getId())));
            reconciliation.setDataVersion(byId.getDataVersion());
            this.purchasePerformanceReconciliationMapper.updateById((Object)reconciliation);
        }
        this.sendMessage(reconciliation, salePerformanceReconciliation);
        return Result.ok((String)"\u53d1\u5e03\u6210\u529f\uff01");
    }

    private void sendMessage(PurchasePerformanceReconciliation purchaseReconciliation, SalePerformanceReconciliation saleReconciliation) {
        String url = "id=" + saleReconciliation.getId() + "&createAccount=" + saleReconciliation.getCreateAccount();
        String serviceAddress = (String)this.staticConfig.getConfig().get("service.address");
        ElsSubAccountDTO elsSubAccount = this.invokeAccountRpcService.getAccount(purchaseReconciliation.getToElsAccount(), "1001");
        String token = JwtUtil.getOutToken((String)(elsSubAccount.getElsAccount() + "_" + elsSubAccount.getSubAccount()), (String)elsSubAccount.getPassword());
        saleReconciliation.setFbk16(serviceAddress + "/els/reconciliation/salePerformanceReconciliation/emailConfirmOrRefuesd?token=" + token + "&operation=confirm&id=" + saleReconciliation.getId());
        saleReconciliation.setFbk17(serviceAddress + "/els/reconciliation/salePerformanceReconciliation/emailConfirmOrRefuesd?token=" + token + "&operation=refused&id=" + saleReconciliation.getId());
        super.sendMessage(purchaseReconciliation.getElsAccount(), "performanceReconciliation", "publish", saleReconciliation.getId(), "performanceReconciliationBusDataServiceImpl", Arrays.asList(purchaseReconciliation.getToElsAccount()));
    }

    private void handleDetail(SalePerformanceReconciliation saleReconciliation, PurchasePerformanceReconciliationVO vo) {
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = vo.getRecContractPromiseList();
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = vo.getRecContractAcceptanceList();
        List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList = vo.getPrePaymentWriteOffList();
        List<PurchaseRecCharge> purchaseRecChargeList = vo.getRecChargeList();
        List<PurchaseAttachmentDTO> attachments = vo.getAttachments();
        String id = saleReconciliation.getId();
        this.saleRecContractPromiseMapper.deleteByMainId(id);
        this.saleRecContractAcceptanceMapper.deleteByMainId(id);
        this.salePrePaymentWriteOffReconciliationMapper.deleteByMainId(id);
        this.saleRecChargeMapper.deleteByMainId(id);
        this.saleRecAdditionalChargesMapper.deleteByMainId(id);
        this.invokeBaseRpcService.deleteSaleAttachmentByMainId(id);
        this.handleSaleRecContractPromiseDetail(saleReconciliation, purchaseRecContractPromiseList);
        this.handleSaleRecContractAcceptanceDetail(saleReconciliation, purchaseRecContractAcceptanceList);
        this.handleSaleRecChargeDetail(saleReconciliation, purchaseRecChargeList);
        this.handleSaleRecPrePaymentWriteOffDetail(saleReconciliation, prePaymentWriteOffList);
        this.handleSaleAttachmentDetail(saleReconciliation, attachments);
    }

    private void handleSaleRecPrePaymentWriteOffDetail(SalePerformanceReconciliation saleReconciliation, List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList) {
        if (CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            return;
        }
        ArrayList<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffList = new ArrayList<SalePrePaymentWriteOffReconciliation>();
        for (PurchasePrePaymentWriteOffReconciliation purchasePrePaymentWriteOff : prePaymentWriteOffList) {
            SalePrePaymentWriteOffReconciliation salePrePaymentWriteOff = new SalePrePaymentWriteOffReconciliation();
            BeanUtils.copyProperties((Object)((Object)purchasePrePaymentWriteOff), (Object)((Object)salePrePaymentWriteOff));
            salePrePaymentWriteOff.setId(null);
            salePrePaymentWriteOff.setElsAccount(saleReconciliation.getElsAccount());
            salePrePaymentWriteOff.setToElsAccount(saleReconciliation.getToElsAccount());
            salePrePaymentWriteOff.setBusAccount(saleReconciliation.getBusAccount());
            salePrePaymentWriteOff.setHeadId(saleReconciliation.getId());
            salePrePaymentWriteOff.setRelationId(purchasePrePaymentWriteOff.getId());
            salePrePaymentWriteOffList.add(salePrePaymentWriteOff);
        }
        this.salePrePaymentWriteOffReconciliationMapper.insertBatchSomeColumn(salePrePaymentWriteOffList);
    }

    private void handleSaleRecContractAcceptanceDetail(SalePerformanceReconciliation saleReconciliation, List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList) {
        if (CollectionUtils.isEmpty(purchaseRecContractAcceptanceList)) {
            return;
        }
        ArrayList<SaleRecContractAcceptance> saleRecContractAcceptanceList = new ArrayList<SaleRecContractAcceptance>();
        for (PurchaseRecContractAcceptance purchaseRecContractAcceptance : purchaseRecContractAcceptanceList) {
            SaleRecContractAcceptance saleRecContractAcceptance = new SaleRecContractAcceptance();
            BeanUtils.copyProperties((Object)((Object)purchaseRecContractAcceptance), (Object)((Object)saleRecContractAcceptance));
            saleRecContractAcceptance.setId(null);
            saleRecContractAcceptance.setElsAccount(saleReconciliation.getElsAccount());
            saleRecContractAcceptance.setToElsAccount(saleReconciliation.getToElsAccount());
            saleRecContractAcceptance.setBusAccount(saleReconciliation.getBusAccount());
            saleRecContractAcceptance.setHeadId(saleReconciliation.getId());
            saleRecContractAcceptance.setRelationId(purchaseRecContractAcceptance.getId());
            saleRecContractAcceptanceList.add(saleRecContractAcceptance);
        }
        this.saleRecContractAcceptanceMapper.insertBatchSomeColumn(saleRecContractAcceptanceList);
    }

    private void handleSaleRecContractPromiseDetail(SalePerformanceReconciliation saleReconciliation, List<PurchaseRecContractPromise> purchaseRecContractPromiseList) {
        if (CollectionUtils.isEmpty(purchaseRecContractPromiseList)) {
            return;
        }
        ArrayList<SaleRecContractPromise> saleRecContractPromiseList = new ArrayList<SaleRecContractPromise>();
        for (PurchaseRecContractPromise purchaseRecContractPromise : purchaseRecContractPromiseList) {
            SaleRecContractPromise saleRecContractPromise = new SaleRecContractPromise();
            BeanUtils.copyProperties((Object)((Object)purchaseRecContractPromise), (Object)((Object)saleRecContractPromise));
            saleRecContractPromise.setId(null);
            saleRecContractPromise.setElsAccount(saleReconciliation.getElsAccount());
            saleRecContractPromise.setToElsAccount(saleReconciliation.getToElsAccount());
            saleRecContractPromise.setBusAccount(saleReconciliation.getBusAccount());
            saleRecContractPromise.setHeadId(saleReconciliation.getId());
            saleRecContractPromise.setRelationId(purchaseRecContractPromise.getId());
            saleRecContractPromiseList.add(saleRecContractPromise);
        }
        this.saleRecContractPromiseMapper.insertBatchSomeColumn(saleRecContractPromiseList);
    }

    private void handleSaleAttachmentDetail(SalePerformanceReconciliation saleReconciliation, List<PurchaseAttachmentDTO> attachments) {
        if (CollectionUtils.isEmpty(attachments)) {
            return;
        }
        ArrayList<SaleAttachmentDTO> saleAttachments = new ArrayList<SaleAttachmentDTO>();
        for (PurchaseAttachmentDTO purchaseAttachment : attachments) {
            purchaseAttachment.setSendStatus("1");
            SaleAttachmentDTO saleAttachment = new SaleAttachmentDTO();
            BeanUtils.copyProperties((Object)purchaseAttachment, (Object)saleAttachment);
            saleAttachment.setId(null);
            saleAttachment.setElsAccount(saleReconciliation.getElsAccount());
            saleAttachment.setHeadId(saleReconciliation.getId());
            saleAttachment.setRelationId(purchaseAttachment.getId());
            saleAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
            saleAttachments.add(saleAttachment);
        }
        this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn(saleAttachments);
    }

    private void handleSaleRecChargeDetail(SalePerformanceReconciliation saleReconciliation, List<PurchaseRecCharge> purchaseRecChargeList) {
        if (CollectionUtils.isEmpty(purchaseRecChargeList)) {
            return;
        }
        ArrayList<SaleRecCharge> saleRecCharges = new ArrayList<SaleRecCharge>();
        for (PurchaseRecCharge purchaseRecCharge : purchaseRecChargeList) {
            SaleRecCharge saleRecCharge = new SaleRecCharge();
            BeanUtils.copyProperties((Object)((Object)purchaseRecCharge), (Object)((Object)saleRecCharge));
            saleRecCharge.setId(null);
            saleRecCharge.setElsAccount(saleReconciliation.getElsAccount());
            saleRecCharge.setToElsAccount(saleReconciliation.getToElsAccount());
            saleRecCharge.setBusAccount(saleReconciliation.getBusAccount());
            saleRecCharge.setHeadId(saleReconciliation.getId());
            saleRecCharge.setRelationId(purchaseRecCharge.getId());
            saleRecCharges.add(saleRecCharge);
        }
        this.saleRecChargeMapper.insertBatchSomeColumn(saleRecCharges);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> invoiceRefusedOrConfirm(PurchasePerformanceReconciliation reconciliation, List<PurchaseInvoice> invoices, String operation) {
        String opt = "confirm";
        if ("refused".equals(operation)) {
            opt = "refund";
            reconciliation.setPurchaseInvoiceAffirmStatus(InvoiceConfirmStatusEnum.RENTURNED.getValue());
            reconciliation.setStatus(ReconciliationBillStatusEnum.INVOICE_RENTURNED.getValue());
        } else if ("confirm".equals(operation)) {
            reconciliation.setPurchaseInvoiceAffirmStatus(InvoiceConfirmStatusEnum.CONFIRMED.getValue());
            reconciliation.setStatus(ReconciliationBillStatusEnum.INVOICE_CONFIRMED.getValue());
            if (!CollectionUtils.isEmpty(invoices) && invoices.size() == 1) {
                PurchaseInvoiceHookVO hookVO = new PurchaseInvoiceHookVO();
                BeanUtils.copyProperties((Object)((Object)invoices.get(0)), (Object)((Object)hookVO));
                String id = reconciliation.getId();
                hookVO.setRecContractPromiseList(this.purchaseRecContractPromiseService.selectByMainId(id));
                hookVO.setRecContractAcceptanceList(this.purchaseRecContractAcceptanceService.selectByMainId(id));
                hookVO.setRecChargeList(this.purchaseRecChargeService.selectByMainId(id));
                hookVO.setPrePaymentWriteOffList(this.purchasePrePaymentWriteOffReconciliationService.selectByMainId(id));
                this.purchaseInvoiceHookInformationService.hook(hookVO);
            }
        }
        this.purchasePerformanceReconciliationMapper.updateById((Object)reconciliation);
        SalePerformanceReconciliation salePerformanceReconciliation = (SalePerformanceReconciliation)((Object)this.salePerformanceReconciliationMapper.selectById((Serializable)((Object)reconciliation.getRelationId())));
        if (salePerformanceReconciliation == null) {
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_tkLR_2f0866fe", (String)"\u64cd\u4f5c\u6210\u529f"));
        }
        salePerformanceReconciliation.setPurchaseInvoiceAffirmStatus(reconciliation.getPurchaseInvoiceAffirmStatus());
        salePerformanceReconciliation.setPurchaseRemark(reconciliation.getPurchaseRemark());
        BigDecimal invoiceTotalAmount = this.saleInvoiceService.invoiceRefusedOrConfirm(invoices, operation);
        if (OperationEnum.CONFIRM.getValue().equals(operation)) {
            salePerformanceReconciliation.setTotalInvoiceAmount(invoiceTotalAmount);
            salePerformanceReconciliation.setStatus(ReconciliationBillStatusEnum.INVOICE_CONFIRMED.getValue());
            String url = "id=" + salePerformanceReconciliation.getId() + "&createAccount=" + salePerformanceReconciliation.getCreateAccount();
            super.sendMessage(reconciliation.getElsAccount(), "invoice", opt, reconciliation.getId(), "performanceReconciliationBusDataServiceImpl", Arrays.asList(reconciliation.getToElsAccount()));
        } else {
            salePerformanceReconciliation.setStatus(ReconciliationBillStatusEnum.INVOICE_RENTURNED.getValue());
        }
        this.salePerformanceReconciliationMapper.updateById((Object)salePerformanceReconciliation);
        this.addPurchaseAttachmentFromOCRInfo(reconciliation, invoices);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_tkLR_2f0866fe", (String)"\u64cd\u4f5c\u6210\u529f"));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> refusedOrConfirm(PurchasePerformanceReconciliation reconciliation, String operation) {
        String opt = "confirm";
        if (OperationEnum.REFUSED.getValue().equals(operation)) {
            reconciliation.setSaleRecAffirmStatus(SaleStatusEmun.REFUSED.getValue());
            reconciliation.setStatus(ReconciliationBillStatusEnum.PURCHASDE_REFUSED.getValue());
            opt = "refund";
            this.elsPurchaseStatisticsWriteOffService.cancelReleaseAmountFromSale(reconciliation.getRelationId());
        } else if (OperationEnum.CONFIRM.getValue().equals(operation)) {
            reconciliation.setSaleRecAffirmStatus(SaleStatusEmun.COMFIRMED.getValue());
            BigDecimal closingAmount = reconciliation.getClosingAmount();
            if (closingAmount != null && closingAmount.compareTo(BigDecimal.ZERO) > 0) {
                reconciliation.setStatus(ReconciliationBillStatusEnum.UNINVOICE.getValue());
            }
            if (closingAmount != null && closingAmount.compareTo(BigDecimal.ZERO) <= 0) {
                reconciliation.setStatus(ReconciliationBillStatusEnum.NOINVOICE.getValue());
            }
        }
        SalePerformanceReconciliation saleReconciliation = (SalePerformanceReconciliation)((Object)this.salePerformanceReconciliationMapper.selectById((Serializable)((Object)reconciliation.getRelationId())));
        if (saleReconciliation == null) {
            throw new ELSBootException("\u5bf9\u5e94\u7684\u9500\u552e\u5bf9\u8d26\u4e0d\u5b58\u5728\uff0c\u65e0\u6cd5\u786e\u8ba4\u6216\u62d2\u7edd");
        }
        this.purchasePerformanceReconciliationMapper.updateById((Object)reconciliation);
        SalePerformanceReconciliation salePerformanceReconciliation = new SalePerformanceReconciliation();
        BeanUtils.copyProperties((Object)((Object)reconciliation), (Object)((Object)salePerformanceReconciliation));
        salePerformanceReconciliation.setId(saleReconciliation.getId());
        salePerformanceReconciliation.setElsAccount(saleReconciliation.getElsAccount());
        salePerformanceReconciliation.setToElsAccount(saleReconciliation.getToElsAccount());
        salePerformanceReconciliation.setBusAccount(saleReconciliation.getBusAccount());
        salePerformanceReconciliation.setRelationId(reconciliation.getId());
        salePerformanceReconciliation.setDataVersion(saleReconciliation.getDataVersion());
        salePerformanceReconciliation.setStatus(reconciliation.getStatus());
        this.salePerformanceReconciliationMapper.updateById((Object)salePerformanceReconciliation);
        super.sendMessage(reconciliation.getElsAccount(), "salePerformanceReconciliation", opt, reconciliation.getId(), "performanceReconciliationBusDataServiceImpl", Arrays.asList(reconciliation.getToElsAccount()));
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_tkLR_2f0866fe", (String)"\u64cd\u4f5c\u6210\u529f"));
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void cancellation(String id) {
        PurchasePerformanceReconciliation purchaseReconciliation = (PurchasePerformanceReconciliation)((Object)this.purchasePerformanceReconciliationMapper.selectById((Serializable)((Object)id)));
        if (purchaseReconciliation == null) {
            return;
        }
        String createAccount = purchaseReconciliation.getCreateAccount();
        String elsAccount = purchaseReconciliation.getElsAccount();
        if (!StringUtils.isEmpty((CharSequence)elsAccount) && elsAccount.equals(createAccount)) {
            this.elsPurchaseStatisticsWriteOffService.cancelReleaseAmountByPurchase(id);
        } else {
            this.elsPurchaseStatisticsWriteOffService.cancelReleaseAmountFromSale(purchaseReconciliation.getRelationId());
        }
        this.cancelReconciliation(id);
        this.cancelContractPromise(id, null);
        this.cancelContractAcceptance(id, null);
        this.cancelCharges(id, null);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveInvoice(PurchasePerformanceReconciliation reconciliation, List<PurchaseInvoice> purchaseInvoiceList, String operation) {
        this.purchaseInvoiceMapper.deleteByMainId(reconciliation.getId());
        this.saleInvoiceMapper.deleteByMainId(reconciliation.getRelationId());
        SalePerformanceReconciliation salePerformanceReconciliation = (SalePerformanceReconciliation)((Object)this.salePerformanceReconciliationMapper.selectById((Serializable)((Object)reconciliation.getRelationId())));
        this.purchaseInvoiceService.savePerformanceReconcilationInvoice(purchaseInvoiceList, reconciliation, salePerformanceReconciliation);
        reconciliation.setInvoiced("1");
        this.purchasePerformanceReconciliationMapper.updateById((Object)reconciliation);
        salePerformanceReconciliation.setInvoiced("1");
        this.salePerformanceReconciliationMapper.updateById((Object)salePerformanceReconciliation);
        this.addPurchaseAttachmentFromOCRInfo(reconciliation, purchaseInvoiceList);
    }

    @Override
    public void delMain(String id) {
        this.cancelContractPromise(id, null);
        this.cancelContractAcceptance(id, null);
        this.cancelCharges(id, null);
        this.deleteDetail(id);
        this.purchasePerformanceReconciliationMapper.deleteById((Serializable)((Object)id));
    }

    @Override
    public PurchasePerformanceReconciliationVO queryReconciliationItemList(PurchasePerformanceReconciliation purchaseReconciliation, String id) {
        PurchasePerformanceReconciliationVO purchaseReconciliationVO = new PurchasePerformanceReconciliationVO();
        PurchaseInvoice purchaseInvoice = (PurchaseInvoice)((Object)this.purchaseInvoiceService.getById((Serializable)((Object)id)));
        String reconciliationNumber = purchaseInvoice.getReconciliationNumber();
        LambdaQueryWrapper reconciliationLambdaQueryWrapper = new LambdaQueryWrapper();
        reconciliationLambdaQueryWrapper.eq(PurchasePerformanceReconciliation::getReconciliationNumber, (Object)reconciliationNumber);
        PurchasePerformanceReconciliation reconciliation = (PurchasePerformanceReconciliation)((Object)this.getOne((Wrapper)reconciliationLambdaQueryWrapper));
        if (reconciliation == null) {
            return purchaseReconciliationVO;
        }
        List<PurchaseRecCharge> purchaseRecChargeList = this.purchaseRecChargeService.selectByMainId(reconciliation.getId());
        List<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList = this.purchasePrePaymentWriteOffReconciliationService.selectByMainId(reconciliation.getId());
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = this.purchaseRecContractAcceptanceService.selectByMainId(reconciliation.getId());
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = this.purchaseRecContractPromiseService.selectByMainId(reconciliation.getId());
        if (!StringUtils.isEmpty((CharSequence)reconciliation.getReconciliationNumber())) {
            PurchaseInvoiceHookVO vo = PurchaseInvoiceHookVO.builder().build();
            vo.setRecContractPromiseList(purchaseRecContractPromiseList);
            vo.setRecContractAcceptanceList(purchaseRecContractAcceptanceList);
            vo.setRecChargeList(purchaseRecChargeList);
            vo.setPrePaymentWriteOffList(purchasePrePaymentWriteOffList);
            this.purchaseInvoiceHookInformationService.handleBusinessList(vo, reconciliation.getReconciliationNumber());
        }
        purchaseReconciliationVO.setRecContractPromiseList(purchaseRecContractPromiseList);
        purchaseReconciliationVO.setRecContractAcceptanceList(purchaseRecContractAcceptanceList);
        purchaseReconciliationVO.setPrePaymentWriteOffList(purchasePrePaymentWriteOffList);
        purchaseReconciliationVO.setRecChargeList(purchaseRecChargeList);
        purchaseReconciliationVO.setHookStatus(purchaseReconciliation.getHookStatus());
        return purchaseReconciliationVO;
    }

    @SrmTransaction
    public void addPurchaseAttachmentFromOCRInfo(PurchasePerformanceReconciliation reconciliation, List<PurchaseInvoice> purchaseInvoiceList) {
        List<PurchaseAttachmentDTO> addAttachmentDTOList;
        List attachmentDTOList;
        List attachmentIds;
        List saleAttachmentDTOList;
        List attachmentIds2;
        SalePerformanceReconciliation saleReconciliation;
        List allAttachmentIds;
        List allAttachmentDTOList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(reconciliation.getId());
        if (CollUtil.isNotEmpty(purchaseInvoiceList) && CollUtil.isNotEmpty(allAttachmentIds = allAttachmentDTOList.stream().filter(x -> "invoiceOCR".equals(x.getBusinessType())).map(m -> m.getId()).distinct().collect(Collectors.toList()))) {
            this.invokeBaseRpcService.deletePurchaseAttachmentByBatchId(allAttachmentIds);
        }
        if ((saleReconciliation = (SalePerformanceReconciliation)((Object)this.salePerformanceReconciliationMapper.selectById((Serializable)((Object)reconciliation.getRelationId())))) != null && CollUtil.isNotEmpty(attachmentIds2 = (saleAttachmentDTOList = this.invokeBaseRpcService.selectSaleAttachmentByMainId(saleReconciliation.getId())).stream().filter(x -> "invoiceOCR".equals(x.getBusinessType())).map(m -> m.getId()).distinct().collect(Collectors.toList()))) {
            this.invokeBaseRpcService.deleteSaleAttachmentByBatchId(attachmentIds2);
        }
        if (CollUtil.isNotEmpty(purchaseInvoiceList) && CollUtil.isNotEmpty(attachmentIds = purchaseInvoiceList.stream().filter(p -> StringUtils.isNotBlank((CharSequence)p.getInvoiceImg())).map(p -> p.getInvoiceImg().split("-")[0]).distinct().collect(Collectors.toList())) && CollUtil.isNotEmpty((Collection)(attachmentDTOList = this.invokeBaseRpcService.listPurchaseFiles(attachmentIds))) && CollUtil.isNotEmpty(addAttachmentDTOList = attachmentDTOList.stream().filter(a -> !a.getHeadId().equals(reconciliation.getId()) && "invoiceOCR".equals(a.getBusinessType())).collect(Collectors.toList()))) {
            addAttachmentDTOList.forEach(x -> {
                x.setId(null);
                x.setHeadId(reconciliation.getId());
                x.setRelationId(reconciliation.getId());
                x.setElsAccount(TenantContext.getTenant());
                x.setSourceNumber(reconciliation.getReconciliationNumber());
            });
            this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(addAttachmentDTOList);
            if (saleReconciliation != null) {
                ArrayList attachmentList = SysUtil.copyProperties(addAttachmentDTOList, SaleAttachmentDTO.class);
                attachmentList.forEach(x -> {
                    x.setId(null);
                    x.setElsAccount(saleReconciliation.getElsAccount());
                    x.setHeadId(saleReconciliation.getId());
                    x.setRelationId(reconciliation.getId());
                    x.setSourceNumber(saleReconciliation.getReconciliationNumber());
                });
                this.invokeBaseRpcService.insertSaleAttachmentBatchSomeColumn((List)attachmentList);
            }
        }
    }

    private void cancelReconciliation(String id) {
        PurchasePerformanceReconciliation purchasePerformanceReconciliation = (PurchasePerformanceReconciliation)((Object)this.purchasePerformanceReconciliationMapper.selectById((Serializable)((Object)id)));
        purchasePerformanceReconciliation.setCancellation("1");
        LoginUser loginUser = SysUtil.getLoginUser();
        purchasePerformanceReconciliation.setCancellationSubAccount(loginUser.getSubAccount());
        purchasePerformanceReconciliation.setCancellationName(loginUser.getRealname());
        purchasePerformanceReconciliation.setCancellationTime(new Date());
        purchasePerformanceReconciliation.setStatus(ReconciliationBillStatusEnum.RENTURNED.getValue());
        this.purchasePerformanceReconciliationMapper.updateById((Object)purchasePerformanceReconciliation);
        SalePerformanceReconciliation salePerformanceReconciliation = (SalePerformanceReconciliation)((Object)this.salePerformanceReconciliationMapper.selectById((Serializable)((Object)purchasePerformanceReconciliation.getRelationId())));
        salePerformanceReconciliation.setCancellationName(purchasePerformanceReconciliation.getCancellationName());
        salePerformanceReconciliation.setCancellationSubAccount(purchasePerformanceReconciliation.getCancellationSubAccount());
        salePerformanceReconciliation.setCancellationTime(purchasePerformanceReconciliation.getCancellationTime());
        salePerformanceReconciliation.setCancellation("1");
        salePerformanceReconciliation.setStatus(purchasePerformanceReconciliation.getStatus());
        this.salePerformanceReconciliationMapper.updateById((Object)salePerformanceReconciliation);
    }

    private void insertDeductCost(PurchasePerformanceReconciliation reconciliation, List<PurchaseRecCharge> purchaseRecChargeList) {
        if (CollectionUtils.isEmpty(purchaseRecChargeList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
        ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
        for (PurchaseRecCharge entity : purchaseRecChargeList) {
            entity.setHeadId(reconciliation.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)reconciliation);
            entity.setReconciliationNumber(reconciliation.getReconciliationNumber());
            entity.setItemNumber(String.valueOf(itemNumber));
            entity.setId(null);
            PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)entity.getBusinessId())));
            deductCost.setDeductStatus("1");
            deductCost.setReconciliationNumber(reconciliation.getReconciliationNumber());
            deductCosts.add(deductCost);
            SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)deductCost.getRelationId())));
            saleDeductCost.setDeductStatus("1");
            saleDeductCost.setReconciliationNumber(reconciliation.getReconciliationNumber());
            saleDeductCosts.add(saleDeductCost);
            ++itemNumber;
        }
        this.purchaseRecChargeService.saveBatch(purchaseRecChargeList, 2000);
        if (!deductCosts.isEmpty()) {
            this.purchaseDeductCostService.updateBatchById(deductCosts);
        }
        if (!saleDeductCosts.isEmpty()) {
            this.saleDeductCostService.updateBatchById(saleDeductCosts);
        }
    }

    private void insertPrePaymentWriteOff(PurchasePerformanceReconciliation reconciliation, List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList) {
        if (CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList = new ArrayList<PurchasePrePaymentWriteOffReconciliation>();
        for (PurchasePrePaymentWriteOffReconciliation prePaymentWriteOff : prePaymentWriteOffList) {
            prePaymentWriteOff.setHeadId(reconciliation.getId());
            SysUtil.setSysParam((BaseEntity)prePaymentWriteOff, (BaseEntity)reconciliation);
            prePaymentWriteOff.setReconciliationNumber(reconciliation.getReconciliationNumber());
            prePaymentWriteOff.setItemNumber(String.valueOf(itemNumber));
            prePaymentWriteOff.setToElsAccount(reconciliation.getToElsAccount());
            prePaymentWriteOff.setId(null);
            purchasePrePaymentWriteOffList.add(prePaymentWriteOff);
            ++itemNumber;
        }
        if (!CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            this.purchasePrePaymentWriteOffReconciliationService.saveBatch(prePaymentWriteOffList, 2000);
        }
    }

    private void insertContractAcceptance(PurchasePerformanceReconciliation reconciliation, List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList) {
        if (CollectionUtils.isEmpty(purchaseRecContractAcceptanceList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<PurchaseContractAcceptanceDTO> purchaseContractAcceptanceList = new ArrayList<PurchaseContractAcceptanceDTO>();
        ArrayList<SaleContractAcceptanceDTO> saleContractAcceptanceList = new ArrayList<SaleContractAcceptanceDTO>();
        for (PurchaseRecContractAcceptance purchaseRecContractAcceptance : purchaseRecContractAcceptanceList) {
            purchaseRecContractAcceptance.setHeadId(reconciliation.getId());
            SysUtil.setSysParam((BaseEntity)purchaseRecContractAcceptance, (BaseEntity)reconciliation);
            purchaseRecContractAcceptance.setReconciliationNumber(reconciliation.getReconciliationNumber());
            purchaseRecContractAcceptance.setItemNumber(String.valueOf(itemNumber));
            PurchaseContractAcceptanceDTO contractAcceptance = this.purchaseContractAcceptanceLocalRpcService.getById(purchaseRecContractAcceptance.getBusinessId());
            if (contractAcceptance != null) {
                contractAcceptance.setCostStatus("1");
                contractAcceptance.setReconciliationNumber(reconciliation.getReconciliationNumber());
                purchaseRecContractAcceptance.setId(null);
                purchaseContractAcceptanceList.add(contractAcceptance);
                SaleContractAcceptanceDTO saleContractAcceptance = this.saleContractAcceptanceLocalRpcService.getById(contractAcceptance.getRelationId());
                saleContractAcceptance.setCostStatus("1");
                saleContractAcceptance.setReconciliationNumber(reconciliation.getReconciliationNumber());
                saleContractAcceptanceList.add(saleContractAcceptance);
            }
            ++itemNumber;
        }
        if (!CollectionUtils.isEmpty(purchaseRecContractAcceptanceList)) {
            this.purchaseRecContractAcceptanceService.saveBatch(purchaseRecContractAcceptanceList);
        }
        if (!CollectionUtils.isEmpty(purchaseContractAcceptanceList)) {
            this.purchaseContractAcceptanceLocalRpcService.updatePurchaseContractAcceptanceItemListById(purchaseContractAcceptanceList);
        }
        if (!CollectionUtils.isEmpty(saleContractAcceptanceList)) {
            this.saleContractAcceptanceLocalRpcService.updateSaleContractAcceptanceItemListById(saleContractAcceptanceList);
        }
    }

    private void insertContractPromise(PurchasePerformanceReconciliation reconciliation, List<PurchaseRecContractPromise> purchaseRecContractPromiseList) {
        if (CollectionUtils.isEmpty(purchaseRecContractPromiseList)) {
            return;
        }
        ArrayList<PurchaseContractPromiseDTO> purchaseContractPromiseList = new ArrayList<PurchaseContractPromiseDTO>();
        ArrayList<SaleContractPromiseDTO> saleContractPromiseList = new ArrayList<SaleContractPromiseDTO>();
        int itemNumber = 1;
        for (PurchaseRecContractPromise purchaseRecContractPromise : purchaseRecContractPromiseList) {
            purchaseRecContractPromise.setHeadId(reconciliation.getId());
            SysUtil.setSysParam((BaseEntity)purchaseRecContractPromise, (BaseEntity)reconciliation);
            purchaseRecContractPromise.setReconciliationNumber(reconciliation.getReconciliationNumber());
            purchaseRecContractPromise.setItemNumber(String.valueOf(itemNumber));
            PurchaseContractPromiseDTO contractPromise = this.purchaseContractPromiseLocalRpcService.getById(purchaseRecContractPromise.getBusinessId());
            if (contractPromise != null) {
                contractPromise.setReconciliationStatus("1");
                contractPromise.setReconciliationNumber(reconciliation.getReconciliationNumber());
                purchaseRecContractPromise.setId(null);
                purchaseContractPromiseList.add(contractPromise);
                SaleContractPromiseDTO saleContractPromise = this.saleContractPromiseLocalRpcService.getById(contractPromise.getRelationId());
                saleContractPromise.setReconciliationStatus("1");
                saleContractPromise.setReconciliationNumber(reconciliation.getReconciliationNumber());
                saleContractPromiseList.add(saleContractPromise);
            }
            ++itemNumber;
        }
        if (!CollectionUtils.isEmpty(purchaseRecContractPromiseList)) {
            this.purchaseRecContractPromiseService.saveBatch(purchaseRecContractPromiseList);
        }
        if (!CollectionUtils.isEmpty(purchaseContractPromiseList)) {
            this.purchaseContractPromiseLocalRpcService.updatePurchaseContractPromiseItemListById(purchaseContractPromiseList);
        }
        if (!CollectionUtils.isEmpty(saleContractPromiseList)) {
            this.saleContractPromiseLocalRpcService.updateSaleContractPromiseItemListById(saleContractPromiseList);
        }
    }

    private void cancelContractAcceptance(String id, List<String> existIds) {
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = this.purchaseRecContractAcceptanceService.selectByMainId(id);
        if (CollectionUtils.isEmpty(purchaseRecContractAcceptanceList)) {
            return;
        }
        ArrayList<PurchaseContractAcceptanceDTO> purchaseContractAcceptanceList = new ArrayList<PurchaseContractAcceptanceDTO>();
        ArrayList<SaleContractAcceptanceDTO> saleContractAcceptanceList = new ArrayList<SaleContractAcceptanceDTO>();
        for (PurchaseRecContractAcceptance purchaseRecContractAcceptance : purchaseRecContractAcceptanceList) {
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(purchaseRecContractAcceptance.getBusinessId())) continue;
            PurchaseContractAcceptanceDTO purchaseContractAcceptance = this.purchaseContractAcceptanceLocalRpcService.getById(purchaseRecContractAcceptance.getBusinessId());
            if (purchaseContractAcceptance != null && !StringUtils.isEmpty((CharSequence)purchaseContractAcceptance.getId())) {
                this.handleContractAcceptanceFromPurchase(purchaseContractAcceptanceList, saleContractAcceptanceList, purchaseContractAcceptance);
                continue;
            }
            this.handleContractAcceptanceFromSale(purchaseContractAcceptanceList, saleContractAcceptanceList, purchaseRecContractAcceptance);
        }
        if (!CollectionUtils.isEmpty(purchaseContractAcceptanceList)) {
            this.purchaseContractAcceptanceLocalRpcService.updatePurchaseContractAcceptanceItemListById(purchaseContractAcceptanceList);
        }
        if (!CollectionUtils.isEmpty(saleContractAcceptanceList)) {
            this.saleContractAcceptanceLocalRpcService.updateSaleContractAcceptanceItemListById(saleContractAcceptanceList);
        }
    }

    private void handleContractAcceptanceFromSale(List<PurchaseContractAcceptanceDTO> purchaseContractAcceptanceList, List<SaleContractAcceptanceDTO> saleContractAcceptanceList, PurchaseRecContractAcceptance purchaseRecContractAcceptance) {
        SaleContractAcceptanceDTO saleContractAcceptance = this.saleContractAcceptanceLocalRpcService.getById(purchaseRecContractAcceptance.getBusinessId());
        if (saleContractAcceptance == null) {
            return;
        }
        saleContractAcceptance.setCostStatus("0");
        saleContractAcceptance.setReconciliationNumber(null);
        saleContractAcceptanceList.add(saleContractAcceptance);
        String relationId = saleContractAcceptance.getRelationId();
        if (StringUtils.isEmpty((CharSequence)relationId)) {
            return;
        }
        PurchaseContractAcceptanceDTO purchaseContractAcceptance = this.purchaseContractAcceptanceLocalRpcService.getById(relationId);
        if (purchaseContractAcceptance == null) {
            return;
        }
        purchaseContractAcceptance.setCostStatus("0");
        purchaseContractAcceptance.setReconciliationNumber(null);
        purchaseContractAcceptanceList.add(purchaseContractAcceptance);
    }

    private void handleContractAcceptanceFromPurchase(List<PurchaseContractAcceptanceDTO> purchaseContractAcceptanceList, List<SaleContractAcceptanceDTO> saleContractAcceptanceList, PurchaseContractAcceptanceDTO purchaseContractAcceptance) {
        purchaseContractAcceptance.setCostStatus("0");
        purchaseContractAcceptance.setReconciliationNumber(null);
        purchaseContractAcceptanceList.add(purchaseContractAcceptance);
        String relationId = purchaseContractAcceptance.getRelationId();
        if (StringUtils.isEmpty((CharSequence)relationId)) {
            return;
        }
        SaleContractAcceptanceDTO saleContractAcceptance = this.saleContractAcceptanceLocalRpcService.getById(relationId);
        if (saleContractAcceptance == null) {
            return;
        }
        saleContractAcceptance.setCostStatus("0");
        saleContractAcceptance.setReconciliationNumber(null);
        saleContractAcceptanceList.add(saleContractAcceptance);
    }

    private void cancelContractPromise(String id, List<String> existIds) {
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = this.purchaseRecContractPromiseService.selectByMainId(id);
        if (CollectionUtils.isEmpty(purchaseRecContractPromiseList)) {
            return;
        }
        ArrayList<PurchaseContractPromiseDTO> contractPromiseList = new ArrayList<PurchaseContractPromiseDTO>();
        ArrayList<SaleContractPromiseDTO> saleContractPromiseList = new ArrayList<SaleContractPromiseDTO>();
        for (PurchaseRecContractPromise purchaseRecContractPromise : purchaseRecContractPromiseList) {
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(purchaseRecContractPromise.getBusinessId())) continue;
            PurchaseContractPromiseDTO contractPromise = this.purchaseContractPromiseLocalRpcService.getById(purchaseRecContractPromise.getBusinessId());
            if (contractPromise != null && !StringUtils.isEmpty((CharSequence)contractPromise.getId())) {
                this.handleContractPromiseFromPurchase(contractPromiseList, saleContractPromiseList, contractPromise);
                continue;
            }
            this.handleContractPromiseFromSale(contractPromiseList, saleContractPromiseList, purchaseRecContractPromise);
        }
        if (!CollectionUtils.isEmpty(contractPromiseList)) {
            this.purchaseContractPromiseLocalRpcService.updatePurchaseContractPromiseItemListById(contractPromiseList);
        }
        if (!CollectionUtils.isEmpty(saleContractPromiseList)) {
            this.saleContractPromiseLocalRpcService.updateSaleContractPromiseItemListById(saleContractPromiseList);
        }
    }

    private void handleContractPromiseFromPurchase(List<PurchaseContractPromiseDTO> contractPromiseList, List<SaleContractPromiseDTO> saleContractPromiseList, PurchaseContractPromiseDTO contractPromise) {
        contractPromise.setReconciliationStatus("0");
        contractPromise.setReconciliationNumber(null);
        contractPromiseList.add(contractPromise);
        String relationId = contractPromise.getRelationId();
        if (StringUtils.isEmpty((CharSequence)relationId)) {
            return;
        }
        SaleContractPromiseDTO saleContractPromise = this.saleContractPromiseLocalRpcService.getById(relationId);
        if (saleContractPromise == null) {
            return;
        }
        saleContractPromise.setReconciliationStatus("0");
        saleContractPromise.setReconciliationNumber(null);
        saleContractPromiseList.add(saleContractPromise);
    }

    private void handleContractPromiseFromSale(List<PurchaseContractPromiseDTO> contractPromiseList, List<SaleContractPromiseDTO> saleContractPromiseList, PurchaseRecContractPromise purchaseRecContractPromise) {
        SaleContractPromiseDTO saleContractPromise = this.saleContractPromiseLocalRpcService.getById(purchaseRecContractPromise.getBusinessId());
        if (saleContractPromise == null) {
            return;
        }
        saleContractPromise.setReconciliationStatus("0");
        saleContractPromise.setReconciliationNumber(null);
        saleContractPromiseList.add(saleContractPromise);
        String relationId = saleContractPromise.getRelationId();
        if (StringUtils.isEmpty((CharSequence)relationId)) {
            return;
        }
        PurchaseContractPromiseDTO contractPromise = this.purchaseContractPromiseLocalRpcService.getById(relationId);
        if (contractPromise != null) {
            contractPromise.setReconciliationStatus("0");
            contractPromise.setReconciliationNumber(null);
            contractPromiseList.add(contractPromise);
        }
    }

    private void cancelCharges(String purchaseReconciliationId, List<String> existIds) {
        List<PurchaseRecCharge> charges = this.purchaseRecChargeService.selectByMainId(purchaseReconciliationId);
        if (CollectionUtils.isEmpty(charges)) {
            return;
        }
        ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
        ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
        for (PurchaseRecCharge charge : charges) {
            SaleDeductCost saleDeductCost;
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(charge.getBusinessId())) continue;
            PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)charge.getBusinessId())));
            if (deductCost != null) {
                deductCost.setDeductStatus("0");
                deductCost.setReconciliationNumber(null);
                deductCosts.add(deductCost);
                saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)deductCost.getRelationId())));
                saleDeductCost.setDeductStatus("0");
                saleDeductCost.setReconciliationNumber(null);
                saleDeductCosts.add(saleDeductCost);
            }
            if ((saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)charge.getBusinessId())))) == null) continue;
            saleDeductCost.setDeductStatus("0");
            saleDeductCost.setReconciliationNumber(null);
            saleDeductCosts.add(saleDeductCost);
            PurchaseDeductCost purchaseDeductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)saleDeductCost.getRelationId())));
            purchaseDeductCost.setDeductStatus("0");
            purchaseDeductCost.setReconciliationNumber(null);
            deductCosts.add(purchaseDeductCost);
        }
        if (!deductCosts.isEmpty()) {
            this.purchaseDeductCostService.updateBatchById(deductCosts);
        }
        if (!saleDeductCosts.isEmpty()) {
            this.saleDeductCostService.updateBatchById(saleDeductCosts);
        }
    }

    private List<PurchaseRecContractPromise> getPurchaseRecContractPromiseList(List<PurchaseContractPromiseDTO> purchaseContractPromiseList) {
        ArrayList<PurchaseRecContractPromise> list = new ArrayList<PurchaseRecContractPromise>();
        if (CollectionUtils.isEmpty(purchaseContractPromiseList)) {
            return list;
        }
        for (PurchaseContractPromiseDTO purchaseContractPromiseDTO : purchaseContractPromiseList) {
            PurchaseRecContractPromise dto = new PurchaseRecContractPromise();
            BeanUtils.copyProperties((Object)purchaseContractPromiseDTO, (Object)((Object)dto));
            dto.setMasterContractNumber(purchaseContractPromiseDTO.getContractNumber());
            dto.setContractParties(purchaseContractPromiseDTO.getSupplierName());
            dto.setContractPromise(purchaseContractPromiseDTO.getPerformingPartyName());
            dto.setContractDrawer(purchaseContractPromiseDTO.getInvoicedName());
            dto.setContractReceiver(purchaseContractPromiseDTO.getPayeeName());
            dto.setId(null);
            dto.setAmount(purchaseContractPromiseDTO.getAmount());
            dto.setBusinessId(purchaseContractPromiseDTO.getId());
            dto.setCurrency(purchaseContractPromiseDTO.getCurreny());
            list.add(dto);
        }
        return list;
    }

    private List<PurchaseRecContractAcceptance> getPurchaseRecContractAcceptanceList(List<PurchaseContractAcceptanceDTO> purchaseContractAcceptanceList) {
        ArrayList<PurchaseRecContractAcceptance> list = new ArrayList<PurchaseRecContractAcceptance>();
        for (PurchaseContractAcceptanceDTO purchaseContractAcceptanceDTO : purchaseContractAcceptanceList) {
            PurchaseRecContractAcceptance dto = new PurchaseRecContractAcceptance();
            BeanUtils.copyProperties((Object)purchaseContractAcceptanceDTO, (Object)((Object)dto));
            dto.setId(null);
            dto.setBusinessId(purchaseContractAcceptanceDTO.getId());
            list.add(dto);
        }
        return list;
    }

    @Override
    public void getDataByErp() {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "getPurchasePerformanceReconciliation", (Object)new JSONObject());
    }

    @Override
    public void pushDataToErp(String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List purchaseReconciliationList = this.listByIds(idList).stream().filter(head -> !"1".equals(head.getReturnState())).collect(Collectors.toList());
        for (PurchasePerformanceReconciliation reconciliation : purchaseReconciliationList) {
            this.pushDataToErp(reconciliation);
        }
    }

    private void pushDataToErp(PurchasePerformanceReconciliation reconciliation) {
        String elsAccount = TenantContext.getTenant();
        this.interfaceUtil.callInterface(elsAccount, "pushPurchasePerformanceReconciliation", (Object)reconciliation);
    }

    @Override
    public void copyData(String id) {
        PurchasePerformanceReconciliation purchaseReconciliation = (PurchasePerformanceReconciliation)((Object)this.purchasePerformanceReconciliationMapper.selectById((Serializable)((Object)id)));
        if (purchaseReconciliation == null) {
            return;
        }
        PurchasePerformanceReconciliation newReconciliation = new PurchasePerformanceReconciliation();
        newReconciliation.setToElsAccount(purchaseReconciliation.getToElsAccount());
        newReconciliation.setCreateAccount(purchaseReconciliation.getCreateAccount());
        newReconciliation.setPurchaseName(purchaseReconciliation.getPurchaseName());
        newReconciliation.setSupplierName(purchaseReconciliation.getSupplierName());
        newReconciliation.setBeginDate(purchaseReconciliation.getBeginDate());
        newReconciliation.setEndDate(purchaseReconciliation.getEndDate());
        newReconciliation.setCompany(purchaseReconciliation.getCompany());
        newReconciliation.setPurchaseOrg(purchaseReconciliation.getPurchaseOrg());
        newReconciliation.setSupplierCode(purchaseReconciliation.getSupplierCode());
        newReconciliation.setSalePrincipalPhone(purchaseReconciliation.getSalePrincipalPhone());
        newReconciliation.setPaymentClause(purchaseReconciliation.getPaymentClause());
        newReconciliation.setPaymentClauseDesc(purchaseReconciliation.getPaymentClauseDesc());
        newReconciliation.setTaxCode(purchaseReconciliation.getTaxCode());
        newReconciliation.setTaxRate(purchaseReconciliation.getTaxRate());
        newReconciliation.setCurrency(purchaseReconciliation.getCurrency());
        newReconciliation.setExchangeRate(purchaseReconciliation.getExchangeRate());
        newReconciliation.setPayWay(purchaseReconciliation.getPayWay());
        newReconciliation.setPayCycle(purchaseReconciliation.getPayCycle());
        newReconciliation.setPurchasePrincipal(purchaseReconciliation.getPurchasePrincipal());
        newReconciliation.setSalePrincipal(purchaseReconciliation.getSalePrincipal());
        newReconciliation.setPaymentBenchmarkDate(purchaseReconciliation.getPaymentBenchmarkDate());
        newReconciliation.setPaymentExpiredate(purchaseReconciliation.getPaymentExpiredate());
        newReconciliation.setTemplateNumber(purchaseReconciliation.getTemplateNumber());
        newReconciliation.setTemplateVersion(purchaseReconciliation.getTemplateVersion());
        newReconciliation.setTemplateName(purchaseReconciliation.getTemplateName());
        newReconciliation.setTemplateAccount(purchaseReconciliation.getTemplateAccount());
        newReconciliation.setSaveForZero(purchaseReconciliation.getSaveForZero());
        newReconciliation.setChargeCurrency(purchaseReconciliation.getChargeCurrency());
        newReconciliation.setIsTeamwork(purchaseReconciliation.getIsTeamwork());
        this.saveMainByCopy(newReconciliation);
    }

    private void saveMainByCopy(PurchasePerformanceReconciliation reconciliation) {
        this.buildPurchasePerformanceReconciliation(reconciliation);
        this.purchasePerformanceReconciliationMapper.insert((Object)reconciliation);
        this.invokeBaseRpcService.addStatusLog(reconciliation.getId(), ReconciliationStatusEmun.NEW.getValue(), "reconciliation", "inster");
    }

    @Override
    public Result<?> hookConfirm(PurchasePerformanceReconciliation purchaseReconciliation, List<PurchaseInvoice> purchaseInvoices) {
        PurchasePerformanceReconciliation reconciliation = (PurchasePerformanceReconciliation)((Object)this.purchasePerformanceReconciliationMapper.selectById((Serializable)((Object)purchaseReconciliation.getId())));
        if (reconciliation == null) {
            return Result.error((String)I18nUtil.translate((String)"i18n_field_YxuIetVH_ba87ff35", (String)"\u627e\u4e0d\u5230\u5bf9\u8d26\u5355\u4fe1\u606f"));
        }
        if (ReconciliationHookStatusEnum.CONFIRM.getValue().equals(reconciliation.getHookStatus())) {
            return Result.error((String)I18nUtil.translate((String)"i18n_alert_tFIRLRt_45d3a84e", (String)"\u5355\u636e\u5df2\u786e\u8ba4\u52fe\u7a3d"));
        }
        ReconciliationVO reconciliationVO = new ReconciliationVO();
        BeanUtils.copyProperties((Object)((Object)purchaseReconciliation), (Object)reconciliationVO);
        this.purchaseDeliveryWaterService.handleWaterData(purchaseInvoices, reconciliationVO);
        reconciliation.setHookStatus(ReconciliationHookStatusEnum.CONFIRM.getValue());
        this.updateById((Object)reconciliation);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_tkLR_2f0866fe", (String)"\u64cd\u4f5c\u6210\u529f"));
    }

    @Override
    public JSONObject getRequestDataById(String id) {
        PurchasePerformanceReconciliationVO purchasePerformanceReconciliationVO = this.getMessageById(id);
        Result result = Result.ok((Object)((Object)purchasePerformanceReconciliationVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }

    @Override
    public JSONArray getRequestDataById(List<String> ids) {
        ArrayList headVOArrayList = new ArrayList();
        ids.forEach(id -> headVOArrayList.add(this.getMessageById((String)id)));
        Result result = Result.ok(headVOArrayList);
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONArray)result.getResult();
    }

    @Override
    public JSONObject getDataById(String id) {
        PurchasePerformanceReconciliation purchasePerformanceReconciliation = (PurchasePerformanceReconciliation)((Object)this.getById((Serializable)((Object)id)));
        PurchasePerformanceReconciliationVO headVO = (PurchasePerformanceReconciliationVO)((Object)BeanUtil.copyProperties((Object)((Object)purchasePerformanceReconciliation), PurchasePerformanceReconciliationVO.class, (String[])new String[0]));
        Result result = Result.ok((Object)((Object)headVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }

    private PurchasePerformanceReconciliationVO getMessageById(String id) {
        PurchasePerformanceReconciliation purchasePerformanceReconciliation = (PurchasePerformanceReconciliation)((Object)this.getById((Serializable)((Object)id)));
        PurchasePerformanceReconciliationVO purchasePerformanceReconciliationVO = new PurchasePerformanceReconciliationVO();
        BeanUtils.copyProperties((Object)((Object)purchasePerformanceReconciliation), (Object)((Object)purchasePerformanceReconciliationVO));
        List<PurchaseRecContractPromise> purchaseRecContractPromiseList = this.purchaseRecContractPromiseMapper.selectByMainId(id);
        List<PurchaseRecContractAcceptance> purchaseRecContractAcceptanceList = this.purchaseRecContractAcceptanceMapper.selectByMainId(id);
        purchasePerformanceReconciliationVO.setRecContractPromiseList(purchaseRecContractPromiseList);
        purchasePerformanceReconciliationVO.setRecContractAcceptanceList(purchaseRecContractAcceptanceList);
        return purchasePerformanceReconciliationVO;
    }
}

