/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.FormCommit;
import com.els.common.aspect.annotation.PermissionDataOpt;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.finance.entity.PurchasePaymentApplyHead;
import com.els.modules.finance.entity.PurchasePaymentApplyItem;
import com.els.modules.finance.entity.PurchasePaymentApplyOther;
import com.els.modules.finance.entity.PurchasePaymentApplyWriteOff;
import com.els.modules.finance.enumerate.WriteOffStatusEnum;
import com.els.modules.finance.service.PurchasePaymentApplyHeadService;
import com.els.modules.finance.service.PurchasePaymentApplyItemService;
import com.els.modules.finance.service.PurchasePaymentApplyOtherService;
import com.els.modules.finance.service.PurchasePaymentApplyWriteOffService;
import com.els.modules.finance.service.SalePaymentApplyItemService;
import com.els.modules.finance.vo.PurchasePaymentApplyHeadVO;
import com.els.modules.reconciliation.entity.ElsPurchaseStatisticsSourceCase;
import com.els.modules.reconciliation.entity.ElsPurchaseStatisticsWriteOff;
import com.els.modules.reconciliation.entity.PurchasePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffService;
import com.els.modules.reconciliation.service.PurchasePaymentChargeService;
import com.els.modules.reconciliation.service.PurchasePrePaymentWriteOffReconciliationService;
import com.els.rpc.service.InvokeBaseRpcService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/finance/purchasePaymentApplyHead"})
@Api(tags={"\u91c7\u8d2d\u7533\u8bf7\u4ed8\u6b3e\u5934"})
public class PurchasePaymentApplyHeadController
extends BaseController<PurchasePaymentApplyHead, PurchasePaymentApplyHeadService> {
    private static final Logger log = LoggerFactory.getLogger(PurchasePaymentApplyHeadController.class);
    @Autowired
    private PurchasePaymentApplyHeadService purchasePaymentApplyHeadService;
    @Autowired
    private PurchasePaymentApplyItemService purchasePaymentApplyItemService;
    @Autowired
    private SalePaymentApplyItemService salePaymentApplyItemService;
    @Autowired
    private PurchasePaymentApplyOtherService purchasePaymentApplyOtherService;
    @Autowired
    private PurchasePaymentChargeService purchasePaymentChargeService;
    @Autowired
    private PurchasePaymentApplyWriteOffService purchasePaymentApplyWriteOffService;
    @Autowired
    private PurchasePrePaymentWriteOffReconciliationService purchasePrePaymentWriteOffReconciliationService;
    @Autowired
    private ElsPurchaseStatisticsWriteOffService elsPurchaseStatisticsWriteOffService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Autowired
    private RedisUtil redisUtil;
    private static final String LOCK_KEY = "srm_purchasePaymentApplyHead_";
    private static final Long LOCK_EXPIRE_TIME = 30000L;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"paymentApply#purchasePaymentApplyHead:list"})
    @PermissionDataView(businessType="paymentApply")
    public Result<?> queryPageList(PurchasePaymentApplyHead purchasePaymentApplyHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchasePaymentApplyHead), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchasePaymentApplyHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @SrmValidated
    @AutoLog(busModule="\u4ed8\u6b3e\u7533\u8bf7", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"paymentApply#purchasePaymentApplyHead:add"})
    @PermissionDataOpt(businessType="paymentApply", beanClass=PurchasePaymentApplyHeadService.class)
    @FormCommit
    public Result<?> add(@RequestBody PurchasePaymentApplyHeadVO purchasePaymentApplyHeadPage) {
        PurchasePaymentApplyHead purchasePaymentApplyHead = new PurchasePaymentApplyHead();
        BeanUtils.copyProperties((Object)((Object)purchasePaymentApplyHeadPage), (Object)((Object)purchasePaymentApplyHead));
        this.purchasePaymentApplyHeadService.saveMain(purchasePaymentApplyHead, purchasePaymentApplyHeadPage);
        return Result.ok((Object)((Object)purchasePaymentApplyHead));
    }

    @AutoLog(busModule="\u4ed8\u6b3e\u7533\u8bf7", value="\u4f5c\u5e9f")
    @ApiOperation(value="\u4f5c\u5e9f", notes="\u4f5c\u5e9f")
    @PostMapping(value={"/cancel"})
    @RequiresPermissions(value={"paymentApply#purchasePaymentApplyHead:cancel"})
    @PermissionDataOpt(businessType="paymentApply", beanClass=PurchasePaymentApplyHeadService.class)
    public Result<?> cancel(@RequestBody PurchasePaymentApplyHeadVO purchasePaymentApplyHeadPage) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, purchasePaymentApplyHeadPage.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APBVtiKRcsSTVBtk_4fa405f4", (String)"\u5f53\u524d\u4ed8\u6b3e\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.purchasePaymentApplyHeadService.cancel(purchasePaymentApplyHeadPage);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, purchasePaymentApplyHeadPage.getId());
        }
        return Result.ok();
    }

    @AutoLog(busModule="\u4ed8\u6b3e\u7533\u8bf7", value="\u540c\u6b65")
    @ApiOperation(value="\u540c\u6b65", notes="\u540c\u6b65")
    @PostMapping(value={"/synchr"})
    @RequiresPermissions(value={"paymentApply#purchasePaymentApplyHead:synchr"})
    @PermissionDataOpt(businessType="paymentApply", beanClass=PurchasePaymentApplyHeadService.class)
    public Result<?> synchr(@RequestBody PurchasePaymentApplyHeadVO purchasePaymentApplyHeadPage) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, purchasePaymentApplyHeadPage.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APBVtiKRcsSTVBtk_4fa405f4", (String)"\u5f53\u524d\u4ed8\u6b3e\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.purchasePaymentApplyHeadService.synchr(purchasePaymentApplyHeadPage);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, purchasePaymentApplyHeadPage.getId());
        }
        return Result.ok();
    }

    @SrmValidated
    @AutoLog(busModule="\u4ed8\u6b3e\u7533\u8bf7", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"paymentApply#purchasePaymentApplyHead:edit"})
    @PermissionDataOpt(businessType="paymentApply", beanClass=PurchasePaymentApplyHeadService.class)
    public Result<?> edit(@RequestBody PurchasePaymentApplyHeadVO purchasePaymentApplyHeadPage) {
        PurchasePaymentApplyHead purchasePaymentApplyHead = new PurchasePaymentApplyHead();
        BeanUtils.copyProperties((Object)((Object)purchasePaymentApplyHeadPage), (Object)((Object)purchasePaymentApplyHead));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, purchasePaymentApplyHeadPage.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APBVtiKRcsSTVBtk_4fa405f4", (String)"\u5f53\u524d\u4ed8\u6b3e\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.purchasePaymentApplyHeadService.updateMain(purchasePaymentApplyHead, purchasePaymentApplyHeadPage);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, purchasePaymentApplyHeadPage.getId());
        }
        String id = purchasePaymentApplyHead.getId();
        return this.queryById(id);
    }

    @SrmValidated
    @AutoLog(busModule="\u4ed8\u6b3e\u7533\u8bf7", value="\u4fdd\u5b58\u6838\u9500\u4fe1\u606f")
    @ApiOperation(value="\u4fdd\u5b58\u6838\u9500\u4fe1\u606f", notes="\u4fdd\u5b58\u6838\u9500\u4fe1\u606f")
    @PostMapping(value={"/updateWriteOff"})
    @RequiresPermissions(value={"paymentApply#purchasePaymentApplyHead:edit"})
    @PermissionDataOpt(businessType="paymentApply", beanClass=PurchasePaymentApplyHeadService.class)
    public Result<?> updateWriteOff(@RequestBody PurchasePaymentApplyHeadVO purchasePaymentApplyHeadPage) {
        PurchasePaymentApplyHead purchasePaymentApplyHead = new PurchasePaymentApplyHead();
        BeanUtils.copyProperties((Object)((Object)purchasePaymentApplyHeadPage), (Object)((Object)purchasePaymentApplyHead));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, purchasePaymentApplyHeadPage.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APBVtiKRcsSTVBtk_4fa405f4", (String)"\u5f53\u524d\u4ed8\u6b3e\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.purchasePaymentApplyHeadService.updateWriteOff(purchasePaymentApplyHead, purchasePaymentApplyHeadPage);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, purchasePaymentApplyHeadPage.getId());
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u4ed8\u6b3e\u7533\u8bf7-\u6838\u9500\u786e\u8ba4")
    @ApiOperation(value="\u6838\u9500\u786e\u8ba4", notes="\u6838\u9500\u786e\u8ba4")
    @PostMapping(value={"/confirmWriteOff"})
    @RequiresPermissions(value={"paymentApply#purchasePaymentApplyHead:edit"})
    public Result<?> confirmWriteOff(@RequestBody PurchasePaymentApplyHeadVO purchasePaymentApplyHeadPage) {
        PurchasePaymentApplyHead purchasePaymentApplyHead = new PurchasePaymentApplyHead();
        BeanUtils.copyProperties((Object)((Object)purchasePaymentApplyHeadPage), (Object)((Object)purchasePaymentApplyHead));
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, purchasePaymentApplyHeadPage.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APBVtiKRcsSTVBtk_4fa405f4", (String)"\u5f53\u524d\u4ed8\u6b3e\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.purchasePaymentApplyHeadService.confirmWriteOff(purchasePaymentApplyHead, purchasePaymentApplyHeadPage);
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, purchasePaymentApplyHeadPage.getId());
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u4ed8\u6b3e\u7533\u8bf7", value="\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"paymentApply#purchasePaymentApplyHead:delete"})
    @PermissionDataOpt(businessType="paymentApply", beanClass=PurchasePaymentApplyHeadService.class)
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchasePaymentApplyHeadService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"paymentApply#purchasePaymentApplyHead:view"})
    @BusinessModule(module="paymentApply")
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        PurchasePaymentApplyHead purchasePaymentApplyHead = (PurchasePaymentApplyHead)((Object)this.purchasePaymentApplyHeadService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchasePaymentApplyHeadVO purchasePaymentApplyHeadVO = new PurchasePaymentApplyHeadVO();
        BeanUtils.copyProperties((Object)((Object)purchasePaymentApplyHead), (Object)((Object)purchasePaymentApplyHeadVO));
        List<PurchasePaymentApplyItem> purchasePaymentApplyItemList = this.purchasePaymentApplyItemService.selectByMainId(id);
        this.handlePaymentInfo(purchasePaymentApplyItemList);
        purchasePaymentApplyHeadVO.setPaymentApplyItemList(purchasePaymentApplyItemList);
        purchasePaymentApplyHeadVO.setPaymentChargeList(this.purchasePaymentChargeService.selectByMainId(id));
        List<PurchasePaymentApplyWriteOff> purchasePaymentApplyWriteOffList = this.purchasePaymentApplyWriteOffService.selectByMainId(id);
        this.handleWriteOffInfo(purchasePaymentApplyWriteOffList);
        purchasePaymentApplyHeadVO.setPaymentApplyWriteOffList(purchasePaymentApplyWriteOffList);
        List<PurchasePaymentApplyOther> purchasePaymentApplyOthers = this.purchasePaymentApplyOtherService.selectByMainId(id);
        purchasePaymentApplyHeadVO.setPaymentApplyOtherList(purchasePaymentApplyOthers);
        List purchaseAttachmentList = this.invokeBaseRpcService.selectPurchaseAttachmentByMainId(id);
        purchasePaymentApplyHeadVO.setAttachmentList(purchaseAttachmentList);
        return Result.ok((Object)((Object)purchasePaymentApplyHeadVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u91c7\u8d2d\u7533\u8bf7\u4ed8\u6b3e\u5934id\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u4ed8\u6b3e\u884c", notes="\u901a\u8fc7\u91c7\u8d2d\u7533\u8bf7\u4ed8\u6b3e\u5934id\u67e5\u8be2\u91c7\u8d2d\u7533\u8bf7\u4ed8\u6b3e\u884c")
    @GetMapping(value={"/queryPurchasePaymentApplyItemByMainId"})
    @RequiresPermissions(value={"paymentApply#purchasePaymentApplyHead:view"})
    public Result<?> queryPurchasePaymentApplyItemListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchasePaymentApplyItem> purchasePaymentApplyItemList = this.purchasePaymentApplyItemService.selectByMainId(id);
        return Result.ok(purchasePaymentApplyItemList);
    }

    @ApiOperation(value="\u83b7\u53d6\u4e1a\u52a1\u5355\u636e", notes="\u83b7\u53d6\u4e1a\u52a1\u5355\u636e")
    @RequestMapping(value={"/getBusinessDocuments"}, method={RequestMethod.GET})
    @RequiresPermissions(value={"paymentApply#purchasePaymentApplyHead:getBusinessDocuments"})
    public Result<?> getBusinessDocuments(PurchasePaymentApplyHead head, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        return this.purchasePaymentApplyHeadService.getBusinessDocuments(head, pageNo, pageSize);
    }

    @ApiOperation(value="\u652f\u4ed8\u786e\u8ba4", notes="\u652f\u4ed8\u786e\u8ba4")
    @PostMapping(value={"/paymentConfirmation"})
    @RequiresPermissions(value={"paymentApply#purchasePaymentApplyHead:paymentConfirmation"})
    public Result<?> paymentConfirmation(@RequestBody PurchasePaymentApplyHeadVO purchasePaymentApplyHeadPage) {
        if (!this.redisUtil.tryGetDistributedLock(LOCK_KEY, purchasePaymentApplyHeadPage.getId(), LOCK_EXPIRE_TIME.longValue())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APBVtiKRcsSTVBtk_4fa405f4", (String)"\u5f53\u524d\u4ed8\u6b3e\u5355\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u65e0\u9700\u91cd\u590d\u64cd\u4f5c\uff01"));
        }
        try {
            this.purchasePaymentApplyHeadService.paymentConfirmation(purchasePaymentApplyHeadPage.getId());
        }
        catch (Exception e) {
            throw new ELSBootException(e.getMessage(), (Throwable)e, new String[0]);
        }
        finally {
            this.redisUtil.releaseDistributedLock(LOCK_KEY, purchasePaymentApplyHeadPage.getId());
        }
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u67e5\u8be2\u9884\u4ed8\u6b3e\u6838\u9500")
    @ApiOperation(value="\u67e5\u8be2\u9884\u4ed8\u6b3e\u6838\u9500", notes="\u67e5\u8be2\u9884\u4ed8\u6b3e\u6838\u9500")
    @GetMapping(value={"/getPurchasePrePaymentWriteOffReconciliationByIdList"})
    @RequiresPermissions(value={"paymentApply#purchasePaymentApplyHead:getPurchasePrePaymentWriteOffReconciliationByIdList"})
    public Result<?> getPurchasePrePaymentWriteOffReconciliationByIdList(@RequestParam(name="ids", required=true) String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        List<PurchasePrePaymentWriteOffReconciliation> prePaymentWriteOffList = this.purchasePrePaymentWriteOffReconciliationService.selectByMainIds(new HashSet<String>(idList));
        Set<String> businessIds = prePaymentWriteOffList.stream().filter(writeeOff -> !StringUtils.isEmpty((CharSequence)writeeOff.getBusinessId())).map(PurchasePrePaymentWriteOffReconciliation::getBusinessId).collect(Collectors.toSet());
        Map<String, ElsPurchaseStatisticsWriteOff> statisticsSourceMap = this.elsPurchaseStatisticsWriteOffService.getStatisticsSourceMap(businessIds);
        for (PurchasePrePaymentWriteOffReconciliation prePaymentWriteOff : prePaymentWriteOffList) {
            ElsPurchaseStatisticsWriteOff writeOff;
            String businessId;
            if (StringUtils.isEmpty((CharSequence)prePaymentWriteOff.getWriteOffStatus())) {
                prePaymentWriteOff.setWriteOffStatus(WriteOffStatusEnum.UN_WRITE_OFF.getValue());
            }
            if (StringUtils.isEmpty((CharSequence)(businessId = prePaymentWriteOff.getBusinessId())) || (writeOff = statisticsSourceMap.get(businessId)) == null) continue;
            prePaymentWriteOff.setUnWrittenOffAmount(writeOff.getSourceUnWrittenOffAmount());
            prePaymentWriteOff.setWrittenOffAmount(writeOff.getSourceWrittenOffAmount());
        }
        return Result.ok(prePaymentWriteOffList);
    }

    @SrmValidated
    @ApiOperation(value="\u590d\u5236", notes="\u590d\u5236")
    @GetMapping(value={"/copyData"})
    @RequiresPermissions(value={"paymentApply#purchasePaymentApplyHead:copy"})
    public Result<?> copyData(@RequestParam(name="id", required=true) String id) {
        this.purchasePaymentApplyHeadService.copyData(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u4ed8\u6b3e\u7533\u8bf7-\u63d0\u53d6\u9884\u4ed8\u6b3e\u5355", logType=2)
    @ApiOperation(value="\u63d0\u53d6\u9884\u4ed8\u6b3e\u5355", notes="\u63d0\u53d6\u9884\u4ed8\u6b3e\u5355")
    @PostMapping(value={"/extractAdvanceCharge"})
    @RequiresPermissions(value={"paymentApply#purchasePaymentApplyHead:extractAdvanceCharge"})
    @PermissionDataOpt(businessType="paymentApply", beanClass=PurchasePaymentApplyHeadService.class)
    public Result<?> extractAdvanceCharge(@RequestBody PurchasePaymentApplyHeadVO purchasePaymentApplyHeadPage) {
        PurchasePaymentApplyHeadVO purchasePaymentApplyHeadVO = this.purchasePaymentApplyHeadService.extractAdvanceCharge(purchasePaymentApplyHeadPage);
        return Result.ok((Object)((Object)purchasePaymentApplyHeadVO));
    }

    private void handlePaymentInfo(List<PurchasePaymentApplyItem> purchasePaymentApplyItemList) {
        if (!CollectionUtil.isEmpty(purchasePaymentApplyItemList)) {
            Map<String, ElsPurchaseStatisticsSourceCase> map = this.purchasePaymentApplyHeadService.getStatisticsSourceMap(purchasePaymentApplyItemList);
            for (PurchasePaymentApplyItem item : purchasePaymentApplyItemList) {
                ElsPurchaseStatisticsSourceCase sourceCase;
                if (StringUtils.isEmpty((CharSequence)item.getSourceId()) || (sourceCase = map.get(item.getSourceId())) == null) continue;
                if (sourceCase.getSourcePaymentAmount() != null) {
                    item.setItemPaymentAmount(sourceCase.getSourcePaymentAmount());
                }
                if (sourceCase.getSourcePaidAmount() == null) continue;
                item.setSourcePaidAmount(sourceCase.getSourcePaidAmount());
            }
        }
    }

    private void handleWriteOffInfo(List<PurchasePaymentApplyWriteOff> purchasePaymentApplyWriteOffList) {
        Set<String> businessIds = purchasePaymentApplyWriteOffList.stream().filter(writeOff -> !StringUtils.isEmpty((CharSequence)writeOff.getBusinessId())).map(PurchasePaymentApplyWriteOff::getBusinessId).collect(Collectors.toSet());
        Map<String, String> purchaseSaleIdsMap = this.salePaymentApplyItemService.exchangePurchaseSaleIds(purchasePaymentApplyWriteOffList);
        HashSet<String> purchaseBussiness = new HashSet<String>(purchaseSaleIdsMap.values());
        businessIds.addAll(purchaseBussiness);
        Map<String, ElsPurchaseStatisticsWriteOff> writeOffMap = this.elsPurchaseStatisticsWriteOffService.getStatisticsSourceMap(businessIds);
        for (PurchasePaymentApplyWriteOff writeOff2 : purchasePaymentApplyWriteOffList) {
            ElsPurchaseStatisticsWriteOff statisticsWriteOff;
            String businessId = writeOff2.getBusinessId();
            if (StringUtils.isEmpty((CharSequence)businessId) || !StringUtils.isEmpty((CharSequence)writeOff2.getReconciliationNumber()) && (writeOff2.getReconciliationNumber().contains("SR") || writeOff2.getReconciliationNumber().contains("SPR")) && StringUtils.isEmpty((CharSequence)(businessId = purchaseSaleIdsMap.get(businessId))) || (statisticsWriteOff = writeOffMap.get(businessId)) == null) continue;
            writeOff2.setUnWrittenOffAmount(statisticsWriteOff.getSourceUnWrittenOffAmount());
            writeOff2.setWrittenOffAmount(statisticsWriteOff.getSourceWrittenOffAmount());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2", notes="\u5217\u8868\u9875\u9875\u7b7e\u6570\u91cf\u67e5\u8be2")
    @GetMapping(value={"/counts"})
    @RequiresPermissions(value={"paymentApply#purchasePaymentApplyHead:list"})
    @PermissionDataView(businessType="paymentApply")
    public Result<?> queryTabsCount(PurchasePaymentApplyHead applyHead, HttpServletRequest req) {
        ArrayList<CountVO> result = new ArrayList<CountVO>();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)applyHead), (Map)req.getParameterMap());
        queryWrapper.select(new String[]{"payment_apply_status", "count(0) as participateQuantity"});
        queryWrapper.groupBy((Object)"payment_apply_status");
        List list = ((PurchasePaymentApplyHeadService)this.service).list((Wrapper)queryWrapper);
        Map<String, Integer> countMap = list.stream().collect(Collectors.toMap(PurchasePaymentApplyHead::getPaymentApplyStatus, PurchasePaymentApplyHead::getParticipateQuantity));
        Integer all = 0;
        for (Map.Entry<String, Integer> entry : countMap.entrySet()) {
            all = all + entry.getValue();
        }
        result.add(new CountVO(I18nUtil.translate((String)"i18n_title_all", (String)"\u5168\u90e8"), "paymentApplyStatus", null, all));
        List srmRectificationAppealStatus = this.invokeBaseRpcService.queryDictItemsByCode("srmPaymentApplyStatus", TenantContext.getTenant());
        for (DictDTO status : srmRectificationAppealStatus) {
            Integer total = countMap.get(status.getValue()) == null ? Integer.valueOf(0) : countMap.get(status.getValue());
            result.add(new CountVO(I18nUtil.translate((String)status.getTextI18nKey(), (String)status.getText()), "paymentApplyStatus", status.getValue(), total));
        }
        return Result.ok(result);
    }
}

