/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.modules.finance.api.enumerate.DeductCostTypeEnum;
import com.els.modules.reconciliation.entity.SaleRecCharge;
import com.els.modules.reconciliation.enumerate.third.NuonuoInvoiceLinePropertyEnum;
import com.els.modules.reconciliation.enumerate.third.NuonuoTaxFlagEnum;
import com.els.modules.reconciliation.mapper.SaleRecChargeMapper;
import com.els.modules.reconciliation.service.SaleRecChargeService;
import com.els.modules.reconciliation.vo.InvoiceDetailVO;
import com.els.modules.reconciliation.vo.SalePerformanceReconciliationVO;
import com.els.modules.reconciliation.vo.SaleReconciliationVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class SaleRecChargeServiceImpl
extends ServiceImpl<SaleRecChargeMapper, SaleRecCharge>
implements SaleRecChargeService {
    @Resource
    private SaleRecChargeMapper saleRecChargeMapper;

    @Override
    public List<SaleRecCharge> selectByMainId(String mainId) {
        return this.saleRecChargeMapper.selectByMainId(mainId);
    }

    @Override
    public void deleteByMainId(String mainId) {
        this.saleRecChargeMapper.deleteByMainId(mainId);
    }

    @Override
    public void checkReconcilationedCharge(SaleReconciliationVO saleReconciliationVO) {
        List<SaleRecCharge> recChargeList = saleReconciliationVO.getRecChargeList();
        if (CollectionUtil.isEmpty(recChargeList)) {
            return;
        }
        Set<String> saleCharges = recChargeList.stream().map(SaleRecCharge::getVoucherNumber).collect(Collectors.toSet());
        List<SaleRecCharge> items = this.saleRecChargeMapper.checkHasReconcilationed(saleCharges);
        List<SaleRecCharge> resultList = this.getIntersection(recChargeList, items);
        if (CollectionUtil.isEmpty(resultList)) {
            return;
        }
        String reconciliationNumber = saleReconciliationVO.getReconciliationNumber();
        if (CollectionUtil.isEmpty(resultList = resultList.stream().filter(item -> !item.getReconciliationNumber().contains(reconciliationNumber)).collect(Collectors.toList()))) {
            return;
        }
        List<SaleRecCharge> sourceList = this.getIntersection(resultList, recChargeList);
        Optional optional = sourceList.stream().findFirst();
        if (optional.isPresent()) {
            SaleRecCharge saleRecCharge = (SaleRecCharge)((Object)optional.get());
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VVRHWTyWWWWWIhxIeWVQG_d3c7fd99", (String)"\u6263\u6b3e\u660e\u7ec6 \u5e8f\u53f7${0} \u5df2\u53d1\u5e03\u5bf9\u8d26\uff0c\u8bf7\u5220\u9664", (String[])new String[]{saleRecCharge.getItemNumber()}));
        }
    }

    private List<SaleRecCharge> getIntersection(List<SaleRecCharge> targetList, List<SaleRecCharge> sourceList) {
        return sourceList.stream().filter(item -> targetList.stream().map(SaleRecCharge::getVoucherNumber).collect(Collectors.toList()).contains(item.getVoucherNumber())).collect(Collectors.toList());
    }

    @Override
    public void checkPerformanceReconcilationedCharge(SalePerformanceReconciliationVO saleReconciliationVO) {
        List<SaleRecCharge> recChargeList = saleReconciliationVO.getRecChargeList();
        if (CollectionUtil.isEmpty(recChargeList)) {
            return;
        }
        Set<String> saleCharges = recChargeList.stream().map(SaleRecCharge::getVoucherNumber).collect(Collectors.toSet());
        List<SaleRecCharge> items = this.saleRecChargeMapper.checkHasPerformanceReconcilationed(saleCharges);
        List<SaleRecCharge> resultList = this.getIntersection(recChargeList, items);
        if (CollectionUtil.isEmpty(resultList)) {
            return;
        }
        String reconciliationNumber = saleReconciliationVO.getReconciliationNumber();
        if (CollectionUtil.isEmpty(resultList = resultList.stream().filter(item -> !item.getReconciliationNumber().contains(reconciliationNumber)).collect(Collectors.toList()))) {
            return;
        }
        List<SaleRecCharge> sourceList = this.getIntersection(resultList, recChargeList);
        Optional optional = sourceList.stream().findFirst();
        if (optional.isPresent()) {
            SaleRecCharge saleRecCharge = (SaleRecCharge)((Object)optional.get());
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_VVRHWTyWWWWWIhxIeWVQG_d3c7fd99", (String)"\u6263\u6b3e\u660e\u7ec6 \u5e8f\u53f7${0} \u5df2\u53d1\u5e03\u5bf9\u8d26\uff0c\u8bf7\u5220\u9664", (String[])new String[]{saleRecCharge.getItemNumber()}));
        }
    }

    @Override
    public List<InvoiceDetailVO> billingRecCharge(List<SaleRecCharge> saleRecChargeList, List<InvoiceDetailVO> details) {
        if (CollectionUtils.isEmpty(saleRecChargeList)) {
            return details;
        }
        ArrayList<InvoiceDetailVO> chargeDetails = new ArrayList<InvoiceDetailVO>();
        for (SaleRecCharge charge : saleRecChargeList) {
            if (DeductCostTypeEnum.ACCOUNT_DEDUCTION.getValue().equals(charge.getDeductionType())) continue;
            InvoiceDetailVO detail = new InvoiceDetailVO();
            BigDecimal taxRate = charge.getTaxRate();
            if (taxRate != null) {
                detail.setTaxRate(taxRate.divide(new BigDecimal("100")) + "");
            }
            BigDecimal totalAmount = charge.getTotalAmount();
            BigDecimal totalNonTaxAmount = charge.getTotalNonTaxAmount();
            if (totalNonTaxAmount != null) {
                detail.setTaxExcludedAmount(totalNonTaxAmount + "");
                if (totalAmount != null) {
                    BigDecimal taxAmount = totalAmount.subtract(totalNonTaxAmount);
                    detail.setTax(taxAmount + "");
                    detail.setTaxIncludedAmount(totalAmount + "");
                }
            }
            detail.setWithTaxFlag(NuonuoTaxFlagEnum.TAX_NOT_INCLUDED.getValue());
            chargeDetails.add(detail);
        }
        ArrayList<InvoiceDetailVO> invoiceDetailList = new ArrayList<InvoiceDetailVO>();
        if (CollectionUtils.isEmpty(chargeDetails)) {
            return details;
        }
        BigDecimal totalTaxExcludedAmount = BigDecimal.ZERO;
        BigDecimal totalTaxIncludedAmount = BigDecimal.ZERO;
        BigDecimal totalTaxAmount = BigDecimal.ZERO;
        for (InvoiceDetailVO detail : details) {
            String taxIncludedAmount;
            String tax;
            String taxExcludedAmount = detail.getTaxExcludedAmount();
            if (!StringUtils.isEmpty((Object)taxExcludedAmount)) {
                BigDecimal taxExcludedAmountDecimal = new BigDecimal(taxExcludedAmount);
                totalTaxExcludedAmount = totalTaxExcludedAmount.add(taxExcludedAmountDecimal);
            }
            if (!StringUtils.isEmpty((Object)(tax = detail.getTax()))) {
                BigDecimal taxDecimal = new BigDecimal(tax);
                totalTaxAmount = totalTaxAmount.add(taxDecimal);
            }
            if (StringUtils.isEmpty((Object)(taxIncludedAmount = detail.getTaxIncludedAmount()))) continue;
            BigDecimal taxIncludedAmountDecimal = new BigDecimal(taxIncludedAmount);
            totalTaxIncludedAmount = totalTaxIncludedAmount.add(taxIncludedAmountDecimal);
        }
        BigDecimal totalNoTaxChargeAmount = BigDecimal.ZERO;
        BigDecimal totalTaxChargeAmount = BigDecimal.ZERO;
        for (InvoiceDetailVO chargeDetail : chargeDetails) {
            String taxIncludedAmount;
            String taxExcludedAmount = chargeDetail.getTaxExcludedAmount();
            if (!StringUtils.isEmpty((Object)taxExcludedAmount)) {
                totalNoTaxChargeAmount = totalNoTaxChargeAmount.add(new BigDecimal(taxExcludedAmount));
            }
            if (StringUtils.isEmpty((Object)(taxIncludedAmount = chargeDetail.getTaxIncludedAmount()))) continue;
            totalTaxChargeAmount = totalTaxChargeAmount.add(new BigDecimal(taxIncludedAmount));
        }
        BigDecimal currentNoTaxChargeAmount = BigDecimal.ZERO;
        BigDecimal currentTaxChargeAmount = BigDecimal.ZERO;
        for (int i = 0; i < details.size(); ++i) {
            InvoiceDetailVO detail = details.get(i);
            InvoiceDetailVO targetDetail = new InvoiceDetailVO();
            BeanUtils.copyProperties((Object)detail, (Object)targetDetail);
            InvoiceDetailVO antiDetail = new InvoiceDetailVO();
            BeanUtils.copyProperties((Object)detail, (Object)antiDetail);
            if (i != details.size() - 1) {
                String taxIncludedAmount = detail.getTaxIncludedAmount();
                if (!StringUtils.isEmpty((Object)taxIncludedAmount)) {
                    BigDecimal chargeTaxAmount = new BigDecimal(taxIncludedAmount).multiply(totalTaxChargeAmount).divide(totalTaxIncludedAmount, 6, 4);
                    antiDetail.setTaxIncludedAmount(chargeTaxAmount.negate() + "");
                    currentTaxChargeAmount = currentTaxChargeAmount.add(chargeTaxAmount);
                    if (!StringUtils.isEmpty((Object)detail.getTaxRate())) {
                        BigDecimal temp = BigDecimal.ONE.add(new BigDecimal(detail.getTaxRate()));
                        BigDecimal chargeNoTaxAmount = chargeTaxAmount.divide(temp, 6, 4);
                        antiDetail.setTaxExcludedAmount(chargeNoTaxAmount.negate() + "");
                        currentNoTaxChargeAmount = currentNoTaxChargeAmount.add(chargeNoTaxAmount);
                        BigDecimal chargeTaxAmout = chargeTaxAmount.subtract(chargeNoTaxAmount);
                        antiDetail.setTax(chargeTaxAmout.negate() + "");
                    }
                }
            } else {
                BigDecimal noTaxChargeAmount = totalNoTaxChargeAmount.subtract(currentNoTaxChargeAmount);
                BigDecimal taxChargeAmount = totalTaxChargeAmount.subtract(currentTaxChargeAmount);
                antiDetail.setTaxExcludedAmount(noTaxChargeAmount.negate() + "");
                antiDetail.setTaxIncludedAmount(taxChargeAmount.negate() + "");
                antiDetail.setTax(taxChargeAmount.subtract(noTaxChargeAmount).negate() + "");
            }
            targetDetail.setInvoiceLineProperty(NuonuoInvoiceLinePropertyEnum.DISCOUNTED_LINES.getValue());
            antiDetail.setInvoiceLineProperty(NuonuoInvoiceLinePropertyEnum.DISCOUNT_LINES.getValue());
            antiDetail.setPrice(null);
            antiDetail.setNum("");
            invoiceDetailList.add(targetDetail);
            invoiceDetailList.add(antiDetail);
        }
        return invoiceDetailList;
    }
}

