/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.reconciliation.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.aspect.DictAspect;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.MsgParamsVO;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.StaticConfig;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.base.api.dto.DictDTO;
import com.els.modules.base.api.dto.ElsTaxDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.dto.SaleAttachmentDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.modules.base.api.service.ElsTaxRpcService;
import com.els.modules.base.api.service.TemplateRpcService;
import com.els.modules.delivery.api.dto.PurchaseVoucherHeadDTO;
import com.els.modules.delivery.api.dto.PurchaseVoucherItemDTO;
import com.els.modules.delivery.api.service.PurchaseVoucherItemRpcService;
import com.els.modules.enterprise.api.dto.ElsEnterpriseInfoDTO;
import com.els.modules.enterprise.api.service.ElsEnterpriseInfoRpcService;
import com.els.modules.finance.api.enumerate.AddCostTypeEnum;
import com.els.modules.finance.api.enumerate.DeductCostTypeEnum;
import com.els.modules.finance.entity.FinanceEnterpriseOutinvoice;
import com.els.modules.finance.entity.PurchaseAddCost;
import com.els.modules.finance.entity.PurchaseDeductCost;
import com.els.modules.finance.entity.SaleAddCost;
import com.els.modules.finance.entity.SaleDeductCost;
import com.els.modules.finance.service.FinanceEnterpriseOutinvoiceService;
import com.els.modules.finance.service.PurchaseAddCostService;
import com.els.modules.finance.service.PurchaseDeductCostService;
import com.els.modules.finance.service.SaleAddCostService;
import com.els.modules.finance.service.SaleDeductCostService;
import com.els.modules.finance.service.SalePaymentApplyItemService;
import com.els.modules.material.api.dto.PurchaseMaterialHeadDTO;
import com.els.modules.reconciliation.entity.PurchaseFinanceTaxCode;
import com.els.modules.reconciliation.entity.PurchaseInvoice;
import com.els.modules.reconciliation.entity.PurchasePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.entity.PurchaseRecAcceptReturn;
import com.els.modules.reconciliation.entity.PurchaseRecAdditionalCharges;
import com.els.modules.reconciliation.entity.PurchaseRecCharge;
import com.els.modules.reconciliation.entity.PurchaseReconciliation;
import com.els.modules.reconciliation.entity.SaleInvoice;
import com.els.modules.reconciliation.entity.SalePrePaymentWriteOffReconciliation;
import com.els.modules.reconciliation.entity.SaleRecAcceptReturn;
import com.els.modules.reconciliation.entity.SaleRecAdditionalCharges;
import com.els.modules.reconciliation.entity.SaleRecCharge;
import com.els.modules.reconciliation.entity.SaleReconciliation;
import com.els.modules.reconciliation.enumerate.CategoryEnum;
import com.els.modules.reconciliation.enumerate.InvoiceConfirmStatusEnum;
import com.els.modules.reconciliation.enumerate.InvoiceStatusEnum;
import com.els.modules.reconciliation.enumerate.OperationEnum;
import com.els.modules.reconciliation.enumerate.ReconcilationItemTypeEmun;
import com.els.modules.reconciliation.enumerate.ReconciliationBillStatusEnum;
import com.els.modules.reconciliation.enumerate.ReconciliationStatusEmun;
import com.els.modules.reconciliation.enumerate.SaleStatusEmun;
import com.els.modules.reconciliation.enumerate.third.NuonuoTaxFlagEnum;
import com.els.modules.reconciliation.mapper.PurchaseInvoiceMapper;
import com.els.modules.reconciliation.mapper.PurchasePrePaymentWriteOffReconciliationMapper;
import com.els.modules.reconciliation.mapper.PurchaseRecAcceptReturnMapper;
import com.els.modules.reconciliation.mapper.PurchaseRecAdditionalChargesMapper;
import com.els.modules.reconciliation.mapper.PurchaseRecChargeMapper;
import com.els.modules.reconciliation.mapper.PurchaseReconciliationMapper;
import com.els.modules.reconciliation.mapper.SaleInvoiceMapper;
import com.els.modules.reconciliation.mapper.SaleReconciliationMapper;
import com.els.modules.reconciliation.rpc.PurchaseVoucherHeadLocalRpcService;
import com.els.modules.reconciliation.service.ElsPurchaseStatisticsWriteOffService;
import com.els.modules.reconciliation.service.PurchaseFinanceTaxCodeService;
import com.els.modules.reconciliation.service.PurchaseRecAdditionalChargesService;
import com.els.modules.reconciliation.service.PurchaseRecChargeService;
import com.els.modules.reconciliation.service.SaleInvoiceService;
import com.els.modules.reconciliation.service.SalePrePaymentWriteOffReconciliationService;
import com.els.modules.reconciliation.service.SaleRecAcceptReturnService;
import com.els.modules.reconciliation.service.SaleRecAdditionalChargesService;
import com.els.modules.reconciliation.service.SaleRecChargeService;
import com.els.modules.reconciliation.service.SaleReconciliationService;
import com.els.modules.reconciliation.vo.InvoiceDetailVO;
import com.els.modules.reconciliation.vo.ReconciliationVO;
import com.els.modules.reconciliation.vo.SaleReconciliationVO;
import com.els.rpc.service.InvokeAccountRpcService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SaleReconciliationServiceImpl
extends BaseServiceImpl<SaleReconciliationMapper, SaleReconciliation>
implements SaleReconciliationService {
    private static final Logger log = LoggerFactory.getLogger(SaleReconciliationServiceImpl.class);
    @Resource
    private SaleReconciliationMapper saleReconciliationMapper;
    @Resource
    private SaleRecAcceptReturnService saleRecAcceptReturnService;
    @Resource
    private SaleRecAdditionalChargesService saleRecAdditionalChargesService;
    @Resource
    private SaleRecChargeService saleRecChargeService;
    @Resource
    private SaleInvoiceMapper saleInvoiceMapper;
    @Resource
    private PurchaseReconciliationMapper purchaseReconciliationMapper;
    @Resource
    private PurchaseInvoiceMapper purchaseInvoiceMapper;
    @Resource
    private TemplateRpcService templateHeadService;
    @Resource
    private ElsEnterpriseInfoRpcService elsEnterpriseInfoRpcService;
    @Resource
    private PurchaseVoucherItemRpcService purchaseVoucherItemRpcService;
    @Autowired
    private SaleAddCostService saleAddCostService;
    @Autowired
    private PurchaseAddCostService purchaseAddCostService;
    @Autowired
    private SaleDeductCostService saleDeductCostService;
    @Autowired
    private PurchaseDeductCostService purchaseDeductCostService;
    @Resource
    private PurchaseRecAcceptReturnMapper purchaseRecAcceptReturnMapper;
    @Resource
    private PurchaseRecAdditionalChargesMapper purchaseRecAdditionalChargesMapper;
    @Resource
    private PurchaseRecChargeMapper purchaseRecChargeMapper;
    @Resource
    private PurchasePrePaymentWriteOffReconciliationMapper purchasePrePaymentWriteOffReconciliationMapper;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;
    @Resource
    private ElsTaxRpcService elsTaxRpcService;
    @Resource
    private PurchaseVoucherHeadLocalRpcService purchaseVoucherHeadLocalRpcService;
    @Resource
    private PurchaseRecAdditionalChargesService purchaseRecAdditionalChargesService;
    @Resource
    private PurchaseRecChargeService purchaseRecChargeService;
    @Autowired
    private SalePrePaymentWriteOffReconciliationService salePrePaymentWriteOffReconciliationService;
    @Autowired
    private ElsPurchaseStatisticsWriteOffService elsPurchaseStatisticsWriteOffService;
    @Autowired
    private SalePaymentApplyItemService salePaymentApplyItemService;
    @Autowired
    private SaleInvoiceService saleInvoiceService;
    @Autowired
    private FinanceEnterpriseOutinvoiceService financeEnterpriseOutinvoiceService;
    @Autowired
    private PurchaseFinanceTaxCodeService purchaseFinanceTaxCodeService;
    @Autowired
    private StaticConfig staticConfig;

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveMain(SaleReconciliation saleReconciliation, SaleReconciliationVO vo) {
        List<SaleRecAcceptReturn> saleRecAcceptReturnList = vo.getRecAcceptReturnList();
        this.buildReconciliation(saleReconciliation);
        this.saleReconciliationMapper.insert((Object)saleReconciliation);
        this.handleDocumentInfo(saleRecAcceptReturnList, saleReconciliation);
        this.insertData(saleReconciliation, vo);
        this.invokeBaseRpcService.addStatusLog(saleReconciliation.getRelationId(), ReconciliationStatusEmun.NEW.getValue(), "saleReconciliation", "inster");
        if (CollectionUtils.isEmpty(saleRecAcceptReturnList)) {
            return;
        }
        this.generateReconciliation(saleReconciliation, vo);
        this.insertPrePaymentWriteOff(saleReconciliation, vo.getPrePaymentWriteOffList());
    }

    private void insertPrePaymentWriteOff(SaleReconciliation saleReconciliation, List<SalePrePaymentWriteOffReconciliation> prePaymentWriteOffList) {
        if (CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            return;
        }
        int itemNumber = 1;
        for (SalePrePaymentWriteOffReconciliation prePaymentWriteOff : prePaymentWriteOffList) {
            prePaymentWriteOff.setHeadId(saleReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)prePaymentWriteOff, (BaseEntity)saleReconciliation);
            prePaymentWriteOff.setId(null);
            prePaymentWriteOff.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            prePaymentWriteOff.setItemNumber(String.valueOf(itemNumber));
            prePaymentWriteOff.setBusAccount(saleReconciliation.getToElsAccount());
            prePaymentWriteOff.setToElsAccount(saleReconciliation.getToElsAccount());
        }
        if (!CollectionUtils.isEmpty(prePaymentWriteOffList)) {
            this.salePrePaymentWriteOffReconciliationService.saveBatch(prePaymentWriteOffList, 2000);
        }
    }

    private void buildReconciliation(SaleReconciliation saleReconciliation) {
        String reconciliationNumber = this.invokeBaseRpcService.getNextCode("saleReconciliation", (Object)saleReconciliation, saleReconciliation.getBusAccount());
        saleReconciliation.setReconciliationNumber(reconciliationNumber);
        saleReconciliation.setBusAccount(saleReconciliation.getToElsAccount());
        TemplateHeadDTO templateHead = this.templateHeadService.getById(saleReconciliation.getTemplateNumber());
        if (templateHead != null) {
            saleReconciliation.setTemplateName(templateHead.getTemplateName());
            saleReconciliation.setTemplateNumber(templateHead.getTemplateNumber());
            saleReconciliation.setTemplateVersion(String.valueOf(templateHead.getTemplateVersion()));
            saleReconciliation.setTemplateAccount(templateHead.getElsAccount());
        }
        saleReconciliation.setCreateAccount(TenantContext.getTenant());
        saleReconciliation.setSaleRecAffirmStatus(SaleStatusEmun.NEW.getValue());
        saleReconciliation.setSaleRecSendStatus("0");
        saleReconciliation.setInvoiced("0");
        saleReconciliation.setStatus(ReconciliationBillStatusEnum.NEW.getValue());
        saleReconciliation.setCancellation("0");
        ElsEnterpriseInfoDTO enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(TenantContext.getTenant());
        if (enterpriseInfo != null) {
            saleReconciliation.setSupplierName(enterpriseInfo.getName());
        }
        if ((enterpriseInfo = this.elsEnterpriseInfoRpcService.getByElsAccount(saleReconciliation.getToElsAccount())) != null) {
            saleReconciliation.setPurchaseName(enterpriseInfo.getName());
        }
        saleReconciliation.setRelationId(IdWorker.getIdStr());
        this.handlePaymentExpireDate(saleReconciliation);
    }

    private void handlePaymentExpireDate(SaleReconciliation saleReconciliation) {
        if (StringUtils.isEmpty((CharSequence)saleReconciliation.getPayCycle()) || saleReconciliation.getPaymentBenchmarkDate() == null) {
            return;
        }
        Integer payCycle = Integer.valueOf(saleReconciliation.getPayCycle());
        if (payCycle > 0) {
            DateTime paymentExpireDate = DateUtil.offsetDay((Date)saleReconciliation.getPaymentBenchmarkDate(), (int)payCycle);
            saleReconciliation.setPaymentExpiredate((Date)paymentExpireDate);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> updateMain(SaleReconciliation saleReconciliation, SaleReconciliationVO vo) {
        this.checkRecAcceptReturn(saleReconciliation, vo.getRecAcceptReturnList());
        this.checkRecAdditionalCharges(saleReconciliation, vo.getRecAdditionalChargesList());
        this.checkRecCharge(saleReconciliation, vo.getRecChargeList());
        List<SaleRecAcceptReturn> saleRecAcceptReturnList = vo.getRecAcceptReturnList();
        List<SaleRecAdditionalCharges> saleRecAdditionalChargesList = vo.getRecAdditionalChargesList();
        List<SaleRecCharge> saleRecChargeList = vo.getRecChargeList();
        List<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffList = vo.getPrePaymentWriteOffList();
        this.handlePaymentExpireDate(saleReconciliation);
        if (CollectionUtils.isEmpty(saleRecAdditionalChargesList)) {
            this.cancelAdditionalCharges(saleReconciliation.getId(), null);
            this.saleRecAdditionalChargesService.deleteByMainId(saleReconciliation.getId());
        }
        if (CollectionUtils.isEmpty(saleRecChargeList)) {
            this.cancelCharges(saleReconciliation.getId(), null);
            this.saleRecChargeService.deleteByMainId(saleReconciliation.getId());
        }
        if (CollectionUtils.isEmpty(salePrePaymentWriteOffList)) {
            this.salePrePaymentWriteOffReconciliationService.deleteByMainId(saleReconciliation.getId());
        }
        if (CollectionUtils.isEmpty(saleRecAcceptReturnList)) {
            this.cancelAcceptReturns(saleReconciliation.getId(), null);
            this.saleRecAcceptReturnService.deleteByMainId(saleReconciliation.getId());
            this.calculateMoney(saleReconciliation, vo);
            this.checkSettlementAmount(saleReconciliation);
            this.saleReconciliationMapper.updateById((Object)saleReconciliation);
            return Result.ok((String)I18nUtil.translate((String)"i18n_alert_savaSuccess", (String)"\u4fdd\u5b58\u6210\u529f"));
        }
        ArrayList<String> acceptReturnIds = new ArrayList<String>();
        BigDecimal amount = new BigDecimal(0);
        for (SaleRecAcceptReturn purchaseRecAcceptReturn : saleRecAcceptReturnList) {
            acceptReturnIds.add(purchaseRecAcceptReturn.getBusinessId());
            if (purchaseRecAcceptReturn.getDirectionBorrowing().equals("+")) {
                amount = amount.add(purchaseRecAcceptReturn.getTotalAmount());
            }
            if (!purchaseRecAcceptReturn.getDirectionBorrowing().equals("-")) continue;
            amount = amount.subtract(purchaseRecAcceptReturn.getTotalAmount());
        }
        this.cancelAcceptReturns(saleReconciliation.getId(), acceptReturnIds);
        List<String> addCostIds = saleRecAdditionalChargesList.stream().map(SaleRecAdditionalCharges::getBusinessId).collect(Collectors.toList());
        this.cancelAdditionalCharges(saleReconciliation.getId(), addCostIds);
        List<String> deductCostIds = saleRecChargeList.stream().map(SaleRecCharge::getBusinessId).collect(Collectors.toList());
        this.cancelCharges(saleReconciliation.getId(), deductCostIds);
        this.handleDocumentInfo(saleRecAcceptReturnList, saleReconciliation);
        this.saleReconciliationMapper.updateById((Object)saleReconciliation);
        this.generateReconciliation(saleReconciliation, vo);
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_savaSuccess", (String)"\u4fdd\u5b58\u6210\u529f"));
    }

    private void checkRecAcceptReturn(SaleReconciliation saleReconciliation, List<SaleRecAcceptReturn> recAcceptReturnList) {
        if (CollectionUtil.isEmpty(recAcceptReturnList)) {
            return;
        }
        Set voucherNumbers = recAcceptReturnList.stream().map(SaleRecAcceptReturn::getVoucherNumber).collect(Collectors.toSet());
        List purchaseVoucherItems = this.purchaseVoucherItemRpcService.checkVoucher(voucherNumbers, saleReconciliation.getToElsAccount(), saleReconciliation.getElsAccount());
        if (CollectionUtil.isEmpty((Collection)purchaseVoucherItems)) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (PurchaseVoucherItemDTO purchaseVoucherItem : purchaseVoucherItems) {
            map.put(purchaseVoucherItem.getVoucherNumber(), purchaseVoucherItem.getReconciliationNumber());
        }
        Set reconciliationNumber = purchaseVoucherItems.stream().filter(item -> !StringUtils.isEmpty((CharSequence)item.getReconciliationNumber())).map(PurchaseVoucherItemDTO::getReconciliationNumber).collect(Collectors.toSet());
        reconciliationNumber.remove(saleReconciliation.getReconciliationNumber());
        if (CollectionUtil.isEmpty(reconciliationNumber)) {
            return;
        }
        for (int i = 0; i < recAcceptReturnList.size(); ++i) {
            boolean flag;
            SaleRecAcceptReturn recAcceptReturn = recAcceptReturnList.get(i);
            String number = (String)map.get(recAcceptReturn.getVoucherNumber());
            boolean bl = flag = !StringUtils.isEmpty((CharSequence)number) && !StringUtils.isEmpty((CharSequence)saleReconciliation.getReconciliationNumber()) && !saleReconciliation.getReconciliationNumber().equals(number);
            if (!flag) continue;
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6536\u9000\u8d27\u660e\u7ec6 \u5e8f\u53f7${0} \u5df2\u88ab\u5176\u4ed6\u5bf9\u8d26\u5355: ${1} \u5bf9\u8d26\uff0c\u8bf7\u5220\u9664", (String[])new String[]{i + 1 + "", number}));
        }
    }

    private void checkRecAdditionalCharges(SaleReconciliation saleReconciliation, List<SaleRecAdditionalCharges> recAdditionalChargesList) {
        if (CollectionUtil.isEmpty(recAdditionalChargesList)) {
            return;
        }
        Set<String> voucherNumbers = recAdditionalChargesList.stream().map(SaleRecAdditionalCharges::getVoucherNumber).collect(Collectors.toSet());
        List<SaleAddCost> saleAddCosts = this.saleAddCostService.checkHasReconciliation(voucherNumbers);
        if (CollectionUtil.isEmpty(saleAddCosts)) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (SaleAddCost saleAddCost : saleAddCosts) {
            map.put(saleAddCost.getCostNumber(), saleAddCost.getReconciliationNumber());
        }
        Set reconciliationNumber = saleAddCosts.stream().filter(item -> !StringUtils.isEmpty((CharSequence)item.getReconciliationNumber())).map(SaleAddCost::getReconciliationNumber).collect(Collectors.toSet());
        reconciliationNumber.remove(saleReconciliation.getReconciliationNumber());
        if (CollectionUtil.isEmpty(reconciliationNumber)) {
            return;
        }
        for (int i = 0; i < recAdditionalChargesList.size(); ++i) {
            boolean flag;
            SaleRecAdditionalCharges saleRecAdditionalCharges = recAdditionalChargesList.get(i);
            String number = (String)map.get(saleRecAdditionalCharges.getVoucherNumber());
            boolean bl = flag = !StringUtils.isEmpty((CharSequence)number) && !StringUtils.isEmpty((CharSequence)saleReconciliation.getReconciliationNumber()) && !saleReconciliation.getReconciliationNumber().equals(number);
            if (!flag) continue;
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u9644\u52a0\u8d39\u7528 \u5e8f\u53f7${0} \u5df2\u88ab\u5176\u4ed6\u5bf9\u8d26\u5355: ${1} \u5bf9\u8d26\uff0c\u8bf7\u5220\u9664", (String[])new String[]{i + 1 + "", number}));
        }
    }

    private void checkRecCharge(SaleReconciliation saleReconciliation, List<SaleRecCharge> recChargeList) {
        if (CollectionUtil.isEmpty(recChargeList)) {
            return;
        }
        Set<String> voucherNumbers = recChargeList.stream().map(SaleRecCharge::getVoucherNumber).collect(Collectors.toSet());
        List<SaleDeductCost> saleDeductCosts = this.saleDeductCostService.checkHasReconciliation(voucherNumbers);
        if (CollectionUtil.isEmpty(saleDeductCosts)) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (SaleDeductCost saleDeductCost : saleDeductCosts) {
            map.put(saleDeductCost.getDeductNumber(), saleDeductCost.getReconciliationNumber());
        }
        Set reconciliationNumber = saleDeductCosts.stream().filter(item -> !StringUtils.isEmpty((CharSequence)item.getReconciliationNumber())).map(SaleDeductCost::getReconciliationNumber).collect(Collectors.toSet());
        reconciliationNumber.remove(saleReconciliation.getReconciliationNumber());
        if (CollectionUtil.isEmpty(reconciliationNumber)) {
            return;
        }
        for (int i = 0; i < recChargeList.size(); ++i) {
            boolean flag;
            SaleRecCharge saleRecCharge = recChargeList.get(i);
            String number = (String)map.get(saleRecCharge.getVoucherNumber());
            boolean bl = flag = !StringUtils.isEmpty((CharSequence)number) && !StringUtils.isEmpty((CharSequence)saleReconciliation.getReconciliationNumber()) && !saleReconciliation.getReconciliationNumber().equals(number);
            if (!flag) continue;
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u6263\u6b3e\u660e\u7ec6 \u5e8f\u53f7${0} \u5df2\u88ab\u5176\u4ed6\u5bf9\u8d26\u5355: ${1} \u5bf9\u8d26\uff0c\u8bf7\u5220\u9664", (String[])new String[]{i + 1 + "", number}));
        }
    }

    private void checkSettlementAmount(SaleReconciliation saleReconciliation) {
        if (!"1".equals(saleReconciliation.getSaveForZero()) && BigDecimal.ZERO.compareTo(saleReconciliation.getClosingAmount()) == 0) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_dBHfEU0xiTcIIet_be49e2d6", (String)"\u5e94\u4ed8\u91d1\u989d\u7b49\u4e8e0\uff0c\u4e0d\u5141\u8bb8\u521b\u5efa\u5bf9\u8d26\u5355"));
        }
    }

    private void checkData(List<SaleRecAcceptReturn> saleRecAcceptReturnList) {
        for (SaleRecAcceptReturn item : saleRecAcceptReturnList) {
            if (StringUtils.isEmpty((CharSequence)item.getTaxCode())) {
                throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IetbLKmWlWYWSUiWWWWWWfoLV_4ecddce1", (String)"\u5bf9\u8d26\u5355\u751f\u6210\u5931\u8d25,\u6536(\u9000)\u8d27\u51ed\u8bc1[${0}]\u7a0e\u7801\u4e3a\u7a7a", (String[])new String[]{item.getVoucherNumber()}));
            }
            if (!StringUtils.isEmpty((CharSequence)item.getCurrency())) continue;
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_IetbLKmWlWYWSUiWWWWWWlqLV_417f87b8", (String)"\u5bf9\u8d26\u5355\u751f\u6210\u5931\u8d25,\u6536(\u9000)\u8d27\u51ed\u8bc1[${0}]\u5e01\u522b\u4e3a\u7a7a", (String[])new String[]{item.getVoucherNumber()}));
        }
    }

    private void handleDocumentInfo(List<SaleRecAcceptReturn> saleRecAcceptReturnList, SaleReconciliation saleReconciliation) {
        HashSet<String> voucherItemIds = new HashSet<String>();
        if (CollectionUtils.isEmpty(saleRecAcceptReturnList)) {
            return;
        }
        for (SaleRecAcceptReturn saleRecAcceptReturn : saleRecAcceptReturnList) {
            if (StringUtils.isEmpty((CharSequence)saleRecAcceptReturn.getBusinessId())) continue;
            voucherItemIds.add(saleRecAcceptReturn.getBusinessId());
        }
        List purchaseVoucherItemDTOSList = this.purchaseVoucherItemRpcService.selectVoucherItemListByIds(new ArrayList(voucherItemIds));
        if (CollectionUtils.isEmpty((Collection)purchaseVoucherItemDTOSList)) {
            return;
        }
        Set voucherHeadIds = purchaseVoucherItemDTOSList.stream().map(PurchaseVoucherItemDTO::getHeadId).collect(Collectors.toSet());
        List<PurchaseVoucherHeadDTO> purchaseVoucherHeadDTOList = this.purchaseVoucherHeadLocalRpcService.listByIds(new ArrayList<String>(voucherHeadIds));
        if (CollectionUtils.isEmpty(purchaseVoucherHeadDTOList)) {
            return;
        }
        HashSet<String> documentIds = new HashSet<String>();
        HashSet<String> parentDocumentIds = new HashSet<String>();
        for (PurchaseVoucherHeadDTO dto : purchaseVoucherHeadDTOList) {
            String documentId = dto.getDocumentId();
            this.handleIds(documentIds, documentId);
            parentDocumentIds.add(dto.getId());
        }
        String documentIdsStr = StringUtils.join(documentIds, (String)",");
        String parentDocumentIdsStr = StringUtils.join(parentDocumentIds, (String)",");
        saleReconciliation.setDocumentId(documentIdsStr);
        saleReconciliation.setDocumentParentId(parentDocumentIdsStr);
        HashMap<String, PurchaseVoucherItemDTO> map = new HashMap<String, PurchaseVoucherItemDTO>();
        for (PurchaseVoucherItemDTO purchaseVoucherItemDTO : purchaseVoucherItemDTOSList) {
            map.put(purchaseVoucherItemDTO.getVoucherNumber(), purchaseVoucherItemDTO);
        }
        for (SaleRecAcceptReturn saleRecAcceptReturn : saleRecAcceptReturnList) {
            PurchaseVoucherItemDTO purchaseVoucherItemDTO;
            if (StringUtils.isEmpty((CharSequence)saleRecAcceptReturn.getVoucherNumber()) || (purchaseVoucherItemDTO = (PurchaseVoucherItemDTO)map.get(saleRecAcceptReturn.getVoucherNumber())) == null) continue;
            saleRecAcceptReturn.setDocumentId(purchaseVoucherItemDTO.getDocumentId());
            saleRecAcceptReturn.setDocumentParentId(purchaseVoucherItemDTO.getId());
        }
    }

    private void handleIds(Set<String> documentIds, String documentId) {
        if (StringUtils.isEmpty((CharSequence)documentId)) {
            return;
        }
        if (documentId.contains(",")) {
            List<String> documentLists = Arrays.asList(documentId.split(","));
            documentIds.addAll(documentLists);
        } else {
            documentIds.add(documentId);
        }
    }

    public void generateReconciliation(SaleReconciliation reconciliation, SaleReconciliationVO vo) {
        List<SaleRecAcceptReturn> acceptReturns = vo.getRecAcceptReturnList();
        List<SaleRecAdditionalCharges> additionalCharges = vo.getRecAdditionalChargesList();
        List<SaleRecCharge> charges = vo.getRecChargeList();
        List<SalePrePaymentWriteOffReconciliation> writeOffList = vo.getPrePaymentWriteOffList();
        this.checkData(acceptReturns);
        Set taxCodeSet = acceptReturns.stream().map(SaleRecAcceptReturn::getTaxCode).collect(Collectors.toSet());
        Set currencySet = acceptReturns.stream().map(SaleRecAcceptReturn::getCurrency).collect(Collectors.toSet());
        boolean flag = false;
        for (String currency : currencySet) {
            boolean writeOffFlag = false;
            for (String taxCode : taxCodeSet) {
                reconciliation.setTaxCode(taxCode);
                reconciliation.setCurrency(currency);
                this.setTaxRate(reconciliation, taxCode);
                ArrayList<SaleRecAcceptReturn> recAcceptReturns = new ArrayList<SaleRecAcceptReturn>();
                ArrayList<SaleRecAdditionalCharges> recAdditionalCharges = new ArrayList<SaleRecAdditionalCharges>();
                ArrayList<SaleRecCharge> recCharges = new ArrayList<SaleRecCharge>();
                ArrayList<SalePrePaymentWriteOffReconciliation> writeOffs = new ArrayList<SalePrePaymentWriteOffReconciliation>();
                BigDecimal amount = new BigDecimal(0);
                for (SaleRecAcceptReturn acceptReturn : acceptReturns) {
                    if (!taxCode.equals(acceptReturn.getTaxCode()) || !currency.equals(acceptReturn.getCurrency())) continue;
                    recAcceptReturns.add(acceptReturn);
                    if (acceptReturn.getDirectionBorrowing().equals("+")) {
                        amount = amount.add(acceptReturn.getTotalAmount());
                    }
                    if (!acceptReturn.getDirectionBorrowing().equals("-")) continue;
                    amount = amount.subtract(acceptReturn.getTotalAmount());
                }
                if (CollectionUtils.isEmpty(recAcceptReturns)) continue;
                if (!CollectionUtils.isEmpty(additionalCharges)) {
                    for (SaleRecAdditionalCharges purchaseRecAdditionalCharges : additionalCharges) {
                        if (!taxCode.equals(purchaseRecAdditionalCharges.getTaxCode()) || !currency.equals(purchaseRecAdditionalCharges.getCurrency())) continue;
                        recAdditionalCharges.add(purchaseRecAdditionalCharges);
                    }
                }
                if (!CollectionUtils.isEmpty(charges)) {
                    for (SaleRecCharge charge : charges) {
                        if (!taxCode.equals(charge.getTaxCode()) || !currency.equals(charge.getCurrency())) continue;
                        recCharges.add(charge);
                    }
                }
                if (!CollectionUtils.isEmpty(writeOffList)) {
                    for (SalePrePaymentWriteOffReconciliation writeOff : writeOffList) {
                        if (!currency.equals(writeOff.getCurrency())) continue;
                        writeOffs.add(writeOff);
                    }
                }
                if (!CollectionUtils.isEmpty(writeOffs) && !writeOffFlag) {
                    writeOffFlag = true;
                }
                if (flag) {
                    SaleReconciliation saleReconciliation = new SaleReconciliation();
                    BeanUtils.copyProperties((Object)((Object)reconciliation), (Object)((Object)saleReconciliation));
                    saleReconciliation.setId(null);
                    saleReconciliation.setRelationId(null);
                    String reconciliationNumber = this.invokeBaseRpcService.getNextCode("saleReconciliation", (Object)saleReconciliation, saleReconciliation.getBusAccount());
                    saleReconciliation.setReconciliationNumber(reconciliationNumber);
                    SaleReconciliationVO targetVo = new SaleReconciliationVO(recAcceptReturns, recAdditionalCharges, recCharges, writeOffs);
                    this.calculateMoney(saleReconciliation, targetVo);
                    this.checkSettlementAmount(saleReconciliation);
                    this.saleReconciliationMapper.insert((Object)saleReconciliation);
                    this.insertData(saleReconciliation, targetVo);
                    continue;
                }
                SaleReconciliationVO targetVo = new SaleReconciliationVO(recAcceptReturns, recAdditionalCharges, recCharges, writeOffs);
                this.calculateMoney(reconciliation, targetVo);
                this.checkSettlementAmount(reconciliation);
                this.saleReconciliationMapper.updateById((Object)reconciliation);
                this.insertData(reconciliation, targetVo);
                flag = true;
            }
        }
    }

    private void setTaxRate(SaleReconciliation reconciliation, String taxCode) {
        if (reconciliation.getTaxRate() == null) {
            return;
        }
        List taxs = this.elsTaxRpcService.findList(reconciliation.getElsAccount(), taxCode);
        if (CollectionUtils.isEmpty((Collection)taxs)) {
            return;
        }
        Optional taxOptional = taxs.stream().findFirst();
        if (taxOptional.isPresent()) {
            ElsTaxDTO elsTaxDTO = (ElsTaxDTO)taxOptional.get();
            reconciliation.setTaxRate(elsTaxDTO.getTaxRate());
        }
    }

    public void calculateMoney(SaleReconciliation reconciliation, SaleReconciliationVO vo) {
        List<SaleRecAcceptReturn> acceptReturns = vo.getRecAcceptReturnList();
        List<SaleRecAdditionalCharges> additionalCharges = vo.getRecAdditionalChargesList();
        List<SaleRecCharge> charges = vo.getRecChargeList();
        List<SalePrePaymentWriteOffReconciliation> prePaymentWriteOffList = vo.getPrePaymentWriteOffList();
        BigDecimal deliveryIncludeTaxAmount = new BigDecimal(0);
        if (!CollectionUtil.isEmpty(acceptReturns)) {
            for (Object recAcceptReturn : acceptReturns) {
                if (recAcceptReturn.getDirectionBorrowing().equals("+")) {
                    deliveryIncludeTaxAmount = deliveryIncludeTaxAmount.add(recAcceptReturn.getTotalAmount());
                }
                if (!recAcceptReturn.getDirectionBorrowing().equals("-")) continue;
                deliveryIncludeTaxAmount = deliveryIncludeTaxAmount.subtract(recAcceptReturn.getTotalAmount());
            }
        }
        reconciliation.setDeliveryIncludeTaxAmount(deliveryIncludeTaxAmount);
        BigDecimal additionalChangesAmount = new BigDecimal(0);
        if (!CollectionUtil.isEmpty(additionalCharges)) {
            for (SaleRecAdditionalCharges recAdditionalCharges : additionalCharges) {
                additionalChangesAmount = additionalChangesAmount.add(recAdditionalCharges.getTotalAmount());
            }
        }
        reconciliation.setAdditionalChangesAmount(additionalChangesAmount);
        BigDecimal chargeTotalAmount = new BigDecimal(0);
        BigDecimal chargeAmount = new BigDecimal(0);
        BigDecimal buckleTicketsAmount = new BigDecimal(0);
        if (!CollectionUtil.isEmpty(charges)) {
            for (SaleRecCharge recCharge : charges) {
                chargeTotalAmount = chargeTotalAmount.add(recCharge.getTotalAmount());
                if (DeductCostTypeEnum.ACCOUNT_DEDUCTION.getValue().equals(recCharge.getDeductionType())) {
                    chargeAmount = chargeAmount.add(recCharge.getTotalAmount());
                }
                if (!DeductCostTypeEnum.TICKET_DEDUCTION.getValue().equals(recCharge.getDeductionType())) continue;
                buckleTicketsAmount = buckleTicketsAmount.add(recCharge.getTotalAmount());
            }
        }
        reconciliation.setChargeTotalAmount(chargeTotalAmount);
        reconciliation.setChargeAmount(chargeAmount);
        reconciliation.setBuckleTicketsAmount(buckleTicketsAmount);
        BigDecimal shouldInvoiceAmount = deliveryIncludeTaxAmount.add(additionalChangesAmount).subtract(buckleTicketsAmount);
        reconciliation.setShouldInvoiceAmount(shouldInvoiceAmount);
        BigDecimal closingAmount = shouldInvoiceAmount.subtract(chargeAmount);
        reconciliation.setClosingAmount(closingAmount);
        BigDecimal writtenOffAmount = BigDecimal.ZERO;
        if (!CollectionUtil.isEmpty(prePaymentWriteOffList)) {
            writtenOffAmount = prePaymentWriteOffList.parallelStream().filter(item -> item.getThisWriteOffAmount() != null).map(SalePrePaymentWriteOffReconciliation::getThisWriteOffAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            reconciliation.setWrittenOffAmount(writtenOffAmount);
        }
        BigDecimal settlementAmount = closingAmount.subtract(writtenOffAmount);
        reconciliation.setSettlementAmount(settlementAmount);
        reconciliation.setRemainingUnPaidAmount(settlementAmount);
    }

    private void insertData(SaleReconciliation saleReconciliation, SaleReconciliationVO vo) {
        this.deleteDetail(saleReconciliation.getId());
        this.insertAcceptReturns(saleReconciliation, vo.getRecAcceptReturnList());
        this.insertAddCost(saleReconciliation, vo.getRecAdditionalChargesList());
        this.insertDeductCost(saleReconciliation, vo.getRecChargeList());
        this.insertPrePaymentWriteOff(saleReconciliation, vo.getPrePaymentWriteOffList());
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delMain(String id) {
        this.cancelAcceptReturns(id, null);
        this.cancelAdditionalCharges(id, null);
        this.cancelCharges(id, null);
        this.deleteDetail(id);
        this.saleReconciliationMapper.deleteById((Serializable)((Object)id));
    }

    private void cancelCharges(String id, List<String> existIds) {
        List<SaleRecCharge> charges = this.saleRecChargeService.selectByMainId(id);
        if (CollectionUtils.isEmpty(charges)) {
            return;
        }
        ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
        ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
        for (SaleRecCharge charge : charges) {
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(charge.getBusinessId())) continue;
            SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)charge.getBusinessId())));
            saleDeductCost.setDeductStatus("0");
            saleDeductCost.setReconciliationNumber(null);
            saleDeductCosts.add(saleDeductCost);
            PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)saleDeductCost.getRelationId())));
            deductCost.setDeductStatus("0");
            deductCost.setReconciliationNumber(null);
            deductCosts.add(deductCost);
        }
        if (!deductCosts.isEmpty()) {
            this.purchaseDeductCostService.updateBatchById(deductCosts);
        }
        if (!saleDeductCosts.isEmpty()) {
            this.saleDeductCostService.updateBatchById(saleDeductCosts);
        }
    }

    private void cancelAdditionalCharges(String id, List<String> existIds) {
        List<SaleRecAdditionalCharges> additionalCharges = this.saleRecAdditionalChargesService.selectByMainId(id);
        if (CollectionUtils.isEmpty(additionalCharges)) {
            return;
        }
        ArrayList<PurchaseAddCost> addCosts = new ArrayList<PurchaseAddCost>();
        ArrayList<SaleAddCost> saleAddCosts = new ArrayList<SaleAddCost>();
        for (SaleRecAdditionalCharges recAdditionalCharges : additionalCharges) {
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(recAdditionalCharges.getBusinessId())) continue;
            SaleAddCost saleAddCost = (SaleAddCost)((Object)this.saleAddCostService.getById((Serializable)((Object)recAdditionalCharges.getBusinessId())));
            saleAddCost.setReconciliationNumber(null);
            saleAddCost.setCostStatus("0");
            saleAddCosts.add(saleAddCost);
            PurchaseAddCost addCost = (PurchaseAddCost)((Object)this.purchaseAddCostService.getById((Serializable)((Object)saleAddCost.getRelationId())));
            addCost.setCostStatus("0");
            addCost.setReconciliationNumber(null);
            addCosts.add(addCost);
        }
        if (!addCosts.isEmpty()) {
            this.purchaseAddCostService.updateBatchById(addCosts);
        }
        if (!saleAddCosts.isEmpty()) {
            this.saleAddCostService.updateBatchById(saleAddCosts);
        }
    }

    private void cancelAcceptReturns(String id, List<String> existIds) {
        List<SaleRecAcceptReturn> acceptReturns = this.saleRecAcceptReturnService.selectByMainId(id);
        if (CollectionUtils.isEmpty(acceptReturns)) {
            return;
        }
        ArrayList<PurchaseVoucherItemDTO> voucherItems = new ArrayList<PurchaseVoucherItemDTO>();
        for (SaleRecAcceptReturn acceptReturn : acceptReturns) {
            if (!CollectionUtils.isEmpty(existIds) && existIds.contains(acceptReturn.getBusinessId())) continue;
            PurchaseVoucherItemDTO voucherItem = this.purchaseVoucherItemRpcService.getById(acceptReturn.getBusinessId());
            voucherItem.setReconciliation("0");
            voucherItem.setReconciliationNumber(null);
            voucherItems.add(voucherItem);
        }
        if (!voucherItems.isEmpty()) {
            this.purchaseVoucherItemRpcService.updatePurchaseVoucherItemListById(voucherItems);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void delBatchMain(List<String> idList) {
        for (String id : idList) {
            this.deleteDetail(id);
            this.saleReconciliationMapper.deleteById((Serializable)((Object)id));
        }
    }

    private void deleteDetail(String id) {
        this.saleRecAcceptReturnService.deleteByMainId(id);
        this.saleRecAdditionalChargesService.deleteByMainId(id);
        this.saleRecChargeService.deleteByMainId(id);
        this.salePrePaymentWriteOffReconciliationService.deleteByMainId(id);
        this.saleInvoiceMapper.deleteByMainId(id);
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void confirmOrRefused(SaleReconciliation saleReconciliation, String operation) {
        String opt = null;
        if ("confirm".equals(operation)) {
            saleReconciliation.setReconciliationStatus(ReconciliationStatusEmun.COMFIRMED.getValue());
            opt = "confirm";
            BigDecimal closingAmount = saleReconciliation.getClosingAmount();
            if (closingAmount != null && closingAmount.compareTo(BigDecimal.ZERO) > 0) {
                saleReconciliation.setStatus(ReconciliationBillStatusEnum.UNINVOICE.getValue());
            } else if (closingAmount != null && closingAmount.compareTo(BigDecimal.ZERO) <= 0) {
                saleReconciliation.setStatus(ReconciliationBillStatusEnum.NOINVOICE.getValue());
            }
        } else if ("refused".equals(operation)) {
            saleReconciliation.setReconciliationStatus(ReconciliationStatusEmun.REFUSED.getValue());
            saleReconciliation.setStatus(ReconciliationBillStatusEnum.SALE_REFUSED.getValue());
            opt = "refund";
            this.elsPurchaseStatisticsWriteOffService.cancelReleaseAmountBySale(saleReconciliation.getRelationId(), saleReconciliation.getToElsAccount(), saleReconciliation.getElsAccount());
        }
        this.updateById((Object)saleReconciliation);
        this.invokeBaseRpcService.addStatusLog(saleReconciliation.getRelationId(), saleReconciliation.getReconciliationStatus(), "reconciliation", opt);
        PurchaseReconciliation purchaseReconciliation = (PurchaseReconciliation)((Object)this.purchaseReconciliationMapper.selectById((Serializable)((Object)saleReconciliation.getRelationId())));
        if (purchaseReconciliation != null) {
            purchaseReconciliation.setReconciliationStatus(saleReconciliation.getReconciliationStatus());
            purchaseReconciliation.setSaleRemark(saleReconciliation.getSaleRemark());
            purchaseReconciliation.setRelationId(saleReconciliation.getId());
            purchaseReconciliation.setStatus(saleReconciliation.getStatus());
            purchaseReconciliation.setRejectReason(saleReconciliation.getRejectReason());
            this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
        }
        if (OperationEnum.CONFIRM.getValue().equals(operation)) {
            this.handleDocument(purchaseReconciliation);
        }
        this.handleMessage(saleReconciliation, opt, purchaseReconciliation);
    }

    private void handleMessage(SaleReconciliation saleReconciliation, String opt, PurchaseReconciliation purchaseReconciliation) {
        String serviceAddress = (String)this.staticConfig.getConfig().get("service.address");
        saleReconciliation.setFbk18(serviceAddress + "/srm/reconciliation/sale/SaleReconciliation?id=" + saleReconciliation.getId() + "&open=true&toInvoice=true");
        if (!StringUtils.isEmpty((CharSequence)opt) && purchaseReconciliation != null) {
            super.sendMessage(saleReconciliation.getBusAccount(), "reconciliation", opt, saleReconciliation.getId(), "reconciliationBusDataServiceImpl", Arrays.asList(saleReconciliation.getToElsAccount()));
            super.sendMessage(saleReconciliation.getBusAccount(), "saleReconciliation", opt, saleReconciliation.getId(), "reconciliationBusDataServiceImpl", Arrays.asList(saleReconciliation.getElsAccount()));
        }
    }

    private void handleDocument(PurchaseReconciliation purchaseReconciliation) {
        String headId = purchaseReconciliation.getRelationId();
        Set<String> voucherItemIds = this.listVourcherItemIdsFromSaleRecAcceptReturn(headId);
        List purchaseVoucherItemDTOSList = this.purchaseVoucherItemRpcService.selectVoucherItemListByIds(new ArrayList<String>(voucherItemIds));
        if (!CollectionUtils.isEmpty((Collection)purchaseVoucherItemDTOSList)) {
            Set<String> voucherHeadIds = purchaseVoucherItemDTOSList.stream().map(PurchaseVoucherItemDTO::getHeadId).collect(Collectors.toSet());
            this.handlePurchaseReconciliationDocumentInfo(purchaseReconciliation, voucherHeadIds);
        }
        this.handlePurchaseRecAdditionalChargesListDocumentInfo(purchaseReconciliation);
        this.handlePurchaseRecChargeListDocumentInfo(purchaseReconciliation);
    }

    private void handlePurchaseReconciliationDocumentInfo(PurchaseReconciliation purchaseReconciliation, Set<String> voucherHeadIds) {
        List<PurchaseVoucherHeadDTO> purchaseVoucherHeadDTOList = this.purchaseVoucherHeadLocalRpcService.listByIds(new ArrayList<String>(voucherHeadIds));
        if (CollectionUtils.isEmpty(purchaseVoucherHeadDTOList)) {
            return;
        }
        for (PurchaseVoucherHeadDTO dto : purchaseVoucherHeadDTOList) {
            String documentIdz = dto.getDocumentId();
            if (StringUtils.isEmpty((CharSequence)documentIdz)) continue;
            if (documentIdz.contains(",")) {
                List<String> documentIds = Arrays.asList(documentIdz.split(","));
                for (String documentId : documentIds) {
                    this.invokeBaseRpcService.updateIntegratedDocumentMain("reconciliationId", documentId, dto.getId(), purchaseReconciliation.getId());
                }
                continue;
            }
            this.invokeBaseRpcService.updateIntegratedDocumentMain("reconciliationId", documentIdz, dto.getId(), purchaseReconciliation.getId());
        }
    }

    private Set<String> listVourcherItemIdsFromSaleRecAcceptReturn(String headId) {
        HashSet<String> voucherItemIds = new HashSet<String>();
        List<SaleRecAcceptReturn> saleRecAcceptReturnList = this.saleRecAcceptReturnService.selectByMainId(headId);
        if (CollectionUtils.isEmpty(saleRecAcceptReturnList)) {
            return voucherItemIds;
        }
        for (SaleRecAcceptReturn saleRecAcceptReturn : saleRecAcceptReturnList) {
            if (StringUtils.isEmpty((CharSequence)saleRecAcceptReturn.getBusinessId())) continue;
            voucherItemIds.add(saleRecAcceptReturn.getBusinessId());
        }
        return voucherItemIds;
    }

    private void handlePurchaseRecAdditionalChargesListDocumentInfo(PurchaseReconciliation purchaseReconciliation) {
        List<PurchaseRecAdditionalCharges> purchaseRecAdditionalChargesList = this.purchaseRecAdditionalChargesService.selectByMainId(purchaseReconciliation.getId());
        if (CollectionUtils.isEmpty(purchaseRecAdditionalChargesList)) {
            return;
        }
        for (PurchaseRecAdditionalCharges purchaseRecAdditionalCharges : purchaseRecAdditionalChargesList) {
            if (StringUtils.isEmpty((CharSequence)purchaseRecAdditionalCharges.getDocumentId())) continue;
            this.invokeBaseRpcService.updateIntegratedDocumentMain("reconciliationId", purchaseRecAdditionalCharges.getDocumentId(), purchaseRecAdditionalCharges.getBusinessId(), purchaseReconciliation.getId());
        }
    }

    private void handlePurchaseRecChargeListDocumentInfo(PurchaseReconciliation purchaseReconciliation) {
        List<PurchaseRecCharge> purchaseRecChargeList = this.purchaseRecChargeService.selectByMainId(purchaseReconciliation.getId());
        if (CollectionUtils.isEmpty(purchaseRecChargeList)) {
            return;
        }
        for (PurchaseRecCharge purchaseRecCharge : purchaseRecChargeList) {
            if (StringUtils.isEmpty((CharSequence)purchaseRecCharge.getDocumentId())) continue;
            this.invokeBaseRpcService.updateIntegratedDocumentMain("reconciliationId", purchaseRecCharge.getDocumentId(), purchaseRecCharge.getBusinessId(), purchaseReconciliation.getId());
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void saveInvoice(SaleReconciliation saleReconciliation, List<SaleInvoice> saleInvoiceList, String operation) {
        this.saleInvoiceMapper.deleteByMainId(saleReconciliation.getId());
        BigDecimal invoiceTotalAmount = BigDecimal.ZERO;
        BigDecimal notIncludeTaxAmount = BigDecimal.ZERO;
        BigDecimal taxAmount = BigDecimal.ZERO;
        for (SaleInvoice saleInvoice : saleInvoiceList) {
            saleInvoice.setId(null);
            if (StringUtils.isBlank((CharSequence)saleInvoice.getInvoiceNumber())) {
                saleInvoice.setInvoiceNumber(this.invokeBaseRpcService.getNextCode("invoiceNumber", (Object)saleInvoice, saleReconciliation.getToElsAccount()));
            }
            if ("save".equals(operation)) {
                if (!InvoiceStatusEnum.RENTURNED.getValue().equals(saleInvoice.getStatus())) {
                    saleInvoice.setStatus(InvoiceStatusEnum.NEW.getValue());
                }
            } else if ("send".equals(operation)) {
                saleInvoice.setStatus(InvoiceStatusEnum.UNCONFIRMED.getValue());
            }
            if (saleInvoice.getNotIncludeTaxAmount() == null) {
                BigDecimal tax = saleInvoice.getTaxRate().divide(new BigDecimal(100)).add(BigDecimal.ONE);
                saleInvoice.setNotIncludeTaxAmount(saleInvoice.getIncludeTaxAmount().divide(tax, 6, 5));
            }
            if (saleInvoice.getTaxAmount() == null) {
                saleInvoice.setTaxAmount(saleInvoice.getIncludeTaxAmount().subtract(saleInvoice.getNotIncludeTaxAmount()));
            }
            saleInvoice.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            saleInvoice.setBusAccount(saleReconciliation.getToElsAccount());
            saleInvoice.setToElsAccount(saleReconciliation.getToElsAccount());
            saleInvoice.setHeadId(saleReconciliation.getId());
            String documentId = saleReconciliation.getDocumentId();
            if (!StringUtils.isEmpty((CharSequence)documentId)) {
                saleInvoice.setDocumentId(documentId);
            }
            saleInvoice.setDocumentParentId(saleReconciliation.getRelationId());
            SysUtil.setSysParam((BaseEntity)saleInvoice, (BaseEntity)saleReconciliation);
            invoiceTotalAmount = invoiceTotalAmount.add(saleInvoice.getIncludeTaxAmount());
            notIncludeTaxAmount = notIncludeTaxAmount.add(saleInvoice.getNotIncludeTaxAmount());
            taxAmount = taxAmount.add(saleInvoice.getTaxAmount());
        }
        saleReconciliation.setTotalInvoiceAmount(invoiceTotalAmount);
        saleReconciliation.setNotIncludeTaxAmount(notIncludeTaxAmount);
        saleReconciliation.setTaxAmount(taxAmount);
        this.saleReconciliationMapper.updateById((Object)saleReconciliation);
        PurchaseReconciliation purchaseReconciliation = (PurchaseReconciliation)((Object)this.purchaseReconciliationMapper.selectById((Serializable)((Object)saleReconciliation.getRelationId())));
        if (purchaseReconciliation != null) {
            purchaseReconciliation.setTotalInvoiceAmount(invoiceTotalAmount);
            purchaseReconciliation.setNotIncludeTaxAmount(notIncludeTaxAmount);
            purchaseReconciliation.setTaxAmount(taxAmount);
            this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
        }
        if (!saleInvoiceList.isEmpty()) {
            this.saleInvoiceMapper.insertBatchSomeColumn(saleInvoiceList);
        }
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public void sendInvoice(SaleReconciliation saleReconciliation, List<SaleInvoice> saleInvoiceList) {
        saleReconciliation.setInvoiced("1");
        saleReconciliation.setPurchaseInvoiceAffirmStatus(InvoiceConfirmStatusEnum.UNCONFIRMED.getValue());
        saleReconciliation.setStatus(ReconciliationBillStatusEnum.INVOICE_UNCONFIRMED.getValue());
        this.saveInvoice(saleReconciliation, saleInvoiceList, "send");
        PurchaseReconciliation purchaseReconciliation = (PurchaseReconciliation)((Object)this.purchaseReconciliationMapper.selectById((Serializable)((Object)saleReconciliation.getRelationId())));
        if (purchaseReconciliation != null) {
            purchaseReconciliation.setInvoiced("1");
            purchaseReconciliation.setRelationId(saleReconciliation.getId());
            purchaseReconciliation.setPurchaseInvoiceAffirmStatus(InvoiceConfirmStatusEnum.UNCONFIRMED.getValue());
            purchaseReconciliation.setTotalInvoiceAmount(saleReconciliation.getTotalInvoiceAmount());
            purchaseReconciliation.setSaleRemark(saleReconciliation.getSaleRemark());
            purchaseReconciliation.setStatus(saleReconciliation.getStatus());
            this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
            this.purchaseInvoiceMapper.deleteByMainId(purchaseReconciliation.getId());
            List saleAttachments = this.invokeBaseRpcService.selectSaleAttachmentByMainId(saleReconciliation.getId());
            Map<String, String> map = this.handlePurchaseAttachmentDetail(purchaseReconciliation, saleAttachments);
            ArrayList<PurchaseInvoice> purchaseInvoices = new ArrayList<PurchaseInvoice>();
            for (SaleInvoice saleInvoice : saleInvoiceList) {
                String saleImageId;
                String purchaseImageId;
                String[] image;
                PurchaseInvoice purchaseInvoice = new PurchaseInvoice();
                BeanUtils.copyProperties((Object)((Object)saleInvoice), (Object)((Object)purchaseInvoice));
                purchaseInvoice.setRelationId(saleInvoice.getId());
                purchaseInvoice.setElsAccount(purchaseReconciliation.getElsAccount());
                purchaseInvoice.setToElsAccount(purchaseReconciliation.getToElsAccount());
                purchaseInvoice.setHeadId(purchaseReconciliation.getId());
                purchaseInvoice.setId(null);
                purchaseInvoices.add(purchaseInvoice);
                String invoiceImg = purchaseInvoice.getInvoiceImg();
                if (StringUtils.isEmpty((CharSequence)invoiceImg) || (image = invoiceImg.split("-")).length <= 0 || StringUtils.isEmpty((CharSequence)(purchaseImageId = map.get(saleImageId = image[0])))) continue;
                String purchaseInvoiceImg = purchaseImageId + "-" + image[1];
                purchaseInvoice.setInvoiceImg(purchaseInvoiceImg);
            }
            this.sendMessage(saleReconciliation, purchaseReconciliation, "invoice");
            this.purchaseInvoiceMapper.insertBatchSomeColumn(purchaseInvoices);
        }
    }

    private void sendMessage(SaleReconciliation saleReconciliation, PurchaseReconciliation purchaseReconciliation, String invoice) {
        super.sendMessage(saleReconciliation.getBusAccount(), invoice, "publish", purchaseReconciliation.getId(), "reconciliationBusDataServiceImpl", Arrays.asList(saleReconciliation.getToElsAccount()));
    }

    @Override
    public SaleReconciliationVO extractReconciliation(SaleReconciliationVO vo) {
        PurchaseVoucherItemDTO purchaseVoucherItemDTO = this.buildPurchaseVoucherItem(vo);
        List voucherItems = this.purchaseVoucherItemRpcService.selectReconciliationVoucher(purchaseVoucherItemDTO);
        if (!CollectionUtils.isEmpty((Collection)voucherItems)) {
            List<SaleRecAcceptReturn> acceptReturns = this.getBySaleVoucherItem(voucherItems);
            vo.setRecAcceptReturnList(acceptReturns);
        } else {
            vo.setRecAcceptReturnList(null);
        }
        ReconciliationVO targetVo = new ReconciliationVO();
        BeanUtils.copyProperties((Object)((Object)vo), (Object)targetVo);
        List<SaleRecCharge> charges = this.saleDeductCostService.getBySaleDeductCost(targetVo);
        vo.setRecChargeList(charges);
        List<SaleRecAdditionalCharges> additionalCharges = this.saleAddCostService.getBySaleAddCost(vo);
        vo.setRecAdditionalChargesList(additionalCharges);
        List<SalePrePaymentWriteOffReconciliation> prePaymentWriteOff = this.salePaymentApplyItemService.getSalePrePaymentWriteOffReconciliations(targetVo);
        vo.setPrePaymentWriteOffList(prePaymentWriteOff);
        return vo;
    }

    private PurchaseVoucherItemDTO buildPurchaseVoucherItem(SaleReconciliationVO vo) {
        PurchaseVoucherItemDTO purchaseVoucherItemDTO = new PurchaseVoucherItemDTO();
        purchaseVoucherItemDTO.setElsAccount(vo.getToElsAccount());
        purchaseVoucherItemDTO.setToElsAccount(vo.getElsAccount());
        purchaseVoucherItemDTO.setCompany(vo.getCompany());
        purchaseVoucherItemDTO.setBeginDate(vo.getBeginDate());
        purchaseVoucherItemDTO.setEndDate(vo.getEndDate());
        purchaseVoucherItemDTO.setVoucherStatus("0");
        if (StringUtils.isNotBlank((CharSequence)vo.getTaxCode())) {
            purchaseVoucherItemDTO.setTaxCode(vo.getTaxCode());
        }
        if (StringUtils.isNotBlank((CharSequence)vo.getCurrency())) {
            purchaseVoucherItemDTO.setCurrency(vo.getCurrency());
        }
        return purchaseVoucherItemDTO;
    }

    public List<SaleRecAcceptReturn> getBySaleVoucherItem(List<PurchaseVoucherItemDTO> voucherItems) {
        ArrayList<SaleRecAcceptReturn> acceptReturns = new ArrayList<SaleRecAcceptReturn>();
        for (PurchaseVoucherItemDTO purchaseVoucherItem : voucherItems) {
            SaleRecAcceptReturn acceptReturn = new SaleRecAcceptReturn();
            BeanUtils.copyProperties((Object)purchaseVoucherItem, (Object)((Object)acceptReturn));
            acceptReturn.setItemType(ReconcilationItemTypeEmun.RECEIVING_REFUND.getValue());
            acceptReturn.setVoucherItemNumber(purchaseVoucherItem.getItemNumber());
            acceptReturn.setVoucherTime(purchaseVoucherItem.getVoucherDate());
            acceptReturn.setMobileType(purchaseVoucherItem.getMoveType());
            acceptReturn.setDirectionBorrowing(purchaseVoucherItem.getLoanDirection());
            acceptReturn.setPurchaseFactory(purchaseVoucherItem.getFactory());
            acceptReturn.setInventoryAddress(purchaseVoucherItem.getStorageLocation());
            acceptReturn.setInventoryAddressDesc(purchaseVoucherItem.getStorageLocationName());
            acceptReturn.setUnitQuantity(purchaseVoucherItem.getQuantityUnit());
            acceptReturn.setPrice(purchaseVoucherItem.getPrice());
            acceptReturn.setNoTaxUnitPrice(purchaseVoucherItem.getNetPrice());
            acceptReturn.setTaxRate(StringUtils.isNotBlank((CharSequence)purchaseVoucherItem.getTaxRate()) ? new BigDecimal(purchaseVoucherItem.getTaxRate()) : null);
            if (purchaseVoucherItem.getPrice() != null && purchaseVoucherItem.getVoucherQuantity() != null) {
                acceptReturn.setTotalAmount(purchaseVoucherItem.getPrice().multiply(purchaseVoucherItem.getVoucherQuantity()));
            }
            if (purchaseVoucherItem.getNetPrice() != null && purchaseVoucherItem.getVoucherQuantity() != null) {
                acceptReturn.setTotalNonTaxAmount(purchaseVoucherItem.getNetPrice().multiply(purchaseVoucherItem.getVoucherQuantity()));
            }
            acceptReturn.setBusinessId(purchaseVoucherItem.getId());
            acceptReturn.setId(null);
            acceptReturns.add(acceptReturn);
        }
        return acceptReturns;
    }

    @Override
    @SrmTransaction(rollbackFor={RuntimeException.class})
    public Result<?> publish(SaleReconciliation saleReconciliation, SaleReconciliationVO vo) {
        SaleReconciliation dbReconciliation = (SaleReconciliation)((Object)this.getById((Serializable)((Object)saleReconciliation.getId())));
        if (dbReconciliation != null && ReconciliationBillStatusEnum.PURCHASDE_UNCONFIRMED.getValue().equals(dbReconciliation.getStatus())) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_APzExqhxVXVtFzE_64c0f41", (String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u53d1\u5e03\uff0c\u8bf7\u5237\u65b0\u5355\u636e\u72b6\u6001"));
        }
        this.saleRecAcceptReturnService.checkAcceptReturn(vo);
        this.saleRecAdditionalChargesService.checkAdditional(vo);
        this.saleRecChargeService.checkReconcilationedCharge(vo);
        ReconciliationVO targetVo = new ReconciliationVO();
        BeanUtils.copyProperties((Object)((Object)saleReconciliation), (Object)targetVo);
        this.elsPurchaseStatisticsWriteOffService.writeOffAmountOccupyBySale(targetVo, vo.getPrePaymentWriteOffList());
        boolean flag = false;
        if (SaleStatusEmun.REFUSED.getValue().equals(saleReconciliation.getSaleRecAffirmStatus()) && StringUtils.isNotBlank((CharSequence)saleReconciliation.getRelationId())) {
            flag = true;
        }
        saleReconciliation.setSaleRecAffirmStatus(SaleStatusEmun.UNCONFIRMED.getValue());
        saleReconciliation.setSaleRecSendStatus("1");
        saleReconciliation.setStatus(ReconciliationBillStatusEnum.PURCHASDE_UNCONFIRMED.getValue());
        this.updateMain(saleReconciliation, vo);
        this.invokeBaseRpcService.addStatusLog(saleReconciliation.getRelationId(), saleReconciliation.getReconciliationStatus(), "saleReconciliation", "publish");
        String id = saleReconciliation.getRelationId();
        PurchaseReconciliation purchaseReconciliation = new PurchaseReconciliation();
        BeanUtils.copyProperties((Object)((Object)saleReconciliation), (Object)((Object)purchaseReconciliation));
        purchaseReconciliation.setElsAccount(saleReconciliation.getToElsAccount());
        purchaseReconciliation.setToElsAccount(saleReconciliation.getElsAccount());
        purchaseReconciliation.setRelationId(saleReconciliation.getId());
        purchaseReconciliation.setStatus(saleReconciliation.getStatus());
        if (flag) {
            purchaseReconciliation.setId(id);
            purchaseReconciliation.setReconciliationStatus(saleReconciliation.getReconciliationStatus());
            purchaseReconciliation.setStatus(saleReconciliation.getStatus());
            this.purchaseReconciliationMapper.updateById((Object)purchaseReconciliation);
            this.handleDetail(purchaseReconciliation, vo);
        } else {
            purchaseReconciliation.setId(id);
            this.purchaseReconciliationMapper.insert((Object)purchaseReconciliation);
            this.handleDetail(purchaseReconciliation, vo);
            saleReconciliation.setRelationId(purchaseReconciliation.getId());
        }
        this.sendMessage(saleReconciliation, purchaseReconciliation, "saleReconciliation");
        return Result.ok((String)I18nUtil.translate((String)"i18n_alert_hxLRW_c95760c0", (String)"\u53d1\u5e03\u6210\u529f\uff01"));
    }

    @Override
    public void emailConfirmOrRefuesd(String id, String operation) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(BaseEntity::getId, (Object)id);
        SaleReconciliation saleReconciliation = (SaleReconciliation)((Object)this.getOne((Wrapper)lambdaQueryWrapper));
        if (saleReconciliation != null) {
            this.confirmOrRefused(saleReconciliation, operation);
        }
    }

    private MsgParamsVO parameterAssemble(SaleReconciliation reconciliation) {
        MsgParamsVO msgParamsVO = new MsgParamsVO();
        ArrayList<ElsSubAccountDTO> accountList = new ArrayList<ElsSubAccountDTO>();
        HashMap<String, ArrayList<ElsSubAccountDTO>> receiverMap = new HashMap<String, ArrayList<ElsSubAccountDTO>>();
        ElsSubAccountDTO subAccount = this.invokeAccountRpcService.getAccount(reconciliation.getToElsAccount(), reconciliation.getPurchasePrincipal().split("_")[0]);
        accountList.add(subAccount);
        receiverMap.put(reconciliation.getToElsAccount(), accountList);
        msgParamsVO.setReceiverMap(receiverMap);
        Map paramMap = (Map)JSON.parse((String)JSONObject.toJSON((Object)((Object)reconciliation)).toString());
        paramMap.put("userName", subAccount.getRealname());
        msgParamsVO.setParams((Object)paramMap);
        return msgParamsVO;
    }

    private void handleDetail(PurchaseReconciliation purchaseReconciliation, SaleReconciliationVO vo) {
        List<SaleRecAcceptReturn> saleRecAcceptReturnList = vo.getRecAcceptReturnList();
        List<SaleRecAdditionalCharges> saleRecAdditionalChargesList = vo.getRecAdditionalChargesList();
        List<SaleRecCharge> saleRecChargeList = vo.getRecChargeList();
        List<SaleAttachmentDTO> attachments = vo.getAttachments();
        List<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffList = vo.getPrePaymentWriteOffList();
        this.purchaseRecAcceptReturnMapper.deleteByMainId(purchaseReconciliation.getId());
        this.purchaseRecChargeMapper.deleteByMainId(purchaseReconciliation.getId());
        this.purchaseRecAdditionalChargesMapper.deleteByMainId(purchaseReconciliation.getId());
        this.purchasePrePaymentWriteOffReconciliationMapper.deleteByMainId(purchaseReconciliation.getId());
        this.invokeBaseRpcService.deletePurchaseAttachmentByMainId(purchaseReconciliation.getId());
        this.handlePurchaseRecAcceptReturnDetail(purchaseReconciliation, saleRecAcceptReturnList);
        this.handlePurchaseRecChargeDetail(purchaseReconciliation, saleRecChargeList);
        this.handlePurchaseRecAdditionalChargeDetail(purchaseReconciliation, saleRecAdditionalChargesList);
        this.handlePurchaseRecPrePaymentWriteOffDetail(purchaseReconciliation, salePrePaymentWriteOffList);
        this.handlePurchaseAttachmentDetail(purchaseReconciliation, attachments);
    }

    private Map<String, String> handlePurchaseAttachmentDetail(PurchaseReconciliation purchaseReconciliation, List<SaleAttachmentDTO> attachments) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (CollectionUtils.isEmpty(attachments)) {
            return map;
        }
        ArrayList<PurchaseAttachmentDTO> purchaseAttachments = new ArrayList<PurchaseAttachmentDTO>();
        for (SaleAttachmentDTO saleAttachment : attachments) {
            saleAttachment.setSendStatus("1");
            PurchaseAttachmentDTO purchaseAttachment = new PurchaseAttachmentDTO();
            BeanUtils.copyProperties((Object)saleAttachment, (Object)purchaseAttachment);
            purchaseAttachment.setId(IdWorker.getIdStr());
            saleAttachment.setRelationId(purchaseAttachment.getId());
            purchaseAttachment.setElsAccount(purchaseReconciliation.getElsAccount());
            purchaseAttachment.setHeadId(purchaseReconciliation.getId());
            purchaseAttachment.setRelationId(saleAttachment.getId());
            purchaseAttachment.setDeleted(CommonConstant.DEL_FLAG_0);
            purchaseAttachments.add(purchaseAttachment);
            this.invokeBaseRpcService.updateSaleAttachment(saleAttachment);
            map.put(saleAttachment.getId(), purchaseAttachment.getId());
        }
        this.invokeBaseRpcService.insertPurchaseAttachmentBatchSomeColumn(purchaseAttachments);
        return map;
    }

    private void handlePurchaseRecAdditionalChargeDetail(PurchaseReconciliation purchaseReconciliation, List<SaleRecAdditionalCharges> saleRecAdditionalChargesList) {
        if (CollectionUtils.isEmpty(saleRecAdditionalChargesList)) {
            return;
        }
        ArrayList<PurchaseRecAdditionalCharges> purchaseRecAdditionalCharges = new ArrayList<PurchaseRecAdditionalCharges>();
        for (SaleRecAdditionalCharges saleRecAdditionalCharges : saleRecAdditionalChargesList) {
            PurchaseRecAdditionalCharges purchaseRecAdditionalCharge = new PurchaseRecAdditionalCharges();
            BeanUtils.copyProperties((Object)((Object)saleRecAdditionalCharges), (Object)((Object)purchaseRecAdditionalCharge));
            purchaseRecAdditionalCharge.setId(null);
            purchaseRecAdditionalCharge.setElsAccount(purchaseReconciliation.getElsAccount());
            purchaseRecAdditionalCharge.setToElsAccount(purchaseReconciliation.getToElsAccount());
            purchaseRecAdditionalCharge.setHeadId(purchaseReconciliation.getId());
            purchaseRecAdditionalCharge.setRelationId(saleRecAdditionalCharges.getId());
            purchaseRecAdditionalCharges.add(purchaseRecAdditionalCharge);
        }
        this.purchaseRecAdditionalChargesMapper.insertBatchSomeColumn(purchaseRecAdditionalCharges);
    }

    private void handlePurchaseRecChargeDetail(PurchaseReconciliation purchaseReconciliation, List<SaleRecCharge> saleRecChargeList) {
        if (CollectionUtils.isEmpty(saleRecChargeList)) {
            return;
        }
        ArrayList<PurchaseRecCharge> purchaseRecCharges = new ArrayList<PurchaseRecCharge>();
        for (SaleRecCharge saleRecCharge : saleRecChargeList) {
            PurchaseRecCharge purchaseRecCharge = new PurchaseRecCharge();
            BeanUtils.copyProperties((Object)((Object)saleRecCharge), (Object)((Object)purchaseRecCharge));
            purchaseRecCharge.setId(null);
            purchaseRecCharge.setElsAccount(purchaseReconciliation.getElsAccount());
            purchaseRecCharge.setToElsAccount(purchaseReconciliation.getToElsAccount());
            purchaseRecCharge.setHeadId(purchaseReconciliation.getId());
            purchaseRecCharge.setRelationId(saleRecCharge.getId());
            purchaseRecCharges.add(purchaseRecCharge);
        }
        this.purchaseRecChargeMapper.insertBatchSomeColumn(purchaseRecCharges);
    }

    private void handlePurchaseRecPrePaymentWriteOffDetail(PurchaseReconciliation purchaseReconciliation, List<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffList) {
        if (CollectionUtils.isEmpty(salePrePaymentWriteOffList)) {
            return;
        }
        ArrayList<PurchasePrePaymentWriteOffReconciliation> purchasePrePaymentWriteOffList = new ArrayList<PurchasePrePaymentWriteOffReconciliation>();
        for (SalePrePaymentWriteOffReconciliation prePaymentWriteOff : salePrePaymentWriteOffList) {
            PurchasePrePaymentWriteOffReconciliation writeOff = new PurchasePrePaymentWriteOffReconciliation();
            BeanUtils.copyProperties((Object)((Object)prePaymentWriteOff), (Object)((Object)writeOff));
            writeOff.setId(null);
            writeOff.setElsAccount(purchaseReconciliation.getElsAccount());
            writeOff.setToElsAccount(purchaseReconciliation.getToElsAccount());
            writeOff.setHeadId(purchaseReconciliation.getId());
            writeOff.setRelationId(prePaymentWriteOff.getId());
            purchasePrePaymentWriteOffList.add(writeOff);
        }
        this.purchasePrePaymentWriteOffReconciliationMapper.insertBatchSomeColumn(purchasePrePaymentWriteOffList);
    }

    private void handlePurchaseRecAcceptReturnDetail(PurchaseReconciliation purchaseReconciliation, List<SaleRecAcceptReturn> saleRecAcceptReturnList) {
        if (CollectionUtils.isEmpty(saleRecAcceptReturnList)) {
            return;
        }
        ArrayList<PurchaseRecAcceptReturn> purcahseRecAcceptReturns = new ArrayList<PurchaseRecAcceptReturn>();
        for (SaleRecAcceptReturn saleRecAcceptReturn : saleRecAcceptReturnList) {
            PurchaseRecAcceptReturn purchaseRecAcceptReturn = new PurchaseRecAcceptReturn();
            BeanUtils.copyProperties((Object)((Object)saleRecAcceptReturn), (Object)((Object)purchaseRecAcceptReturn));
            purchaseRecAcceptReturn.setId(null);
            purchaseRecAcceptReturn.setElsAccount(purchaseReconciliation.getElsAccount());
            purchaseRecAcceptReturn.setToElsAccount(purchaseReconciliation.getToElsAccount());
            purchaseRecAcceptReturn.setHeadId(purchaseReconciliation.getId());
            purchaseRecAcceptReturn.setRelationId(saleRecAcceptReturn.getId());
            purcahseRecAcceptReturns.add(purchaseRecAcceptReturn);
        }
        this.purchaseRecAcceptReturnMapper.insertBatchSomeColumn(purcahseRecAcceptReturns);
    }

    private void insertDeductCost(SaleReconciliation saleReconciliation, List<SaleRecCharge> saleRecChargeList) {
        if (CollectionUtils.isEmpty(saleRecChargeList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<PurchaseDeductCost> deductCosts = new ArrayList<PurchaseDeductCost>();
        ArrayList<SaleDeductCost> saleDeductCosts = new ArrayList<SaleDeductCost>();
        for (SaleRecCharge entity : saleRecChargeList) {
            entity.setHeadId(saleReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleReconciliation);
            entity.setId(null);
            entity.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            entity.setItemNumber(String.valueOf(itemNumber));
            entity.setBusAccount(saleReconciliation.getBusAccount());
            SaleDeductCost saleDeductCost = (SaleDeductCost)((Object)this.saleDeductCostService.getById((Serializable)((Object)entity.getBusinessId())));
            saleDeductCost.setDeductStatus("1");
            saleDeductCost.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            saleDeductCosts.add(saleDeductCost);
            PurchaseDeductCost deductCost = (PurchaseDeductCost)((Object)this.purchaseDeductCostService.getById((Serializable)((Object)saleDeductCost.getRelationId())));
            deductCost.setDeductStatus("1");
            deductCost.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            deductCosts.add(deductCost);
            ++itemNumber;
        }
        if (!saleRecChargeList.isEmpty()) {
            this.saleRecChargeService.saveBatch(saleRecChargeList, 2000);
        }
        if (!deductCosts.isEmpty()) {
            this.purchaseDeductCostService.updateBatchById(deductCosts);
        }
        if (!saleDeductCosts.isEmpty()) {
            this.saleDeductCostService.updateBatchById(saleDeductCosts);
        }
    }

    private void insertAddCost(SaleReconciliation saleReconciliation, List<SaleRecAdditionalCharges> saleRecAdditionalChargesList) {
        if (CollectionUtils.isEmpty(saleRecAdditionalChargesList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<PurchaseAddCost> addCosts = new ArrayList<PurchaseAddCost>();
        ArrayList<SaleAddCost> saleAddCosts = new ArrayList<SaleAddCost>();
        for (SaleRecAdditionalCharges entity : saleRecAdditionalChargesList) {
            entity.setHeadId(saleReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleReconciliation);
            entity.setId(null);
            entity.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            entity.setItemNumber(String.valueOf(itemNumber));
            entity.setBusAccount(saleReconciliation.getBusAccount());
            SaleAddCost saleAddCost = (SaleAddCost)((Object)this.saleAddCostService.getById((Serializable)((Object)entity.getBusinessId())));
            saleAddCost.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            saleAddCost.setCostStatus("1");
            saleAddCosts.add(saleAddCost);
            PurchaseAddCost addCost = (PurchaseAddCost)((Object)this.purchaseAddCostService.getById((Serializable)((Object)saleAddCost.getRelationId())));
            addCost.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            addCost.setCostStatus("1");
            addCosts.add(addCost);
            ++itemNumber;
        }
        if (!saleRecAdditionalChargesList.isEmpty()) {
            this.saleRecAdditionalChargesService.saveBatch(saleRecAdditionalChargesList, 200);
        }
        if (!addCosts.isEmpty()) {
            this.purchaseAddCostService.updateBatchById(addCosts);
        }
        if (!saleAddCosts.isEmpty()) {
            this.saleAddCostService.updateBatchById(saleAddCosts);
        }
    }

    private void insertAcceptReturns(SaleReconciliation saleReconciliation, List<SaleRecAcceptReturn> saleRecAcceptReturnList) {
        if (CollectionUtils.isEmpty(saleRecAcceptReturnList)) {
            return;
        }
        int itemNumber = 1;
        ArrayList<PurchaseVoucherItemDTO> voucherItems = new ArrayList<PurchaseVoucherItemDTO>();
        Date date = new Date();
        for (SaleRecAcceptReturn entity : saleRecAcceptReturnList) {
            entity.setHeadId(saleReconciliation.getId());
            SysUtil.setSysParam((BaseEntity)entity, (BaseEntity)saleReconciliation);
            entity.setId(null);
            entity.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            entity.setItemNumber(String.valueOf(itemNumber));
            entity.setBusAccount(saleReconciliation.getBusAccount());
            BigDecimal totalAmount = entity.getTotalAmount();
            BigDecimal totalNonTaxAmount = entity.getTotalNonTaxAmount();
            if (totalAmount != null && totalNonTaxAmount != null) {
                BigDecimal taxAmount = totalAmount.subtract(totalNonTaxAmount);
                entity.setTaxAmount(taxAmount);
            }
            PurchaseVoucherItemDTO voucherItem = this.purchaseVoucherItemRpcService.getById(entity.getBusinessId());
            voucherItem.setReconciliation("1");
            voucherItem.setReconciliationNumber(saleReconciliation.getReconciliationNumber());
            voucherItem.setPostDate(date);
            voucherItems.add(voucherItem);
            ++itemNumber;
        }
        if (!saleRecAcceptReturnList.isEmpty()) {
            this.saleRecAcceptReturnService.saveBatch(saleRecAcceptReturnList, 2000);
        }
        if (!voucherItems.isEmpty()) {
            this.purchaseVoucherItemRpcService.updatePurchaseVoucherItemListById(voucherItems);
        }
    }

    @Override
    public Result<?> billing(SaleReconciliationVO vo) {
        List<FinanceEnterpriseOutinvoice> saleOutinvoiceList = vo.getSaleOutinvoiceList();
        List<FinanceEnterpriseOutinvoice> purchaseOutinvoiceList = vo.getPurchaseOutinvoiceList();
        Optional saleOutinvoiceOption = saleOutinvoiceList.stream().findFirst();
        Optional purchaseOutinvoiceOption = purchaseOutinvoiceList.stream().findFirst();
        if (!saleOutinvoiceOption.isPresent()) {
            return Result.error((String)"\u8bf7\u586b\u5199\u9500\u552e\u5f00\u7968\u4fe1\u606f");
        }
        if (!purchaseOutinvoiceOption.isPresent()) {
            return Result.error((String)"\u8bf7\u586b\u5199\u91c7\u8d2d\u5f00\u7968\u4fe1\u606f");
        }
        FinanceEnterpriseOutinvoice saleOutinvoice = (FinanceEnterpriseOutinvoice)((Object)saleOutinvoiceOption.get());
        FinanceEnterpriseOutinvoice purchaseOutinvoice = (FinanceEnterpriseOutinvoice)((Object)purchaseOutinvoiceOption.get());
        ArrayList<InvoiceDetailVO> details = new ArrayList<InvoiceDetailVO>();
        this.billingRecAcceptReturn(vo.getRecAcceptReturnList(), details);
        List<InvoiceDetailVO> invoiceDetailList = this.saleRecChargeService.billingRecCharge(vo.getRecChargeList(), details);
        this.billingRecAdditionalCharges(vo.getRecAdditionalChargesList(), invoiceDetailList);
        SaleInvoice saleInvoice = new SaleInvoice();
        saleInvoice.setElsAccount(vo.getElsAccount());
        saleInvoice.setBusAccount(vo.getToElsAccount());
        saleInvoice.setToElsAccount(vo.getToElsAccount());
        saleInvoice.setHeadId(vo.getId());
        saleInvoice.setReconciliationNumber(vo.getReconciliationNumber());
        return this.saleInvoiceService.billing(invoiceDetailList, saleOutinvoice, purchaseOutinvoice, saleInvoice);
    }

    private void billingRecAdditionalCharges(List<SaleRecAdditionalCharges> saleRecAdditionalChargesList, List<InvoiceDetailVO> details) {
        if (CollectionUtils.isEmpty(saleRecAdditionalChargesList)) {
            return;
        }
        Set<String> costTypes = saleRecAdditionalChargesList.stream().filter(charge -> !StringUtils.isEmpty((CharSequence)charge.getCostType())).map(SaleRecAdditionalCharges::getCostType).collect(Collectors.toSet());
        String busAccount = "";
        Optional chargeOptional = saleRecAdditionalChargesList.stream().findFirst();
        if (chargeOptional.isPresent()) {
            SaleRecAdditionalCharges charges = (SaleRecAdditionalCharges)((Object)chargeOptional.get());
            busAccount = charges.getBusAccount();
        }
        List<PurchaseFinanceTaxCode> purchaseFinanceTaxCodeList = this.purchaseFinanceTaxCodeService.listFeeBySale(costTypes, busAccount, CategoryEnum.FEE.getValue());
        HashMap<String, String> map = new HashMap<String, String>();
        if (!CollectionUtils.isEmpty(purchaseFinanceTaxCodeList)) {
            for (PurchaseFinanceTaxCode financeTaxCode : purchaseFinanceTaxCodeList) {
                map.put(financeTaxCode.getGoodsAndServicesNames(), financeTaxCode.getTaxCategoryCode());
            }
        }
        for (SaleRecAdditionalCharges additionalCharges : saleRecAdditionalChargesList) {
            String categoryCode;
            BigDecimal taxRate;
            InvoiceDetailVO detail = new InvoiceDetailVO();
            if (!StringUtils.isEmpty((CharSequence)additionalCharges.getCostType())) {
                String goodsName = AddCostTypeEnum.parse((String)additionalCharges.getCostType()).getDesc();
                detail.setGoodsName(goodsName);
            }
            if ((taxRate = additionalCharges.getTaxRate()) != null) {
                detail.setTaxRate(taxRate.divide(new BigDecimal("100")) + "");
            }
            BigDecimal totalAmount = additionalCharges.getTotalAmount();
            BigDecimal totalNonTaxAmount = additionalCharges.getTotalNonTaxAmount();
            if (totalNonTaxAmount != null) {
                detail.setTaxExcludedAmount(totalNonTaxAmount + "");
                detail.setPrice(totalNonTaxAmount + "");
                if (totalAmount != null) {
                    BigDecimal taxAmount = totalAmount.subtract(totalNonTaxAmount);
                    detail.setTax(taxAmount + "");
                }
            }
            if (!StringUtils.isEmpty((CharSequence)(categoryCode = (String)map.get(additionalCharges.getCostType())))) {
                detail.setGoodsCode(categoryCode);
            }
            detail.setNum(BigDecimal.ONE + "");
            detail.setUnit("\u6b21");
            detail.setWithTaxFlag(NuonuoTaxFlagEnum.TAX_NOT_INCLUDED.getValue());
            details.add(detail);
        }
    }

    private void billingRecAcceptReturn(List<SaleRecAcceptReturn> saleRecAcceptReturnList, List<InvoiceDetailVO> details) {
        InvoiceDetailVO detail;
        if (CollectionUtils.isEmpty(saleRecAcceptReturnList)) {
            return;
        }
        HashMap<String, String> dictMap = new HashMap<String, String>();
        Optional acceptReturnOptional = saleRecAcceptReturnList.stream().findFirst();
        String busAccount = "";
        if (acceptReturnOptional.isPresent()) {
            SaleRecAcceptReturn saleRecAcceptReturn = (SaleRecAcceptReturn)((Object)acceptReturnOptional.get());
            busAccount = saleRecAcceptReturn.getBusAccount();
        }
        List dictList = this.invokeBaseRpcService.queryDictItemsByCode("unitCode", busAccount);
        for (DictDTO dict : dictList) {
            dictMap.put(dict.getValue(), dict.getText());
        }
        Set materialNumbers = saleRecAcceptReturnList.stream().map(SaleRecAcceptReturn::getMaterialNumber).collect(Collectors.toSet());
        Map<String, String> numberToCategoryCodeMap = this.purchaseFinanceTaxCodeService.handleTaxCategoryCode(new HashMap<String, PurchaseMaterialHeadDTO>(), new ArrayList<String>(materialNumbers), busAccount);
        HashMap<String, SaleRecAcceptReturn> acceptReturnMap = new HashMap<String, SaleRecAcceptReturn>();
        for (SaleRecAcceptReturn saleRecAcceptReturn : saleRecAcceptReturnList) {
            boolean flag;
            detail = new InvoiceDetailVO();
            String materialNumber = saleRecAcceptReturn.getMaterialNumber();
            BigDecimal totalAmount = saleRecAcceptReturn.getTotalAmount();
            BigDecimal taxRate = saleRecAcceptReturn.getTaxRate();
            String materialSpec = saleRecAcceptReturn.getMaterialSpec();
            BigDecimal price = saleRecAcceptReturn.getPrice();
            boolean bl = flag = !StringUtils.isEmpty((CharSequence)materialNumber) && taxRate != null && !StringUtils.isEmpty((CharSequence)materialSpec) && price != null;
            if (flag) {
                BigDecimal mapTotalNonTaxAmount;
                String key = materialNumber + "-" + taxRate + "-" + materialSpec + "-" + price;
                SaleRecAcceptReturn acceptReturn = (SaleRecAcceptReturn)((Object)acceptReturnMap.get(key));
                if (acceptReturn == null) {
                    if (!StringUtils.isEmpty((CharSequence)saleRecAcceptReturn.getDirectionBorrowing()) && "-".equals(saleRecAcceptReturn.getDirectionBorrowing()) && saleRecAcceptReturn.getVoucherQuantity() != null) {
                        BigDecimal temp = saleRecAcceptReturn.getVoucherQuantity().negate();
                        saleRecAcceptReturn.setVoucherQuantity(temp);
                    }
                    acceptReturnMap.put(key, saleRecAcceptReturn);
                    continue;
                }
                if (StringUtils.isEmpty((CharSequence)saleRecAcceptReturn.getDirectionBorrowing())) continue;
                if (saleRecAcceptReturn.getVoucherQuantity() != null) {
                    BigDecimal mapQuantity;
                    BigDecimal voucherQuantity = saleRecAcceptReturn.getVoucherQuantity();
                    BigDecimal bigDecimal = mapQuantity = acceptReturn.getVoucherQuantity() == null ? BigDecimal.ZERO : acceptReturn.getVoucherQuantity();
                    if ("+".equals(saleRecAcceptReturn.getDirectionBorrowing())) {
                        mapQuantity = mapQuantity.add(voucherQuantity);
                    } else if ("-".equals(saleRecAcceptReturn.getDirectionBorrowing())) {
                        mapQuantity = mapQuantity.subtract(voucherQuantity);
                    }
                    acceptReturn.setVoucherQuantity(mapQuantity);
                }
                if (saleRecAcceptReturn.getTaxAmount() != null) {
                    BigDecimal mapTaxAmount;
                    BigDecimal taxAmount = saleRecAcceptReturn.getTaxAmount();
                    BigDecimal bigDecimal = mapTaxAmount = acceptReturn.getTaxAmount() == null ? BigDecimal.ZERO : acceptReturn.getTaxAmount();
                    if ("+".equals(saleRecAcceptReturn.getDirectionBorrowing())) {
                        mapTaxAmount = mapTaxAmount.add(taxAmount);
                    } else if ("-".equals(saleRecAcceptReturn.getDirectionBorrowing())) {
                        mapTaxAmount = mapTaxAmount.subtract(taxAmount);
                    }
                    acceptReturn.setTaxAmount(mapTaxAmount);
                }
                if (saleRecAcceptReturn.getTotalAmount() != null) {
                    BigDecimal mapTotalAmount;
                    BigDecimal bigDecimal = mapTotalAmount = acceptReturn.getTotalAmount() == null ? BigDecimal.ZERO : acceptReturn.getTotalAmount();
                    if ("+".equals(saleRecAcceptReturn.getDirectionBorrowing())) {
                        mapTotalAmount = mapTotalAmount.add(totalAmount);
                    } else if ("-".equals(saleRecAcceptReturn.getDirectionBorrowing())) {
                        mapTotalAmount = mapTotalAmount.subtract(totalAmount);
                    }
                    acceptReturn.setTotalAmount(mapTotalAmount);
                }
                if (saleRecAcceptReturn.getTotalNonTaxAmount() == null) continue;
                BigDecimal totalNonTaxAmount = saleRecAcceptReturn.getTotalNonTaxAmount();
                BigDecimal bigDecimal = mapTotalNonTaxAmount = acceptReturn.getTotalNonTaxAmount() == null ? BigDecimal.ZERO : acceptReturn.getTotalNonTaxAmount();
                if ("+".equals(saleRecAcceptReturn.getDirectionBorrowing())) {
                    mapTotalNonTaxAmount = mapTotalNonTaxAmount.add(totalNonTaxAmount);
                } else if ("-".equals(saleRecAcceptReturn.getDirectionBorrowing())) {
                    mapTotalNonTaxAmount = mapTotalNonTaxAmount.subtract(totalNonTaxAmount);
                }
                acceptReturn.setTotalNonTaxAmount(mapTotalNonTaxAmount);
                continue;
            }
            this.handleInvoiceDetail(dictMap, numberToCategoryCodeMap, saleRecAcceptReturn, detail);
            this.handleAmountInfo(details, saleRecAcceptReturn, detail, totalAmount, taxRate);
        }
        for (SaleRecAcceptReturn saleRecAcceptReturn : acceptReturnMap.values()) {
            detail = new InvoiceDetailVO();
            this.handleInvoiceDetail(dictMap, numberToCategoryCodeMap, saleRecAcceptReturn, detail);
            this.handleAmountInfo(details, saleRecAcceptReturn, detail, saleRecAcceptReturn.getTotalAmount(), saleRecAcceptReturn.getTaxRate());
        }
    }

    private void handleAmountInfo(List<InvoiceDetailVO> details, SaleRecAcceptReturn saleRecAcceptReturn, InvoiceDetailVO detail, BigDecimal totalAmount, BigDecimal taxRate) {
        BigDecimal totalNonTaxAmount;
        BigDecimal taxAmount;
        if (taxRate != null) {
            detail.setTaxRate(taxRate.divide(new BigDecimal("100")) + "");
        }
        if ((taxAmount = saleRecAcceptReturn.getTaxAmount()) != null) {
            detail.setTax(taxAmount + "");
        }
        if ((totalNonTaxAmount = saleRecAcceptReturn.getTotalNonTaxAmount()) != null) {
            detail.setTaxExcludedAmount(totalNonTaxAmount + "");
        }
        if (totalAmount != null) {
            detail.setTaxIncludedAmount(totalAmount + "");
        }
        detail.setNum(saleRecAcceptReturn.getVoucherQuantity() + "");
        detail.setWithTaxFlag(NuonuoTaxFlagEnum.TAX_NOT_INCLUDED.getValue());
        details.add(detail);
    }

    private void handleInvoiceDetail(Map<String, String> dictMap, Map<String, String> numberToCategoryCodeMap, SaleRecAcceptReturn saleRecAcceptReturn, InvoiceDetailVO detail) {
        String categoryCode;
        PurchaseVoucherItemDTO dto = new PurchaseVoucherItemDTO();
        dto.setVoucherNumber(saleRecAcceptReturn.getVoucherNumber());
        dto.setElsAccount(saleRecAcceptReturn.getBusAccount());
        dto.setToElsAccount(saleRecAcceptReturn.getElsAccount());
        List voucherItem = this.purchaseVoucherItemRpcService.selectInvoiceVoucher(dto);
        if (CollectionUtils.isEmpty((Collection)voucherItem)) {
            return;
        }
        Optional voucherItemOptional = voucherItem.stream().findFirst();
        if (!voucherItemOptional.isPresent()) {
            return;
        }
        PurchaseVoucherItemDTO voucherItemDTO = (PurchaseVoucherItemDTO)voucherItemOptional.get();
        detail.setGoodsName(voucherItemDTO.getMaterialName());
        detail.setSpecType(voucherItemDTO.getMaterialSpec());
        detail.setPrice(voucherItemDTO.getNetPrice() + "");
        String purchaseUnit = voucherItemDTO.getPurchaseUnit();
        if (!StringUtils.isEmpty((CharSequence)purchaseUnit) && !StringUtils.isEmpty((CharSequence)dictMap.get(purchaseUnit))) {
            String union = dictMap.get(purchaseUnit);
            detail.setUnit(union);
        }
        if (!StringUtils.isEmpty((CharSequence)(categoryCode = numberToCategoryCodeMap.get(voucherItemDTO.getMaterialNumber())))) {
            detail.setGoodsCode(categoryCode);
        }
    }

    @Override
    public SaleReconciliationVO queryReconciliationItemList(SaleReconciliation saleReconciliation, String id) {
        SaleReconciliationVO saleReconciliationVO = new SaleReconciliationVO();
        LambdaQueryWrapper reconciliationLambdaQueryWrapper = new LambdaQueryWrapper();
        reconciliationLambdaQueryWrapper.eq(BaseEntity::getId, (Object)id);
        SaleReconciliation saleReconciliations = (SaleReconciliation)((Object)this.getOne((Wrapper)reconciliationLambdaQueryWrapper));
        if (saleReconciliations == null) {
            return saleReconciliationVO;
        }
        List<SaleRecAcceptReturn> saleRecAcceptReturnList = this.saleRecAcceptReturnService.selectByMainId(id);
        List<SaleRecAdditionalCharges> saleRecAdditionalChargesList = this.saleRecAdditionalChargesService.selectByMainId(id);
        List<SaleRecCharge> saleRecChargeList = this.saleRecChargeService.selectByMainId(id);
        List<SalePrePaymentWriteOffReconciliation> salePrePaymentWriteOffList = this.salePrePaymentWriteOffReconciliationService.selectByMainId(id);
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"els_account", (Collection)this.invokeBaseRpcService.getPurchaseListByElsAccount(TenantContext.getTenant()));
        queryWrapper.eq((Object)"bus_type", (Object)"purchase");
        List purchaseOutinvoiceList = this.financeEnterpriseOutinvoiceService.list((Wrapper)queryWrapper);
        queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        queryWrapper.eq((Object)"bus_type", (Object)"sale");
        List saleOutinvoiceList = this.financeEnterpriseOutinvoiceService.list((Wrapper)queryWrapper);
        saleReconciliationVO.setRecAcceptReturnList(saleRecAcceptReturnList);
        saleReconciliationVO.setRecChargeList(saleRecChargeList);
        saleReconciliationVO.setRecAdditionalChargesList(saleRecAdditionalChargesList);
        saleReconciliationVO.setPrePaymentWriteOffList(salePrePaymentWriteOffList);
        saleReconciliationVO.setPurchaseOutinvoiceList(purchaseOutinvoiceList);
        saleReconciliationVO.setSaleOutinvoiceList(saleOutinvoiceList);
        return saleReconciliationVO;
    }

    @Override
    public JSONObject getDataById(String id) {
        SaleReconciliation saleReconciliation = (SaleReconciliation)((Object)this.getById((Serializable)((Object)id)));
        SaleReconciliationVO headVO = (SaleReconciliationVO)((Object)BeanUtil.copyProperties((Object)((Object)saleReconciliation), SaleReconciliationVO.class, (String[])new String[0]));
        Result result = Result.ok((Object)((Object)headVO));
        DictAspect dictAspect = (DictAspect)SpringContextUtils.getBean((String)"dictAspect");
        dictAspect.parseDictText((Object)result);
        return (JSONObject)result.getResult();
    }

    @Override
    public void deleteByRelationIds(Set<String> ids) {
        this.saleReconciliationMapper.deleteByRelationIds(ids);
    }
}

