/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryInfo.api.enumerate;

import java.util.Calendar;
import java.util.Date;

public enum StatisticsDateType {
    D1("1d", 1),
    D7("7d", 7),
    M1("30d", 30),
    M3("90d", 90);

    private final String dicCode;
    private final GetDateTimeScopeService getDateTimeScopeService;

    private StatisticsDateType(String dicCode, int day) {
        this.dicCode = dicCode;
        this.getDateTimeScopeService = StatisticsDateType.getDateTimeScopeServiceImpl(day);
    }

    public String getDicCode() {
        return this.dicCode;
    }

    public GetDateTimeScopeService getGetDateTimeScopeService() {
        return this.getDateTimeScopeService;
    }

    public static StatisticsDateType getTypeWhitDicCode(String dicCode, StatisticsDateType defaultType) {
        StatisticsDateType[] statisticsDateTypeArray = StatisticsDateType.values();
        int n = statisticsDateTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            StatisticsDateType value = statisticsDateTypeArray[n2];
            if (value.dicCode.equals(dicCode)) {
                return value;
            }
            ++n2;
        }
        return defaultType;
    }

    private static GetDateTimeScopeService getDateTimeScopeServiceImpl(int days) {
        return () -> {
            Calendar calendar = Calendar.getInstance();
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            Date endTime = calendar.getTime();
            calendar.add(5, -1 * days);
            Date beginTime = calendar.getTime();
            return new DateTimeScope(beginTime, endTime);
        };
    }

    public static class DateTimeScope {
        private Date beginTime;
        private Date endTime;

        public DateTimeScope(Date beginTime, Date endTime) {
            this.beginTime = beginTime;
            this.endTime = endTime;
        }

        public Date getBeginTime() {
            return this.beginTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public void setBeginTime(Date beginTime) {
            this.beginTime = beginTime;
        }

        public void setEndTime(Date endTime) {
            this.endTime = endTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DateTimeScope)) {
                return false;
            }
            DateTimeScope other = (DateTimeScope)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Date this$beginTime = this.getBeginTime();
            Date other$beginTime = other.getBeginTime();
            if (this$beginTime == null ? other$beginTime != null : !((Object)this$beginTime).equals(other$beginTime)) {
                return false;
            }
            Date this$endTime = this.getEndTime();
            Date other$endTime = other.getEndTime();
            return !(this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DateTimeScope;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Date $beginTime = this.getBeginTime();
            result = result * 59 + ($beginTime == null ? 43 : ((Object)$beginTime).hashCode());
            Date $endTime = this.getEndTime();
            result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
            return result;
        }

        public String toString() {
            return "StatisticsDateType.DateTimeScope(beginTime=" + this.getBeginTime() + ", endTime=" + this.getEndTime() + ")";
        }
    }

    @FunctionalInterface
    public static interface GetDateTimeScopeService {
        public DateTimeScope getDateTimeScope();
    }
}

