/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bidding.api.service.impl;

import com.els.common.util.I18nUtil;
import com.els.modules.account.api.dto.ImUserDTO;
import com.els.modules.bidding.entity.SaleBiddingHead;
import com.els.modules.bidding.enumerate.BiddingStatusEnum;
import com.els.modules.bidding.service.SaleBiddingHeadService;
import com.els.modules.im.api.dto.ImRecordDto;
import com.els.modules.im.api.service.ImUserRecordRpcService;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service(value="saleBiddingImUserRecordServiceImpl")
public class SaleBiddingUserRecordInvokeBeanServiceImpl
implements ImUserRecordRpcService {
    @Resource
    private SaleBiddingHeadService saleBiddingHeadService;

    public List<ImUserDTO> getRecordPersonInCharge(ImRecordDto imRecordDto) {
        SaleBiddingHead dbHead = (SaleBiddingHead)this.saleBiddingHeadService.getById((Serializable)((Object)imRecordDto.getRecordId()));
        Assert.isTrue((dbHead != null ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_fail_bidding_record_id_no_found_bidding", (String)("\u62db\u6807\u5355[" + imRecordDto.getRecordId() + "]\u4e0d\u5b58\u5728"), (String[])new String[]{imRecordDto.getRecordId()}));
        Assert.isTrue((!BiddingStatusEnum.CANCEL.getValue().equals(dbHead.getBiddingStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_fail_bidding_is_invalid_bidding", (String)"\u62db\u6807\u5355\u5df2\u4f5c\u5e9f\u72b6\u6001\uff0c\u65e0\u6cd5\u6c9f\u901a"));
        Assert.isTrue((!BiddingStatusEnum.NEW.getValue().equals(dbHead.getBiddingStatus()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_fail_bidding_status_is_new_bidding", (String)"\u62db\u6807\u5355\u65b0\u5efa\u72b6\u6001\uff0c\u65e0\u6cd5\u6c9f\u901a"));
        String toElsAccount = dbHead.getToElsAccount();
        String subAccount = StringUtils.isEmpty((Object)dbHead.getPurchasePrincipal()) ? "1001" : dbHead.getPurchasePrincipal().split("_")[0];
        ImUserDTO imUserDTO = new ImUserDTO();
        imUserDTO.setElsAccount(String.valueOf(toElsAccount) + "_" + subAccount);
        return Lists.newArrayList((Object[])new ImUserDTO[]{imUserDTO});
    }
}

